#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>

#include "../FW/labImage.h"
#include "../improv_plugin.h"
#include "feat_track_plugin.h"

/*
 * From the detected features, calculate the point (in
 * the image) where the camera should be directed 
 */

void direct(Point* target)
{

  int i;

  double no_feats=0;
  double x = 0;
  double y = 0;
  
  for (i=0; i<XX*YY; i++)
    if (f[i].active == TRUE)
      no_feats++;

  for (i=0; i<XX*YY; i++)
    if (f[i].active == TRUE)
	{
	  x += f[i].x;
	  y += f[i].y;
	}
   
  target->x = (int)(x/no_feats);
  target->y = (int)(y/no_feats);

}


/*
 * Draw crosshair on image to show where target is
 */

void draw_crosshair(BYTE* image, Point *target, int col, int width, int height)
{

  int i;
  
  int x = target->x;
  int y = target->y;

  /* clamp if too close to edge */

  if (x < 5)
    x = 5;
  
  if (x >= width-5)
    x = width-6;

  if (y < 5)
    y = 5;

  if (y >= height-5)
    y = height-6;


  if (col == FALSE) /* grey image */
    {

      for (i=-3; i<=3; i++)
	{
	  image[ (y-3)*width+x+i ] = BLACK;
	  image[ (y+3)*width+x+i ] = BLACK;
	}
      
      for (i=-3; i<=3; i++)
	{
	  image[ (y+i)*width+x-3 ] = BLACK;
	  image[ (y+i)*width+x+3 ] = BLACK;
	}

      for (i=-5; i<=5; i++)
	{
	  image[ y*width+x+i  ] = WHITE;
	  image[ (y+i)*width+x] = WHITE;
	}

    }

  else /* col image */
    {

      for (i=-3; i<=3; i++)
	{
	  image[ 3*((y-3)*width+x+i) ] = BLACK;
	  image[ 3*((y+3)*width+x+i) ] = BLACK;
	  
	  image[ 3*((y-3)*width+x+i)+1 ] = BLACK;
	  image[ 3*((y+3)*width+x+i)+1 ] = BLACK;

	  image[ 3*((y-3)*width+x+i)+2 ] = BLACK;
	  image[ 3*((y+3)*width+x+i)+2 ] = BLACK;
	}

      for (i=-3; i<=3; i++)
	{
	  image[ 3*((y+i)*width+x+3) ]   = BLACK;
	  image[ 3*((y+i)*width+x-3) ]   = BLACK;
	  
	  image[ 3*((y+i)*width+x+3)+1 ] = BLACK;
	  image[ 3*((y+i)*width+x-3)+1 ] = BLACK;

	  image[ 3*((y+i)*width+x+3)+2 ] = BLACK;
	  image[ 3*((y+i)*width+x-3)+2 ] = BLACK;
	}

      for (i=-5; i<=5; i++)
	{
	  image[ 3*( (y+i)*width+x ) ]   = WHITE;
	  image[ 3*( (y+i)*width+x )+1 ] = BLACK;
	  image[ 3*( (y+i)*width+x )+2 ] = BLACK;
	  
	  image[ 3*( y*width+x+i ) ]   = WHITE;
	  image[ 3*( y*width+x+i )+1 ] = BLACK;
	  image[ 3*( y*width+x+i )+2 ] = BLACK;
	}

    }

}
	  



