/*  sample_plugin.c
 *  for Improv v5.1
 *
 *  see the included README or README.html 
 *  for instructions on what to change.
 * 
 */

#include "improv_plugin.h"
#include "sample_plugin.h"

/* CHANGEME: set this to the number of processing operations in the plugin */
#define NUMBER_OF_OPERATIONS 2

/* CHANGEME: fill out the the struct fields with the plugin details */
IP_Descriptor ipl_plugin =
{
	100,
	"Sample Plugin",                              /* plugin name */
	"Daniel Venkitachalam & Leon Koch",           /* plugin author */
	"2002",                                       /* date */
	"A sample Improv plugin using code from IPL", /* comment */
	NUMBER_OF_OPERATIONS,                         /* num. ops (set above) */
	NULL                                          /* IP_ops, filled out by
                                                       * the _init function */
};

/* Initialise the plugin.  If you require global-type variables,
 * declare a custom struct containing the variables, cast a pointer
 * to it as an IP_Handle and return it here.  This allows your
 * plugin to be re-entrant.  The IP_Handle you specify will be passed
 * to every processing function which can cast it back to the
 * relevant struct and access it's members */

IP_Handle IP_Init()
{
	IP_Op *op;
	int i = 0;

	/* Fill out the IP ops descriptions */
	ipl_plugin.Ops = (IP_Op*) calloc(NUMBER_OF_OPERATIONS, sizeof(IP_Op));

	/* CHANGEME: for each operation, provide a section 
	 * like this to fill out the operation details  */

	/* Noise function */
	op = (IP_Op*) &(ipl_plugin.Ops[i++]);
	op->Category   = (char*) strdup("General");
	op->Operation  = (char*) strdup("Noise");
	op->Index      = i;
	op->InputCount = 1;          /* the maximum number of images to pass
	                              * to this function (size of inputs)
	                              * NOTE: the application may pass less 
	                              * images than this, so check your input 
	                              * images before you start using them. */
	/* include the following for an operation with parameters */
	op->ParamCount = 1;
	op->ParamNames = (char**) calloc(1, sizeof(char *));
	op->ParamNames[0] = (char *) strdup("Noise");
	/* or include the following for no parameters */
	//op->ParamNames = NULL;
	op->resultType = NORESULT;   /* The result type return by this operation.
	                              * If the operation does return a result, you
	                              * must specify the maximum size of that result
	                              * - see improv_plugin.h for valid result types */
	//op->resultType = TEXT;
	//op->resultSize = sizeof(char)*28;
	op->process    = IPL_noise;  /* IMPORTANT: change this to your routine */
	/* end noise function */

	/* An example of an operation that uses two input pictures. */

	/*  Difference  */
	op = (IP_Op*) &(ipl_plugin.Ops[i++]);
	op->Category   = (char*) strdup("General");
	op->Operation  = (char*) strdup("Difference");
	op->Index      = i;
	op->InputCount = 2;
	op->ParamCount = 0;
	op->ParamNames = NULL;
	op->resultType = NORESULT;
	op->process    = IPL_difference;


	/* This is error checking code to make sure the number of operations
	 * specified matches the number of operations defined properly.  You
	 * can leave this as is */

	if( i != NUMBER_OF_OPERATIONS ) {
		printf("IPL_plugin.c ERROR: Mismatched number of operations:\n" \
				" (i, NUMBER_OF_OPERATIONS) = (%d, %d)\n", i, NUMBER_OF_OPERATIONS);
		exit(1);
	}

	return NULL;
}

/* boilerplate code, leave as is, returns the plugin descriptor */
const IP_Descriptor* 
IP_Descriptor_get(unsigned long Index)
{
	return &ipl_plugin;
}

/* CHANGEME: replace this function (and declaration in sample_plugin.h) with your
 * processing function.  All processing functions have the same prototype.  The
 *  args are:
 *
 *  -instance: holds global information (not used here)
 *  -in: an array of input pictures. This plugin uses only one input.
 *  -out: single output
 *  -params: an array of floating parameters. Again, only one floating parameter 
 *           is used by this plugin (noise factor), described in IP_Init
 *  -result: the allocated memory provided by the application to return an extra
 *           operation result (such as text).
 */

pluginReturnType IPL_noise(IP_Handle instance, Picture **in, Picture *out, float *params, void *result)
{
	int i,pos;
	int imageSize ;
	int numberOfPixels ;
	int width, height;

	double noise;

	BYTE *imageOut,*imageIn;

	// Just one input, dereference the first element of picture input array
	Picture *p_imageIn = *in;    

	imageIn=(BYTE *)p_imageIn->data;
	imageOut=(BYTE *)out->data;
	noise = (double) params[0];

	width=p_imageIn->width;
	height=p_imageIn->height;

	imageSize = width * height; 
	numberOfPixels = (int)(imageSize * noise);

	if(p_imageIn->format==pix_grey) {
		memcpy(imageOut, imageIn, imageSize);

		for (i = 0; i < numberOfPixels; i+=2) {
			imageOut[rand() % imageSize] = WHITE;
			imageOut[rand() % imageSize] = BLACK;
		}
		return NOERROR;
	}
	else if (p_imageIn->format==pix_bgr32) {
		memcpy(imageOut, imageIn, 4*imageSize);

		for (i = 0; i < numberOfPixels; i+=2) {
			pos = rand() % imageSize;
			imageOut[4*pos  ] = WHITE;
			imageOut[4*pos+1] = WHITE;
			imageOut[4*pos+2] = WHITE;
			pos = rand() % imageSize;
			imageOut[4*pos  ] = BLACK;
			imageOut[4*pos+1] = BLACK;         
			imageOut[4*pos+2] = BLACK;
		}
		return NOERROR;
	}
	else
		return WRONGFORMAT;
}


pluginReturnType IPL_difference(IP_Handle instance, Picture **in, Picture *out, float *params, void *result)
{
	int i;
	int delta;
	int width, height;
	BYTE *imageOut,*imageIn,*buf;
	Picture *resized;

	/* Get the first and second input pictures.
	 * Note that the input pictures should not be manipulated directly, 
	 * as the memory is referenced by other parts of the application.
	 * If required, take a copy of the image, and the manipulate that.
	 * See the code below that resizes the image for an example. */
	Picture *p_imageIn = in[0];
	Picture *p_buf = in[1];

	imageIn=(BYTE *)p_imageIn->data;
	imageOut=(BYTE *)out->data;
	
	width=p_imageIn->width;
	height=p_imageIn->height;

	/* Note that you can only assume that the first input picture and
	 * the output picture are valid. It is left to each operation to
	 * check that any other input frames it wants to use are valid. */
	if(p_buf==NULL) { return; }
	else if((buf=(BYTE *)p_buf->data)==NULL) { return; }
	else {
		/* Additionally, the pictures in p_imageInputs could possibly be
		 * of different dimensions. It is left to each operation to deal
		 * with this, as neccessary. In this case, the second image is
		 * resized to the demensions of the first (if required). The
		 * output picture, p_imageOut, will always be of the same
		 * dimensions as the first input image. */
		if((p_imageIn->width!=p_buf->width)||
		   (p_imageIn->height!=p_buf->height)) {
			resized = copyImage(p_buf);
			resizeImage(resized,p_imageIn->width,p_imageIn->height);
			buf=(BYTE *)resized->data;
		}
		if(p_imageIn->format==pix_grey) {
			for (i = 0; i < width * height; i++) {
				delta = *(buf++) - *(imageIn++);
				if (delta < 0) delta = - delta;
				imageOut[i] = (BYTE)delta;
			}
			return NOERROR;
		}
		else if (p_imageIn->format==pix_bgr32) {
			for (i = 0; i < 4*width * height; i++) {
				delta = buf[i] - imageIn[i];
				if (delta < 0) delta = - delta;
				imageOut[i] = (BYTE)delta;
			}
			return NOERROR;
		}
		else return WRONGFORMAT;
	}
}

