HELP TEXT FOR LGRAMMAR

-----------------------------------------------------------------

2D Turtle Symbols:

F  "forward with line drawing". Turtle moves in direction of its
   orientation vector (head) for a fixed distance and draws a line

f  "forward without line drawing". Turtle moves in direction of its
   orientation vector (head) for a fixed distance without drawing

+  Turtle turns left by a specified angle

-  Turtle turns right by a specified angle

[  "start branching" Push current turtle position and orientation 
   on stack

]  "terminate branching" Pop data from stack replacing current
   turtle position and orientation

|  "flip" Turn turtle about 180 degree

'  Increment color index

`  Decrement color index

-----------------------------------------------------------------

3D Turtle Symbols:

F  "forward with line drawing". Turtle moves in direction of its
   orientation vector (head) for a fixed distance and draws a line.
   Has no effect within a polygon '{ }' (see G)

f  "forward without line drawing". Turtle moves in direction of its
   orientation vector (head) for a fixed distance without drawing
   New position is recorded as a corner point within polygons '{ }'.

+  Turn turtle about axis 'up' by a specified angle

-  Turn turtle about axis 'up' by the negative of a specified angle

&  Turn turtle about axis 'left' by a specified angle 

^  Turn turtle about axis 'left' by the negative of a specified angle

\  Turn turtle about axis 'head' by a specified angle

/  Turn turtle about axis 'head' by a specified angle

|  Turn turtle about axis 'up' by 180 degrees

[  "start branching" Push current turtle position and orientation 
   on stack

]  "terminate branching" Pop data from stack replacing current
   turtle position and orientation

{  "start polygon" render a polygon, e.g. for a leaf

}  "terminate polygon"

.  Define a corner point within a polygon '{ }'

G  Corresponds to F within a polygon '{ }'

'  Increment color index

`  Decrement color index

-----------------------------------------------------------------

Enter a New Grammar:

1st line: enter the axiom (a sequence of turtle symbols),
          terminated by <RETURN>

further line: 
          enter the production rules
          rules have the following form
              <left side>=<right side>
          with
          <linke Seite>  equals 1 turtle symbol
          <rechte Seite> equals several turtle symbols

Accept the new grammar by pressing the OK button.
Press the NEXT button to generate the next grammar derivative.

Any characters may be used as grammar symbols. Characters which do
NOT have a predefined graphics meaning (e.g. F does, but E does not)
are used for grammar derivation, but will not generate graphics
themselves.

The values for LENGTH and ANGLE apply to all "F", "+", "-", and so on
in a grammar. In order to have different length or angle values
for individual symbols, these values may be specified after the
symbol in sharp brackets, e.g.
  +<45>  denotes turning left by 45 degrees, no matter what the global
         value for ANGLE is
  F[500] denotes drawing a line of length 500, no matter what the
         global value for LENGTH is

-----------------------------------------------------------------

Stochastic Grammars

Using individual values as probabilities for a rule after the equal sign
results in defining stochastic grammers. Here, is it allowed to have
several rules for the same symbol, however, the sum of all probability
values for this symbol has to be 1, e.g.:
  F=<0.3> F+F
  F=<0.7> F-F

-----------------------------------------------------------------

Literature

P. Prusinkiewicz, A. Lindenmayer:
The SAlgorithmic Beauty of Plants
Springer-Verlag, New York, 1990

Chr. Drabek (in German)
Implementierung von L-Grammatiken zur Erzeugung von Graftalen
Diplomarbeit no. 986, Univ. Stuttgart, Fakultaet Informatik, 1993

-----------------------------------------------------------------

Contact

Christine Drabek
Thomas Braunl
Univ. Stuttgart IPVR
Breitwiesenstr. 20-22, D-70565 Stuttgart, Germany
e-mail: braunl@informatik.uni-stuttgart.de


