/*************************************************************************/
/*
 *
 * Filename: color.c
 *
 */

#include "grammar.h"

#include <malloc.h>
#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>

typedef struct {
           String name; /* Farbname */
           XColor farbe;
               } FARBEN;

/* functions in color.c:
 *
 * void Color();
 * void create_pal1();
 * void create_pal2();
 * void CopyColor();
 * void PasteColor();
 * void ChangePal();
 * void ColorOk();
 * void ColorCancel();
 * void init_color();
 * void def_color_pal();
 * void grey_color_pal();
 * void green_color_pal();
 * void change_color();
 *
 */


/* externe Variablen */

extern Display *display;
extern int screen;


/* globale Variablen */

FARBEN defcolor[NOC];

XColor greycolor[NOC],
       greencolor[NOC],
       setcolor[NOC],
       owncolor[NOC],
       helpcolor[NOC];  /* Zwischenspeicher fuer Farbwerte */

Colormap cmap;

char *col_pal_name,     /* aktueller Palettenname */
     *help_pal_name;    /* Zwischenspeicher fuer Palettenname */

Pixel pixel;

Widget b[NOC], c[NOC];

Pixel white;

/*************************************************************************/
/* Function Name: Color
 * Description:  Callback-Funktion, wenn Button 'Color' im Hauptmenue
 *               gedrueckt wird. Neues Popup-Fenster erscheint mit
 *               2 Farbpaletten (create_pal1/2) und 5 Command-Widgets
 *               (def, grey, green, o.k., cancel)
 * Globals: col_pal_name  - aktueller Palettenname
 *          help_pal_name - Zwischenspeicher fuer Palettenname
 */

/*ARGSUSED*/
void Color(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data; 
{
  void create_pal1();
  void create_pal2();
  void ChangePal();
  void ColorOk();
  void ColorCancel();

  Widget popup, form, label1, box1, label2, box2, button;
  int b;

  popup = XtVaCreatePopupShell("Colortable",
			      topLevelShellWidgetClass,
                              w,
			      NULL);

  form = XtCreateManagedWidget(
         "form", formWidgetClass, popup,
         NULL, ZERO);

  label1 = XtCreateManagedWidget(
         "label1", labelWidgetClass, form, NULL, ZERO);

  box1 = XtCreateManagedWidget(
         "box1", boxWidgetClass, form, NULL, ZERO);

  create_pal1(box1);

  label2 = XtCreateManagedWidget(
         "label2", labelWidgetClass, form, NULL, ZERO);

  box2 = XtCreateManagedWidget(
         "box2", boxWidgetClass, form, NULL, ZERO);

  create_pal2(box2);

b= 0;
  button = XtCreateManagedWidget(
         "color_def", commandWidgetClass, form, NULL, ZERO);
  XtAddCallback(button, XtNcallback, ChangePal, (int *)(b));
b++;
  button = XtCreateManagedWidget(
         "color_grey", commandWidgetClass, form, NULL, ZERO);
  XtAddCallback(button, XtNcallback, ChangePal, (int *)(b));
b++;
  button = XtCreateManagedWidget(
         "color_green", commandWidgetClass, form, NULL, ZERO);
  XtAddCallback(button, XtNcallback, ChangePal, (int *)(b));


  button = XtCreateManagedWidget(
         "color_ok", commandWidgetClass, form, NULL, ZERO);
  XtAddCallback(button, XtNcallback, ColorOk, NULL);

  button = XtCreateManagedWidget(
          "color_cancel", commandWidgetClass, form, NULL, ZERO);
  XtAddCallback(button, XtNcallback, ColorCancel, NULL);


  help_pal_name = (char *)malloc(10 * sizeof(char));
  if (help_pal_name == NULL)
  {
    fprintf(stderr, "Kein Speicher mehr frei!\n");
    fprintf(stderr, "malloc-Aufruf in Color\n");
    exit(1);
  }
  sprintf(help_pal_name, col_pal_name);


  XtSetSensitive(w, FALSE);
  XtPopup(popup, XtGrabNonexclusive);
}

/*************************************************************************/
/* Function Name: create_pal1
 * Description: Command-Widgets fuer die obere Palette werden angelegt,
 *              Hintergrundfarbe wird aus setcolor uebernommen 
 * Arguments: parent        - parent-Widget fuer die b[NOC]'s
 * Globals:   b[NOC]        - Widgets, die die Palette bilden
 *            setcolor[NOC] - Farben fuer die Palette
 */

void create_pal1(parent)
Widget parent;
{
  void CopyColor();

  char *name;
  int i;

  name = (char *)malloc(3*sizeof(char));
  if (name == NULL)
  {
    fprintf(stderr,"Kein Speicher mehr frei\n");
    fprintf(stderr,"malloc in create_pal1\n");
  }

  for (i=0; i<NOC; i++)
  {
    sprintf(name, "b%d", i);

    b[i] = XtVaCreateManagedWidget(
           name, commandWidgetClass, parent, 
           XtNbackground, setcolor[i].pixel, NULL);
    XtAddCallback(b[i], XtNcallback, CopyColor, NULL);
  }

  free(name);
}

/*************************************************************************/
/* Function Name: create_pal2
 * Description: Command-Widgets fuer die untere Palette werden angelegt,
 *              Hintergrundfarbe wird aus owncolor uebernommen 
 * Arguments: parent        - parent-Widget fuer die c[NOC]'s
 * Globals:   c[NOC]        - Widgets, die die Palette bilden
 *            owncolor[NOC] - Farben fuer die Palette
 */

void create_pal2(parent)
Widget parent;
{
  void PasteColor();

  char *name;
  int i;

  name = (char *)malloc(3*sizeof(char));
  if (name == NULL)
  {
    fprintf(stderr,"Kein Speicher mehr frei\n");
    fprintf(stderr,"malloc in create_pal1\n");
  }

  for (i=0; i<NOC; i++)
  {
    sprintf(name, "c%d", i);

    c[i] = XtVaCreateManagedWidget(
           name, commandWidgetClass, parent,
           XtNbackground, owncolor[i].pixel, NULL); 
    XtAddCallback(c[i], XtNcallback, PasteColor, (int *)(i));
  }

  free(name);
}

/*************************************************************************/
/* Function Name: CopyColor
 * Description: Hintergrundfarbe von Widget w wird in der globalen 
 *              Variable pixel gespeichert
 * Arguments: w - Widget, das den Callback ausgeloest hat
 * Globals: pixel
 */

/*ARGSUSED*/
void CopyColor(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  XtVaGetValues(w, XtNbackground, &pixel, NULL);
}

/*************************************************************************/
/* Function Name: PasteColor
 * Description: Widget w erhaelt Hintergrundfarbe, die in globaler Variable
 *              pixel gespeichert ist. Farbwert wird in Zwischenspeicher
 *              helpcolor gespeichert (bis ColorOk oder ColorCancel    
 *              aufgerufen wird).
 * Arguments: w - Widget, das Callback ausgeloest hat
 *            i - Nummer des Widget w
 * Globals: pixel
 *          helpcolor
 *          display, cmap
 */

/*ARGSUSED*/
void PasteColor(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  int i = (int)client_data;

  /* Farbe in Widget kopieren */
  XtVaSetValues(w, XtNbackground, pixel, NULL);

  /* Farbe in helpcolor kopieren */
  helpcolor[i].pixel = pixel;
  XQueryColor(display, cmap, &helpcolor[i]);
}

/*************************************************************************/
/* Function Name: ChangePal
 * Description: In Abhaengigkeit des gedrueckten Buttons button werden
 *              die Hintergrundfarben der beiden Farbpaletten geaendert.
 *              In help_pal_name wird der zugehoerige Palettenname
 *              zwischengespeichert (bis ColorOk oder ColorCancel auf- 
 *              gerufen wird)
 * Arguments: button - 0: Def-Widget hat Callback ausgeloest
 *                     1: Grey-Widget  "    "         "
 *                     2: Green-Widget "    "         "
 * Globals: defcolor
 *          greycolor
 *          greencolor
 *          helpcolor
 *          help_pal_name
 *          b[NOC], c[NOC]
 */

/*ARGSUSED*/
void ChangePal(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data; 
{
  int button = (int)(client_data);
  int i;

  switch(button)
  {
  case 0: /* def-Werte */
      for (i=0; i<NOC; i++)
      {
        XtVaSetValues(b[i], XtNbackground, defcolor[i].farbe.pixel, NULL);
        XtVaSetValues(c[i], XtNbackground, defcolor[i].farbe.pixel, NULL);
        helpcolor[i] = defcolor[i].farbe;
      }  
      sprintf(help_pal_name, "def_pal");
      break;

  case 1: /* grey-Werte */
      for (i=0; i<NOC; i++)
      {
        XtVaSetValues(b[i], XtNbackground, greycolor[i].pixel, NULL);
        XtVaSetValues(c[i], XtNbackground, greycolor[i].pixel, NULL);
        helpcolor[i] = greycolor[i];
      }
      sprintf(help_pal_name, "grey_pal");
      break;

  case 2: /* green */
      for (i=0; i<NOC; i++)
      {
        XtVaSetValues(b[i], XtNbackground, greencolor[i].pixel, NULL);
        XtVaSetValues(c[i], XtNbackground, greencolor[i].pixel, NULL);
        helpcolor[i] = greencolor[i];
      }
      sprintf(help_pal_name, "green_pal");
      break;

  } /* end of switch */

}

/*************************************************************************/
/* Function Name: ColorOk
 * Description: setcolor und owncolor bekommen die aktuellen Farbwerte
 *              zugewiesen. Falls Farbreihenfolge durch Copy und Paste
 *              geaendert wurde, wird Farbe fuer owncolor von helpcolor
 *              uebernommen. col_pal_name erhaelt den aktuellen Namen
 *              und das Popup-Widget wird geschlossen
 * Arguments: w - Widget, das den Callback ausgeloest hat
 * Globals: help_pal_name, col_pal_name
 *          setcolor, owncolor
 *          defcolor, greycolor, greencolor
 */

/*ARGSUSED*/
void ColorOk(w, client_data, call_data)
Widget	w;		
XtPointer client_data, call_data;
{
  Widget popup = XtParent(XtParent(w));
  Widget button = XtParent(popup);
  int i;

  if (strcmp(help_pal_name, "def_pal") == 0)
  {
    for (i=0; i<NOC; i++)
    {
      setcolor[i]  = defcolor[i].farbe;
      owncolor[i]  = helpcolor[i];
      helpcolor[i] = defcolor[i].farbe;
    }
  }

  if (strcmp(help_pal_name, "grey_pal") == 0)
  {
    for (i=0; i<NOC; i++)
    {
      setcolor[i]  = greycolor[i];
      owncolor[i]  = helpcolor[i];
      helpcolor[i] = greycolor[i];
    }  
  }

  if (strcmp(help_pal_name, "green_pal") == 0)
  {
    for (i=0; i<NOC; i++)
    {
      setcolor[i]  = greencolor[i];
      owncolor[i]  = helpcolor[i];
      helpcolor[i] = greencolor[i];
    }  
  }

  /* Palettenname aus Hilfsspeicher wird uebernommen */
  sprintf(col_pal_name, help_pal_name);
  free(help_pal_name);

  XtSetSensitive(button, TRUE);
  XtDestroyWidget(popup);
}

/*************************************************************************/
/* Function Name: ColorCancel
 * Description: helpcolor wird wieder auf alte Farbwerte gesestzt und 
 *              das Popup-Widget wird geschlossen. Zwischengespeicherte
 *              Aenderungen (ChangePal, Copy, Paste) werden geloescht.
 * Arguments: w - Widget, das den Callback ausgeloest hat
 * Globals: col_pal_name, help_pal_name
 *          defcolor, greycolor, greencolor
 *          helpcolor
 */

/*ARGSUSED*/
void ColorCancel(w, client_data, call_data)
Widget	w;		
XtPointer client_data, call_data;
{
  Widget popup = XtParent(XtParent(w));
  Widget button = XtParent(popup);
  int i;


  if (strcmp(col_pal_name, "def_pal") == 0)
  {
    for (i=0; i<NOC; i++)
    {
      helpcolor[i] = defcolor[i].farbe;
    }  
  }

  if (strcmp(col_pal_name, "grey_pal") == 0)
  {
    for (i=0; i<NOC; i++)
    {
       helpcolor[i] = greycolor[i];
    }  
  }

  if (strcmp(col_pal_name, "green_pal") == 0)
  {
    for (i=0; i<NOC; i++)
    {
      helpcolor[i] = greencolor[i];
    }  
  }

  free(help_pal_name);

  XtSetSensitive(button, TRUE);
  XtDestroyWidget(popup);
}

/*************************************************************************/
/* Function Name: init_color
 * Description: Initialiserungsprozess fuer Farbanwendung :
 *              Anlegen der Colormap, Allokation der Farben,
 *              col_pal_name wird mit def_pal initialisiert
 * Globals: display, screen,
 *          cmap, white,
 *          defcolor, greycolor, greencolor, 
 *          setcolor, owncolor, helpcolor,
 *          col_pal_name
 */

void init_color()
{
  void def_color_pal();
  void grey_color_pal();
  void green_color_pal();

  XColor exact;
  int i;

  cmap = DefaultColormap(display, screen);

  white = WhitePixel(display, screen);

  def_color_pal();
  grey_color_pal();
  green_color_pal();

  for (i=0; i<NOC; i++)
  {
    XAllocNamedColor(display,cmap,
          defcolor[i].name, &exact, &(defcolor[i].farbe));

    XAllocColor(display,cmap, &greycolor[i]);

    XAllocColor(display,cmap, &greencolor[i]);

    setcolor[i] = defcolor[i].farbe;
    owncolor[i] = defcolor[i].farbe;
    helpcolor[i] = defcolor[i].farbe;
  }

  col_pal_name = (char *)malloc(10 * sizeof(char));
  if (col_pal_name == NULL)
  {
    fprintf(stderr, "Kein Speicher mehr frei!\n");
    fprintf(stderr, "malloc-Aufruf in init_color\n");
    exit(1);
  }
  sprintf(col_pal_name,"def_pal");

}

/*************************************************************************/
/* Function Name: def_color_pal
 * Description: Farbnamen fuer defcolor werden angegeben
 * Globals: def_color
 */

void def_color_pal()
{
  XColor black,
	 blue,
	 cadetBlue,
	 coral,
 	 darkGreen,
 	 darkOrange,
	 darkViolet,
	 deepPink,
	 forest,
	 green,
	 grey,
	 hotPink,
	 lightGrey,
	 lime,
	 maroon,
	 mediumBlue,
	 mediumOrchid,
	 mistyRose,
	 olive,
	 orange,
	 peru,
	 plum,
	 red,
	 saddle,
	 sienna,
	 slateBlue,
	 slateGrey,
	 snow,
	 steelBlue,
	 tomato,
	 violetRed,
	 yellow ;

  defcolor[0].farbe = black;		defcolor[0].name = "black";
  defcolor[1].farbe = saddle;		defcolor[1].name = "SaddleBrown";
  defcolor[2].farbe = sienna;		defcolor[2].name = "Sienna";
  defcolor[3].farbe = peru;		defcolor[3].name = "Peru";
  defcolor[4].farbe = olive;		defcolor[4].name = "OliveDrab";
  defcolor[5].farbe = darkGreen;	defcolor[5].name = "DarkGreen";
  defcolor[6].farbe = forest;		defcolor[6].name = "ForestGreen";
  defcolor[7].farbe = lime;		defcolor[7].name = "LimeGreen";
  defcolor[8].farbe = green;		defcolor[8].name = "Green";
  defcolor[9].farbe = yellow;		defcolor[9].name = "Yellow";
  defcolor[10].farbe = orange;		defcolor[10].name = "Orange";
  defcolor[11].farbe = darkOrange;  	defcolor[11].name = "DarkOrange";
  defcolor[12].farbe = coral;		defcolor[12].name = "LightCoral";
  defcolor[13].farbe = tomato;		defcolor[13].name = "Tomato";
  defcolor[14].farbe = red;		defcolor[14].name = "Red";
  defcolor[15].farbe = maroon;		defcolor[15].name = "Maroon";
  defcolor[16].farbe = violetRed;   	defcolor[16].name = "VioletRed";
  defcolor[17].farbe = deepPink;    	defcolor[17].name = "DeepPink";
  defcolor[18].farbe = hotPink;		defcolor[18].name = "HotPink";
  defcolor[19].farbe = plum;		defcolor[19].name = "Plum";
  defcolor[20].farbe = mediumOrchid; 	defcolor[20].name = "MediumOrchid";
  defcolor[21].farbe = darkViolet;  	defcolor[21].name = "DarkViolet";
  defcolor[22].farbe = slateBlue;   	defcolor[22].name = "SlateBlue";
  defcolor[23].farbe = mediumBlue;  	defcolor[23].name = "MediumBlue";
  defcolor[24].farbe = blue;		defcolor[24].name = "Blue";
  defcolor[25].farbe = steelBlue;   	defcolor[25].name = "SteelBlue";
  defcolor[26].farbe = cadetBlue;   	defcolor[26].name = "CadetBlue";
  defcolor[27].farbe = slateGrey;   	defcolor[27].name = "SlateGrey";
  defcolor[28].farbe = grey;		defcolor[28].name = "Grey";
  defcolor[29].farbe = lightGrey;   	defcolor[29].name = "LightGrey";
  defcolor[30].farbe = snow;		defcolor[30].name = "Snow2";
  defcolor[31].farbe = mistyRose;   	defcolor[31].name = "MistyRose";

}

/*************************************************************************/
/* Function Name: grey_color
 * Description: Farbwerte fuer greycolor werden berechnet
 * Globals: greycolor
 */

void grey_color_pal()
{
  int i,
      k;

  for (i=0; i<NOC; i++)
  {
    k = i * (65536 / NOC);
    greycolor[i].red = k;
    greycolor[i].green = k;
    greycolor[i].blue = k;
  }
}

/*************************************************************************/
/* Function Name: green_color
 * Description: Farbwerte fuer greencolor werden berechnet
 * Globals: green_color
 */

void green_color_pal()
{
  int i, k;
  int max = 65535;

  for (i=0; i<NOC; i++)
  {
    if (i<10)
    {
      k = max / 100;
      greencolor[i].red   = k * (50 - 3*i);
      greencolor[i].green = k * (25 + 2*i);
      greencolor[i].blue  = k / 20 * i;
    }
    else
    {
      if (i<20)
      {
        k = 60 - (2 * i);
        greencolor[i].red   = k;
        greencolor[i].green = max * 10 / (29 - i);
        greencolor[i].blue  = k;
      }
      else
      {
        k = i * (max /NOC);
        greencolor[i].red   = k;
        greencolor[i].green = max;
        greencolor[i].blue  = 0;
      }
    }
  }
}

/*************************************************************************/
/* Function Name: change_color
 * Description: Paletten werden gemaess dem neuen Namen pal_name geaendert
 * Arguments: pal_name - neuer Palettenname 
 * Globals:  setcolor, owncolor, helpcolor
 *           defcolor, greycolor, greencolor
 *           display, cmap
 *           col_pal_name, help_pal_name
 */
void change_color(pal_name, farben)
char *pal_name;
XColor farben[NOC];
{
  int i;

  if (strcmp(pal_name, "def_pal") == 0)
  {
    for (i=0; i<NOC; i++)
    {
      setcolor[i]  = defcolor[i].farbe;
      owncolor[i]  = farben[i];
      helpcolor[i] = farben[i];
      XAllocColor(display, cmap, &setcolor[i]);
      XAllocColor(display, cmap, &owncolor[i]);
      XAllocColor(display, cmap, &helpcolor[i]);
    }  
  }

  if (strcmp(pal_name, "grey_pal") == 0)
  {
    for (i=0; i<NOC; i++)
    {
      setcolor[i]  = greycolor[i];
      owncolor[i]  = farben[i];
      helpcolor[i] = farben[i];
      XAllocColor(display, cmap, &setcolor[i]);
      XAllocColor(display, cmap, &owncolor[i]);
      XAllocColor(display, cmap, &helpcolor[i]);
    }  
  }

  if (strcmp(pal_name, "green_pal") == 0)
  {
    for (i=0; i<NOC; i++)
    {
      setcolor[i]  = greencolor[i];
      owncolor[i]  = farben[i];
      helpcolor[i] = farben[i];
      XAllocColor(display, cmap, &setcolor[i]);
      XAllocColor(display, cmap, &owncolor[i]);
      XAllocColor(display, cmap, &helpcolor[i]);
    }  
  }

  sprintf(col_pal_name, pal_name);
}

/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/* Function Name: 
 * Description: 
 * Arguments: 
 * Globals: 
 * Returns: 
 */
/*************************************************************************/






