/*************************************************************************/
/*
 *
 *  Filename:  grammar.c
 *
 */

#include "grammar.h"

#include <malloc.h>
#include <stdio.h>
#include <ctype.h>

#include <X11/Intrinsic.h>


/* functions in grammar.c:
 *
 * int  klammern_pruefen();
 * void init_word();
 * void ableitung_wort();
 * void ableitung_symbol();
 *
 *
 * void    push_2d();
 * STACK2 *pop_2d();
 * void    push_3d();
 * STACK3 *pop_3d();
 * void    push_point();
 * STACK  *pop_point();
 */


extern SYMBOLE *create_node();
extern double   random_number();
extern SYMBOLE *delete_wordlist();

extern REGELN  *grammar;
extern SYMBOLE *word;
extern SYMBOLE *current_symbol;


STACK2 *stackptr2 = NULL;
STACK3 *stackptr3 = NULL;
STACK  *stackptr  = NULL;

/*************************************************************************/
/* Function Name: klammern_pruefen
 * Description: ueberprueft, ob in str die Klammern '[' und ']', '{' und            '}'
 *              bzw. '<' und '>' (hier auch keine Schachtelung erlaubt)
 *              richtig gesetzt wurden. Die Ueberpruefung erfolgt zeilenweise,
 *              d.h. es wird jedesmal bis zu '\n' eine korrekte Klammerung
 *              benoetigt, sonst Fehler zurueckgegeben.
 * Arguments: str - zu pruefenden String
 * Returns: fehler = 0: kein Fehler erkannt
 *                   1: Fehler erkannt
 */

int klammern_pruefen(str)
String str;
{
  int i;              /* Schleifenvariable */
  char c;

  int r = 0,          /* zaehlt '[' bzw. ']' */
      s = 0,          /* zaehlt '{' bzw. '}' */
      t = 0;          /* zaehlt '<' bzw. '>' */

  int fehler = 0;

  for (i=0; i<strlen(str); i++)
  {
    c = str[i];
    switch(c)
    {
    case '[': r++;
              break;

    case ']': r--;
              if (r<0)
              {
                fehler = 1;
                return fehler;
              }
              break;

    case '{': s++;
              if (s>1)
              {
                /* '{' innerhalb von "{ }" */
                fehler = 1;
                return fehler;
              }
              break;

    case '}': s--;
              if (s<0)
              {
                fehler = 1;
                return fehler;
              }
              break;

    case '<': t++;
              if (t>1)
              {
                /* '<' innerhalb von Index oder Zusatz */
                fehler = 1;
                return fehler;
              }
              break;

    case '>': t--;
              if (t<0)
              {
                fehler = 1;
                return fehler;
              }
              break;

    case '\n': /* Zeilenende */
              if ( (r != 0) || (s!= 0) || (t != 0) )
              {
                fehler = 1;
                return fehler;
              }
              break;
    } /*switch*/
  } /*for*/

  if ( (r != 0) || (s != 0) || (t != 0) ) fehler = 1;

  return fehler;
}

/*************************************************************************/
/* Function Name: init_word
 * Description: initialisiert word mit dem Axiom von grammar
 *              current_symbol zeigt auf den Anfang von word 
 * Globals: grammar
 *          word
 *          current_symbol
 */

void init_word()
{
  SYMBOLE *create_node();

  SYMBOLE *hilfe,
          *w_end,
          *wneu;

  hilfe = grammar->list;
  word = create_node();
  word->symb   = hilfe->symb;
  word->zusatz = hilfe->zusatz;
  word->indice = hilfe->indice;
  word->next   = NULL;
  w_end = word;
  hilfe = hilfe->next;

  while (hilfe)
  {
    wneu = create_node();
    w_end->next  = wneu;
    wneu->symb   = hilfe->symb;
    wneu->zusatz = hilfe->zusatz;
    wneu->indice = hilfe->indice;
    wneu->next   = NULL;
    w_end = wneu;
    hilfe = hilfe->next;
  }

  current_symbol = word;
}

/*************************************************************************/
/* Function Name: ableitung_wort
 * Description: leitet word einen gesamten Schritt ab
 * Globals: grammar
 *          word
 *          current_symbol
 */

void ableitung_wort()
{
  SYMBOLE *create_node();
  double   random_number();
  SYMBOLE *delete_wordlist();

  SYMBOLE *newword,
          *new,
          *newend,
          *old,
          *regelsymb;

  REGELN *prod;

  String noprod_symbole = "+-^&\/|$[]{}.~!,%";

  double sum_wk,
         number;

  newword = create_node();
  newend = newword;

  old = word;       /* zeigt auf 1. Symbol des abzuleitenden Wortes */

  while (old)
  {
    prod = grammar->next;  /* zeigt auf erste Produktion */

    if (prod != NULL)
    {
      /* passende Produktion suchen */
      while ( ( ((prod->symb)   != (old->symb)) || 
                ((prod->indice) != (old->indice)) ) && (prod->next) )
      {
        prod = prod->next;
      }

      if ( ((prod->symb) == (old->symb)) &&
           ((prod->indice) == (old->indice)) )
      {
        /* 1.passende Produktion gefunden - symb und indice sind gleich - */

        /* Wahrscheinlichkeiten ueberpruefen */
        if (prod->zusatz != 1)
        {
          sum_wk = prod->zusatz;
  
          /* Zufallszahl zwischen 0 und 1 erzeugen */
          number = random_number();

          while (sum_wk < number)
          {  
            prod = prod->next;
            /* naechste passende Produktion suchen */ 
            while ( ((prod->symb) != (old->symb)) 
                 || ((prod->indice) != (old->indice)) )
            {
              prod = prod->next;
            }
            sum_wk += prod->zusatz;
          }
        }

        /* Produktion fuer Ableitung gefunden */

        regelsymb = prod->list; /* zeigt auf 1. Symbol der rechten Seite */
        while(regelsymb)
        {
          new = create_node();
          newend->next = new;
          newend = new;
          new->symb   = regelsymb->symb;
          new->indice = regelsymb->indice;

          /* Zusatz-Vererbung */
          if (strchr(noprod_symbole,regelsymb->symb) == NULL)
          {
            new->zusatz = regelsymb->zusatz * old->zusatz;
          }
          else
          {
            new->zusatz = regelsymb->zusatz;
          }

          regelsymb = regelsymb->next; 
        } /*while*/
      } /*if*/
      else
      {
        /* Identitaetsproduktion */
        new = create_node();
        newend->next = new;
        newend = new;
        new->symb   = old->symb;
        new->zusatz = old->zusatz;
        new->indice = old->indice;

      }
    } /*if */
    else
    {
      /* keine Regeln vorhanden -> Identitaetsproduktion */
      new = create_node();
      newend->next = new;
      newend = new;
      new->symb   = old->symb;
      new->zusatz = old->zusatz;
      new->indice = old->indice;

    }

    old = old->next;  /* naechstes Symbol des abzuleitenden Wortes */
  } /*while*/

  new = newword->next;

  /* Speicherplatz fuer newword freigeben */
  free(newword); 

  /* altes word loeschen */
  old = delete_wordlist(word);

  /* neues word setzen */
  word = new;
  current_symbol = word; 
}

/*************************************************************************/
/* Function Name: ableitung_symbol
 * Description: leitet naechstes Symbol - current_symbol - von word ab
 * Globals: grammar
 *          word
 *          current_symbol
 */

void ableitung_symbol()
{
  double   random_number();
  SYMBOLE *create_node();

  REGELN *prod;
  SYMBOLE *next_symbol,
          *regelsymb,
          *new;

  String noprod_symbole = "+-^&\/|$[]{}.~!,%";

  char   help_symb;
  double help_zusatz;

  double sum_wk,
         number;

  /* naechstes Symbol zum Einhaengen merken */
  next_symbol = current_symbol->next;

  prod = grammar->next;  /* zeigt auf erste Produktion */

  if (prod != NULL)
  {
    /* passende Produktion suchen */
    while ( ( ((prod->symb)   != (current_symbol->symb)) ||
              ((prod->indice) != (current_symbol->indice)) )  && (prod->next) )
    {
      prod = prod->next;
    }

    if ( ((prod->symb)   == (current_symbol->symb)) &&
         ((prod->indice) == (current_symbol->indice)) )
    {
      /* 1.passende Produktion gefunden */

      /* Wahrscheinlichkeiten ueberpruefen */
      if (prod->zusatz != 1)
      {
        sum_wk = prod->zusatz;
  
        /* Zufallszahl zwischen 0 und 1 erzeugen */
        number = random_number();

        while (sum_wk < number)
        {  
          prod = prod->next;
          /* naechste passende Produktion suchen */ 
          while ( ((prod->symb) != (current_symbol->symb)) ||
                  ((prod->indice) != (current_symbol->indice)) )
          {
            prod = prod->next;
          }
          sum_wk += prod->zusatz;
        }
      }

      /* Produktion fuer Ableitung gefunden */

      regelsymb = prod->list; /* zeigt auf 1. Symbol der rechten Seite */

      help_symb  = current_symbol->symb;
      help_zusatz = current_symbol->zusatz;

      current_symbol->symb   = regelsymb->symb;
      current_symbol->indice = regelsymb->indice;

      /* Zusatz-Vererbung */
      if (strchr(noprod_symbole, regelsymb->symb) == NULL)
      {
        current_symbol->zusatz = regelsymb->zusatz * help_zusatz;
      }
      else
      {
        current_symbol->zusatz = regelsymb->zusatz;
      }

      regelsymb = regelsymb->next;
      while(regelsymb)
      {
        new = create_node();
        current_symbol->next = new;
        current_symbol = new;
        new->symb   = regelsymb->symb;
        new->indice = regelsymb->indice;

        /* Zusatz-Vererbung */
        if (strchr(noprod_symbole, regelsymb->symb) == NULL)
        {
          new->zusatz = regelsymb->zusatz * help_zusatz;
        }
        else
        {
          new->zusatz = regelsymb->zusatz;
        }
 
        regelsymb = regelsymb->next;
      }
      current_symbol->next = next_symbol;
    }
    else
    {
      /* Identitaetsproduktion */
    }
  } /*if*/
  else 
  {
    /* keine Regeln vorhanden -> Identitaetsproduktion */
  }

  if (next_symbol)
  {
    /* falls naechstes Symbol im abzuleitenden Wort existiert */
    current_symbol = next_symbol;
  }
  else
  {
    /* current_symbol wird wieder auf den Wortanfang gesetzt */
    current_symbol = word;
  }
}

/*************************************************************************/
/* Function Name: push_2d
 * Description: legt state2 als oberstes Element auf den Stack     
 *              (2D-Turtle)
 * Arguments: state2 - enthaelt zu speichernde Werte (pos und orient)
 * Globals: stackptr2
 */

void push_2d(state2)
STACK2 *state2;
{
  STACK2 *neu;

  neu = (STACK2 *)malloc(sizeof(STACK2));
  if (neu == NULL)
  {
    fprintf(stderr, "Kein Speicher mehr frei!\n");
    fprintf(stderr, "malloc-Aufruf in push_2d\n");
    exit(1);
  }

  neu->position  = state2->position;
  neu->head      = state2->head;
  neu->sum_angle = state2->sum_angle;
  neu->color     = state2->color;

  /* Element neu vorn in Stack einfuegen */
  neu ->next = stackptr2;
  stackptr2 = neu;
}

/*************************************************************************/
/* Function Name: pop_2d
 * Description: nimmt oberstes Element vom Stack und 
 *              gibt es als Ergebnis zurueck (2D-Turtle)
 * Globals: stackptr2
 * Returns: state2
 */

STACK2 *pop_2d()
{
  STACK2 *state2;
  STACK2 *alt;

  if(stackptr2 == NULL)
  {
    fprintf(stderr, "Stack leer in pop_2d!\n");
    exit(1);
  }

  state2 =  (STACK2 *)malloc(sizeof(STACK2));
  if (state2 == NULL)
  {
    fprintf(stderr, "Kein Speicher mehr frei!\n");
    fprintf(stderr, "malloc-Aufruf in pop_2D\n");
    exit(1);
  }

  state2->position  = stackptr2->position;
  state2->head      = stackptr2->head;
  state2->sum_angle = stackptr2->sum_angle;
  state2->color     = stackptr2->color;

  /* alt zeigt auf altes oberstes Element im Stack */
  alt = stackptr2;

  /* stackptr zeigt auf neues oberstes Element im Stack */
  stackptr2 = stackptr2->next;

  free(alt);
  return state2;
}

/*************************************************************************/
/* Function Name: push_3d
 * Description: legt turtle_state3 als oberstes Element 
 *              auf den Stack (3D-Turtle)
 * Arguments: turtle_state3 - enthaelt zu speichernde Werte (pos und orient)
 * Globals: stackptr
 */

void push_3d(turtle_state3)
STACK3 *turtle_state3;
{
  STACK3 *neu;

  neu = (STACK3 *)malloc(sizeof(STACK3));
  if (neu == NULL)
  {
    fprintf(stderr, "Kein Speicher mehr frei!\n");
    fprintf(stderr, "malloc-Aufruf in push_3d\n");
    exit(1);
  }

  neu->position = turtle_state3->position;
  neu->head     = turtle_state3->head;
  neu->left     = turtle_state3->left;
  neu->up       = turtle_state3->up;
  neu->color    = turtle_state3->color;


  /* Element neu vorn in Stack einfuegen */
  neu ->next = stackptr3;
  stackptr3 = neu;
}

/*************************************************************************/
/* Function Name: pop_3d
 * Description: nimmt oberstes Element vom Stack und 
 *              gibt es als Ergebnis zurueck (3D-Turtle)
 * Globals: stackptr
 * Returns: turtle_state3
 */

STACK3 *pop_3d()
{
  STACK3 *turtle_state3;
  STACK3 *alt;

  if(stackptr3 == NULL)
  {
    fprintf(stderr, "Stack leerin pop_3d!\n");
    exit(1);
  }

  turtle_state3 =  (STACK3 *)malloc(sizeof(STACK3));
  if (turtle_state3 == NULL)
  {
    fprintf(stderr, "Kein Speicher mehr frei!\n");
    fprintf(stderr, "malloc-Aufruf in pop_3d\n");
    exit(1);
  }

  turtle_state3->position = stackptr3->position;
  turtle_state3->head     = stackptr3->head;
  turtle_state3->left     = stackptr3->left;
  turtle_state3->up       = stackptr3->up;
  turtle_state3->color    = stackptr3->color;

  /* alt zeigt auf 1. Element im Stack */
  alt = stackptr3;

  /* stackptr zeigt auf 2. Element im Stack */
  stackptr3 = stackptr3->next;

  free(alt);
  return turtle_state3;
}

/*************************************************************************/
/* Function Name: push_point
 * Description: legt point als oberstes Element auf den Stack     
 * Arguments: point - enthaelt zu speichernde Werte (pos)
 * Globals: stackptr
 */

void push_point(point)
STACK *point;
{
  STACK *neu;

  neu = (STACK *)malloc(sizeof(STACK));
  if (neu == NULL)
  {
    fprintf(stderr, "Kein Speicher mehr frei!\n");
    fprintf(stderr, "malloc-Aufruf in push_poly\n");
    exit(1);
  }

  neu->position  = point->position;

  /* Element neu vorn in Stack einfuegen */
  neu ->next = stackptr;
  stackptr = neu;
}

/*************************************************************************/
/* Function Name: pop_point
 * Description: nimmt oberstes Element vom Stack und 
 *              gibt es als Ergebnis zurueck
 * Globals: stackptr
 * Returns: poly_point
 */

STACK *pop_point()
{
  STACK *point;
  STACK *alt;

  if(stackptr == NULL)
  {
    fprintf(stderr, "Stack leer in pop_point!\n");
    exit(1);
  }

  point =  (STACK *)malloc(sizeof(STACK));
  if (point == NULL)
  {
    fprintf(stderr, "Kein Speicher mehr frei!\n");
    fprintf(stderr, "malloc-Aufruf in pop_point\n");
    exit(1);
  }

  point->position  = stackptr->position;

  /* alt zeigt auf altes oberstes Element im Stack */
  alt = stackptr;

  /* stackptr zeigt auf neues oberstes Element im Stack */
  stackptr = stackptr->next;

  free(alt);
  return point;
}

/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/* Function Name: 
 * Description: 
 * Arguments: 
 * Globals: 
 * Returns: 
 */

/*************************************************************************/


