/*
 *  Filename: grammar.h
 *
 */


typedef struct node {
           char         symb;
           double       zusatz;
           char         indice;
           struct node *next;
                    } SYMBOLE;

typedef struct rule {
           char         symb;   /* left side of production */ 
           double       zusatz; /* zusatz for angle resp. length */
           char         indice; /* indice for turtle-symbol */
           SYMBOLE     *list;   /* pointer to right side of production */
           struct rule *next;   /* pointer to next rule */
                    } REGELN;

typedef struct {
           double x, y, z;
               } POINT;


typedef struct {
           POINT  pos;        /* Positions-Vektor der Turtle */
           POINT  h;          /* heading-Vektor */
           POINT  l;          /* left-Vektor */
           POINT  u;          /* up-Vektor */
           double angle;      /* Winkel fuer Drehung der Turtle */
           int    length;     /* Laenge in Pixel fuer F bzw. f */
           double scale;      /* Verkleinerungsfaktor fuer F bzw. f */
               } TURTLE_VALUES;


typedef struct stack {
           POINT position;
           struct stack *next;
                     } STACK;

typedef struct stack2 {
           POINT  position;
           POINT  head;
           double sum_angle;
           int    color;
           struct stack2 *next;
                      } STACK2;

typedef struct stack3 {
           POINT  position;
           POINT  head;
           POINT  left;
           POINT  up;
           int    color;
           struct stack3 *next;
                      } STACK3;

typedef struct stackturtle {
           POINT  position;
           POINT  head;
           POINT  left;
           POINT  up;
           int    color;
           double stem;
           struct stackturtle *next;
                      } STACKTURTLE;



#define PI    3.141592653589793
#define NOC  32                   /* number of colors */
