/*************************************************************************/
/*
 *
 *  Filename:  load.c
 *
 */

#include "grammar.h"
#include <dirent.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <malloc.h>
#include <math.h>
#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/Viewport.h>


/* aus xui.c */

extern Widget g_posx, g_posy, g_posz;
extern Widget g_angle, g_length, g_scale;
extern Widget g_headx, g_heady, g_headz;
extern Widget g_leftx, g_lefty, g_leftz;
extern Widget g_upx, g_upy, g_upz;
extern Widget proj_x0, proj_y0, proj_a;
extern Widget gram;

extern int persp_x0, persp_y0, persp_a;

extern XtAppContext app_context;

/* functions in load.c:
 *
 * void Load();
 * void update_filelist();
 * void ClickList();
 * void LoadOk();
 * void LoadCancel();
 *
 */ 

 
Widget filelist, text;

char workdir[MAXPATHLEN];
 
int countclick; 
 
/*************************************************************************/
/* Function Name: Load
 * Description: 
 * Arguments: 
 * Globals: filelist, text, workdir
 */

/* ARGSUSED */
void Load(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Widget popup, pform, viewport, l_ok, l_cancel;

  void ClickList();
  void update_filelist();
  void LoadOk();
  void LoadCancel();

  static int counter = 0;

  popup = XtVaCreatePopupShell("popup", topLevelShellWidgetClass, w,
			         NULL);

  pform = XtVaCreateManagedWidget("pform", formWidgetClass, popup, NULL);

  text = XtVaCreateManagedWidget("text", asciiTextWidgetClass, pform,
                                 XtNeditType, XawtextEdit,
                                 XtNwidth, 250,
                                 XtNheight, 30,
                                 XtNautoFill, TRUE,
                                 NULL);

  if (counter == 0)
  {
    getwd(workdir);
    if (workdir == NULL)
    {
      printf("getwd\n");
      exit(1);
    }
    counter++;
  }
  
  XtVaSetValues(text, XtNstring, workdir, NULL);


  viewport = XtVaCreateManagedWidget("viewport", viewportWidgetClass, pform,
                                     XtNfromVert, text,
                                     XtNallowHoriz, TRUE,
                                     XtNallowVert, TRUE,
                                     XtNheight, 250,
                                     XtNwidth, 150,
                                     NULL);

  filelist = XtVaCreateManagedWidget("filelist", listWidgetClass, viewport,
                                     XtNdefaultColumns,1,
                                     NULL);

  XtAddCallback(filelist, XtNcallback, ClickList, NULL);

  countclick = 0;
  update_filelist();

  l_ok = XtVaCreateManagedWidget("O.K.", commandWidgetClass, pform,
                                 XtNfromHoriz, viewport,
                                 XtNfromVert, text,
                                 NULL);
  XtAddCallback(l_ok, XtNcallback, LoadOk, NULL); 

  l_cancel = XtVaCreateManagedWidget("Cancel", commandWidgetClass, pform,
                                     XtNfromHoriz, viewport,
                                     XtNfromVert, l_ok,
                                     NULL);
  XtAddCallback(l_cancel, XtNcallback, LoadCancel, NULL);

  XtPopup(popup, XtGrabNonexclusive);
}

/*************************************************************************/
/* Function Name: update_filelist
 * Description: 
 * Arguments: 
 * Globals: workdir, filelist
 */

void update_filelist()
{
  DIR  *directory;
  struct dirent *dp;

  int entry;
  String *str;
  int i;   /* Schleifenvariable */


  directory = (DIR *)malloc(sizeof(DIR));
  if (directory == NULL)
  {
    fprintf(stderr, "Kein Speicher mehr frei!\n");
    fprintf(stderr, "malloc-Aufruf in update_filelist\n");
    exit(1);
  }

  directory = opendir(workdir);
  if (directory == NULL)
  {
    fprintf(stderr, "Fehler bei opendir1 in update_filelist\n");
    exit(1);
  }
  entry = 0;

  dp = (struct dirent *)malloc(sizeof(struct dirent));
  if (dp == NULL)
  {
    fprintf(stderr, "Kein Speicher mehr frei!\n");
    fprintf(stderr, "malloc-Aufruf in update_filelist\n");
    exit(1);
  }

  for (dp = readdir(directory); dp != NULL; dp = readdir(directory))
  {
    entry++;
  }
  closedir(directory);

  str = (String *)malloc(sizeof(String) * entry);
  if (str == NULL)
  {
    fprintf(stderr, "Kein Speicher mehr frei!\n");
    fprintf(stderr, "malloc-Aufruf in update_filelist\n");
    exit(1);
  }

  directory = opendir(workdir);
  if (directory == NULL)
  {
    fprintf(stderr, "Fehler bei opendir2 in update_filelist\n");
    exit(1);
  }
  dp = readdir(directory);  /* Eintrag .  */

  i = 0;
  for (dp = readdir(directory); dp != NULL; dp = readdir(directory))
  {
    str[i] = XtNewString(dp->d_name);
    i++;
  } 
  XawListChange(filelist, str, i, 0, TRUE);
  closedir(directory);
}

/*************************************************************************/
/* Function Name: ClickList
 * Description: 
 * Arguments: 
 * Globals: text, workdir
 */

/*ARGSUSED*/
void ClickList(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  XawListReturnStruct *listitem = (XawListReturnStruct *)call_data;

  void LoadOk();

  char path[MAXPATHLEN];
  static char altname[MAXPATHLEN] = "\0";

  countclick++;

  strcpy(path, workdir);
  strcat(path, "/");
  strcat(path, listitem->string);
  XtVaSetValues(text, XtNstring, path, NULL);

  if (!(countclick % 2) && (strcmp(altname, listitem->string) == 0))
  {  
    LoadOk(text, (XtPointer) NULL, (XtPointer) NULL);
    countclick = 0;
  }

  strcpy(altname, listitem->string);  
}

/*************************************************************************/
/* Function Name: LoadOk
 * Description: 
 * Arguments: 
 * Globals: 
 */

/* ARGSUSED */
void LoadOk(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Widget popup  = XtParent(XtParent(w));
  Widget button = XtParent(popup);

  void update_filelist();

  String filename;
  struct stat *buf;

  FILE *fp;

  char *pal_name;
  XColor farben[NOC];
  int i;

  char wert[10];
  char file_zeile[80];
  char *file_gram;

  int geslaenge;
  int h;
  char neu[MAXPATHLEN];
  char alt[MAXPATHLEN];


  countclick = 0;

  filename = (char *)malloc(sizeof(char) * MAXPATHLEN);
  if (filename == NULL)
  {
    fprintf(stderr, "Kein Speicher mehr frei!\n");
    fprintf(stderr, "malloc-Aufruf in LoadOk\n");
    exit(1);
  }

  XtVaGetValues(text, XtNstring, &filename, NULL);

  buf = (struct stat *)malloc(sizeof(struct stat));
  if (buf == NULL)
  {
    fprintf(stderr, "Kein Speicher mehr frei!\n");
    fprintf(stderr, "malloc-Aufruf in LoadOk\n");
    exit(1);
  }

  stat(filename, buf);

  if (S_ISDIR(buf->st_mode))
  {
    /* Verzeichnis aktualisieren */ 

    strcpy(alt, filename);
    geslaenge = strlen(alt);
    if (   (alt[geslaenge-3] == '/')
        && (alt[geslaenge-2] == '.')
        && (alt[geslaenge-1] == '.') )
    {
      geslaenge -= 4;

      if (geslaenge > 13) /* wegen /tmp_mnt/home */
      {
        h=0;
        while((alt[geslaenge-h] != '/') && (h < geslaenge))
        {
          h++;
        }

        if (geslaenge > h+1)
        {
          geslaenge -= (h+1);
        }

        for(h=0; h<=geslaenge; h++)
        {
          neu[h] = alt[h];
        }
        neu[h] = '\0';
        strcpy(workdir, neu);
      }
      else 
      {
        strcpy(workdir, filename);
      }

    }
    else
    {
      strcpy(workdir, filename);
    }

    XtVaSetValues(text, XtNstring, workdir, NULL);
    update_filelist();
  }

  if (S_ISREG(buf->st_mode))
  {
    if ((fp = fopen(filename, "r")) != NULL)
    {
      /* Einlesen der Farb-Palette aus dem File */
      pal_name = (char *)malloc(10 * sizeof(char));
      if (pal_name == NULL)
      {
        fprintf(stderr, "Kein Speicher mehr frei!\n");
        fprintf(stderr, "malloc-Aufruf in LoadOk\n");
        exit(1);
      }
      /* pal_name */
      fscanf(fp, "%s", pal_name);

      /* Einlesen der Farbreihenfolge aus dem File */
      for (i=0; i<NOC; i++)
      {
        fscanf(fp, "%s", wert); farben[i].red = atoi(wert);
        fscanf(fp, "%s", wert); farben[i].green = atoi(wert);
        fscanf(fp, "%s", wert); farben[i].blue = atoi(wert);
      }

      change_color(pal_name, farben);

      free(pal_name);

      /* Einlesen der Filedaten in die Turtledaten */

      /* g_posx */
      fscanf(fp, "%s", wert);
      XtVaSetValues(g_posx, XtNvalue, wert, NULL);
  
      /* g_posy */
      fscanf(fp, "%s", wert);
      XtVaSetValues(g_posy, XtNvalue, wert, NULL);
  
      /* g_posz */
      fscanf(fp, "%s", wert);
      XtVaSetValues(g_posz, XtNvalue, wert, NULL);
 
      /* g_angle */
      fscanf(fp, "%s", wert); 
      XtVaSetValues(g_angle, XtNvalue, wert, NULL);
  
      /* g_length */
      fscanf(fp, "%s", wert);
      XtVaSetValues(g_length, XtNvalue, wert, NULL);

      /* g_scale */
      fscanf(fp, "%s", wert);
      XtVaSetValues(g_scale, XtNvalue, wert, NULL);
 
      /* g_headx */
      fscanf(fp, "%s", wert);
      XtVaSetValues(g_headx, XtNvalue, wert, NULL);
 
      /* g_heady */
      fscanf(fp, "%s", wert);
      XtVaSetValues(g_heady, XtNvalue, wert, NULL);

      /* g_headz */
      fscanf(fp, "%s", wert);
      XtVaSetValues(g_headz, XtNvalue, wert, NULL);

      /* g_leftx */
      fscanf(fp, "%s", wert);
      XtVaSetValues(g_leftx, XtNvalue, wert, NULL);
  
      /* g_lefty */
      fscanf(fp, "%s", wert);
      XtVaSetValues(g_lefty, XtNvalue, wert, NULL);

      /* g_leftz */
      fscanf(fp, "%s", wert);
      XtVaSetValues(g_leftz, XtNvalue, wert, NULL);

      /* g_upx */
      fscanf(fp, "%s", wert);
      XtVaSetValues(g_upx, XtNvalue, wert, NULL);
  
      /* g_upy */
      fscanf(fp, "%s", wert);
      XtVaSetValues(g_upy, XtNvalue, wert, NULL);
  
      /* g_upz */
      fscanf(fp, "%s", wert);
      XtVaSetValues(g_upz, XtNvalue, wert, NULL);

      /* persp_x0 */
      fscanf(fp, "%s", wert);
      persp_x0 = atoi(wert);
 
      /* persp_y0 */
      fscanf(fp, "%s", wert);
      persp_y0 = atoi(wert);
 
      /* persp_a */
      fscanf(fp, "%s", wert);
      persp_a = atoi(wert);

      /* gram */
      file_gram = (char *)calloc(1,sizeof(char)*500);
      if (file_gram == NULL)
      {
        fprintf(stderr, "Kein Speicher mehr frei!\n");
        fprintf(stderr, "calloc-Aufruf in LoadOk\n");
        exit(1);
      }
 
      while (fscanf(fp, "%s", file_zeile) != EOF)
      {
        strcat(file_gram, file_zeile);
        strcat(file_gram, "\n");
      }
      XtVaSetValues(gram, XtNstring, file_gram, NULL);
  
      free(file_gram);

      if (fclose(fp))
      {
        fprintf(stderr, "Datei konnte nicht geschlossen werden\n");
        fprintf(stderr, "fclose in LoadOk \n");
        exit(1);
      }
     
      XtSetSensitive(button, TRUE);
      XtDestroyWidget(popup);
    }
  }
}

/*************************************************************************/
/* Function Name: LoadCancel
 * Description: 
 * Arguments: 
 */

/* ARGSUSED */
void LoadCancel(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Widget popup  = XtParent(XtParent(w));
  Widget button = XtParent(popup);

  countclick = 0;

  XtSetSensitive(button, TRUE);
  XtDestroyWidget(popup);
}

/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/* Function Name: 
 * Description: 
 * Arguments: 
 * Globals: 
 * Returns: 
 */
/*************************************************************************/

