/***********************************************************************/
/*
 *
 * Filename: save.c
 *
 */

#include "grammar.h"
#include "save.h"

#include <sys/param.h>

#include <malloc.h>
#include <math.h>
#include <stdio.h>


#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>

/* functions in save.c:
 *
 * void SaveObj();
 * void MenuSelect();
 * void SaveOReturnOk();
 * void SaveObjOk();
 * void SaveObjCancel();
 * void save_object_to_parfile();
 *
 */

extern int listlength(); /* aus functions.c */

extern SYMBOLE       *word;
extern TURTLE_VALUES *turtle;
extern double         CO[361], SI[361];
extern XColor         owncolor[NOC];


/* globale Variablen */

Widget fileinput;

Widget windart,
       pictures, endpic,
       amplitude, sample_int,
       camlocx, camlocy, camlocz,
       camdirx, camdiry, camdirz,
       camupx,  camupy,  camupz,
       camrx,   camry,   camrz;

WIND *wind;

/*************************************************************************/
/* Function Name: SaveObj
 * Description: 
 * Arguments: w - Widget, das den Callback ausgeloest hat 
 * Globals: Widgets (dialogWidgetClass)
 */

/*ARGSUSED*/
void SaveObj(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  void MenuSelect();
  void SaveObjOk();
  void SaveObjCancel();

  Widget popup,
         paned,
         windform,
         menu,
         entry,
         cameraform,
         cameralabel,
         saveobjform,
         saveobjok,
         saveobjcancel;

  char * menu_item_names[] = 
              {
              "Wind 1", "Wind 2", "Wind 3", "Wind from File",
              };

  char dirname[MAXPATHLEN]; /* Name des aktuellen Verzeichnisses */

  int i;

  popup = XtVaCreatePopupShell(
          "lgrammar_saveobj",        /* widget name */
          topLevelShellWidgetClass,  /* widget class from Shell.h */
          w,                         /* parent widget */   
          NULL);                     /* terminate varargs list */

  paned = XtVaCreateManagedWidget(
          "paned",              /* widget name */
          panedWidgetClass,     /* widget class from Paned.h */
          popup,                /* parent widget */
          NULL);                /* terminate varargs list */

  windform = XtVaCreateManagedWidget(
          "windform",           /* widget name */
          formWidgetClass,      /* widget class from Form.h */
          paned,                /* parent widget */
          NULL);                /* terminate varargs list */

  windart = XtVaCreateManagedWidget(
          "windart",             /* widget name */
          menuButtonWidgetClass, /* widget class from MenuButton.h */
          windform,              /* parent widget */
          NULL);                 /* terminate varargs list */

  menu = XtVaCreatePopupShell(
          "menu",                /* widget name */
          simpleMenuWidgetClass, /* widget class from SimpleMenu.h */
          windart,               /* parent widget */
          NULL);                 /* terminate varargs list */

  for (i=0; i<(int)XtNumber(menu_item_names); i++)
  {
    char *item = menu_item_names[i];
    entry = XtVaCreateManagedWidget(
          item,                 /* widget name */
          smeBSBObjectClass,    /* widget class from SmeBSB.h */
          menu,                 /* parent widget */
          NULL);                /* terminate varargs list */

    XtAddCallback(entry, XtNcallback, MenuSelect, (XtPointer)(i));
  }


  pictures = XtVaCreateManagedWidget(
          "pictures",           /* widget name */
          dialogWidgetClass,    /* widget class from Dialog.h */
          windform,             /* parent widget */
          NULL);                /* terminate varargs list */

  endpic = XtVaCreateManagedWidget(
          "endpic",             /* widget name */
          dialogWidgetClass,    /* widget class from Dialog.h */
          windform,             /* parent widget */
          NULL);                /* terminate varargs list */

  amplitude = XtVaCreateManagedWidget(
          "amplitude",          /* widget name */
          dialogWidgetClass,    /* widget class from Dialog.h */
          windform,             /* parent widget */
          NULL);                /* terminate varargs list */

  sample_int = XtVaCreateManagedWidget(
          "sample_int",         /* widget name */
          dialogWidgetClass,    /* widget class from Dialog.h */
          windform,             /* parent widget */
          NULL);                /* terminate varargs list */

  cameraform = XtVaCreateManagedWidget(
          "cameraform",         /* widget name */
          formWidgetClass,      /* widget class from Form.h */
          paned,                /* parent widget */
          NULL);                /* terminate varargs list */

  cameralabel = XtVaCreateManagedWidget(
          "cameralabel",        /* widget name */
          labelWidgetClass,     /* widget class from Label.h */
          cameraform,           /* parent widget */
          NULL);                /* terminate varargs list */

  camlocx = XtVaCreateManagedWidget(
          "camlocx",            /* widget name */
          dialogWidgetClass,    /* widget class from Dialog.h */
          cameraform,           /* parent widget */
          NULL);                /* terminate varargs list */

  camlocy = XtVaCreateManagedWidget(
          "camlocy",            /* widget name */
          dialogWidgetClass,    /* widget class from Dialog.h */
          cameraform,           /* parent widget */
          NULL);                /* terminate varargs list */

  camlocz = XtVaCreateManagedWidget(
          "camlocz",            /* widget name */
          dialogWidgetClass,    /* widget class from Dialog.h */
          cameraform,           /* parent widget */
          NULL);                /* terminate varargs list */

  camdirx = XtVaCreateManagedWidget(
          "camdirx",            /* widget name */
          dialogWidgetClass,    /* widget class from Dialog.h */
          cameraform,           /* parent widget */
          NULL);                /* terminate varargs list */

  camdiry = XtVaCreateManagedWidget(
          "camdiry",            /* widget name */
          dialogWidgetClass,    /* widget class from Dialog.h */
          cameraform,           /* parent widget */
          NULL);                /* terminate varargs list */

  camdirz = XtVaCreateManagedWidget(
          "camdirz",            /* widget name */
          dialogWidgetClass,    /* widget class from Dialog.h */
          cameraform,           /* parent widget */
          NULL);                /* terminate varargs list */

  camupx = XtVaCreateManagedWidget(
          "camupx",             /* widget name */
          dialogWidgetClass,    /* widget class from Dialog.h */
          cameraform,           /* parent widget */
          NULL);                /* terminate varargs list */

  camupy = XtVaCreateManagedWidget(
          "camupy",             /* widget name */
          dialogWidgetClass,    /* widget class from Dialog.h */
          cameraform,           /* parent widget */
          NULL);                /* terminate varargs list */

  camupz = XtVaCreateManagedWidget(
          "camupz",             /* widget name */
          dialogWidgetClass,    /* widget class from Dialog.h */
          cameraform,           /* parent widget */
          NULL);                /* terminate varargs list */

  camrx = XtVaCreateManagedWidget(
          "camrx",              /* widget name */
          dialogWidgetClass,    /* widget class from Dialog.h */
          cameraform,           /* parent widget */
          NULL);                /* terminate varargs list */

  camry = XtVaCreateManagedWidget(
          "camry",              /* widget name */
          dialogWidgetClass,    /* widget class from Dialog.h */
          cameraform,           /* parent widget */
          NULL);                /* terminate varargs list */

  camrz = XtVaCreateManagedWidget(
          "camrz",              /* widget name */
          dialogWidgetClass,    /* widget class from Dialog.h */
          cameraform,           /* parent widget */
          NULL);                /* terminate varargs list */

  saveobjform = XtVaCreateManagedWidget(
          "saveobjform",        /* widget name */
          formWidgetClass,      /* widget class from Form.h */
          paned,                /* parent widget */
          NULL);                /* terminate varargs list */

  fileinput = XtVaCreateManagedWidget(
          "fileinput",          /* widget name */
          dialogWidgetClass,    /* widget class from Dialog.h */
          saveobjform,          /* parent widget */
          NULL);                /* terminate varargs list */

  saveobjok = XtVaCreateManagedWidget(
          "saveobjok",          /* widget name */
          commandWidgetClass,   /* widget class from Command.h */
          saveobjform,          /* parent widget */
          NULL);                /* terminate varargs list */
  XtAddCallback(saveobjok, XtNcallback, SaveObjOk, NULL);

  saveobjcancel= XtVaCreateManagedWidget(
          "saveobjcancel",      /* widget name */
          commandWidgetClass,   /* widget class from Command.h */
          saveobjform,          /* parent widget */
          NULL);                /* terminate varargs list */
  XtAddCallback(saveobjcancel, XtNcallback, SaveObjCancel, NULL);

getwd(dirname);
if (dirname == NULL)
{
  printf("getwd\n");
  exit(1);
}
XtVaSetValues(fileinput, XtNvalue, dirname, NULL);



  XtSetSensitive(w, FALSE);

  XtPopup(popup, XtGrabNonexclusive);

  /* Speicher fuer Struktur wind anlegen */
  wind = (WIND *)malloc(sizeof(WIND));
  if (wind == NULL)
  {
    fprintf(stderr, "Kein Speicher mehr frei!\n");
    fprintf(stderr, "malloc-Aufruf in SaveObjOk\n");
    exit(1);
  }

  wind->art = 1; /* Default-Wert, falls spaeter keine Art ausgew"ahlt wird */

}

/*************************************************************************/
/* Function Name: MenuSelect
 * Description: 
 * Arguments: 
 * Globals: wind 
 */

void MenuSelect(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  int i = (int)(client_data) + 1;

  wind->art = i;
}

/*************************************************************************/
/* Function Name: SaveOReturnOk
 * Description: Generiert den Callback, der durch Druecken des OK-Buttons
 *              ausgeloest worden waere
 * Arguments: w - Widget, das den Callback ausgeloest hat
 */

/*ARGSUSED*/
void SaveOReturnOk(w, event, params, num_params)
Widget w;		
XEvent *event;		
String *params;	
Cardinal *num_params;
{
  void SaveObjOk();

  Widget dialog = XtParent(w);

  SaveObjOk(dialog, (XtPointer) dialog, (XtPointer) NULL);
}

/*************************************************************************/
/* Function Name: SaveObjOk
 * Description: liest Daten aus dem Popup und ruft damit die Funktionen
 *              save_object_to_... auf. Anschl. wird Popup geschlossen.
 * Arguments: w - Widget, das den Callback ausgeloest hat
 * Globals: Widgets (dialogWidgetClass), aus denen die Values gelesen werden
 */

/*ARGSUSED*/
void SaveObjOk(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  void save_object_to_rayfile();
  void save_object_to_parfile();

  Widget popup = XtParent(XtParent(XtParent(XtParent(XtParent(XtParent(w))))));
  Widget button = XtParent(popup);

  String filename = XawDialogGetValueString(fileinput); 
         /* ohne Speicherallokation */

  CAMERA *camera;
  char   *s_value;


  /* Speicher fuer Struktur camera anlegen */
  camera = (CAMERA *)malloc(sizeof(CAMERA));
  if (camera == NULL)
  {
    fprintf(stderr, "Kein Speicher mehr frei!\n");
    fprintf(stderr, "malloc-Aufruf in SaveObjOk\n");
    exit(1);
  }


  /* Speicher fuer s_value anlegen */
  s_value = (char *)malloc(5 * sizeof(char));
  if (s_value == NULL)
  {
    fprintf(stderr, "Kein Speicher mehr frei\n");
    fprintf(stderr, "malloc-Aufruf in SaveObjOk\n");
    exit(1);
  }

  /* Einlesen der eingegebenen Werte in die Struktur camera */
  XtVaGetValues(camlocx, XtNvalue, &s_value, NULL);
  camera->loc.x = (double)(atof(s_value));

  XtVaGetValues(camlocy, XtNvalue, &s_value, NULL);
  camera->loc.y = (double)(atof(s_value));

  XtVaGetValues(camlocz, XtNvalue, &s_value, NULL);
  camera->loc.z = (double)(atof(s_value));

  XtVaGetValues(camdirx, XtNvalue, &s_value, NULL);
  camera->dir.x = (double)(atof(s_value));

  XtVaGetValues(camdiry, XtNvalue, &s_value, NULL);
  camera->dir.y = (double)(atof(s_value));

  XtVaGetValues(camdirz, XtNvalue, &s_value, NULL);
  camera->dir.z = (double)(atof(s_value));

  XtVaGetValues(camupx, XtNvalue, &s_value, NULL);
  camera->up.x = (double)(atof(s_value));

  XtVaGetValues(camupy, XtNvalue, &s_value, NULL);
  camera->up.y = (double)(atof(s_value));

  XtVaGetValues(camupz, XtNvalue, &s_value, NULL);
  camera->up.z = (double)(atof(s_value));

  XtVaGetValues(camrx, XtNvalue, &s_value, NULL);
  camera->right.x = (double)(atof(s_value));

  XtVaGetValues(camry, XtNvalue, &s_value, NULL);
  camera->right.y = (double)(atof(s_value));

  XtVaGetValues(camrz, XtNvalue, &s_value, NULL);
  camera->right.z = (double)(atof(s_value));

  XtVaGetValues(pictures, XtNvalue, &s_value, NULL);
  wind->numpic = atoi(s_value);

  XtVaGetValues(endpic, XtNvalue, &s_value, NULL);
  wind->end = atoi(s_value);

  XtVaGetValues(amplitude, XtNvalue, &s_value, NULL);
  wind->ampl = (double)(atof(s_value));

  XtVaGetValues(sample_int, XtNvalue, &s_value, NULL);
  wind->sample = (double)(atof(s_value));

  free(s_value);

  save_object_to_parfile(filename, camera, wind);

  free(camera);
  free(wind);

  XtSetSensitive(button, TRUE);
  XtDestroyWidget(popup);
}
 
/*************************************************************************/
/* Function Name: SaveObjCancel
 * Description: Schliest Popup, ohne weitere Funktionen aufzurufen
 * Arguments: w - Widget, das den Callback ausgeloest hat
 */

/*ARGSUSED*/
void SaveObjCancel(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Widget popup = XtParent(XtParent(XtParent(w)));
  Widget button = XtParent(popup);

  free(wind);

  XtSetSensitive(button, TRUE);
  XtDestroyWidget(popup);
}

/***********************************************************************/
/* Function Name: save_object_to_parfile
 * Description: 
 * Arguments: filename - Name fuer das neue File
 *            camera   - enthaelt Daten der Kamera
 * Globals: turtle - enthaelt Turtle-Daten
 *          word   - Zeiger auf abgeleitetes Wort
 *          owncolor - aktuelle Farbpalette
 */

void save_object_to_parfile(filename, camera, wind)
String filename;
CAMERA *camera;
WIND   *wind;
{
  char *parfile;
  FILE *fp;

  POINT pos, head, left, up;
  POINT hhelp, lhelp, uhelp;

  double radius, length;

  double angle;               /* Winkel fuer '+', '-', .. */
  double sin_d, cos_d;
  double angle_b;             /* angle im Bogenmass */

  SYMBOLE *elemptr;           /* wandert durch Liste 'word' */
  char c;                     /* Turtle-Symbol */
  double zusatz_c;            /* Zusatz zum Turtle-Symbol */
  double helpzusatz;          /* Zwischenspeicher fuer Wert, der durch
                                 Zusatz != 1 temporaer veraendert */
  double helpsin, helpcos;    /* dito */

  double betrag;              /* Betrag eines Vektors, bei '$' */

  STACKTURTLE *s_ptr = NULL,  /* Zeiger auf oberstes Stack-Element */
              *state;         /* Stack-Element */

  POINT t1;           /* Eckpunkt eines Dreiecks */
  int count_vertex = 0;       /* zaehlt Eckpunkte fuer Dreiecke */

  int farb_index = 0;         /* Zeiger auf owncolor */
  double r, g, b;             /* Anteil der Farben red, green, blue */

int count, m, n;
int i; /* Schleifenvariable */
int *k;


  /* aktuelle Zeichenposition */
pos.x  =  0; pos.y  = 0; pos.z  = 0;    /* einfach so festgelegt */

  head = turtle->h;
  left = turtle->l;
  up   = turtle->u;
  
  angle = turtle->angle;


  if (angle - (int)(angle) == 0)
  {
    /* in Tabelle nachschauen */
    sin_d = SI[(int)(angle)];
    cos_d = CO[(int)(angle)];
  }
  else
  {
    /* Werte berechnen */
    angle_b = angle * PI / 180;
    sin_d = sin(angle_b);
    cos_d = cos(angle_b);
  }


length = (double)(turtle->length) / 80; /* einfach so festgelegt */

radius = 0.05;                          /* einfach so festgelegt */

  r = ((double)(owncolor[farb_index].red)) /65535;
  g = ((double)(owncolor[farb_index].green)) /65535;
  b = ((double)(owncolor[farb_index].blue)) /65535;

  /*+++++++++++++++++++++++++++++++++++++++++++++++++++*/

  parfile = (char *)malloc((strlen(filename)+10) * sizeof(char));
  if (parfile == NULL)
  {
    fprintf(stderr, "Kein Speicher mehr frei!\n");
    fprintf(stderr, "malloc-Aufruf in save_object_to_parfile\n");
    exit(1);
  }
  strcpy(parfile, filename);
  parfile = strcat(parfile, ".par");

  if ((fp = fopen(parfile, "w")) == NULL)
  {
    fprintf(stderr, "Datei konnte nicht geoeffnet werden\n");
    fprintf(stderr, "fopen in save_object_to_parfile\n");
    exit(1);
  }

  /*+++++++++++++++++++++++++++++++++++++++++++++++++++*/

  count = 0;
  m = 0;
  elemptr = word;
  while (elemptr)
  {
    c = elemptr->symb;
    switch(c)
    {
    case '[':
      count++;
      if (count > m)
      {
        m = count;
      }
      break;

    case ']':
      count--;
      break;
    }
    elemptr = elemptr->next;
  }

  k = (int *)malloc(m * sizeof(int));
  if (k == NULL)
  {
    fprintf(stderr,"Fehler bei malloc in save_object_to_parfile\n");
    exit(1);
  }

  count = 0;
  n = 0;
  for (i=0; i<=m; i++)
  {
    k[i] = 0;
  }
  elemptr = word;
  while (elemptr)
  {
    c = elemptr->symb;
    switch(c)
    {
    case '[':
      count++;
      for (i=0; i<=m; i++)
      {
        if (count == i)
        {
          (k[i])++;
        }
        if (k[i] > n)
        {
          n = k[i];
        }
      }
      break;
  
    case ']':
      count--;
      for (i=0; i<=m; i++)
      {
        if(count < (i-1))
        {
          k[i] = 0;
        }
      }
      break;
    }
    elemptr = elemptr->next;
  }
  free(k);
  
  fprintf(fp, "1 %d\n", m);
  fprintf(fp, "2 %d\n", n);
  fprintf(fp, "3 %f %f %f\n", camera->loc.x, camera->loc.y, camera->loc.z);
  fprintf(fp, "4 %f %f %f\n", camera->dir.x, camera->dir.y, camera->dir.z);
  fprintf(fp, "5 %f %f %f\n", camera->up.x, camera->up.y, camera->up.z);
  fprintf(fp, "6 %f %f %f\n", camera->right.x, camera->right.y, camera->right.z);

  fprintf(fp, "7 %d\n", wind->numpic);
  fprintf(fp, "8 %d\n", wind->end);

  /* Windart auf File herausschreiben */
  fprintf(fp, "9 %d\n", wind->art);

  fprintf(fp, "10 %f\n", wind->ampl);
  fprintf(fp, "11 %f\n", wind->sample);


/***************************************/

elemptr = word;
while (elemptr)
{
c = elemptr->symb;
zusatz_c = elemptr->zusatz;

switch(c)
{
case 'F': /* move forward and draw a line */

     if (count_vertex == 0) /* F nicht innerhalb von '{ }' */
     {
       if (zusatz_c != 1.0)
       {
         helpzusatz = length;
         length = zusatz_c * length;
       }

       fprintf(fp, "70\n");
       fprintf(fp, "80 %f %f %f\n", pos.x, pos.y, pos.z);
       fprintf(fp, "72 %f %f %f\n", head.x, head.y, head.z);
       fprintf(fp, "76 %f\n", length);
       fprintf(fp, "82 %f\n", radius);
       fprintf(fp, "67 %f %f %f\n", r, g, b);

       /* Position aktualisieren */
       pos.x += head.x * length;
       pos.y += head.y * length;
       pos.z += head.z * length;

       if (zusatz_c != 1.0)
       {
         length = helpzusatz;
       }
     }
     break;


case 'f': /* move forward without drawing a line */

     if (zusatz_c != 1.0)
     {
       helpzusatz = length;
       length = zusatz_c * length;
     }

     pos.x += head.x * length;
     pos.y += head.y * length;
     pos.z += head.z * length;

     if (count_vertex > 0)
     {
       if ( (fabs(pos.x - t1.x) > 0.00001) ||
            (fabs(pos.y - t1.y) > 0.00001) ||
            (fabs(pos.z - t1.z) > 0.00001)  )
       {
         fprintf(fp, "80 %f %f %f\n", pos.x, pos.y, pos.z);
         count_vertex ++;
       }
     }

     if (zusatz_c != 1.0)
     {
       length = helpzusatz;
     }
     break;


case '+': /* turn left by turtle->angle */

     if (zusatz_c != 1.0)
     {
       helpzusatz = angle;
       helpsin = sin_d;
       helpcos = cos_d;
       angle = zusatz_c;
       angle_b = angle * PI / 180;
       sin_d = sin(angle_b);
       cos_d = cos(angle_b);
     }

     hhelp.x =  head.x * cos_d + left.x * sin_d;
     hhelp.y =  head.y * cos_d + left.y * sin_d;
     hhelp.z =  head.z * cos_d + left.z * sin_d;
     lhelp.x = -head.x * sin_d + left.x * cos_d;
     lhelp.y = -head.y * sin_d + left.y * cos_d;
     lhelp.z = -head.z * sin_d + left.z * cos_d;
     head = hhelp;
     left = lhelp;

     if (zusatz_c != 1.0)
     {
       angle = helpzusatz;
       sin_d = helpsin;
       cos_d = helpcos;
     }
     break;


case '-': /* turn right by turtle->angle */

     if (zusatz_c != 1.0)
     {
       helpzusatz = angle;
       helpsin = sin_d;
       helpcos = cos_d;
       angle = zusatz_c;
       angle_b = angle * PI / 180;
       sin_d = sin(angle_b);
       cos_d = cos(angle_b);
     }

     hhelp.x = head.x * cos_d - left.x * sin_d;
     hhelp.y = head.y * cos_d - left.y * sin_d;
     hhelp.z = head.z * cos_d - left.z * sin_d;
     lhelp.x = head.x * sin_d + left.x * cos_d;
     lhelp.y = head.y * sin_d + left.y * cos_d;
     lhelp.z = head.z * sin_d + left.z * cos_d;
     head = hhelp;
     left = lhelp;

     if (zusatz_c != 1.0)
     {
       angle = helpzusatz;
       sin_d = helpsin;
       cos_d = helpcos;
     }
     break;


case '&': /* pitch down */

     if (zusatz_c != 1.0)
     {
       helpzusatz = angle;
       helpsin = sin_d;
       helpcos = cos_d;
       angle = zusatz_c;
       angle_b = angle * PI / 180;
       sin_d = sin(angle_b);
       cos_d = cos(angle_b);
     }

     hhelp.x = head.x * cos_d - up.x * sin_d;
     hhelp.y = head.y * cos_d - up.y * sin_d;
     hhelp.z = head.z * cos_d - up.z * sin_d;
     uhelp.x = head.x * sin_d + up.x * cos_d;
     uhelp.y = head.y * sin_d + up.y * cos_d;
     uhelp.z = head.z * sin_d + up.z * cos_d;
     head = hhelp;
     up   = uhelp;
     if (zusatz_c != 1.0)
     {
       angle = helpzusatz;
       sin_d = helpsin;
       cos_d = helpcos;
     }
     break;


case '^': /* pitch up */

     if (zusatz_c != 1.0)
     {
       helpzusatz = angle;
       helpsin = sin_d;
       helpcos = cos_d;
       angle = zusatz_c;
       angle_b = angle * PI / 180;
       sin_d = sin(angle_b);
       cos_d = cos(angle_b);
     }

     hhelp.x =  head.x * cos_d + up.x * sin_d;
     hhelp.y =  head.y * cos_d + up.y * sin_d;
     hhelp.z =  head.z * cos_d + up.z * sin_d;
     uhelp.x = -head.x * sin_d + up.x * cos_d;
     uhelp.y = -head.y * sin_d + up.y * cos_d;
     uhelp.z = -head.z * sin_d + up.z * cos_d;
     head = hhelp;
     up   = uhelp;

     if (zusatz_c != 1.0)
     {
       angle = helpzusatz;
       sin_d = helpsin;
       cos_d = helpcos;
     }
     break;


case 92: /* Ascii-Zeichen: \  , roll left*/

     if (zusatz_c != 1.0)
     {
       helpzusatz = angle;
       helpsin = sin_d;
       helpcos = cos_d;
       angle = zusatz_c;
       angle_b = angle * PI / 180;
       sin_d = sin(angle_b);
       cos_d = cos(angle_b);
     }

     lhelp.x = left.x * cos_d - up.x * sin_d;
     lhelp.y = left.y * cos_d - up.y * sin_d;
     lhelp.z = left.z * cos_d - up.z * sin_d;
     uhelp.x = left.x * sin_d + up.x * cos_d;
     uhelp.y = left.y * sin_d + up.y * cos_d;
     uhelp.z = left.z * sin_d + up.z * cos_d;
     left = lhelp;
     up   = uhelp;

     if (zusatz_c != 1.0)
     {
       angle = helpzusatz;
       sin_d = helpsin;
       cos_d = helpcos;
     }
     break;


case '/': /* roll right */

     if (zusatz_c != 1.0)
     {
       helpzusatz = angle;
       helpsin = sin_d;
       helpcos = cos_d;
       angle = zusatz_c;
       angle_b = angle * PI / 180;
       sin_d = sin(angle_b);
       cos_d = cos(angle_b);
     }

     lhelp.x =  left.x * cos_d + up.x * sin_d;
     lhelp.y =  left.y * cos_d + up.y * sin_d;
     lhelp.z =  left.z * cos_d + up.z * sin_d;
     uhelp.x = -left.x * sin_d + up.x * cos_d;
     uhelp.y = -left.y * sin_d + up.y * cos_d;
     uhelp.z = -left.z * sin_d + up.z * cos_d;
     left = lhelp;
     up   = uhelp;

     if (zusatz_c != 1.0)
     {
       angle = helpzusatz;
       sin_d = helpsin;
       cos_d = helpcos;
     }
     break;


case '|': /* turn around */
     head.x = -head.x;
     head.y = -head.y;
     head.z = -head.z;
     left.x = -left.x;
     left.y = -left.y;
     left.z = -left.z;
     break;


case '$': /* rotate turtle to vertical */
     if ((head.x != 0) || (head.z != 0))
     {
       betrag = 1 / (sqrt(head.x * head.x + head.z * head.z));
       left.x = head.z / betrag;
       left.y = 0;
       left.z = -head.x / betrag;
       up.x = -head.x * head.y;
       up.y = head.x * head.x + head.z * head.z;
       up.z = -head.y * head.z;
     }
     break;


case '[': /* start a branch */
     fprintf(fp, "91\n");

     state = (STACKTURTLE *)malloc(sizeof(STACKTURTLE));
     if (state == NULL)
     {
       fprintf(stderr, "Kein Speicher mehr frei!\n");
       fprintf(stderr, "malloc-Aufruf in save_object_to_file\n");
       exit(1);
     }
     state->position = pos;
     state->head     = head;
     state->left     = left;
     state->up       = up;
     state->stem     = radius;
     state->color    = farb_index;

     state->next     = s_ptr;
     s_ptr           = state;
     break;


case ']': /* complete a branch */
     fprintf(fp, "93\n");

     state  = s_ptr;
     s_ptr  = state->next;

     pos    = state->position;
     head   = state->head;
     left   = state->left;
     up     = state->up;
     radius = state->stem;
     farb_index = state->color;
     free(state);

     /* farb_index in entsprechende rgb-Werte umrechnen */
     r = ((double)(owncolor[farb_index].red)) / 65535;
     g = ((double)(owncolor[farb_index].green)) / 65535;
     b = ((double)(owncolor[farb_index].blue)) / 65535;
     break;


case '{': /* start a filled polygon */
     count_vertex = 1;
     t1 = pos;
     fprintf(fp, "123\n");
     fprintf(fp, "67 %f %f %f\n", r, g, b);
     fprintf(fp, "80 %f %f %f\n", pos.x, pos.y, pos.z);
     break;


case '.': /* mark a polygon vertex */
     if (count_vertex > 0)
     {
       if ( (fabs(pos.x - t1.x) > 0.00001) ||
            (fabs(pos.y - t1.y) > 0.00001) ||
            (fabs(pos.z - t1.z) > 0.00001)  )
       {
         fprintf(fp, "80 %f %f %f\n", pos.x, pos.y, pos.z);
         count_vertex ++;
       }
     }
     break;


case 'G': /* equ. to 'F', without marking a polygon vertex */

     if (count_vertex > 0)
     {
       if (zusatz_c != 1.0)
       {
         helpzusatz = length;
         length = zusatz_c * length;
       }

       /* Position aktualisieren */
       pos.x += head.x * length;
       pos.y += head.y * length;
       pos.z += head.z * length;

       if (zusatz_c != 1.0)
       {
         length = helpzusatz;
       }
     }
     break;


case '}': /* end a filled polygon */

     fprintf(fp, "125\n");
     count_vertex = 0;
     break;


case 39: /* Ascii-Zeichen: ' , increment current color index */

     if (count_vertex == 0)
     {
       if (zusatz_c == 1.0)
       {
         if (farb_index < (NOC-1))
         {
           farb_index ++;
         }
         else
         { 
           farb_index = 0;
         }
       }
       else
       {
         farb_index = zusatz_c;
         if (farb_index >= NOC)
         {
           farb_index = 0;
         }
       }

       /* farb_index in entsprechende rgb-Werte umrechnen */
       r = ((double)(owncolor[farb_index].red)) / 65535;
       g = ((double)(owncolor[farb_index].green)) / 65535;
       b = ((double)(owncolor[farb_index].blue)) / 65535;
     }
     break;


case 96: /* Ascii-Zeichen: ` , decrement current color index */

     if (count_vertex == 0)
     {
       if (zusatz_c == 1.0)
       {
         if (farb_index > 0)
         {
           farb_index --;
         }
         else
         {
           farb_index = NOC - 1;
         }
       }
       else
       {
         farb_index = zusatz_c;       
         if (farb_index >= NOC)
         {
           farb_index = 0;
         }
       }

       /* farb_index in entsprechende rgb-Werte umrechnen */
       r = ((double)(owncolor[farb_index].red)) / 65535;
       g = ((double)(owncolor[farb_index].green)) / 65535;
       b = ((double)(owncolor[farb_index].blue)) / 65535;
     }  
     break;


case '!': /* decrement diameter of segment */
     if (radius > 0.01)
     {
       radius -= 0.01;
     }
     else
     {
       radius /= 2;
     }
     break;


} /* end switch */


elemptr = elemptr->next;
} /* end while */

  /*+++++++++++++++++++++++++++++++++++++++++++++++++++*/

  fprintf(fp, "200");

  if (fclose(fp))
  {
    fprintf(stderr, "Datei konnte nicht geschlossen werden\n");
    fprintf(stderr, "fclose in save_object_to_parfile\n");
    exit(1);
  }

  free(parfile);

}

/***********************************************************************/
/***********************************************************************/
/***********************************************************************/
/* Function Name: 
 * Description: 
 * Arguments: 
 * Globals: 
 * Returns: 
 */
/***********************************************************************/

