/*************************************************************************/
/*
 *
 *  Filename:  turtle.c
 *
 */

#include "grammar.h"

#include <malloc.h>
#include <math.h>
#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>


/* functions in turtle.c 
 *
 * void    clear_draw_pixmap();
 * void    init_drawing();
 * void    turtle_2D();
 * Boolean turtlesymbol_2d();
 * XPoint  persp();
 * void    turtle_3D();
 * Boolean turtlesymbol_3d();
 * 
 */

extern Widget    drawing;

extern double CO[361], SI[361];

extern REGELN   *grammar;
extern SYMBOLE  *word;
extern SYMBOLE  *current_symbol;

extern int       color_index;

extern XColor owncolor[NOC];
extern TURTLE_VALUES *turtle;

extern Widget g_stop, g_ok,
              nextderiv, prevderiv, singlesymbol, continuesymbol;

extern XtAppContext app_context;

extern Boolean anhalten;

extern int count_deriv;

extern int persp_x0, persp_y0, persp_a;


/* globale Variablen */

STACK2 *state2;
STACK3 *state3;
STACK  *poly_point;

Display  *display;
int       screen;
GC        draw_gc;
Pixmap    draw_pixmap;
Dimension draw_width, draw_height;

POINT     position;
POINT     head, left, up;
double    length;

/*************************************************************************/
/* Function Name: clear_draw_pixmap
 * Description: loescht den Inhalt von draw_pixmap
 * Globals: display
 *          screen
 *          draw_gc
 *          draw_pixmap
 *          draw_width
 *          draw_height
 *          owncolor
 */

void clear_draw_pixmap()
{
  unsigned long black, white;

  black = XBlackPixel(display, screen);
  white = XWhitePixel(display, screen);

  XSetBackground(display, draw_gc, white);
  XSetForeground(display, draw_gc, white);

  XFillRectangle(display, draw_pixmap, draw_gc,
                 0,0,
                 (int)draw_width,(int)draw_height);

  if (DefaultDepth(display, screen) != 1)
  {
    XSetForeground(display, draw_gc, owncolor[0].pixel);
  }
  else
  {
    XSetForeground(display, draw_gc, black);
  }
}

/*************************************************************************/
/* Function Name: init_drawing
 * Description: bereitet drawing und draw_pixmap fuer die Ausgabe der 
 *              Bilder vor
 * Arguments: topLevel - fuer display-Fkt.
 *            drawing - fuer Pixmap-Init.
 * Globals: display
 *          screen
 *          draw_gc
 *          draw_pixmap
 *          draw_width
 *          draw_height
 */

void init_drawing(topLevel,drawing)
Widget topLevel, drawing;
{
  void clear_draw_pixmap();

  display = XtDisplay(topLevel);
  screen = XDefaultScreen(display);

  XtVaGetValues(drawing,
                XtNheight, &draw_height,
                XtNwidth , &draw_width,
                NULL);

  draw_pixmap = XCreatePixmap(
                 display,                      /* Display */
                 RootWindowOfScreen(XtScreen(topLevel)),     /*  */
                 (int) draw_width,             /* width of pixmap */
                 (int) draw_height,            /* height of pixmap */
                 DefaultDepthOfScreen(XtScreen(topLevel)));  /*  */

  draw_gc = XCreateGC(display,
                      draw_pixmap,
                      0,0);

  clear_draw_pixmap();
}

/*************************************************************************/
/* Function Name: turtle_2D
 * Description: liest die Symbole aus charstring und zeichnet das 
 *              zugehoerige Bild der Turtle-Symbole in draw_pixmap; 
 *              draw_pixmap wird nach Bearbeiten von string auf 
 *              drawing kopiert
 * Arguments: drawing - Widget, in das draw_pixmap kopiert wird
 *            str - enthaelt nur 2D Turtle-Symbole
 *            count_deriv - Ableitungsstufe
 *            turtle - Struktur, die Turtle-Werte enthaelt
 * Globals: display
 *          draw_pixmap
 *          draw_gc
 *          draw_width
 *          draw_height
 *          state2
 * Returns: none
 */

void turtle_2D(drawing, count_deriv, turtle)
Widget drawing;
int count_deriv;
TURTLE_VALUES *turtle;
{
  int length_of_word;
  XtWorkProcId wp_id_2d;

  void clear_draw_pixmap();
  Boolean turtlesymbol_2d();

  state2 = (STACK2 *)malloc(sizeof(STACK2));
  if (state2 == NULL)
  {
    fprintf(stderr, "Kein Speicher mehr frei!\n");
    fprintf(stderr, "malloc-Aufruf in turtle_2D\n");
    exit(1);
  }

  clear_draw_pixmap();

  XCopyArea(display, draw_pixmap, XtWindow(drawing), draw_gc,
            0,0, (int)draw_width, (int)draw_height, 0,0);
 
  position = turtle->pos;
  head     = turtle->h;
  length   = turtle->length * pow((1/turtle->scale), (double)count_deriv);

  length_of_word = listlength(word);

  wp_id_2d = XtAppAddWorkProc(
                  app_context, turtlesymbol_2d, (int *)(length_of_word));

  XtSetSensitive(g_stop, TRUE);
  XtSetSensitive(g_ok, FALSE);
  XtSetSensitive(nextderiv, FALSE);
  XtSetSensitive(prevderiv, FALSE);
  XtSetSensitive(singlesymbol, FALSE);
  XtSetSensitive(continuesymbol, FALSE);
}

/*************************************************************************/
/* Function Name: turtlesymbol_2d
 * Description: 
 * Arguments: 
 * Globals: 
 * Returns: 
 */

/* ARGSUSED */
Boolean turtlesymbol_2d(client_data)
XtPointer client_data;
{
  static int k = 0;
  int ll = (int)client_data; /* length of list 'word' */
  SYMBOLE *elemptr;
  int i;                     /* Schleifenvariable */
  char c;                    /* Turtle-Symbol */
  double zusatz_c;           /* Zusatz zum Turtle-Symbol */
  double helpzusatz;         /* Zwischenspeicher fuer Wert, der durch
                                Zusatz != 1 temporaer veraendert wird */

  static double sum_angle = 0; /* aufsummierter Winkel */
  double angle_d;
  double sin_d, cos_d;

  XPoint xstart, xend;       /* 2 Punkte fuer Strecke 'F' bzw. 'f' */
  POINT hilfe;               /* Zwischenspeicher fuer head */

  if (k < ll && !anhalten)
  {
    /* Lesen des k-ten Symbols in der Liste von word */
    elemptr = word;
    for (i=0; i<k; i++)
    {
      elemptr = elemptr->next;
    }
    c = elemptr->symb;
    zusatz_c = elemptr->zusatz;

    if ((elemptr == current_symbol) && (elemptr != word))
    {
      /* Restwort bei Teilableitung erreicht */
      /* auf alte Laenge fuer F und f umschalten */
      if (count_deriv > 0)
      {
        length = turtle->length * 
                  pow((1/turtle->scale), (double)(count_deriv-1));
      }
    }

    /* Verarbeitung des gelesenen Symbols, ggf. mit Zusatz '<..>' */
    switch(c)
    {
    case 'F': /* move forward and draw line */

              if (zusatz_c != 1.0)
              {
                helpzusatz = length;
                length = zusatz_c * length;
              }

              xstart.x = (int)(position.x);
              xstart.y = (int)(draw_height - position.y);

              position.x += length*head.x;
              position.y += length*head.y;

              xend.x = (int)(position.x);
              xend.y = (int)(draw_height - position.y);

              XDrawLine(display, draw_pixmap, draw_gc,
                        xstart.x, xstart.y, xend.x, xend.y);

              XDrawLine(display, XtWindow(drawing), draw_gc,
                        xstart.x, xstart.y, xend.x, xend.y);

              if (zusatz_c != 1.0)
              {
                length = helpzusatz;
              }
              break;

    case 'f': /* move forward without drawing a line */

              if (zusatz_c != 1.0)
              {
                helpzusatz = length;
                length = zusatz_c * length;
              }

              position.x += length*head.x;
              position.y += length*head.y;

              if (zusatz_c != 1.0)
              {
                length = helpzusatz;
              }
              break;

    case '+': /* turn left by angle_d */

              if (zusatz_c != 1.0)
              {
                helpzusatz = turtle->angle;
                turtle->angle = zusatz_c;
              }

              sum_angle += turtle->angle;
              if (sum_angle >= 360) sum_angle -= 360;

              if (sum_angle < 0)
              {
                angle_d = sum_angle + 360;
              }
              else
              {
                angle_d = sum_angle;
              }
              if (angle_d - (int)(angle_d) == 0)
              {
                /* in Tabelle nachschauen */
                sin_d = SI[(int)(angle_d)];
                cos_d = CO[(int)(angle_d)];
              }
              else 
              {
                /* Werte berechnen */
                angle_d = (angle_d * PI / 180);
                sin_d = sin(angle_d);
                cos_d = cos(angle_d);
              }

              hilfe.x = turtle->h.x*cos_d - turtle->h.y*sin_d;
              hilfe.y = turtle->h.x*sin_d + turtle->h.y*cos_d;
              head = hilfe;

              if (zusatz_c != 1.0)
              {
                turtle->angle = helpzusatz;
              }
              break;


    case '-': /* turn right by angle_d */

              if (zusatz_c != 1.0)
              {
                helpzusatz = turtle->angle;
                turtle->angle = zusatz_c;
              }

              sum_angle -= turtle->angle;
              if (sum_angle <= -360) sum_angle += 360;

              if (sum_angle < 0)
              {
                angle_d = sum_angle + 360;
              }
              else
              {
                angle_d = sum_angle;
              }
              if (angle_d - (int)(angle_d) == 0)
              {
                /* in Tabelle nachschauen */
                sin_d = SI[(int)(angle_d)];
                cos_d = CO[(int)(angle_d)];
              }
              else 
              {
                /* Werte berechnen */
                angle_d = (angle_d * PI/ 180);
                sin_d = sin(angle_d);
                cos_d = cos(angle_d);
              }
              hilfe.x = turtle->h.x*cos_d - turtle->h.y*sin_d;
              hilfe.y = turtle->h.x*sin_d + turtle->h.y*cos_d;
              head = hilfe;

              if (zusatz_c != 1.0)
              {
                turtle->angle = helpzusatz;
              }
              break;


    case '|': /* turn back */
              hilfe = head;
              head.x = -hilfe.x;
              head.y = -hilfe.y;
              break;


    case '[': /* push current state2 of the turtle */
              state2->position  = position;
              state2->head      = head;
              state2->sum_angle = sum_angle;
              state2->color     = color_index;
              push_2d(state2);
              break;


    case ']': /* pop a state2 from the stack */
              state2 = pop_2d();
              position    = state2->position;
              head        = state2->head;
              sum_angle   = state2->sum_angle;
              color_index = state2->color;
              break;


    case 39:  /* Ascii-Zeichen: ' */
              /* increment the current color index */

              if (DefaultDepth(display,screen) != 1)
              {
                if (zusatz_c == 1.0)
                { 
                  if (color_index < (NOC-1))
                  {
                    color_index ++;
                  }
                  else
                  {
                    color_index = 0;
                  }
                }
                else
                {
                  color_index = zusatz_c;  
                  if (color_index >= NOC)
                  {
                    color_index = 0;
                  }
                }
                XSetForeground(display, draw_gc, owncolor[color_index].pixel);
              }
              break;


    case 96:  /* Ascii-Zeichen: ` */
              /* decrement the current color index */

              if (DefaultDepth(display,screen) != 1)
              {
                if (zusatz_c == 1.0)
                {
                  if (color_index > 0)
                  {
                    color_index --;
                  }
                  else
                  {
                    color_index = NOC - 1;
                  }
                }
                else
                {
                  color_index = zusatz_c; /* war bisher -= */ 
                  if (color_index >= NOC)
                  {
                    color_index = 0;
                  }
                }
                XSetForeground(display, draw_gc, owncolor[color_index].pixel);
              }
              break;


    } /* end switch */

    k++;

    return FALSE;
  }


  if (k == ll)
  {
    /* Wortende erreicht */
    k = 0;
    sum_angle = 0;
    free(state2);

    XCopyArea(display, draw_pixmap, XtWindow(drawing), draw_gc,
              0,0, (int)draw_width, (int)draw_height, 0,0);
    XtSetSensitive(g_stop, FALSE);
    XtSetSensitive(g_ok, TRUE);
    XtSetSensitive(singlesymbol, TRUE);

    if (count_deriv > 0) XtSetSensitive(prevderiv, TRUE);

    if (word == current_symbol)
    {
      XtSetSensitive(nextderiv, TRUE);
    }
    else
    {
      XtSetSensitive(continuesymbol, TRUE);
    }

    return TRUE;
  }


  if (anhalten)
  {
    k = 0;
    sum_angle = 0;
    free(state2);

    XtSetSensitive(g_ok, TRUE);
    XtSetSensitive(g_stop, FALSE);
    XtSetSensitive(prevderiv, TRUE);
    anhalten = FALSE;
    return TRUE;
  }
}

/*************************************************************************/
/* Function Name: persp
 * Description: berechnet die projizierten Koordinaten eines Punktes
 *              (Zentralprojektion)
 * Arguments: punkt - (x, y, z) - Koordinaten
 * Globals: draw_height, persp_x0, persp_y0, persp_a
 * Returns: bildpunkt - projizierte Koordinaten (x, y) von punkt
 */

XPoint persp(punkt)
POINT punkt;
{
  XPoint bildpunkt;
  double w;

  w = punkt.z / persp_a + 1;

  /* Projektion */
  bildpunkt.x =  persp_x0 + (int)(punkt.x / w);
  bildpunkt.y = (draw_height - persp_y0) - (int)(punkt.y / w);

  return bildpunkt;
}

/*************************************************************************/
/* Function Name: turtle_3D
 * Description: liest die Symbole aus string und zeichnet das zugehoerige
 *              Bild der Turtle-Symbole in draw_pixmap; draw_pixmap wird
 *              nach Bearbeiten von string auf drawing kopiert
 * Arguments: drawing - Widget, in das draw_pixmap kopiert wird
 *            str  - enthaelt 3D Turtle-Symbole
 *            count_deriv - Ableitungsstufe
 *            turtle - Struktur, die Turtle-Werte enthaelt
 * Globals: display
 *          draw_pixmap
 *          draw_gc
 *          draw_width
 *          draw_height
 * Returns: none
 */

void turtle_3D(drawing, count_deriv, turtle)
Widget drawing;
int count_deriv;
TURTLE_VALUES *turtle;
{
  int length_of_word;
  XtWorkProcId wp_id_3d;

  void clear_draw_pixmap();
  int  listlength();
  Boolean turtlesymbol_3d();

  state3 = (STACK3 *)malloc(sizeof(STACK3));
  if (state3 == NULL)
  {
    fprintf(stderr, "Kein Speicher mehr frei!\n");
    fprintf(stderr, "malloc-Aufruf in turtle_3D\n");
    exit(1);
  }

  clear_draw_pixmap();

  XCopyArea(display, draw_pixmap, XtWindow(drawing), draw_gc,
            0,0, (int)draw_width, (int)draw_height, 0,0);

  position = turtle->pos;
  head = turtle->h;
  left = turtle->l;
  up   = turtle->u;

  color_index = 0;

  length = turtle->length * pow((1/turtle->scale), (double)count_deriv);

  length_of_word = listlength(word);

  wp_id_3d = XtAppAddWorkProc(
               app_context,turtlesymbol_3d,(int *)(length_of_word));

  XtSetSensitive(g_stop, TRUE);
  XtSetSensitive(g_ok, FALSE);
  XtSetSensitive(nextderiv, FALSE);
  XtSetSensitive(prevderiv, FALSE);
  XtSetSensitive(singlesymbol, FALSE);
  XtSetSensitive(continuesymbol, FALSE);
}

/*************************************************************************/
/* Function Name: turtlesymbol_3d
 * Description: 
 * Arguments: 
 * Globals: 
 * Returns: 
 */

Boolean turtlesymbol_3d(client_data)
XtPointer client_data;
{
  static int m = 0;
  int ll = (int)client_data; /* length of list 'word' */
  SYMBOLE *elemptr;
  int i;                     /* Schleifenvariable */
  char c;                    /* Turtle-Symbol */
  double zusatz_c;           /* Zusatz zum Turtle-Symbol */  
  double helpzusatz;         /* Zwischenspeicher fuer Wert, der durch
                                Zusatz != 1 temporaer veraendert wird */

  double angle_d;
  double sin_d, cos_d;

  XPoint xstart, xend;       /* 2 Punkte fuer Strecke 'F' bzw. 'f' */
  POINT start, end;          /* projizierte Werte fuer xstart/xend */

  POINT hhilfe,              /* Zwischenspeicher fuer head */
        lhilfe,              /* Zwischenspeicher fuer left */
        uhilfe;              /* Zwischenspeicher fuer up */

  double betrag;             /* Betrag eines Vektors, bei '$' noetig */

  XPoint *points;     /* Array fuer Polygonpunkte */
  static int npoints = 0;    /* zaehlt Punkte eines Polygons */
  int j;                     /* Schleifenvariable */

  if (m < ll && !anhalten)
  {
    /* Lesen der m-ten Symbols in der Liste von word */
    elemptr = word;
    for (i=0; i<m; i++)
    {
      elemptr = elemptr->next;
    }
    c = elemptr->symb;
    zusatz_c = elemptr->zusatz;

    if ((elemptr == current_symbol) && (elemptr != word))
    {
      /* Restwort bei Teilableitung erreicht */
      /* auf alte Laenge fuer F und f umschalten */
      if (count_deriv > 0)
      {
        length = turtle->length * 
                  pow((1/turtle->scale), (double)(count_deriv-1));
      }
    }

    angle_d = turtle->angle;
    if (angle_d - (int)(angle_d) == 0)
    {
      /* in Tabelle nachschauen */
      sin_d = SI[(int)(angle_d)];
      cos_d = CO[(int)(angle_d)];
    }
    else
    {
      /* Werte berechnen */
      angle_d = (angle_d * PI / 180);
      sin_d = sin(angle_d);
      cos_d = cos(angle_d);
    }

    /* Verarbeitung des gelesenen Symbols, ggf. mit Zusatz '<..>' */
    switch(c)
    {
    case 'F': /* move forward and draw line */

              if (zusatz_c != 1.0)
              {
                helpzusatz =length;
                length = zusatz_c * length;
              }

              start = position;
              xstart = persp(start);

              position.x += length * head.x;
              position.y += length * head.y;
              position.z += length * head.z;

              end = position;
              xend = persp(end);

              XDrawLine(display, draw_pixmap, draw_gc,
                        xstart.x, xstart.y, xend.x, xend.y);

              XDrawLine(display, XtWindow(drawing), draw_gc,
                        xstart.x, xstart.y, xend.x, xend.y);

              if (zusatz_c != 1.0)
              {
                length = helpzusatz;
              }
              break;
 

    case 'f': /* move forward without drawing a line */

              if (zusatz_c != 1.0)
              {
                helpzusatz = length;
                length = zusatz_c * length;
              }

              position.x += length * head.x;
              position.y += length * head.y;
              position.z += length * head.z;

              if (zusatz_c != 1.0)
              {
                length = helpzusatz;
              }

              if (npoints > 0)
              {
                /* f taucht innerhalb von '{', '}' auf */
                poly_point = (STACK *)malloc(sizeof(STACK));
                if (poly_point == NULL)
                {
                   fprintf(stderr, "Kein Speicher mehr frei!\n");
                   fprintf(stderr, "malloc-Aufruf in turtlesymbol_3d\n");
                   exit(1);
                }
                poly_point->position = position;
                push_point(poly_point);
                npoints ++;
              }
              break;


    case '+': /* turn left by angle_d */
              /* Rotationsmatrix Ru mit Winkel d bzw. (360-d) */

              if (zusatz_c != 1.0)
              {
                angle_d = zusatz_c;

                if (angle_d - (int)(angle_d) == 0)
                {
                  /* in Tabelle nachschauen */
                  sin_d = SI[(int)(angle_d)];
                  cos_d = CO[(int)(angle_d)];
                }
                else
                {
                  /* Werte berechnen */
                  angle_d = (angle_d * PI / 180);
                  sin_d = sin(angle_d);
                  cos_d = cos(angle_d);
                }
              }

              hhilfe.x =  head.x * cos_d + left.x * sin_d;
              hhilfe.y =  head.y * cos_d + left.y * sin_d;
              hhilfe.z =  head.z * cos_d + left.z * sin_d;
              lhilfe.x = -head.x * sin_d + left.x * cos_d;
              lhilfe.y = -head.y * sin_d + left.y * cos_d;
              lhilfe.z = -head.z * sin_d + left.z * cos_d;
              head = hhilfe;
              left = lhilfe;

              break;


    case '-': /* turn right by angle_d */
              /* Rotationsmatrix Ru mit Winkel -d */

              if (zusatz_c != 1.0)
              {
                angle_d = zusatz_c;

                if (angle_d - (int)(angle_d) == 0)
                {
                  /* in Tabelle nachschauen */
                  sin_d = SI[(int)(angle_d)];
                  cos_d = CO[(int)(angle_d)];
                }
                else
                {
                  /* Werte berechnen */
                  angle_d = (angle_d * PI / 180);
                  sin_d = sin(angle_d);
                  cos_d = cos(angle_d);
                }
              }
 
              hhilfe.x = head.x * cos_d - left.x * sin_d;
              hhilfe.y = head.y * cos_d - left.y * sin_d;
              hhilfe.z = head.z * cos_d - left.z * sin_d;
              lhilfe.x = head.x * sin_d + left.x * cos_d;
              lhilfe.y = head.y * sin_d + left.y * cos_d;
              lhilfe.z = head.z * sin_d + left.z * cos_d;
              head = hhilfe;
              left = lhilfe;

              break;


    case '&': /* pitch down */
              /* Rotationsmatrix Rl mit Winkel d */

              if (zusatz_c != 1.0)
              {
                angle_d = zusatz_c;

                if (angle_d - (int)(angle_d) == 0)
                {
                  /* in Tabelle nachschauen */
                  sin_d = SI[(int)(angle_d)];
                  cos_d = CO[(int)(angle_d)];
                }
                else
                {
                  /* Werte berechnen */
                  angle_d = (angle_d * PI / 180);
                  sin_d = sin(angle_d);
                  cos_d = cos(angle_d);
                }
              }

              hhilfe.x = head.x * cos_d - up.x * sin_d;
              hhilfe.y = head.y * cos_d - up.y * sin_d;
              hhilfe.z = head.z * cos_d - up.z * sin_d;
              uhilfe.x = head.x * sin_d + up.x * cos_d;
              uhilfe.y = head.y * sin_d + up.y * cos_d;
              uhilfe.z = head.z * sin_d + up.z * cos_d;
              head = hhilfe;
              up   = uhilfe;  

              break;


    case '^': /* pitch up */
              /* Rotationsmatrix Rl mit Winkel -d */

              if (zusatz_c != 1.0)
              {
                angle_d = zusatz_c;

                if (angle_d - (int)(angle_d) == 0)
                {
                  /* in Tabelle nachschauen */
                  sin_d = SI[(int)(angle_d)];
                  cos_d = CO[(int)(angle_d)];
                }
                else
                {
                  /* Werte berechnen */
                  angle_d = (angle_d * PI / 180);
                  sin_d = sin(angle_d);
                  cos_d = cos(angle_d);
                }
              }

              hhilfe.x =  head.x * cos_d + up.x * sin_d;
              hhilfe.y =  head.y * cos_d + up.y * sin_d;
              hhilfe.z =  head.z * cos_d + up.z * sin_d;
              uhilfe.x = -head.x * sin_d + up.x * cos_d;
              uhilfe.y = -head.y * sin_d + up.y * cos_d;
              uhilfe.z = -head.z * sin_d + up.z * cos_d;
              head = hhilfe;
              up   = uhilfe;  

              break;


    case 92:  /* Ascii-Zeichen: \  */
              /* roll left */
              /* Rotationsmatrix Rh mit Winkel d */

              if (zusatz_c != 1.0)
              {
                angle_d = zusatz_c;

                if (angle_d - (int)(angle_d) == 0)
                {
                  /* in Tabelle nachschauen */
                  sin_d = SI[(int)(angle_d)];
                  cos_d = CO[(int)(angle_d)];
                }
                else
                {
                  /* Werte berechnen */
                  angle_d = (angle_d * PI / 180);
                  sin_d = sin(angle_d);
                  cos_d = cos(angle_d);
                }
              }

              lhilfe.x = left.x * cos_d - up.x * sin_d;
              lhilfe.y = left.y * cos_d - up.y * sin_d;
              lhilfe.z = left.z * cos_d - up.z * sin_d;
              uhilfe.x = left.x * sin_d + up.x * cos_d;
              uhilfe.y = left.y * sin_d + up.y * cos_d;
              uhilfe.z = left.z * sin_d + up.z * cos_d;
              left = lhilfe;
              up   = uhilfe;  

              break;


    case '/': /* roll right */
              /* Rotationsmatrix Rh mit Winkel -d */

              if (zusatz_c != 1.0)
              {
                angle_d = zusatz_c;

                if (angle_d - (int)(angle_d) == 0)
                {
                  /* in Tabelle nachschauen */
                  sin_d = SI[(int)(angle_d)];
                  cos_d = CO[(int)(angle_d)];
                }
                else
                {
                  /* Werte berechnen */
                  angle_d = (angle_d * PI / 180);
                  sin_d = sin(angle_d);
                  cos_d = cos(angle_d);
                }
              }

              lhilfe.x =  left.x * cos_d + up.x * sin_d;
              lhilfe.y =  left.y * cos_d + up.y * sin_d;
              lhilfe.z =  left.z * cos_d + up.z * sin_d;
              uhilfe.x = -left.x * sin_d + up.x * cos_d;
              uhilfe.y = -left.y * sin_d + up.y * cos_d;
              uhilfe.z = -left.z * sin_d + up.z * cos_d;
              left = lhilfe;
              up   = uhilfe;  

              break;


    case '|': /* turn around */
              /* Rotationsmatrix Ru mit Winkel d=180 */

              head.x = -head.x;
              head.y = -head.y;
              head.z = -head.z;
              left.x = -left.x;
              left.y = -left.y;
              left.z = -left.z;
              break;

    case '$': /* rotate turtle to vertical */

              if ((head.x != 0) || (head.z != 0))
              {
                betrag = 1 / (sqrt(head.x * head.x + head.z * head.z));
                left.x = head.z / betrag;
                left.y = 0;
                left.z = -head.x / betrag;
                up.x   = -head.x * head.y;
                up.y   = head.x * head.x + head.z * head.z;
                up.z   = -head.y * head.z; 
              }
              break;

    case '[': /* start a branch */
              /* push current state3 of the turtle */

              state3->position  = position;
              state3->head      = head;
              state3->left      = left;
              state3->up        = up;
              state3->color     = color_index;
              push_3d(state3);
              break;

    case ']': /* complete a branch */
              /* pop a state3 from the stack */

              state3 = pop_3d();
              position    = state3->position;
              head        = state3->head;
              left        = state3->left;
              up          = state3->up;
              color_index = state3->color;
              if (DefaultDepth(display, screen ) != 1)
              {
                XSetForeground(display, draw_gc, owncolor[color_index].pixel);
              }
              break;


    case '{': /* start a filled polygon */

              poly_point = (STACK *)malloc(sizeof(STACK));
              if (poly_point == NULL)
              {
                fprintf(stderr, "Kein Speicher mehr frei!\n");
                fprintf(stderr, "malloc-Aufruf in turtlesymbol_3d\n");
                exit(1);
              }
              poly_point->position = position;
              push_point(poly_point);
              npoints ++;
              break;


    case '.': /* mark a polygon vertex */

              if (npoints > 0)
              {
                poly_point = (STACK *)malloc(sizeof(STACK));
                if (poly_point == NULL)
                {
                  fprintf(stderr, "Kein Speicher mehr frei!\n");
                  fprintf(stderr, "malloc-Aufruf in turtlesymbol_3d\n");
                   exit(1);
                }
                poly_point->position = position;
                push_point(poly_point);
                npoints ++;
              }
              break;


    case 'G': /* equ. to 'F', without marking a polygon vertex */

              if (npoints > 0)
              {
                if (zusatz_c != 1.0)
                {
                  helpzusatz =length;
                  length = zusatz_c * length;
                }

                start = position;
                xstart = persp(start);

                position.x += length * head.x;
                position.y += length * head.y;
                position.z += length * head.z;

                end = position;
                xend = persp(end);

                XDrawLine(display, draw_pixmap, draw_gc,
                          xstart.x, xstart.y, xend.x, xend.y);

                XDrawLine(display, XtWindow(drawing), draw_gc,
                          xstart.x, xstart.y, xend.x, xend.y);

                if (zusatz_c != 1.0)
                {
                  length = helpzusatz;
                }
              }
              break;
 
    case '}': /* end a filled polygon */

              points = (XPoint *)malloc(npoints * sizeof(XPoint));
              if (points == NULL)
              {
                fprintf(stderr, "Kein Speicher mehr frei!\n");
                fprintf(stderr, "malloc-Aufruf in turtlesymbol_3d\n");
                exit(1);
              }
              for (j=0; j<npoints; j++)
              { 
                poly_point = pop_point();
                points[j] = persp(poly_point->position);
                free(poly_point);
              }

              XFillPolygon(display, draw_pixmap, draw_gc,
                           points, npoints, Complex, CoordModeOrigin);

              XFillPolygon(display, XtWindow(drawing), draw_gc,
                           points, npoints, Complex, CoordModeOrigin);

              XDrawLines(display, draw_pixmap, draw_gc,
                           points, npoints, CoordModeOrigin);

              XDrawLines(display, XtWindow(drawing), draw_gc,
                           points, npoints, CoordModeOrigin);

              free(points);
              npoints = 0;
              break;

    case 39:  /* Ascii-Zeichen: ' */
              /* increment the current color index */


              if ((DefaultDepth(display,screen) != 1) && (npoints == 0))
              {
                if (zusatz_c == 1.0)
                { 
                  if (color_index < (NOC-1))
                  {
                    color_index ++;
                  }
                  else
                  {
                    color_index = 0;
                  }
                }
                else
                {
                  color_index = zusatz_c; 
                  if (color_index >= NOC)
                  {
                    color_index = 0;
                  }
                }
                XSetForeground(display, draw_gc, owncolor[color_index].pixel);
              }
              break;


    case 96:  /* Ascii-Zeichen: ` */
              /* decrement the current color index */

              if ((DefaultDepth(display,screen) != 1) && (npoints == 0))
              {
                if (zusatz_c == 1.0)
                {
                  if (color_index > 0)
                  {
                    color_index --;
                  }
                  else
                  {
                    color_index = NOC - 1;
                  }
                }
                else
                {
                  color_index = zusatz_c;           
                  if (color_index >= NOC)
                  {
                    color_index = 0;
                  }
                }
                XSetForeground(display, draw_gc, owncolor[color_index].pixel);
              }
              break;


    } /* end switch */

    m ++;
    return FALSE;
  }

  if (m == ll)
  {
    /* Wortende erreicht */
    m = 0;
    free(state3);

    npoints = 0;

    XCopyArea(display, draw_pixmap, XtWindow(drawing), draw_gc,
              0,0, (int)draw_width, (int)draw_height, 0,0);
    XtSetSensitive(g_stop, FALSE);
    XtSetSensitive(g_ok, TRUE);
    XtSetSensitive(singlesymbol, TRUE);

    if (count_deriv > 0) XtSetSensitive(prevderiv, TRUE);

    if (word == current_symbol)
    {
      XtSetSensitive(nextderiv, TRUE);
    }
    else
    {
      XtSetSensitive(continuesymbol, TRUE);
    }

    return TRUE;
  }

  if (anhalten)
  {
    m = 0;
    free(state3);

    npoints = 0;

    XtSetSensitive(g_ok, TRUE);
    XtSetSensitive(g_stop, FALSE);
    XtSetSensitive(prevderiv, TRUE);
    anhalten = FALSE;
    return TRUE;
  }
}

/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/* Function Name: 
 * Description: 
 * Arguments: 
 * Globals: 
 * Returns: 
 */
/*************************************************************************/


