/*************************************************************************/
/*
 *
 *  Filename:  xui.c
 *
 */

#include "grammar.h"
#include <sys/param.h>

#include <malloc.h>
#include <math.h>
#include <stdio.h>
#include <ctype.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>



/* Include files required for widgets used in this file */

#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/Viewport.h>


/* aus load.c */

extern void Load();
extern void ClickList();
extern void LoadOk();
extern void LoadCancel();


/* aus save.c */

extern void SaveOReturnOk();
extern void SaveObj();

extern Widget fileinput;


/* aus color.c */

extern char  *col_pal_name;
extern XColor owncolor[NOC];

extern void     Color();
extern void     init_color();
extern void     change_color();


/* aus functions.c */

extern REGELN  *init_grammar();
extern char    *word_to_string();
extern int      test_dimens();
extern SYMBOLE *delete_wordlist();
extern REGELN  *delete_grammarlist();
extern int      klammerung();
extern int      test_wk();


/* aus grammar.c */

extern int     klammern_pruefen();
extern void    init_word();
extern void    ableitung_wort();
extern void    ableitung_symbol();


/* aus turtle.c */

extern void    init_drawing();
extern void    turtle_2D();
extern void    turtle_3D();

extern Display  *display;
extern int       screen;
extern GC        draw_gc;
extern Pixmap    draw_pixmap;
extern Dimension draw_width, draw_height;


/* functions in xui.c */

void RestorePicture();
void Dummy();
void syntax();
void Help();
void HelpOk();
void G3D();
void Proj();
void ProjOk();
void ProjCancel();
void GOk();
void GStop();
void display_deriv();
void display_word();
void Fehler();
void NextDeriv();
void PrevDeriv();
void SingleSymbol();
void ContinueSymbol();
void Save();
void SaveSReturnOk();
void SaveOk();
void SaveCancel();
void SaveImage();
void Quit();

void save_settings_to_file();


/* global variables */

REGELN *grammar = NULL;

SYMBOLE *word = NULL,
        *current_symbol = NULL;

Boolean anhalten = FALSE; /* used once here */

String *str = NULL; /*enthaelt abgeleitete Symbole fuer Anzeige in wlist */

int count_deriv;  /* zaehlt die Ableitungen */

int dimens; /* 2D- oder 3D-Symbole in Grammatik */

TURTLE_VALUES *turtle; /* Struktur, die Turtle-Eingabewerte enthaelt */

int persp_x0, persp_y0,  /* Koordinatenursprung der Bildkoordinaten */
    persp_a;             /* Zentrum der perspektivischen Projektion */


int color_index; /* used once here */



Widget topLevel;

Widget drawing; /* Widget zur Ausgabe der erstellten Bilder */

Widget wlist;
Widget wderiv;

Widget g_posx, g_posy, g_posz,
       g_angle,
       g_length,
       g_scale,
       g_proj,
       g_3d,
       glabel,
       gram;

Widget g_headx, g_heady, g_headz,
       g_leftx, g_lefty, g_leftz,
       g_upx, g_upy, g_upz;

Widget proj_x0, proj_y0, proj_a;

Widget g_stop, g_ok;

Widget nextderiv, prevderiv,
       singlesymbol, continuesymbol;

Widget save;
Widget savesett;


XtAppContext app_context;

static String fallback_resources[] = {
 "*savesett.value.translations: #override \\n <Key>Return:SaveSReturnOk()",
 "*fileinput.value.translations:#override \\n <Key>Return:SaveOReturnOk()",
 NULL
};

XtActionsRec actionTable[] = {
    {"SaveSReturnOk", SaveSReturnOk},
    {"SaveOReturnOk", SaveOReturnOk},
 NULL
};

double CO[361], SI[361]; /* just calculated here, but not used */

/*************************************************************************/
void main(argc, argv)
int argc;
char **argv;
{
   Widget paned,       /* 1.Widget, zur Ein-/Ausgabe der Daten */ 
          popup;       /* 2.Widget, enthaelt Widget drawing */

   Widget wform,       /* Widget zur Ausgabe des aktuellen Wortes */
          wlabel,
          wview,
          wderivlabel;  

   Widget gform,       /* Widget zur Ein-/Ausgabe der Grammatik */
          gpform,
          gtform,
          gbform,
          g_color,
          g_help;

   Widget buttonform,  /* Widget, welches die Buttons enthaelt */
          quit,
          load;

   static XtActionsRec neu_wlist[] = { {"dummy", Dummy}, };


   int i;             /* Schleifenvariable */
   double winkel;     /* Winkel im Bogenmass */

  /**************************************************************/
   topLevel = XtVaAppInitialize(
           &app_context,             /* Application context */
           "LGrammar",               /* Application class */
           NULL, 0,                  /* command line option list */
           &argc, argv,              /* command line args */
           fallback_resources,       /* appl-defaults */
           NULL);                    /* terminate varargs list */
 
   XtAppAddActions(app_context, actionTable, XtNumber(actionTable));

   if (argc != 1) syntax(app_context, argv[0]);

   paned = XtVaCreateManagedWidget(
           "paned",             /* arbitrary widget name */
           panedWidgetClass,    /* widget class from Paned.h */ 
           topLevel,            /* parent widget */
           NULL);               /* terminate varargs list */ 

   popup = XtVaCreatePopupShell(
           "lgrammar_drawing",  /* arbitrary widget name */
           topLevelShellWidgetClass,   /* Widget class */
           topLevel,            /* parent widget */
           NULL);               /* terminat varargs list */

   drawing = XtVaCreateManagedWidget(       
           "drawing",           /* widget name */
           widgetClass,         /* widget class */
           popup,               /* parent widget */
           NULL);               /* terminate varargs list */

   XtAddEventHandler(
           drawing,             /* widget name */
           ExposureMask,        /* event_mask */
           FALSE,               /* nonmaskable */
           RestorePicture,      /* handler */
           NULL);               /* client_data */

  /**************************************************************/
   wform = XtVaCreateManagedWidget(       
           "wform",             /* widget name */
           formWidgetClass,     /* widget class from Form.h */
           paned,               /* parent widget */
           NULL);               /* terminate varargs list */

   wlabel = XtVaCreateManagedWidget(
           "wlabel",            /* widget name */
           labelWidgetClass,    /* widget class from Label.h */
           wform,               /* parent widget */
           NULL);               /* terminate varargs list */

   wview = XtVaCreateManagedWidget(
           "wview",             /* widget name */
           viewportWidgetClass, /* widget class from Viewport.h */
           wform,               /* parent widget */
           NULL);               /* terminate varargs list */ 

   wlist = XtVaCreateManagedWidget(
           "wlist",             /* widget name */
           listWidgetClass,     /* widget class from List.h */
           wview,               /* parent widget */
           NULL);               /* terminate varags list */

   /* wlist erhaelt neue Funktion ueber translation table */
   XtAppAddActions(app_context, neu_wlist, XtNumber(neu_wlist));

   /* wlist soll zu Beginn leer sein */
   str = (String *) XtRealloc((char *)str, sizeof(String) * 1);
   if (str == NULL)
   {
     fprintf(stderr, "Kein Speicher mehr frei!\n");
     fprintf(stderr, "XtRealloc-Aufruf in main\n");
     exit(1);
   }
   str[0] = XtNewString(" ");
   XawListChange(wlist, str, 1, 0, TRUE);

   wderivlabel = XtVaCreateManagedWidget(
           "wderivlabel",       /* widget name */
           labelWidgetClass,    /* widget class from Label.h */
           wform,               /* parent widget */
           NULL);               /* terminate varargs list */           

   wderiv = XtVaCreateManagedWidget(
           "wderiv",            /* widget name */
           labelWidgetClass,    /* widget class from Label.h */
           wform,               /* parent widget */
           NULL);               /* terminate varargs list */

  /**************************************************************/
 
   gform = XtVaCreateManagedWidget(       
           "gform",             /* widget name */
           formWidgetClass,     /* widget class from Form.h */
           paned,               /* parent widget */
           NULL);               /* terminate varargs list */

   gpform = XtVaCreateManagedWidget(
           "gpform",            /* widget name */
           formWidgetClass,     /* widgetClass from Form.h */
           gform,               /* parent widget */
           NULL);

   g_posx = XtVaCreateManagedWidget(
           "g_posx",            /* widget name */
           dialogWidgetClass,   /* widget class from Dialog.h */
           gpform,              /* parent widget */
           NULL);               /* terminate varargs list */  

   g_posy = XtVaCreateManagedWidget(
           "g_posy",            /* widget name */
           dialogWidgetClass,   /* widget class from Dialog.h */
           gpform,              /* parent widget */
           NULL);               /* terminate varargs list */  

   g_posz = XtVaCreateManagedWidget(
           "g_posz",            /* widget name */
           dialogWidgetClass,   /* widget class from Dialog.h */
           gpform,              /* parent widget */
           NULL);               /* terminate varargs list */  
   XtSetSensitive(g_posz, FALSE);

   g_angle = XtVaCreateManagedWidget(
           "g_angle",           /* widget name */
           dialogWidgetClass,   /* widget class from Dialog.h */
           gpform,              /* parent widget */
           NULL);               /* terminate varargs list */  

   g_length = XtVaCreateManagedWidget(
           "g_length",          /* widget name */
           dialogWidgetClass,   /* widget class from Dialog.h */
           gpform,              /* parent widget */
           NULL);               /* terminate varargs list */  

   g_scale = XtVaCreateManagedWidget(
           "g_scale",           /* widget name */
           dialogWidgetClass,   /* widget class from Dialog.h */
           gpform,              /* parent widget */
           NULL);               /* terminate varargs list */

   gtform = XtVaCreateManagedWidget(       
           "gtform",            /* widget name */
           formWidgetClass,     /* widget class from Form.h*/
           gform,               /* parent widget */
           NULL);               /* terminate varargs list */


   g_headx = XtVaCreateManagedWidget(
           "g_headx",           /* widget name */
           dialogWidgetClass,   /* widget class from Dialog.h */
           gtform,              /* parent widget */
           NULL);               /* terminate varargs list */  

   g_heady = XtVaCreateManagedWidget(
           "g_heady",           /* widget name */
           dialogWidgetClass,   /* widget class from Dialog.h */
           gtform,              /* parent widget */
           NULL);               /* terminate varargs list */

   g_headz = XtVaCreateManagedWidget(
           "g_headz",           /* widget name */
           dialogWidgetClass,   /* widget class from Dialog.h */
           gtform,              /* parent widget */
           NULL);               /* terminate varargs list */  
   XtSetSensitive(g_headz, FALSE);

   g_leftx = XtVaCreateManagedWidget(
           "g_leftx",           /* widget name */
           dialogWidgetClass,   /* widget class from Dialog.h */
           gtform,              /* parent widget */
           NULL);               /* terminate varargs list */  
   XtSetSensitive(g_leftx, FALSE);

   g_lefty = XtVaCreateManagedWidget(
           "g_lefty",           /* widget name */
           dialogWidgetClass,   /* widget class from Dialog.h */
           gtform,              /* parent widget */
           NULL);               /* terminate varargs list */  
   XtSetSensitive(g_lefty, FALSE);

   g_leftz = XtVaCreateManagedWidget(
           "g_leftz",           /* widget name */
           dialogWidgetClass,   /* widget class from Dialog.h */
           gtform,              /* parent widget */
           NULL);               /* terminate varargs list */  
   XtSetSensitive(g_leftz, FALSE);

   g_upx = XtVaCreateManagedWidget(
           "g_upx",             /* widget name */
           dialogWidgetClass,   /* widget class from Dialog.h */
           gtform,              /* parent widget */
           NULL);               /* terminate varargs list */  
   XtSetSensitive(g_upx, FALSE);

   g_upy = XtVaCreateManagedWidget(
           "g_upy",             /* widget name */
           dialogWidgetClass,   /* widget class from Dialog.h */
           gtform,              /* parent widget */
           NULL);               /* terminate varargs list */  
   XtSetSensitive(g_upy, FALSE);

   g_upz = XtVaCreateManagedWidget(
           "g_upz",             /* widget name */
           dialogWidgetClass,   /* widget class from Dialog.h */
           gtform,              /* parent widget */
           NULL);               /* terminate varargs list */  
   XtSetSensitive(g_upz, FALSE);

   gbform = XtVaCreateManagedWidget(       
           "gbform",            /* widget name */
           formWidgetClass,     /* widget class from Form.h*/
           gform,               /* parent widget */
           NULL);               /* terminate varargs list */

   g_3d = XtVaCreateManagedWidget(
           "g_3d",              /* widget name */
           commandWidgetClass,  /* widget class from Command.h */
           gbform,              /* parent widget */
           NULL);               /* terminate varargs list */
   XtAddCallback(g_3d, XtNcallback, G3D, NULL);

   g_proj = XtVaCreateManagedWidget(
           "g_proj",            /* widget name */
           commandWidgetClass,  /* widget class from Command.h */
           gbform,              /* parent widget */
           NULL);               /* terminate varargs list */
   XtAddCallback(g_proj, XtNcallback, Proj, NULL);
   XtSetSensitive(g_proj, FALSE);

   g_color = XtVaCreateManagedWidget(
           "g_color",           /* widget name */
           commandWidgetClass,  /* widget class from Command.h */
           gbform,              /* parent widget */
           NULL);               /* terminate varargs list */
   XtAddCallback(g_color, XtNcallback, Color, NULL);

   glabel = XtVaCreateManagedWidget(
           "glabel",            /* widget name */
           labelWidgetClass,    /* widget class from Label.h */
           gform,               /* parent widget */
           NULL);               /* terminate varargs list */

   gram = XtVaCreateManagedWidget(
           "gram",              /* widget name */
           asciiTextWidgetClass,  /* widget class from AsciiText.h */
           gform,               /* parent widget */
           NULL);               /* terminate varargs list */  

   g_ok = XtVaCreateManagedWidget(
           "g_ok",              /* widget name */
           commandWidgetClass,  /* widget class from Command.h */
           gform,               /* parent widget */
           NULL);               /* terminate varargs list */
   XtAddCallback(g_ok, XtNcallback, GOk, (XtPointer) gram);

   g_stop = XtVaCreateManagedWidget(
           "g_stop",            /* widget name */
           commandWidgetClass,  /* widget class from Command.h */
           gform,               /* paarent widget class */
           NULL);               /* terminate varargs list */
   XtAddCallback(g_stop, XtNcallback, GStop, NULL);
   XtSetSensitive(g_stop, FALSE);

   g_help = XtVaCreateManagedWidget(
           "g_help",            /* widget name */
           commandWidgetClass,  /* widget class from Command.h */
           gform,               /* parent widget */
           NULL);               /* terminate varargs list */
   XtAddCallback(g_help, XtNcallback, Help, NULL);

 /***************************************************************/
   buttonform = XtVaCreateManagedWidget(
           "buttonform",        /* arbitrary widget name */
           formWidgetClass,     /* widget class from Form.h */ 
           paned,               /* parent widget */
           NULL);               /* terminate varargs list */

   nextderiv = XtVaCreateManagedWidget(
           "nextderiv",         /* arbitrary widget name */
           commandWidgetClass,  /* widget class from Command.h */ 
           buttonform,          /* parent widget */
           NULL);               /* terminate varargs list */ 
   XtAddCallback(nextderiv, XtNcallback, NextDeriv, NULL);
   XtSetSensitive(nextderiv, FALSE);

   prevderiv = XtVaCreateManagedWidget(
           "prevderiv",         /* arbitrary widget name */
           commandWidgetClass,  /* widget class from Command.h */ 
           buttonform,          /* parent widget */
           NULL);               /* terminate varargs list */ 
   XtAddCallback(prevderiv, XtNcallback, PrevDeriv, NULL);
   XtSetSensitive(prevderiv, FALSE);

   singlesymbol = XtVaCreateManagedWidget(
           "singlesymbol",      /* arbitrary widget name */
           commandWidgetClass,  /* widget class from Command.h */ 
           buttonform,          /* parent widget */
           NULL);               /* terminate varargs list */ 
   XtAddCallback(singlesymbol, XtNcallback, SingleSymbol, NULL);
   XtSetSensitive(singlesymbol, FALSE);

   continuesymbol = XtVaCreateManagedWidget(
           "continuesymbol",    /* arbitrary widget name */
           commandWidgetClass,  /* widget class from Command.h */ 
           buttonform,          /* parent widget */
           NULL);               /* terminate varargs list */ 
   XtAddCallback(continuesymbol, XtNcallback, ContinueSymbol, NULL);
   XtSetSensitive(continuesymbol, FALSE);
 
   quit = XtVaCreateManagedWidget(
           "quit",              /* arbitrary widget name */
           commandWidgetClass,  /* widget class from Command.h */ 
           buttonform,          /* parent widget */
           NULL);               /* terminate varargs list */ 
   XtAddCallback(quit, XtNcallback, Quit, NULL);

   load = XtVaCreateManagedWidget(
           "load",              /* arbitrary widget name */
           commandWidgetClass,  /* widget class from Command.h */ 
           buttonform,          /* parent widget */
           NULL);               /* terminate varargs list */ 
   XtAddCallback(load, XtNcallback, Load, NULL);

   save = XtVaCreateManagedWidget(
           "save",              /* arbitrary widget name */
           commandWidgetClass,  /* widget class from Command.h */ 
           buttonform,          /* parent widget */
           NULL);               /* terminate varargs list */ 
   XtAddCallback(save, XtNcallback, Save, NULL);
   XtSetSensitive(save, FALSE);

  /*****************************************************************/
 
  /* Create windows for widgets and map them */
  XtRealizeWidget(topLevel);

  /* Map popup Widget */
  XtPopup(popup, XtGrabNone);

  /* Initialisieren der Pixmap und des GC zum Zeichnen in drawing */
  init_drawing(topLevel, drawing);


  /* Farbbildschirm, d.h. Farbpalette soll anwaehlbar sein */
  if (DefaultDepth(display,screen) == 1)
  {
    XtSetSensitive(g_color, FALSE);
  }

  init_color();


  /* Default-Werte fuer die perspektivische Projektion */
  persp_a  = 1000;
  persp_x0 = 0;
  persp_y0 = 0;

  /* Speicher fuer aktuelle Turtlewerte anlegen */
  turtle = (TURTLE_VALUES *)malloc(sizeof(TURTLE_VALUES));
  if (turtle == NULL)
  {
    fprintf(stderr, "Kein Speicher mehr frei!\n");
    fprintf(stderr, "malloc-Aufruf in main\n");
    exit(1);
  }

  /* Berechnen der Sinus-/Cosinus-Werte fuer eine Tabelle */
  for (i=0; i<361; i++)
  {
    winkel = i * PI /180;
    SI[i] = sin(winkel);
    CO[i] = cos(winkel);
  }

  SI[0]   = 0.0; SI[30]  = 0.5;  SI[90]  = 1.0;  SI[150] = 0.5; 
  SI[180] = 0.0; SI[210] = -0.5; SI[270] = -1.0; SI[330] = -0.5; 
  SI[360] = 0.0;

  CO[0]   = 1.0;  CO[60]  = 0.5;  CO[90]  = 0; CO[120] = -0.5;
  CO[180] = -1.0; CO[240] = -0.5; CO[270] = 0; CO[300] = 0.5;
  CO[360] = 1.0;


  /* Loop for events */
   XtAppMainLoop(app_context);
} 

/* end of main */


/*************************************************************************/
/* Function Name: RestorePicture
 * Description: Erneuert das Bild in drawing nach einem Expose-Event
 * Arguments: w           - drawing
 *            client_data - NULL
 *            event       - ExposeEvent
 * Globals: display
 *          draw_pixmap
 *          draw_gc
 *          draw_width
 *          draw_height
 * Returns: none
 */

void RestorePicture(w, client_data, event)
Widget w;
XtPointer client_data;
XEvent *event;
{
  XCopyArea(display, draw_pixmap, XtWindow(w), draw_gc,
            0,0, (int)draw_width, (int)draw_height, 0,0);
}

/*************************************************************************/
/* Function Name: Dummy
 * Description: "do nothing"
 * Arguments: unused
 */

/* ARGSUSED */
void Dummy(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  /* do nothing */
}

/*************************************************************************/
/* Function Name: syntax
 * Description: prints the unknown arguments for this function.
 * Arguments: app_context
 *            call - the name of the application
 */

/* ARGSUSED */
void syntax(app_context, call)
XtAppContext app_context;
char *call;
{
  XtDestroyApplicationContext(app_context);
  fprintf(stderr, " Argument(e) unbekannt: %s\n", call);
  exit(1);
}

/*************************************************************************/
/* Function Name: Help
 * Description: Oeffnet ein Fenster, das einen Helptext und einen OK-Button
 *              zum Beenden den Hilfe enthaelt.
 *              Button help wird "insensitive" gesetzt.
 * Arguments: w - Widget, das Callback ausgeloest hat
 */

/* ARGSUSED */
void Help(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Widget popup,
         helpform,
         helptext,
         helpok;

  popup = XtVaCreatePopupShell(
          "lgrammar_help",           /* widget name */
          topLevelShellWidgetClass,  /* widget class from Shell.h */
          w,                         /* parent widget */   
          NULL);                     /* terminate varargs list */

  helpform = XtVaCreateManagedWidget(
          "helpform",                /* widget name */
          formWidgetClass,           /* widget class from Form.h */
          popup,                     /* parent widget */
          NULL);                     /* terminate varargs list */

  helptext = XtVaCreateManagedWidget(
          "helptext",                /* widget name */
          asciiTextWidgetClass,      /* widget class from AsciiText.h */
          helpform,                  /* parent widget */
          NULL);                     /* terminate varargs list */

  helpok = XtVaCreateManagedWidget(
          "helpok",                  /* widget name */
          commandWidgetClass,        /* widget class from Command.h */
          helpform,                  /* parent widget */
          NULL);                     /* terminate varargs list */
  XtAddCallback(helpok, XtNcallback, HelpOk, NULL);

  XtSetSensitive(w, FALSE);

  XtPopup(popup, XtGrabNone);
}

/*************************************************************************/
/* Function Name: HelpOk
 * Description: schliest das Help-Fenster und setzt den Button fuer Help
 *              wieder auf "sensitive" 
 * Arguments: w - Widget, das den Callback ausgeloest hat
 */

/* ARGSUSED */
void HelpOk(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Widget popup = XtParent(XtParent(w));
  Widget button  = XtParent(popup);

  XtSetSensitive(button, TRUE);
  XtDestroyWidget(popup);
}

/*************************************************************************/
/* Function Name: G3D
 * Description: 
 * Arguments: w - Widget, das den Callback ausgeloest hat
 * Globals: a lot
 */

/* ARGSUSED */
void G3D(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  String s_label;

  /* bestehende Beschriftung lesen */
  XtVaGetValues(w, XtNlabel, &s_label, NULL);
  if (strcmp(s_label, "2D") == 0)
  {
    /* neue Beschriftung = 3D */
    XtVaSetValues(w, XtNlabel, "3D", NULL);

    XtSetSensitive(g_posz, TRUE);
    XtSetSensitive(g_headz, TRUE);
    XtSetSensitive(g_leftx, TRUE);
    XtSetSensitive(g_lefty, TRUE);
    XtSetSensitive(g_leftz, TRUE);
    XtSetSensitive(g_upx, TRUE);
    XtSetSensitive(g_upy, TRUE);
    XtSetSensitive(g_upz, TRUE);
    XtSetSensitive(g_proj, TRUE);
  }
  else
  {
    /* neue Beschriftung = 2D */
    XtVaSetValues(w, XtNlabel, "2D", NULL);

    XtSetSensitive(g_posz, FALSE);
    XtSetSensitive(g_headz, FALSE);
    XtSetSensitive(g_leftx, FALSE);
    XtSetSensitive(g_lefty, FALSE);
    XtSetSensitive(g_leftz, FALSE);
    XtSetSensitive(g_upx, FALSE);
    XtSetSensitive(g_upy, FALSE);
    XtSetSensitive(g_upz, FALSE);
    XtSetSensitive(g_proj, FALSE);
  }
}

/*************************************************************************/
/* Function Name: Proj
 * Description: 
 * Arguments: w - Widget, das den callback ausgeloest hat
 * Globals: a lot
 */

/* ARGSUSED */
void Proj(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Widget popup,
         projform,
         projok,
         projcancel;

  char *str;
  Arg args[2];

  popup = XtVaCreatePopupShell( 
          "lgrammar_proj",           /* widget name */
          topLevelShellWidgetClass,  /* widget class from Shell.h */
          w,                         /* parent widget */   
          NULL);                     /* terminate varargs list */

  projform = XtVaCreateManagedWidget(
          "projform",                /* widget name */
          formWidgetClass,           /* widget class from Form.h */
          popup,                     /* parent widget */
          NULL);                     /* terminate varargs list */

  proj_x0 = XtVaCreateManagedWidget(
          "proj_x0",                 /* widget name */
          dialogWidgetClass,         /* widget class from Dialog.h */
          projform,                  /* parent widget */
          NULL);                     /* terminate varargs list */  

  proj_y0 = XtVaCreateManagedWidget(
          "proj_y0",                 /* widget name */
          dialogWidgetClass,         /* widget class from Dialog.h */
          projform,                  /* parent widget */
          NULL);                     /* terminate varargs list */  

  proj_a = XtVaCreateManagedWidget(
          "proj_a",                  /* widget name */
          dialogWidgetClass,         /* widget class from Dialog.h */
          projform,                  /* parent widget */
          NULL);                     /* terminate varargs list */  

  projok = XtVaCreateManagedWidget(
          "projok",                  /* widget name */
          commandWidgetClass,        /* widget class from Command.h */
          projform,                  /* parent widget */
          NULL);                     /* terminate varargs list */
  XtAddCallback(projok, XtNcallback, ProjOk, NULL);

  projcancel = XtVaCreateManagedWidget(
          "projcancel",              /* widget name */
          commandWidgetClass,        /* widget class from Command.h */
          projform,                  /* parent widget */
          NULL);                     /* terminate varargs list */
  XtAddCallback(projcancel, XtNcallback, ProjCancel, NULL);

  XtSetSensitive(w, FALSE);

  XtPopup(popup, XtGrabNonexclusive);

  /* in Popup aktuelle Werte von persp_a, persp_x0 und persp_y0 anzeigen */ 
  str = (char *)malloc(5*sizeof(char));
  if (str == NULL)
  {
    fprintf(stderr, "Kein Speicher mehr frei!\n");
    fprintf(stderr, "malloc-Aufruf in Proj\n");
    exit(1);
  }

  sprintf(str, "%d", persp_x0);
  XtSetArg(args[0], XtNvalue, str);
  XtSetValues(proj_x0, args, ONE);

  sprintf(str, "%d", persp_y0);
  XtSetArg(args[0], XtNvalue, str);
  XtSetValues(proj_y0, args, ONE);

  sprintf(str, "%d", persp_a);
  XtSetArg(args[0], XtNvalue, str);
  XtSetValues(proj_a, args, ONE);

  free(str);
}

/*************************************************************************/
/* Function Name: ProjOk
 * Description: 
 * Arguments: w - Widget, das den Callback ausgeloest hat
 * Globals: 
 */

/* ARGSUSED */
void ProjOk(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Widget popup = XtParent(XtParent(w));
  Widget button = XtParent(popup);
 
  String s_value;

  /* Einlesen der eingegeben Werte in Proj */

  XtVaGetValues(proj_x0, XtNvalue, &s_value, NULL);
  persp_x0 = (int)(atof(s_value));

  XtVaGetValues(proj_y0, XtNvalue, &s_value, NULL);
  persp_y0 = (int)(atof(s_value));

  XtVaGetValues(proj_a, XtNvalue, &s_value, NULL);
  persp_a = (double)(atof(s_value));

  XtSetSensitive(button, TRUE);
  XtDestroyWidget(popup);
}

/*************************************************************************/
/* Function Name: ProjCancel
 * Description: 
 * Arguments: w - Widget, das den Callback ausgeloest hat
 */

/* ARGSUSED */
void ProjCancel(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Widget popup = XtParent(XtParent(w));
  Widget button = XtParent(popup);
 
  XtSetSensitive(button, TRUE);
  XtDestroyWidget(popup);
}

/*************************************************************************/
/* Function Name: GOk
 * Description: 
 * Arguments: 
 * Globals: 
 * Returns: 
 */

/* ARGSUSED */
void GOk(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Widget eingabe = (Widget) client_data;
  String str_eingabe;           /* liest Grammatik ein */

  int fehler = 0;               /* Klammersetzung korrekt ? */

  Widget gfehler,               /* Popup-Fenster fuer falsche Klammern */
         gfehlerlabel;          /* Fehlermeldung */
  Position x, y;                /* Postion des Popups */
  Dimension width, height;      /* Groesse des Popups */
  Widget topLevel = XtParent(XtParent(XtParent(w)));

  String s_value;

  Arg arg[1];
  char newlabel[BUFSIZ];

  char text[3];  /* Label fuer g_3d, wechselt zwischen 2D und 3D */


  XtSetSensitive(g_stop, FALSE);

  XtVaGetValues(eingabe, XtNstring,&str_eingabe,NULL);
  if (strlen(str_eingabe) < 1)
  {
    /* zu wenig Zeichen fuer eine Grammatik */
  }
  else
  {
    /* Index bzw. Zusatz auf korrekte '<','>' pruefen, Klammern pruefen */
    fehler = klammern_pruefen (str_eingabe);

    if (fehler == 0)
    {
      if (grammar)
      {
        /* bestehende grammar loeschen */
        grammar = delete_grammarlist(grammar);
      }
      /* grammar aufbauen */
      grammar = init_grammar(str_eingabe);

      if (grammar != NULL)
      {
        /* Klammerung in Grammatik testen */
        fehler = klammerung(grammar);
      }
      else
      {
        /* Grammatik fehlerhaft */
        fehler = 10;
      }

      if (fehler == 0)
      {
        /* Wahrscheinlichkeiten ueberpruefen */
        fehler = test_wk(grammar);
      }
    }

    switch (fehler)
    {
    case 0:

       sprintf(newlabel, "Grammar:");
       XtSetArg(arg[0], XtNlabel, newlabel);
       XtSetValues(glabel, arg, ONE);

       /* Axiom ausgeben */
       if (word)
       {
         /* bestehendes word wird geloescht */
         word = delete_wordlist(word);
       }
       /* word mit Axiom initialisieren */
       init_word();
       display_word();

       /* Zahl der Ableitungen ausgeben */
       count_deriv = 0;
       display_deriv();

       color_index = 0;

       /* Einlesen der eingegeben Werte in die Struktur turtle */
       XtVaGetValues(g_posx, XtNvalue, &s_value, NULL);
       turtle->pos.x = (double)(atof(s_value));

       XtVaGetValues(g_posy, XtNvalue, &s_value, NULL);
       turtle->pos.y = (double)(atof(s_value));

       XtVaGetValues(g_posz, XtNvalue, &s_value, NULL);
       turtle->pos.z = (double)(atof(s_value));

       XtVaGetValues(g_headx, XtNvalue, &s_value, NULL);
       turtle->h.x = (double)(atof(s_value));

       XtVaGetValues(g_heady, XtNvalue, &s_value, NULL);
       turtle->h.y = (double)(atof(s_value));

       XtVaGetValues(g_headz, XtNvalue, &s_value, NULL);
       turtle->h.z = (double)(atof(s_value));

       XtVaGetValues(g_leftx, XtNvalue, &s_value, NULL);
       turtle->l.x = (double)(atof(s_value));
 
       XtVaGetValues(g_lefty, XtNvalue, &s_value, NULL);
       turtle->l.y = (double)(atof(s_value));

       XtVaGetValues(g_leftz, XtNvalue, &s_value, NULL);
       turtle->l.z = (double)(atof(s_value));

       XtVaGetValues(g_upx, XtNvalue, &s_value, NULL);
       turtle->u.x = (double)(atof(s_value));

       XtVaGetValues(g_upy, XtNvalue, &s_value, NULL);
       turtle->u.y = (double)(atof(s_value));
  
       XtVaGetValues(g_upz, XtNvalue, &s_value, NULL);
       turtle->u.z = (double)(atof(s_value));
 
       XtVaGetValues(g_angle, XtNvalue, &s_value, NULL);
       turtle->angle = (double)(atof(s_value));

       XtVaGetValues(g_length, XtNvalue, &s_value, NULL);
       turtle->length = atoi(s_value);

       XtVaGetValues(g_scale, XtNvalue, &s_value, NULL);
       turtle->scale = (double)(atof(s_value));


       /* Test, ob 2D- oder 3D-Symbole in der Grammatik enthalten sind */
       dimens = test_dimens(str_eingabe);
       if (dimens == 3)
       {
         turtle_3D(drawing, count_deriv, turtle);

         sprintf(text, "3D");
         XtSetArg(arg[0], XtNlabel, text);
         XtSetValues(g_3d, arg, ONE);

         XtSetSensitive(g_posz, TRUE);
         XtSetSensitive(g_headz, TRUE);
         XtSetSensitive(g_leftx, TRUE);
         XtSetSensitive(g_lefty, TRUE);
         XtSetSensitive(g_leftz, TRUE);
         XtSetSensitive(g_upx, TRUE);  
         XtSetSensitive(g_upy, TRUE);  
         XtSetSensitive(g_upz, TRUE);
         XtSetSensitive(g_proj, TRUE);
       }
       else
       {
         turtle_2D(drawing, count_deriv, turtle);

         sprintf(text, "2D");
         XtSetArg(arg[0], XtNlabel, text);
         XtSetValues(g_3d, arg, ONE);

         XtSetSensitive(g_posz, FALSE);
         XtSetSensitive(g_headz, FALSE);
         XtSetSensitive(g_leftx, FALSE);
         XtSetSensitive(g_lefty, FALSE);
         XtSetSensitive(g_leftz, FALSE);
         XtSetSensitive(g_upx, FALSE);
         XtSetSensitive(g_upy, FALSE);
         XtSetSensitive(g_upz, FALSE);
         XtSetSensitive(g_proj, FALSE);
       }

       XtSetSensitive(nextderiv, TRUE);
       XtSetSensitive(prevderiv, FALSE);
       XtSetSensitive(singlesymbol, TRUE);
       XtSetSensitive(continuesymbol, FALSE);
       XtSetSensitive(save, TRUE);

       break;


    case 1: /* Klammersetzung nicht in Ordnung, Meldung ausgeben */

       /* get the coordinates of the button widget */
       XtVaGetValues(w,
              XtNwidth, &width,
              XtNheight, &height,
              NULL);

       /* translate coords in application button window 
        * into coords from root window */
       XtTranslateCoords(w,           /* Widget */
              (Position) (width-5),   /* x */
              (Position) (height-50), /* y */
              &x, &y);                /* coords on root window */

       gfehler = XtVaCreatePopupShell(
                 "gfehler",                 /* widget name */
                 overrideShellWidgetClass,  /* widget class from Shell.h */
                 w,                         /* parent widget */
                 NULL);                     /* terminate varargs list */

       /* move popup shell to this position */
       XtVaSetValues(gfehler,
              XtNx, x,
              XtNy, y,
              NULL);

       gfehlerlabel = XtVaCreateManagedWidget(
                   "Klammersetzung!",    /* widget name */
                   commandWidgetClass,   /* widget class from Command.h */
                   gfehler,              /* parent widget */
                   NULL);                /* terminate varargs list */
       XtAddCallback(gfehlerlabel, XtNcallback, Fehler, NULL);
 
       XtSetSensitive(XtParent(gfehler),FALSE);
       XtPopup(gfehler, XtGrabNonexclusive);
       XBell(XtDisplay(topLevel), 0);
       break;

    case 10: /* Grammatik nicht in Ordnung */
       sprintf(newlabel, "GRAMMAR: Check '='");
       XtSetArg(arg[0], XtNlabel, newlabel);
       XtSetValues(glabel, arg, ONE);
       XBell(XtDisplay(topLevel), 0);
       break;

    case 20: /* Wahrscheinlichkeitsangaben nicht in Ordnung */
       sprintf(newlabel, "GRAMMAR: Check probabilities");
       XtSetArg(arg[0], XtNlabel, newlabel);
       XtSetValues(glabel, arg, ONE);
       XBell(XtDisplay(topLevel), 0);
       break;

      break;

    } /* end of switch */
  } /* end of else */
} /* end of G_ok */

/*************************************************************************/
/* Function Name: display_deriv
 * Description: 
 * Arguments: 
 * Globals: 
 * Returns: 
 */

void display_deriv()
{
  char text[5];

  sprintf(text, "%d", count_deriv);
  XtVaSetValues(wderiv, XtNlabel, text, NULL);
}

/*************************************************************************/
/* Function Name: display_word
 * Description: 
 * Arguments: 
 * Globals: 
 * Returns: 
 */

void display_word()
{
  str[0] = XtNewString((String *)word_to_string(word, current_symbol));
  XawListChange(wlist, str, 1, 0, TRUE);
}

/*************************************************************************/
/* Function Name: Fehler
 * Description: 
 * Arguments: 
 * Globals: 
 * Returns: 
 */

/* ARGSUSED */
void Fehler(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Widget popup = XtParent(w);
  Widget button = XtParent(popup);

  XtSetSensitive(button, TRUE);

  XtDestroyWidget(popup);
}

/*************************************************************************/
/* Function Name: GStop
 * Description: 
 * Arguments: 
 * Globals: 
 * Returns: 
 */

/* ARGSUSED */
void GStop(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  anhalten = TRUE;
}

/*************************************************************************/
/* Function Name: NextDeriv
 * Description: 
 * Arguments: 
 * Globals: 
 * Returns: 
 */

/* ARGSUSED */
void NextDeriv(w, client_data, call_data)
Widget w;
XtPointer client_data,
          call_data; 
{
  count_deriv ++;
  display_deriv();

  ableitung_wort();
  display_word();


  XtSetSensitive(prevderiv, TRUE);

  if (dimens == 3)
  {
    turtle_3D(drawing, count_deriv, turtle);
  }
  else
  {
    turtle_2D(drawing, count_deriv, turtle);
  }
}

/*************************************************************************/
/* Function Name: PrevDeriv
 * Description: 
 * Arguments: 
 * Globals: 
 * Returns: 
 */

/* ARGSUSED */
void PrevDeriv(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  int i;

  count_deriv--;
  display_deriv();

  word = delete_wordlist(word);
  init_word();

  for (i=0; i<count_deriv; i++)
  {
    ableitung_wort();
  }
  display_word();

  if (count_deriv < 1)
  {
    XtSetSensitive(prevderiv, FALSE);
  }

  if (dimens == 3)
  {
    turtle_3D(drawing, count_deriv, turtle);
  }
  else
  {
    turtle_2D(drawing, count_deriv, turtle);
  }
}

/*************************************************************************/
/* Function Name: SingleSymbol
 * Description: 
 * Arguments: 
 * Globals: 
 * Returns: 
 */

/* ARGSUSED */
void SingleSymbol(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  if (word == current_symbol)
  {
    count_deriv ++;
    display_deriv();
  }

  ableitung_symbol();
  display_word();

  if(word != current_symbol)
  {
    XtSetSensitive(nextderiv, FALSE);
    XtSetSensitive(prevderiv, FALSE);
    XtSetSensitive(continuesymbol, TRUE);
  }
  else
  {
    XtSetSensitive(nextderiv, TRUE);
    XtSetSensitive(prevderiv, TRUE);
    XtSetSensitive(continuesymbol, FALSE);
  }

  if (dimens == 3)
  {
    turtle_3D(drawing, count_deriv, turtle);
  }
  else
  {
    turtle_2D(drawing, count_deriv, turtle);
  }
}

/*************************************************************************/
/* Function Name: ContinueSymbol
 * Description: 
 * Arguments: 
 * Globals: 
 * Returns: 
 */

/* ARGSUSED */
void ContinueSymbol(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  while (word != current_symbol)
  {
    ableitung_symbol();
  }
  display_word();

  XtSetSensitive(nextderiv, TRUE);
  XtSetSensitive(prevderiv, TRUE);
  XtSetSensitive(continuesymbol,FALSE);

  if (dimens == 3)
  {
    turtle_3D(drawing, count_deriv, turtle);
  }
  else
  {
    turtle_2D(drawing, count_deriv, turtle);
  }
}

/*************************************************************************/
/* Function Name: Save
 * Description: 
 * Arguments: 
 * Globals: 
 * Returns: 
 */

/* ARGSUSED */
void Save(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Widget popup,
         saveform,
         saveok,
         savecancel,
         saveimage,
         saveobj;


  char dirname[MAXPATHLEN];  /* Name des aktuellen Verzeichnisses */

  popup = XtVaCreatePopupShell(
          "lgrammar_save",           /* widget name */
          topLevelShellWidgetClass,  /* widget class from Shell.h */
          w,                         /* parent widget */   
          NULL);                     /* terminate varargs list */

  saveform = XtVaCreateManagedWidget(
          "saveform",           /* widget name */
          formWidgetClass,      /* widget class from Form.h */
          popup,                /* parent widget */
          NULL);                /* terminate varargs list */

  savesett = XtVaCreateManagedWidget(
          "savesett",           /* widget name */
          dialogWidgetClass,    /* widget class from Dialog.h */
          saveform,             /* parent widget */
          NULL);                /* terminate varargs list */

  saveok = XtVaCreateManagedWidget(
          "saveok",             /* widget name */
          commandWidgetClass,   /* widget class from Command.h */
          saveform,             /* parent widget */
          NULL);                /* terminate varargs list */
  XtAddCallback(saveok, XtNcallback, SaveOk, NULL);

  savecancel = XtVaCreateManagedWidget(
          "savecancel",         /* widget name */
          commandWidgetClass,   /* widget class from Command.h */
          saveform,             /* parent widget */
          NULL);                /* terminate varargs list */
  XtAddCallback(savecancel, XtNcallback, SaveCancel, NULL);

  saveimage = XtVaCreateManagedWidget(
          "saveimage",          /* widget name */
          commandWidgetClass,   /* widget class from Command.h */
          saveform,             /* parent widget */
          NULL);                /* terminate varargs list */
  XtAddCallback(saveimage, XtNcallback, SaveImage, NULL);
 
  saveobj = XtVaCreateManagedWidget(
          "saveobj",            /* widget name */
          commandWidgetClass,   /* widget class from Command.h */
          saveform,             /* parent widget */
          NULL);                /* terminate varargs list */
  XtAddCallback(saveobj, XtNcallback, SaveObj, NULL);

  getwd(dirname);
  if (dirname == NULL)
  {
    printf("getwd\n");
    exit(1);
  }
  XtVaSetValues(savesett, XtNvalue, dirname, NULL);


  XtSetSensitive(w, FALSE);

  XtPopup(popup, XtGrabNonexclusive);
}

/*************************************************************************/
/* Function Name: SaveSReturnOk
 * Description: 
 * Arguments: w - Widget, das den callback ausgeloest hat
 * Globals: 
 * Returns: 
 */

/*ARGSUSED*/
void SaveSReturnOk(w, event, params, num_params)
Widget w;		
XEvent *event;		
String *params;	
Cardinal *num_params;
{
  Widget dialog = XtParent(w);

  SaveOk(dialog, (XtPointer) dialog, (XtPointer) NULL);
}

/*************************************************************************/
/* Function Name: SaveOk
 * Description: 
 * Arguments: 
 * Globals: 
 * Returns: 
 */

/* ARGSUSED */
void SaveOk(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Widget popup = XtParent(XtParent(w));
  Widget button = XtParent(popup);

  String settfname   = XawDialogGetValueString(savesett);

  String leer = "";
  int savenumber = 0;

  /* eingelesenen Filenamen vergleichen */
  if (strcmp(settfname,   leer) != 0) savenumber +=  1;

  switch (savenumber)
  {
  case 0: /* keine Filenamen angegeben */

     XtSetSensitive(button, TRUE);
     XtDestroyWidget(popup);
     break;


  case 1: /* Save Settings */

     save_settings_to_file(settfname);
     XtSetSensitive(button, TRUE);
     XtDestroyWidget(popup);
     break;

  } /*switch*/
}

/*************************************************************************/
/* Function Name: SaveCancel
 * Description: 
 * Arguments: 
 * Globals: 
 * Returns: 
 */

/* ARGSUSED */
void SaveCancel(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Widget popup = XtParent(XtParent(w));
  Widget button = XtParent(popup);
 
  XtSetSensitive(button, TRUE);
  XtDestroyWidget(popup);
}

/*************************************************************************/
/* Function Name: SaveImage
 * Description: 
 * Arguments: 
 * Globals: 
 * Returns: 
 */

/* ARGSUSED */
void SaveImage(w, call_data, client_data)
Widget w;

XtPointer call_data, client_data;
{
  Widget popup = XtParent(XtParent(w));
  Widget button = XtParent(popup);

  String *cmd;

  cmd = (String *)malloc(100*sizeof(char));
  if (cmd == NULL)
  {
    fprintf(stdout,"Kein Speicher mehr frei\n");
    fprintf(stdout,"malloc-Aufruf in SaveImage\n");
  }
  sprintf(cmd, "xgrab");
  system(cmd);
  free(cmd);

  XtSetSensitive(button, TRUE);
  XtDestroyWidget(popup);
}

/*************************************************************************/
/* Function Name: Quit
 * Description: exits the application
 * Arguments: unused
 * Returns: none
 */

/* ARGSUSED */
void Quit(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  XtDestroyApplicationContext(XtWidgetToApplicationContext(w));
  exit(0);
}

/*************************************************************************/
/* Function Name: save_settings_to_file
 * Description: 
 * Arguments: 
 * Globals: 
 * Returns: 
 */

void save_settings_to_file(filename)
String filename;
{
  FILE *fp;
  String wert;
  char *str;

  int i;

  if ((fp = fopen(filename, "w")) == NULL)
  {
    fprintf(stderr, "Datei konnte nicht geoeffnet werden\n");
    fprintf(stderr, "fopen in save_settings_to_file\n");
    exit(1);
  }

  /* Einlesen der Farb-Palette */
  /* col_pal_name */
  fprintf(fp, "%s\n", col_pal_name);


  str = (char *)malloc(8 * sizeof(char));
  if (str == NULL)
  {
    fprintf(stderr, "Kein Speicher mehr frei!\n");
    fprintf(stderr, "malloc-Aufruf in save_settings_to_file\n");
    exit(1);
  }

  /* Einlesen der Farbreihenfolge in File fp */
  for (i=0; i<NOC; i++)
  {
    sprintf(str, "%d", owncolor[i].red);
    fprintf(fp, "%s ", str);
    sprintf(str, "%d", owncolor[i].green);
    fprintf(fp, "%s ", str);
    sprintf(str, "%d", owncolor[i].blue);
    fprintf(fp, "%s\n", str);
  }

  /* Einlesen der Turtledaten in File fp */

  /* g_posx */
  XtVaGetValues(g_posx, XtNvalue, &wert, NULL);
  fprintf(fp, "%s\n", wert);

  /* g_posy */
  XtVaGetValues(g_posy, XtNvalue, &wert, NULL);
  fprintf(fp, "%s\n", wert);

  /* g_posz */
  XtVaGetValues(g_posz, XtNvalue, &wert, NULL);
  fprintf(fp, "%s\n", wert);

  /* g_angle */
  XtVaGetValues(g_angle, XtNvalue, &wert, NULL);
  fprintf(fp, "%s\n", wert);

  /* g_length */
  XtVaGetValues(g_length, XtNvalue, &wert, NULL);
  fprintf(fp, "%s\n", wert);

  /* g_scale */
  XtVaGetValues(g_scale, XtNvalue, &wert, NULL);
  fprintf(fp, "%s\n", wert);


  /* g_headx */
  XtVaGetValues(g_headx, XtNvalue, &wert, NULL);
  fprintf(fp, "%s\n", wert);
      
  /* g_heady */
  XtVaGetValues(g_heady, XtNvalue, &wert, NULL);
  fprintf(fp, "%s\n", wert);

  /* g_headz */
  XtVaGetValues(g_headz, XtNvalue, &wert, NULL);
  fprintf(fp, "%s\n", wert);

  /* g_leftx */
  XtVaGetValues(g_leftx, XtNvalue, &wert, NULL);
  fprintf(fp, "%s\n", wert);
      
  /* g_lefty */
  XtVaGetValues(g_lefty, XtNvalue, &wert, NULL);
  fprintf(fp, "%s\n", wert);

  /* g_leftz */
  XtVaGetValues(g_leftz, XtNvalue, &wert, NULL);
  fprintf(fp, "%s\n", wert);

  /* g_upx */
  XtVaGetValues(g_upx, XtNvalue, &wert, NULL);
  fprintf(fp, "%s\n", wert);
      
  /* g_upy */
  XtVaGetValues(g_upy, XtNvalue, &wert, NULL);
  fprintf(fp, "%s\n", wert);

  /* g_upz */
  XtVaGetValues(g_upz, XtNvalue, &wert, NULL);
  fprintf(fp, "%s\n", wert);


  /* persp_x0 */
  sprintf(str, "%d", persp_x0);
  fprintf(fp, "%s\n", str);

  /* persp_y0 */
  sprintf(str, "%d", persp_y0);
  fprintf(fp, "%s\n", str);

  /* persp_a */
  sprintf(str, "%d", persp_a);
  fprintf(fp, "%s\n", str);

  free(str);


  /* gram */
  XtVaGetValues(gram, XtNstring, &wert, NULL);
  fprintf(fp, "%s\n", wert);

  if (fclose(fp))
  {
    fprintf(stderr, "Datei konnte nicht geschlossen werden\n");
    fprintf(stderr, "fclose in save_settings_to_file\n");
    exit(1);
  }
}

/*************************************************************************/
/*************************************************************************/
/*************************************************************************/
/* Function Name: 
 * Description: 
 * Arguments: 
 * Globals: 
 * Returns: 
 */

/*************************************************************************/


