MODULE monitor_buffer;

EXPORT MONITOR Buffer;
       ENTRY writebuf (a: INTEGER);
       ENTRY readbuf  (VAR a: INTEGER);

IMPLEMENTATION

MONITOR Buffer;
CONST max = 5;

VAR Stack:          ARRAY[1..max] OF INTEGER;
    SPointer:       INTEGER;
    Free, Occupied: CONDITION;

ENTRY writebuf(a: INTEGER);
BEGIN
  WHILE SPointer=max (* Buffer full *) DO WAIT(Free) END;
  inc(SPointer);
  Stack[SPointer] := a;
  IF SPointer=1 THEN SIGNAL(Occupied) END;
  (* *) WriteString("write "); WriteInt(SPointer,3);
  (* *) WriteInt(a,6); WriteLn;
END writebuf;

ENTRY readbuf(VAR a: INTEGER);
BEGIN
  WHILE SPointer=0  (*Buffer empty*)  DO WAIT(Occupied) END;
  a := Stack[SPointer];
  (* *) WriteString("read        "); WriteInt(SPointer,3);
  (* *) WriteInt(a,6); WriteLn;
  dec(SPointer);
  IF SPointer = max-1 THEN SIGNAL(Free) END;
END readbuf;

BEGIN (* Monitor Initialization *)
  WriteString("Init Monitor"); WriteLn;
  SPointer:=0;
END MONITOR Buffer;

BEGIN
  WriteString("Init High-level Module"); WriteLn;
END MODULE monitor_buffer.
