PROCESSOR MODULE fractal;
IMPLEMENTATION
CONST num_workers =   5;    (* number workers    *)
      num_iter    = 200;    (* number iterations *)

TYPE  patch       = ARRAY[1..10][1..10] OF INTEGER;
(*TYPE  patch       = ARRAY[1..10],[1..10] OF INTEGER;*)
      complex     = RECORD re,im: REAL
                    END;

PROCEDURE C_Add (a,b: complex): complex;
VAR res: complex;
BEGIN
  res.re := a.re + b.re;
  res.im := a.im + b.im;
  RETURN(res);
END C_Add;

PROCEDURE C_Mul (a,b: complex): complex;
VAR res: complex;
BEGIN
  res.re := a.re*b.re - a.im*b.im;
  res.im := a.re*b.im + a.im*b.re;
  RETURN(res);
END C_Mul;

PROCEDURE C_big (a: complex) : BOOLEAN;
BEGIN
  RETURN (a.re*a.re + a.im*a.im > 5.0);
END C_big;


MONITOR image;
VAR pic        : ARRAY[1..100][1..100] OF INTEGER;
(*VAR pic        : ARRAY[1..100],[1..100] OF INTEGER;*)
    i,num_ret  : INTEGER;

PROCEDURE print;
(* print whole picture as character graphics *)
VAR i,j: INTEGER;
BEGIN
  FOR j:=1 TO 100 DO
    FOR i:=1 TO 100 DO
      IF pic[i,j]=num_iter THEN Write('X') ELSE Write(' ') END;
    END;
    WriteLn;
  END
END print;

ENTRY put_res (k,l: INTEGER; res: patch);
VAR i,j: INTEGER;
BEGIN (* enter partial result *)
  FOR i:= 1 TO 10 DO
    FOR j:=1 TO 10 DO
      pic[10*(k-1) +i, 10*(l-1) +j] := res[i,j]
    END
  END;
  INC(num_ret);
  WriteString("patch received"); 
  WriteInt(k,4); WriteInt(l,4); WriteLn;
  IF num_ret = 100 THEN print END;
END put_res;

BEGIN (* monitor-init *)
  num_ret := 0; (* number of returned patches *)
END MONITOR image;

PROCEDURE calc(k,l,i,j: INTEGER): INTEGER;
(* calculate value for a single pixel position *)
CONST north    =   1.3;  south = -1.3;
      west     =  -2.0;  east  =  0.6; 
(* try also: west  = -0.76;  east = -0.74; *)
(*           north =  0.03; south =  0.01; *)
VAR   c,z : complex;
      iter: INTEGER;

BEGIN
(*  WITH c DO
      re := west  + FLOAT(10*k+i) * ((east -west )/99.0); (* real *)
      im := south + FLOAT(10*l+j) * ((north-south)/99.0); (* imaginery *)
  END; *)
  c.re := west  + FLOAT(10*(k-1)+i) * ((east -west )/99.0); (* real *)
  c.im := south + FLOAT(10*(l-1)+j) * ((north-south)/99.0); (* imaginery *)
  z:=c;
  iter:=0;
  REPEAT
    INC(iter);
    z   := C_Add( C_Mul(z,z), c );
  UNTIL (iter=num_iter) OR C_big(z);
  RETURN(iter)
END calc;

PROCEDURE calc_area(k,l: INTEGER; VAR res: patch);
(* using only boolean results: black/white         *)
(* subroutine calc returns true if point converges *)
VAR surround: BOOLEAN;
    i,j     : INTEGER;
BEGIN
  (* first do border *)
  surround := TRUE;
  FOR i:=1 TO 10 DO 
    res[ 1,i] := calc(k,l, 1,i);
    res[10,i] := calc(k,l,10,i);
    IF (res[1,i]<num_iter) OR (res[10,i]<num_iter) THEN surround := FALSE END;
  END;
  FOR i:=2 TO 9 DO 
    res[i, 1] := calc(k,l,i, 1);
    res[i,10] := calc(k,l,i,10);
    IF (res[i,1]<num_iter) OR (res[i,10]<num_iter) THEN surround := FALSE END;
  END;

  (* then do inner section *)
  FOR i:=2 TO 9 DO
    FOR j:=2 TO 9 DO
      IF surround THEN res[i,j] := num_iter
                  ELSE res[i,j] := calc(k,l,i,j)
      END
    END
  END;
END calc_area;

PROCESS worker;
VAR i,j: INTEGER;
    res: patch;
BEGIN
  (* here a square is not requested from         *)
  (* the monitor, but a fixed scheduling is used *)
  FOR i:=PROCESSNO TO 10 BY num_workers DO
    FOR j:=1 TO 10 DO
      calc_area(i,j,res);
      image:put_res(i,j,res);
    END
  END
END PROCESS worker;


BEGIN
 START(worker, num_workers)
END PROCESSOR MODULE fractal.

