PROCESSOR MODULE pi_calc;
IMPLEMENTATION
CONST  intervals = 100;       (* number of intervals        *)
       width     = 1.0 / Float (intervals);  (* Int.-width  *)
       num_work  =   5;       (* number of worker processes *)

PROCEDURE f (x: REAL): REAL;
(* function to be integrated *)
BEGIN
  RETURN(4.0 / (1.0 + x*x))
END f;

MONITOR assignment;
VAR sum        : REAL;
    pos,answers: INTEGER;

ENTRY get_interval(VAR int: INTEGER);
BEGIN
  pos := pos+1;
  IF pos<=intervals THEN int := pos
                    ELSE int := -1    (* done *)
  END;
END get_interval;

ENTRY put_result(res: REAL);
BEGIN
  sum     := sum+res;
  answers := answers+1;
  IF answers = intervals THEN      (* print result *)
    WriteString("Pi = "); WriteReal(sum,10); WriteLn;
  END;
END put_result;

BEGIN (* monitor-init *)
  pos := 0;  answers := 0;
  sum := 0.0;
END MONITOR assignment;

PROCESS worker(id: INTEGER);
VAR iv : INTEGER;
    res: REAL;
BEGIN
  assignment:get_interval(iv); (* get 1. assignm. from mon. *)
  WHILE iv > 0 DO
    res := width * f( (FLOAT(iv)-0.5) * width );
    assignment:put_result(res);  (* put result to monitor *)
    assignment:get_interval(iv); (* get assignm. from mon.*)
  END
END PROCESS worker;

PROCEDURE start_procs;
VAR i: INTEGER;
BEGIN
  FOR i:= 1 TO num_work DO START(worker(i)) END
END start_procs;

BEGIN
  start_procs;
END PROCESSOR MODULE pi_calc.
