/*
 *	mclocal.h
 */


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <errno.h>
#include <sys/time.h>
#include <string.h>

#ifndef sequent

extern void	*shm_define();

# define shmalloc(x)	shm_define (x)
# define shfree(x)	free (x)
# define shared
#else
/* because of lines 305-307 in the following defines must be here */
# define volatile
# define private
# include <parallel/parallel.h>
# undef volatile
# undef private

extern void	*bzero();	/* define is insufficient because of  mcrpc_*.c */

# define usleep(m)	sleep (1);

#endif


/*
 * Shared-Memory-Steuerung
 */
typedef	int	m0_shmseg;

extern	void	*get_shared_memory_client();


/*
 * Communication-Identifikation und -Steuerung
 */
typedef	enum	COMMSTATUS {
			comm_null = 0,
			comm_started,
			comm_in_use,
			comm_ended
		} COMMSTATUS;

typedef	struct	COMMLIST {
			char	*communicationid;
			char	*computerid;
			int	processid;
			int	processno;
			unsigned long	prognum;
			COMMSTATUS	commstat;
			struct COMMLIST	*next;
		} COMMLIST;
		
typedef	struct	COMPUTER {
			char	*workstation_class;
			char	*modula_p_workstation_name;
			char	*real_workstation_name;
			COMMLIST	*communicationlist;
		} COMPUTER, *m0_computer;

typedef	struct	COMPUTERLIST {
			m0_computer	wsid;
			struct COMPUTERLIST	*next;
		} COMPUTERLIST;

extern	COMPUTERLIST	**shm_begin_of_workstationlist;
#define begin_of_workstationlist	(*shm_begin_of_workstationlist)


extern	m0_computer	add_computer();	/* COMPUTER (..., ...) */
extern	void	init_communication();	/* INITCOM (..., ..., ...) */


/*
 * Semaphore-Steuerung
 */
typedef	int	m0_semaphore_set;
typedef	unsigned short	m0_semaphore;
extern	int	consume_verbot;

extern	void	sem_init();
extern	void	sem_kill();

extern	void	p_exclusive_sem();
extern	void	v_exclusive_sem();

extern	m0_semaphore	sem_define();
extern	void	consume_global_sem();
extern	void	m0_p();
extern	void	m0_v();


/*
 * Condition-Steuerung
 */
#define m0_condition	m0_semaphore

#define cond_define(c)	sem_define (c)
extern	void	m0_v_and_wait();
extern	void	m0_signal();
extern	int	m0_status();


/*
 * Signal-Steuerung
 */

extern	void	sig_set();



/*
 * Programm-System-Initialisierung
 */
 
extern	int	fork_return_code;	/* for testing the fork-statement */

extern	char	*module_name;	/* is set through processor module */

extern	int	cnt;	/* for starting processes and communications */

extern	void	add_fktn();
extern	void	execute_fktn();

extern	void	first_init();
extern	void	second_init();



/*
 * Program-Abort
 */

extern	void	modula_p_abort();

