.TH MC 1 "22 December 1992"
.SH NAME
mc \- Modula-P: A Compiler for Asynchronously Parallel Programs
.SH SYNOPSIS
.B mc
{ 
.B \-options
} 
[
.I sourcefile
]
.SH DESCRIPTION
.B mc
is the compiler for the parallel programming language
.I Modula-P.
It translates programs written in Modula-P
into C code and then builds executables. The processor module has to be
compiled as the
.I last
module. All highlevel and lowlevel modules used must be reachable via 
import declarations from the processor module and are linked to one executable.

mc calls the C compiler at the local
workstation, if the compilation of Modula-P was successful.

When using COMMUNICATIONS, mc calls rpcgen at the local
workstation and the C compiler at the remote
workstation, if the compilation of the Modula-P COMMUNICATION was successful.

The compiler only takes files ending with
.I .mod 
as input files. If
.I sourcefile 
has not the extension 
.I .mod
, the compiler adds 
.I .mod 
and tries to open the file.

The Modula-P compiler always produces object files with the name
.I sourcefile.m.o.
Here and in the following descriptions,
.I sourcefile
is assumed to be without extension
.I .mod .

.SH OPTIONS
.TP
.BI c fn
use
.I fn
as output name for the generated C file (default is
.I sourcefile.m.c ).
.TP
.B d
include rule or compiler subroutine name whenever errors occur (this feature is  useful only for debugging compiler errors).
.TP
.B l
generate a listing file. The filename of the listing is
.I sourcefile.lis .
.TP
.BI m size
set size for shared memory segment to
.I size
in kByte (default is 64).
.TP
.BI o fn
use
.I fn
as output name for the generated executabnle file.
.TP
.B s
show initialization sequence of the modules
at execution time on standard output.
.TP
.B w
suppress output of warning messages.

.SH ENVIRONMENT
.TP
.B MC_LIBMCLOCAL
if the library
.I libmclocal.a
is not included in the LD_LIBRARY_PATH, you may set this environment
variable to the full path for
.I libmclocal.a .
.TP
.B MC_LIBMCREMOTE
if the library
.I libmcremote.a
is not included in the LD_LIBRARY_PATH of the remote workstation, you may set this environment
variable to the full path for
.I libmclocal.a
. This environment variable only works while compiling COMMUNICATIONS on remote workstations.
.TP
.B MC_INCLUDE
directory path for the include files of the Modula-P compiler. This environment
variable should be set, if the include files are not located
in a standard include path.
.TP
.B MC_CCLOCAL
this environment variable may contain any additional options for the
C compiler for compilations at the local workstation (no COMMUNICATIONS).
.TP
.B MC_LDLOCAL
this environment variable may contain any additional options for the
C compiler for linking (ld) at the local workstation (no COMMUNICATIONS).
.TP
.B MC_REMOTE
this environment variable may contain any additional options for the
C compiler for compiling and linking (ld) at the remote
workstation.
This environment variable only works while compiling COMMUNICATIONS on remote workstations.

.SH SEE ALSO
.TP
cc (1V), rpcgen(1)
