/*
 *	mctypes.h
 */

#ifndef MCTYPES
# define MCTYPES

/*
 * Modula-P Types
 */

# define m0_integer		int
# define m0_shortint		short
# define m0_longint		long
# define m0_POSITIVESHORTINT	short
# define m0_POSITIVEINT		int
# define m0_real		float
# define m0_shortreal		float
# define m0_longreal		double
# define m0_cardinal		unsigned
# define m0_shortcard		short unsigned
# define m0_longcard		long unsigned
# define m0_char		unsigned char
# define m0_byte		short
# define m0_void		void
# define m0_boolean		short


/*
 * Compiler Constants
 */

# define m0_maxint		((int) (((unsigned int)-1)/2))
# define m0_minint		((int) (((unsigned int) m0_maxint) + 1))

# define m0_mincard		((unsigned int) (0))
# define m0_maxcard		((unsigned int) ((int) -1))

# define m0_maxlongint		((long) (((unsigned long)-1)/2))
# define m0_minlongint		((long) (((unsigned long) m0_maxlongint) + 1))

# define m0_minlongcard		((unsigned long) (0))
# define m0_maxlongcard		((unsigned long) ((long) -1))

# define m0_maxshortint		((short) (((unsigned short)-1)/2))
# define m0_minshortint		((short) (((unsigned short) m0_maxshortint) + 1))

# define m0_minshortcard		((unsigned short) (0))
# define m0_maxshortcard		((unsigned short) ((short) -1))

/*
 * Modula-P Constants
 */

# define m0_nil		0
# define m0_false	0
# define m0_true	1

#endif

