
# line 2 "../source/modula.yac"
/*
 *	modula.yac
 */

#include "os.h"
#include "mctypes.h"
#include "mcfktns.h"
#include "symbtbl.h"
#include "mc.h"

#ifdef MSDOS
# include "lex_yy.h"
#endif
#ifndef MSDOS
# include "lex.yy.h"
#endif

	/* maximale Indexanzahl einer einzelnen Array-Definition */
#define	MAX_ARR		10
SymbTblEntry	*(arrayix[MAX_ARR]);

		/*
		 * Folgender define ist noetig,
		 * weil sonst yylval als int definiert wird
		 * ueber ifndef YYSTYPE
		 */
#define	YYSTYPE	YYSTYPESTRUCT

/*	Zum Debug bitte die folgende Zeile hinter den Kommentar versetzen!
	und die Variable yydebug auf 1 setzen!
#define YYDEBUG 1
 */

# line 40 "../source/modula.yac"
typedef union  {
	struct s {
		Flag	flag;

		union art {
			SymbTblEntry	*stbltyp;	/* pointer to symbtblentry of type */
			BlockType	blcktyp;
			OpArt	oa;
			DefArt	da;
		} art;

		union val {
			long	lv;	/* long value */
			double	dv;	/* double value */
			char	*sv;	/* string (pointer) value */
			char	ov[16];	/* operator (string) value */
			SymbTblEntry	*pstbl;	/* pointer to symbtblentry */
		} val;
	} s;
} YYSTYPE;

# line 63 "../source/modula.yac"

/* darf erst nach %union kommen: */
#include "expr.h"
# define AND 257
# define ARRAY 258
# define BEG 259
# define BY 260
# define CASE 261
# define CALL 262
# define COMMUNICATION 263
# define CONST 264
# define DISABLE 265
# define DO 266
# define ELSE 267
# define ELSIF 268
# define ENABLE 269
# define END 270
# define ENTRY 271
# define EVENT 272
# define EXCEPTION 273
# define EXCEPTNO 274
# define EXIT 275
# define EXPORT 276
# define EXTERNAL 277
# define FOR 278
# define FORWARD 279
# define HALT 280
# define HIGH 281
# define IF 282
# define IMPLEMENTATION 283
# define IMPORT 284
# define INITCOM 285
# define INTERRUPT 286
# define LOOP 287
# define LOWLEVEL 288
# define MODULE 289
# define MONITOR 290
# define NOT 291
# define OF 292
# define OR 293
# define PROCEDURE 294
# define PROCESS 295
# define PROCESSID 296
# define PROCESSNO 297
# define PROCESSOR 298
# define RAISE 299
# define RECORD 300
# define REPEAT 301
# define RESTART 302
# define RESUME 303
# define RETURN 304
# define SIGNAL 305
# define START 306
# define STATUS 307
# define THEN 308
# define TO 309
# define TYPE 310
# define UNTIL 311
# define VAL 312
# define VAR 313
# define WAIT 314
# define WHILE 315
# define WITH 316
# define XOR 317
# define BOOLEAN 318
# define COMPUTER 319
# define CONDITION 320
# define POINTER 321
# define SEMAPHORE 322
# define SET 323
# define ASSIGNMENTOP 324
# define RELOP 325
# define MULOP 326
# define PLUSMINUS 327
# define TWOSINGLEDOTS 328
# define INTNUMBER 329
# define REALNUMBER 330
# define STRING 331
# define IDENT 332
# define NEWORDISPOSE 333
# define PORV 334
# define STDFKTN 335

# line 203 "../source/modula.yac"

/* weitere Variablen */

SymbTblEntry	*pstblentry;

IdArt		idart,
		procedure_call /* Zum Test auf Entry, Prozess, Prozedur */;

typedef enum	IdListType {
			parameterlist= 1,
			enumerationlist,
			recordfieldlist
		} IdListType;

IdListType	idlisttype;

typedef struct	ImportSave {
			FILE		*yyin;
			int		yylineno,
					yychar,
					mc_list_lineno;
			char		*yysbuf,
					*yysptr,
					*actual_filename;
			ModuleType	moduletype;
			struct ImportSave *previous;
		} ImportSave;

ImportSave	*pimportsave = NULL;

TypeArt		ta, ta1, ta2, ta3;

/* Fuer Enumeration zum Erkennen der Anzahl Elemente */
int	erange;

/* Fuer alle Prozeduren, in denen RETURN erlaubt ist, zeigt
 * phead auf den Prozedur-Id-Eintrag */
SymbTblEntry	*phead;


/* Makros */

#define	mkimpfnwithoutpath	{\
	import_filename_without_path = strrchr (import_filename, '/');\
	if (import_filename_without_path != NULL) {\
		import_filename_without_path += 1;\
	} else {\
		import_filename_without_path = import_filename;\
	}\
}


#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval, yyval;
typedef int yytabelem;
# define YYERRCODE 256

# line 5164 "../source/modula.yac"


/*
Die syntaktischen Elemente "localident", "constant" und "expression"
wurden nicht weiter aufgeschluesselt.
Ihre Struktur ist die gleiche wie in Modula-2 und ist in der
Modula-P Sprachbeschreibung durch verbale Umschreibungen definiert.
 */

/*
Folgende Regeln werden nicht abgeleitet !?!


set		:	_module_ident_ local_ident
			'('
			setelementlist
			')'
		;

setelementlist	:	setelementlist
			','
			caselabel
		|	caselabel
		;


constantexpr ...	|	constset

constset	:	_qualident_
			'{'
			constsetlist
			'}'
		;

constsetlist	:	constsetlist
			','
			constsetlistel
		|	constsetlistel
		;

constsetlistel	:	constantexpr
			TWOSINGLEDOTS
			constantexpr
		|	constantexpr
		;

expression ...	|	set


--> folgendes bereits ueber designator erledigt !!!
		|		{
					put_expr_pos ();
					$$.s.flag = null_flag;
					$$.s.flag.is_expr = 1;
				}
			entrycall {
					ta = $2.s.art.stbltyp->u.oftype->tart;
					if (ta.is_array || ta.is_record || ta.is_char) {
						put_expr_pos ();
					} else {
						get_expr_pos ();
					}
					$$ = $2;
				}





set		:	_qualident_ {
message (D_FATAL, "yyparse (set): Set-Implementation failed");
				}
			'{'
			setlist
			'}'
		;

setlist		:	setlist
			','
			setlistel
		|	setlistel
		;

setlistel	:	expression {
message (D_WARN, "setlistel: Expr vom Typ char ist noch nicht ausgegeben (ACHTUNG: Unterschied bei flag is_const ja/nein)");
				}
			TWOSINGLEDOTS
			expression {
message (D_WARN, "setlistel: Expr vom Typ char ist noch nicht ausgegeben (ACHTUNG: Unterschied bei flag is_const ja/nein)");
				}
		|	expression {
message (D_WARN, "setlistel: Expr vom Typ char ist noch nicht ausgegeben (ACHTUNG: Unterschied bei flag is_const ja/nein)");
				}
		;

_qualident_	:	qualident
		|
		;

qualident	:	ident {
					if ((pstblentry = symbtbllookup (id_name)) == NULL) {
						message (D_ERROR, "yyparse (qualident): Identifier '%s' not declared", id_name_fuer_fehlertext);
					}
					if (pstblentry->iart.is_constid) {
						$$.s.flag.is_const = 1;
					} else if (pstblentry->iart.is_varid) {
						$$.s.flag.is_const = 0;
					} else {
						message (D_ERROR, "yyparse (qualident): Identifier '%s' is no Variable or Constant", id_name_fuer_fehlertext);
						YYERROR;
					}
					$$.s.val.pstbl = pstblentry;
					$$.s.art.stbltyp = pstblentry->ofstblentry;
				}
			'.'
			ident
		|	ident
		;

*/

yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 227,
	267, 318,
	268, 318,
	270, 318,
	311, 318,
	59, 318,
	124, 318,
	-2, 316,
-1, 358,
	332, 480,
	-2, 485,
-1, 361,
	325, 0,
	61, 0,
	-2, 505,
-1, 362,
	325, 0,
	61, 0,
	-2, 506,
-1, 386,
	64, 134,
	-2, 130,
-1, 631,
	332, 480,
	-2, 485,
-1, 667,
	325, 0,
	61, 0,
	-2, 520,
-1, 668,
	325, 0,
	61, 0,
	-2, 522,
-1, 708,
	332, 480,
	-2, 485,
-1, 824,
	332, 480,
	-2, 485,
-1, 825,
	332, 480,
	-2, 485,
	};
# define YYNPROD 545
# define YYLAST 1089
yytabelem yyact[]={

   228,   465,   192,   191,   680,   818,   687,   244,   678,   253,
   659,   611,   561,    18,    71,   681,   661,   464,    29,    11,
    40,   162,    69,    42,   682,    50,    29,   408,    41,   466,
    14,   349,   257,    20,    62,   459,   455,   145,   195,   492,
    23,   187,   376,   390,   179,   302,   454,    50,   252,    56,
    57,   194,    59,   262,    48,    19,   411,   273,   645,    62,
   168,   444,    16,    27,   196,    16,   375,   176,   239,   164,
   782,   104,   319,   121,   328,   118,   115,   351,   101,   350,
   235,   392,   132,   164,   114,   117,   120,   232,   510,   306,
   274,    24,   602,   360,   510,   217,   664,   506,    97,   341,
   309,   135,   233,   234,   716,    43,   127,   623,    44,    44,
    45,   274,   182,   231,   715,   446,   809,   553,   230,   357,
   164,   355,    96,    12,   161,   440,   108,   140,   109,   172,
   512,   175,   112,   183,   161,   263,   169,    19,    19,   238,
   190,   237,    19,    19,    44,   129,   417,   276,   157,    19,
   148,    19,    19,   136,   511,     6,   256,   514,   184,   278,
   161,   161,    33,   514,   513,   161,   473,    70,   245,   309,
   170,   275,    79,   381,    80,   808,   372,   826,   183,   342,
   278,   277,   245,   697,   280,   281,   262,     9,   288,   282,
   556,    44,   798,   250,    43,   251,   769,     7,    44,    45,
    74,   263,   823,    72,   138,   736,   735,   587,   662,   796,
   721,   590,   525,    17,    73,   633,   469,   773,   306,   306,
   451,   410,   610,   344,   524,   126,   733,   178,   811,   141,
    55,   783,   763,   546,   386,   528,   573,   745,   133,   122,
   335,   180,    89,   485,   478,   556,   306,   816,   779,    61,
   476,    49,   262,   274,   293,   336,   739,   509,   812,   477,
    28,   486,   340,   161,   806,   475,   787,   699,   698,   292,
   825,   734,   695,   161,   161,   161,   161,   161,   161,   161,
   527,   646,   625,   529,   161,   679,   377,   353,   540,   276,
   449,   448,   387,   382,    19,   352,   183,   361,   362,   363,
   364,   365,   366,   367,   348,   347,   300,   308,   370,   290,
   311,   307,   432,   275,   271,   249,   154,    19,   295,   152,
   159,   272,   278,   277,   453,    19,   418,    19,   422,   426,
   433,   722,   294,   435,   159,   437,    19,   143,   150,   147,
   443,   519,   146,    99,   415,   824,    87,   378,   415,    54,
    52,   415,   310,   268,   718,   456,   160,   462,   166,   167,
   163,    19,   158,   420,   165,   551,   425,   186,   710,   161,
   160,   159,   166,   167,   163,    19,   308,   394,   165,   311,
   273,   480,   709,   423,   256,   452,   427,   558,   441,   461,
   298,    60,   303,   471,   256,   269,   438,   412,    47,   388,
   490,   557,   320,   488,   498,   291,   660,   160,   384,   166,
   167,   163,    19,   261,   737,   165,   270,   255,   264,   268,
   421,   310,   674,   421,   415,   820,   632,    19,   415,   521,
   305,   415,   481,   413,   523,   166,   167,   416,   742,   509,
   537,   345,   509,   346,   739,    86,   541,   489,   690,   491,
    98,   691,   161,   510,   161,   657,   415,   549,   256,   497,
   548,   269,   542,   502,   256,   548,   505,   550,   456,   499,
   501,   256,   503,   554,   615,   767,   545,   761,   547,   261,
   562,   753,   270,   161,   264,   692,   614,   658,   456,   512,
   656,   532,   379,    19,   655,   494,   495,   496,   654,   574,
   500,   500,   653,   500,   616,   535,   509,   572,   188,   570,
   517,   403,   368,   511,   559,   415,   334,   333,   332,   331,
   318,   508,   514,   513,   317,   566,   315,   314,   313,   312,
   283,   246,   534,    26,   577,    39,    37,   415,   415,   518,
   415,    15,   414,   516,   515,   597,   596,   595,   594,   593,
   578,   592,   591,   619,    38,   470,    21,   359,   822,    51,
   817,   637,   790,   636,   635,   161,    67,   560,   377,   377,
    68,    66,   598,   599,   648,   600,   274,   563,   468,   751,
   634,   620,   467,   631,   708,   555,   358,    93,   460,   639,
   630,   552,   665,   624,   705,   638,   613,   463,   703,   629,
   458,   617,   356,   267,   161,   266,   265,   641,   689,   685,
   642,   643,   276,   415,   415,   415,   415,   415,   415,   415,
   651,   650,   544,   700,   415,   450,   640,   500,   457,   456,
   256,   462,   500,   354,   415,   510,   275,   415,   510,   704,
   260,   675,   259,   684,   272,   278,   277,   258,   667,   668,
   669,   670,   671,   672,   673,   254,   786,   696,   723,   676,
   538,   707,   701,   461,   338,   702,   706,   539,   442,   693,
   730,   512,   694,   339,   512,   337,   242,   243,   241,   618,
   439,   240,   144,    76,   273,   149,   113,    83,    75,   793,
   720,   728,   564,   649,   484,   511,   299,   746,   511,   103,
   421,   137,   510,   508,   514,   513,   508,   514,   513,   273,
   415,   752,   273,   102,   807,   509,   627,   748,    93,   161,
   543,   764,   747,   622,   447,   248,   750,    82,   153,   119,
   770,    85,   771,   759,   760,   758,   757,   749,   512,    81,
   161,   755,   571,   762,   626,   743,   380,   415,   472,   774,
   173,   289,   256,   369,   174,   780,   785,   130,   128,    95,
   628,   562,   511,   788,   789,   765,   256,   652,   273,   487,
   508,   514,   513,   273,   161,   794,   161,   795,   391,   800,
   801,   802,   768,   161,   799,   576,   393,   189,   575,   389,
   301,   805,   111,   110,   621,   445,   247,    78,   797,   810,
   343,   151,   116,    84,    77,   329,   815,   804,   683,   604,
   161,   424,   327,   407,   819,   531,   193,   536,   821,   605,
   781,   224,   239,   740,   161,   225,   828,   829,   819,   827,
   803,   738,   778,   777,   235,   207,   776,   775,   222,   732,
   209,   232,   219,   677,   603,   214,   326,   223,   814,   772,
   218,   731,   520,   324,   325,   493,   233,   234,   398,   212,
   601,   221,   215,   213,   227,   211,   216,   231,   323,   666,
   507,   322,   230,   727,   208,   220,   226,   663,   419,   589,
   274,   729,   588,   224,   239,   409,   726,   225,   586,   504,
   321,   612,    19,   238,   210,   237,   235,   207,   744,   609,
   222,   608,   209,   232,   219,   274,   530,   214,   274,   223,
   688,   510,   218,   784,   607,   741,   276,   686,   233,   234,
   606,   212,   526,   221,   215,   213,   227,   211,   216,   231,
   431,   430,   429,   236,   230,   436,   208,   220,   226,   533,
   275,   276,   434,   229,   276,   428,   522,   512,   272,   278,
   277,   330,   406,   725,    19,   238,   210,   237,   397,   396,
   724,   585,   405,   584,   274,   275,   404,   813,   275,   274,
   766,   511,   583,   272,   278,   277,   272,   278,   277,   508,
   514,   513,   316,   582,   402,   581,   401,   580,   400,   579,
   399,   206,   205,   204,   203,   202,   201,   200,   199,   198,
   276,   197,   395,   142,   107,   276,   106,   719,   483,   792,
   647,   482,   385,   296,   383,   181,   177,   155,    88,    46,
   711,   279,   156,   123,   275,    53,    25,   297,   100,   275,
    58,   131,   272,   278,   277,    94,    92,   272,   278,   277,
    32,    36,    65,    64,   791,   756,   754,   712,   474,   714,
   717,   713,   644,   569,   479,   568,   567,   374,   373,   285,
   286,   565,   371,   284,   125,   304,   139,   124,    90,    30,
   287,   171,    91,    31,    13,   105,    35,    22,     8,   185,
   134,    63,    34,    10,     5,     4,     3,     2,     1 };
yytabelem yypact[]={

  -101, -1000, -1000, -1000, -1000, -1000, -1000, -1000,  -166, -1000,
  -166,   -51,  -277,  -166,   -51, -1000,  -219,     4, -1000, -1000,
  -124, -1000,  -185, -1000,    -5,  -277, -1000, -1000,   291, -1000,
   290, -1000,   -51,    -7,   -96,   -56, -1000, -1000, -1000, -1000,
 -1000,  -105, -1000, -1000, -1000, -1000,  -277, -1000, -1000,   287,
 -1000, -1000, -1000,   181, -1000,  -150, -1000,  -219,  -277, -1000,
 -1000,   284, -1000,   -56, -1000, -1000, -1000, -1000, -1000, -1000,
  -277, -1000, -1000, -1000, -1000, -1000,   -51, -1000,   -51, -1000,
 -1000, -1000,   -51,  -180,  -181,  -183, -1000, -1000,   178, -1000,
   -31,   -56, -1000, -1000, -1000,   -51, -1000,  -231, -1000, -1000,
   177,  -197, -1000,   -51, -1000,  -162, -1000, -1000, -1000, -1000,
   283,   280, -1000, -1000, -1000,   279, -1000, -1000,   260, -1000,
 -1000,   257, -1000,    43, -1000,  -148,  -113,  -159, -1000, -1000,
  -189, -1000,   -15,    80, -1000, -1000, -1000,   468, -1000,  -277,
 -1000, -1000,   560, -1000,  -103,  -186, -1000, -1000,  -186,   256,
 -1000,   468, -1000,   468, -1000,   161,   255,   319, -1000,    80,
    80, -1000, -1000, -1000,    80,   490, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000,   -56, -1000, -1000,   250,  -277, -1000, -1000,
   210,   274, -1000, -1000,   319,  -162,  -150,   247, -1000,   334,
 -1000, -1000,   160,    41, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,   489, -1000,
   488,   487,   486, -1000, -1000,   484,   480,  -252,   356, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000,  -242, -1000, -1000,   479,
   478,   477,   476, -1000, -1000, -1000, -1000, -1000, -1000,  -277,
   -56, -1000, -1000, -1000, -1000, -1000, -1000,   -56,   -94, -1000,
   164,   246, -1000,   245,  -243,   236, -1000, -1000, -1000, -1000,
 -1000, -1000,    80, -1000,  -171, -1000, -1000, -1000,  -173, -1000,
  -216, -1000,    80,    80,    80,    80,    80,    80,    80,   472,
 -1000, -1000,   712,    80,  -100,  -190,  -148,  -162,   -99,   234,
 -1000, -1000, -1000, -1000, -1000,  -277,   143,   233, -1000,   -94,
 -1000,  -232, -1000, -1000,   331, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000,   471, -1000, -1000, -1000,
 -1000,   -35,   106,   622,  -194,   622,   106,  -194,  -277,   106,
   272, -1000,  -277, -1000,  -277,   338,  -165, -1000,   -51,  -195,
  -179, -1000,   232, -1000, -1000, -1000, -1000, -1000, -1000,   231,
   129, -1000, -1000,    -4,  -277, -1000,   -38, -1000,   -45, -1000,
 -1000,  -146,  -146, -1000,  -167,  -167,  -167, -1000,    80, -1000,
   707,  -117, -1000, -1000,   206,   200, -1000, -1000, -1000, -1000,
  -277, -1000, -1000,   161, -1000, -1000, -1000, -1000, -1000,   202,
 -1000, -1000, -1000,    95, -1000,   622,   560,   622, -1000,  -194,
  -194,  -194,   106,  -277,  -194,  -194,   106,  -194, -1000,   106,
  -211,   378, -1000, -1000,  -194, -1000, -1000, -1000,    30,   110,
 -1000,  -252,   159,   654,   165, -1000,   -54,   378, -1000,   189,
 -1000, -1000, -1000, -1000,   106, -1000,  -194,   464, -1000,  -277,
 -1000, -1000, -1000, -1000,   229,  -277, -1000,   -56, -1000, -1000,
 -1000,    80,   140,    80,   416, -1000, -1000,    95,    73, -1000,
 -1000, -1000, -1000,    95, -1000,   131, -1000,  -277, -1000, -1000,
    95,   648, -1000, -1000,   -51, -1000, -1000, -1000, -1000,   469,
 -1000, -1000,    80,   172,   -56, -1000, -1000,  -277, -1000, -1000,
 -1000, -1000, -1000,   106, -1000, -1000, -1000,   378, -1000, -1000,
 -1000, -1000,   378, -1000,   -61,   378, -1000,   -55, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000,   106,   106, -1000,   106, -1000,
  -217, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
   -34,  -194,   445,   430,   463, -1000,  -194, -1000,   -56,   468,
 -1000, -1000,  -188,   -51,   223,   651, -1000,   623, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,   156,   421,
  -277, -1000, -1000,  -243,    80,  -148,  -219,  -277,  -277, -1000,
  -273,   222,   319,  -277, -1000,   334,  -232,   421,   378,   461,
   457,   453,   449,   411,   446,   362,   -59, -1000,  -212,   622,
 -1000,   106,   106,   106,   106,   106,   106,   106, -1000, -1000,
   381, -1000,   106,    29,  -194,   560, -1000,  -277, -1000,   407,
   444, -1000,   106, -1000, -1000,   106, -1000, -1000,   213,   -88,
   209,   208,  -277, -1000, -1000, -1000, -1000, -1000,  -277,    95,
   -38,   -45, -1000, -1000,   324, -1000,   310, -1000, -1000,   319,
 -1000, -1000, -1000, -1000,  -184, -1000, -1000,   296, -1000,   -53,
 -1000, -1000,   273, -1000, -1000, -1000, -1000,  -277, -1000, -1000,
 -1000, -1000, -1000,   -35, -1000,   187,   560,  -163,  -163, -1000,
  -169,  -169,  -169, -1000, -1000, -1000,   378,   102, -1000,   147,
   400, -1000,   319, -1000, -1000, -1000,   394, -1000,   106, -1000,
 -1000, -1000, -1000,   378,   196, -1000,  -277, -1000, -1000, -1000,
 -1000,  -186, -1000, -1000, -1000,  -243, -1000, -1000,   -45, -1000,
  -277,   440,   -96, -1000,  -166, -1000, -1000,   436,    80,   139,
  -277, -1000, -1000, -1000,   434,   106,   -74,   622, -1000,   622,
 -1000,   -43,   -59, -1000, -1000, -1000, -1000, -1000,   190,    80,
  -258,   138, -1000,   378, -1000, -1000, -1000,   207,   -56, -1000,
 -1000,    95, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000,   319, -1000, -1000,    95,   362, -1000,   378, -1000,
   187,   187,   -57,    80,   -78,    80,   622,   622,   622, -1000,
 -1000, -1000,    80, -1000, -1000, -1000,   205, -1000,   -98, -1000,
  -176,   -89,   135,   199, -1000, -1000, -1000,   319, -1000, -1000,
   187,   187,   187,   622,   319, -1000, -1000,   188, -1000,    80,
 -1000, -1000, -1000,   384,   560,   187, -1000,    78, -1000,   212,
 -1000, -1000,   -93,    80,   -45,   -45, -1000, -1000,   186,   186 };
yytabelem yypgo[]={

     0,  1088,  1087,  1086,  1085,  1084,  1083,    19,   541,  1082,
  1081,    14,  1080,  1079,   204,  1078,  1077,  1076,  1075,  1074,
  1073,   230,  1072,  1071,  1070,     0,  1069,  1068,  1067,  1066,
  1065,  1064,    60,  1063,  1062,  1061,  1060,  1059,  1058,  1057,
  1056,    42,  1055,  1054,  1053,  1052,  1051,  1050,  1049,  1048,
    50,    40,  1047,  1046,    28,  1045,    23,    22,    20,  1044,
     7,  1043,  1042,   536,   531,   535,  1041,  1040,    49,  1036,
  1035,  1031,  1030,   391,  1028,    24,  1027,  1026,   533,  1025,
  1023,  1022,  1021,  1020,  1019,   398,  1018,  1017,    48,  1016,
   227,  1015,  1014,   112,  1013,  1012,  1011,  1010,  1009,  1008,
  1007,  1006,   229,  1004,  1003,     3,     2,  1002,    51,    38,
    64,  1001,   999,   998,   997,   996,   995,   994,   993,   992,
   991,   990,    95,   989,   988,   987,   986,   985,   984,    56,
   983,   982,   972,   970,    10,   967,   966,   963,   962,   961,
   960,   959,   958,   953,   952,   951,   945,   943,   942,   939,
   935,   933,   932,   931,   930,   922,   920,   917,   915,   914,
   913,     6,   910,   906,   901,   899,   898,    11,   891,   890,
    27,   889,   888,    16,   886,   885,   882,   881,   879,   877,
   873,   871,   870,   869,   868,   860,    39,   858,   855,   854,
   853,   852,   851,   849,   848,   846,   844,   843,   839,   837,
     8,   836,   833,   832,     4,   831,   830,    15,   823,   820,
   819,   817,   815,   813,   812,   811,   809,   808,   805,    37,
   804,   803,   802,   801,    41,   800,   797,   796,   795,   794,
   793,   792,   790,   789,   788,    45,   787,   786,     9,   785,
    43,   778,   769,    46,   767,   765,   760,    36,   759,   758,
   757,   754,   751,   750,   746,   742,   739,   731,   729,   728,
   727,   725,    99,   724,   723,   722,   720,   717,   714,   713,
   701,   699,   696,   694,   693,   690,   689,   688,   687,   686,
   685,   683,   682,   681,   680,   679,   678,   677,   675,   673,
   668,   667,   664,   660,   657,   656,   655,    31,    32,   647,
   642,   640,   633,   628,   625,   622,   606,   605,   603,   602,
   600,   599,   598,   597,   594,   591,   590,    35,   588,   586,
    17,     1,   585,   584,   583,    29,   582,   580,   579,    12,
   578,   577,   567,   564,   563,   562,   560,   558,     5,   557,
   555,    21,   552,   551,   549,   548,   547,   546,   545,   544,
   543,   542,   539 };
yytabelem yyr1[]={

     0,     1,     2,     2,     2,     2,     6,    10,    13,     3,
    12,    12,    15,    17,    18,     4,    19,    22,    24,     5,
    23,    23,    26,    27,     7,    30,    14,    29,    29,    31,
    33,    35,    28,    36,    28,    37,    32,    32,    38,    38,
    40,    39,    39,    42,    39,    39,    43,    45,    41,    47,
    44,    44,    46,    48,    48,    48,    49,    34,    34,    52,
    52,    53,    53,    53,    53,    55,    59,    59,     8,     9,
     9,    61,    61,    61,    61,    16,    16,    66,    66,    66,
    20,    21,    21,    69,    69,    68,    67,    67,    67,    72,
    72,    72,    74,    76,    73,    50,    50,    77,    77,    77,
    77,    79,    80,    78,    81,    82,    83,    81,    51,    51,
    84,    84,    84,    84,    86,    87,    85,    71,    71,    89,
    89,    89,    89,    89,    92,    90,    91,    91,    94,    93,
    96,    97,    98,    95,    99,   100,    95,    95,   101,    11,
    11,   103,    11,   104,   102,   105,   105,   107,   106,   106,
   108,   108,   108,   108,   108,   108,   108,   108,   108,   108,
   108,   108,   108,   121,   123,   108,   108,   124,   125,   108,
   126,   127,   108,   128,   130,   108,   108,   131,   132,   133,
   135,   108,   136,   137,   108,   138,   139,   140,   108,   141,
   108,   142,   108,   108,   143,   134,   134,   144,   109,   145,
   122,   148,   122,   149,   122,   150,   122,   122,   122,   122,
   122,   122,   147,   147,   146,   146,   146,   152,   152,   156,
   158,   155,   159,   155,   155,   160,   157,   157,   162,   161,
   163,   153,   164,   164,   166,   165,   165,   168,   167,   169,
   172,   174,   112,   175,   176,   177,   170,   178,   170,   179,
   171,   171,   180,   173,   173,   181,   182,   183,   113,   184,
   185,   114,   187,   114,   188,   186,   189,   116,   190,   191,
   192,   194,   115,   193,   193,   195,   196,   198,   117,   199,
   197,   197,   197,   201,   197,   202,   197,   203,   197,   205,
   206,   200,   204,   204,   208,   207,   209,   209,   210,   119,
   110,   211,   151,   212,   154,   213,   111,   214,   118,   118,
   216,   215,   215,   215,   217,   217,   218,   120,   120,   219,
   219,    64,   221,    54,   223,   222,   222,   225,   225,   225,
   226,   227,   229,   220,   230,   220,   231,   220,   228,   228,
   232,   234,   224,   236,   224,   237,   235,   235,   239,   233,
   233,   242,   244,   245,   240,   241,   241,   246,   243,   243,
   247,    70,   250,   248,   252,   251,   251,   253,   255,   249,
   254,   254,    65,   257,    56,   259,   258,   258,   260,   261,
   263,   265,   256,   264,   264,   266,   267,   262,   262,   268,
   268,    62,   270,    57,   271,   272,   273,   274,   276,   269,
   275,   275,    63,   278,    58,   280,   279,   279,   281,   283,
   285,   277,   282,   282,   286,   286,   284,   284,   287,   289,
    60,   291,   290,   290,   292,   293,   295,   288,   294,   294,
    88,   296,    88,    88,   238,   238,   238,   238,   238,   238,
   298,   302,   299,   303,   300,   305,   297,   297,   304,   304,
   304,   301,   301,   301,   309,   311,   306,   313,   306,   312,
   314,   312,   316,   310,   310,   315,   315,   317,   318,   318,
   319,   307,   320,   322,   322,   323,   322,   324,   321,   321,
   326,   327,   328,   325,   325,   325,   329,   331,   329,   332,
   330,   335,   333,   334,   334,   337,   337,   336,   336,   338,
   308,   340,   339,   339,    25,    75,    75,    75,    75,    75,
    75,    75,    75,    75,    75,    75,    75,    75,    75,   342,
   129,   343,   129,   344,   129,   345,   129,   346,   129,   347,
   129,   348,   129,   349,   129,   350,   129,   351,   129,   129,
   129,   352,   129,   341,   341 };
yytabelem yyr2[]={

     0,     3,     2,     2,     2,     3,     1,     1,     1,    20,
     2,     1,     1,     1,     1,    16,     1,     1,     1,    20,
     2,     1,     1,     1,    13,     1,     8,     2,     1,     1,
     1,     1,    14,     1,     8,     1,     6,     0,     4,     4,
     1,     8,     2,     1,     8,     0,     1,     1,    11,     1,
     8,     0,     4,     2,     0,     2,     1,    11,     0,     4,
     0,     3,     3,     3,     3,     4,     5,     0,     4,     4,
     0,     2,     2,     2,     2,     4,     0,     2,     2,     2,
     4,     4,     0,     2,     2,     6,     4,     4,     0,     4,
     2,     4,     1,     1,    12,     4,     0,     4,     2,     2,
     4,     1,     1,    12,     3,     1,     1,    16,     4,     0,
     4,     2,     2,     4,     1,     1,    10,     5,     0,     4,
     2,     2,     4,     4,     1,     8,     6,     2,     1,     6,
     1,     1,     1,    16,     1,     1,    12,     0,     1,     7,
     3,     1,     7,     1,     5,     4,     5,     1,     8,     2,
     2,     2,     3,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     3,     1,     1,    12,     3,     1,     1,    12,
     1,     1,    12,     1,     1,    12,     3,     1,     1,     1,
     1,    22,     1,     1,    12,     1,     1,     1,    16,     1,
     8,     1,     8,     0,     1,     7,     1,     1,     9,     1,
     7,     1,    11,     1,    15,     1,    11,     9,     3,     3,
     3,     2,     2,     2,     2,     2,     2,     5,     1,     1,
     1,    11,     1,     7,     3,     1,     9,     2,     1,     5,
     1,     7,     5,     5,     1,     9,     2,     1,     5,     1,
     1,     1,    16,     1,     1,     1,    12,     1,     8,     1,
     8,     0,     1,     6,     0,     1,     1,     1,    15,     1,
     1,    12,     1,     8,     1,     5,     1,     9,     1,     1,
     1,     1,    23,     5,     1,     1,     1,     1,    19,     1,
     8,     2,     5,     1,     8,     1,     8,     1,     8,     1,
     1,    10,     7,     2,     1,     7,     5,     0,     1,    12,
     3,     1,    11,     1,     7,     1,     9,     1,     9,     5,
     1,     8,     2,     0,     2,     0,     1,     7,     3,     4,
     0,     4,     1,     7,     1,     9,     5,     2,     3,     3,
     1,     1,     1,    18,     1,     6,     1,     6,     3,     0,
     1,     1,    12,     1,     4,     1,     7,     1,     1,     9,
     2,     1,     1,     1,    15,     3,     1,     1,     9,     2,
     3,     4,     1,     7,     1,     7,     5,     1,     1,    14,
     3,     0,     4,     1,     7,     1,     9,     5,     1,     1,
     1,     1,    22,     2,     1,     1,     1,    18,     0,     2,
     1,     4,     1,    11,     1,     1,     1,     1,     1,    24,
     2,     1,     4,     1,     7,     1,     7,     5,     1,     1,
     1,    18,     4,     0,     2,     2,     2,     1,     4,     1,
     7,     1,     9,     5,     1,     1,     1,    16,     3,     0,
     4,     1,     6,     4,     3,     2,     2,     2,     2,     3,
    11,     1,     9,     1,     9,     1,     9,     3,     7,     5,
     1,     2,     2,     2,     1,     1,    13,     1,     9,     2,
     1,     5,     1,     8,     2,     2,     1,     3,     2,     3,
     1,     7,     5,     3,     5,     1,     8,     1,     9,     3,
     1,     1,     1,    13,     2,     1,     2,     1,     5,     1,
     6,     1,    16,     3,     0,     4,     0,     6,     2,     6,
     5,     1,     7,     1,     2,     7,     7,     7,     7,     7,
     7,     7,     5,     5,     3,     3,     3,     7,     9,     1,
     9,     1,     9,     1,     9,     1,     9,     1,     9,     1,
     9,     1,     9,     1,     7,     1,     7,     1,     5,     3,
     3,     1,     9,     2,     2 };
yytabelem yychk[]={

 -1000,    -1,    -2,    -3,    -4,    -5,   256,   298,   -15,   288,
    -6,    -7,   289,   -19,    -7,    -8,   -50,   264,   -25,   332,
    -7,    -8,   -16,   -51,   310,   -77,   -78,    59,   256,   -25,
   -26,   -20,   -67,   286,    -9,   -17,   -66,   -63,   -64,   -65,
   -58,   -54,   -56,   290,   294,   295,   -84,   -85,    59,   256,
   -25,   -78,    59,   -79,    59,   -21,   -68,   -50,   -72,    59,
   -73,   256,   -25,   -10,   -61,   -62,   -63,   -64,   -65,   -57,
   263,   -11,   259,   270,   256,  -277,  -281,  -220,  -226,   277,
   279,  -256,  -260,  -278,  -221,  -257,   -85,    59,   -86,    61,
   -27,   -22,   -69,   -64,   -70,  -248,   272,   -51,   -73,    59,
   -74,   -11,  -269,  -271,   -25,   -18,  -101,  -103,   -68,   -68,
  -230,  -231,   -68,  -279,   -25,   256,  -222,   -25,   256,  -258,
   -25,   256,    61,   -80,   -28,   -31,   256,   -11,  -249,   -68,
  -250,   -71,   313,    61,   -12,   298,   -68,  -270,   -14,   -29,
   289,  -102,  -104,  -102,  -282,  -219,    59,    59,  -219,  -280,
    59,  -223,    59,  -259,    59,   -87,   -81,   -75,   319,   291,
   327,   -25,  -341,   331,    40,   335,   329,   330,   -32,   284,
   283,   -23,   288,  -253,  -251,   -25,   256,   -89,   -90,    59,
   256,   -91,   -93,   -25,   -75,   -13,   -21,  -224,    40,  -236,
   -25,  -105,  -106,   256,  -108,  -109,  -110,  -111,  -112,  -113,
  -114,  -115,  -116,  -117,  -118,  -119,  -120,   275,   314,   280,
   334,   305,   299,   303,   285,   302,   306,  -122,   290,   282,
   315,   301,   278,   287,   261,   265,   316,   304,   -25,  -147,
   312,   307,   281,   296,   297,   274,  -151,   335,   333,   262,
  -283,  -286,   -64,  -287,   -60,   271,   -64,  -227,  -261,    59,
  -224,  -224,   -88,  -238,  -296,   256,   -25,  -298,  -299,  -300,
  -301,   318,    91,    40,   323,  -306,  -307,  -308,   258,   300,
   321,    59,   325,    61,   257,   317,   293,   327,   326,   -82,
   -75,   -75,   -75,    40,   -33,   -37,   -36,   -24,   -11,  -252,
    59,   -90,    59,    44,    58,    44,   -94,   -76,   -14,  -272,
    59,  -232,  -235,    58,   -30,   270,    59,   270,   266,    59,
   311,   269,    40,    40,    40,    40,  -131,    40,    40,   324,
    46,  -169,  -181,  -184,  -190,  -189,  -195,  -214,   316,  -218,
  -145,    40,    40,    40,    40,   -25,   -11,  -288,  -292,  -289,
   -11,  -262,   273,  -225,    59,   277,   279,    59,    59,  -297,
   322,   320,    59,   -75,  -302,   292,  -309,   292,  -319,  -339,
   309,   -75,   -75,   -75,   -75,   -75,   -75,   -75,    40,    41,
   -75,   -34,   276,   -38,   -39,   256,   -41,   -25,   -32,   -14,
  -254,   272,    59,   -92,   -93,   -95,    91,    59,  -262,  -233,
  -240,  -241,   313,  -237,    46,  -107,  -141,  -142,  -187,  -121,
  -124,  -126,  -128,    40,  -136,  -138,  -144,  -213,  -170,  -175,
   256,  -129,   291,   327,  -351,  -341,   331,    40,  -106,   256,
  -109,  -122,  -106,  -129,  -215,  -109,   -25,  -129,  -146,  -152,
  -153,  -154,    40,    58,  -148,   -25,  -150,   -25,    58,  -284,
   290,   -68,  -290,   -25,   256,  -228,   294,  -263,    59,    59,
  -304,    91,   256,   328,  -243,  -247,   -25,  -303,  -310,  -317,
  -318,  -298,   -25,  -313,  -320,  -321,  -325,  -326,  -330,   261,
  -340,   -75,    41,   283,   -49,    59,    44,    59,    44,   -43,
   -25,   -88,   -96,   -99,  -273,    41,    59,  -242,  -238,  -108,
  -105,  -108,  -186,  -188,  -122,  -122,  -122,  -129,   -25,  -110,
  -122,  -110,  -129,  -110,  -171,  -129,   308,  -182,   325,    61,
   257,   317,   293,   327,   326,  -349,  -350,  -122,  -352,   311,
  -191,   270,   292,   269,    59,   266,  -155,    91,    46,    94,
  -163,  -212,  -129,  -149,  -122,    41,  -211,   -25,  -293,  -291,
    59,   -25,   -11,  -266,  -305,   -75,    93,   -75,    44,    41,
  -238,   292,  -315,    44,  -238,  -322,    59,   270,   256,  -243,
  -332,  -329,  -238,  -331,    44,   -35,   -50,   -40,   -42,   -44,
    40,  -255,   -75,    64,   -11,  -234,  -239,  -243,  -129,  -123,
  -125,  -127,  -130,  -132,  -137,  -139,  -172,   268,  -176,  -178,
   266,  -342,  -343,  -344,  -345,  -346,  -347,  -348,  -129,  -129,
  -129,  -185,   309,  -196,  -216,  -210,  -156,  -159,  -164,  -165,
   256,  -167,  -168,  -110,    41,    44,    41,  -110,  -285,   -11,
  -224,  -229,  -264,   295,   -68,    59,    93,    93,  -246,  -311,
  -316,  -324,   270,    59,  -327,  -333,  -334,   -25,  -297,   -75,
   -32,   -51,   -41,   -41,   -45,   331,    59,   -97,   -25,  -274,
  -235,  -240,  -244,    41,    41,    41,    41,    44,    41,  -134,
    44,  -173,   267,  -179,   308,  -106,  -183,  -129,  -129,  -129,
  -129,  -129,  -129,  -129,    41,  -186,  -129,  -197,  -200,   256,
  -204,  -207,   -75,  -217,  -109,  -105,  -157,  -161,  -162,   -25,
    41,    44,    41,  -129,  -129,    59,  -294,   271,    59,    59,
   -25,  -219,  -247,  -312,  -238,  -314,  -317,  -325,  -323,    58,
    58,   -83,   -52,   -46,   -48,   298,   288,   -47,    58,  -100,
  -275,   263,    58,   -25,  -140,  -143,  -174,  -180,  -170,  -177,
  -105,  -192,  -198,   124,   124,    59,    58,   267,  -205,    44,
  -208,  -158,    44,  -129,  -166,    41,   -25,  -265,  -267,  -297,
  -320,  -328,   -25,    41,   -53,   -54,   -55,   -56,   -57,   -58,
    -7,    41,   -75,    93,   -25,  -245,  -133,    41,  -129,   270,
  -106,  -106,  -193,   260,  -173,  -199,  -201,  -202,  -203,    58,
  -207,  -209,   328,    93,  -160,  -167,  -295,    59,   -11,  -329,
  -335,   -59,   -98,  -276,  -238,  -134,   266,   -75,   270,  -200,
  -106,  -106,  -106,  -206,   -75,  -161,    59,  -268,   273,   292,
   -60,    93,    59,  -135,  -194,  -106,    59,  -336,  -338,  -204,
    41,  -105,  -337,   124,   267,    58,   270,  -338,  -321,  -321 };
yytabelem yydef[]={

    12,    -2,     1,     2,     3,     4,     5,     6,     0,    16,
     0,    96,     0,     0,    96,    76,   109,     0,    22,   504,
    88,    70,    13,    68,     0,    95,    98,    99,     0,   101,
     0,    82,    96,     0,     7,     0,    75,    77,    78,    79,
   408,   330,   378,   403,   322,   373,   108,   111,   112,     0,
   114,    97,   100,     0,    23,    17,    80,   109,    86,    87,
    90,     0,    92,     0,    69,    71,    72,    73,    74,   394,
     0,    14,   138,   140,   141,   402,    96,   321,    96,   334,
   336,   372,    96,     0,     0,     0,   110,   113,     0,   102,
    29,     0,    81,    83,    84,    96,   362,   118,    89,    91,
     0,    11,   391,    96,   392,    28,   143,   143,   413,   320,
     0,     0,   320,   404,   405,     0,   323,   324,     0,   374,
   375,     0,   115,     0,    24,    37,     0,    21,   361,   367,
     0,    85,     0,     0,     8,    10,    82,   343,    15,     0,
    27,   139,   193,   142,   409,   331,   335,   337,   379,     0,
   407,   343,   326,   343,   377,   431,     0,   104,   105,     0,
     0,   514,   515,   516,     0,     0,   543,   544,    30,    35,
    33,    18,    20,     0,   363,   364,     0,   117,   120,   121,
     0,     0,   127,   128,    93,    28,   395,     0,   340,   347,
    25,   144,     0,     0,   149,   150,   151,   152,   153,   154,
   155,   156,   157,   158,   159,   160,   161,   162,     0,   166,
     0,     0,     0,   176,   177,     0,     0,   300,     0,   239,
   255,   259,   268,   266,   275,   307,     0,    -2,   199,     0,
     0,     0,     0,   208,   209,   210,   211,   212,   213,     0,
     0,   412,   414,   415,   424,   419,   319,     0,   388,   406,
     0,     0,   116,     0,     0,     0,   434,   435,   436,   437,
   438,   439,     0,   441,     0,   451,   452,   453,   454,   470,
   503,   103,     0,     0,     0,     0,     0,     0,     0,     0,
   512,   513,     0,     0,    58,    45,    37,    28,   371,     0,
   366,   119,   122,   123,   124,     0,   137,     0,     9,   388,
   393,   356,   344,   345,     0,   145,   147,   146,   189,   191,
   262,   309,   163,   167,   170,   173,     0,   182,   185,   197,
   305,   243,   537,   193,     0,   193,   537,   313,     0,   537,
   218,   201,     0,   205,     0,     0,   417,   418,    96,     0,
   339,   380,     0,   325,   327,   328,   329,   376,   430,     0,
   450,   447,   433,     0,     0,   443,     0,   457,    -2,   500,
   501,    -2,    -2,   507,   508,   509,   510,   511,     0,   517,
     0,     0,    56,    36,     0,     0,    42,    46,    34,    19,
     0,   370,   365,   431,   126,   129,    -2,    94,   396,     0,
   350,   351,   355,     0,    26,   193,   193,   193,   264,     0,
     0,     0,   537,     0,     0,     0,   537,     0,   251,   537,
     0,   256,   533,   535,     0,   539,   540,   541,     0,     0,
   269,     0,     0,     0,     0,   312,     0,   317,   200,   214,
   215,   216,   230,   303,   537,   203,     0,     0,   301,     0,
   416,   425,   420,   421,     0,     0,   338,     0,   385,   432,
   445,     0,     0,     0,     0,   359,   360,     0,   466,   464,
   467,   468,   469,     0,   471,     0,   479,     0,   484,   489,
   487,     0,   518,    31,    96,    38,    40,    39,    43,    51,
   368,   125,     0,     0,     0,   341,   348,     0,   346,   148,
   190,   192,   263,   537,   164,   168,   171,   174,   178,   183,
   300,   186,   198,   306,   240,   244,   247,     0,   519,   521,
   523,   525,   527,   529,   531,   537,   537,   538,   537,   260,
     0,   267,   276,   308,   310,   298,   217,   219,   222,   224,
   237,     0,     0,     0,     0,   207,     0,   410,     0,   343,
   423,   332,   384,    96,     0,     0,   449,     0,   357,   442,
   444,   455,   462,   465,   458,   472,   477,   473,     0,   481,
   494,   502,   486,     0,     0,    37,   109,     0,     0,    47,
     0,     0,   131,     0,   397,   347,   356,   352,   265,     0,
     0,     0,     0,     0,     0,   196,   254,   249,     0,   193,
   257,   537,   537,   537,   537,   537,   537,   537,   534,   536,
     0,   264,   537,     0,   315,   193,   228,     0,   231,     0,
     0,   236,   537,   304,   202,   537,   206,   302,     0,   429,
     0,     0,     0,   383,   320,   446,   448,   440,     0,   460,
     0,    -2,   474,   475,     0,   490,     0,   493,   488,   106,
    32,    60,    41,    44,    54,    49,   369,     0,   135,   401,
   342,   349,     0,   165,   169,   172,   175,     0,   184,   187,
   194,   241,   252,   243,   245,   248,   193,    -2,    -2,   524,
   526,   528,   530,   532,   542,   261,   270,   277,   281,     0,
   289,   293,   294,   311,   314,   299,   220,   227,   537,   223,
   232,   234,   233,   238,     0,   411,     0,   428,   422,   333,
   381,   386,   358,   456,   459,     0,   463,   478,    -2,   482,
     0,     0,    57,    48,     0,    53,    55,     0,     0,     0,
     0,   400,   353,   179,     0,   537,     0,   193,   250,   193,
   258,   274,   254,   279,   282,   283,   285,   287,     0,     0,
   297,     0,   225,   229,   237,   204,   426,     0,     0,   461,
   476,   487,   491,   107,    59,    61,    62,    63,    64,    67,
    52,    50,   132,   136,   398,     0,   196,   188,   195,   242,
   253,   246,     0,     0,     0,     0,   193,   193,   193,   290,
   292,   295,     0,   221,   228,   235,     0,   382,   390,   483,
     0,    65,     0,     0,   354,   180,   271,   273,   278,   280,
   284,   286,   288,   193,   296,   226,   427,     0,   389,     0,
    66,   133,   399,     0,   193,   291,   387,   496,   498,     0,
   181,   272,     0,     0,    -2,    -2,   492,   497,   495,   499 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"AND",	257,
	"ARRAY",	258,
	"BEG",	259,
	"BY",	260,
	"CASE",	261,
	"CALL",	262,
	"COMMUNICATION",	263,
	"CONST",	264,
	"DISABLE",	265,
	"DO",	266,
	"ELSE",	267,
	"ELSIF",	268,
	"ENABLE",	269,
	"END",	270,
	"ENTRY",	271,
	"EVENT",	272,
	"EXCEPTION",	273,
	"EXCEPTNO",	274,
	"EXIT",	275,
	"EXPORT",	276,
	"EXTERNAL",	277,
	"FOR",	278,
	"FORWARD",	279,
	"HALT",	280,
	"HIGH",	281,
	"IF",	282,
	"IMPLEMENTATION",	283,
	"IMPORT",	284,
	"INITCOM",	285,
	"INTERRUPT",	286,
	"LOOP",	287,
	"LOWLEVEL",	288,
	"MODULE",	289,
	"MONITOR",	290,
	"NOT",	291,
	"OF",	292,
	"OR",	293,
	"PROCEDURE",	294,
	"PROCESS",	295,
	"PROCESSID",	296,
	"PROCESSNO",	297,
	"PROCESSOR",	298,
	"RAISE",	299,
	"RECORD",	300,
	"REPEAT",	301,
	"RESTART",	302,
	"RESUME",	303,
	"RETURN",	304,
	"SIGNAL",	305,
	"START",	306,
	"STATUS",	307,
	"THEN",	308,
	"TO",	309,
	"TYPE",	310,
	"UNTIL",	311,
	"VAL",	312,
	"VAR",	313,
	"WAIT",	314,
	"WHILE",	315,
	"WITH",	316,
	"XOR",	317,
	"BOOLEAN",	318,
	"COMPUTER",	319,
	"CONDITION",	320,
	"POINTER",	321,
	"SEMAPHORE",	322,
	"SET",	323,
	"ASSIGNMENTOP",	324,
	"RELOP",	325,
	"MULOP",	326,
	"PLUSMINUS",	327,
	"TWOSINGLEDOTS",	328,
	"=",	61,
	"INTNUMBER",	329,
	"REALNUMBER",	330,
	"STRING",	331,
	"IDENT",	332,
	"NEWORDISPOSE",	333,
	"PORV",	334,
	"STDFKTN",	335,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
      "module : moduletypes",
      "moduletypes : processormodule",
      "moduletypes : highmodule",
      "moduletypes : lowmodule",
      "moduletypes : error",
      "processormodule : PROCESSOR",
      "processormodule : PROCESSOR moduledecl highdeclaration .commonprocpcss.",
      "processormodule : PROCESSOR moduledecl highdeclaration .commonprocpcss. block processorornot",
      "processormodule : PROCESSOR moduledecl highdeclaration .commonprocpcss. block processorornot modulebody",
      "processorornot : PROCESSOR",
      "processorornot : /* empty */",
      "highmodule : /* empty */",
      "highmodule : moduledecl highdeclaration .monprocpcss.",
      "highmodule : moduledecl highdeclaration .monprocpcss. block",
      "highmodule : moduledecl highdeclaration .monprocpcss. block modulebody",
      "lowmodule : LOWLEVEL",
      "lowmodule : LOWLEVEL moduledecl lowdeclaration .procevent.",
      "lowmodule : LOWLEVEL moduledecl lowdeclaration .procevent. block lowlevelornot",
      "lowmodule : LOWLEVEL moduledecl lowdeclaration .procevent. block lowlevelornot modulebody",
      "lowlevelornot : LOWLEVEL",
      "lowlevelornot : /* empty */",
      "moduledecl : MODULE ident",
      "moduledecl : MODULE ident ';'",
      "moduledecl : MODULE ident ';' ieii",
      "modulebody : moduleornot ident",
      "modulebody : moduleornot ident '.'",
      "moduleornot : MODULE",
      "moduleornot : /* empty */",
      "ieii : /* empty */",
      "ieii : _import_",
      "ieii : _import_ _export_ IMPLEMENTATION",
      "ieii : _import_ _export_ IMPLEMENTATION _import_",
      "ieii : error IMPLEMENTATION",
      "ieii : error IMPLEMENTATION _import_",
      "_import_ : IMPORT",
      "_import_ : IMPORT implist",
      "_import_ : /* empty */",
      "implist : .importlist. ';'",
      "implist : error ';'",
      ".importlist. : .importlist. ','",
      ".importlist. : .importlist. ',' importlistid",
      ".importlist. : importlistid",
      ".importlist. : error ','",
      ".importlist. : error ',' importlistid",
      ".importlist. : /* empty */",
      "importlistid : ident",
      "importlistid : ident _impfilename_",
      "importlistid : ident _impfilename_ importmodule",
      "_impfilename_ : '(' STRING",
      "_impfilename_ : '(' STRING ')'",
      "_impfilename_ : /* empty */",
      "importmodule : impmoduletypes moduledecl",
      "impmoduletypes : PROCESSOR",
      "impmoduletypes : /* empty */",
      "impmoduletypes : LOWLEVEL",
      "_export_ : EXPORT",
      "_export_ : EXPORT _constdecl_ _typedecl_ .heads.",
      "_export_ : /* empty */",
      ".heads. : .heads. heads",
      ".heads. : /* empty */",
      "heads : procedurehead",
      "heads : mheadehead",
      "heads : processhead",
      "heads : commhead",
      "mheadehead : monhead .entryhead.",
      ".entryhead. : .entryhead. entryhead",
      ".entryhead. : /* empty */",
      "highdeclaration : _constdecl_ _typedecl_",
      ".commonprocpcss. : .commonprocpcss. commonprocpcss",
      ".commonprocpcss. : /* empty */",
      "commonprocpcss : commdecl",
      "commonprocpcss : monitordecl",
      "commonprocpcss : proceduredecl",
      "commonprocpcss : processdecl",
      ".monprocpcss. : .monprocpcss. monprocpcss",
      ".monprocpcss. : /* empty */",
      "monprocpcss : monitordecl",
      "monprocpcss : proceduredecl",
      "monprocpcss : processdecl",
      "lowdeclaration : _interruptdecl_ normdecl",
      ".procevent. : .procevent. procevent",
      ".procevent. : /* empty */",
      "procevent : proceduredecl",
      "procevent : eventdecl",
      "normdecl : _constdecl_ _typedecl_ _vardecl_",
      "_interruptdecl_ : INTERRUPT .intdecllist.",
      "_interruptdecl_ : INTERRUPT ';'",
      "_interruptdecl_ : /* empty */",
      ".intdecllist. : .intdecllist. intdecllistid",
      ".intdecllist. : intdecllistid",
      ".intdecllist. : error ';'",
      "intdecllistid : ident",
      "intdecllistid : ident '=' constantexpr",
      "intdecllistid : ident '=' constantexpr ';'",
      "_constdecl_ : CONST .constdecllist.",
      "_constdecl_ : /* empty */",
      ".constdecllist. : .constdecllist. constdecllistid",
      ".constdecllist. : constdecllistid",
      ".constdecllist. : ';'",
      ".constdecllist. : error ';'",
      "constdecllistid : ident",
      "constdecllistid : ident '='",
      "constdecllistid : ident '=' constorcomputer ';'",
      "constorcomputer : constantexpr",
      "constorcomputer : COMPUTER",
      "constorcomputer : COMPUTER '(' constantexpr ',' constantexpr",
      "constorcomputer : COMPUTER '(' constantexpr ',' constantexpr ')'",
      "_typedecl_ : TYPE .typedecllist.",
      "_typedecl_ : /* empty */",
      ".typedecllist. : .typedecllist. typedecllistid",
      ".typedecllist. : typedecllistid",
      ".typedecllist. : ';'",
      ".typedecllist. : error ';'",
      "typedecllistid : ident",
      "typedecllistid : ident '='",
      "typedecllistid : ident '=' alltypes",
      "_vardecl_ : VAR .vardecllist.",
      "_vardecl_ : /* empty */",
      ".vardecllist. : .vardecllist. vardecllist",
      ".vardecllist. : vardecllist",
      ".vardecllist. : ';'",
      ".vardecllist. : error ';'",
      ".vardecllist. : error ','",
      "vardecllist : varidlist ':'",
      "vardecllist : varidlist ':' alltypes",
      "varidlist : varidlist ',' identwithadress",
      "varidlist : identwithadress",
      "identwithadress : ident",
      "identwithadress : ident _address_",
      "_address_ : '['",
      "_address_ : '[' constantexpr",
      "_address_ : '[' constantexpr ':' constantexpr",
      "_address_ : '[' constantexpr ':' constantexpr ']'",
      "_address_ : '['",
      "_address_ : '[' '@' ident",
      "_address_ : '[' '@' ident ']'",
      "_address_ : /* empty */",
      "block : BEG",
      "block : BEG restblock",
      "block : END",
      "block : error",
      "block : error restblock",
      "restblock : /* empty */",
      "restblock : statend",
      "statend : statlist END",
      "statend : error END",
      "statlist : statlist ';'",
      "statlist : statlist ';' statement",
      "statlist : statement",
      "statement : assignment",
      "statement : procedurecall",
      "statement : entrycalloldver",
      "statement : ifstat",
      "statement : whilestat",
      "statement : repeatstat",
      "statement : forstat",
      "statement : loopstat",
      "statement : casestat",
      "statement : disenable",
      "statement : withstat",
      "statement : returnstat",
      "statement : EXIT",
      "statement : WAIT '('",
      "statement : WAIT '(' designator",
      "statement : WAIT '(' designator ')'",
      "statement : HALT",
      "statement : PORV '('",
      "statement : PORV '(' designator",
      "statement : PORV '(' designator ')'",
      "statement : SIGNAL '('",
      "statement : SIGNAL '(' designator",
      "statement : SIGNAL '(' designator ')'",
      "statement : RAISE '('",
      "statement : RAISE '(' expression",
      "statement : RAISE '(' expression ')'",
      "statement : RESUME",
      "statement : INITCOM",
      "statement : INITCOM '(' ident",
      "statement : INITCOM '(' ident ',' ident",
      "statement : INITCOM '(' ident ',' ident countornot",
      "statement : INITCOM '(' ident ',' ident countornot ')'",
      "statement : RESTART '('",
      "statement : RESTART '(' procedurecall",
      "statement : RESTART '(' procedurecall ')'",
      "statement : START '('",
      "statement : START '(' procedurecall",
      "statement : START '(' procedurecall countornot",
      "statement : START '(' procedurecall countornot ')'",
      "statement : error DO",
      "statement : error DO statend",
      "statement : error ';'",
      "statement : error ';' statement",
      "statement : /* empty */",
      "countornot : ','",
      "countornot : ',' expression",
      "countornot : /* empty */",
      "assignment : designator ASSIGNMENTOP",
      "assignment : designator ASSIGNMENTOP expression",
      "designator : ident",
      "designator : ident actparordesexp",
      "designator : stdfktnnewdisp '('",
      "designator : stdfktnnewdisp '(' expression ')'",
      "designator : VAL '(' ident",
      "designator : VAL '(' ident ',' expression ')'",
      "designator : STATUS '('",
      "designator : STATUS '(' designator ')'",
      "designator : HIGH '(' ident ')'",
      "designator : PROCESSID",
      "designator : PROCESSNO",
      "designator : EXCEPTNO",
      "designator : commcall",
      "stdfktnnewdisp : STDFKTN",
      "stdfktnnewdisp : NEWORDISPOSE",
      "actparordesexp : .designatorexpr.",
      "actparordesexp : actualparams",
      "actparordesexp : entrycall",
      ".designatorexpr. : .designatorexpr. designatorexpr",
      ".designatorexpr. : /* empty */",
      "designatorexpr : '['",
      "designatorexpr : '[' desigexprlist",
      "designatorexpr : '[' desigexprlist ']'",
      "designatorexpr : '.'",
      "designatorexpr : '.' ident",
      "designatorexpr : '^'",
      "desigexprlist : desigexprlist ','",
      "desigexprlist : desigexprlist ',' desex",
      "desigexprlist : desex",
      "desex : /* empty */",
      "desex : expression",
      "actualparams : '('",
      "actualparams : '(' apexplstbracket",
      "apexplstbracket : actparexprlist ')'",
      "apexplstbracket : error ')'",
      "actparexprlist : actparexprlist ','",
      "actparexprlist : actparexprlist ',' actexp",
      "actparexprlist : actexp",
      "actexp : /* empty */",
      "actexp : expression",
      "ifstat : IF",
      "ifstat : IF exthenstat _elseiflist_",
      "ifstat : IF exthenstat _elseiflist_ _else_",
      "ifstat : IF exthenstat _elseiflist_ _else_ END",
      "exthenstat : /* empty */",
      "exthenstat : expression",
      "exthenstat : expression THEN",
      "exthenstat : expression THEN statlist",
      "exthenstat : error THEN",
      "exthenstat : error THEN statlist",
      "_elseiflist_ : _elseiflist_ ELSIF",
      "_elseiflist_ : _elseiflist_ ELSIF exthenstat",
      "_elseiflist_ : /* empty */",
      "_else_ : ELSE",
      "_else_ : ELSE statlist",
      "_else_ : /* empty */",
      "whilestat : WHILE",
      "whilestat : WHILE expression",
      "whilestat : WHILE expression DO",
      "whilestat : WHILE expression DO statend",
      "repeatstat : REPEAT",
      "repeatstat : REPEAT statlist UNTIL",
      "repeatstat : REPEAT statlist UNTIL repexpr",
      "repeatstat : error UNTIL",
      "repeatstat : error UNTIL repexpr",
      "repexpr : /* empty */",
      "repexpr : expression",
      "loopstat : LOOP",
      "loopstat : LOOP statlist END",
      "forstat : FOR",
      "forstat : FOR assignment",
      "forstat : FOR assignment TO expression",
      "forstat : FOR assignment TO expression _byexpr_ DO",
      "forstat : FOR assignment TO expression _byexpr_ DO statend",
      "_byexpr_ : BY constantexpr",
      "_byexpr_ : /* empty */",
      "casestat : CASE",
      "casestat : CASE expression OF",
      "casestat : CASE expression OF caselist",
      "casestat : CASE expression OF caselist _else_ END",
      "caselist : caselist '|'",
      "caselist : caselist '|' case",
      "caselist : case",
      "caselist : error '|'",
      "caselist : error ';'",
      "caselist : error ';' statlist",
      "caselist : error ':'",
      "caselist : error ':' statlist",
      "caselist : error ELSE",
      "caselist : error ELSE statlist",
      "case : caselabellist",
      "case : caselabellist ':'",
      "case : caselabellist ':' statlist",
      "caselabellist : caselabellist ',' caselabel",
      "caselabellist : caselabel",
      "caselabel : constantexpr",
      "caselabel : constantexpr _toconstantexpr_",
      "_toconstantexpr_ : TWOSINGLEDOTS constantexpr",
      "_toconstantexpr_ : /* empty */",
      "withstat : WITH WITH ident DO",
      "withstat : WITH WITH ident DO statend",
      "procedurecall : designator",
      "commcall : CALL ident ':'",
      "commcall : CALL ident ':' procedurecall",
      "entrycall : ':'",
      "entrycall : ':' procedurecall",
      "entrycalloldver : MONITOR '.'",
      "entrycalloldver : MONITOR '.' procedurecall",
      "disenable : DISABLE",
      "disenable : DISABLE assignmentlist ENABLE",
      "disenable : error ENABLE",
      "assignmentlist : assignmentlist ';'",
      "assignmentlist : assignmentlist ';' _assignornot_",
      "assignmentlist : assignment",
      "assignmentlist : /* empty */",
      "_assignornot_ : assignment",
      "_assignornot_ : /* empty */",
      "returnstat : RETURN",
      "returnstat : RETURN expression",
      "returnstat : RETURN",
      ".proceduredecl. : .proceduredecl. proceduredecl",
      ".proceduredecl. : /* empty */",
      "proceduredecl : procedurehead procedurebody",
      "procedurehead : PROCEDURE",
      "procedurehead : PROCEDURE restofprocedhd",
      "restofprocedhd : ident",
      "restofprocedhd : ident _formalparams_ semicolextforw",
      "restofprocedhd : error ';'",
      "semicolextforw : ';'",
      "semicolextforw : EXTERNAL",
      "semicolextforw : FORWARD",
      "procedurebody : /* empty */",
      "procedurebody : normdecl .proceduredecl.",
      "procedurebody : normdecl .proceduredecl. block noprocedure ident",
      "procedurebody : normdecl .proceduredecl. block noprocedure ident ';'",
      "procedurebody : EXTERNAL",
      "procedurebody : EXTERNAL ';'",
      "procedurebody : FORWARD",
      "procedurebody : FORWARD ';'",
      "noprocedure : PROCEDURE",
      "noprocedure : /* empty */",
      "_formalparams_ : '('",
      "_formalparams_ : '(' paramsectlist ')'",
      "_formalparams_ : '(' paramsectlist ')' _oftypeident_",
      "_formalparams_ : /* empty */",
      "_formalparams_ : _oftypeident_",
      "_oftypeident_ : ':'",
      "_oftypeident_ : ':' type",
      "_oftypeident_ : /* empty */",
      "paramsectlist : paramsectlist ';'",
      "paramsectlist : paramsectlist ';' paramsect",
      "paramsectlist : paramsect",
      "paramsect : _var_",
      "paramsect : _var_ idlist",
      "paramsect : _var_ idlist ':'",
      "paramsect : _var_ idlist ':' type",
      "_var_ : VAR",
      "_var_ : /* empty */",
      "idlist : idlist ','",
      "idlist : idlist ',' idlistident",
      "idlist : idlistident",
      "idlistident : ident",
      "eventdecl : eventhead eventbody",
      "eventhead : EVENT",
      "eventhead : EVENT restofeventhead",
      "restofeventhead : ident",
      "restofeventhead : ident ';'",
      "restofeventhead : error ';'",
      "eventbody : normdecl",
      "eventbody : normdecl block noevent ident",
      "eventbody : normdecl block noevent ident ';'",
      "noevent : EVENT",
      "noevent : /* empty */",
      "processdecl : processhead processbody",
      "processhead : PROCESS",
      "processhead : PROCESS restofprocesshd",
      "restofprocesshd : ident",
      "restofprocesshd : ident _formalparams_ ';'",
      "restofprocesshd : error ';'",
      "processbody : /* empty */",
      "processbody : normdecl .proceduredecl.",
      "processbody : normdecl .proceduredecl. _exception_",
      "processbody : normdecl .proceduredecl. _exception_ block processornot ident",
      "processbody : normdecl .proceduredecl. _exception_ block processornot ident ';'",
      "processornot : PROCESS",
      "processornot : /* empty */",
      "_exception_ : EXCEPTION ';'",
      "_exception_ : EXCEPTION ';' normdecl .proceduredecl.",
      "_exception_ : EXCEPTION ';' normdecl .proceduredecl. block exceptionornot ';'",
      "_exception_ : /* empty */",
      "exceptionornot : EXCEPTION",
      "exceptionornot : /* empty */",
      "commdecl : commhead commbody",
      "commhead : COMMUNICATION ident",
      "commhead : COMMUNICATION ident _formalparams_ ';'",
      "commbody : /* empty */",
      "commbody : normdecl .procevent.",
      "commbody : normdecl .procevent. _exception_",
      "commbody : normdecl .procevent. _exception_ block",
      "commbody : normdecl .procevent. _exception_ block commornot ident",
      "commbody : normdecl .procevent. _exception_ block commornot ident ';'",
      "commornot : COMMUNICATION",
      "commornot : /* empty */",
      "monitordecl : monhead monbody",
      "monhead : MONITOR",
      "monhead : MONITOR restofmonhead",
      "restofmonhead : ident",
      "restofmonhead : ident ';'",
      "restofmonhead : error ';'",
      "monbody : /* empty */",
      "monbody : normdecl .procentry.",
      "monbody : normdecl .procentry. block monitorornot ident",
      "monbody : normdecl .procentry. block monitorornot ident ';'",
      ".procentry. : .procentry. procentry",
      ".procentry. : /* empty */",
      "procentry : proceduredecl",
      "procentry : entrydecl",
      "monitorornot : MONITOR",
      "monitorornot : /* empty */",
      "entrydecl : entryhead entrybody",
      "entryhead : ENTRY",
      "entryhead : ENTRY restofentryhead",
      "restofentryhead : ident",
      "restofentryhead : ident _formalparams_ ';'",
      "restofentryhead : error ';'",
      "entrybody : /* empty */",
      "entrybody : normdecl",
      "entrybody : normdecl block noentry ident",
      "entrybody : normdecl block noentry ident ';'",
      "noentry : ENTRY",
      "noentry : /* empty */",
      "alltypes : type ';'",
      "alltypes : /* empty */",
      "alltypes : specialtype ';'",
      "alltypes : error ';'",
      "type : ident",
      "type : subrange",
      "type : enumeration",
      "type : settype",
      "type : structype",
      "type : BOOLEAN",
      "subrange : '[' constantexpr TWOSINGLEDOTS constantexpr ']'",
      "enumeration : '('",
      "enumeration : '(' idlist ')'",
      "settype : SET OF",
      "settype : SET OF type",
      "specialtype : SEMAPHORE _seminit_",
      "specialtype : SEMAPHORE _seminit_ ';'",
      "specialtype : CONDITION",
      "_seminit_ : '[' constantexpr ']'",
      "_seminit_ : error ']'",
      "_seminit_ : /* empty */",
      "structype : arraytype",
      "structype : recordtype",
      "structype : pointertype",
      "arraytype : ARRAY",
      "arraytype : ARRAY subrangelist OF",
      "arraytype : ARRAY subrangelist OF arroftypeorspec",
      "arraytype : ARRAY OF",
      "arraytype : ARRAY OF type",
      "arroftypeorspec : type",
      "arroftypeorspec : /* empty */",
      "arroftypeorspec : specialtype",
      "subrangelist : subrangelist commaornot",
      "subrangelist : subrangelist commaornot subr",
      "subrangelist : subr",
      "commaornot : ','",
      "commaornot : /* empty */",
      "subr : suborid",
      "suborid : subrange",
      "suborid : ident",
      "recordtype : RECORD",
      "recordtype : RECORD fend",
      "fend : fieldlist endorerror",
      "endorerror : END",
      "endorerror : error END",
      "endorerror : error ';'",
      "endorerror : error ';' fend",
      "fieldlist : fieldlist ';'",
      "fieldlist : fieldlist ';' recordfield",
      "fieldlist : recordfield",
      "recordfield : /* empty */",
      "recordfield : idlist",
      "recordfield : idlist ':'",
      "recordfield : idlist ':' typeandnospec",
      "recordfield : reccase",
      "recordfield : /* empty */",
      "typeandnospec : type",
      "typeandnospec : /* empty */",
      "typeandnospec : specialtype",
      "reccase : CASE",
      "reccase : CASE restofreccase",
      "restofreccase : _reccase_ident_ ':' ident",
      "restofreccase : _reccase_ident_ ':' ident OF variantlist _elsefieldlist_ END",
      "_reccase_ident_ : ident",
      "_reccase_ident_ : /* empty */",
      "_elsefieldlist_ : ELSE fieldlist",
      "_elsefieldlist_ : /* empty */",
      "variantlist : variantlist '|' variant",
      "variantlist : variant",
      "variant : caselabellist ':' fieldlist",
      "pointertype : POINTER _totypeornot_",
      "_totypeornot_ : TO",
      "_totypeornot_ : TO typeandnospec",
      "_totypeornot_ : /* empty */",
      "ident : IDENT",
      "constantexpr : constantexpr RELOP constantexpr",
      "constantexpr : constantexpr '=' constantexpr",
      "constantexpr : constantexpr AND constantexpr",
      "constantexpr : constantexpr XOR constantexpr",
      "constantexpr : constantexpr OR constantexpr",
      "constantexpr : constantexpr PLUSMINUS constantexpr",
      "constantexpr : constantexpr MULOP constantexpr",
      "constantexpr : NOT constantexpr",
      "constantexpr : PLUSMINUS constantexpr",
      "constantexpr : ident",
      "constantexpr : number",
      "constantexpr : STRING",
      "constantexpr : '(' constantexpr ')'",
      "constantexpr : STDFKTN '(' constantexpr ')'",
      "expression : expression RELOP",
      "expression : expression RELOP expression",
      "expression : expression '='",
      "expression : expression '=' expression",
      "expression : expression AND",
      "expression : expression AND expression",
      "expression : expression XOR",
      "expression : expression XOR expression",
      "expression : expression OR",
      "expression : expression OR expression",
      "expression : expression PLUSMINUS",
      "expression : expression PLUSMINUS expression",
      "expression : expression MULOP",
      "expression : expression MULOP expression",
      "expression : NOT",
      "expression : NOT expression",
      "expression : PLUSMINUS",
      "expression : PLUSMINUS expression",
      "expression : /* empty */",
      "expression : designator",
      "expression : number",
      "expression : STRING",
      "expression : '('",
      "expression : '(' expression ')'",
      "number : INTNUMBER",
      "number : REALNUMBER",
};
#endif /* YYDEBUG */
/* @(#)27       1.7.1.1  com/cmd/lang/yacc/yaccpar, cmdlang, bos320, 9209320f 2/19/92 16:36:02 */
/*
 * COMPONENT_NAME: (CMDLANG) Language Utilities
 *
 * FUNCTIONS: yyparse
 * ORIGINS: 03
 */
/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#ifdef YYSPLIT
#   define YYERROR      return(-2)
#else
#   define YYERROR      goto yyerrlab
#endif
#ifdef YACC_MSG
#ifndef _XOPEN_SOURCE
#define _XOPEN_SOURCE
#endif
#include <nl_types.h>
nl_catd catd;
#endif
#define YYACCEPT        return(0)
#define YYABORT         return(1)
#ifndef YACC_MSG
#define YYBACKUP( newtoken, newvalue )\
{\
        if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
        {\
                yyerror( "syntax error - cannot backup" );\
                YYERROR;\
        }\
        yychar = newtoken;\
        yystate = *yyps;\
        yylval = newvalue;\
        goto yynewstate;\
}
#else
#define YYBACKUP( newtoken, newvalue )\
{\
        if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
        {\
                catd=catopen("yacc_user.cat",0);\
                yyerror(catgets(catd,1,1,"syntax error - cannot backup" ));\
                YYERROR;\
        }\
        yychar = newtoken;\
        yystate = *yyps;\
        yylval = newvalue;\
        goto yynewstate;\
}
#endif
#define YYRECOVERING()  (!!yyerrflag)
#ifndef YYDEBUG
#       define YYDEBUG  1       /* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;                    /* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG          (-1000)

#ifdef YYSPLIT
#   define YYSCODE { \
                        extern int (*_yyf[])(); \
                        register int yyret; \
                        if (_yyf[yytmp]) \
                            if ((yyret=(*_yyf[yytmp])()) == -2) \
                                    goto yyerrlab; \
                                else if (yyret>=0) return(yyret); \
                   }
#endif

/*
** global variables used by the parser
*/
YYSTYPE yyv[ YYMAXDEPTH ];      /* value stack */
int yys[ YYMAXDEPTH ];          /* state stack */

YYSTYPE *yypv;                  /* top of value stack */
YYSTYPE *yypvt;                 /* top of value stack for $vars */
int *yyps;                      /* top of state stack */

int yystate;                    /* current state */
int yytmp;                      /* extra var (lasts between blocks) */

int yynerrs;                    /* number of errors */
int yyerrflag;                  /* error recovery flag */
int yychar;                     /* current input token number */

#ifdef __cplusplus
 #ifdef _CPP_IOSTREAMS
  #include <iostream.h>
  extern void yyerror (char *); /* error message routine -- iostream version */
 #else
  #include <stdio.h>
  extern "C" void yyerror (char *); /* error message routine -- stdio version */
 #endif /* _CPP_IOSTREAMS */
 extern "C" int yylex(void);        /* return the next token */
#endif /* __cplusplus */


/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
#ifdef __cplusplus
extern "C"
#endif /* __cplusplus */
int
yyparse()
{
        /*
        ** Initialize externals - yyparse may be called more than once
        */
        yypv = &yyv[-1];
        yyps = &yys[-1];
        yystate = 0;
        yytmp = 0;
        yynerrs = 0;
        yyerrflag = 0;
        yychar = -1;
#ifdef YACC_MSG
        catd=catopen("yacc_user.cat",0);
#endif
        goto yystack;
        {
                register YYSTYPE *yy_pv;        /* top of value stack */
                register int *yy_ps;            /* top of state stack */
                register int yy_state;          /* current state */
                register int  yy_n;             /* internal state number info */

                /*
                ** get globals into registers.
                ** branch to here only if YYBACKUP was called.
                */
        yynewstate:
                yy_pv = yypv;
                yy_ps = yyps;
                yy_state = yystate;
                goto yy_newstate;

                /*
                ** get globals into registers.
                ** either we just started, or we just finished a reduction
                */
        yystack:
                yy_pv = yypv;
                yy_ps = yyps;
                yy_state = yystate;

                /*
                ** top of for (;;) loop while no reductions done
                */
        yy_stack:
                /*
                ** put a state and value onto the stacks
                */
#if YYDEBUG
                /*
                ** if debugging, look up token value in list of value vs.
                ** name pairs.  0 and negative (-1) are special values.
                ** Note: linear search is used since time is not a real
                ** consideration while debugging.
                */
                if ( yydebug )
                {
                        register int yy_i;

#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                        cout << "State " << yy_state << " token ";
                        if ( yychar == 0 )
                                cout << "end-of-file" << endl;
                        else if ( yychar < 0 )
                                cout << "-none-" << endl;
#else
                        printf( "State %d, token ", yy_state );
                        if ( yychar == 0 )
                                printf( "end-of-file\n" );
                        else if ( yychar < 0 )
                                printf( "-none-\n" );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
                        else
                        {
                                for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
                                        yy_i++ )
                                {
                                        if ( yytoks[yy_i].t_val == yychar )
                                                break;
                                }
#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                                cout << yytoks[yy_i].t_name << endl;
#else
                                printf( "%s\n", yytoks[yy_i].t_name );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
                        }
                }
#endif /* YYDEBUG */
                if ( ++yy_ps >= &yys[ YYMAXDEPTH ] )    /* room on stack? */
                {
#ifndef YACC_MSG
                        yyerror( "yacc stack overflow" );
#else
                        yyerror(catgets(catd,1,2,"yacc stack overflow" ));
#endif
                        YYABORT;
                }
                *yy_ps = yy_state;
                *++yy_pv = yyval;

                /*
                ** we have a new state - find out what to do
                */
        yy_newstate:
                if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
                        goto yydefault;         /* simple state */
#if YYDEBUG
                /*
                ** if debugging, need to mark whether new token grabbed
                */
                yytmp = yychar < 0;
#endif
                if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
                        yychar = 0;             /* reached EOF */
#if YYDEBUG
                if ( yydebug && yytmp )
                {
                        register int yy_i;

#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                        cout << "Received token " << endl;
                        if ( yychar == 0 )
                                cout << "end-of-file" << endl;
                        else if ( yychar < 0 )
                                cout << "-none-" << endl;
#else
                        printf( "Received token " );
                        if ( yychar == 0 )
                                printf( "end-of-file\n" );
                        else if ( yychar < 0 )
                                printf( "-none-\n" );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
                        else
                        {
                                for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
                                        yy_i++ )
                                {
                                        if ( yytoks[yy_i].t_val == yychar )
                                                break;
                                }
#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                                cout << yytoks[yy_i].t_name << endl;
#else
                                printf( "%s\n", yytoks[yy_i].t_name );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
                        }
                }
#endif /* YYDEBUG */
                if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
                        goto yydefault;
                if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )  /*valid shift*/
                {
                        yychar = -1;
                        yyval = yylval;
                        yy_state = yy_n;
                        if ( yyerrflag > 0 )
                                yyerrflag--;
                        goto yy_stack;
                }

        yydefault:
                if ( ( yy_n = yydef[ yy_state ] ) == -2 )
                {
#if YYDEBUG
                        yytmp = yychar < 0;
#endif
                        if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
                                yychar = 0;             /* reached EOF */
#if YYDEBUG
                        if ( yydebug && yytmp )
                        {
                                register int yy_i;

#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                                cout << "Received token " << endl;
                                if ( yychar == 0 )
                                        cout << "end-of-file" << endl;
                                else if ( yychar < 0 )
                                        cout << "-none-" << endl;
#else
                                printf( "Received token " );
                                if ( yychar == 0 )
                                        printf( "end-of-file\n" );
                                else if ( yychar < 0 )
                                        printf( "-none-\n" );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
                                else
                                {
                                        for ( yy_i = 0;
                                                yytoks[yy_i].t_val >= 0;
                                                yy_i++ )
                                        {
                                                if ( yytoks[yy_i].t_val
                                                        == yychar )
                                                {
                                                        break;
                                                }
                                        }
#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                                        cout << yytoks[yy_i].t_name << endl;
#else
                                        printf( "%s\n", yytoks[yy_i].t_name );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
                                }
                        }
#endif /* YYDEBUG */
                        /*
                        ** look through exception table
                        */
                        {
                                register int *yyxi = yyexca;

                                while ( ( *yyxi != -1 ) ||
                                        ( yyxi[1] != yy_state ) )
                                {
                                        yyxi += 2;
                                }
                                while ( ( *(yyxi += 2) >= 0 ) &&
                                        ( *yyxi != yychar ) )
                                        ;
                                if ( ( yy_n = yyxi[1] ) < 0 )
                                        YYACCEPT;
                        }
                }

                /*
                ** check for syntax error
                */
                if ( yy_n == 0 )        /* have an error */
                {
                        /* no worry about speed here! */
                        switch ( yyerrflag )
                        {
                        case 0:         /* new error */
#ifndef YACC_MSG
                                yyerror( "syntax error" );
#else
                                yyerror(catgets(catd,1,3,"syntax error" ));
#endif
                                goto skip_init;
                        yyerrlab:
                                /*
                                ** get globals into registers.
                                ** we have a user generated syntax type error
                                */
                                yy_pv = yypv;
                                yy_ps = yyps;
                                yy_state = yystate;
                                yynerrs++;
                        skip_init:
                        case 1:
                        case 2:         /* incompletely recovered error */
                                        /* try again... */
                                yyerrflag = 3;
                                /*
                                ** find state where "error" is a legal
                                ** shift action
                                */
                                while ( yy_ps >= yys )
                                {
                                        yy_n = yypact[ *yy_ps ] + YYERRCODE;
                                        if ( yy_n >= 0 && yy_n < YYLAST &&
                                                yychk[yyact[yy_n]] == YYERRCODE)                                        {
                                                /*
                                                ** simulate shift of "error"
                                                */
                                                yy_state = yyact[ yy_n ];
                                                goto yy_stack;
                                        }
                                        /*
                                        ** current state has no shift on
                                        ** "error", pop stack
                                        */
#if YYDEBUG
                                        if ( yydebug )
#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                                            cout << "Error recovery pops state "
                                                 << (*yy_ps)
                                                 << ", uncovers state "
                                                 << yy_ps[-1] << endl;
#else
#       define _POP_ "Error recovery pops state %d, uncovers state %d\n"
                                                printf( _POP_, *yy_ps,
                                                        yy_ps[-1] );
#       undef _POP_
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
#endif
                                        yy_ps--;
                                        yy_pv--;
                                }
                                /*
                                ** there is no state on stack with "error" as
                                ** a valid shift.  give up.
                                */
                                YYABORT;
                        case 3:         /* no shift yet; eat a token */
#if YYDEBUG
                                /*
                                ** if debugging, look up token in list of
                                ** pairs.  0 and negative shouldn't occur,
                                ** but since timing doesn't matter when
                                ** debugging, it doesn't hurt to leave the
                                ** tests here.
                                */
                                if ( yydebug )
                                {
                                        register int yy_i;

#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                                        cout << "Error recovery discards ";
                                        if ( yychar == 0 )
                                            cout << "token end-of-file" << endl;
                                        else if ( yychar < 0 )
                                            cout << "token -none-" << endl;
#else
                                        printf( "Error recovery discards " );
                                        if ( yychar == 0 )
                                                printf( "token end-of-file\n" );
                                        else if ( yychar < 0 )
                                                printf( "token -none-\n" );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
                                        else
                                        {
                                                for ( yy_i = 0;
                                                        yytoks[yy_i].t_val >= 0;
                                                        yy_i++ )
                                                {
                                                        if ( yytoks[yy_i].t_val
                                                                == yychar )
                                                        {
                                                                break;
                                                        }
                                                }
#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                                                cout << "token " <<
                                                    yytoks[yy_i].t_name <<
                                                    endl;
#else
                                                printf( "token %s\n",
                                                        yytoks[yy_i].t_name );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
                                        }
                                }
#endif /* YYDEBUG */
                                if ( yychar == 0 )      /* reached EOF. quit */
                                        YYABORT;
                                yychar = -1;
                                goto yy_newstate;
                        }
                }/* end if ( yy_n == 0 ) */
                /*
                ** reduction by production yy_n
                ** put stack tops, etc. so things right after switch
                */
#if YYDEBUG
                /*
                ** if debugging, print the string that is the user's
                ** specification of the reduction which is just about
                ** to be done.
                */
                if ( yydebug )
#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                        cout << "Reduce by (" << yy_n << ") \"" <<
                            yyreds[ yy_n ] << "\"\n";
#else
                        printf( "Reduce by (%d) \"%s\"\n",
                                yy_n, yyreds[ yy_n ] );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
#endif
                yytmp = yy_n;                   /* value to switch over */
                yypvt = yy_pv;                  /* $vars top of value stack */
                /*
                ** Look in goto table for next state
                ** Sorry about using yy_state here as temporary
                ** register variable, but why not, if it works...
                ** If yyr2[ yy_n ] doesn't have the low order bit
                ** set, then there is no action to be done for
                ** this reduction.  So, no saving & unsaving of
                ** registers done.  The only difference between the
                ** code just after the if and the body of the if is
                ** the goto yy_stack in the body.  This way the test
                ** can be made before the choice of what to do is needed.
                */
                {
                        /* length of production doubled with extra bit */
                        register int yy_len = yyr2[ yy_n ];

                        if ( !( yy_len & 01 ) )
                        {
                                yy_len >>= 1;
                                yyval = ( yy_pv -= yy_len )[1]; /* $$ = $1 */
                                yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
                                        *( yy_ps -= yy_len ) + 1;
                                if ( yy_state >= YYLAST ||
                                        yychk[ yy_state =
                                        yyact[ yy_state ] ] != -yy_n )
                                {
                                        yy_state = yyact[ yypgo[ yy_n ] ];
                                }
                                goto yy_stack;
                        }
                        yy_len >>= 1;
                        yyval = ( yy_pv -= yy_len )[1]; /* $$ = $1 */
                        yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
                                *( yy_ps -= yy_len ) + 1;
                        if ( yy_state >= YYLAST ||
                                yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
                        {
                                yy_state = yyact[ yypgo[ yy_n ] ];
                        }
                }
                                        /* save until reenter driver code */
                yystate = yy_state;
                yyps = yy_ps;
                yypv = yy_pv;
        }
        /*
        ** code supplied by user is placed in this switch
        */

                switch(yytmp){

case 1:
# line 258 "../source/modula.yac"
{
					c_init_out ();
					parser_errno = 1;
				} /*NOTREACHED*/ break;
case 5:
# line 267 "../source/modula.yac"
{
					message (D_FATAL, "yyparse (moduletypes): No Error-Recovery possible");
				} /*NOTREACHED*/ break;
case 6:
# line 272 "../source/modula.yac"
{
					static	int	proc_mod_count = 0;

					if (proc_mod_count++) {
						message (D_ERROR, "yyparse (processormodule): Only one PROCESSOR MODULE allowed");
							/*
							 * Ruecksprung aus yyparse
							 */
						YYABORT;
					}
					
					moduletype = e_PROCMOD;
				} /*NOTREACHED*/ break;
case 7:
# line 287 "../source/modula.yac"
{
					blocktype = e_MODULE;
					setactualblock (e_MODULE, yypvt[-2].s.val.pstbl->id);
					yyval = yypvt[-2];
				} /*NOTREACHED*/ break;
case 8:
# line 293 "../source/modula.yac"
{
					yyval = yypvt[-5];
				} /*NOTREACHED*/ break;
case 11:
# line 300 "../source/modula.yac"
{
					message (D_WARN, "yyparse (processorornot): Token PROCESSOR is missing");
				} /*NOTREACHED*/ break;
case 12:
# line 305 "../source/modula.yac"
{
					moduletype = e_HIGHMOD;
				} /*NOTREACHED*/ break;
case 13:
# line 310 "../source/modula.yac"
{
					blocktype = e_MODULE;
					setactualblock (e_MODULE, yypvt[-2].s.val.pstbl->id);
					yyval = yypvt[-2];
				} /*NOTREACHED*/ break;
case 14:
# line 315 "../source/modula.yac"
{
					yyval = yypvt[-4];
				} /*NOTREACHED*/ break;
case 16:
# line 321 "../source/modula.yac"
{
					moduletype = e_LOWMOD;
				} /*NOTREACHED*/ break;
case 17:
# line 326 "../source/modula.yac"
{
					search_for_undeclared_events ();

					blocktype = e_MODULE;
					setactualblock (e_MODULE, yypvt[-2].s.val.pstbl->id);
					yyval = yypvt[-2];
				} /*NOTREACHED*/ break;
case 18:
# line 334 "../source/modula.yac"
{
					yyval = yypvt[-5];
				} /*NOTREACHED*/ break;
case 21:
# line 341 "../source/modula.yac"
{
					message (D_WARN, "yyparse (lowlevelornot): Token LOWLEVEL is missing");
				} /*NOTREACHED*/ break;
case 22:
# line 347 "../source/modula.yac"
{
					setidart (is_moduleid);
					if (symbtbllookupwithinidart (id_name, idart) != NULL) {
						message (D_ERROR, "yyparse (moduledecl): Module-Identifier '%s' already declared", id_name_fuer_fehlertext);
					}
					pstblentry = symbtbladd (id_name);
					pstblentry->iart.is_moduleid = 1;
					pstblentry->status.is_defined = 1;
					pstblentry->ofstblentry = voidstblentry;
					if (import_filename == NULL) {
							/* kein Import-Modul */
						c_init ("extern\tint\tc_init;\n\n");
						c_init ("void\ti0_%s ()\n{\n", pstblentry->id);
						c_init ("\tstatic int\tinit = 0;\n");
						c_init ("\tif (c_init) {\n");
						c_init ("\t\tprintf (\"Init-Begin Modul: %s\\n\");\n\t}\n", pstblentry->id);
						c_init ("\tif (init) {\n");
						c_init ("\t\tif (c_init) {\n");
						c_init ("\t\t\tprintf (\"Init-Abort Modul: %s (already initialized)\\n\");\n\t\t}\n", pstblentry->id);
						c_init ("\t\treturn;\n\t}\n\tinit = 1;\n\n");

						if (moduletype == e_PROCMOD) {
							c_out_lf ();
							c_out_linebegin ("char	*module_name = \"%s\";", pstblentry->id);
							module_name = pstblentry->id;
						}
						c_out_lf ();
						c_out_linebegin ("extern char	*processtype; /* defined in library libmc... */");
					} else {
							/* Import-Modul */
							
						c_out_linebegin ("extern void i0_%s ();\n", pstblentry->id);
						c_init ("\ti0_%s ();\n", pstblentry->id);
					}

					blocktype = e_MODULE;
					newblocklist (pstblentry->id);

					yyval.s.art.blcktyp = e_MODULE;
					yyval.s.val.pstbl = pstblentry;
				} /*NOTREACHED*/ break;
case 23:
# line 388 "../source/modula.yac"
{
					yyval = yypvt[-1];
				} /*NOTREACHED*/ break;
case 24:
# line 391 "../source/modula.yac"
{
					setactualblock (e_MODULE, yypvt[-3].s.val.pstbl->id);
					yyval = yypvt[-3];
				} /*NOTREACHED*/ break;
case 25:
# line 398 "../source/modula.yac"
{
					setidart (is_moduleid);
					if ((pstblentry = symbtbllookupwithinidart (id_name, idart)) == NULL) {
						message (D_ERROR, "yyparse (modulebody): Module-Identifier '%s' not declared", id_name_fuer_fehlertext);
					}
					if (pstblentry->ofblock->nr != 0) {
						message (D_ERROR, "yyparse (modulebody): Module-Identifier '%s' not declared", id_name_fuer_fehlertext);
					}
					if (pstblentry != yypvt[-2].s.val.pstbl) {
						message (D_ERROR, "yyparse (modulebody): Module-Identifier '%s' not the same as in declaration part", id_name_fuer_fehlertext);
					}
					c_init ("\tadd_fktn (m0_%s);\n", pstblentry->id);
					c_init ("\tif (c_init) {\n");
					c_init ("\t\tprintf (\"Init-End Modul: %s\\n\");\n\t}\n", pstblentry->id);
					c_init ("\treturn;\n}\n");
					if (moduletype == e_PROCMOD) {
						c_init ("\nint c_init = %d;\n", mc_init);
						c_init ("\nunsigned long mc_shmsize = %lu;\n", mc_shmsize);
						c_init ("\nmain ()\n{\n\tfirst_init ();\n\ti0_%s ();\n\tsecond_init ();\n\texecute_fktn ();\n}", pstblentry->id);
					}
				} /*NOTREACHED*/ break;
case 28:
# line 423 "../source/modula.yac"
{
					message (D_WARN, "yyparse (moduleornot): Token MODULE is missing");
				} /*NOTREACHED*/ break;
case 29:
# line 428 "../source/modula.yac"
{
					yyval.s.flag.is_2nd_importstat = 0;
				} /*NOTREACHED*/ break;
case 30:
# line 431 "../source/modula.yac"
{
					setactualblock (e_MODULE, yypvt[-2].s.val.pstbl->id);
				} /*NOTREACHED*/ break;
case 31:
# line 435 "../source/modula.yac"
{
					yyval.s.flag.is_2nd_importstat = 1;
				} /*NOTREACHED*/ break;
case 33:
# line 440 "../source/modula.yac"
{
					yyerrok;
					yyval.s.flag.is_2nd_importstat = 1;
				} /*NOTREACHED*/ break;
case 35:
# line 448 "../source/modula.yac"
{
					yyval.s.flag = yypvt[-1].s.flag;
				} /*NOTREACHED*/ break;
case 40:
# line 461 "../source/modula.yac"
{
					yyval.s.flag = yypvt[-2].s.flag;
				} /*NOTREACHED*/ break;
case 43:
# line 467 "../source/modula.yac"
{
					yyerrok;
					yyval.s.flag = yypvt[-2].s.flag;
				} /*NOTREACHED*/ break;
case 46:
# line 475 "../source/modula.yac"
{
						/* id_name ist 5 Zeichen laenger als
						 * das laengste erlaubte Token (s. Lex)
						 */
					strcat (id_name, ".mod");
					import_filename = id_name;
					import_filename_without_path = id_name;
				} /*NOTREACHED*/ break;
case 47:
# line 483 "../source/modula.yac"
{
					ImportSave	*pisave;
					ModuleType	mtyp;

						/* mtyp erhaelt den modultyp des
						 * zum Compilieren aufgerufenen
						 * Moduls
						 */
					mtyp = moduletype;
					if (pisave = pimportsave) {
						while (pisave->previous) {
							pisave = pisave->previous;
						}
						mtyp = pisave->moduletype;
					}
					
						/* Der Import wird pro FILE nur einmal durchgefuerht;
						 * der Import nach dem Schlusselwort IMPLEMENTATION
						 * wird beim zu compilierenden Modul durchgefuehrt
						 * und rekursiv beim zu compilierenden PROCESSOR-MODULE
						 * (sonst nicht!)
						 */
					if (   look_for_filename (import_filename) == NULL
					    && (pimportsave == NULL || mtyp == e_PROCMOD || yypvt[-3].s.flag.is_2nd_importstat == 0)) {
							/* Import noch nicht durchgefuehrt, Filename speichern */

							/*
							 * Variablen des
							 * aufrufendes Moduls
							 * sichern
							 */
						if ((pisave = (ImportSave *) malloc (sizeof (ImportSave))) == NULL) {
							message (D_INTERNAL, "yyparse (importlistid): No more memory for ImportSave");
						}
						pisave->yyin = yyin;
						pisave->yylineno = yylineno;
						pisave->mc_list_lineno = mc_list_lineno;
						pisave->yychar = yychar;
						if ((pisave->yysbuf = (char *) malloc (max_token_length)) == NULL) {
							message (D_INTERNAL, "yyparse (importlistid): No more memory for yysbuf to save");
						}
						memcpy (pisave->yysbuf, yysbuf, max_token_length);
						pisave->yysptr = yysptr;
						pisave->actual_filename = actual_filename; /* Pointer genuegt */
						pisave->moduletype = moduletype;
						pisave->previous = pimportsave;
						pimportsave = pisave;

						blocktype = e_FILE;
						newblocklist (import_filename = add_filename (import_filename));
						mkimpfnwithoutpath;	/* Pointer auf die neue position setzen */

							/* open IMPORT-File */
						if ((yyin = fopen (import_filename, "r")) == NULL) {
								/*
								 * open failed
								 */
									/* Zurueckspeichern
									 * der bereits ver-
									 * aenderten Variablen
									 * des aufrufendes Moduls
									 */
							yyin = pimportsave->yyin;
							pisave = pimportsave;
							pimportsave = pimportsave->previous;
							free (pisave->yysbuf);
							free (pisave);
							
							message (D_ERROR, "yyparse (importlistid): IMPORT-File '%s' not found", import_filename);

							if (pimportsave) {
								import_filename = actual_filename;
								mkimpfnwithoutpath;
							} else {
								import_filename = NULL;
								import_filename_without_path = NULL;
							}
							
							YYERROR;
						} else {
								/*
								 * open o. k.
								 */
							actual_filename = import_filename;
							yylineno = 1;
							mc_list_lineno = 0;
							mc_list_level++;
							if (listfile != NULL) {
								int	i;

								fprintf (listfile, "\n");
								for (i = 1; i <= mc_list_level; i++) {
									fprintf (listfile, "IMPORT:\t");
								}
								fprintf (listfile, "%d:\t", ++mc_list_lineno);
							}

							yyclearin;

							c_out_lineno ();
						}
					} else {
							/* Import bereits durchgefuehrt, Filename Rueckspeichern */
						if (pimportsave) {
							import_filename = actual_filename;
							mkimpfnwithoutpath;
						} else {
							import_filename = NULL;
							import_filename_without_path = NULL;
						}
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 48:
# line 596 "../source/modula.yac"
{
						/* Import wurde durchgefuehrt;
						 * Zurueckspeichern
						 * der Variablen des
						 * aufrufendes Moduls
						 */

					ImportSave	*pisave;
					
					fclose (yyin);

					yyclearin;

					pisave = pimportsave;
					yyin = pisave->yyin;
					yylineno = pisave->yylineno;
					mc_list_lineno = pisave->mc_list_lineno;
					mc_list_level--;
					if (listfile != NULL) {
						int	i;

						fprintf (listfile, "\n");
						for (i = 1; i <= mc_list_level; i++) {
							fprintf (listfile, "IMPORT:\t");
						}
						fprintf (listfile, "%dC:\t", mc_list_lineno);
					}
					yychar = pisave->yychar;
					memcpy (yysbuf, pisave->yysbuf, max_token_length);
					yysptr = pisave->yysptr;
					actual_filename = pisave->actual_filename; /* Pointer genuegt */
					moduletype = pisave->moduletype;
					pimportsave = pisave->previous;
					free (pisave->yysbuf);
					free (pisave);

					c_out_lineno ();

					if (pimportsave) {
						import_filename = actual_filename;
						mkimpfnwithoutpath;
					} else {
						import_filename = NULL;
						import_filename_without_path = NULL;
					}
				} /*NOTREACHED*/ break;
case 49:
# line 645 "../source/modula.yac"
{
						/* String-Value yylval.s.val.sv
						 * ist ohne Anfuehrungszeichen */
					import_filename = yypvt[-0].s.val.sv;
					mkimpfnwithoutpath;
				} /*NOTREACHED*/ break;
case 56:
# line 664 "../source/modula.yac"
{
					export = 1;
				} /*NOTREACHED*/ break;
case 57:
# line 669 "../source/modula.yac"
{
					export = 0;
				} /*NOTREACHED*/ break;
case 61:
# line 680 "../source/modula.yac"
{
					c_out_linebegin ("");
					c_out ("extern ");
					c_out_id (yypvt[-0].s.val.pstbl->ofstblentry);
					c_out_id (yypvt[-0].s.val.pstbl);
					c_out ("();");
					c_out_lf ();

					setactualblock (e_MODULE, NULL);
				} /*NOTREACHED*/ break;
case 62:
# line 690 "../source/modula.yac"
{
					setactualblock (e_MODULE, NULL);
				} /*NOTREACHED*/ break;
case 63:
# line 693 "../source/modula.yac"
{
					setactualblock (e_MODULE, NULL);
				} /*NOTREACHED*/ break;
case 64:
# line 696 "../source/modula.yac"
{
					message (D_ERROR, "Not implemented yet");
				} /*NOTREACHED*/ break;
case 66:
# line 707 "../source/modula.yac"
{
					if (yyval.s.flag.is_error == 0) {
						c_out_linebegin ("");
						c_out ("extern ");
						c_out_id (yypvt[-0].s.val.pstbl->ofstblentry);
						c_out_id (yypvt[-0].s.val.pstbl);
						c_out ("();");
						c_out_lf ();
					}
				} /*NOTREACHED*/ break;
case 92:
# line 776 "../source/modula.yac"
{
					pstblentry = symbtbladd (id_name);
					pstblentry->iart.is_interruptid = 1;
					pstblentry->status.is_defined = 1;
					pstblentry->ofstblentry = voidstblentry;
					yyval.s.val.pstbl = pstblentry;
				} /*NOTREACHED*/ break;
case 93:
# line 784 "../source/modula.yac"
{
					ta = yypvt[-0].s.art.stbltyp->u.oftype->tart;

					if ( ! (ta.is_byte && ! ta.is_shortint && ! ta.is_shortcard)) {
						message (D_ERROR, "yyparse (intdecllistid): Interrupt-Number must be of Type BYTE");
					}
					yypvt[-2].s.val.pstbl->u.lv = yypvt[-0].s.val.lv;
					c_out_linebegin ("extern int event_%ld (); /* Interrupt-Deklaration */", yypvt[-0].s.val.lv);
				} /*NOTREACHED*/ break;
case 101:
# line 808 "../source/modula.yac"
{
					pstblentry = symbtbladd (id_name);
					pstblentry->iart.is_constid = 1;
					pstblentry->status.is_defined = 1;
					yyval.s.val.pstbl = pstblentry;
				} /*NOTREACHED*/ break;
case 102:
# line 814 "../source/modula.yac"
{
					yyval = yypvt[-1];
				} /*NOTREACHED*/ break;
case 104:
# line 821 "../source/modula.yac"
{
					int	ignore = 0;
			
					ta = yypvt[-0].s.art.stbltyp->u.oftype->tart;
					
					yypvt[-1].s.val.pstbl->ofstblentry = yypvt[-0].s.art.stbltyp;

					c_out_linebegin ("");

					if (export && (import_filename != NULL)) {
						c_out ("extern ");
						ignore = 1;
					}

					if (ta.is_char && ta.is_array) {
												/* string */
						yypvt[-1].s.val.pstbl->u.sv = yypvt[-0].s.val.sv;
						c_out ("m0_char\t*");
						c_out_id (yypvt[-1].s.val.pstbl);
						if (! ignore) {
							c_out ("= \"%s\";", yypvt[-0].s.val.sv);
						}
					} else if (ta.is_char && ! ta.is_array) {
												/* char */
						yypvt[-1].s.val.pstbl->u.lv = yypvt[-0].s.val.lv;
						c_out ("m0_char\t");
						c_out_id (yypvt[-1].s.val.pstbl);
						if (! ignore) {
							c_out ("= '%c';", ((char) yypvt[-0].s.val.lv));
						}
					} else if (ta.is_shortreal) {
												/* alles mit Wert dv */
						yypvt[-1].s.val.pstbl->u.dv = yypvt[-0].s.val.dv;
						c_out_id (yypvt[-1].s.val.pstbl->ofstblentry);
						c_out ("\t");
						c_out_id (yypvt[-1].s.val.pstbl);
						if (! ignore) {
							c_out ("= %.32E;", yypvt[-0].s.val.dv);
						}
					} else if (ta.is_byte || ta.is_boolean) {
												/* alles mit Wert lv */
						yypvt[-1].s.val.pstbl->u.lv = yypvt[-0].s.val.lv;
						c_out_id (yypvt[-1].s.val.pstbl->ofstblentry);
						c_out ("\t");
						c_out_id (yypvt[-1].s.val.pstbl);
						if (! ignore) {
							c_out ("= 0x%lX; /*Dec.: %ld*/", yypvt[-0].s.val.lv, yypvt[-0].s.val.lv);
						}
					} else if (ta.is_computer) {
												/* Computer */
						if (moduletype != e_PROCMOD || yypvt[-1].s.val.pstbl->ofblock->type != e_MODULE) {
							message (D_ERROR, "yyparse (constorcomputer): Declarations of Type COMPUTER only at the Constant Declarationpart of the Processor-Module allowed");
						}
						c_out ("m0_computer\tc_%s", yypvt[-1].s.val.pstbl->id);
						if (! ignore) {
							c_out (";");
							c_init ("\tc_%s = c_%s;", yypvt[-1].s.val.pstbl->id, yypvt[-0].s.val.pstbl->id);
						}
						yypvt[-1].s.val.pstbl->u.wsv = yypvt[-0].s.val.pstbl->u.wsv;
					} else {
						message (D_ERROR, "yyparse (constorcomputer): Constant-Type not recognized");
					}
					if (ignore) {
						c_out (";");
					}
				} /*NOTREACHED*/ break;
case 105:
# line 887 "../source/modula.yac"
{
					if ((moduletype != e_PROCMOD && ! (export && (import_filename != NULL))) || yypvt[-1].s.val.pstbl->ofblock->type != e_MODULE) {
						message (D_ERROR, "yyparse (constorcomputer): Procedure COMPUTER only at the Constant Declarationpart of the Processor-Module allowed");
					}
					setidart (is_generictype);

					if ((pstblentry = symbtbllookupwithinidart ("computer", idart)) == NULL) {
						message (D_INTERNAL, "yyparse (constorcomputer): COMPUTER-Type not found");
					}

					yypvt[-1].s.val.pstbl->ofstblentry = pstblentry;

					c_out_linebegin ("");

					if (export && (import_filename != NULL)) {
						c_out ("extern ");
					}

					c_out ("m0_computer\tc_%s;", yypvt[-1].s.val.pstbl->id);
				} /*NOTREACHED*/ break;
case 106:
# line 910 "../source/modula.yac"
{
					typedef struct WS_LIST {
								WORKSTATION	*ws;
								SymbTblEntry	*computer_entry;
								struct WS_LIST	*next;
							} WS_LIST;

					static WS_LIST	*wslist = NULL;

					int	eflag = 0;

					if (strcmp (yypvt[-2].s.art.stbltyp->id, "STRING") != 0) {
						message (D_ERROR, "yyparse (constorcomputer): Workstation-Class must be a String");
						eflag = 1;
					}

					if (strcmp (yypvt[-0].s.art.stbltyp->id, "STRING") != 0) {
						message (D_ERROR, "yyparse (constorcomputer): Workstation-Name must be a String");
						eflag = 1;
					}

					if (wslist == NULL) {
						if ((wslist = (WS_LIST *) malloc (sizeof (WS_LIST))) == NULL) {
							message (D_INTERNAL, "yyparse (constorcomputer): No more memory for WorkstationList");
						}
						if ((yypvt[-6].s.val.pstbl->u.wsv = wslist->ws = (WORKSTATION *) malloc (sizeof (WORKSTATION))) == NULL) {
							message (D_INTERNAL, "yyparse (constorcomputer): No more memory for Workstation");
						}
						wslist->ws->ws_class = strsave (yypvt[-2].s.val.sv);
						wslist->ws->ws_name = strsave (yypvt[-0].s.val.sv);
						wslist->computer_entry = yypvt[-6].s.val.pstbl;
						wslist->next = NULL;
					} else {
						WS_LIST	*wslhelp1, *wslhelp2;

						wslhelp1 = wslist;

						do {
							wslhelp2 = wslhelp1;
							if (strcmp (wslhelp1->ws->ws_name, yypvt[-0].s.val.sv) == 0) {
								message (D_ERROR, "yyparse (constorcomputer): Workstation-Name already defined! Use '%s = %s'", yypvt[-6].s.val.pstbl->id, wslhelp1->computer_entry->id);
							}
						} while ((wslhelp1 = wslhelp1->next) != NULL);

						if ((wslhelp2->next = (WS_LIST *) malloc (sizeof (WS_LIST))) == NULL) {
							message (D_INTERNAL, "yyparse (constorcomputer): No more memory for WorkstationList");
						}
						if ((yypvt[-6].s.val.pstbl->u.wsv = wslhelp2->next->ws = (WORKSTATION *) malloc (sizeof (WORKSTATION))) == NULL) {
							message (D_INTERNAL, "yyparse (constorcomputer): No more memory for Workstation");
						}
						wslhelp2->next->ws->ws_class = strsave (yypvt[-2].s.val.sv);
						wslhelp2->next->ws->ws_name = strsave (yypvt[-0].s.val.sv);
						wslhelp2->next->computer_entry = yypvt[-6].s.val.pstbl;
						wslhelp2->next->next = NULL;
					}

					if (eflag == 0) {	/* only strings may be put out */
						if (! (export && (import_filename != NULL))) {
							c_init ("\tc_%s = add_computer (\"%s\", \"%s\");\n", yypvt[-6].s.val.pstbl->id, yypvt[-2].s.val.sv, yypvt[-0].s.val.sv);
						}
					}
				} /*NOTREACHED*/ break;
case 114:
# line 988 "../source/modula.yac"
{
					pstblentry = symbtbladd (id_name);
					pstblentry->iart.is_typeid = 1;
					pstblentry->status.is_defined = 1;
					add_stbl_list (pstblentry);
				} /*NOTREACHED*/ break;
case 115:
# line 994 "../source/modula.yac"
{
					yyval.s.art.da = def_type;
				} /*NOTREACHED*/ break;
case 117:
# line 1001 "../source/modula.yac"
{
					c_saved_out ();
				} /*NOTREACHED*/ break;
case 124:
# line 1016 "../source/modula.yac"
{
					yyval.s.art.da = def_var;
				} /*NOTREACHED*/ break;
case 128:
# line 1029 "../source/modula.yac"
{
					pstblentry = symbtbladd (id_name);
					pstblentry->iart.is_varid = 1;
					pstblentry->status.is_defined = 1;
					add_stbl_list (pstblentry);
					yyval.s.val.pstbl = pstblentry;
				} /*NOTREACHED*/ break;
case 130:
# line 1039 "../source/modula.yac"
{
					if (moduletype != e_LOWMOD) {
						message (D_ERROR, "yyparse (_address_): Address only in Lowlevel-Modules allowed");
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 131:
# line 1045 "../source/modula.yac"
{
					ta = yypvt[-0].s.art.stbltyp->u.oftype->tart;

					if (! ta.is_byte) {
						message (D_ERROR, "yyparse (_address_): Constant-Expression of invalid Type");
						YYERROR;
					}

					if ((yypvt[-0].s.val.lv & 0xFFFF) != yypvt[-0].s.val.lv) {
						message (D_ERROR, "yyparse (_address_): Constant-Expression too big (max. 2 Byte)");
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 132:
# line 1059 "../source/modula.yac"
{
					ta = yypvt[-0].s.art.stbltyp->u.oftype->tart;

					if (! ta.is_byte) {
						message (D_ERROR, "yyparse (_address_): Constant-Expression of invalid Type");
						YYERROR;
					}
					
					if ((yypvt[-0].s.val.lv & 0xFFFF) != yypvt[-0].s.val.lv) {
						message (D_ERROR, "yyparse (_address_): Constant-Expression too big (max. 2 Byte)");
						YYERROR;
					}

					c_out_lf ();
					c_out ("#define ");
					c_out_id (yypvt[-6].s.val.pstbl);
					c_out ("\t");
					c_out ("\t*a%d_%s ", yypvt[-6].s.val.pstbl->ofblock->nr, yypvt[-6].s.val.pstbl->id);
					c_out_lf ();
					c_save ("\n#line %d \"%s\"", yylineno, actual_filename);
					c_save ("\n#undef m%d_%s", yypvt[-6].s.val.pstbl->ofblock->nr, yypvt[-6].s.val.pstbl->id);
					c_init ("\ta%d_%s = ", yypvt[-6].s.val.pstbl->ofblock->nr, yypvt[-6].s.val.pstbl->id);
					c_init ("(void *) 0x%4.4lX%4.4lX;\n", yypvt[-3].s.val.lv, yypvt[-0].s.val.lv);
					c_save ("\n#define m%d_%s\t", yypvt[-6].s.val.pstbl->ofblock->nr, yypvt[-6].s.val.pstbl->id);
					c_save ("(*a%d_%s)\n", yypvt[-6].s.val.pstbl->ofblock->nr, yypvt[-6].s.val.pstbl->id);
				} /*NOTREACHED*/ break;
case 134:
# line 1086 "../source/modula.yac"
{
					if (moduletype != e_LOWMOD) {
						message (D_ERROR, "yyparse (_address_): Address only in Lowlevel-Modules allowed");
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 135:
# line 1093 "../source/modula.yac"
{
					setidart (is_varid);
					if ((pstblentry = symbtbllookupwithinidart (id_name, idart)) == NULL) {
						message (D_ERROR, "yyparse (_address_): Variable-Identifier '%s' not declared", id_name_fuer_fehlertext);
						YYERROR;
					}
					if (pstblentry->ofstblentry == NULL) {
						message (D_ERROR, "yyparse (_address_): Variable-Identifier '%s' must be fully declared before address-reference", id_name_fuer_fehlertext);
						YYERROR;
					}
					c_out_lf ();
					c_out ("#define ");
					c_out_id (yypvt[-4].s.val.pstbl);
					c_out ("\t");
					c_out ("\t*a%d_%s ", yypvt[-4].s.val.pstbl->ofblock->nr, yypvt[-4].s.val.pstbl->id);
					c_out_lf ();
					c_save ("\n#line %d \"%s\"", yylineno, actual_filename);
					c_save ("\n#undef m%d_%s", yypvt[-4].s.val.pstbl->ofblock->nr, yypvt[-4].s.val.pstbl->id);
					c_init ("\ta%d_%s = ", yypvt[-4].s.val.pstbl->ofblock->nr, yypvt[-4].s.val.pstbl->id);
					c_init ("(void *) &m%d_%s;\n", pstblentry->ofblock->nr, pstblentry->id);
					c_save ("\n#define m%d_%s\t", yypvt[-4].s.val.pstbl->ofblock->nr, yypvt[-4].s.val.pstbl->id);
					c_save ("(*a%d_%s)\n", yypvt[-4].s.val.pstbl->ofblock->nr, yypvt[-4].s.val.pstbl->id);
				} /*NOTREACHED*/ break;
case 138:
# line 1120 "../source/modula.yac"
{
					yyval = yypvt[-1];
				} /*NOTREACHED*/ break;
case 139:
# line 1123 "../source/modula.yac"
{
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 140:
# line 1126 "../source/modula.yac"
{
					if (yypvt[-1].s.art.blcktyp == e_MONITOR) {
						if ((pstblentry = symbtbllookup ("semaphore")) == NULL) {
							message (D_FATAL, "yyparse (block): Semaphore-Type not found");
						}
						c_out_lf ();
						c_out_linebegin ("");
						c_out_id (pstblentry);
						c_out ("sem_%s;", yypvt[-1].s.val.pstbl->id);
						c_init ("\tsem_%s = sem_define (1);\t/* Monitor-Semaphor-Init. */\n", yypvt[-1].s.val.pstbl->id);
					}
					if (yypvt[-1].s.art.blcktyp == e_COMMUNICATION) {
						message (D_ERROR, "yyparse (block): Empty Block not allowed for Communications (at least keyword BEGIN required)");
					}
					if (yypvt[-1].s.art.blcktyp != e_EVENT && yypvt[-1].s.art.blcktyp != e_EXCEPTION) {
							/* bei Events ist das schon alles erledigt, Exceptions s. u.  */
						c_out_lf ();
						c_out_linebegin ("m0_void ");
						c_out_id (yypvt[-1].s.val.pstbl);
						c_out ("()");
						c_out_lf ();
						c_out ("{");
						c_out_lf ();
					} else if (yypvt[-1].s.art.blcktyp == e_EXCEPTION) {
							/* Prozess beenden bei Exceptions ohne RESUME */
						c_out_lf ();
						c_out_linebegin ("if (strcmp (processtype, \"COMMUNICATION\") == 0) {");
						c_out_lf ();
						c_out_linebegin ("\trpc_service_stop_client_site (NULL);");
						c_out_lf ();
						c_out_linebegin ("} else {");
						c_out_lf ();
						c_out_linebegin ("\texit (0);");
						c_out_lf ();
						c_out_linebegin ("}");
						tabcnt--;
						c_out_lf ();
					} else {
							/* Interrupts aktivieren bei Events */
						c_out_lf ();
						c_out_linebegin ("sig_set ();");
						tabcnt--;
						c_out_lf ();
					}
					if (lookforgentypeart (yypvt[-1].s.val.pstbl).is_void == 0) {
						message (D_ERROR, "yyparse (block): Empty Block only with Procedure-Type void allowed");
					}
					c_out_linebegin ("}");

					if (lookforgentypeart (yypvt[-1].s.val.pstbl).is_void == 0) {
						message (D_ERROR, "yyparse (block): Procedures returning a Value must have a RETURN-Statement");
					}

					deleteactualblock ();
				} /*NOTREACHED*/ break;
case 141:
# line 1181 "../source/modula.yac"
{
					yyerrok;
					yyval = yypvt[-1];
				} /*NOTREACHED*/ break;
case 142:
# line 1186 "../source/modula.yac"
{
					yyval = yypvt[-1];
				} /*NOTREACHED*/ break;
case 143:
# line 1191 "../source/modula.yac"
{
					phead = yypvt[-0].s.val.pstbl;

						/* bei Events und Exceptions ist schon alles erledigt */
					if (yypvt[-0].s.art.blcktyp != e_EVENT && yypvt[-0].s.art.blcktyp != e_EXCEPTION) {
						c_out_linebegin ("");
						if (yypvt[-0].s.art.blcktyp == e_MONITOR) {
							if ((pstblentry = symbtbllookup ("semaphore")) == NULL) {
								message (D_FATAL, "yyparse (block): Semaphore-Type not found");
							}
							c_out_id (pstblentry);
							c_out ("sem_%s;", yypvt[-0].s.val.pstbl->id);
							c_out_lf ();
							c_out_linebegin ("");
							c_init ("\tsem_%s = sem_define (1);\t/* Monitor-Semaphor-Init. */\n", yypvt[-0].s.val.pstbl->id);
						}

						if (yypvt[-0].s.art.blcktyp == e_COMMUNICATION) {
							c_out_lf ();
							c_out ("comm_out\tout;");
							c_out_lf ();
							c_out_linebegin ("comm_out *comm_procedure_1 (in)");
							c_out_lf ();
							c_out_linebegin ("\tcomm_in\t*in;");
						} else {
							c_out_id (yypvt[-0].s.val.pstbl->ofstblentry);
							c_out_id (yypvt[-0].s.val.pstbl);
							c_out ("(");
						}

						switch (yypvt[-0].s.art.blcktyp) {
						case e_MONITOR:
						default:
							c_out (")");
							break;
						case e_COMMUNICATION:
							comm_param_out (yypvt[-0].s.val.pstbl);	
							break;
						case e_PROCEDURE:
						case e_PROCESS:
						case e_ENTRY:
							formal_param_out (yypvt[-0].s.val.pstbl);	
							break;
						}
						c_out_lf ();
						c_out ("{");
						c_out_lf ();
						tabcnt++;
						if (lookforgentypeart (yypvt[-0].s.val.pstbl).is_void == 0) {
							c_out_linebegin ("");
							c_out_id (yypvt[-0].s.val.pstbl->ofstblentry);
							c_out ("\tretval;");
							c_out_lf ();
						}
					}
					if (yypvt[-0].s.art.blcktyp == e_PROCEDURE) {
						save_locals ();
					} else if (yypvt[-0].s.art.blcktyp == e_ENTRY) {
						c_out_lf ();
						c_out_linebegin ("m0_p (sem_%s);", yypvt[-0].s.val.pstbl->ofblock->id);
						c_out_lf ();
						c_out_linebegin ("consume_verbot = 1;");
					}
					yyval.s.flag = null_flag;
				} /*NOTREACHED*/ break;
case 144:
# line 1256 "../source/modula.yac"
{
					if (yypvt[-2].s.art.blcktyp == e_PROCEDURE || yypvt[-2].s.art.blcktyp == e_ENTRY || yypvt[-2].s.art.blcktyp == e_COMMUNICATION) {
						revoke_fparams_var_attr (yypvt[-2].s.val.pstbl);	
						c_out_lf ();
						c_out ("ret:");
						c_saved_out ();
					}

					if (yypvt[-2].s.art.blcktyp == e_ENTRY) {
						c_out_lf ();
						c_out_linebegin ("m0_v (sem_%s);", yypvt[-2].s.val.pstbl->ofblock->id);
						c_out_lf ();
						c_out_linebegin ("consume_verbot = 0;");
					} else if (yypvt[-2].s.art.blcktyp == e_EVENT || yypvt[-2].s.art.blcktyp == e_EXCEPTION) {
							/* Interrupts aktivieren
							 * bei Events und Exceptions
							 * mit RESUME, sowie Prozess
							 * beenden bei Exceptions ohne RESUME */
						if (yypvt[-2].s.art.blcktyp == e_EXCEPTION) {
							c_out_lf ();
							c_out_linebegin ("if (strcmp (processtype, \"COMMUNICATION\") == 0) {");
							c_out_lf ();
							c_out_linebegin ("\trpc_service_stop_client_site (NULL);");
							c_out_lf ();
							c_out_linebegin ("} else {");
							c_out_lf ();
							c_out_linebegin ("\texit (0);");
							c_out_lf ();
							c_out_linebegin ("}");
							c_out_lf ();
							c_out ("ret:");
						}
						c_out_lf ();
						c_out_linebegin ("sig_set ();");
					}
					c_out_lf();

					if (yypvt[-2].s.art.blcktyp == e_COMMUNICATION) {
						comm_return (yypvt[-2].s.val.pstbl);
					} else if (lookforgentypeart (yypvt[-2].s.val.pstbl).is_void) {
						c_out_linebegin ("return;");
					} else {
						c_out_linebegin ("return (retval);");
						if (blocklist->retcount <= 0) {
							message (D_ERROR, "yyparse (block): Procedures returning a Value must have a RETURN-Statement");
						}
					}
					c_out_lf ();
					tabcnt--;
					c_out_linebegin ("}");

					deleteactualblock ();
				} /*NOTREACHED*/ break;
case 146:
# line 1314 "../source/modula.yac"
{
					clr_exbuf ();
				} /*NOTREACHED*/ break;
case 147:
# line 1320 "../source/modula.yac"
{
					yyval.s.flag = null_flag;
				} /*NOTREACHED*/ break;
case 152:
# line 1329 "../source/modula.yac"
{
					c_out_lf ();
					c_out_linebegin ("");
					c_out_exbuf ();
					c_out (";");
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 162:
# line 1345 "../source/modula.yac"
{
					loop_stack (0);
				} /*NOTREACHED*/ break;
case 163:
# line 1349 "../source/modula.yac"
{
					yyval.s.flag = null_flag;
					yyval.s.flag.is_cond_or_sem_fn = 1;
				} /*NOTREACHED*/ break;
case 164:
# line 1353 "../source/modula.yac"
{
					BlockList	*bh;
			
					if (moduletype == e_LOWMOD || blocklist->nextblocklist->type != e_ENTRY) {
						message (D_ERROR, "yyparse (statement): Procedure WAIT only in Entry-Block allowed");
						YYERROR;
					}
					if (yypvt[-0].s.art.stbltyp->u.oftype->tart.is_condition == 0) {
						message (D_ERROR, "yyparse (statement): WAIT-Parameter is not of type CONDITION");
						YYERROR;
					}
					bh = blocklist;
					while (bh->type != e_MONITOR) {
						bh = bh->nextblocklist;
						if (bh == NULL) {
							message (D_INTERNAL, "yyparse (statement): Blocklist of Monitor not found");
						}
					}
					c_out_lf ();
					c_out_linebegin ("consume_verbot = 0;");
					c_out_lf ();
					c_out_linebegin ("m0_v_and_wait (sem_%s, ", bh->id);
					c_out_exbuf ();
					c_out (");");
					c_out_lf ();
					c_out_linebegin ("m0_p (sem_%s);", bh->id);
					c_out_lf ();
					c_out_linebegin ("consume_verbot = 1;");
				} /*NOTREACHED*/ break;
case 166:
# line 1383 "../source/modula.yac"
{
					c_out_lf ();
					c_out_linebegin ("if (strcmp (processtype, \"COMMUNICATION\") == 0) {");
					c_out_lf ();
					c_out_linebegin ("\trpc_service_stop_client_site (NULL);");
					c_out_lf ();
					c_out_linebegin ("} else {");
					c_out_lf ();
					c_out_linebegin ("\texit (0);");
					c_out_lf ();
					c_out_linebegin ("}");
				} /*NOTREACHED*/ break;
case 167:
# line 1396 "../source/modula.yac"
{
					yyval.s.flag = null_flag;
					yyval.s.flag.is_cond_or_sem_fn = 1;
				} /*NOTREACHED*/ break;
case 168:
# line 1400 "../source/modula.yac"
{
					if (moduletype != e_LOWMOD) {
						message (D_ERROR, "yyparse (statement): Procedures P and V only in Lowlevel-Modules allowed");
						YYERROR;
					}
					if (yypvt[-0].s.art.stbltyp->u.oftype->tart.is_semaphore == 0) {
						message (D_ERROR, "yyparse (statement): P- or V-Parameter is not of type SEMAPHORE");
						YYERROR;
					}
					c_out_lf ();
					if (yypvt[-3].s.val.ov [0] == 'P') {
						c_out_linebegin ("m0_p (");
					} else {
						c_out_linebegin ("m0_v (");
					}
					c_out_exbuf ();
					c_out (");");
				} /*NOTREACHED*/ break;
case 170:
# line 1420 "../source/modula.yac"
{
					yyval.s.flag = null_flag;
					yyval.s.flag.is_cond_or_sem_fn = 1;
				} /*NOTREACHED*/ break;
case 171:
# line 1424 "../source/modula.yac"
{
					BlockList	*bl;

					bl = blocklist->nextblocklist;
					if (moduletype == e_LOWMOD || bl->type != e_ENTRY) {
						message (D_ERROR, "yyparse (statement): Procedure SIGNAL only in Entry-Block allowed");
						YYERROR;
					}
					if (yypvt[-0].s.art.stbltyp->u.oftype->tart.is_condition == 0) {
						message (D_ERROR, "yyparse (statement): SIGNAL-Parameter is not of type CONDITION");
						YYERROR;
					}
					c_out_lf ();
					c_out_linebegin ("m0_signal (");
					c_out_exbuf ();
					c_out (");");
				} /*NOTREACHED*/ break;
case 173:
# line 1443 "../source/modula.yac"
{
					clr_exbuf ();
				} /*NOTREACHED*/ break;
case 174:
# line 1446 "../source/modula.yac"
{
					if (lookforgentypeart (yypvt[-0].s.art.stbltyp).is_shortcard == 0) {
						message (D_ERROR, "yyparse (statement): RAISE only with argument of SHORTCARD-Type allowed");
					}
					if (strcmp (blocklist->id, "Exception") == 0) {
						message (D_ERROR, "yyparse (statement): RAISE is forbidden within an Exception");
					}
					c_out_lf ();
					c_out_linebegin ("m0_raise (");
					c_out_exbuf ();
					c_out (");");
				} /*NOTREACHED*/ break;
case 176:
# line 1459 "../source/modula.yac"
{
					if (strcmp (blocklist->id, "Exception") != 0) {
						message (D_ERROR, "yyparse (statement): RESUME is forbidden outside of an Exception");
					}
					
					c_out_lf ();
					c_out_linebegin ("goto ret;");
				} /*NOTREACHED*/ break;
case 177:
# line 1467 "../source/modula.yac"
{
					if (moduletype != e_PROCMOD || blocktype != e_MODULE) {
						message (D_ERROR, "yyparse (statement): Procedure INITCOM only in the Initialization-Block of the Processor-Module allowed");
					}
				} /*NOTREACHED*/ break;
case 178:
# line 1473 "../source/modula.yac"
{
					setidart (is_communicationid);
					if ((pstblentry = symbtbllookupwithinidart (id_name, idart)) == NULL) {
						message (D_ERROR, "yyparse (statement): First Parameter of INITCOM is no Communication Identifier");
					}
					yyval.s.val.pstbl = pstblentry;
				} /*NOTREACHED*/ break;
case 179:
# line 1481 "../source/modula.yac"
{
					typedef	struct	INITCOMLIST {
								char	*computer;
								char	*communication;
								struct	INITCOMLIST	*next;
							} INITCOMLIST;

					static	INITCOMLIST	*iclist = NULL, *iclhelp;

					typedef	struct	COMPILELIST {
								char	*ws_class;
								char	*communication;
								struct	COMPILELIST	*next;
							} COMPILELIST;

					static	COMPILELIST	*rshcclist = NULL, *rshcclhelp;

					setidart (is_constid);
					if ((pstblentry = symbtbllookupwithinidart (id_name, idart)) == NULL) {
						message (D_ERROR, "yyparse (statement): Second Parameter of INITCOM is no Constant Identifier");
					}
					if (lookforgentypeart (pstblentry).is_computer == 0) {
						message (D_ERROR, "yyparse (statement): Second Parameter of INITCOM is not of type COMPUTER");
					}

							/* Check, ob bereits initialisiert */
					iclhelp = iclist;

					while (iclhelp != NULL) {
						if (   (strcmp (iclhelp->computer, pstblentry->id) == 0)
						    && (strcmp (iclhelp->communication, yypvt[-2].s.val.pstbl->id) == 0)) {
							break;
						}
						iclhelp = iclhelp->next;
					}

					if (iclhelp != NULL) {
						message (D_ERROR, "yyparse (statement): INITCOM (%s, %s) cannot be used more than once", yypvt[-2].s.val.pstbl->id, pstblentry->id);
					} else {
						if ((iclhelp = (INITCOMLIST *) malloc (sizeof (INITCOMLIST))) == NULL) {
							message (D_INTERNAL, "yyparse (statement): No more memory for INITCOMLIST");
						}

						iclhelp->next = iclist;

						iclist = iclhelp;
						iclist->computer = pstblentry->id;
						iclist->communication = yypvt[-2].s.val.pstbl->id;

						c_out_lf ();
						c_out_linebegin ("init_communication (c_%s, \"%s\", \"%s\", ", pstblentry->id, pstblentry->id, yypvt[-2].s.val.pstbl->id);
					}

							/* Remote Compilation */
					if (strlen (module_name) + strlen (yypvt[-2].s.val.pstbl->id) + strlen (pstblentry->u.wsv->ws_class) > 250) {
						message (D_ERROR, "yyparse (statement): Name '%s_%s_%s' too long for a communication server program", module_name, yypvt[-2].s.val.pstbl->id, pstblentry->u.wsv->ws_class);
					} else {
								/* Check, ob bereits compiliert */
						rshcclhelp = rshcclist;

						while (rshcclhelp != NULL) {
							if (   (strcmp (rshcclhelp->ws_class, pstblentry->u.wsv->ws_class) == 0)
							    && (strcmp (rshcclhelp->communication, yypvt[-2].s.val.pstbl->id) == 0)) {
								break;
							}
							rshcclhelp = rshcclhelp->next;
						}

						if (rshcclhelp == NULL) {
								/* Noch nicht compiliert, --> Eintrag in Liste */
							if ((rshcclhelp = (COMPILELIST *) malloc (sizeof (COMPILELIST))) == NULL) {
								message (D_INTERNAL, "yyparse (statement): No more memory for COMPILELIST");
							}

							rshcclhelp->next = rshcclist;

							rshcclist = rshcclhelp;
							rshcclist->ws_class = pstblentry->u.wsv->ws_class;
							rshcclist->communication = yypvt[-2].s.val.pstbl->id;

								/* remote Compilation */
							remote_compile (pstblentry->u.wsv->ws_name, yypvt[-2].s.val.pstbl->id, pstblentry->u.wsv->ws_class);
						}
					}

					yyval.s.val.pstbl = pstblentry;
				} /*NOTREACHED*/ break;
case 180:
# line 1568 "../source/modula.yac"
{
					c_out (", &cno_%s);", yypvt[-4].s.val.pstbl->id);
					c_out_lf ();
				} /*NOTREACHED*/ break;
case 182:
# line 1574 "../source/modula.yac"
{
					if (strcmp (blocklist->id, "Exception") != 0) {
						message (D_ERROR, "yyparse (statement): RESTART is forbidden outside of an Exception");
					}
					
					c_out_lf ();
					c_out_linebegin ("sig_set (); /* Exception ends here, Restart of the Process follows */");

					procedure_call.is_procedureid = 0;
					procedure_call.is_processid = 1;
					
					yyval.s.flag = null_flag;
					yyval.s.flag.is_restartofprocess = 1;
				} /*NOTREACHED*/ break;
case 183:
# line 1588 "../source/modula.yac"
{
					procedure_call.is_procedureid = 1;
					procedure_call.is_processid = 0;
					
					c_out_lf ();
					c_out_linebegin ("exit (0); /* End of the Process */");
				} /*NOTREACHED*/ break;
case 185:
# line 1597 "../source/modula.yac"
{
					c_out_lf ();
					c_out_linebegin ("cnt = 1;");
					c_out_lf ();
					c_out_linebegin ("do {");
					tabcnt++;
					c_out_lf ();
					c_out_linebegin ("if ((fork_return_code = fork ()) == 0) { /* child */");
					tabcnt++;
					c_out_lf ();
					c_out_linebegin ("m0_processid = (int) getpid ();");
					c_out_lf ();
					c_out_linebegin ("consume_global_sem ();");
					c_out_lf ();
					c_out_linebegin ("sig_set ();");

					procedure_call.is_procedureid = 0;
					procedure_call.is_processid = 1;
					
					yyval.s.flag = null_flag;
					yyval.s.flag.is_startofprocess = 1;
				} /*NOTREACHED*/ break;
case 186:
# line 1619 "../source/modula.yac"
{
					procedure_call.is_procedureid = 1;
					procedure_call.is_processid = 0;
					
					c_out_lf ();
					c_out_linebegin ("exit (0); /* child's death */");
					tabcnt--;
					c_out_lf ();
					c_out_linebegin ("} /* parent continues work */");
					c_out_lf ();
					c_out_linebegin ("if (fork_return_code == -1)");
					c_out_lf ();
					c_out_linebegin ("\truntime_error (P_INTERN, \"Too many Processes. Program system is stopped\");");
					c_out_lf ();
					c_out_linebegin ("cnt++;");
					tabcnt--;
					c_out_lf ();
					c_out_linebegin ("} while (cnt <= (");
				} /*NOTREACHED*/ break;
case 187:
# line 1638 "../source/modula.yac"
{
					c_out ("));");
					c_out_lf ();
				} /*NOTREACHED*/ break;
case 189:
# line 1644 "../source/modula.yac"
{
					yyerrok;
					yyval.s.flag = null_flag;
					clr_exbuf ();
				} /*NOTREACHED*/ break;
case 191:
# line 1651 "../source/modula.yac"
{
					yyerrok;
					yyval.s.flag = null_flag;
					clr_exbuf ();
				} /*NOTREACHED*/ break;
case 194:
# line 1661 "../source/modula.yac"
{
					clr_exbuf ();
				} /*NOTREACHED*/ break;
case 195:
# line 1664 "../source/modula.yac"
{
					if (lookforgentypeart (yypvt[-0].s.art.stbltyp).is_byte == 0) {
						message (D_ERROR, "yyparse (countornot): START or INITCOM only with second argument of INTEGER- or CARDINAL-Type allowed");
					}
					c_out_exbuf ();
				} /*NOTREACHED*/ break;
case 196:
# line 1670 "../source/modula.yac"
{
					c_out (" 1 ");
				} /*NOTREACHED*/ break;
case 197:
# line 1677 "../source/modula.yac"
{
					if (yypvt[-1].s.art.stbltyp->iart.is_openarrayparam) {
						message (D_ERROR, "yyparse (assignment): Assignment to Open-Array impossible");
						YYERROR;
					}

					if (yypvt[-2].s.flag.is_for_assignment) {
						c_out_exbuf ();
						c_out_lf ();
						c_out_linebegin ("for (");
						c_exbuf ("for_variable");
					}
					
					if (yypvt[-1].s.val.pstbl->iart.is_for_parameter) {
						message (D_ERROR, "yyparse (assignment): Variable-Identifier left of ':=' is used in outer FOR-Statement");
					}

					if (yypvt[-1].s.flag.is_lvalue == 0) {
						message (D_ERROR, "yyparse (assignment): Identifier left of ':=' must be lvalue (no Constant or Procedurecall)");
						YYERROR;
					}

					c_exbuf (" =  "); /* Unbedingt zwei Blanks nach dem '=' lassen (s. ca. 10 Zeilen tiefer) */
					put_expr_pos ();
				} /*NOTREACHED*/ break;
case 198:
# line 1702 "../source/modula.yac"
{
					Types	*t1;
					char	*pc;

					get_expr_pos ();
					
					t1 = yypvt[-3].s.art.stbltyp->u.oftype;

					/* siehe selbiges auch beim returnstat */
							/* Typecheck */
					ta2 = lookforgentypeart (yypvt[-0].s.art.stbltyp);

					if (t1->tart.is_array && t1->oftype->u.oftype->tart.is_char && ta2.is_char) {
									/* String_Var := (Char || String) */
						pc = strchr (expression_buffer, '=');

						pc [0] = '.';
						pc [1] = 'a';
						pc [2] = ',';

						pc = pc + 3;

						if (! ta2.is_array) {
							insert_exbuf (pc, "mk_str (");
							c_exbuf (")");
						}
							
						c_out ("strncpy (");
						c_out_exbuf ();
						c_out (", sizeof (");
						c_out_id (yypvt[-3].s.art.stbltyp);
						c_out (") - 1 )");
					} else if ((t1->tart.is_subrange) && (yypvt[-3].s.art.stbltyp->status.is_predeclared == 0)) {
							/* Nur bei Programm-Definierten Subrange-Typen,
							 * nicht bei Byte, CHAR, ... */
						if (maxtype (yypvt[-3].s.art.stbltyp, yypvt[-0].s.art.stbltyp) == NULL) {
							message (D_ERROR, "yyparse (assignment): Incompatible Types at Subrange-Assignment");
							YYERROR;
						}
						if (yypvt[-4].s.flag.is_for_assignment == 0) {
								/* nicht bei FOR-Assignments (dieser Test folgt innerhalb der Schleife) */
							pc = strchr (expression_buffer, '=');
							pc = pc + 3;
							insert_exbuf (pc, "range_check ((long) ");
							c_out_exbuf ();
							c_out (", 0x%lXL /*Dec. %ld*/", t1->minval, t1->minval);
							c_out (", 0x%lXL /*Dec. %ld*/", t1->maxval, t1->maxval);
							c_out (", %d /*lineno*/", yylineno);
							c_out (", \"%s\"", actual_filename);
							c_out (") + 0x%lXL /*Dec. %ld; range_check returns first_value - second_value*/", t1->minval, t1->minval);
						}
					} else if (t1->tart.is_pointer && ta2.is_pointer) {
						if ( ! ((strcmp (t1->oftype->id, "void") == 0) || (strcmp (lookforgentype (yypvt[-0].s.art.stbltyp)->u.oftype->oftype->id, "void") == 0))) {
							if (yypvt[-3].s.art.stbltyp != maxtype (yypvt[-3].s.art.stbltyp, yypvt[-0].s.art.stbltyp)) {
								message (D_ERROR, "yyparse (assignment): Incompatible Types at Pointer-Assignment");
								YYERROR;
							}
						}
					} else if (yypvt[-3].s.art.stbltyp != maxtype (yypvt[-3].s.art.stbltyp, yypvt[-0].s.art.stbltyp)) {
						message (D_ERROR, "yyparse (assignment): Incompatible Types at Assignment");
						YYERROR;
					}
					
					c_out_exbuf ();
					c_out (";");

					yyval = yypvt[-3]; /* siehe forstat */
				} /*NOTREACHED*/ break;
case 199:
# line 1773 "../source/modula.yac"
{
					if (yypvt[-1].s.flag.is_entrycall) {
						setidart (is_entryid);
					} else if (yypvt[-1].s.flag.is_communicationcall) {
						setidart (is_communicationid);
					} else if (yypvt[-1].s.flag.is_startofprocess || yypvt[-1].s.flag.is_restartofprocess) {
						setidart (is_processid);
					} else {
						setidart (is_varid);
						idart.is_constid = idart.is_procedureid = idart.is_monitorid = idart.is_semaphoreid = idart.is_conditionid = 1;
					}
					if ((pstblentry = symbtbllookupwithinidart (id_name, idart)) == NULL) {
						message (D_ERROR, "yyparse (designator): Identifier '%s' doesn't exist", id_name_fuer_fehlertext);
						YYERROR;
					}
					if (   (yypvt[-1].s.flag.is_cond_or_sem_fn == 0)
					    && (pstblentry->iart.is_semaphoreid || pstblentry->iart.is_conditionid)) {
						message (D_ERROR, "yyparse (designator): Identifier '%s' is of Type SEMAPHORE or CONDITION, Assignments are not allowed", id_name_fuer_fehlertext);
						YYERROR;
					} else if (pstblentry->iart.is_constid) {
						yyval.s.flag.is_const = 1;
						yyval.s.flag.is_lvalue = 0;
					} else if (   pstblentry->iart.is_procedureid
						   || pstblentry->iart.is_processid
						   || pstblentry->iart.is_monitorid
						   || pstblentry->iart.is_entryid
						   || pstblentry->iart.is_communicationid) {
						yyval.s.flag.is_const = 0;
						yyval.s.flag.is_lvalue = 0;
					} else {	/* Variable */
						yyval.s.flag.is_const = 0;
						yyval.s.flag.is_lvalue = 1;
					}

					if (yypvt[-1].s.flag.is_for_assignment == 0 && yypvt[-1].s.flag.is_expr == 0) {
						c_out_lf ();
						c_out_linebegin ("");
					}

					if (! pstblentry->iart.is_monitorid) {
							/* Monitorname wird nicht ausgegeben */
						c_exbuf_id (pstblentry);
					}
					
					yyval.s.art.stbltyp = lookforgentype (pstblentry);
					yyval.s.val.pstbl = pstblentry;
				} /*NOTREACHED*/ break;
case 200:
# line 1820 "../source/modula.yac"
{
					yyval = yypvt[-0];
					yyval.s.val.pstbl = yypvt[-1].s.val.pstbl;
					yyval.s.flag = yypvt[-1].s.flag;
				} /*NOTREACHED*/ break;
case 201:
# line 1826 "../source/modula.yac"
{
					c_exbuf ("m0_%s (", yypvt[-1].s.val.ov);
					put_expr_pos ();
				} /*NOTREACHED*/ break;
case 202:
# line 1831 "../source/modula.yac"
{
					get_expr_pos ();

					ta = lookforgentypeart (yypvt[-1].s.art.stbltyp);
					setidart (is_generictype);
					
					if (yypvt[-4].s.val.ov [0] == '0' && yypvt[-4].s.val.ov [1] == '_' /* see modula.lex */) {
							/* Typ-Umwandlungs-Funktion */
						if ((pstblentry = symbtbllookupwithinidart (yypvt[-4].s.val.ov + 2, idart)) == NULL) {
							message (D_INTERNAL, "yyparse (designator): Invalid Type Conversion Function");
						}
						if (ta.is_byte) {
							if (lookforgentypeart (pstblentry).is_shortreal) {
								message (D_ERROR, "yyparse (designator): REAL-Argument expected at Type Conversion Function");
							}
						} else if (ta.is_shortreal) {
							if (lookforgentypeart (pstblentry).is_byte) {
								message (D_ERROR, "yyparse (designator): INTEGER- or CARDINAL-Argument expected at Type Conversion Function");
							}
						} else {
							message (D_ERROR, "yyparse (designator): Invalid Argument Type at Type Conversion Function");
						}
					} else if (strcmp (yypvt[-4].s.val.ov, "float") == 0) {
						if (ta.is_byte == 0) {
							message (D_ERROR, "yyparse (designator): Float only with INTEGER- or CARDINAL-Argument allowed");
						}
						if ((pstblentry = symbtbllookupwithinidart ("shortreal", idart)) == NULL) {
							message (D_FATAL, "yyparse (designator): SHORTREAL-Type not found");
						}
					} else if (strcmp (yypvt[-4].s.val.ov, "trunc") == 0) {
						if (ta.is_shortreal == 0) {
							message (D_ERROR, "yyparse (designator): Trunc only with REAL-Argument allowed");
						}
						if ((pstblentry = symbtbllookupwithinidart ("byte", idart)) == NULL) {
							message (D_FATAL, "yyparse (designator): BYTE-Type not found");
						}
					} else if (strcmp (yypvt[-4].s.val.ov, "ord") == 0) {
						if (ta.is_boolean == 0 && ta.is_char == 0 && ta.is_enumeration == 0) {
							message (D_ERROR, "yyparse (designator): Ord only with Enumeration-Type-, BOOLEAN- or CHAR-Argument allowed");
						}
						if ((pstblentry = symbtbllookupwithinidart ("byte", idart)) == NULL) {
							message (D_FATAL, "yyparse (designator): BYTE-Type not found");
						}
					} else if (strcmp (yypvt[-4].s.val.ov, "chr") == 0) {
						if (ta.is_byte == 0 || ta.is_shortint || ta.is_shortcard) {
							message (D_ERROR, "yyparse (designator): Chr only with BYTE-Argument allowed");
						}
						if ((pstblentry = symbtbllookupwithinidart ("char", idart)) == NULL) {
							message (D_FATAL, "yyparse (designator): CHAR-Type not found");
						}
					} else if ((strcmp (yypvt[-4].s.val.ov, "dec") == 0) || (strcmp (yypvt[-4].s.val.ov, "inc") == 0)) {
						if (ta.is_char == 0 && ta.is_enumeration == 0 && ta.is_byte == 0) {
							message (D_ERROR, "yyparse (designator): Dec and Inc only with Enumeration-Type-, CHAR-, Integer od Cardinal-Argument allowed");
						}
						if (yypvt[-1].s.flag.is_lvalue == 0) {
							message (D_ERROR, "yyparse (designator): Dec- and Inc-Argument must be lvalue (no Constant or Procedurecall)");
						}
						if (yypvt[-1].s.val.pstbl) {
							if (yypvt[-1].s.val.pstbl->iart.is_for_parameter) {
								message (D_ERROR, "yyparse (designator): Argument is used in outer FOR-Statement");
							}
						}

						pstblentry = voidstblentry;

						c_exbuf (", ");
						c_exbuf_id (yypvt[-1].s.art.stbltyp);
					} else if ((strcmp (yypvt[-4].s.val.ov, "new") == 0) || (strcmp (yypvt[-4].s.val.ov, "dispose") == 0)) {
						if (ta.is_pointer == 0) {
							message (D_ERROR, "yyparse (designator): New and Dispose only with Pointer-Type-Argument allowed");
						} else {
							pstblentry = lookforgentype (yypvt[-1].s.art.stbltyp)->u.oftype->oftype;
							if (strcmp (pstblentry->id, "void") == 0) {
								message (D_ERROR, "yyparse (designator): New and Dispose not with untyped Pointer-Argument allowed");
							}
							if (strcmp (yypvt[-4].s.val.ov, "new") == 0) {
								c_exbuf (", sizeof (");
								c_exbuf_id (pstblentry);
								c_exbuf (")");
							}

							if ((pstblentry = symbtbllookupwithinidart ("void", idart)) == NULL) {
								message (D_FATAL, "yyparse (designator): Void-Type not found");
							}
						}
					} else {
						message (D_INTERNAL, "yyparse (designator): Unknown Conversion Function");
					}
					
					c_exbuf (")");

					yyval.s.art.stbltyp = yyval.s.val.pstbl = pstblentry;
					
					yyval.s.flag.is_const = 0;
					yyval.s.flag.is_lvalue = 0;
				} /*NOTREACHED*/ break;
case 203:
# line 1929 "../source/modula.yac"
{
					c_exbuf ("((");
					setidart (is_typeid);
					if ((pstblentry = symbtbllookupwithinidart (id_name, idart)) == NULL) {
						message (D_ERROR, "yyparse (designator): First VAL-Parameter is no Enumeration-Type-Identifier");
						YYERROR;
					}
					if (lookforgentypeart (pstblentry).is_enumeration == 0) {
						message (D_ERROR, "yyparse (designator): First VAL-Parameter is no Enumeration-Type-Identifier");
						YYERROR;
					}
					c_exbuf_id (pstblentry);
					c_exbuf (") ");

					put_expr_pos ();

					yyval.s.art.stbltyp = pstblentry;
				} /*NOTREACHED*/ break;
case 204:
# line 1949 "../source/modula.yac"
{
					get_expr_pos ();

					c_exbuf (")");

					if (lookforgentypeart (yypvt[-1].s.art.stbltyp).is_byte == 0) {
						message (D_ERROR, "yyparse (designator): Second VAL-Parameter is not of Type BYTE");
					}

					yyval.s.art.stbltyp = yyval.s.val.pstbl = yypvt[-3].s.art.stbltyp;
					
					yyval.s.flag.is_const = 0;
					yyval.s.flag.is_lvalue = 0;
				} /*NOTREACHED*/ break;
case 205:
# line 1964 "../source/modula.yac"
{
					yyval.s.flag = null_flag;
					yyval.s.flag.is_cond_or_sem_fn = 1;

					c_exbuf ("m0_status (");
				} /*NOTREACHED*/ break;
case 206:
# line 1971 "../source/modula.yac"
{
					BlockList	*bl;

					bl = blocklist->nextblocklist;
					if (moduletype == e_LOWMOD || bl->type != e_ENTRY) {
						message (D_ERROR, "yyparse (designator): Procedure STATUS only in Entry-Block allowed");
						YYERROR;
					}
					if (yypvt[-1].s.art.stbltyp->u.oftype->tart.is_condition == 0) {
						message (D_ERROR, "yyparse (designator): STATUS-Parameter is not of type CONDITION");
						YYERROR;
					}
					c_exbuf (")");

					setidart (is_typeid);
					if ((pstblentry = symbtbllookupwithinidart ("byte", idart)) == NULL) {
						message (D_FATAL, "yyparse (designator): BYTE-Type not found for STATUS");
					}

					yyval.s.art.stbltyp = yyval.s.val.pstbl = pstblentry;
					
					yyval.s.flag.is_const = 0;
					yyval.s.flag.is_lvalue = 0;
				} /*NOTREACHED*/ break;
case 207:
# line 1998 "../source/modula.yac"
{
					setidart (is_varid);
                                        if ((pstblentry = symbtbllookupwithinidart (id_name, idart)) == NULL) {
						message (D_ERROR, "yyparse (designator): Parameter '%s' of Procedure HIGH is not an Open Array Parameter", id_name_fuer_fehlertext);
                                                YYERROR;
                                        }

                                        if (pstblentry->iart.is_openarrayparam == 0) {
                                                message (D_ERROR, "yyparse (designator): HIGH-Parameter is not an Open Array Parameter");
                                                YYERROR;
                                        }
					c_exbuf ("high_%s", pstblentry->id);

                                        setidart (is_typeid);
                                        if ((pstblentry = symbtbllookupwithinidart ("byte", idart)) == NULL) {
                                                message (D_FATAL, "yyparse (designator): BYTE-Type not found for HIGH");
                                        }

                                        yyval.s.art.stbltyp = yyval.s.val.pstbl = pstblentry;

                                        yyval.s.flag.is_const = 0;
                                        yyval.s.flag.is_lvalue = 0;
                                } /*NOTREACHED*/ break;
case 208:
# line 2021 "../source/modula.yac"
{
					setidart (is_typeid);
					if ((pstblentry = symbtbllookupwithinidart ("integer", idart)) == NULL) {
						message (D_FATAL, "yyparse (designator): INTEGER-Type not found for PROCESSID");
					}

					c_exbuf ("m0_processid");

					yyval.s.art.stbltyp = yyval.s.val.pstbl = pstblentry;

					yyval.s.flag.is_const = 0;
					yyval.s.flag.is_lvalue = 0;
				} /*NOTREACHED*/ break;
case 209:
# line 2034 "../source/modula.yac"
{
					setidart (is_typeid);
					if ((pstblentry = symbtbllookupwithinidart ("integer", idart)) == NULL) {
						message (D_FATAL, "yyparse (designator): INTEGER-Type not found for PROCESSNO");
					}

					c_exbuf ("m0_processno");

					yyval.s.art.stbltyp = yyval.s.val.pstbl = pstblentry;

					yyval.s.flag.is_const = 0;
					yyval.s.flag.is_lvalue = 0;
				} /*NOTREACHED*/ break;
case 210:
# line 2047 "../source/modula.yac"
{
					setidart (is_typeid);
					if ((pstblentry = symbtbllookupwithinidart ("shortcard", idart)) == NULL) {
						message (D_FATAL, "yyparse (designator): SHORTCARD-Type not found for EXCEPTNO");
					}

					if (strcmp (blocklist->id, "Exception") != 0) {
						message (D_ERROR, "yyparse (designator): EXCEPTNO is forbidden outside of an Exception");
					}

					c_exbuf ("errno");

					yyval.s.art.stbltyp = yyval.s.val.pstbl = pstblentry;

					yyval.s.flag.is_const = 0;
					yyval.s.flag.is_lvalue = 0;
				} /*NOTREACHED*/ break;
case 217:
# line 2079 "../source/modula.yac"
{
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 218:
# line 2082 "../source/modula.yac"
{
					if (yypvt[-0].s.flag.is_lvalue == 0 && yypvt[-0].s.flag.is_const == 0) {
							/* Procedure, Entry, ... */
						if (yypvt[-0].s.val.pstbl->u.lv != 0L) {
							message (D_ERROR, "yyparse (.designatorexpr.): Count of Actual Parameters differs from Count of defined Formal-Parameters");
							YYERROR;
						}
						c_exbuf ("()");
					}
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 219:
# line 2095 "../source/modula.yac"
{
					if (yypvt[-1].s.flag.is_lvalue == 0 || yypvt[-1].s.flag.is_const) {
						message (D_ERROR, "yyparse (designatorexpr): Array-Identifier is invalid");
						YYERROR;
					}
					c_exbuf (".a [range_check ((long) ");
					yyval = yypvt[-1];
				} /*NOTREACHED*/ break;
case 220:
# line 2103 "../source/modula.yac"
{
					c_exbuf (", %d /*lineno*/", yylineno);
					c_exbuf (", \"%s\"", actual_filename);
					c_exbuf (")]");
				} /*NOTREACHED*/ break;
case 221:
# line 2108 "../source/modula.yac"
{
					yyval = yypvt[-2];
				} /*NOTREACHED*/ break;
case 222:
# line 2111 "../source/modula.yac"
{
					if (yypvt[-1].s.flag.is_lvalue == 0 || yypvt[-1].s.flag.is_const) {
						message (D_ERROR, "yyparse (designatorexpr): Record-Identifier is invalid");
						YYERROR;
					}
					if (! yypvt[-1].s.art.stbltyp->u.oftype->tart.is_record) {
						message (D_ERROR, "yyparse (designatorexpr): Not of a Record-Type");
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 223:
# line 2121 "../source/modula.yac"
{
					SymbTblEntry	*help;

					setidart (is_recordfieldid);
					idart.is_recordcaseid = 1;
					strcat (id_name, "_");
					if ((pstblentry = symbtbllookupwithinidart (id_name, idart)) == NULL) {
						message (D_ERROR, "yyparse (designatorexpr): Record-Field-Identifier '%s' not declared", id_name_fuer_fehlertext);
						YYERROR;
					}
					while (pstblentry) { /* while 1: Zutreffende Hashlist-Eintraege testen */
						help = yypvt[-3].s.art.stbltyp->u.oftype->indextype;
						while (help) { /* while 2: Record durchsuchen, ob richtiger Eintrag dabei */
							if (help == pstblentry) { /* Eintrag gefunden */
								break; /* while 2 */
							}
							help = help->u.nextfldorpar;
						} /* end while 2 */

						if (help == pstblentry) { /* Eintrag gefunden */
							break; /* while 1 */
						}

						do {		/* Hashlist durchsuchen nach weiterem zutreffendem Eintrag */
							pstblentry = pstblentry->next;
						} while (pstblentry && strcmp (pstblentry->id, id_name) && ! (pstblentry->iart.is_recordfieldid || pstblentry->iart.is_recordcaseid));
					} /* end while 1 */
					
					if (pstblentry == NULL) {
						message (D_ERROR, "yyparse (designatorexpr): Record-Field-Identifier '%s' not declared", id_name_fuer_fehlertext);
						YYERROR;
					}
					c_exbuf (".%s", pstblentry->id);
					yyval = yypvt[-3];
					yyval.s.art.stbltyp = yyval.s.val.pstbl = lookforgentype (pstblentry);
				} /*NOTREACHED*/ break;
case 224:
# line 2157 "../source/modula.yac"
{
					if (yypvt[-1].s.flag.is_lvalue == 0 || yypvt[-1].s.flag.is_const) {
						message (D_ERROR, "yyparse (designatorexpr): Pointer-Identifier is invalid");
						YYERROR;
					}
					if (! yypvt[-1].s.art.stbltyp->u.oftype->tart.is_pointer) {
						message (D_ERROR, "yyparse (designatorexpr): Not of a Pointer-Type");
						YYERROR;
					}
					insert_exbuf (show_expr_pos (), "(*");
					c_exbuf (")");

					yyval = yypvt[-1];
					yyval.s.art.stbltyp = yyval.s.val.pstbl = lookforgentype (yypvt[-1].s.art.stbltyp->u.oftype->oftype);

					if (strcmp (yyval.s.art.stbltyp->id, "void") == 0) {
						message (D_ERROR, "yyparse (designatorexpr): Pointer-Operator '^' not allowed with an untyped Pointer");
					}
				} /*NOTREACHED*/ break;
case 225:
# line 2179 "../source/modula.yac"
{
                                        c_exbuf (", %d /*lineno*/", yylineno);
					c_exbuf (", \"%s\"", actual_filename);
					c_exbuf (")].a [range_check ((long) ");
					yyval = yypvt[-1];
				} /*NOTREACHED*/ break;
case 226:
# line 2185 "../source/modula.yac"
{
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 228:
# line 2191 "../source/modula.yac"
{
					put_expr_pos ();
				} /*NOTREACHED*/ break;
case 229:
# line 2194 "../source/modula.yac"
{
					get_expr_pos ();

					if (! yypvt[-2].s.art.stbltyp->u.oftype->tart.is_array) {
						message (D_ERROR, "yyparse (desex): Not of an Array-Type");
						YYERROR;
					}
					
					ta = lookforgentypeart (yypvt[-0].s.art.stbltyp);

					if (! (ta.is_byte || ta.is_subrange || ta.is_enumeration)) {
						message (D_ERROR, "yyparse (desex): Array-Index of invalid Type");
						YYERROR;
					}

					if (yypvt[-0].s.flag.is_const) {
						long	lhelp;

						if (ta.is_char && ta.is_array) {
							message (D_ERROR, "yyparse (desex): Array-Index of Type STRING not allowed");
							YYERROR;
						}

						if (yypvt[-0].s.flag.is_expr) {
							lhelp = yypvt[-0].s.val.pstbl->u.lv;

							if (   (yypvt[-2].s.val.pstbl->iart.is_openarrayparam == 0)
							    && (   (lhelp < yypvt[-2].s.art.stbltyp->u.oftype->minval)
							        || (lhelp > yypvt[-2].s.art.stbltyp->u.oftype->maxval))) {
								message (D_ERROR, "yyparse (desex): Array-Index '%ld' out of range ('%ld', '%ld')", yypvt[-0].s.val.pstbl->u.lv, yypvt[-2].s.art.stbltyp->u.oftype->minval, yypvt[-2].s.art.stbltyp->u.oftype->maxval);
								YYERROR;
							}
						} else {
							if (ta.is_char) {
								lhelp = (long) yypvt[-0].s.val.pstbl->u.sv [0];
							} else {
								lhelp = yypvt[-0].s.val.lv;
							}

							if (   (yypvt[-2].s.val.pstbl->iart.is_openarrayparam == 0)
							    && (   (lhelp < yypvt[-2].s.art.stbltyp->u.oftype->minval)
							        || (lhelp > yypvt[-2].s.art.stbltyp->u.oftype->maxval))) {
								message (D_ERROR, "yyparse (desex): Array-Index '%ld' out of range ('%ld', '%ld')", yypvt[-0].s.val.lv, yypvt[-2].s.art.stbltyp->u.oftype->minval, yypvt[-2].s.art.stbltyp->u.oftype->maxval);
								YYERROR;
							}
						}
					}

					if (maxtype (yypvt[-2].s.art.stbltyp->u.oftype->indextype, yypvt[-0].s.art.stbltyp) == NULL) {
						message (D_ERROR, "yyparse (desex): Array-Index of invalid Type");
						YYERROR;
					}

					if (yypvt[-2].s.val.pstbl->iart.is_openarrayparam) {
						c_exbuf (", 0L, high_%s", yypvt[-2].s.val.pstbl->id);
					} else {
						c_exbuf (", 0x%lXL /*Dec. %ld*/", yypvt[-2].s.art.stbltyp->u.oftype->minval, yypvt[-2].s.art.stbltyp->u.oftype->minval);
						c_exbuf (", 0x%lXL /*Dec. %ld*/", yypvt[-2].s.art.stbltyp->u.oftype->maxval, yypvt[-2].s.art.stbltyp->u.oftype->maxval);
					}

					yyval = yypvt[-2];
					yyval.s.art.stbltyp = yyval.s.val.pstbl = lookforgentype (yypvt[-2].s.art.stbltyp->u.oftype->oftype);
				} /*NOTREACHED*/ break;
case 230:
# line 2260 "../source/modula.yac"
{
					if (yypvt[-1].s.flag.is_lvalue || yypvt[-1].s.flag.is_const) {
						message (D_ERROR, "yyparse (actualparams): Procedure-Identifier is invalid");
						YYERROR;
					}

					if (yypvt[-1].s.val.pstbl->iart.is_monitorid) {
						message (D_ERROR, "yyparse (actualparams): Monitor-Identifier cannot be used like Procedure-Identifier");
						YYERROR;
					}

					c_exbuf ("(");

					yyval = yypvt[-1];
				} /*NOTREACHED*/ break;
case 231:
# line 2275 "../source/modula.yac"
{
					if (yypvt[-0].s.flag.is_error == 0) {
						if (yypvt[-0].s.val.pstbl->u.nextfldorpar != NULL) {
							message (D_ERROR, "yyparse (actualparams): Count of Actual Parameters is less than Count of defined Formal-Parameters");
							YYERROR;
						}
					}


					if (yypvt[-5].s.flag.is_communicationcall) {
						c_exbuf (", c_%s, \"%s\"", yypvt[-5].s.val.pstbl->id, yypvt[-5].s.val.pstbl->id);
					}

					c_exbuf (")");

					yyval = yypvt[-3];
					yyval.s.art.stbltyp = lookforgentype (yypvt[-3].s.val.pstbl);
				} /*NOTREACHED*/ break;
case 232:
# line 2296 "../source/modula.yac"
{
					yyval = yypvt[-1];
					yyval.s.flag.is_error = 0;
				} /*NOTREACHED*/ break;
case 233:
# line 2301 "../source/modula.yac"
{
					yyval.s.flag.is_error = 1;
				} /*NOTREACHED*/ break;
case 234:
# line 2307 "../source/modula.yac"
{
					yyval = yypvt[-1]; /* wegen Parameter-Liste */
					c_exbuf (", ");
				} /*NOTREACHED*/ break;
case 235:
# line 2311 "../source/modula.yac"
{
					yyval = yypvt[-0]; /* wegen Parameter-Liste */
				} /*NOTREACHED*/ break;
case 237:
# line 2317 "../source/modula.yac"
{
					yyval = yypvt[-0];
					yyval.s.val.sv = expression_buffer + strlen (expression_buffer);

					put_expr_pos ();
				} /*NOTREACHED*/ break;
case 238:
# line 2323 "../source/modula.yac"
{
					Types	*t1;
					char	*pos;

					get_expr_pos ();

					pos = yypvt[-1].s.val.sv;

					yyval = yypvt[-2];
					if ((yyval.s.val.pstbl = pstblentry = yypvt[-2].s.val.pstbl->u.nextfldorpar) == NULL) {
						message (D_ERROR, "yyparse (actexp): Count of Actual Parameters is higher than Count of defined Formal-Parameters");
						YYERROR;
					}
					t1 = (yyval.s.art.stbltyp = lookforgentype (pstblentry))->u.oftype;

							/* Typecheck */
					ta2 = lookforgentypeart (yypvt[-0].s.art.stbltyp);
					if ((pstblentry->iart.is_openarrayparam || t1->tart.is_array) && t1->oftype->u.oftype->tart.is_char) {
									/* String */
						if (yypvt[-0].s.flag.is_const) {
									/* Konstante */
							if (ta2.is_char) {
								if (! ta2.is_array) {
									insert_exbuf (pos, "mk_str (");
									c_exbuf (")");
								}
							}

							if (! pstblentry->iart.is_callbyreference) {
								if (pstblentry->iart.is_openarrayparam) {
									insert_exbuf (pos, "str_save (");
									if (ta2.is_array) {
										c_exbuf (", %d), %d", strlen (yypvt[-0].s.val.pstbl->u.sv), strlen (yypvt[-0].s.val.pstbl->u.sv));
									} else {
										c_exbuf (", 1), 1");
									}
								} else {
										/* insert erfolgt nach rechts, daher
										 * umgekehrte Reihenfolge beibehalten */
									insert_exbuf (pos, "*) str_save (");
									if (pstblentry->ofstblentry->status.is_external) {
										insert_exbuf (pos, "m0_%s ", pstblentry->ofstblentry->id);
									} else {
										insert_exbuf (pos, "m%d_%s ", pstblentry->ofstblentry->ofblock->nr, pstblentry->ofstblentry->id);
									}
									insert_exbuf (pos, "* (");
									c_exbuf (", sizeof (");
									c_exbuf_id (pstblentry->ofstblentry);
									c_exbuf (") - 1)");
								}
								
									/* fuer Untenstehenden Typ-Check */
								yypvt[-0].s.art.stbltyp = pstblentry;
							}
						}
					}
					
					if (pstblentry->iart.is_callbyreference) {
						if (yypvt[-0].s.flag.is_lvalue) {
								/* Es ist eine Variable */
							insert_exbuf (pos, "&");
							
							if (moduletype == e_LOWMOD) {
								if (yypvt[-0].s.val.pstbl->ofblock->nr == 1) {
										/* globale Lowlevel-Variable */
									message (D_ERROR, "yyparse (actexp): Call-By-Reference-Parameter must not be a global declared variable of a lowlevel module");
								}
							}
						} else {
								/* Procedurecall bzw. Konstante wird abgelehnt */
							message (D_ERROR, "yyparse (actexp): Parameter must be an lvalue");
							YYERROR;
						}
					}

					if (pstblentry->iart.is_openarrayparam) {
							/* Open Array */
						if (! (t1->oftype->u.oftype->tart.is_char && yypvt[-0].s.flag.is_const)) {
								/* fuer konstante Strings bereits erledigt (s.o.) */
							SymbTblEntry	*t;
							t = lookforgentype (yypvt[-0].s.art.stbltyp);
							if (t->u.oftype->tart.is_array) {
								if (maxtype (t1->oftype, lookforgentype (yypvt[-0].s.art.stbltyp)->u.oftype->oftype) == NULL) {
									message (D_ERROR, "yyparse (actexp): Invalid Parameter-Type");
									YYERROR;
								} else {
									if (! pstblentry->iart.is_callbyreference) {
										insert_exbuf (pos, "mem_save ((char *) &");
										c_exbuf (", sizeof (");
										if (yypvt[-0].s.art.stbltyp->iart.is_openarrayparam) {
											c_exbuf_id (lookforgentype (yypvt[-0].s.art.stbltyp)->u.oftype->oftype);
											c_exbuf (")*");
												/* $2.s.val.pstbl nur garantiert bei Open Array vorhanden,
												 * da diese immer eindimensional sein muessen */
											c_exbuf ("high_%s)", yypvt[-0].s.val.pstbl->id);
										} else {
											c_exbuf_id (t);
											c_exbuf ("))");
										}
									}
									if (yypvt[-0].s.art.stbltyp->iart.is_openarrayparam) {
											/* $2.s.val.pstbl nur garantiert bei Open Array vorhanden,
											 * da diese immer eindimensional sein muessen */
										c_exbuf (", high_%s", yypvt[-0].s.val.pstbl->id);
									} else {
										c_exbuf (", %ld", t->u.oftype->maxval - t->u.oftype->minval);
									}
								}
							} else {
								message (D_ERROR, "yyparse (actexp): ARRAY-Type required");
								YYERROR;
							}
						}
					} else if (pstblentry != maxtype (pstblentry, yypvt[-0].s.art.stbltyp)) {
						message (D_ERROR, "yyparse (actexp): Invalid Parameter-Type");
						YYERROR;
					}
					
				} /*NOTREACHED*/ break;
case 239:
# line 2445 "../source/modula.yac"
{
					c_out_lf ();
					c_out_linebegin ("if (");
				} /*NOTREACHED*/ break;
case 240:
# line 2450 "../source/modula.yac"
{
					tabcnt--;
					c_out_lf ();
					c_out_linebegin ("} else {");
					tabcnt++;
				} /*NOTREACHED*/ break;
case 241:
# line 2456 "../source/modula.yac"
{
					tabcnt--;
					c_out_lf ();
					c_out_linebegin ("}");
				} /*NOTREACHED*/ break;
case 243:
# line 2464 "../source/modula.yac"
{
					clr_exbuf ();
				} /*NOTREACHED*/ break;
case 244:
# line 2467 "../source/modula.yac"
{
							/* Check for Boolean */
					if (lookforgentypeart (yypvt[-0].s.art.stbltyp).is_boolean) {
						c_out_exbuf ();
						c_out (") {");
						tabcnt++;
					} else {
						message (D_ERROR, "yyparse (exthenstat): Expression is not of type BOOLEAN");
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 245:
# line 2478 "../source/modula.yac"
{
					yyval.s.flag = null_flag;
				} /*NOTREACHED*/ break;
case 247:
# line 2483 "../source/modula.yac"
{
					yyerrok;
					yyval.s.flag = null_flag;
					clr_exbuf ();
				} /*NOTREACHED*/ break;
case 249:
# line 2492 "../source/modula.yac"
{
					tabcnt--;
					c_out_lf ();
					c_out_linebegin ("} else if (");
				} /*NOTREACHED*/ break;
case 252:
# line 2501 "../source/modula.yac"
{
					yyval.s.flag = null_flag;
				} /*NOTREACHED*/ break;
case 255:
# line 2508 "../source/modula.yac"
{
					c_out_lf ();
					c_out_linebegin ("while (");
					clr_exbuf ();
				} /*NOTREACHED*/ break;
case 256:
# line 2513 "../source/modula.yac"
{
							/* Check for Boolean */
					if (lookforgentypeart (yypvt[-0].s.art.stbltyp).is_boolean) {
						c_out_exbuf ();
						c_out (") {");
						tabcnt++;
					} else {
						message (D_ERROR, "yyparse (whilestat): Expression is not of type BOOLEAN");
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 257:
# line 2524 "../source/modula.yac"
{
					yyval.s.flag = null_flag;
				} /*NOTREACHED*/ break;
case 258:
# line 2527 "../source/modula.yac"
{
					tabcnt--;
					c_out_lf ();
					c_out_linebegin ("}");
				} /*NOTREACHED*/ break;
case 259:
# line 2535 "../source/modula.yac"
{
					c_out_lf ();
					c_out_linebegin ("do {");
					tabcnt++;
					yyval.s.flag = null_flag;
				} /*NOTREACHED*/ break;
case 260:
# line 2542 "../source/modula.yac"
{
					tabcnt--;
					c_out_lf ();
					c_out_linebegin ("} while ( ! (");
				} /*NOTREACHED*/ break;
case 262:
# line 2549 "../source/modula.yac"
{
					yyerrok;
					tabcnt--;
					c_out_lf ();
					c_out_linebegin ("} while ( ! (");
				} /*NOTREACHED*/ break;
case 264:
# line 2558 "../source/modula.yac"
{
					clr_exbuf ();
				} /*NOTREACHED*/ break;
case 265:
# line 2561 "../source/modula.yac"
{
							/* Check for Boolean */
					if (lookforgentypeart (yypvt[-0].s.art.stbltyp).is_boolean) {
						c_out_exbuf ();
						c_out ("));");
					} else {
						message (D_ERROR, "yyparse (repexpr): Expression is not of type BOOLEAN");
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 266:
# line 2574 "../source/modula.yac"
{
					loop_stack (1);
					yyval.s.flag = null_flag;
				} /*NOTREACHED*/ break;
case 267:
# line 2579 "../source/modula.yac"
{
					loop_stack (-1);
				} /*NOTREACHED*/ break;
case 268:
# line 2584 "../source/modula.yac"
{
					c_out_lf ();
					c_out ("#define for_variable ");
					yyval.s.flag = null_flag;
					yyval.s.flag.is_for_assignment = 1;

					clr_exbuf ();
				} /*NOTREACHED*/ break;
case 269:
# line 2592 "../source/modula.yac"
{
					ta = lookforgentypeart (yypvt[-0].s.art.stbltyp);
					if ( ! (ta.is_byte || ta.is_enumeration || (ta.is_char && ! ta.is_array) || ta.is_subrange)) {
						message (D_ERROR, "yyparse (forstat): FOR-Variable-Identifier is of an invalid Type");
						YYERROR;
					}
					c_out (" ");
					yypvt[-0].s.val.pstbl->iart.is_for_parameter = 1;
					yyval = yypvt[-0];

					clr_exbuf ();
				} /*NOTREACHED*/ break;
case 270:
# line 2605 "../source/modula.yac"
{
					ta = lookforgentypeart (yypvt[-0].s.art.stbltyp);

					if (yypvt[-2].s.art.stbltyp != maxtype (yypvt[-2].s.art.stbltyp, yypvt[-0].s.art.stbltyp)) {
						message (D_ERROR, "yyparse (forstat): Incompatible Types at TO-Expression");
						YYERROR;
					}
					c_out_exbuf ();
					yyval = yypvt[-3];
				} /*NOTREACHED*/ break;
case 271:
# line 2616 "../source/modula.yac"
{
					Types	*t1;

					t1 = yypvt[-6].s.art.stbltyp->u.oftype;

					if (t1->tart.is_subrange && ! yypvt[-6].s.art.stbltyp->status.is_predeclared) {
							/* range check; nicht bei BYTE und CHAR */
						c_out_lf ();
						c_out_linebegin ("range_check ((long) for_variable, 0x%lXL /*Dec. %ld*/", t1->minval, t1->minval);
						c_out (", 0x%lXL /*Dec. %ld*/", t1->maxval, t1->maxval);
						c_out (", %d /*lineno*/", yylineno);
						c_out (", \"%s\"", actual_filename);
						c_out ("); /* range_check with for_variable */");
					}

					c_out_lf ();
					c_out ("#undef for_variable");
					yyval.s.flag = null_flag;
				} /*NOTREACHED*/ break;
case 272:
# line 2635 "../source/modula.yac"
{
					yypvt[-7].s.val.pstbl->iart.is_for_parameter = 0;
					tabcnt--;
					c_out_lf ();
					c_out_linebegin ("}");
				} /*NOTREACHED*/ break;
case 273:
# line 2645 "../source/modula.yac"
{
					ta = lookforgentypeart (yypvt[-2].s.val.pstbl);
					if (! ta.is_byte) {
						message (D_ERROR, "yyparse (_byexpr_): BY-Constant-Expression only with FOR-Variables of Integer- or Cardinal-Type");
						YYERROR;
					}

					if (yypvt[-0].s.art.stbltyp->u.oftype->tart.is_byte) {
						if (negative_stbltyp (yypvt[-0].s.art.stbltyp)) {
								/* Dekrement! */
							c_out (" <= ");
								
						} else {
								/* Inkrement! */
							c_out (" >= ");
						}
						c_out ("for_variable ; for_variable += ");
						c_out ("%ld) {", yypvt[-0].s.val.lv);
						tabcnt++;
					} else {
						message (D_ERROR, "yyparse (_byexpr_): Increment Expression is not valid");
						yypvt[-2].s.val.pstbl->iart.is_for_parameter = 0;
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 274:
# line 2670 "../source/modula.yac"
{
					c_out (" >= for_variable ; ");
					ta = lookforgentypeart (yypvt[-0].s.val.pstbl);
					if (ta.is_enumeration) {
							/* enumeration */
						c_out ("m0_inc (for_variable, ");
						c_out_id (lookforgentype (yypvt[-0].s.val.pstbl));
						c_out (")) {");
					} else {
							/* char oder byte */
						c_out ("for_variable++) {");
					}
					tabcnt++;
				} /*NOTREACHED*/ break;
case 275:
# line 2686 "../source/modula.yac"
{
					c_out_lf ();
					c_out_linebegin ("switch (");

					clr_exbuf ();
				} /*NOTREACHED*/ break;
case 276:
# line 2693 "../source/modula.yac"
{
					ta = lookforgentypeart (yypvt[-1].s.art.stbltyp);
					
					if ( ! (ta.is_byte || ta.is_enumeration || ta.is_subrange || (ta.is_char && ! ta.is_array))) {
						message (D_ERROR, "yyparse (casestat): CASE-Expression must be of an Char-, Enumeration-, Subrange-, Integer- or Cardinal-Type");
						YYERROR;
					}
					c_out_exbuf ();
					c_out (") {");
					tabcnt++;
					yyval = yypvt[-1];
				} /*NOTREACHED*/ break;
case 277:
# line 2705 "../source/modula.yac"
{
					c_out_lf ();
					c_out_linebegin ("break; ");
					tabcnt--;
					c_out_lf ();
					c_out_linebegin ("default: ");
					tabcnt++;
				} /*NOTREACHED*/ break;
case 278:
# line 2714 "../source/modula.yac"
{
					c_out_lf ();
					c_out_linebegin ("break; ");
					tabcnt--;
					c_out_lf ();
					c_out_linebegin ("} ");
				} /*NOTREACHED*/ break;
case 279:
# line 2724 "../source/modula.yac"
{
					c_out_lf ();
					c_out_linebegin ("break; ");
					yyval = yypvt[-2];
				} /*NOTREACHED*/ break;
case 282:
# line 2732 "../source/modula.yac"
{
					yyerrok;
					clr_exbuf ();
					c_out_lf ();
					c_out_linebegin ("break; ");
				} /*NOTREACHED*/ break;
case 283:
# line 2739 "../source/modula.yac"
{
					yyerrok;
					clr_exbuf ();
					yyval.s.flag = null_flag;
				} /*NOTREACHED*/ break;
case 285:
# line 2746 "../source/modula.yac"
{
					yyerrok;
					clr_exbuf ();
					yyval.s.flag = null_flag;
				} /*NOTREACHED*/ break;
case 287:
# line 2753 "../source/modula.yac"
{
					c_out_lf ();
					c_out_linebegin ("break; ");
					tabcnt--;
					c_out_lf ();
					c_out_linebegin ("default: /* within error-recovery (standard-default comes too (see later)) */");
					tabcnt++;
					yyerrok;
					clr_exbuf ();
					yyval.s.flag = null_flag;
				} /*NOTREACHED*/ break;
case 289:
# line 2767 "../source/modula.yac"
{
					if (yypvt[-1].s.art.stbltyp != maxtype (yypvt[-1].s.art.stbltyp, yypvt[-0].s.art.stbltyp)) {
						message (D_ERROR, "yyparse (case): Type in CASE-List incompatible with Type in CASE-Expression");
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 290:
# line 2773 "../source/modula.yac"
{
					yyval.s.flag = null_flag;
				} /*NOTREACHED*/ break;
case 292:
# line 2781 "../source/modula.yac"
{
					if (yypvt[-0].s.art.stbltyp != maxtype (yypvt[-0].s.art.stbltyp, yypvt[-2].s.art.stbltyp)) {
						message (D_ERROR, "yyparse (caselabellist): Incompatible Types in CASE-List");
						YYERROR;
					}
					yyval = yypvt[-2];
				} /*NOTREACHED*/ break;
case 294:
# line 2791 "../source/modula.yac"
{
					ta = yypvt[-0].s.art.stbltyp->u.oftype->tart;
					tabcnt--;
					c_out_lf ();
					if (ta.is_byte || ta.is_enumeration || ta.is_subrange) {
						c_out_linebegin ("case 0x%lX:/*Dec. %ld*/", yypvt[-0].s.val.lv, yypvt[-0].s.val.lv);
					} else if (ta.is_char && !ta.is_array) {
						c_out_linebegin ("case '%c':", ((char) yypvt[-0].s.val.lv));
					} else {
						message (D_ERROR, "yyparse (caselabel): CASE-Label-Expression must be of an Char-, Enumeration-, Integer- or Cardinal-Type");
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 295:
# line 2804 "../source/modula.yac"
{
					tabcnt++;
					yyval = yypvt[-2];
				} /*NOTREACHED*/ break;
case 296:
# line 2811 "../source/modula.yac"
{
					if (yypvt[-0].s.art.stbltyp != mintype (yypvt[-3].s.art.stbltyp, yypvt[-0].s.art.stbltyp)) {
						message (D_ERROR, "yyparse (_toconstantexpr_): Incompatible Types at '..'");
						YYERROR;
					}

					ta = yypvt[-0].s.art.stbltyp->u.oftype->tart;
					if (ta.is_byte || ta.is_enumeration || ta.is_subrange || (ta.is_char && !ta.is_array)) {
						if (ta.is_longcard) {
							if ((unsigned long) yypvt[-3].s.val.lv >= (unsigned long) yypvt[-0].s.val.lv) {
								message (D_ERROR, "yyparse (_toconstantexpr_): Constant after '..' must be greater than constant before");
								YYERROR;
							}
							for ( ; (unsigned long) ++yypvt[-3].s.val.lv <= (unsigned long) yypvt[-0].s.val.lv; ) {
								c_out_lf ();
								c_out_linebegin ("case 0x%lX:/*Dec. %lu*/", yypvt[-0].s.val.lv, ((unsigned long) yypvt[-0].s.val.lv));
							}
						} else {
							if (yypvt[-3].s.val.lv >= yypvt[-0].s.val.lv) {
								message (D_ERROR, "yyparse (_toconstantexpr_): Constant after '..' must be greater than constant before");
								YYERROR;
							}
							for ( ; ++yypvt[-3].s.val.lv <= yypvt[-0].s.val.lv; ) {
								c_out_lf ();
								if (ta.is_char && !ta.is_array) {
									c_out_linebegin ("case '%c':", ((char) yypvt[-3].s.val.lv));
								} else {
									c_out_linebegin ("case 0x%lX:/*Dec. %ld*/", yypvt[-3].s.val.lv, yypvt[-3].s.val.lv);
								}
							}
						}
					} else {
						message (D_ERROR, "yyparse (_toconstantexpr_): CASE-Label-Expression must be of an Char-, Enumeration-, Integer- or Cardinal-Type");
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 298:
# line 2853 "../source/modula.yac"
{
					yyval.s.flag = null_flag;
				} /*NOTREACHED*/ break;
case 300:
# line 2860 "../source/modula.yac"
{
					/* $0.s.flag is set to null_flag, because of
					 * procedurecall is only called in statement,
					 * statement is only called in statlist,
					 * statlist is only called in statlist or statend,
					 * and every statlist- or statend-call preceedes a
					 * statement '$$.s.flag = null_flag;'.
					 */

					/* Handelt es sich beim designator um einen
					 * entrycall oder einen commcall, so wird
					 * procedurecall rekursiv aufgerufen und
					 * beim endgueltigen Verlassen des designators
					 * im Folgenden dann die Ausgabe erzeugt
					 */

					/* Beim procedure_call muss der
					 * Designator den Typ void haben */

					if (   (procedure_call.is_entryid == 0 /* kein entry */)
					    && (procedure_call.is_communicationid == 0 /* keine communication */)) {

						/* reiner Prozedur-Call als
						 * Statement oder Prozess-Call
						 * beim START muss vom Typ void
						 * sein; die Prozedur-Calls
						 * innerhalb von Expressions
						 * werden als Designator
						 * behandelt */
						if (procedure_call.is_processid && yypvt[-1].s.flag.is_restartofprocess == 0 /* kein restart */) {
								/* fuer PROCESSNO */
							c_out_lf ();
							c_out_linebegin ("m0_processno = inc_processno_activ_exception (\"%s\");\n", yypvt[-0].s.val.pstbl->id);
						}
						if (lookforgentypeart (yypvt[-0].s.val.pstbl).is_void == 0) {
							message (D_ERROR, "yyparse (procedurecall): Procedure-Call as single Statement only with Procedure-Type void allowed");
						}
						c_out_lf ();
						c_out_linebegin ("");
						c_out_exbuf ();
						c_out (";");
					}
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 301:
# line 2909 "../source/modula.yac"
{
					setidart (is_constid);
					if ((pstblentry = symbtbllookupwithinidart (id_name, idart)) == NULL) {
						message (D_ERROR, "yyparse (commcall): Computer-Identifier '%s' not found", id_name_fuer_fehlertext);
					} else if (lookforgentypeart (pstblentry).is_computer == 0) {
						message (D_ERROR, "yyparse (commcall): Identifier '%s' is not of type COMPUTER", id_name_fuer_fehlertext);
					}

					yyval = yypvt[-3];
					yyval.s.val.pstbl = pstblentry;

					procedure_call.is_procedureid = 0;
					procedure_call.is_communicationid = 1;
					yyval.s.flag = null_flag;
					yyval.s.flag.is_communicationcall = 1;
				} /*NOTREACHED*/ break;
case 302:
# line 2925 "../source/modula.yac"
{
					procedure_call.is_procedureid = 1;
					procedure_call.is_communicationid = 0;

					if (yypvt[-5].s.flag.is_expr == 0) {
						/* alleiniges Statement
						 * Typ muss void sein */
						if (lookforgentypeart (yypvt[-0].s.val.pstbl).is_void == 0) {
							message (D_ERROR, "yyparse (commcall): Communication-Call as single Statement only with Entry-Type void allowed");
						}
					}
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 303:
# line 2941 "../source/modula.yac"
{
					if (! yypvt[-1].s.val.pstbl->iart.is_monitorid) {
						message (D_ERROR, "yyparse (entrycall): Monitor-Identifier invalid");
						YYERROR;
					}
					yyval = yypvt[-1];

					procedure_call.is_procedureid = 0;
					procedure_call.is_entryid = 1;
					yyval.s.flag = null_flag;
					yyval.s.flag.is_entrycall = 1;
				} /*NOTREACHED*/ break;
case 304:
# line 2953 "../source/modula.yac"
{
					procedure_call.is_procedureid = 1;
					procedure_call.is_entryid = 0;

					if (yypvt[-5].s.flag.is_expr == 0) {
						/* alleiniges Statement
						 * Typ muss void sein */
						if (lookforgentypeart (yypvt[-0].s.val.pstbl).is_void == 0) {
							message (D_ERROR, "yyparse (entrycall): Entry-Call as single Statement only with Entry-Type void allowed");
						}
					}
					if (yypvt[-0].s.val.pstbl->ofblock->id != yypvt[-1].s.val.pstbl->id) {
							message (D_ERROR, "yyparse (entrycall): Entry belongs to Monitor '%s' instead of Monitor '%s'",
								 yypvt[-0].s.val.pstbl->ofblock->id, yypvt[-1].s.val.pstbl->id);
					}
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 305:
# line 2974 "../source/modula.yac"
{
					procedure_call.is_procedureid = 0;
					procedure_call.is_entryid = 1;
					yyval.s.flag = null_flag;
					yyval.s.flag.is_entrycall = 1;
				} /*NOTREACHED*/ break;
case 306:
# line 2980 "../source/modula.yac"
{
					procedure_call.is_procedureid = 1;
					procedure_call.is_entryid = 0;

					if (yypvt[-4].s.flag.is_expr == 0) {
						/* alleiniges Statement
						 * Typ muss void sein */
						if (lookforgentypeart (yypvt[-0].s.val.pstbl).is_void == 0) {
							message (D_ERROR, "yyparse (entrycalloldver): Entry-Call as single Statement only with Entry-Type void allowed");
						}
					}
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 307:
# line 2996 "../source/modula.yac"
{
					c_out_lf ();
					c_out_linebegin ("sig_ign (); /* DISABLE */");
					yyval.s.flag = null_flag;
					yyval.s.flag.is_disenableblock = 1;
				} /*NOTREACHED*/ break;
case 308:
# line 3003 "../source/modula.yac"
{
					c_out_lf ();
					c_out_linebegin ("sig_set (); /* ENABLE */");
					yyval.s.flag = null_flag;
				} /*NOTREACHED*/ break;
case 309:
# line 3009 "../source/modula.yac"
{
					yyerrok;
					message (D_ERROR, "yyparse (disenable): Within a DISABLE-ENABLE-block only assignments are allowed");
					c_out_lf ();
					c_out_linebegin ("sig_set (); /* ENABLE WITH ERROR */");
					yyval.s.flag = null_flag;
				} /*NOTREACHED*/ break;
case 310:
# line 3019 "../source/modula.yac"
{
					yyval.s.flag = yypvt[-2].s.flag;
				} /*NOTREACHED*/ break;
case 316:
# line 3031 "../source/modula.yac"
{
					if (! (phead->iart.is_communicationid || phead->iart.is_entryid || phead->iart.is_procedureid)) {
						message (D_ERROR, "yyparse (returnstat): RETURN-Statement only in COMMUNICATION, ENTRY or PROCEDURE allowed");
						YYERROR;
					}

					blocklist->retcount++;
					clr_exbuf ();
					c_exbuf ("retval =  "); /* Unbedingt zwei Blanks nach dem '=' lassen (s. ca. 10 Zeilen tiefer) */
					put_expr_pos ();
				} /*NOTREACHED*/ break;
case 317:
# line 3042 "../source/modula.yac"
{
					Types	*t1;
					char	*pc;

					get_expr_pos ();
					
					t1 = lookforgentype (phead)->u.oftype;

					/* siehe selbiges auch beim assignment */
							/* Typecheck */
					ta2 = lookforgentypeart (yypvt[-0].s.art.stbltyp);

					if (t1->tart.is_array && t1->oftype->u.oftype->tart.is_char && ta2.is_char) {
									/* return (Char || String) */
						if (! ta2.is_array) {
							get_expr_pos ();
							insert_exbuf (get_expr_pos (), "mk_str (");
							c_exbuf (")");
						}
						pc = strchr (expression_buffer, '=');

						pc [0] = '.';
						pc [1] = 'a';
						pc [2] = ',';
	
						c_out ("strncpy (");
						c_out_exbuf ();
						c_out (", sizeof (retval) - 1)");
					} else if (phead->ofstblentry != maxtype (phead->ofstblentry, yypvt[-0].s.art.stbltyp)) {
						message (D_ERROR, "yyparse (returnstat): Incompatible Type of RETURN-Expression");
						YYERROR;
					}
					
					c_out_exbuf ();
					c_out (";");
					c_out_lf ();
					c_out_linebegin ("goto ret;");
				} /*NOTREACHED*/ break;
case 318:
# line 3080 "../source/modula.yac"
{
					if (! (phead->iart.is_communicationid || phead->iart.is_entryid || phead->iart.is_procedureid)) {
						message (D_ERROR, "yyparse (returnstat): RETURN-Statement only in COMMUNICATION, ENTRY or PROCEDURE allowed");
						YYERROR;
					}

					blocklist->retcount++;

					if (lookforgentypeart (phead).is_void == 0) {
						message (D_ERROR, "yyparse (returnstat): RETURN-Expression missing");
						YYERROR;
					}

					c_out_lf ();
					c_out_linebegin ("goto ret;");
				} /*NOTREACHED*/ break;
case 322:
# line 3107 "../source/modula.yac"
{
						/*  wegen error-recovery */
					yyval.s.art.blcktyp = e_PROCEDURE;
					yyval.s.val.pstbl = voidstblentry;
				} /*NOTREACHED*/ break;
case 323:
# line 3112 "../source/modula.yac"
{
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 324:
# line 3117 "../source/modula.yac"
{
					blocktype = e_PROCEDURE;
					setidart (is_procedureid);
					if ((pstblentry = symbtbllookupwithinidart (id_name, idart)) == NULL) {
						pstblentry = symbtbladd (id_name);
						pstblentry->iart.is_procedureid = 1;
						if (export) {
							pstblentry->status.is_external = 1;
						} else {
							pstblentry->status.is_defined = 1;
						}
						pstblentry->ofstblentry = voidstblentry; /* Default */
						yyval.s.flag.is_alreadydefined = 0;
						newblocklist (pstblentry->id);
					} else {
						if (pstblentry->status.is_defined) {
							message (D_ERROR, "yyparse (restofprocedhd): Procedure already defined");
						}
						setactualblock (blocktype, pstblentry->id);
						pstblentry->status.is_defined = 1;
						yyval.s.flag.is_alreadydefined = 1;
					}
					staticlevel = blocklist->nr;
							/* $0 wird wegen der error-recovery gesetzt */
					yyval.s.art.blcktyp = yypvt[-1].s.art.blcktyp = e_PROCEDURE;
					yyval.s.val.pstbl = yypvt[-1].s.val.pstbl = pstblentry;
				} /*NOTREACHED*/ break;
case 325:
# line 3145 "../source/modula.yac"
{
					staticlevel = yypvt[-2].s.val.pstbl->ofblock->nr;
					yyval = yypvt[-2];
					yyval.s.flag.is_error = 0;
				} /*NOTREACHED*/ break;
case 326:
# line 3151 "../source/modula.yac"
{
							/* $0 wurde wegen der error-recovery gesetzt;
							 * einmal in ...head und einmal weiter oben
							 * in dieser Regel */
					yyval = yypvt[-2];
					yyval.s.flag.is_error = 1;
				} /*NOTREACHED*/ break;
case 328:
# line 3162 "../source/modula.yac"
{
					message (D_ERROR, "yyparse (semicolextforw): Head of Procedure must be separated from 'EXTERNAL' with a semicolon");
					YYERROR;
				} /*NOTREACHED*/ break;
case 329:
# line 3166 "../source/modula.yac"
{
					message (D_ERROR, "yyparse (semicolextforw): Head of Procedure must be separated from 'FORWARD' with a semicolon");
					YYERROR;
				} /*NOTREACHED*/ break;
case 330:
# line 3172 "../source/modula.yac"
{
					staticlevel = blocklist->nr;
					setactualblock (e_PROCEDURE, yypvt[-0].s.val.pstbl->id);
					blocktype = e_BODY;
					newblocklist (yypvt[-0].s.val.pstbl->id);
					yyval.s.val.lv = (long) staticlevel;
				} /*NOTREACHED*/ break;
case 331:
# line 3180 "../source/modula.yac"
{
					staticlevel = (int) yypvt[-2].s.val.lv;
					setactualblock (e_PROCEDURE, yypvt[-3].s.val.pstbl->id);
					setactualblock (e_BODY, yypvt[-3].s.val.pstbl->id);
					yyval = yypvt[-3];
				} /*NOTREACHED*/ break;
case 332:
# line 3188 "../source/modula.yac"
{
					setidart (is_procedureid);
					if ((pstblentry = symbtbllookupwithinidart (id_name, idart)) == NULL) {
						message (D_ERROR, "yyparse (procedurebody): Procedure-Identifier '%s' not declared", id_name_fuer_fehlertext);
					}
					if (pstblentry != yypvt[-7].s.val.pstbl) {
						message (D_ERROR, "yyparse (procedurebody): Procedure '%s' is not the current declared Procedure", id_name_fuer_fehlertext);
					}
					tabcnt--;

					staticlevel = yypvt[-7].s.val.pstbl->ofblock->nr;
				} /*NOTREACHED*/ break;
case 334:
# line 3201 "../source/modula.yac"
{
					yypvt[-1].s.val.pstbl->status.is_external = 1;
					c_out_lf ();
					c_out ("#define\t");
					c_out_id (yypvt[-1].s.val.pstbl);
					c_out ("\t%s", yypvt[-1].s.val.pstbl->id);
					c_out_lf ();
					c_out_linebegin ("");
					c_out ("extern ");
					c_out_id (yypvt[-1].s.val.pstbl->ofstblentry);
					c_out_id (yypvt[-1].s.val.pstbl);
					c_out ("();");
					c_out_lf ();
				} /*NOTREACHED*/ break;
case 336:
# line 3216 "../source/modula.yac"
{
					yypvt[-1].s.val.pstbl->status.is_external = 1;
					yypvt[-1].s.val.pstbl->status.is_defined = 0;

					c_out_linebegin ("");
					c_out ("extern ");
					c_out_id (yypvt[-1].s.val.pstbl->ofstblentry);
					c_out_id (yypvt[-1].s.val.pstbl);
					c_out ("();");
					c_out_lf ();
				} /*NOTREACHED*/ break;
case 338:
# line 3230 "../source/modula.yac"
{
					message (D_WARN, "yyparse (noprocedure): Token PROCEDURE not allowed at end of Procedure");
				} /*NOTREACHED*/ break;
case 340:
# line 3236 "../source/modula.yac"
{
					yyval = yypvt[-1];
				} /*NOTREACHED*/ break;
case 341:
# line 3240 "../source/modula.yac"
{
					if (yypvt[-1].s.val.pstbl->u.nextfldorpar != NULL) {
						message (D_ERROR, "yyparse (_formalparams_): Parameter-Count differs from earlier Declaration");
					}

					yyval = yypvt[-4];
				} /*NOTREACHED*/ break;
case 343:
# line 3248 "../source/modula.yac"
{
					if (yypvt[-0].s.val.pstbl->u.nextfldorpar != NULL) {
						message (D_ERROR, "yyparse (_formalparams_): Parameter-Count differs from earlier Declaration");
					}

					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 345:
# line 3258 "../source/modula.yac"
{
					if (yypvt[-1].s.art.blcktyp == e_PROCESS) {
						message (D_ERROR, "yyparse (_oftypeident_): Type-Identifier not allowed for Processes");
						YYERROR;
					}
					yyval.s.art.da = def_null; /* damit keine Ausgabe bei type stattfindet */
				} /*NOTREACHED*/ break;
case 346:
# line 3265 "../source/modula.yac"
{
					if (yypvt[-3].s.flag.is_alreadydefined) {
							/* Typ-Check */
						if (yypvt[-3].s.val.pstbl->ofstblentry != yypvt[-0].s.art.stbltyp) {
							message (D_ERROR, "yyparse (_oftypeident_): Procedure-Type differs from earlier Declaration");
						}
					}
					yypvt[-3].s.val.pstbl->ofstblentry = yypvt[-0].s.art.stbltyp;
				} /*NOTREACHED*/ break;
case 347:
# line 3274 "../source/modula.yac"
{
					pstblentry = voidstblentry;
					if (yypvt[-0].s.flag.is_alreadydefined) {
							/* Typ-Check */
						if (yypvt[-0].s.val.pstbl->ofstblentry != pstblentry) {
							message (D_ERROR, "yyparse (_oftypeident_): Procedure-Type differs from earlier Declaration");
						}
					}
					yypvt[-0].s.val.pstbl->ofstblentry = pstblentry;
				} /*NOTREACHED*/ break;
case 348:
# line 3287 "../source/modula.yac"
{
					yyval = yypvt[-1];	/* Der zweite paramsect
							   erhaelt als $0 die
							   Werte des ersten */
				} /*NOTREACHED*/ break;
case 349:
# line 3292 "../source/modula.yac"
{
					yyval = yypvt[-0]; /* wegen Parameter-Liste */
				} /*NOTREACHED*/ break;
case 351:
# line 3298 "../source/modula.yac"
{
					idlisttype = parameterlist;
					yyval = yypvt[-1];
					yyval.s.flag = yypvt[-0].s.flag;
					if (yypvt[-1].s.flag.is_alreadydefined) {
						yyval.s.flag.is_alreadydefined = 1;
					}
				} /*NOTREACHED*/ break;
case 352:
# line 3306 "../source/modula.yac"
{
					idlisttype = (IdListType) 0;
				} /*NOTREACHED*/ break;
case 353:
# line 3309 "../source/modula.yac"
{
					yyval.s.flag = null_flag;
					yyval.s.flag.is_paramsect = 1;
					/* flag.is_arrayof kann beim ARRAY-Type gesetzt werden */
					yyval.s.flag.is_arrayof = 0;

					yyval.s.art.da = def_null; /* damit keine Ausgabe bei type stattfindet */
				} /*NOTREACHED*/ break;
case 354:
# line 3317 "../source/modula.yac"
{
					yypvt[-1].s.flag.is_paramsect = 0;	/* zur Sicherheit geloescht,
									   damit das gesetzte Flag
									   nicht im Stack bleibt */
					if (yypvt[-7].s.flag.is_alreadydefined) {
							/* Typ-Check */
						char	var, opn;

						var = '\0';
						opn = '\0';
						
						if (yypvt[-6].s.flag.is_const == 0) {
							var = 'V';
						}
						if (yypvt[-1].s.flag.is_arrayof == 1) {
							opn = 'A';
						}
						check_type_of_stbl_list (yypvt[-0].s.art.stbltyp, var, opn);
					} else {
							/* Typ-Eintrag */
						if (yypvt[-1].s.flag.is_arrayof == 1) {
							set_openarray_of_stbl_list (lookforgentype (yypvt[-0].s.art.stbltyp));
						} else {
							set_type_of_stbl_list (yypvt[-0].s.art.stbltyp);
						}
					}
					yyval = yypvt[-4];
					yyval.s.art.stbltyp = yypvt[-0].s.art.stbltyp;
				} /*NOTREACHED*/ break;
case 355:
# line 3348 "../source/modula.yac"
{
					if (yypvt[-1].s.art.blcktyp == e_PROCESS) {
						message (D_ERROR, "yyparse (_var_): Call by Reference not allowed for Processes");
						YYERROR;
					}
					yyval.s.flag = null_flag;
					yyval.s.flag.is_const = 0;
				} /*NOTREACHED*/ break;
case 356:
# line 3356 "../source/modula.yac"
{
					yyval.s.flag = null_flag;
					yyval.s.flag.is_const = 1;
				} /*NOTREACHED*/ break;
case 357:
# line 3364 "../source/modula.yac"
{
					yyval = yypvt[-2];
					if ((idlisttype == recordfieldlist) || (idlisttype == parameterlist)) {
							/* Wegen richtiger
							   Verkettung in der
							   nextfldorpar-Liste */
						yyval = yypvt[-1];
					}
				} /*NOTREACHED*/ break;
case 358:
# line 3373 "../source/modula.yac"
{
					yyval = yypvt[-0]; /* wegen Parameter-Liste */
				} /*NOTREACHED*/ break;
case 360:
# line 3379 "../source/modula.yac"
{
					switch (idlisttype) {
					default:
						message (D_INTERNAL, "yyparse (idlistident): unknown idlisttype %d", idlisttype);
					case recordfieldlist:
						strcat (id_name, "_");
						pstblentry = symbtbladd (id_name);
						pstblentry->iart.is_recordfieldid = 1;
						pstblentry->status.is_defined = 1;
							/* Feld-Liste: */
						pstblentry->u.nextfldorpar = yypvt[-1].s.val.pstbl;
						add_stbl_list (pstblentry);
						yyval = yypvt[-1];
						yyval.s.val.pstbl = pstblentry;
						break;
					case enumerationlist:
						pstblentry = symbtbladd (id_name);
						pstblentry->iart.is_constid = 1;
						pstblentry->status.is_defined = 1;
						pstblentry->ofstblentry = yypvt[-1].s.art.stbltyp;
						if (erange == 0) {
							c_out_linebegin ("");
							c_out_id (pstblentry);
							c_out ("= 0");
						} else {
							c_out (", ");
							c_out_linebegin ("");
							c_out_id (pstblentry);
						}
						pstblentry->u.lv = (long) erange;
						erange++;
						break;
					case parameterlist:
						if (yypvt[-1].s.flag.is_alreadydefined == 0) {
							/* noch nicht deklariert */
							pstblentry = symbtbladd (id_name);
							pstblentry->iart.is_parameter = 1;
								/* noconst, falls VAR-Parameter */
							if (yypvt[-1].s.flag.is_const == 0) {
								pstblentry->iart.is_callbyreference = 1;
							}
							pstblentry->status.is_defined = 1;
								/* Parameter-Liste: */
							yypvt[-1].s.val.pstbl->u.nextfldorpar = pstblentry;
						} else {
							/* bereits deklariert --> pruefen */
							pstblentry = yypvt[-1].s.val.pstbl->u.nextfldorpar;
							if (pstblentry == NULL) {
								message (D_ERROR, "yyparse (idlistident): Parameter-Count differs from earlier Declaration");
								YYERROR;
							}
							if (strcmp (id_name, pstblentry->id) != 0) {
								message (D_ERROR, "yyparse (idlistident): Parameter-Identifier '%s' differs from earlier Declaration", id_name_fuer_fehlertext);
								YYERROR;
							}
						}
						add_stbl_list (pstblentry);
						yyval = yypvt[-1];
						yyval.s.val.pstbl = pstblentry;
						break;
					}
				} /*NOTREACHED*/ break;
case 362:
# line 3447 "../source/modula.yac"
{
						/*  wegen error-recovery */
					yyval.s.art.blcktyp = e_EVENT;
					yyval.s.val.pstbl = voidstblentry;
				} /*NOTREACHED*/ break;
case 363:
# line 3452 "../source/modula.yac"
{
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 364:
# line 3457 "../source/modula.yac"
{
					setidart (is_interruptid);
					if ((pstblentry = symbtbllookupwithinidart (id_name, idart)) == NULL) {
						message (D_ERROR, "yyparse (restofeventhead): Interrupt-Identifier '%s' not declared or event defined twice", id_name_fuer_fehlertext);
						YYERROR;
					}
					pstblentry->iart.is_eventid = 1;
					pstblentry->iart.is_interruptid = 0;
					blocktype = e_EVENT;
					newblocklist (pstblentry->id);
						/* in pstblentry->u.lv steht die
						 * zugehoerige Interruptnummer */
					
					blocktype = e_BODY;
					newblocklist (pstblentry->id);

					c_out_linebegin ("int event_%ld ()", pstblentry->u.lv);
					c_out_lf ();
					c_out_linebegin ("{");
					c_out_lf ();
					tabcnt++;
					c_init ("\tsig_neu (%ld, event_%ld);\n", pstblentry->u.lv, pstblentry->u.lv);

					staticlevel = blocklist->nr;
							/* $0 wird wegen der error-recovery gesetzt */
					yyval.s.art.blcktyp = yypvt[-1].s.art.blcktyp = e_EVENT;
					yyval.s.val.pstbl = yypvt[-1].s.val.pstbl = pstblentry;
				} /*NOTREACHED*/ break;
case 365:
# line 3485 "../source/modula.yac"
{
					yyval = yypvt[-1];
					yyval.s.flag.is_error = 0;
				} /*NOTREACHED*/ break;
case 366:
# line 3490 "../source/modula.yac"
{
							/* $0 wurde wegen der error-recovery gesetzt;
							 * einmal in ...head und einmal weiter oben
							 * in dieser Regel */
					yyval = yypvt[-2];
					yyval.s.flag.is_error = 1;
				} /*NOTREACHED*/ break;
case 367:
# line 3499 "../source/modula.yac"
{
					/* staticlevel ist von oben noch gesetzt,
					 * da keine lokalen Prozeduren definiert
					 * werden koennen */
					c_out_linebegin ("sig_ign ();");
					yyval = yypvt[-1];
				} /*NOTREACHED*/ break;
case 368:
# line 3508 "../source/modula.yac"
{
					setidart (is_eventid);
					if ((pstblentry = symbtbllookupwithinidart (id_name, idart)) == NULL) {
						message (D_ERROR, "yyparse (eventbody): Event-Identifier '%s' not declared", id_name_fuer_fehlertext);
					}
					if (pstblentry != yypvt[-5].s.val.pstbl) {
						message (D_ERROR, "yyparse (eventbody): Event '%s' is not the current declared Event", id_name_fuer_fehlertext);
					}
					staticlevel = yypvt[-5].s.val.pstbl->ofblock->nr;
				} /*NOTREACHED*/ break;
case 370:
# line 3521 "../source/modula.yac"
{
					message (D_WARN, "yyparse (noevent): Token EVENT not allowed at end of Event");
				} /*NOTREACHED*/ break;
case 373:
# line 3531 "../source/modula.yac"
{
						/*  wegen error-recovery */
					yyval.s.art.blcktyp = e_PROCESS;
					yyval.s.val.pstbl = voidstblentry;
				} /*NOTREACHED*/ break;
case 374:
# line 3536 "../source/modula.yac"
{
						/*
						 * extern ...
						 * wird immer ausgegeben, weil der
						 * Prozess in einer eventuell
						 * vorhandenen Exception 
						 * bereits mit RESTART
						 * aufgerufen werden kann
						 */
					c_out_linebegin ("");
					c_out ("extern ");
					c_out_id (yypvt[-0].s.val.pstbl->ofstblentry);
					c_out_id (yypvt[-0].s.val.pstbl);
					c_out ("();");
					c_out_lf ();

					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 375:
# line 3556 "../source/modula.yac"
{
					blocktype = e_PROCESS;
					setidart (is_processid);
					if ((pstblentry = symbtbllookupwithinidart (id_name, idart)) == NULL) {
						pstblentry = symbtbladd (id_name);
						pstblentry->iart.is_processid = 1;
						if (export) {
							pstblentry->status.is_external = 1;
						} else {
							pstblentry->status.is_defined = 1;
						}
						pstblentry->ofstblentry = voidstblentry; /* Default */
						yyval.s.flag.is_alreadydefined = 0;
						newblocklist (pstblentry->id);
					} else {
						if (pstblentry->status.is_defined) {
							message (D_ERROR, "yyparse (restofprocesshd): Process already defined");
							YYERROR;
						}
						yyval.s.flag.is_alreadydefined = 1;
						setactualblock (blocktype, pstblentry->id);
						pstblentry->status.is_defined = 1;
					}
					pstblentry->ofstblentry = voidstblentry;
					staticlevel = blocklist->nr;
							/* $0 wird wegen der error-recovery gesetzt */
					yyval.s.art.blcktyp = yypvt[-1].s.art.blcktyp = e_PROCESS;
					yyval.s.val.pstbl = yypvt[-1].s.val.pstbl = pstblentry;
				} /*NOTREACHED*/ break;
case 376:
# line 3586 "../source/modula.yac"
{
					staticlevel = yypvt[-2].s.val.pstbl->ofblock->nr;
					yyval = yypvt[-2];
					yyval.s.flag.is_error = 0;
				} /*NOTREACHED*/ break;
case 377:
# line 3592 "../source/modula.yac"
{
							/* $0 wurde wegen der error-recovery gesetzt;
							 * einmal in ...head und einmal weiter oben
							 * in dieser Regel */
					yyval = yypvt[-2];
					yyval.s.flag.is_error = 1;
				} /*NOTREACHED*/ break;
case 378:
# line 3601 "../source/modula.yac"
{
					staticlevel = blocklist->nr;
					setactualblock (e_PROCESS, yypvt[-0].s.val.pstbl->id);
					blocktype = e_BODY;
					newblocklist (yypvt[-0].s.val.pstbl->id);
					yyval.s.val.lv = (long) staticlevel;
				} /*NOTREACHED*/ break;
case 379:
# line 3609 "../source/modula.yac"
{
					yyval = yypvt[-3];
				} /*NOTREACHED*/ break;
case 380:
# line 3612 "../source/modula.yac"
{
					staticlevel = (int) yypvt[-4].s.val.lv;
					setactualblock (e_PROCESS, yypvt[-5].s.val.pstbl->id);
					setactualblock (e_BODY, yypvt[-5].s.val.pstbl->id);
					yyval = yypvt[-5];
				} /*NOTREACHED*/ break;
case 381:
# line 3620 "../source/modula.yac"
{
					setidart (is_processid);
					if ((pstblentry = symbtbllookupwithinidart (id_name, idart)) == NULL) {
						message (D_ERROR, "yyparse (processbody): Process-Identifier '%s' not declared", id_name_fuer_fehlertext);
					}
					if (pstblentry != yypvt[-9].s.val.pstbl) {
						message (D_ERROR, "yyparse (processbody): Process '%s' is not the current declared Process", id_name_fuer_fehlertext);
					}
					staticlevel = yypvt[-9].s.val.pstbl->ofblock->nr;
				} /*NOTREACHED*/ break;
case 384:
# line 3634 "../source/modula.yac"
{
					message (D_WARN, "yyparse (processornot): Token PROCESS is missing");
				} /*NOTREACHED*/ break;
case 385:
# line 3640 "../source/modula.yac"
{
					blocktype = e_EXCEPTION;
					newblocklist ("Exception");
					blocktype = e_BODY;
					newblocklist ("Exception");

					staticlevel = blocklist->nr;

					pstblentry = voidstblentry;
					yyval.s.art.blcktyp = e_EXCEPTION;
					yyval.s.val.lv = (long) staticlevel;
				} /*NOTREACHED*/ break;
case 386:
# line 3653 "../source/modula.yac"
{
					staticlevel = (int) yypvt[-2].s.val.lv;

					c_out_linebegin ("sigreturntype x_%s () /* Exception */", yypvt[-5].s.val.pstbl->id);
					c_out_lf ();
					c_out_linebegin ("{");
					c_out_lf ();
					tabcnt++;
					c_out_linebegin ("sig_ign ();");
					c_out_lf ();
					c_init ("\tdefine_exception (\"%s\", x_%s);\n", yypvt[-5].s.val.pstbl->id, yypvt[-5].s.val.pstbl->id);

					setactualblock (e_EXCEPTION, "Exception");
					setactualblock (e_BODY, "Exception");

					staticlevel = blocklist->nr;

					yyval = yypvt[-2];
					yyval.s.val.pstbl = voidstblentry;
				} /*NOTREACHED*/ break;
case 390:
# line 3680 "../source/modula.yac"
{
					message (D_WARN, "yyparse (exceptionornot): Token EXCEPTION is missing");
				} /*NOTREACHED*/ break;
case 392:
# line 3690 "../source/modula.yac"
{
					pstblentry = symbtbladd (id_name);
					pstblentry->iart.is_communicationid = 1;
					if (! export) {
						pstblentry->status.is_defined = 1;
					}
					pstblentry->ofstblentry = voidstblentry; /* Default */
					blocktype = e_COMMUNICATION;
					newblocklist (pstblentry->id);

					staticlevel = blocklist->nr;

					yyval.s.art.blcktyp = e_COMMUNICATION;
					yyval.s.val.pstbl = pstblentry;
				} /*NOTREACHED*/ break;
case 393:
# line 3706 "../source/modula.yac"
{
					yyval = yypvt[-2];
				} /*NOTREACHED*/ break;
case 394:
# line 3711 "../source/modula.yac"
{
					char	newoutname[256];

					pclose (outfile);

					strcpy (newoutname, module_name);
					strcat (newoutname, "_");
					strcat (newoutname, yypvt[-0].s.val.pstbl->id);
					strcat (newoutname, ".c");

							/* Output to Comm-Server-File */
					if ((outfile = fopen (newoutname, "w")) == NULL) {
						message (D_OPEN_ERROR, "yyparse (commbody): Cannot open output file '%s'", newoutname);
					}

					setlinebuf (outfile);

					c_out_lf ();
					c_out ("#include \"%s_%s_xdr.c\"", module_name, yypvt[-0].s.val.pstbl->id);
					c_out_lf ();
					c_out ("#include <mcfktns.h>");
					c_out_lf ();
					c_out ("#include <mcremote.h>");
					c_out_lf ();
					c_out ("comm_in\targument;");
					c_out_lf ();
					c_out ("int\targument_length = sizeof (argument);");
					c_out_lf ();

					c_out_lineno ();

					staticlevel = blocklist->nr;
					setactualblock (e_COMMUNICATION, yypvt[-0].s.val.pstbl->id);
					blocktype = e_BODY;
					newblocklist (yypvt[-0].s.val.pstbl->id);
					yyval.s.val.lv = (long) staticlevel;
				} /*NOTREACHED*/ break;
case 395:
# line 3749 "../source/modula.yac"
{
					search_for_undeclared_events ();

					yyval = yypvt[-3];
				} /*NOTREACHED*/ break;
case 396:
# line 3754 "../source/modula.yac"
{
					staticlevel = (int) yypvt[-4].s.val.lv;
					setactualblock (e_COMMUNICATION, yypvt[-5].s.val.pstbl->id);
					setactualblock (e_BODY, yypvt[-5].s.val.pstbl->id);

					yyval = yypvt[-5];
				} /*NOTREACHED*/ break;
case 397:
# line 3761 "../source/modula.yac"
{
					char	newoutname[256];

					pclose (outfile);

					strcpy (newoutname, module_name);
					strcat (newoutname, "_");
					strcat (newoutname, yypvt[-7].s.val.pstbl->id);
					strcat (newoutname, ".x");

							/* Output to RPC-File */
					if ((outfile = fopen (newoutname, "w")) == NULL) {
						message (D_OPEN_ERROR, "yyparse (commbody): Cannot open output file '%s'", newoutname);
					}
					setlinebuf (outfile);

					comm_out_rpc_file (yypvt[-7].s.val.pstbl);

					pclose (outfile);

					strcpy (newoutname, "rpcgen -h -o ");
					strcat (newoutname, module_name);
					strcat (newoutname, "_");
					strcat (newoutname, yypvt[-7].s.val.pstbl->id);
					strcat (newoutname, ".h ");
					strcat (newoutname, module_name);
					strcat (newoutname, "_");
					strcat (newoutname, yypvt[-7].s.val.pstbl->id);
					strcat (newoutname, ".x");

					fprintf (stderr, "\n%s\n", newoutname);
					if (system (newoutname) != 0) {
						message (D_ERROR, "yyparse (commbody): rpcgen failed");
					}

					strcpy (newoutname, "rpcgen -c -o ");
					strcat (newoutname, module_name);
					strcat (newoutname, "_");
					strcat (newoutname, yypvt[-7].s.val.pstbl->id);
					strcat (newoutname, "_xdr.c ");
					strcat (newoutname, module_name);
					strcat (newoutname, "_");
					strcat (newoutname, yypvt[-7].s.val.pstbl->id);
					strcat (newoutname, ".x");

					fprintf (stderr, "\n%s\n", newoutname);
					if (system (newoutname) != 0) {
						message (D_ERROR, "yyparse (commbody): rpcgen failed");
					}

							/* Output of .m.c-file continues */
					if ((outfile = fopen (p_out, "a")) == NULL) {
						message (D_OPEN_ERROR, "yyparse (commbody): Cannot open output file '%s' to append", p_out);
					}
					setlinebuf (outfile);
					c_out_lineno ();

					local_communication_out (yypvt[-7].s.val.pstbl);
				} /*NOTREACHED*/ break;
case 398:
# line 3821 "../source/modula.yac"
{
					setidart (is_communicationid);
					if ((pstblentry = symbtbllookupwithinidart (id_name, idart)) == NULL) {
						message (D_ERROR, "yyparse (commbody): Communication-Identifier '%s' not declared", id_name_fuer_fehlertext);
					}
					if (pstblentry != yypvt[-10].s.val.pstbl) {
						message (D_ERROR, "yyparse (commbody): Communication '%s' is not the current declared Communication", id_name_fuer_fehlertext);
					}
					staticlevel = yypvt[-10].s.val.pstbl->ofblock->nr;
				} /*NOTREACHED*/ break;
case 401:
# line 3835 "../source/modula.yac"
{
					message (D_WARN, "yyparse (commornot): Token COMMUNICATION is missing");
				} /*NOTREACHED*/ break;
case 403:
# line 3844 "../source/modula.yac"
{
						/*  wegen error-recovery */
					yyval.s.art.blcktyp = e_MONITOR;
					yyval.s.val.pstbl = voidstblentry;
				} /*NOTREACHED*/ break;
case 404:
# line 3849 "../source/modula.yac"
{
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 405:
# line 3854 "../source/modula.yac"
{
					blocktype = e_MONITOR;
					setidart (is_monitorid);
					if ((pstblentry = symbtbllookupwithinidart (id_name, idart)) == NULL) {
						pstblentry = symbtbladd (id_name);
						pstblentry->iart.is_monitorid = 1;
						if (export) {
							pstblentry->status.is_external = 1;
						} else {
							pstblentry->status.is_defined = 1;
						}
						newblocklist (pstblentry->id);
					} else {
						if (pstblentry->status.is_defined) {
							message (D_ERROR, "yyparse (restofmonhead): Monitor already defined");
							YYERROR;
						}
						setactualblock (blocktype, pstblentry->id);
						pstblentry->status.is_defined = 1;
					}
					pstblentry->ofstblentry = voidstblentry;
					c_out_linebegin ("");
					c_out ("extern ");
					c_out_id (pstblentry->ofstblentry);
					c_out_id (pstblentry);
					c_out ("();\textern m0_semaphore sem_%s;", pstblentry->id);
					c_out_lf ();
					
					staticlevel = blocklist->nr;
							/* $0 wird wegen der error-recovery gesetzt */
					yyval.s.art.blcktyp = yypvt[-1].s.art.blcktyp = e_MONITOR;
					yyval.s.val.pstbl = yypvt[-1].s.val.pstbl = pstblentry;
				} /*NOTREACHED*/ break;
case 406:
# line 3887 "../source/modula.yac"
{
					yyval = yypvt[-1];
					yyval.s.flag.is_error = 0;
				} /*NOTREACHED*/ break;
case 407:
# line 3892 "../source/modula.yac"
{
							/* $0 wurde wegen der error-recovery gesetzt;
							 * einmal in ...head und einmal weiter oben
							 * in dieser Regel */
					yyval = yypvt[-2];
					yyval.s.flag.is_error = 1;
				} /*NOTREACHED*/ break;
case 408:
# line 3901 "../source/modula.yac"
{
					staticlevel = blocklist->nr;
					blocktype = e_BODY;
					newblocklist (yypvt[-0].s.val.pstbl->id);
				} /*NOTREACHED*/ break;
case 409:
# line 3907 "../source/modula.yac"
{
							/* Aufruf der Monitor-Initialisierung */
					if (yypvt[-3].s.val.pstbl->status.is_external) {
						c_init ("\tadd_fktn (m0_%s);\t/* Monitor-Init. */\n", yypvt[-3].s.val.pstbl->id);
					} else {
						c_init ("\tadd_fktn (m%d_%s);\t/* Monitor-Init. */\n", yypvt[-3].s.val.pstbl->ofblock->nr, yypvt[-3].s.val.pstbl->id);
					}
					yyval = yypvt[-3];

					setactualblock (e_MONITOR, yypvt[-3].s.val.pstbl->id);
					staticlevel = blocklist->nr;	/* muss in dieser Reihenfolge bleiben ! */
					setactualblock (e_BODY, yypvt[-3].s.val.pstbl->id);
				} /*NOTREACHED*/ break;
case 410:
# line 3922 "../source/modula.yac"
{
					setidart (is_monitorid);
					if ((pstblentry = symbtbllookupwithinidart (id_name, idart)) == NULL) {
						message (D_ERROR, "yyparse (monbody): Monitor-Identifier '%s' not declared", id_name_fuer_fehlertext);
					}
					if (pstblentry != yypvt[-7].s.val.pstbl) {
						message (D_ERROR, "yyparse (monbody): Monitor '%s' is not the current declared Monitor", id_name_fuer_fehlertext);
					}
					staticlevel = yypvt[-7].s.val.pstbl->ofblock->nr;
				} /*NOTREACHED*/ break;
case 417:
# line 3945 "../source/modula.yac"
{
					message (D_WARN, "yyparse (monitorornot): Token MONITOR is missing");
				} /*NOTREACHED*/ break;
case 419:
# line 3954 "../source/modula.yac"
{
						/*  wegen error-recovery */
					yyval.s.art.blcktyp = e_ENTRY;
					yyval.s.val.pstbl = voidstblentry;
				} /*NOTREACHED*/ break;
case 420:
# line 3959 "../source/modula.yac"
{
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 421:
# line 3964 "../source/modula.yac"
{
					setactualblock (e_MONITOR, NULL);
					
					blocktype = e_ENTRY;
					setidart (is_entryid);
					if ((pstblentry = symbtbllookupwithinidart (id_name, idart)) == NULL) {
						pstblentry = symbtbladd (id_name);
						pstblentry->iart.is_entryid = 1;
						if (export) {
							pstblentry->status.is_external = 1;
						} else {
							pstblentry->status.is_defined = 1;
						}
						pstblentry->ofstblentry = voidstblentry; /* Default */
						yyval.s.flag.is_alreadydefined = 0;
						newblocklist (pstblentry->id);
					} else {
						if (pstblentry->status.is_defined) {
							message (D_ERROR, "yyparse (restofentryhead): Entry already defined");
							YYERROR;
						}
						yyval.s.flag.is_alreadydefined = 1;
						setactualblock (blocktype, pstblentry->id);
						pstblentry->status.is_defined = 1;
					}
					staticlevel = blocklist->nr;
							/* $0 wird wegen der error-recovery gesetzt */
					yyval.s.art.blcktyp = yypvt[-1].s.art.blcktyp = e_ENTRY;
					yyval.s.val.pstbl = yypvt[-1].s.val.pstbl = pstblentry;
				} /*NOTREACHED*/ break;
case 422:
# line 3995 "../source/modula.yac"
{
					staticlevel = yypvt[-2].s.val.pstbl->ofblock->nr;
					yyval = yypvt[-2];
					yyval.s.flag.is_error = 0;
				} /*NOTREACHED*/ break;
case 423:
# line 4001 "../source/modula.yac"
{
							/* $0 wurde wegen der error-recovery gesetzt;
							 * einmal in ...head und einmal weiter oben
							 * in dieser Regel */
					yyval = yypvt[-2];
					yyval.s.flag.is_error = 1;
				} /*NOTREACHED*/ break;
case 424:
# line 4010 "../source/modula.yac"
{
					staticlevel = blocklist->nr;
					setactualblock (e_ENTRY, yypvt[-0].s.val.pstbl->id);
					blocktype = e_BODY;
					newblocklist (yypvt[-0].s.val.pstbl->id);
				} /*NOTREACHED*/ break;
case 425:
# line 4016 "../source/modula.yac"
{
					/* staticlevel ist von oben noch gesetzt,
					 * da keine lokalen Prozeduren definiert
					 * werden koennen */
					yyval = yypvt[-2];
				} /*NOTREACHED*/ break;
case 426:
# line 4024 "../source/modula.yac"
{
					setidart (is_entryid);
					if ((pstblentry = symbtbllookupwithinidart (id_name, idart)) == NULL) {
						message (D_ERROR, "yyparse (entrybody): Entry-Identifier '%s' not declared", id_name_fuer_fehlertext);
					}
					if (pstblentry != yypvt[-6].s.val.pstbl) {
						message (D_ERROR, "yyparse (entrybody): Entry '%s' is not the current declared Entry", id_name_fuer_fehlertext);
					}
					staticlevel = yypvt[-6].s.val.pstbl->ofblock->nr;
				} /*NOTREACHED*/ break;
case 428:
# line 4037 "../source/modula.yac"
{
					message (D_WARN, "yyparse (noentry): Token ENTRY not allowed at end of Entry");
				} /*NOTREACHED*/ break;
case 431:
# line 4046 "../source/modula.yac"
{
					yyval = yypvt[-0]; /* for overtaking .s.art.da */
					strcpy (yyval.s.val.ov, ""); /* here stands "ARRAY" only in case of ARRAY-Declaration */
				} /*NOTREACHED*/ break;
case 434:
# line 4056 "../source/modula.yac"
{
					setidart (is_typeid);
					if ((pstblentry = symbtbllookupwithinidart (id_name, idart)) == NULL) {
						message (D_ERROR, "yyparse (type): Type-Identifier '%s' is not declared. Assumed as integer", id_name_fuer_fehlertext);
						pstblentry = symbtbladd (id_name);
						pstblentry->iart.is_typeid = 1;
						pstblentry->status.is_defined = 1;
						if ((pstblentry->ofstblentry = symbtbllookupwithinidart ("integer", idart)) == NULL) {
							message (D_FATAL, "yyparse (type): Integer-Type not found");
						}
					}

					if (yypvt[-1].s.art.da == def_type) {
							/* Typ-Deklaration */
						c_out_linebegin ("\ttypedef\t");
						c_out_id (pstblentry);
						c_out_id (stbllist->entry);
						c_out (";");
						stbllist->entry->iart.is_typeid = 1;
						stbllist->entry->status.is_defined = 1;
						stbllist->entry->ofstblentry = pstblentry;
						free ((char *) stbllist);
						stbllist = NULL;
					} else if (yypvt[-1].s.art.da == def_var) {
							/* Variablen-Deklaration */
						set_and_out_type_of_stbl_list (pstblentry);
					} else if (yypvt[-1].s.art.da == def_record) {
							/* Record-Deklaration */
						set_type_of_stbl_list (pstblentry);
					}

					yyval.s.art.stbltyp = pstblentry;
					yyval.s.flag = null_flag;
				} /*NOTREACHED*/ break;
case 439:
# line 4094 "../source/modula.yac"
{
					setidart (is_typeid);
					if ((pstblentry = symbtbllookupwithinidart ("boolean", idart)) == NULL) {
						message (D_FATAL, "yyparse (type): Boolean-Type not found");
					}

					if (yypvt[-1].s.art.da == def_type) {
							/* Typ-Deklaration */
						c_out_linebegin ("\ttypedef\tm0_boolean\t");
						c_out_id (stbllist->entry);
						c_out (";");
						stbllist->entry->iart.is_typeid = 1;
						stbllist->entry->status.is_defined = 1;
						stbllist->entry->ofstblentry = pstblentry;
						free ((char *) stbllist);
						stbllist = NULL;
					} else if (yypvt[-1].s.art.da == def_var) {
							/* Variablen-Deklaration */
						set_and_out_type_of_stbl_list (pstblentry);
					} else if (yypvt[-1].s.art.da == def_record) {
							/* Record-Deklaration */
						set_type_of_stbl_list (pstblentry);
					}

					yyval.s.flag = null_flag;
					yyval.s.art.stbltyp = pstblentry;
				} /*NOTREACHED*/ break;
case 440:
# line 4127 "../source/modula.yac"
{
					char	sname[40];

					ta1 = yypvt[-3].s.art.stbltyp->u.oftype->tart;
					ta2 = yypvt[-1].s.art.stbltyp->u.oftype->tart;

					if (   ta1.is_longcard /* Bereich zu gross */
					    || ta2.is_longcard /* Bereich zu gross */
					    || (ta1.is_char && ta1.is_array) /* String */
					    || (ta2.is_char && ta2.is_array) /* String */
					    || ! (   (ta1.is_byte && ta2.is_byte)
						  || (ta1.is_enumeration && ta2.is_enumeration)
					          || (ta1.is_char && ta2.is_char))) /* gleicher Typ ? */ {
						message (D_ERROR, "yyparse (subrange): Subrange of invalid Type");
						YYERROR;
					}

					if ((yyval.s.art.stbltyp = maxtype (yypvt[-3].s.art.stbltyp, yypvt[-1].s.art.stbltyp)) == NULL) {
						/* Fehlermeldung wurde bereits ausgegeben */
						YYERROR;
					}

					if (yypvt[-3].s.val.lv > yypvt[-1].s.val.lv) {
						message (D_ERROR, "yyparse (subrange): Value of the first Subrange-Parameter must be less than Value of the seconde one");
						YYERROR;
					}

					sprintf (sname, "_subr_%lX_%lX", yypvt[-3].s.val.lv, yypvt[-1].s.val.lv);
					setidart (is_typeid);
					if ((pstblentry = symbtbllookupwithinidart (sname, idart)) == NULL) {
							/* Subrange noch nicht definiert */
						pstblentry = symbtbladd (sname);
						memset ((char *) &typevar, 0, sizeof (typevar));
							/* Integer-Typ, innerhalb dessen der Subrange liegt
							 * bzw. CHAR oder Enumeration */
						typevar.tart = lookforgentypeart (yyval.s.art.stbltyp);

						typevar.tart.is_subrange = 1;
						pstblentry->iart.is_typeid = pstblentry->iart.is_generictype = 1;
						pstblentry->status.is_defined = 1;
						pstblentry->ofstblentry = pstblentry;
						typevar.minval = yypvt[-3].s.val.lv;
						typevar.maxval = yypvt[-1].s.val.lv;
						typevar.oftype = yyval.s.art.stbltyp;
						pstblentry->u.oftype = typeadd (&typevar);
						c_out_linebegin ("typedef\t");
						c_out_id (yyval.s.art.stbltyp);
						c_out_id (pstblentry);
						c_out (";");
						c_out_lf ();
					}
							
					if (yypvt[-5].s.art.da == def_type) {
							/* Typ-Deklaration */
						c_out_linebegin ("typedef\t");
						c_out_id (pstblentry);
						c_out_id (stbllist->entry);
						c_out (";");
						stbllist->entry->iart.is_typeid = 1;
						stbllist->entry->status.is_defined = 1;
						stbllist->entry->ofstblentry = pstblentry;
						free ((char *) stbllist);
						stbllist = NULL;
					} else if (yypvt[-5].s.art.da == def_var) {
							/* Variablen-Deklaration */
						set_and_out_type_of_stbl_list (pstblentry);
					} else if (yypvt[-5].s.art.da == def_record) {
							/* Record-Deklaration */
						set_type_of_stbl_list (pstblentry);
					}

					yyval.s.art.stbltyp = pstblentry;
					yyval.s.flag = null_flag;
				} /*NOTREACHED*/ break;
case 441:
# line 4203 "../source/modula.yac"
{
					static 	int	enr = 0;
					char	ename[10];

					if (yypvt[-1].s.art.da != def_type) {
							/* keine typedecl */
						sprintf (ename, "_enum%d", enr++);
						pstblentry = symbtbladd (ename);
					} else {
							/* typedecl */
						pstblentry = stbllist->entry;
						free ((char *) stbllist);
						stbllist = NULL;
					}
					memset ((char *) &typevar, 0, sizeof (typevar));
					typevar.tart.is_enumeration = 1;
					pstblentry->iart.is_typeid = pstblentry->iart.is_generictype = 1;
					pstblentry->status.is_defined = 1;
					pstblentry->ofstblentry = pstblentry;
					typevar.minval = 0;
					pstblentry->u.oftype = typeadd (&typevar);
					c_out_linebegin ("typedef enum\t");
					c_out_id (pstblentry);
					c_out ("{ ");
					tabcnt++;
					erange = 0;
					idlisttype = enumerationlist;

					yyval.s.art.stbltyp = pstblentry;
				} /*NOTREACHED*/ break;
case 442:
# line 4234 "../source/modula.yac"
{
					idlisttype = (IdListType) 0;
					if (erange > 255) {
						message (D_WARN, "enumeration: Count of Elements '%d' exceeds 256", erange);
					}
					yypvt[-2].s.art.stbltyp->u.oftype->maxval = (long) (erange - 1);
					tabcnt--;
					c_out ("} ");
					c_out_id (yypvt[-2].s.art.stbltyp);
					c_out (";");

					if (yypvt[-4].s.art.da == def_var) {
							/* Variablen-Deklaration */
						set_and_out_type_of_stbl_list (yypvt[-2].s.art.stbltyp);
					} else if (yypvt[-4].s.art.da == def_record) {
							/* Record-Deklaration */
						set_type_of_stbl_list (pstblentry);
					}

					yyval = yypvt[-2];
					yyval.s.flag = null_flag;
				} /*NOTREACHED*/ break;
case 443:
# line 4259 "../source/modula.yac"
{
					yyval.s.art.da = def_null;
				} /*NOTREACHED*/ break;
case 444:
# line 4262 "../source/modula.yac"
{
/* hier fehlt noch einiges ... */
					yyval.s.flag = null_flag;
				} /*NOTREACHED*/ break;
case 445:
# line 4269 "../source/modula.yac"
{
						/* ARRAY handling see 'out_array_of_cond_or_sem ()'
						 * in file 'symbtbl.c' called in production 'arraytype'
						 * after defining the ARRAY-Index-Types */

					STblList	*help;
			
					if (moduletype != e_LOWMOD) {
						message (D_ERROR, "yyparse (specialtype): SEMAPHORE only in Lowlevel-Modules allowed");
					}
					if ((pstblentry = symbtbllookup ("semaphore")) == NULL) {
						message (D_FATAL, "yyparse (specialtype): Semaphore-Type not found");
					}
					help = stbllist;
					while (help != NULL) {
						if (strcmp (yypvt[-2].s.val.ov, "ARRAY")) {
								/* No ARRAY --> Output */
							c_init ("\tm%d_%s = sem_define (%ld);\n", help->entry->ofblock->nr, help->entry->id, yypvt[-0].s.val.lv);
						}
						help->entry->iart.is_varid = 0;
						help->entry->iart.is_semaphoreid = 1;
						help = help->next;
					}
					if (yypvt[-2].s.art.da == def_var) {
							/* Variablen-Deklaration */
						if (strcmp (yypvt[-2].s.val.ov, "ARRAY")) {
								/* No ARRAY --> Output */
							set_and_out_type_of_stbl_list (pstblentry);
						}
					} else if (yypvt[-2].s.art.da == def_record || yypvt[-2].s.art.da == def_pointer) {
						message (D_ERROR, "yyparse (specialtype): SEMAPHORE-Type as Component of Records or Pointers not allowed");
					} else {
						message (D_ERROR, "yyparse (specialtype): SEMAPHORE-Type only in Variable-Declaration allowed");
					}
					yyval.s.val.lv = yypvt[-0].s.val.lv; /* see production 'arraytype' */
					yyval.s.art.stbltyp = pstblentry;
					yyval.s.flag = null_flag;
				} /*NOTREACHED*/ break;
case 446:
# line 4308 "../source/modula.yac"
{
					/* After SEMAPHORE or SEMAPHORE [...] only a ';' may appear:
					   BUT this ';' here must be put back to the input stream
					   because it is needed in other reductions where specialtype
					   is only one of sveral alternatives.
					   WITHOUT this ';' here there may exist some shift/reduce
					   Conflicts within compiling this source with yacc.
					   Therefore this ';' is given back to the input stream
					   using a function defined in modula.lex with the result
					   that no shift/reduce Conflicts occur.
					*/
					lex_unput_char (';');
					yyval = yypvt[-1];
				} /*NOTREACHED*/ break;
case 447:
# line 4322 "../source/modula.yac"
{
						/* ARRAY handling see 'out_array_of_cond_or_sem ()'
						 * in file 'symbtbl.c' called in production 'arraytype'
						 * after defining the ARRAY-Index-Types */

					STblList	*help;
					BlockList	*bl;

					bl = blocklist->nextblocklist;
					if (moduletype == e_LOWMOD || (bl->type != e_MONITOR && bl->type != e_ENTRY)) {
						message (D_ERROR, "yyparse (specialtype): CONDITION only in Monitors allowed");
					}
					if ((pstblentry = symbtbllookup ("condition")) == NULL) {
						message (D_FATAL, "yyparse (specialtype): Condition-Type not found");
					}
					help = stbllist;
					while (help != NULL) {
						if (strcmp (yypvt[-1].s.val.ov, "ARRAY")) {
								/* No ARRAY --> Output */
							c_init ("\tm%d_%s = cond_define (0);\n", help->entry->ofblock->nr, help->entry->id);
						}
						help->entry->iart.is_varid = 0;
						help->entry->iart.is_conditionid = 1;
						help = help->next;
					}
					if (yypvt[-1].s.art.da == def_var) {
							/* Variablen-Deklaration */
						if (strcmp (yypvt[-1].s.val.ov, "ARRAY")) {
								/* No ARRAY --> Output */
							set_and_out_type_of_stbl_list (pstblentry);
						}
					} else if (yypvt[-1].s.art.da == def_record || yypvt[-1].s.art.da == def_pointer) {
						message (D_ERROR, "yyparse (specialtype): CONDITION-Type as Component of Records or Pointers not allowed");
					} else {
						message (D_ERROR, "yyparse (specialtype): CONDITION-Type only in Variable-Declaration allowed");
					}
					yyval.s.val.lv = 0L; /* see production 'arraytype' */
					yyval.s.art.stbltyp = pstblentry;
					yyval.s.flag = null_flag;
				} /*NOTREACHED*/ break;
case 448:
# line 4366 "../source/modula.yac"
{
					if ((lookforgentypeart (yypvt[-1].s.art.stbltyp).is_byte == 0) || (yypvt[-1].s.val.lv < 0)) {
						message (D_ERROR, "yyparse (_seminit_): Only Cardinal Constants allowed as SEMAPHORE-Init-Value");
					}
					yyval = yypvt[-1];
				} /*NOTREACHED*/ break;
case 449:
# line 4373 "../source/modula.yac"
{
					yyval.s.val.lv = 1L;
				} /*NOTREACHED*/ break;
case 450:
# line 4376 "../source/modula.yac"
{
					yyval.s.val.lv = 1L;
				} /*NOTREACHED*/ break;
case 454:
# line 4386 "../source/modula.yac"
{
					int	i;
					
					for (i = 0; i < MAX_ARR; i++) {
						if (arrayix [i] == NULL) {
							break;
						}
					}

					yyval.s.val.lv = (long) i;
					yyval.s.art.da = def_null;
				} /*NOTREACHED*/ break;
case 455:
# line 4399 "../source/modula.yac"
{
					yyval.s.art.da = def_null;
				} /*NOTREACHED*/ break;
case 456:
# line 4402 "../source/modula.yac"
{
					SymbTblEntry	*ixpstbl, *ofpstbl;
					char	aname[60];
					int	i;

					ofpstbl = lookforgentype (yypvt[-0].s.art.stbltyp);

					for (i = 0; i < MAX_ARR; i++) {
						if (arrayix [i] == NULL) {
							i--;
							break;
						}
					}

					for ( ; i >= (int) yypvt[-4].s.val.lv; i--) {
						ixpstbl = arrayix [i];
							/* Array-Index */
						sprintf (aname, "_array_0x%lX_0x%lX_of_0x%X", ixpstbl->u.oftype->minval, ixpstbl->u.oftype->maxval, ofpstbl->u.oftype->typenr);
						setidart (is_typeid);
						if ((pstblentry = symbtbllookupwithinidart (aname, idart)) == NULL) {
								/* Array-Index noch nicht definiert */
							pstblentry = symbtbladd (aname);
							memset ((char *) &typevar, 0, sizeof (typevar));
							typevar.tart.is_array = 1;
							pstblentry->iart.is_typeid = pstblentry->iart.is_generictype = 1;
							pstblentry->status.is_defined = 1;
							pstblentry->ofstblentry = pstblentry;
							typevar.minval = ixpstbl->u.oftype->minval;
							typevar.maxval = ixpstbl->u.oftype->maxval;
							typevar.dimension = ofpstbl->u.oftype->dimension + 1;
							typevar.oftype = ofpstbl;
							if (strcmp (ofpstbl->id, "STRING") == 0) {
								typevar.tart.is_char = 1;
							}
							typevar.indextype = ixpstbl;
							pstblentry->u.oftype = typeadd (&typevar);
							c_out_linebegin ("typedef\tstruct\t");
							c_out_id (pstblentry);
							c_out ("{");
							c_out_id (ofpstbl);
							if (ixpstbl->u.oftype->tart.is_char) {
								c_out ("a[%ld];} ", typevar.maxval - typevar.minval + 2);
							} else {
								c_out ("a[%ld];} ", typevar.maxval - typevar.minval + 1);
							}
							c_out_id (pstblentry);
							c_out (";");
							c_out_lf ();
						}
						ofpstbl = pstblentry;
					}

					if (yypvt[-6].s.art.da == def_type) {
							/* Typ-Deklaration */
						c_out_linebegin ("typedef\t");
						c_out_id (pstblentry);
						c_out_id (stbllist->entry);
						c_out (";");
						c_out_lf ();
						stbllist->entry->iart.is_typeid = 1;
						stbllist->entry->status.is_defined = 1;
						stbllist->entry->ofstblentry = pstblentry;
						free ((char *) stbllist);
						stbllist = NULL;
					} else if (yypvt[-6].s.art.da == def_var) {
						if (strcmp (yypvt[-0].s.art.stbltyp->id, "semaphore") == 0 || strcmp (yypvt[-0].s.art.stbltyp->id, "condition") == 0) {
							/* Initialisation of SEMAPHORES and CONDITIONS */
							out_array_of_cond_or_sem (pstblentry, yypvt[-0].s.art.stbltyp->id, yypvt[-0].s.val.lv);
						} else {
								/* Variablen-Deklaration (neither SEMAPHORES nor CONDITIONS */
							set_and_out_type_of_stbl_list (pstblentry);
						}
					} else if (yypvt[-6].s.art.da == def_record) {
							/* Record-Deklaration */
						set_type_of_stbl_list (pstblentry);
					}
					
					for (i = (int) yypvt[-4].s.val.lv; i < MAX_ARR; i++) {
						arrayix [i] = NULL;
					}

					yyval.s.art.stbltyp = pstblentry;
					yyval.s.flag = null_flag;
				} /*NOTREACHED*/ break;
case 457:
# line 4487 "../source/modula.yac"
{
					if (yypvt[-2].s.flag.is_paramsect == 0) {
						message (D_ERROR, "yyparse (arraytype): ARRAY OF only in Parameter-Section allowed (not recursive); ignored");
					}
						/* $0 zu beachten! nicht $$ */
					yypvt[-2].s.flag.is_arrayof = 1;
					
					yyval.s.flag = null_flag;
					yyval.s.art.da = def_null;
				} /*NOTREACHED*/ break;
case 458:
# line 4497 "../source/modula.yac"
{
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 460:
# line 4503 "../source/modula.yac"
{
					yyval = yypvt[-0];
					strcpy (yyval.s.val.ov, "ARRAY"); /* here stands "ARRAY" only in case of ARRAY-Declaration */
					yyval.s.art.da = yypvt[-5].s.art.da; /* overtaking .s.art.da of the ARRAY declaration */
				} /*NOTREACHED*/ break;
case 461:
# line 4509 "../source/modula.yac"
{
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 462:
# line 4515 "../source/modula.yac"
{
					yyval = yypvt[-2];
					yyval.s.art.da = def_null;
				} /*NOTREACHED*/ break;
case 466:
# line 4524 "../source/modula.yac"
{
					message (D_WARN, "yyparse (commaornot): Token ',' expected at List Separation");
				} /*NOTREACHED*/ break;
case 467:
# line 4529 "../source/modula.yac"
{
					int	i;

					for (i = 0; i < MAX_ARR; i++) {
						if (arrayix [i] == NULL) {
							break;
						}
					}
					if (i >= MAX_ARR) {
						message (D_FATAL, "yyparse (subr): Array too complex; please split into more types");
					}
					arrayix [i] = yypvt[-0].s.art.stbltyp;
				} /*NOTREACHED*/ break;
case 469:
# line 4544 "../source/modula.yac"
{
					setidart (is_typeid);
					if ((pstblentry = symbtbllookupwithinidart (id_name, idart)) == NULL) {
						message (D_ERROR, "yyparse (suborid): Subrange-Identifier '%s' not declared", id_name_fuer_fehlertext);
						YYERROR;
					}
					yyval.s.art.stbltyp = lookforgentype (pstblentry);
					if (   yyval.s.art.stbltyp->u.oftype->tart.is_subrange == 0
					    && yyval.s.art.stbltyp->u.oftype->tart.is_enumeration == 0) {
						message (D_ERROR, "yyparse (suborid): Subrange-Identifier '%s' not a subrange or enumeration", id_name_fuer_fehlertext);
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 470:
# line 4559 "../source/modula.yac"
{
					if (yypvt[-1].s.art.da == def_type) {
							/* Typ-Deklaration */
						stbllist->entry->iart.is_typeid = 1;
						stbllist->entry->iart.is_generictype = 1;
						memset ((char *) &typevar, 0, sizeof (typevar));
						stbllist->entry->u.oftype = typeadd (&typevar);
						stbllist->entry->u.oftype->tart.is_record = 1;
							/* weiteres siehe unten */
					}
					save_stbl_list (1);
					yyval.s.val.pstbl = NULL;
				} /*NOTREACHED*/ break;
case 471:
# line 4572 "../source/modula.yac"
{
					save_stbl_list (-1);
					yyval.s.art.stbltyp = yyval.s.val.pstbl = pstblentry = define_record (yypvt[-0].s.val.pstbl, yypvt[-3].s.art.da);
					yyval.s.flag = null_flag;
						/* In define_record wurden auch
						 * die Typ-, Variablen- und
						 * Record-Deklarationen
						 * abgearbeitet */

					c_saved_out ();
				} /*NOTREACHED*/ break;
case 472:
# line 4586 "../source/modula.yac"
{
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 473:
# line 4591 "../source/modula.yac"
{
					yyval = yypvt[-1];
				} /*NOTREACHED*/ break;
case 474:
# line 4594 "../source/modula.yac"
{
					yyval = yypvt[-2];
					yyval.s.flag.is_error = 1;
				} /*NOTREACHED*/ break;
case 475:
# line 4598 "../source/modula.yac"
{
					yyerrok;
					yyval = yypvt[-2];
					yyval.s.flag.is_error = 0;
				} /*NOTREACHED*/ break;
case 477:
# line 4607 "../source/modula.yac"
{
					yyval = yypvt[-1];
				} /*NOTREACHED*/ break;
case 478:
# line 4610 "../source/modula.yac"
{
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 479:
# line 4613 "../source/modula.yac"
{
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 480:
# line 4618 "../source/modula.yac"
{
					idlisttype = recordfieldlist;
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 481:
# line 4622 "../source/modula.yac"
{
					idlisttype = (IdListType) 0;
				} /*NOTREACHED*/ break;
case 482:
# line 4625 "../source/modula.yac"
{
					yyval.s.art.da = def_record;
				} /*NOTREACHED*/ break;
case 483:
# line 4628 "../source/modula.yac"
{
					yyval = yypvt[-4];
				} /*NOTREACHED*/ break;
case 485:
# line 4632 "../source/modula.yac"
{
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 487:
# line 4638 "../source/modula.yac"
{
					yyval = yypvt[-0]; /* for overtaking .s.art.da */
					strcpy (yyval.s.val.ov, ""); /* here stands "ARRAY" only in case of ARRAY-Declaration */
				} /*NOTREACHED*/ break;
case 488:
# line 4643 "../source/modula.yac"
{
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 489:
# line 4648 "../source/modula.yac"
{
					message (D_FATAL, "Record-CASE not implemented");

					yyval = yypvt[-1];
				} /*NOTREACHED*/ break;
case 491:
# line 4658 "../source/modula.yac"
{	/*Test auf Typeident */
				} /*NOTREACHED*/ break;
case 493:
# line 4666 "../source/modula.yac"
{
					pstblentry = symbtbladd (id_name);
					pstblentry->iart.is_recordcaseid = 1;
					pstblentry->status.is_defined = 1;
				} /*NOTREACHED*/ break;
case 500:
# line 4691 "../source/modula.yac"
{
					SymbTblEntry	*ofpstbl;
					char	aname[60];

					ofpstbl = lookforgentype (yypvt[-0].s.art.stbltyp);
					
					sprintf (aname, "_pointer_to_%X", ofpstbl->u.oftype->typenr);
					setidart (is_typeid);
					if ((pstblentry = symbtbllookupwithinidart (aname, idart)) == NULL) {
							/* Pointer noch nicht definiert */
						pstblentry = symbtbladd (aname);
						memset ((char *) &typevar, 0, sizeof (typevar));
						typevar.tart.is_pointer = 1;
						pstblentry->iart.is_typeid = pstblentry->iart.is_generictype = 1;
						pstblentry->status.is_defined = 1;
						pstblentry->ofstblentry = pstblentry;
						typevar.oftype = ofpstbl;
						pstblentry->u.oftype = typeadd (&typevar);
						if ((yypvt[-2].s.art.da != def_record) || (! ofpstbl->u.oftype->tart.is_record)) {
							c_out_linebegin ("typedef\t");
							c_out_id (ofpstbl);
							c_out ("\t*");
							c_out_id (pstblentry);
							c_out (";");
							c_out_lf ();
						} else {	/* Record-Pointer innerhalb einer Record-Definition */
							c_out_lf ();
							c_out ("#define\t");
							c_out_id (pstblentry);
							c_out ("\tstruct ");
							c_out_id (ofpstbl);
							c_out (" *");
							c_out_lf ();
							c_save ("\n#line %d \"%s\"", yylineno, actual_filename);
							c_save ("\n#undef m%d_%s", (pstblentry->status.is_external ? 0 : pstblentry->ofblock->nr), pstblentry->id);
							c_save ("\n#line %d \"%s\"\n", yylineno, actual_filename);
							c_save ("typedef\t");
							c_save ("m%d_%s\t*", (ofpstbl->status.is_external ? 0 : ofpstbl->ofblock->nr), ofpstbl->id);
							c_save ("m%d_%s;\n", (pstblentry->status.is_external ? 0 : pstblentry->ofblock->nr), pstblentry->id);
						}
					}
					
					if (yypvt[-2].s.art.da == def_type) {
							/* Typ-Deklaration */
						c_out_linebegin ("typedef\t");
						c_out_id (pstblentry);
						c_out_id (stbllist->entry);
						c_out (";");
						stbllist->entry->iart.is_typeid = 1;
						stbllist->entry->status.is_defined = 1;
						stbllist->entry->ofstblentry = pstblentry;
						free ((char *) stbllist);
						stbllist = NULL;
					} else if (yypvt[-2].s.art.da == def_var) {
							/* Variablen-Deklaration */
						set_and_out_type_of_stbl_list (pstblentry);
					} else if (yypvt[-2].s.art.da == def_record) {
							/* Record-Deklaration */
						set_type_of_stbl_list (pstblentry);
					}
					
					yyval.s.art.stbltyp = pstblentry;
					yyval.s.flag = null_flag;
				} /*NOTREACHED*/ break;
case 501:
# line 4757 "../source/modula.yac"
{
					yyval.s.art.da = def_pointer;
				} /*NOTREACHED*/ break;
case 502:
# line 4760 "../source/modula.yac"
{
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 503:
# line 4763 "../source/modula.yac"
{
					if (moduletype != e_LOWMOD) {
						message (D_ERROR, "yyparse (totypeornot): Untyped POINTER only in Lowlevel-Modules allowed");
					}
					
					yyval.s.art.stbltyp = voidstblentry;
				} /*NOTREACHED*/ break;
case 505:
# line 4777 "../source/modula.yac"
{
					yyval = eval_constexpr (yypvt[-2], yypvt[-1], yypvt[-0]);
					if (yyval.s.art.stbltyp == NULL) {
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 506:
# line 4785 "../source/modula.yac"
{
					yyval = eval_constexpr (yypvt[-2], yypvt[-1], yypvt[-0]);
					if (yyval.s.art.stbltyp == NULL) {
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 507:
# line 4793 "../source/modula.yac"
{
					yyval = eval_constexpr (yypvt[-2], yypvt[-1], yypvt[-0]);
					if (yyval.s.art.stbltyp == NULL) {
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 508:
# line 4801 "../source/modula.yac"
{
					yyval = eval_constexpr (yypvt[-2], yypvt[-1], yypvt[-0]);
					if (yyval.s.art.stbltyp == NULL) {
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 509:
# line 4809 "../source/modula.yac"
{
					yyval = eval_constexpr (yypvt[-2], yypvt[-1], yypvt[-0]);
					if (yyval.s.art.stbltyp == NULL) {
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 510:
# line 4817 "../source/modula.yac"
{
					yyval = eval_constexpr (yypvt[-2], yypvt[-1], yypvt[-0]);
					if (yyval.s.art.stbltyp == NULL) {
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 511:
# line 4825 "../source/modula.yac"
{
					yyval = eval_constexpr (yypvt[-2], yypvt[-1], yypvt[-0]);
					if (yyval.s.art.stbltyp == NULL) {
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 512:
# line 4832 "../source/modula.yac"
{
					if (lookforgentypeart (yypvt[-0].s.art.stbltyp).is_boolean == 0) {
						message (D_ERROR, "yyparse (constantexpr): Only boolean Values allowed with Operator 'NOT'");
						YYERROR;
					}
					yyval = yypvt[-0];
					yyval.s.val.lv = (yyval.s.val.lv ? 0L : 1L);
				} /*NOTREACHED*/ break;
case 513:
# line 4841 "../source/modula.yac"
{
					ta2 = lookforgentypeart (yypvt[-0].s.art.stbltyp);

					if (! (ta2.is_shortreal || ta2.is_byte)) {
						message (D_ERROR, "yyparse (constantexpr): Only numeric Values allowed with Operator 'Unary %s'", yypvt[-1].s.val.ov);
						YYERROR;
					}

					yyval = yypvt[-0];

					if (yypvt[-1].s.art.oa == op_minus) {
						if (ta2.is_shortreal) {
							yyval.s.val.dv *= -1.0;
						} else {
							yyval.s.val.lv *= -1L;
							if (negative_stbltyp (yypvt[-0].s.art.stbltyp) && yyval.s.val.lv >= 0L) {
								yyval.s.art.stbltyp = unsigned_const_stbltyp (yyval.s.val.lv);
							} else {
								yyval.s.art.stbltyp = negative_const_stbltyp (yypvt[-0].s.art.stbltyp);
							}
						}
					}
				} /*NOTREACHED*/ break;
case 514:
# line 4864 "../source/modula.yac"
{
					setidart (is_constid);
					if ((pstblentry = symbtbllookupwithinidart (id_name, idart)) == NULL) {
						message (D_ERROR, "yyparse (constantexpr): Constant-Identifier '%s' not declared", id_name_fuer_fehlertext);
						YYERROR;
					}

					ta2 = lookforgentypeart (pstblentry->ofstblentry);

					if (strcmp (pstblentry->ofstblentry->id, "STRING") == 0) { /* string */
						yyval.s.val.sv = pstblentry->u.sv;
					} if (ta2.is_shortreal) { /* double */
						yyval.s.val.dv = pstblentry->u.dv;
					} else if (ta2.is_byte || ta2.is_boolean || ta2.is_char || ta2.is_enumeration) { /* long */
						yyval.s.val.lv = pstblentry->u.lv;
					} else if (ta2.is_computer) { /* computer */
						yyval.s.val.pstbl = pstblentry;
					} else {
						message (D_INTERNAL, "yyparse (constantexpr): Type of Constant-Identifier '%s' invalid", id_name_fuer_fehlertext);
					}
					yyval.s.flag.is_const = 1;
					yyval.s.art.stbltyp = pstblentry->ofstblentry;
				} /*NOTREACHED*/ break;
case 515:
# line 4887 "../source/modula.yac"
{
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 516:
# line 4890 "../source/modula.yac"
{		/*
						 * Wenn $1.s.art.stbltyp->id == "char"
						 * --> Char-Value ist in $1.s.val.lv
						 * Wenn $1.s.art.stbltyp->id == "STRING"
						 * --> String-Value $1.s.val.sv ist ohne
						 *     Anfuehrungszeichen
						 */
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 517:
# line 4901 "../source/modula.yac"
{
					yyval = yypvt[-1];
				} /*NOTREACHED*/ break;
case 518:
# line 4907 "../source/modula.yac"
{
					if (  (strcmp (yypvt[-3].s.val.ov, "float") == 0)
					   || (strcmp (yypvt[-3].s.val.ov, "trunc") == 0)
					   || (strcmp (yypvt[-3].s.val.ov, "ord") == 0)
					   || (strcmp (yypvt[-3].s.val.ov, "chr") == 0)) {
						yyval = eval_const_stdfktn (yypvt[-3], yypvt[-1]);
						if (yyval.s.art.stbltyp == NULL) {
							YYERROR;
						}
					} else {
						message (D_ERROR, "yyparse (constantexpr): Only Standard Functions FLOAT, TRUNC, ORD, or CHR allowed at constant declaration part");
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 519:
# line 4924 "../source/modula.yac"
{
					ta1 = lookforgentypeart (yypvt[-1].s.art.stbltyp);

		 			if (   ta1.is_boolean
					    || ta1.is_byte
					    || ta1.is_shortreal
					    || ta1.is_enumeration
					    || (ta1.is_subrange && ! ta1.is_char) /* Sonderbehandlung bei CHAR,
										   * welches auch als Subrange
										   * definiert ist */
					    || ta1.is_pointer) {
						c_exbuf (" %s ", yypvt[-0].s.val.ov);
					}
					put_expr_pos ();
				} /*NOTREACHED*/ break;
case 520:
# line 4939 "../source/modula.yac"
{
					get_expr_pos ();

					yyval = eval_expr (yypvt[-3], yypvt[-2], yypvt[-0]);
					if (yyval.s.art.stbltyp == NULL) {
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 521:
# line 4948 "../source/modula.yac"
{
					ta1 = lookforgentypeart (yypvt[-1].s.art.stbltyp);

		 			if (   ta1.is_boolean
					    || ta1.is_byte
					    || ta1.is_shortreal
					    || ta1.is_enumeration
					    || (ta1.is_subrange && ! ta1.is_char) /* Sonderbehandlung bei CHAR,
										   * welches auch als Subrange
										   * definiert ist */
					    || ta1.is_pointer) {
						c_exbuf (" == ");
					}
					put_expr_pos ();
				} /*NOTREACHED*/ break;
case 522:
# line 4963 "../source/modula.yac"
{
					get_expr_pos ();

					yyval = eval_expr (yypvt[-3], yypvt[-2], yypvt[-0]);
					if (yyval.s.art.stbltyp == NULL) {
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 523:
# line 4972 "../source/modula.yac"
{
					if (lookforgentypeart (yypvt[-1].s.art.stbltyp).is_byte) {
								/* bitwise */
						c_exbuf (" %c ", yypvt[-0].s.val.ov [0]);
					} else {
								/* logical */
						c_exbuf (" %s ", yypvt[-0].s.val.ov);
					}
					put_expr_pos ();
				} /*NOTREACHED*/ break;
case 524:
# line 4982 "../source/modula.yac"
{
					get_expr_pos ();

					yyval = eval_expr (yypvt[-3], yypvt[-2], yypvt[-0]);
					if (yyval.s.art.stbltyp == NULL) {
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 525:
# line 4991 "../source/modula.yac"
{
					c_exbuf (" %s ", yypvt[-0].s.val.ov);
					put_expr_pos ();
				} /*NOTREACHED*/ break;
case 526:
# line 4995 "../source/modula.yac"
{
					get_expr_pos ();

					yyval = eval_expr (yypvt[-3], yypvt[-2], yypvt[-0]);
					if (yyval.s.art.stbltyp == NULL) {
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 527:
# line 5004 "../source/modula.yac"
{
					if (lookforgentypeart (yypvt[-1].s.art.stbltyp).is_byte) {
								/* bitwise */
						c_exbuf (" %c ", yypvt[-0].s.val.ov [0]);
					} else {
								/* logical */
						c_exbuf (" %s ", yypvt[-0].s.val.ov);
					}
					put_expr_pos ();
				} /*NOTREACHED*/ break;
case 528:
# line 5014 "../source/modula.yac"
{
					get_expr_pos ();

					yyval = eval_expr (yypvt[-3], yypvt[-2], yypvt[-0]);
					if (yyval.s.art.stbltyp == NULL) {
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 529:
# line 5023 "../source/modula.yac"
{
					c_exbuf (" %s ", yypvt[-0].s.val.ov);
					put_expr_pos ();
				} /*NOTREACHED*/ break;
case 530:
# line 5027 "../source/modula.yac"
{
					get_expr_pos ();

					yyval = eval_expr (yypvt[-3], yypvt[-2], yypvt[-0]);
					if (yyval.s.art.stbltyp == NULL) {
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 531:
# line 5036 "../source/modula.yac"
{
					if (yypvt[-0].s.art.oa == op_mod) {
							/* Modulo */
						insert_exbuf (show_expr_pos (), "modulo (");
						c_exbuf (", ");
					} else {
							/* Nicht Modulo (DIV, *, /) */
						c_exbuf (" %s ", yypvt[-0].s.val.ov);
					}
					put_expr_pos ();
				} /*NOTREACHED*/ break;
case 532:
# line 5047 "../source/modula.yac"
{
					get_expr_pos ();

					if (yypvt[-2].s.art.oa == op_mod) {
						c_exbuf (")");
					}
					yyval = eval_expr (yypvt[-3], yypvt[-2], yypvt[-0]);
					if (yyval.s.art.stbltyp == NULL) {
						YYERROR;
					}
				} /*NOTREACHED*/ break;
case 533:
# line 5058 "../source/modula.yac"
{
					c_exbuf (" ! ");
					put_expr_pos ();
				} /*NOTREACHED*/ break;
case 534:
# line 5062 "../source/modula.yac"
{
					get_expr_pos ();

					if (lookforgentypeart (yypvt[-0].s.art.stbltyp).is_boolean == 0) {
						message (D_ERROR, "yyparse (expression): Only boolean Values allowed with Operator 'NOT'");
						YYERROR;
					}
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 535:
# line 5071 "../source/modula.yac"
{
					if (yypvt[-0].s.art.oa == op_minus) {
						c_exbuf (" %s ", yypvt[-0].s.val.ov);
					}
					put_expr_pos ();
				} /*NOTREACHED*/ break;
case 536:
# line 5077 "../source/modula.yac"
{
					get_expr_pos ();

					ta = lookforgentypeart (yypvt[-0].s.art.stbltyp);

					if (! (ta.is_shortreal || ta.is_byte)) {
						message (D_ERROR, "yyparse (expression): Only numeric Values allowed with Operator 'Unary %s'", yypvt[-2].s.val.ov);
						YYERROR;
					}

					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 537:
# line 5089 "../source/modula.yac"
{
					put_expr_pos ();
					yyval.s.flag = null_flag;
					yyval.s.flag.is_expr = 1;
				} /*NOTREACHED*/ break;
case 538:
# line 5094 "../source/modula.yac"
{
					ta = yypvt[-0].s.art.stbltyp->u.oftype->tart;
					if (ta.is_array || ta.is_record || ta.is_char) {
						put_expr_pos ();
					} else {
						get_expr_pos ();
					}
					yyval = yypvt[-0];
					if (yypvt[-0].s.flag.is_const) {
						yyval.s.flag.is_expr = 1;
					}
				} /*NOTREACHED*/ break;
case 539:
# line 5106 "../source/modula.yac"
{
					ta = lookforgentypeart (yypvt[-0].s.art.stbltyp);

					if (ta.is_cardinal) {
						c_exbuf ("((unsigned long) 0x%lX /*Dec. %lu*/)", yypvt[-0].s.val.lv, ((unsigned long) yypvt[-0].s.val.lv));
					} else if (ta.is_byte) {
						c_exbuf ("0x%lX /*Dec. %ld*/", yypvt[-0].s.val.lv, yypvt[-0].s.val.lv);
					} else if (ta.is_shortreal) {
						c_exbuf ("%.32E", yypvt[-0].s.val.dv);
					}
					yyval = yypvt[-0];
				} /*NOTREACHED*/ break;
case 540:
# line 5118 "../source/modula.yac"
{		/*
						 * Wenn $1.s.art.stbltyp->id == "char"
						 * --> Char-Value ist in $1.s.val.lv
						 * Wenn $1.s.art.stbltyp->id == "STRING"
						 * --> String-Value $1.s.val.sv ist ohne
						 *     Anfuehrungszeichen
						 */

					static SymbTblEntry	pstring;
					char		chelp[2];
						/* Zur Kompatibilitaet mit einer
						 * definierten String-Konstante */
					
					put_expr_pos ();
					if (yypvt[-0].s.art.stbltyp->u.oftype->tart.is_array) {
							/* String */
						c_exbuf ("\"%s\"", yypvt[-0].s.val.sv);
						pstring.u.sv = yypvt[-0].s.val.sv;
					} else {
							/* Char */
						c_exbuf ("'%c'", ((char) yypvt[-0].s.val.lv));
						chelp [0] = (char) yypvt[-0].s.val.lv;
						chelp [1] = '\0';
						pstring.u.sv = strsave (chelp);
					}
					put_expr_pos ();
					yyval = yypvt[-0];
					yyval.s.val.pstbl = &pstring;
				} /*NOTREACHED*/ break;
case 541:
# line 5147 "../source/modula.yac"
{
					c_exbuf ("(");
					put_expr_pos ();
				} /*NOTREACHED*/ break;
case 542:
# line 5152 "../source/modula.yac"
{
					get_expr_pos ();
					c_exbuf (")");
					yyval = yypvt[-1];
				} /*NOTREACHED*/ break;
}


        goto yystack;           /* reset registers in driver code */
}
