/*
 *	rpcfktns.c
 */

#include <stdio.h>
#include <rpc/rpc.h>
#include <sys/socket.h>

#include "mcrpc.h"
#include "rpcfktns.h"

unsigned long	prognum_of_initialization_server;

unsigned long
gettransient(proto, vers, sockp)
      int proto, vers, *sockp;

{
			/* Called by a the
			 * communication-servers and
			 * processor-module-communication-server */
      static int prognum = 0x40000000;
      int s, len, socktype;
      struct sockaddr_in addr;

      switch(proto) {
              case IPPROTO_UDP:
                      socktype = SOCK_DGRAM;
                      break;
              case IPPROTO_TCP:
                      socktype = SOCK_STREAM;
                      break;
              default:
                      fprintf(stderr, "unknown protocol type\n");
                      return 0;

      }
      if (*sockp == RPC_ANYSOCK) {
           if ((s = socket(AF_INET, socktype, 0)) < 0) {
                perror("socket");
                return (0);
           }
           *sockp = s;
      }
      else
           s = *sockp;
      addr.sin_addr.s_addr = 0;
      addr.sin_family = AF_INET;
      addr.sin_port = 0;
      len = sizeof(addr);

      /*
       * may be already bound, so don't check for error
       */

      bind(s, &addr, len);
      if (getsockname(s, &addr, &len)< 0) {
           perror("getsockname");
           return (0);
      }
      while (!pmap_set(prognum++, vers, proto, 
           ntohs(addr.sin_port))) continue;
      return (prognum-1);

}
