/*
 *	rpclocal.h
 */

#ifndef MC_RPCLOCAL

# define MC_RPCLOCAL

# include <stdio.h>
# include <rpc/rpc.h>


typedef struct CLNT_PROCNO {
				/*
				 * this typedef is generated through
				 * symbtbl.c into the output file
				 * Changes here must be repeated in
				 * symbtbl.c
				 */
			CLIENT	*clnt;
			int	procno;
		} CLNT_PROCNO;


		/* defined in mcrpc_svc.c */
extern void	initialization_server_1();


extern void	check_started_comms();
extern void	stop_single_comm();
extern void	start_communication_server();

		/* communication runtime procedures */
CLNT_PROCNO	*mk_connect();
void	release_connect();

		/*
		 * server procedures to the clients
		 * with extension _1 instead of _server_site
		 */
extern void	*procmod_register_server_site();
extern void	*procmod_unregister_server_site();
extern int	*procmod_check_active_server_site();
extern void	*rpc_service_stop_server_site();

#endif
