/*
 *	symbtbl.h
 */


#ifndef NULL
# define	NULL	0
#endif

#define	D_SYMBPRIM	211
#define D_SYMBTBLWIDTH	50

#define	D_WARN	1
#define	D_ERROR	2
#define	D_FATAL	3
#define	D_INTERNAL	4
#define	D_OPEN_ERROR	5

extern char	*module_name;

extern int	warnings;
extern int	errors;

typedef	struct	FileNames {
			char	*name;
			struct	FileNames	*next;
		} FileNames;

extern FileNames	*filenames;

typedef enum	ModuleType {
			e_PROCMOD = 1,
			e_HIGHMOD,
			e_LOWMOD
		} ModuleType;

typedef	struct	IdArt {				/*
						 * Bei den mit ### markierten
						 * IdArten wird ein neuer Block
						 * in der BlockList erstellt,
						 * siehe dazu newblock
						 * und yyparse (ident)
						 */
			unsigned	is_communicationid : 1;	/* ### */
			unsigned	is_constid	: 1;
			unsigned	is_entryid	: 1;	/* ### */
			unsigned	is_eventid	: 1;	/* ### */
			unsigned	is_generictype	: 1;
			unsigned	is_interruptid	: 1;
			unsigned	is_moduleid	: 1;	/* ### */
			unsigned	is_monitorid	: 1;	/* ### */
			unsigned	is_parameter	: 1;
			unsigned	is_callbyreference : 1;
			unsigned	is_openarrayparam : 1;
			unsigned	is_procedureid	: 1;	/* ### */
			unsigned	is_processid	: 1;	/* ### */
			unsigned	is_recordcaseid	: 1;
			unsigned	is_recordfieldid : 1;
			unsigned	is_typeid	: 1;
			unsigned	is_varid	: 1;
			unsigned	is_for_parameter : 1;
			unsigned	is_conditionid	: 1;
			unsigned	is_semaphoreid	: 1;
		} IdArt;

extern IdArt	nullidart;


typedef	struct	Flag {
			unsigned	is_communicationcall : 1;
			unsigned	is_const	: 1;
			unsigned	is_for_assignment : 1;
			unsigned	is_expr		: 1;
			unsigned	is_lvalue	: 1;
			unsigned	is_alreadydefined : 1;
			unsigned	is_entrycall	: 1;
			unsigned	is_startofprocess : 1;
			unsigned	is_restartofprocess : 1;
			unsigned	is_disenableblock : 1;
			unsigned	is_paramsect	: 1;
			unsigned	is_arrayof	: 1;
			unsigned	is_error	: 1;
			unsigned	is_2nd_importstat : 1;
			unsigned	is_cond_or_sem_fn : 1;
		} Flag;

extern Flag	null_flag;


typedef	enum DefArt {
			def_null = 0,
			def_type,
			def_var,
			def_record,
			def_pointer
		} DefArt;

typedef	enum OpArt {
			op_and = 1,
			op_or,
			op_xor,
			op_not,
			op_plus,
			op_minus,
			op_mal,
			op_div,
			op_mod,
			op_geteilt,
			op_gleich,
			op_ungleich,
			op_kleiner,
			op_kleinergleich,
			op_groesser,
			op_groessergleich,
			op_in
		} OpArt;

			
typedef	enum	BlockType {
			e_FILE = 1,
			e_MODULE,
			e_PROCEDURE,
			e_EVENT,
			e_PROCESS,
			e_EXCEPTION,
			e_COMMUNICATION,
			e_MONITOR,
			e_ENTRY,
			e_BODY,
			e_WITH
		} BlockType;
		
extern BlockType	blocktype;

typedef	struct	Status {
			unsigned	is_predeclared : 1;
			unsigned	is_defined : 1;
			unsigned	is_external : 1;
		} Status;


typedef struct WORKSTATION {
			char	*ws_name;
			char	*ws_class;
		} WORKSTATION;

		
typedef	struct	SymbTblEntry {
			int	entrynr;
			char	*id;
			struct	SymbTblEntry	*next;
			struct	SymbTblEntry	*prev;
			IdArt	iart;
			Status	status;
			int	staticlevel;
			struct	SymbTblEntry	*nextinblock;
			struct	BlockList	*ofblock;
				/* Vom Typ bei  is_typeid,
						is_varid,
						is_constid,
						is_eventid,
						is_procedureid,
						is_parameter,
						is_recordcaseid,
						is_recordfieldid */
			struct	SymbTblEntry	*ofstblentry;
			union u {	/* Typ-Pointer bei is_generictype */
				struct	Types	*oftype;
					/* Naechstes Record-Feld
					 * (bei is_recordfieldid oder is_recordcaseid)
					 * und naechster Formal-Parameter
					 * (bei Not-is_generictype-Prozedurtypen mit
					 * Formalparametern oder is_parameter) */
				struct	SymbTblEntry	*nextfldorpar;
					/* Wert bei Zahlenkonstante
					 * und Interrupt-Nr. */
				long	lv;
				double	dv;
					/* Wert bei Stringkonstante */
				char	*sv;
					/* Workstation bei Computer-Konstante */
				WORKSTATION	*wsv;
			} u;
		} SymbTblEntry;

extern	SymbTblEntry	*voidstblentry; /* zeigt auf den Symboltabellen-Eintrag des Typs void */

extern	int	staticlevel;

typedef	struct	STblList {
			SymbTblEntry	*entry;
			struct	STblList	*next;
		} STblList;

extern	STblList	*stbllist;

typedef struct	STblListSave {
			STblList	*list;
			struct	STblListSave	*next;
		} STblListSave;

extern	STblListSave	*stbllistsave;

typedef	struct	BlockList {
			BlockType	type;
			char		*id;
			int		nr;
			SymbTblEntry	*stbllist;
			struct	BlockList	*nextblocklist;
			int	retcount;	/* bei e_BODY */
		} BlockList;

extern	BlockList	*blocklist;

typedef	struct	TypeArt	{
			unsigned	is_array	: 1;
			unsigned	is_boolean	: 1;
			unsigned	is_boolbitmask	: 1;
			unsigned	is_byte		: 1;
			unsigned	is_cardinal	: 1;
			unsigned	is_char		: 1;
			unsigned	is_computer	: 1;
			unsigned	is_condition	: 1;
			unsigned	is_enumeration	: 1;
			unsigned	is_integer	: 1;
			unsigned	is_longcard	: 1;
			unsigned	is_longint	: 1;
			unsigned	is_longreal	: 1;
			unsigned	is_pointer	: 1;
			unsigned	is_proc		: 1;
			unsigned	is_real		: 1;
			unsigned	is_record	: 1;
			unsigned	is_semaphore	: 1;
			unsigned	is_set		: 1;
			unsigned	is_shortcard	: 1;
			unsigned	is_shortint	: 1;
			unsigned	is_shortreal	: 1;
			unsigned	is_subrange	: 1;
			unsigned	is_void		: 1;
		} TypeArt;
		
typedef	struct	Types {
			int	typenr;
			struct	Types		*nexttype;
			TypeArt	tart;
				/* Nicht bei Pointer und Record */
			long	minval;
			long	maxval;
				/* Bei Array */
			unsigned int	dimension;
				/* Bei Pointer, Subrange und Array */
			struct	SymbTblEntry	*oftype;
				/* Bei Array und Record (erstes Fieldlist-Element) */
			struct	SymbTblEntry	*indextype;
		} Types;

extern	Types	typevar;


#define	setidart(is) {\
/* \
	memset ((char *) &idart, 0, sizeof (IdArt));\
*/ \
	idart = nullidart;\
	idart.is = 1;\
}

/* Funktionen in symbtbl.c */

extern void	message();
extern char	*strsave();
extern void	newblocklist();
extern void	newsymbtbl();
extern int	hash();
extern SymbTblEntry	*symbtbllookup();
extern SymbTblEntry	*symbtbllookupwithinidart();
/*	extern SymbTblEntry	*symbtbl_lookup_in_same_level(); */
/*	extern void	entryinactualblock(); */
extern SymbTblEntry	*symbtbladd();
/*	extern int	deleteentry(); */
extern void	setactualblock();
extern int	deleteactualblock();
extern void	save_stbl_list();
extern void	add_stbl_list();
extern void	init_array_of_cond_or_sem();
extern void	set_and_out_type_of_stbl_list();
extern void	set_type_of_stbl_list();
extern void	set_openarray_of_stbl_list();
extern void	check_type_of_stbl_list();
extern Types	*typeadd();
extern SymbTblEntry	*unsigned_const_stbltyp();
extern int	negative_stbltyp();
extern SymbTblEntry	*negative_const_stbltyp();
extern SymbTblEntry	*mintype();
extern SymbTblEntry	*maxtype();
extern SymbTblEntry	*lookforgentype();
extern TypeArt	lookforgentypeart();
extern char	*add_filename();
extern char	*look_for_filename();
extern void	search_for_undeclared_events();
extern void	show_symbtbl();
extern void	show_types();
extern void	show_blocklist();
extern void	show_filenames();
extern int	newblock();
extern void	initprecompiler();
extern void	loop_stack();
extern void	comm_param_out();
extern void	formal_param_out();
extern void	revoke_fparams_var_attr ();
extern void	comm_return();
extern void	comm_out_rpc_file();
extern void	save_locals();
extern void	local_communication_out();
extern SymbTblEntry	*define_record();

