# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX BUFSIZ
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
/*


****************************************************************************
  THIS SOURCE FILE MUST BE RUN WITH lex ON A SUN WORKSTATION
                                             ===============
  BECAUSE WHEN RUN ON A RS/6000 THE GENERATED FILE lex.yy.c
                        =======
  CANNOT BE COMPILED WITH cc ON A SUN WITHOUT ERRORS
                                              ======
  RUNNING LEX ON A SUN CAUSES NO ERRORS NEITHER ON A RS/6000
  NOR ON THE SUN ITSELF
****************************************************************************




Zum DEBUG:
Variable debug muss ein paar Zeilen unter 'int debug;' auf 1 gesetzt werden
# define LEXDEBUG 1
# define sprint(s)	{printf ("%s", s); }
# define allprint(c)	{printf ("%c (%d)", c, c); }
*/

#include "symbtbl.h"
#include "mc.h"
#include "os.h"
#include "mctypes.h"

#ifdef MSDOS
# include "y_tab.h"
#else
# include "y.tab.h"
#endif


#define	rtn(t) {\
	if (lowercase_flag) {\
		message (D_WARN, "yylex: Token '%s' is a reserved word. It must be written uppercase", yytext);\
	}\
	return (t);\
}

#define list() {\
	if (listfile != NULL) {\
		strcpy (lsttxt, yytext);\
		plsttxt1 = lsttxt;\
		do {\
			plsttxt2 = strchr (plsttxt1, '\n');\
			if (plsttxt2 != NULL) {\
				*plsttxt2 = '\0';\
			}\
			fprintf (listfile, "%s", plsttxt1);\
			if (plsttxt2 != NULL) {\
				int	i;\
				fprintf (listfile, "\n");\
				for (i = 1; i <= mc_list_level; i++) {\
					fprintf (listfile, "IMPORT:\t");\
				}\
				fprintf (listfile, "%d:\t", ++mc_list_lineno);\
				plsttxt1 = plsttxt2 + 1;\
			}\
		} while (plsttxt2 != NULL);\
	}\
}
	


#define mklowercase(t, y) {\
	list ();\
	lowercase_flag = 0;\
	strcpy (t, y);\
	for (pc = t; pc [0]; pc++) {\
		while (pc [0] == '_') {\
			lowercase_flag = 1;\
			for (i=0; pc [i]; i++) {\
				pc[i] = pc [i+1];\
			}\
		}\
		if (pc [0] >= 'A' && pc [0] <= 'Z') {\
			pc[0] = pc [0] - 'A' + 'a';\
		} else if (pc [0] < '0' || pc [0] > '9') {\
			lowercase_flag = 1;\
		}\
	}\
}

char	id_name[YYLMAX + 5];	/* zum Anhaengen von ".mod" beim Import */
char	id_name_fuer_fehlertext[YYLMAX];
int	max_token_length = YYLMAX;
static	char	string_inhalt[YYLMAX];
static	char	token[YYLMAX];	/* zur Eliminierung von '_' und zur
				 * Gross-/Kleinschrift-Anpassung */
static	char	lsttxt[YYLMAX], *plsttxt1, *plsttxt2;	/* zur Ausgabe des Listings */
static	char	*pc;
static	int	i;
static	int	lowercase_flag;	/* siehe define rtn (fuer Uppercase-Warnings) */


void
lex_unput_char(c)
	char	c;
{
	unput (c);	/* unput is a macro defined by lex itself --> see generated code */
}

	int	com_deep = 0;
# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
{
				list ();
				
				show_symbtbl ();
			}
break;
case 2:
{
				list ();

				show_types ();
			}
break;
case 3:
{
				list ();

				show_blocklist ((BlockType) 0);
			}
break;
case 4:
{
				list ();

				show_filenames ();
			}
break;
case 5:
		{	/*
				 * Kommentarbeginn erkannt
				 */
				char	nextc;

				list ();
				c_out ("/*");
				com_deep++;

				while (com_deep) {
					nextc = input ();
					if (nextc == '\0') {
						message (D_FATAL, "yylex: Unexpected End of File");
					} else if (nextc == '*') {
						nextc = input ();
						if (nextc == ')') {
								/* Kommentarende erkannt */
							if (listfile != NULL) {
								fprintf (listfile, "*)");
							}
							com_deep--;
							if (com_deep == 0) {
								c_out ("*/");
								break;
							} else {
								c_out ("*)");
							}
						} else if (nextc == '/') {
							if (listfile != NULL) {
								fprintf (listfile, "*/");
							}
								/* C-Kommentarende wird maskiert */
							c_out ("* ");
								/* Zweites Zeichen wird zurueckgeschrieben fuer neuen Test */
							unput (nextc);
						} else if (nextc == '*' || nextc == '(') {
							if (listfile != NULL) {
								fputc ('*', listfile);
							}
							c_out ("*");
								/* Zweites Zeichen wird zurueckgeschrieben fuer neuen Test */
							unput (nextc);
						} else {
							if (listfile != NULL) {
								fprintf (listfile, "*%c", nextc);
								if (nextc == '\n') {
									int	i;

									for (i = 1; i <= mc_list_level; i++) {
										fprintf (listfile, "IMPORT:\t");
									}
									fprintf (listfile, "%d:\t", ++mc_list_lineno);
								}
							}
							c_out ("*%c", nextc);
						}
					} else if (nextc == '/') {
						nextc = input ();
						if (nextc == '*') {
							if (listfile != NULL) {
								fputc ('/', listfile);
							}
								/* C-Kommentarbeginn wird maskiert */
							c_out ("/ ");
								/* Zweites Zeichen wird zurueckgeschrieben fuer neuen Test */
							unput (nextc);
						} else if (nextc == '/' || nextc == '(') {
							if (listfile != NULL) {
								fputc ('/', listfile);
							}
							c_out ("/");
								/* Zweites Zeichen wird zurueckgeschrieben fuer neuen Test */
							unput (nextc);
						} else {
							if (listfile != NULL) {
								fprintf (listfile, "/%c", nextc);
								if (nextc == '\n') {
									int	i;

									for (i = 1; i <= mc_list_level; i++) {
										fprintf (listfile, "IMPORT:\t");
									}
									fprintf (listfile, "%d:\t", ++mc_list_lineno);
								}
							}
							c_out ("/%c", nextc);
						}
					} else if (nextc == '(') {
						nextc = input ();
						if (nextc == '*') {
							if (listfile != NULL) {
								fprintf (listfile, "(*");
							}
								/* weiterer Kommentarbeginn erkannt */
							c_out ("(*");
							com_deep++;
						} else if (nextc == '/' || nextc == '(') {
							if (listfile != NULL) {
								fputc ('(', listfile);
							}
							c_out ("(");
								/* Zweites Zeichen wird zurueckgeschrieben fuer neuen Test */
							unput (nextc);
						} else {
							if (listfile != NULL) {
								fprintf (listfile, "(%c", nextc);
								if (nextc == '\n') {
									int	i;

									for (i = 1; i <= mc_list_level; i++) {
										fprintf (listfile, "IMPORT:\t");
									}
									fprintf (listfile, "%d:\t", ++mc_list_lineno);
								}
							}
							c_out ("(%c", nextc);
						}
					} else {
						if (listfile != NULL) {
							fputc (nextc, listfile);
							if (nextc == '\n') {
								int	i;

								for (i = 1; i <= mc_list_level; i++) {
									fprintf (listfile, "IMPORT:\t");
								}
								fprintf (listfile, "%d:\t", ++mc_list_lineno);
							}
						}
						c_out ("%c", nextc);
					}
				}
					/*
					 * Newline hinter Kommentar-Ende wird
					 * ausgegeben, falls vorhanden
					 */
				for ( ; ; ) {
					nextc = input ();
					if (nextc == '\0') {
						message (D_FATAL, "yylex: Unexpected End of File");
					} else if (nextc == ' ' || nextc == '\t') {
						if (listfile != NULL) {
							fputc (nextc, listfile);
						}
						/* Whitespace wird ignoriert */
					} else if (nextc == '\n') {
						if (listfile != NULL) {
							int	i;

							fprintf (listfile, "\n");
							for (i = 1; i <= mc_list_level; i++) {
								fprintf (listfile, "IMPORT:\t");
							}
							fprintf (listfile, "%d:\t", ++mc_list_lineno);
						}
						c_out_lf ();
					} else {
						/* Abbruch, weil Zeichen erkannt */
						break;
					}
				}
					/* Rueckschreiben des zuletzt erkannten Zeichens */
				unput (nextc);
				c_out_lineno ();
			}
break;
case 6:
		{
				list ();
				
				return (ASSIGNMENTOP);
			}
break;
case 7:
		{
				list ();

				return (TWOSINGLEDOTS);
			}
break;
case 8:
		case 9:
		{		/* not equal */

				list ();

				yylval.s.art.oa = op_ungleich;
				strcpy (yylval.s.val.ov, "!=");
				return (RELOP);
			}
break;
case 10:
		{		/* kleiner */

				list ();

				yylval.s.art.oa = op_kleiner;
				strcpy (yylval.s.val.ov, "<");
				return (RELOP);
			}
break;
case 11:
		{		/* kleiner gleich */

				list ();

				yylval.s.art.oa = op_kleinergleich;
				strcpy (yylval.s.val.ov, "<=");
				return (RELOP);
			}
break;
case 12:
		{		/* groesser */

				list ();

				yylval.s.art.oa = op_groesser;
				strcpy (yylval.s.val.ov, ">");
				return (RELOP);
			}
break;
case 13:
		{		/* groesser gleich */

				list ();

				yylval.s.art.oa = op_groessergleich;
				strcpy (yylval.s.val.ov, ">=");
				return (RELOP);
			}
break;
case 14:
		{		/* mal */

				list ();

				yylval.s.art.oa = op_mal;
				strcpy (yylval.s.val.ov, "*");
				return (MULOP);
			}
break;
case 15:
		{		/* (real) geteilt */

				list ();

				yylval.s.art.oa = op_geteilt;
				strcpy (yylval.s.val.ov, "/");
				return (MULOP);
			}
break;
case 16:
		{		/* plus */

				list ();

				yylval.s.art.oa = op_plus;
				strcpy (yylval.s.val.ov, "+");
				return (PLUSMINUS);
			}
break;
case 17:
		{		/* minus */

				list ();

				yylval.s.art.oa = op_minus;
				strcpy (yylval.s.val.ov, "-");
				return (PLUSMINUS);
			}
break;
case 18:
		{		/* Vergleichsoperator und
					 * Zuweisungsoperator bei
					 * Deklarationen von Konstanten, ... */

				list ();
					 
				yylval.s.art.oa = op_gleich;
				strcpy (yylval.s.val.ov, "==");
				return ((int) '=');
			}
break;
case 19:
	case 20:
	{
				list ();
				
					/* Anfuehrungszeichen werden eliminiert */
				strcpy (string_inhalt, yytext + 1);
				string_inhalt [strlen (string_inhalt) - 1] = '\0';

				yylval.s.flag.is_const = 1;
				if (strlen (string_inhalt) == 1) {
					if ((yylval.s.art.stbltyp = symbtbllookup ("char")) == NULL) {
						message (D_FATAL, "yylex (STRING): Char-Type not found");
					}
					yylval.s.val.lv = string_inhalt [0];
				} else {
					if ((yylval.s.art.stbltyp = symbtbllookup ("STRING")) == NULL) {
						message (D_FATAL, "yylex (STRING): STRING-Type not found");
					}
					yylval.s.val.sv = strsave (string_inhalt);
				}

				return (STRING);
			}
break;
case 21:
case 22:
{
				list ();

				yylval.s.flag.is_const = 1;
				if ((yylval.s.art.stbltyp = symbtbllookup ("shortreal")) == NULL) {
					message (D_FATAL, "yylex (REALNUMBER): SHORTREAL-Type not found");
				}
				sscanf (yytext, "%lf", &yylval.s.val.dv);
				return (REALNUMBER);
			}
break;
case 23:
	{
				list ();

				yylval.s.flag.is_const = 1;
				yylval.s.val.lv = 0;
				if (strlen (yytext) > 9) {
					message (D_ERROR, "yylex: HEXADECIMAL-Constant '%s' too big (> 4 Byte)", yytext);
					yylval.s.art.stbltyp = unsigned_const_stbltyp (yylval.s.val.lv);
					return (INTNUMBER);
				}
				sscanf (yytext + 1, "%lX", &yylval.s.val.lv);
				yylval.s.art.stbltyp = unsigned_const_stbltyp (yylval.s.val.lv);

				return (INTNUMBER);
			}
break;
case 24:
		{	int	i;

				list ();

				yylval.s.flag.is_const = 1;
				yylval.s.val.lv = 0;
				if (strlen (yytext) > 33) {
					message (D_ERROR, "yylex: BINARY-Constant '%s' too big (> 32 Bit)", yytext);
					yylval.s.art.stbltyp = unsigned_const_stbltyp (yylval.s.val.lv);
					return (INTNUMBER);
				}
				for (i = 1; i < strlen (yytext); i++) {
					yylval.s.val.lv <<= 1;
					if (yytext [i] == '1') {
						yylval.s.val.lv |= 1;
					}
				}
				yylval.s.art.stbltyp = unsigned_const_stbltyp (yylval.s.val.lv);

				return (INTNUMBER);
			}
break;
case 25:
	case 26:
		{	char	c[50];

				list ();

				yylval.s.flag.is_const = 1;
				
				sprintf (c, "%lu", m0_maxlongcard);
				if (strlen (yytext) > strlen (c) || (strlen (yytext) == strlen (c) && strcmp (yytext, c) > 0)) {
										/* groesser als maxlongcard --> real */
					sscanf (yytext, "%lf", &yylval.s.val.dv);
					message (D_WARN, "yylex: DECIMAL-Constant '%s' too big; treated as REALNUMBER", yytext);
					if ((yylval.s.art.stbltyp = symbtbllookup ("shortreal")) == NULL) {
						message (D_FATAL, "yylex (DECIMAL): SHORTREAL-Type not found");
					}
					return (REALNUMBER);
				}
				sscanf (yytext, "%ld", &yylval.s.val.lv);
				yylval.s.art.stbltyp = unsigned_const_stbltyp (yylval.s.val.lv);

				return (INTNUMBER);
			}
break;
case 27:
				case 28:
	case 29:
		case 30:
	case 31:
		case 32:
	case 33:
				case 34:
case 35:
	case 36:
{
				/*
				 * Typname in der Rolle als
				 * Typ-Umwandlungs-Funktions-Aufruf
				 * wird erkannt durch Lookahead '{WSNL}*\('
				 */

				mklowercase (token, yytext);

				if (strncmp (token, "byte", 4) == 0) {
					strcpy (yylval.s.val.ov, "0_byte");
				} else if (strncmp (token, "cardinal", 8) == 0) {
					strcpy (yylval.s.val.ov, "0_cardinal");
				} else if (strncmp (token, "integer", 7) == 0) {
					strcpy (yylval.s.val.ov, "0_integer");
				} else if (strncmp (token, "longcard", 8) == 0) {
					strcpy (yylval.s.val.ov, "0_longcard");
				} else if (strncmp (token, "longint", 7) == 0) {
					strcpy (yylval.s.val.ov, "0_longint");
				} else if (strncmp (token, "longreal", 8) == 0) {
					strcpy (yylval.s.val.ov, "0_longreal");
				} else if (strncmp (token, "real", 4) == 0) {
					strcpy (yylval.s.val.ov, "0_real");
				} else if (strncmp (token, "shortcard", 9) == 0) {
					strcpy (yylval.s.val.ov, "0_shortcard");
				} else if (strncmp (token, "shortint", 8) == 0) {
					strcpy (yylval.s.val.ov, "0_shortint");
				} else if (strncmp (token, "shortreal", 9) == 0) {
					strcpy (yylval.s.val.ov, "0_shortreal");
				} else {
					strcpy (yylval.s.val.ov, "0");
					/* liefert im Yacc-File eine Fehlermeldung */
				}
				rtn (STDFKTN);
			}
break;
case 37:
{	/*
				 * In Identifiern werden grundsaetzlich 
				 * Unterstreichungszeichen '_' entfernt,
				 * da diese nicht signifikant sind, sowie
				 * Grossbuchstaben in Kleinbuchstaben
				 * umgewandelt !!!
				 */

				mklowercase (token, yytext);

				switch (token [0]) {	/* Reserved Names */
				default:
					break;
				case 'a':
					if (strcmp (token, "and") == 0) {
							/* and */
						yylval.s.art.oa = op_and;
						strcpy (yylval.s.val.ov, "&&");
						rtn (AND);
					}
					if (strcmp (token, "array") == 0) {
						rtn (ARRAY);
					}
					break;
				case 'b':
					if (strcmp (token, "begin") == 0) {
						rtn (BEG);
					}
					if (strcmp (token, "boolean") == 0) {
						rtn (BOOLEAN);
					}
					if (strcmp (token, "by") == 0) {
						rtn (BY);
					}
					break;
				case 'c':
					if (strcmp (token, "case") == 0) {
						rtn (CASE);
					}
					if (strcmp (token, "call") == 0) {
						rtn (CALL);
					}
					if (strcmp (token, "chr") == 0) {
						strcpy (yylval.s.val.ov, "chr");
						return (STDFKTN);
					}
					if (strcmp (token, "communication") == 0) {
						rtn (COMMUNICATION);
					}
					if (strcmp (token, "computer") == 0) {
						rtn (COMPUTER);
					}
					if (strcmp (token, "condition") == 0) {
						rtn (CONDITION);
					}
					if (strcmp (token, "const") == 0) {
						rtn (CONST);
					}
					break;
				case 'd':
					if (strcmp (token, "dec") == 0) {
						strcpy (yylval.s.val.ov, "dec");
						return (STDFKTN);
					}
					if (strcmp (token, "disable") == 0) {
						rtn (DISABLE);
					}
					if (strcmp (token, "dispose") == 0) {
						strcpy (yylval.s.val.ov, "dispose");
						return (NEWORDISPOSE);
					}
					if (strcmp (token, "div") == 0) {
							/* Integer-Division */
						yylval.s.art.oa = op_div;
						strcpy (yylval.s.val.ov, "/");
						rtn (MULOP);
					}
					if (strcmp (token, "do") == 0) {
						rtn (DO);
					}
					break;
				case 'e':
					if (strcmp (token, "else") == 0) {
						rtn (ELSE);
					}
					if (strcmp (token, "elsif") == 0) {
						rtn (ELSIF);
					}
					if (strcmp (token, "enable") == 0) {
						rtn (ENABLE);
					}
					if (strcmp (token, "end") == 0) {
						rtn (END);
					}
					if (strcmp (token, "entry") == 0) {
						rtn (ENTRY);
					}
					if (strcmp (token, "event") == 0) {
						rtn (EVENT);
					}
					if (strcmp (token, "exceptno") == 0) {
						rtn (EXCEPTNO);
					}
					if (strcmp (token, "exception") == 0) {
						rtn (EXCEPTION);
					}
					if (strcmp (token, "exit") == 0) {
						rtn (EXIT);
					}
					if (strcmp (token, "export") == 0) {
						rtn (EXPORT);
					}
					if (strcmp (token, "external") == 0) {
						rtn (EXTERNAL);
					}
					break;
				case 'f':
					if (strcmp (token, "float") == 0) {
						strcpy (yylval.s.val.ov, "float");
						return (STDFKTN);
					}
					if (strcmp (token, "for") == 0) {
						rtn (FOR);
					}
					if (strcmp (token, "forward") == 0) {
						rtn (FORWARD);
					}
					break;
				case 'h':
					if (strcmp (token, "halt") == 0) {
						return (HALT);
					}
					if (strcmp (token, "high") == 0) {
						return (HIGH);
					}
					break;
				case 'i':
					if (strcmp (token, "if") == 0) {
						rtn (IF);
					}
					if (strcmp (token, "implementation") == 0) {
						rtn (IMPLEMENTATION);
					}
					if (strcmp (token, "import") == 0) {
						rtn (IMPORT);
					}
					if (strcmp (token, "in") == 0) {
							/* Mengen-Operator */
						yylval.s.art.oa = op_in;
						strcpy (yylval.s.val.ov, "&");
						rtn (RELOP);
					}
					if (strcmp (token, "inc") == 0) {
						strcpy (yylval.s.val.ov, "inc");
						return (STDFKTN);
					}
					if (strcmp (token, "initcom") == 0) {
						return (INITCOM);
					}
					if (strcmp (token, "interrupt") == 0) {
						rtn (INTERRUPT);
					}
					break;
				case 'l':
					if (strcmp (token, "loop") == 0) {
						rtn (LOOP);
					}
					if (strcmp (token, "lowlevel") == 0) {
						rtn (LOWLEVEL);
					}
					break;
				case 'm':
					if (strcmp (token, "mod") == 0) {
							/* Integer-Modulo */
						yylval.s.art.oa = op_mod;
						strcpy (yylval.s.val.ov, "%");
						rtn (MULOP);
					}
					if (strcmp (token, "module") == 0) {
						rtn (MODULE);
					}
					if (strcmp (token, "monitor") == 0) {
						rtn (MONITOR);
					}
					break;
				case 'n':
					if (strcmp (token, "new") == 0) {
						strcpy (yylval.s.val.ov, "new");
						return (NEWORDISPOSE);
					}
					if (strcmp (token, "not") == 0) {
							/* not */
						yylval.s.art.oa = op_not;
						strcpy (yylval.s.val.ov, "!");
						rtn (NOT);
					}
					break;
				case 'o':
					if (strcmp (token, "of") == 0) {
						rtn (OF);
					}
					if (strcmp (token, "or") == 0) {
							/* or */
						yylval.s.art.oa = op_or;
						strcpy (yylval.s.val.ov, "||");
						rtn (OR);
					}
					if (strcmp (token, "ord") == 0) {
						strcpy (yylval.s.val.ov, "ord");
						return (STDFKTN);
					}
					break;
				case 'p':
					if (strcmp (token, "p") == 0) {
						strcpy (yylval.s.val.ov, "P");
						rtn (PORV);
					}
					if (strcmp (token, "pointer") == 0) {
						rtn (POINTER);
					}
					if (strcmp (token, "procedure") == 0) {
						rtn (PROCEDURE);
					}
					if (strcmp (token, "processid") == 0) {
						rtn (PROCESSID);
					}
					if (strcmp (token, "processno") == 0) {
						rtn (PROCESSNO);
					}
					if (strcmp (token, "process") == 0) {
						rtn (PROCESS);
					}
					if (strcmp (token, "processor") == 0) {
						rtn (PROCESSOR);
					}
					break;
				case 'r':
					if (strcmp (token, "raise") == 0) {
						rtn (RAISE);
					}
					if (strcmp (token, "record") == 0) {
						rtn (RECORD);
					}
					if (strcmp (token, "repeat") == 0) {
						rtn (REPEAT);
					}
					if (strcmp (token, "restart") == 0) {
						rtn (RESTART);
					}
					if (strcmp (token, "resume") == 0) {
						rtn (RESUME);
					}
					if (strcmp (token, "return") == 0) {
						rtn (RETURN);
					}
					break;
				case 's':
					if (strcmp (token, "semaphore") == 0) {
						rtn (SEMAPHORE);
					}
					if (strcmp (token, "set") == 0) {
						rtn (SET);
					}
					if (strcmp (token, "signal") == 0) {
						rtn (SIGNAL);
					}
					if (strcmp (token, "start") == 0) {
						rtn (START);
					}
					if (strcmp (token, "status") == 0) {
						rtn (STATUS);
					}
					break;
				case 't':
					if (strcmp (token, "then") == 0) {
						rtn (THEN);
					}
					if (strcmp (token, "to") == 0) {
						rtn (TO);
					}
					if (strcmp (token, "trunc") == 0) {
						strcpy (yylval.s.val.ov, "trunc");
						return (STDFKTN);
					}
					if (strcmp (token, "type") == 0) {
						rtn (TYPE);
					}
					break;
				case 'u':
					if (strcmp (token, "until") == 0) {
						rtn (UNTIL);
					}
					break;
				case 'v':
					if (strcmp (token, "v") == 0) {
						strcpy (yylval.s.val.ov, "V");
						rtn (PORV);
					}
					if (strcmp (token, "val") == 0) {
						return (VAL);
					}
					if (strcmp (token, "var") == 0) {
						rtn (VAR);
					}
					break;
				case 'w':
					if (strcmp (token, "wait") == 0) {
						rtn (WAIT);
					}
					if (strcmp (token, "while") == 0) {
						rtn (WHILE);
					}
					if (strcmp (token, "with") == 0) {
						rtn (WITH);
					}
					break;
				case 'x':
					if (strcmp (token, "xor") == 0) {
							/* xor */
						yylval.s.art.oa = op_xor;
						strcpy (yylval.s.val.ov, "^");
						rtn (XOR);
					}
					break;
				}
				
				strcpy (id_name, token);
				strcpy (id_name_fuer_fehlertext, yytext);
				return (IDENT);
			}
break;
case 38:
		{
				if (listfile != NULL) {
					fprintf (listfile, "%s", yytext);
				}
			}
break;
case 39:
		{
				if (listfile != NULL) {
					int	i;

					fprintf (listfile, "\n");
					for (i = 1; i <= mc_list_level; i++) {
						fprintf (listfile, "IMPORT:\t");
					}
					fprintf (listfile, "%d:\t", ++mc_list_lineno);
				}
			}
break;
case 40:
		{		/* 1 bel. Zeichen */
				if (listfile != NULL) {
					fputc (yytext [0], listfile);
				}
				return (yytext [0]);
			}
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

yywrap()
{
	return (1);
}

int yyvstop[] = {
0,

38,
0,

38,
0,

40,
0,

38,
40,
0,

39,
0,

40,
0,

8,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

14,
40,
0,

16,
40,
0,

17,
40,
0,

40,
0,

15,
40,
0,

26,
40,
-25,
0,

40,
0,

10,
40,
0,

18,
40,
0,

12,
40,
0,

37,
40,
0,

37,
40,
0,

37,
40,
0,

37,
40,
0,

37,
40,
0,

37,
40,
0,

37,
40,
0,

38,
0,

20,
0,

23,
0,

24,
0,

19,
0,

5,
0,

7,
0,

22,
0,

21,
0,

26,
-25,
0,

6,
0,

11,
0,

9,
0,

13,
0,

37,
0,

37,
0,

37,
0,

37,
0,

37,
0,

37,
0,

37,
0,

37,
0,

37,
0,

37,
0,

37,
0,

37,
0,

37,
0,

25,
0,

21,
22,
0,

37,
0,

37,
0,

37,
0,

37,
0,

37,
0,

37,
0,

22,
0,

21,
0,

37,
-27,
0,

37,
0,

37,
0,

37,
0,

37,
-33,
0,

37,
0,

21,
22,
0,

27,
0,

37,
0,

37,
0,

37,
0,

37,
0,

37,
0,

33,
0,

37,
0,

37,
0,

37,
0,

37,
0,

37,
0,

37,
0,

37,
0,

37,
0,

37,
0,

37,
0,

37,
-29,
0,

37,
0,

37,
-31,
0,

37,
0,

37,
0,

37,
0,

37,
0,

37,
-28,
0,

29,
0,

37,
-30,
0,

31,
0,

37,
-32,
0,

37,
0,

37,
-35,
0,

37,
0,

28,
0,

30,
0,

32,
0,

37,
-34,
0,

35,
0,

37,
-36,
0,

34,
0,

36,
0,

2,
0,

1,
0,

3,
0,

4,
0,
0};
# define YYTYPE int
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	1,3,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,4,	1,5,	
30,0,	34,0,	0,0,	0,0,	
4,29,	0,0,	0,0,	84,84,	
84,84,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	1,6,	
1,7,	1,8,	1,9,	4,29,	
1,10,	1,11,	84,84,	1,12,	
1,13,	11,36,	1,14,	1,15,	
1,16,	1,17,	84,85,	1,17,	
9,33,	9,33,	0,0,	0,0,	
0,0,	0,0,	0,0,	1,18,	
0,0,	1,19,	1,20,	1,21,	
18,41,	21,44,	1,22,	1,23,	
1,24,	1,22,	1,22,	1,22,	
1,22,	1,22,	1,25,	1,22,	
0,0,	1,26,	0,0,	1,22,	
1,22,	19,42,	19,43,	1,27,	
1,28,	1,22,	24,48,	2,7,	
2,8,	2,9,	1,22,	25,50,	
2,11,	6,30,	2,12,	26,52,	
1,3,	2,14,	2,15,	2,16,	
23,46,	6,30,	6,0,	94,103,	
27,54,	28,56,	23,47,	48,64,	
25,51,	58,69,	2,18,	26,53,	
2,19,	2,20,	2,21,	69,81,	
24,49,	36,58,	24,48,	112,126,	
48,48,	81,94,	46,63,	25,50,	
113,127,	114,128,	6,31,	26,52,	
28,57,	115,129,	27,55,	6,30,	
23,46,	46,46,	126,140,	6,30,	
27,54,	28,56,	127,141,	48,64,	
6,30,	15,37,	6,30,	15,38,	
15,38,	15,38,	15,38,	15,38,	
15,38,	15,38,	15,38,	15,38,	
15,38,	49,48,	46,63,	128,142,	
129,143,	6,30,	6,30,	6,30,	
6,30,	6,30,	6,30,	6,30,	
6,30,	6,30,	6,30,	47,46,	
6,30,	50,65,	6,30,	6,30,	
54,67,	47,47,	6,30,	6,30,	
6,30,	140,148,	141,149,	142,150,	
50,50,	6,30,	53,52,	49,49,	
143,151,	49,48,	51,50,	6,30,	
8,32,	8,32,	8,32,	8,32,	
8,32,	8,32,	8,32,	8,32,	
8,32,	8,32,	53,53,	47,46,	
148,152,	50,65,	54,54,	51,51,	
54,67,	8,32,	8,32,	8,32,	
8,32,	8,32,	8,32,	10,34,	
149,153,	57,56,	53,52,	67,79,	
52,66,	150,154,	51,50,	10,34,	
10,0,	17,39,	66,78,	17,40,	
17,40,	17,40,	17,40,	17,40,	
17,40,	17,40,	17,40,	17,40,	
17,40,	52,52,	67,67,	151,155,	
57,57,	8,32,	8,32,	8,32,	
8,32,	8,32,	8,32,	152,156,	
10,34,	57,56,	66,66,	67,79,	
52,66,	10,35,	153,157,	154,158,	
155,159,	10,34,	66,78,	156,160,	
157,161,	158,162,	10,34,	159,163,	
10,34,	160,164,	161,165,	80,93,	
38,38,	38,38,	38,38,	38,38,	
38,38,	38,38,	38,38,	38,38,	
38,38,	38,38,	80,80,	10,34,	
10,34,	10,34,	10,34,	10,34,	
10,34,	10,34,	10,34,	10,34,	
10,34,	38,59,	10,34,	56,68,	
10,34,	10,34,	55,54,	162,166,	
10,34,	10,34,	10,34,	80,93,	
164,167,	165,168,	166,169,	10,34,	
103,112,	167,170,	168,171,	56,56,	
103,113,	10,34,	22,45,	22,45,	
22,45,	22,45,	22,45,	22,45,	
22,45,	22,45,	22,45,	22,45,	
55,55,	103,114,	103,115,	56,68,	
88,97,	170,172,	55,54,	22,45,	
22,45,	22,45,	22,45,	22,45,	
22,45,	22,45,	22,45,	22,45,	
22,45,	22,45,	22,45,	22,45,	
22,45,	22,45,	22,45,	22,45,	
22,45,	22,45,	22,45,	22,45,	
22,45,	22,45,	22,45,	22,45,	
22,45,	171,173,	88,88,	0,0,	
88,97,	22,45,	0,0,	22,45,	
22,45,	22,45,	22,45,	22,45,	
22,45,	22,45,	22,45,	22,45,	
22,45,	22,45,	22,45,	22,45,	
22,45,	22,45,	22,45,	22,45,	
22,45,	22,45,	22,45,	22,45,	
22,45,	22,45,	22,45,	22,45,	
22,45,	39,60,	0,0,	39,61,	
39,61,	39,61,	39,61,	39,61,	
39,61,	39,61,	39,61,	39,61,	
39,61,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	63,75,	
59,70,	64,76,	59,70,	65,77,	
39,62,	59,71,	59,71,	59,71,	
59,71,	59,71,	59,71,	59,71,	
59,71,	59,71,	59,71,	61,61,	
61,61,	61,61,	61,61,	61,61,	
61,61,	61,61,	61,61,	61,61,	
61,61,	63,63,	0,0,	0,0,	
64,64,	65,65,	0,0,	63,75,	
62,73,	64,76,	62,73,	65,77,	
61,72,	62,74,	62,74,	62,74,	
62,74,	62,74,	62,74,	62,74,	
62,74,	62,74,	62,74,	68,80,	
70,71,	70,71,	70,71,	70,71,	
70,71,	70,71,	70,71,	70,71,	
70,71,	70,71,	0,0,	72,82,	
68,68,	72,82,	0,0,	0,0,	
72,83,	72,83,	72,83,	72,83,	
72,83,	72,83,	72,83,	72,83,	
72,83,	72,83,	75,84,	75,84,	
76,86,	77,87,	86,95,	68,80,	
73,74,	73,74,	73,74,	73,74,	
73,74,	73,74,	73,74,	73,74,	
73,74,	73,74,	79,91,	79,91,	
0,0,	87,96,	90,99,	86,86,	
78,88,	75,84,	76,76,	89,98,	
95,104,	77,77,	78,89,	0,0,	
96,105,	75,85,	91,91,	91,91,	
76,86,	77,87,	86,95,	78,90,	
0,0,	79,91,	0,0,	0,0,	
89,89,	96,96,	0,0,	87,87,	
90,90,	79,92,	97,106,	0,0,	
78,78,	87,96,	90,99,	93,100,	
78,88,	91,91,	95,95,	89,98,	
95,104,	93,101,	78,89,	97,97,	
96,105,	91,92,	99,108,	100,109,	
101,110,	0,0,	93,102,	78,90,	
82,83,	82,83,	82,83,	82,83,	
82,83,	82,83,	82,83,	82,83,	
82,83,	82,83,	97,106,	93,93,	
98,107,	101,101,	102,111,	93,100,	
75,75,	104,116,	0,0,	105,117,	
105,117,	93,101,	108,122,	98,98,	
99,99,	100,100,	99,108,	100,109,	
101,110,	106,119,	93,102,	0,0,	
79,79,	0,0,	107,120,	107,120,	
104,104,	110,124,	109,123,	0,0,	
102,102,	108,108,	105,117,	111,125,	
98,107,	0,0,	102,111,	123,136,	
110,110,	104,116,	105,118,	109,109,	
0,0,	0,0,	108,122,	0,0,	
106,106,	107,120,	116,130,	116,130,	
0,0,	106,119,	117,117,	117,117,	
0,0,	107,121,	0,0,	119,132,	
119,132,	110,124,	109,123,	120,120,	
120,120,	111,111,	123,123,	111,125,	
122,134,	122,134,	125,139,	123,136,	
0,0,	116,130,	0,0,	124,137,	
124,137,	117,117,	130,130,	130,130,	
0,0,	116,131,	119,132,	0,0,	
0,0,	117,118,	120,120,	132,132,	
132,132,	125,125,	119,133,	122,134,	
134,134,	134,134,	120,121,	0,0,	
0,0,	105,105,	124,137,	122,135,	
0,0,	130,130,	125,139,	136,144,	
136,144,	0,0,	124,138,	137,137,	
137,137,	130,131,	132,132,	0,0,	
107,107,	0,0,	0,0,	134,134,	
139,146,	139,146,	132,133,	144,144,	
144,144,	146,146,	146,146,	134,135,	
0,0,	0,0,	136,144,	0,0,	
0,0,	0,0,	137,137,	0,0,	
0,0,	0,0,	136,145,	0,0,	
116,116,	0,0,	137,138,	139,146,	
0,0,	0,0,	144,144,	0,0,	
146,146,	119,119,	0,0,	139,147,	
0,0,	0,0,	144,145,	0,0,	
146,147,	0,0,	122,122,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	124,124,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	136,136,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	139,139,	0,0,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+-1,	0,		yyvstop+1,
yycrank+-52,	yysvec+1,	yyvstop+3,
yycrank+0,	0,		yyvstop+5,
yycrank+7,	0,		yyvstop+7,
yycrank+0,	0,		yyvstop+10,
yycrank+-92,	0,		yyvstop+12,
yycrank+0,	0,		yyvstop+14,
yycrank+140,	0,		yyvstop+17,
yycrank+4,	0,		yyvstop+19,
yycrank+-210,	0,		yyvstop+21,
yycrank+3,	0,		yyvstop+23,
yycrank+0,	0,		yyvstop+25,
yycrank+0,	0,		yyvstop+28,
yycrank+0,	0,		yyvstop+31,
yycrank+95,	0,		yyvstop+34,
yycrank+0,	0,		yyvstop+36,
yycrank+175,	0,		yyvstop+39,
yycrank+3,	0,		yyvstop+43,
yycrank+20,	0,		yyvstop+45,
yycrank+0,	0,		yyvstop+48,
yycrank+4,	0,		yyvstop+51,
yycrank+258,	0,		yyvstop+54,
yycrank+11,	yysvec+22,	yyvstop+57,
yycrank+21,	yysvec+22,	yyvstop+60,
yycrank+13,	yysvec+22,	yyvstop+63,
yycrank+16,	yysvec+22,	yyvstop+66,
yycrank+35,	yysvec+22,	yyvstop+69,
yycrank+33,	yysvec+22,	yyvstop+72,
yycrank+0,	yysvec+4,	yyvstop+75,
yycrank+-2,	yysvec+6,	0,	
yycrank+0,	0,		yyvstop+77,
yycrank+0,	yysvec+8,	yyvstop+79,
yycrank+0,	yysvec+9,	yyvstop+81,
yycrank+-3,	yysvec+10,	0,	
yycrank+0,	0,		yyvstop+83,
yycrank+2,	0,		yyvstop+85,
yycrank+0,	0,		yyvstop+87,
yycrank+216,	0,		yyvstop+89,
yycrank+335,	0,		yyvstop+91,
yycrank+0,	yysvec+17,	yyvstop+93,
yycrank+0,	0,		yyvstop+96,
yycrank+0,	0,		yyvstop+98,
yycrank+0,	0,		yyvstop+100,
yycrank+0,	0,		yyvstop+102,
yycrank+0,	yysvec+22,	yyvstop+104,
yycrank+38,	yysvec+22,	yyvstop+106,
yycrank+78,	yysvec+22,	yyvstop+108,
yycrank+25,	yysvec+22,	yyvstop+110,
yycrank+88,	yysvec+22,	yyvstop+112,
yycrank+85,	yysvec+22,	yyvstop+114,
yycrank+108,	yysvec+22,	yyvstop+116,
yycrank+138,	yysvec+22,	yyvstop+118,
yycrank+103,	yysvec+22,	yyvstop+120,
yycrank+107,	yysvec+22,	yyvstop+122,
yycrank+221,	yysvec+22,	yyvstop+124,
yycrank+208,	yysvec+22,	yyvstop+126,
yycrank+141,	yysvec+22,	yyvstop+128,
yycrank+5,	0,		0,	
yycrank+357,	0,		0,	
yycrank+0,	0,		yyvstop+130,
yycrank+367,	0,		yyvstop+132,
yycrank+389,	0,		0,	
yycrank+330,	yysvec+22,	yyvstop+135,
yycrank+333,	yysvec+22,	yyvstop+137,
yycrank+334,	yysvec+22,	yyvstop+139,
yycrank+151,	yysvec+22,	yyvstop+141,
yycrank+139,	yysvec+22,	yyvstop+143,
yycrank+365,	yysvec+22,	yyvstop+145,
yycrank+4,	0,		0,	
yycrank+400,	0,		0,	
yycrank+0,	yysvec+70,	yyvstop+147,
yycrank+416,	0,		0,	
yycrank+432,	0,		0,	
yycrank+0,	yysvec+73,	yyvstop+149,
yycrank+465,	yysvec+22,	yyvstop+151,
yycrank+403,	yysvec+22,	yyvstop+154,
yycrank+406,	yysvec+22,	yyvstop+156,
yycrank+429,	yysvec+22,	yyvstop+158,
yycrank+481,	yysvec+22,	yyvstop+160,
yycrank+179,	yysvec+22,	yyvstop+163,
yycrank+2,	0,		0,	
yycrank+496,	0,		0,	
yycrank+0,	yysvec+82,	yyvstop+165,
yycrank+10,	0,		0,	
yycrank+0,	0,		yyvstop+168,
yycrank+400,	yysvec+22,	yyvstop+170,
yycrank+424,	yysvec+22,	yyvstop+172,
yycrank+255,	yysvec+22,	yyvstop+174,
yycrank+421,	yysvec+22,	yyvstop+176,
yycrank+425,	yysvec+22,	yyvstop+178,
yycrank+497,	0,		0,	
yycrank+0,	0,		yyvstop+180,
yycrank+460,	yysvec+22,	yyvstop+182,
yycrank+8,	0,		0,	
yycrank+435,	yysvec+22,	yyvstop+184,
yycrank+422,	yysvec+22,	yyvstop+186,
yycrank+440,	yysvec+22,	yyvstop+188,
yycrank+472,	yysvec+22,	yyvstop+190,
yycrank+473,	yysvec+22,	yyvstop+192,
yycrank+474,	yysvec+22,	yyvstop+194,
yycrank+462,	yysvec+22,	yyvstop+196,
yycrank+489,	yysvec+22,	yyvstop+198,
yycrank+202,	0,		0,	
yycrank+485,	yysvec+22,	yyvstop+200,
yycrank+554,	yysvec+22,	yyvstop+202,
yycrank+505,	yysvec+22,	yyvstop+205,
yycrank+569,	yysvec+22,	yyvstop+207,
yycrank+490,	yysvec+22,	yyvstop+210,
yycrank+500,	yysvec+22,	yyvstop+212,
yycrank+497,	yysvec+22,	yyvstop+214,
yycrank+522,	yysvec+22,	yyvstop+216,
yycrank+11,	0,		0,	
yycrank+19,	0,		0,	
yycrank+4,	0,		0,	
yycrank+8,	0,		0,	
yycrank+593,	yysvec+22,	yyvstop+218,
yycrank+597,	0,		0,	
yycrank+0,	0,		yyvstop+221,
yycrank+602,	yysvec+22,	yyvstop+223,
yycrank+606,	0,		0,	
yycrank+0,	0,		yyvstop+226,
yycrank+611,	yysvec+22,	yyvstop+228,
yycrank+523,	yysvec+22,	yyvstop+231,
yycrank+618,	yysvec+22,	yyvstop+233,
yycrank+546,	yysvec+22,	yyvstop+236,
yycrank+23,	0,		0,	
yycrank+30,	0,		0,	
yycrank+46,	0,		0,	
yycrank+44,	0,		0,	
yycrank+621,	0,		0,	
yycrank+0,	0,		yyvstop+238,
yycrank+630,	0,		0,	
yycrank+0,	0,		yyvstop+240,
yycrank+635,	0,		0,	
yycrank+0,	0,		yyvstop+242,
yycrank+646,	yysvec+22,	yyvstop+244,
yycrank+650,	0,		0,	
yycrank+0,	0,		yyvstop+247,
yycrank+659,	yysvec+22,	yyvstop+249,
yycrank+78,	0,		0,	
yycrank+77,	0,		0,	
yycrank+81,	0,		0,	
yycrank+83,	0,		0,	
yycrank+662,	0,		0,	
yycrank+0,	0,		yyvstop+252,
yycrank+664,	0,		0,	
yycrank+0,	0,		yyvstop+254,
yycrank+93,	0,		0,	
yycrank+102,	0,		0,	
yycrank+101,	0,		0,	
yycrank+120,	0,		0,	
yycrank+135,	0,		0,	
yycrank+153,	0,		0,	
yycrank+153,	0,		0,	
yycrank+210,	0,		0,	
yycrank+150,	0,		0,	
yycrank+147,	0,		0,	
yycrank+149,	0,		0,	
yycrank+218,	0,		0,	
yycrank+146,	0,		0,	
yycrank+161,	0,		0,	
yycrank+249,	0,		0,	
yycrank+0,	0,		yyvstop+256,
yycrank+180,	0,		0,	
yycrank+182,	0,		0,	
yycrank+257,	0,		0,	
yycrank+259,	0,		0,	
yycrank+260,	0,		0,	
yycrank+0,	0,		yyvstop+258,
yycrank+280,	0,		0,	
yycrank+308,	0,		0,	
yycrank+0,	0,		yyvstop+260,
yycrank+0,	0,		yyvstop+262,
0,	0,	0};
struct yywork *yytop = yycrank+754;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,'"' ,01  ,01  ,01  ,01  ,047 ,
01  ,01  ,01  ,'+' ,01  ,'+' ,01  ,01  ,
'0' ,'0' ,'2' ,'2' ,'2' ,'2' ,'2' ,'2' ,
'2' ,'2' ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,'A' ,'B' ,'C' ,'D' ,'E' ,'F' ,'G' ,
'H' ,'I' ,'J' ,'J' ,'L' ,'J' ,'N' ,'O' ,
'J' ,'J' ,'R' ,'S' ,'T' ,'J' ,'J' ,'J' ,
'J' ,'Y' ,'J' ,01  ,01  ,01  ,01  ,'_' ,
01  ,'A' ,'B' ,'C' ,'D' ,'E' ,'F' ,'G' ,
'H' ,'I' ,'J' ,'J' ,'L' ,'J' ,'N' ,'O' ,
'J' ,'J' ,'R' ,'S' ,'T' ,'J' ,'J' ,'J' ,
'J' ,'Y' ,'J' ,01  ,01  ,01  ,01  ,01  ,
0};
char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,0,1,1,1,1,1,
1,1,1,1,1,0,0,0,
0,0,0,0,0,0,0,0,
0};
#ifndef lint
static	char ncform_sccsid[] = "@(#)ncform 1.6 88/02/08 SMI"; /* from S5R2 1.2 */
#endif

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
