WS	[ \t]*
WSNL	[ \t\n]*

%{
/*


****************************************************************************
  THIS SOURCE FILE MUST BE RUN WITH lex ON A SUN WORKSTATION
                                             ===============
  BECAUSE WHEN RUN ON A RS/6000 THE GENERATED FILE lex.yy.c
                        =======
  CANNOT BE COMPILED WITH cc ON A SUN WITHOUT ERRORS
                                              ======
  RUNNING LEX ON A SUN CAUSES NO ERRORS NEITHER ON A RS/6000
  NOR ON THE SUN ITSELF
****************************************************************************




Zum DEBUG:
Variable debug muss ein paar Zeilen unter 'int debug;' auf 1 gesetzt werden
# define LEXDEBUG 1
# define sprint(s)	{printf ("%s", s); }
# define allprint(c)	{printf ("%c (%d)", c, c); }
*/

#include "symbtbl.h"
#include "mc.h"
#include "os.h"
#include "mctypes.h"

#ifdef MSDOS
# include "y_tab.h"
#else
# include "y.tab.h"
#endif


#define	rtn(t) {\
	if (lowercase_flag) {\
		message (D_WARN, "yylex: Token '%s' is a reserved word. It must be written uppercase", yytext);\
	}\
	return (t);\
}

#define list() {\
	if (listfile != NULL) {\
		strcpy (lsttxt, yytext);\
		plsttxt1 = lsttxt;\
		do {\
			plsttxt2 = strchr (plsttxt1, '\n');\
			if (plsttxt2 != NULL) {\
				*plsttxt2 = '\0';\
			}\
			fprintf (listfile, "%s", plsttxt1);\
			if (plsttxt2 != NULL) {\
				int	i;\
				fprintf (listfile, "\n");\
				for (i = 1; i <= mc_list_level; i++) {\
					fprintf (listfile, "IMPORT:\t");\
				}\
				fprintf (listfile, "%d:\t", ++mc_list_lineno);\
				plsttxt1 = plsttxt2 + 1;\
			}\
		} while (plsttxt2 != NULL);\
	}\
}
	


#define mklowercase(t, y) {\
	list ();\
	lowercase_flag = 0;\
	strcpy (t, y);\
	for (pc = t; pc [0]; pc++) {\
		while (pc [0] == '_') {\
			lowercase_flag = 1;\
			for (i=0; pc [i]; i++) {\
				pc[i] = pc [i+1];\
			}\
		}\
		if (pc [0] >= 'A' && pc [0] <= 'Z') {\
			pc[0] = pc [0] - 'A' + 'a';\
		} else if (pc [0] < '0' || pc [0] > '9') {\
			lowercase_flag = 1;\
		}\
	}\
}

char	id_name[YYLMAX + 5];	/* zum Anhaengen von ".mod" beim Import */
char	id_name_fuer_fehlertext[YYLMAX];
int	max_token_length = YYLMAX;
static	char	string_inhalt[YYLMAX];
static	char	token[YYLMAX];	/* zur Eliminierung von '_' und zur
				 * Gross-/Kleinschrift-Anpassung */
static	char	lsttxt[YYLMAX], *plsttxt1, *plsttxt2;	/* zur Ausgabe des Listings */
static	char	*pc;
static	int	i;
static	int	lowercase_flag;	/* siehe define rtn (fuer Uppercase-Warnings) */


void
lex_unput_char(c)
	char	c;
{
	unput (c);	/* unput is a macro defined by lex itself --> see generated code */
}

%}

	int	com_deep = 0;

%%

\(\*show_symbtbl\*\)	{
				list ();
				
				show_symbtbl ();
			}

\(\*show_types\*\)	{
				list ();

				show_types ();
			}

\(\*show_blocklist\*\)	{
				list ();

				show_blocklist ((BlockType) 0);
			}

\(\*show_filenames\*\)	{
				list ();

				show_filenames ();
			}

\(\*			{	/*
				 * Kommentarbeginn erkannt
				 */
				char	nextc;

				list ();
				c_out ("/*");
				com_deep++;

				while (com_deep) {
					nextc = input ();
					if (nextc == '\0') {
						message (D_FATAL, "yylex: Unexpected End of File");
					} else if (nextc == '*') {
						nextc = input ();
						if (nextc == ')') {
								/* Kommentarende erkannt */
							if (listfile != NULL) {
								fprintf (listfile, "*)");
							}
							com_deep--;
							if (com_deep == 0) {
								c_out ("*/");
								break;
							} else {
								c_out ("*)");
							}
						} else if (nextc == '/') {
							if (listfile != NULL) {
								fprintf (listfile, "*/");
							}
								/* C-Kommentarende wird maskiert */
							c_out ("* ");
								/* Zweites Zeichen wird zurueckgeschrieben fuer neuen Test */
							unput (nextc);
						} else if (nextc == '*' || nextc == '(') {
							if (listfile != NULL) {
								fputc ('*', listfile);
							}
							c_out ("*");
								/* Zweites Zeichen wird zurueckgeschrieben fuer neuen Test */
							unput (nextc);
						} else {
							if (listfile != NULL) {
								fprintf (listfile, "*%c", nextc);
								if (nextc == '\n') {
									int	i;

									for (i = 1; i <= mc_list_level; i++) {
										fprintf (listfile, "IMPORT:\t");
									}
									fprintf (listfile, "%d:\t", ++mc_list_lineno);
								}
							}
							c_out ("*%c", nextc);
						}
					} else if (nextc == '/') {
						nextc = input ();
						if (nextc == '*') {
							if (listfile != NULL) {
								fputc ('/', listfile);
							}
								/* C-Kommentarbeginn wird maskiert */
							c_out ("/ ");
								/* Zweites Zeichen wird zurueckgeschrieben fuer neuen Test */
							unput (nextc);
						} else if (nextc == '/' || nextc == '(') {
							if (listfile != NULL) {
								fputc ('/', listfile);
							}
							c_out ("/");
								/* Zweites Zeichen wird zurueckgeschrieben fuer neuen Test */
							unput (nextc);
						} else {
							if (listfile != NULL) {
								fprintf (listfile, "/%c", nextc);
								if (nextc == '\n') {
									int	i;

									for (i = 1; i <= mc_list_level; i++) {
										fprintf (listfile, "IMPORT:\t");
									}
									fprintf (listfile, "%d:\t", ++mc_list_lineno);
								}
							}
							c_out ("/%c", nextc);
						}
					} else if (nextc == '(') {
						nextc = input ();
						if (nextc == '*') {
							if (listfile != NULL) {
								fprintf (listfile, "(*");
							}
								/* weiterer Kommentarbeginn erkannt */
							c_out ("(*");
							com_deep++;
						} else if (nextc == '/' || nextc == '(') {
							if (listfile != NULL) {
								fputc ('(', listfile);
							}
							c_out ("(");
								/* Zweites Zeichen wird zurueckgeschrieben fuer neuen Test */
							unput (nextc);
						} else {
							if (listfile != NULL) {
								fprintf (listfile, "(%c", nextc);
								if (nextc == '\n') {
									int	i;

									for (i = 1; i <= mc_list_level; i++) {
										fprintf (listfile, "IMPORT:\t");
									}
									fprintf (listfile, "%d:\t", ++mc_list_lineno);
								}
							}
							c_out ("(%c", nextc);
						}
					} else {
						if (listfile != NULL) {
							fputc (nextc, listfile);
							if (nextc == '\n') {
								int	i;

								for (i = 1; i <= mc_list_level; i++) {
									fprintf (listfile, "IMPORT:\t");
								}
								fprintf (listfile, "%d:\t", ++mc_list_lineno);
							}
						}
						c_out ("%c", nextc);
					}
				}
					/*
					 * Newline hinter Kommentar-Ende wird
					 * ausgegeben, falls vorhanden
					 */
				for ( ; ; ) {
					nextc = input ();
					if (nextc == '\0') {
						message (D_FATAL, "yylex: Unexpected End of File");
					} else if (nextc == ' ' || nextc == '\t') {
						if (listfile != NULL) {
							fputc (nextc, listfile);
						}
						/* Whitespace wird ignoriert */
					} else if (nextc == '\n') {
						if (listfile != NULL) {
							int	i;

							fprintf (listfile, "\n");
							for (i = 1; i <= mc_list_level; i++) {
								fprintf (listfile, "IMPORT:\t");
							}
							fprintf (listfile, "%d:\t", ++mc_list_lineno);
						}
						c_out_lf ();
					} else {
						/* Abbruch, weil Zeichen erkannt */
						break;
					}
				}
					/* Rueckschreiben des zuletzt erkannten Zeichens */
				unput (nextc);
				c_out_lineno ();
			}


:=			{
				list ();
				
				return (ASSIGNMENTOP);
			}

\.\.			{
				list ();

				return (TWOSINGLEDOTS);
			}


#			|
\<\>			{		/* not equal */

				list ();

				yylval.s.art.oa = op_ungleich;
				strcpy (yylval.s.val.ov, "!=");
				return (RELOP);
			}

\<			{		/* kleiner */

				list ();

				yylval.s.art.oa = op_kleiner;
				strcpy (yylval.s.val.ov, "<");
				return (RELOP);
			}

\<=			{		/* kleiner gleich */

				list ();

				yylval.s.art.oa = op_kleinergleich;
				strcpy (yylval.s.val.ov, "<=");
				return (RELOP);
			}

\>			{		/* groesser */

				list ();

				yylval.s.art.oa = op_groesser;
				strcpy (yylval.s.val.ov, ">");
				return (RELOP);
			}

\>=			{		/* groesser gleich */

				list ();

				yylval.s.art.oa = op_groessergleich;
				strcpy (yylval.s.val.ov, ">=");
				return (RELOP);
			}

\*			{		/* mal */

				list ();

				yylval.s.art.oa = op_mal;
				strcpy (yylval.s.val.ov, "*");
				return (MULOP);
			}

\/			{		/* (real) geteilt */

				list ();

				yylval.s.art.oa = op_geteilt;
				strcpy (yylval.s.val.ov, "/");
				return (MULOP);
			}

\+			{		/* plus */

				list ();

				yylval.s.art.oa = op_plus;
				strcpy (yylval.s.val.ov, "+");
				return (PLUSMINUS);
			}

-			{		/* minus */

				list ();

				yylval.s.art.oa = op_minus;
				strcpy (yylval.s.val.ov, "-");
				return (PLUSMINUS);
			}


=			{		/* Vergleichsoperator und
					 * Zuweisungsoperator bei
					 * Deklarationen von Konstanten, ... */

				list ();
					 
				yylval.s.art.oa = op_gleich;
				strcpy (yylval.s.val.ov, "==");
				return ((int) '=');
			}

\'[^\'\n]*\'		|
\"[^\"\n]*\"		{
				list ();
				
					/* Anfuehrungszeichen werden eliminiert */
				strcpy (string_inhalt, yytext + 1);
				string_inhalt [strlen (string_inhalt) - 1] = '\0';

				yylval.s.flag.is_const = 1;
				if (strlen (string_inhalt) == 1) {
					if ((yylval.s.art.stbltyp = symbtbllookup ("char")) == NULL) {
						message (D_FATAL, "yylex (STRING): Char-Type not found");
					}
					yylval.s.val.lv = string_inhalt [0];
				} else {
					if ((yylval.s.art.stbltyp = symbtbllookup ("STRING")) == NULL) {
						message (D_FATAL, "yylex (STRING): STRING-Type not found");
					}
					yylval.s.val.sv = strsave (string_inhalt);
				}

				return (STRING);
			}

([0-9]+\.[0-9]*(E([\+\-])?[0-9]+)?) |
([0-9]*\.[0-9]+(E([\+\-])?[0-9]+)?) {
				list ();

				yylval.s.flag.is_const = 1;
				if ((yylval.s.art.stbltyp = symbtbllookup ("shortreal")) == NULL) {
					message (D_FATAL, "yylex (REALNUMBER): SHORTREAL-Type not found");
				}
				sscanf (yytext, "%lf", &yylval.s.val.dv);
				return (REALNUMBER);
			}

\$[0-9A-Fa-f]+		{
				list ();

				yylval.s.flag.is_const = 1;
				yylval.s.val.lv = 0;
				if (strlen (yytext) > 9) {
					message (D_ERROR, "yylex: HEXADECIMAL-Constant '%s' too big (> 4 Byte)", yytext);
					yylval.s.art.stbltyp = unsigned_const_stbltyp (yylval.s.val.lv);
					return (INTNUMBER);
				}
				sscanf (yytext + 1, "%lX", &yylval.s.val.lv);
				yylval.s.art.stbltyp = unsigned_const_stbltyp (yylval.s.val.lv);

				return (INTNUMBER);
			}

%[01]+			{	int	i;

				list ();

				yylval.s.flag.is_const = 1;
				yylval.s.val.lv = 0;
				if (strlen (yytext) > 33) {
					message (D_ERROR, "yylex: BINARY-Constant '%s' too big (> 32 Bit)", yytext);
					yylval.s.art.stbltyp = unsigned_const_stbltyp (yylval.s.val.lv);
					return (INTNUMBER);
				}
				for (i = 1; i < strlen (yytext); i++) {
					yylval.s.val.lv <<= 1;
					if (yytext [i] == '1') {
						yylval.s.val.lv |= 1;
					}
				}
				yylval.s.art.stbltyp = unsigned_const_stbltyp (yylval.s.val.lv);

				return (INTNUMBER);
			}

[0-9]+/\.\.		|
[0-9]+			{	char	c[50];

				list ();

				yylval.s.flag.is_const = 1;
				
				sprintf (c, "%lu", m0_maxlongcard);
				if (strlen (yytext) > strlen (c) || (strlen (yytext) == strlen (c) && strcmp (yytext, c) > 0)) {
										/* groesser als maxlongcard --> real */
					sscanf (yytext, "%lf", &yylval.s.val.dv);
					message (D_WARN, "yylex: DECIMAL-Constant '%s' too big; treated as REALNUMBER", yytext);
					if ((yylval.s.art.stbltyp = symbtbllookup ("shortreal")) == NULL) {
						message (D_FATAL, "yylex (DECIMAL): SHORTREAL-Type not found");
					}
					return (REALNUMBER);
				}
				sscanf (yytext, "%ld", &yylval.s.val.lv);
				yylval.s.art.stbltyp = unsigned_const_stbltyp (yylval.s.val.lv);

				return (INTNUMBER);
			}

[Bb]_*[Yy]_*[Tt]_*[Ee]_*/{WSNL}*\(					|
[Cc]_*[Aa]_*[Rr]_*[Dd]_*[Ii]_*[Nn]_*[Aa]_*[Ll]_*/{WSNL}*\(		|
[Ii]_*[Nn]_*[Tt]_*[Ee]_*[Gg]_*[Ee]_*[Rr]_*/{WSNL}*\(			|
[Ll]_*[Oo]_*[Nn]_*[Gg]_*[Cc]_*[Aa]_*[Rr]_*[Dd]_*/{WSNL}*\(		|
[Ll]_*[Oo]_*[Nn]_*[Gg]_*[Ii]_*[Nn]_*[Tt]_*/{WSNL}*\(			|
[Ll]_*[Oo]_*[Nn]_*[Gg]_*[Rr]_*[Ee]_*[Aa]_*[Ll]_*/{WSNL}*\(		|
[Rr]_*[Ee]_*[Aa]_*[Ll]_*/{WSNL}*\(					|
[Ss]_*[Hh]_*[Oo]_*[Rr]_*[Tt]_*[Cc]_*[Aa]_*[Rr]_*[Dd]_*/{WSNL}*\(	|
[Ss]_*[Hh]_*[Oo]_*[Rr]_*[Tt]_*[Ii]_*[Nn]_*[Tt]_*/{WSNL}*\(		|
[Ss]_*[Hh]_*[Oo]_*[Rr]_*[Tt]_*[Rr]_*[Ee]_*[Aa]_*[Ll]_*/{WSNL}*\(	{
				/*
				 * Typname in der Rolle als
				 * Typ-Umwandlungs-Funktions-Aufruf
				 * wird erkannt durch Lookahead '{WSNL}*\('
				 */

				mklowercase (token, yytext);

				if (strncmp (token, "byte", 4) == 0) {
					strcpy (yylval.s.val.ov, "0_byte");
				} else if (strncmp (token, "cardinal", 8) == 0) {
					strcpy (yylval.s.val.ov, "0_cardinal");
				} else if (strncmp (token, "integer", 7) == 0) {
					strcpy (yylval.s.val.ov, "0_integer");
				} else if (strncmp (token, "longcard", 8) == 0) {
					strcpy (yylval.s.val.ov, "0_longcard");
				} else if (strncmp (token, "longint", 7) == 0) {
					strcpy (yylval.s.val.ov, "0_longint");
				} else if (strncmp (token, "longreal", 8) == 0) {
					strcpy (yylval.s.val.ov, "0_longreal");
				} else if (strncmp (token, "real", 4) == 0) {
					strcpy (yylval.s.val.ov, "0_real");
				} else if (strncmp (token, "shortcard", 9) == 0) {
					strcpy (yylval.s.val.ov, "0_shortcard");
				} else if (strncmp (token, "shortint", 8) == 0) {
					strcpy (yylval.s.val.ov, "0_shortint");
				} else if (strncmp (token, "shortreal", 9) == 0) {
					strcpy (yylval.s.val.ov, "0_shortreal");
				} else {
					strcpy (yylval.s.val.ov, "0");
					/* liefert im Yacc-File eine Fehlermeldung */
				}
				rtn (STDFKTN);
			}

[A-Za-z][A-Za-z0-9_]*	{	/*
				 * In Identifiern werden grundsaetzlich 
				 * Unterstreichungszeichen '_' entfernt,
				 * da diese nicht signifikant sind, sowie
				 * Grossbuchstaben in Kleinbuchstaben
				 * umgewandelt !!!
				 */

				mklowercase (token, yytext);

				switch (token [0]) {	/* Reserved Names */
				default:
					break;
				case 'a':
					if (strcmp (token, "and") == 0) {
							/* and */
						yylval.s.art.oa = op_and;
						strcpy (yylval.s.val.ov, "&&");
						rtn (AND);
					}
					if (strcmp (token, "array") == 0) {
						rtn (ARRAY);
					}
					break;
				case 'b':
					if (strcmp (token, "begin") == 0) {
						rtn (BEG);
					}
					if (strcmp (token, "boolean") == 0) {
						rtn (BOOLEAN);
					}
					if (strcmp (token, "by") == 0) {
						rtn (BY);
					}
					break;
				case 'c':
					if (strcmp (token, "case") == 0) {
						rtn (CASE);
					}
					if (strcmp (token, "call") == 0) {
						rtn (CALL);
					}
					if (strcmp (token, "chr") == 0) {
						strcpy (yylval.s.val.ov, "chr");
						return (STDFKTN);
					}
					if (strcmp (token, "communication") == 0) {
						rtn (COMMUNICATION);
					}
					if (strcmp (token, "computer") == 0) {
						rtn (COMPUTER);
					}
					if (strcmp (token, "condition") == 0) {
						rtn (CONDITION);
					}
					if (strcmp (token, "const") == 0) {
						rtn (CONST);
					}
					break;
				case 'd':
					if (strcmp (token, "dec") == 0) {
						strcpy (yylval.s.val.ov, "dec");
						return (STDFKTN);
					}
					if (strcmp (token, "disable") == 0) {
						rtn (DISABLE);
					}
					if (strcmp (token, "dispose") == 0) {
						strcpy (yylval.s.val.ov, "dispose");
						return (NEWORDISPOSE);
					}
					if (strcmp (token, "div") == 0) {
							/* Integer-Division */
						yylval.s.art.oa = op_div;
						strcpy (yylval.s.val.ov, "/");
						rtn (MULOP);
					}
					if (strcmp (token, "do") == 0) {
						rtn (DO);
					}
					break;
				case 'e':
					if (strcmp (token, "else") == 0) {
						rtn (ELSE);
					}
					if (strcmp (token, "elsif") == 0) {
						rtn (ELSIF);
					}
					if (strcmp (token, "enable") == 0) {
						rtn (ENABLE);
					}
					if (strcmp (token, "end") == 0) {
						rtn (END);
					}
					if (strcmp (token, "entry") == 0) {
						rtn (ENTRY);
					}
					if (strcmp (token, "event") == 0) {
						rtn (EVENT);
					}
					if (strcmp (token, "exceptno") == 0) {
						rtn (EXCEPTNO);
					}
					if (strcmp (token, "exception") == 0) {
						rtn (EXCEPTION);
					}
					if (strcmp (token, "exit") == 0) {
						rtn (EXIT);
					}
					if (strcmp (token, "export") == 0) {
						rtn (EXPORT);
					}
					if (strcmp (token, "external") == 0) {
						rtn (EXTERNAL);
					}
					break;
				case 'f':
					if (strcmp (token, "float") == 0) {
						strcpy (yylval.s.val.ov, "float");
						return (STDFKTN);
					}
					if (strcmp (token, "for") == 0) {
						rtn (FOR);
					}
					if (strcmp (token, "forward") == 0) {
						rtn (FORWARD);
					}
					break;
				case 'h':
					if (strcmp (token, "halt") == 0) {
						return (HALT);
					}
					if (strcmp (token, "high") == 0) {
						return (HIGH);
					}
					break;
				case 'i':
					if (strcmp (token, "if") == 0) {
						rtn (IF);
					}
					if (strcmp (token, "implementation") == 0) {
						rtn (IMPLEMENTATION);
					}
					if (strcmp (token, "import") == 0) {
						rtn (IMPORT);
					}
					if (strcmp (token, "in") == 0) {
							/* Mengen-Operator */
						yylval.s.art.oa = op_in;
						strcpy (yylval.s.val.ov, "&");
						rtn (RELOP);
					}
					if (strcmp (token, "inc") == 0) {
						strcpy (yylval.s.val.ov, "inc");
						return (STDFKTN);
					}
					if (strcmp (token, "initcom") == 0) {
						return (INITCOM);
					}
					if (strcmp (token, "interrupt") == 0) {
						rtn (INTERRUPT);
					}
					break;
				case 'l':
					if (strcmp (token, "loop") == 0) {
						rtn (LOOP);
					}
					if (strcmp (token, "lowlevel") == 0) {
						rtn (LOWLEVEL);
					}
					break;
				case 'm':
					if (strcmp (token, "mod") == 0) {
							/* Integer-Modulo */
						yylval.s.art.oa = op_mod;
						strcpy (yylval.s.val.ov, "%");
						rtn (MULOP);
					}
					if (strcmp (token, "module") == 0) {
						rtn (MODULE);
					}
					if (strcmp (token, "monitor") == 0) {
						rtn (MONITOR);
					}
					break;
				case 'n':
					if (strcmp (token, "new") == 0) {
						strcpy (yylval.s.val.ov, "new");
						return (NEWORDISPOSE);
					}
					if (strcmp (token, "not") == 0) {
							/* not */
						yylval.s.art.oa = op_not;
						strcpy (yylval.s.val.ov, "!");
						rtn (NOT);
					}
					break;
				case 'o':
					if (strcmp (token, "of") == 0) {
						rtn (OF);
					}
					if (strcmp (token, "or") == 0) {
							/* or */
						yylval.s.art.oa = op_or;
						strcpy (yylval.s.val.ov, "||");
						rtn (OR);
					}
					if (strcmp (token, "ord") == 0) {
						strcpy (yylval.s.val.ov, "ord");
						return (STDFKTN);
					}
					break;
				case 'p':
					if (strcmp (token, "p") == 0) {
						strcpy (yylval.s.val.ov, "P");
						rtn (PORV);
					}
					if (strcmp (token, "pointer") == 0) {
						rtn (POINTER);
					}
					if (strcmp (token, "procedure") == 0) {
						rtn (PROCEDURE);
					}
					if (strcmp (token, "processid") == 0) {
						rtn (PROCESSID);
					}
					if (strcmp (token, "processno") == 0) {
						rtn (PROCESSNO);
					}
					if (strcmp (token, "process") == 0) {
						rtn (PROCESS);
					}
					if (strcmp (token, "processor") == 0) {
						rtn (PROCESSOR);
					}
					break;
				case 'r':
					if (strcmp (token, "raise") == 0) {
						rtn (RAISE);
					}
					if (strcmp (token, "record") == 0) {
						rtn (RECORD);
					}
					if (strcmp (token, "repeat") == 0) {
						rtn (REPEAT);
					}
					if (strcmp (token, "restart") == 0) {
						rtn (RESTART);
					}
					if (strcmp (token, "resume") == 0) {
						rtn (RESUME);
					}
					if (strcmp (token, "return") == 0) {
						rtn (RETURN);
					}
					break;
				case 's':
					if (strcmp (token, "semaphore") == 0) {
						rtn (SEMAPHORE);
					}
					if (strcmp (token, "set") == 0) {
						rtn (SET);
					}
					if (strcmp (token, "signal") == 0) {
						rtn (SIGNAL);
					}
					if (strcmp (token, "start") == 0) {
						rtn (START);
					}
					if (strcmp (token, "status") == 0) {
						rtn (STATUS);
					}
					break;
				case 't':
					if (strcmp (token, "then") == 0) {
						rtn (THEN);
					}
					if (strcmp (token, "to") == 0) {
						rtn (TO);
					}
					if (strcmp (token, "trunc") == 0) {
						strcpy (yylval.s.val.ov, "trunc");
						return (STDFKTN);
					}
					if (strcmp (token, "type") == 0) {
						rtn (TYPE);
					}
					break;
				case 'u':
					if (strcmp (token, "until") == 0) {
						rtn (UNTIL);
					}
					break;
				case 'v':
					if (strcmp (token, "v") == 0) {
						strcpy (yylval.s.val.ov, "V");
						rtn (PORV);
					}
					if (strcmp (token, "val") == 0) {
						return (VAL);
					}
					if (strcmp (token, "var") == 0) {
						rtn (VAR);
					}
					break;
				case 'w':
					if (strcmp (token, "wait") == 0) {
						rtn (WAIT);
					}
					if (strcmp (token, "while") == 0) {
						rtn (WHILE);
					}
					if (strcmp (token, "with") == 0) {
						rtn (WITH);
					}
					break;
				case 'x':
					if (strcmp (token, "xor") == 0) {
							/* xor */
						yylval.s.art.oa = op_xor;
						strcpy (yylval.s.val.ov, "^");
						rtn (XOR);
					}
					break;
				}
				
				strcpy (id_name, token);
				strcpy (id_name_fuer_fehlertext, yytext);
				return (IDENT);
			}


{WS}			{
				if (listfile != NULL) {
					fprintf (listfile, "%s", yytext);
				}
			}

\n			{
				if (listfile != NULL) {
					int	i;

					fprintf (listfile, "\n");
					for (i = 1; i <= mc_list_level; i++) {
						fprintf (listfile, "IMPORT:\t");
					}
					fprintf (listfile, "%d:\t", ++mc_list_lineno);
				}
			}

.			{		/* 1 bel. Zeichen */
				if (listfile != NULL) {
					fputc (yytext [0], listfile);
				}
				return (yytext [0]);
			}

%%

yywrap()
{
	return (1);
}

