/* Parallaxis Version: @(#)conf.h	2.13  2/28/92 14:46:02  */
/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : conf.h                                                            */
/*                                                                           */
/* Definitionen f"ur die Konfigurations- und -gruppeninformationen           */
/*                                                                           */
/* ************************************************************************* */


typedef struct c_group {
    struct c_group * link;
    struct c_group * next;
    int group_nr;          /* Nummer der Konfigurationsgruppe */
    int proz_anz;          /* Zahl der Prozessoren in der Gruppe */
    int port_anz;          /* Zahl der Ports in der Gruppe */
    int conf_anf;          /* Nummer der ersten Konfiguration der Gruppe */
    int conf_end;          /* Nummer der letzten Konfiguration der Gruppe */
    struct c_conf * conf;  /* Liste der Konfigurationen der Gruppe */
    ST * vectors;          /* Symboltabelle der Vektorvariablen und Ports */
    int first_proz;        /* Nummer des ersten Prozessors der Konfiguration */
    int dims;              /* maximale Zahl der Dimensionen */
    int max_dim;           /* maximale Zahl der aller Dimensionen */
    int initport;          /* PARZ-Label der Berechnung der Verbindungen */
    int zeilen;            /* Zahl der Labels zur Berechnung der Verbindungen */
    int port_variable;     /* Zahl der dynamischen Auto-Ziel-Ports */
    struct zwcode * code;  /* Kode fuer die Berechnung der Verbindungen */
    struct single_con * einzel; /* Liste der Verbindungen */
    int * bitfeld;         /* welche Verbindungen existieren */
    ST * temp;             /* Symboltabelle der Laufvariablen der Verbindungen */
    } C_GROUP;

typedef struct c_conf {
    struct c_conf * link;
    Eintrag * name;        /* Konfigurationsname */
    int conf_nr;           /* Nummer der Konfiguration */
    int dims;              /* Zahl der Dimensionen */
    int * wert_von;        /* untere Grenzen der Dimensionen */
    int * wert_bis;        /* obere Grenzen der Dimensionen */
    int * wert_faktoren;   /* Gr"o"se der Dimensionen */
    ST_TYPE * typ;         /* Typen der einzelnen Dimensionen */
    int initdim;           /* PARZ-Label der Berechnung von DIMi */
    } C_CONF;

extern C_GROUP * conf_groups;   /* Liste aller Gruppen */
extern C_GROUP * get_group();   /* ermittelt zu einer Konfigurationsnummer die Gruppe */
extern C_GROUP * get_group_nr();   /* ermittelt zu einer Gruppennummer die Gruppe */

typedef struct single_con {
    int   zahl;    /* Anzahl der Zielports dieses Ports */
    int   epnr;    /* Portnummer bei nur einem Zileport */
    } SINGLE_CON;

extern SINGLE_CON * einzelverbind;

