/* Parallaxis Version: @(#)hilfsvar.h	2.13  2/28/92 14:47:40  */
/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : hilfsvar.h                                                        */
/*                                                                           */
/* Definitionen zur Verwaltung der Hilfsvariablen                            */
/*                                                                           */
/* ************************************************************************* */

/* Sammeln aller Hilfsvariablen */ 
typedef struct hvars {
        struct hvars *  link;
        ST_TYPE *       typ;            /* Typ der Hilfsvariablen */
        int             anz;            /* Gesamtzahl der Hilfsvariablen dieses Typs */
        int             totalanz;       /* Gesamtzahl der benoetigten Hilfsvariablen dieses Typs */
        Eintrag *       ein;            /* Kette der Hilfsvariablen */
        }       HVARS;


/* Variablenknoten */
typedef struct varnode {
        struct varnode *link;           /* Verkettung pro Ausdruck */
        struct varnode *lk;             /* Verkettung fuer die Freigabe */
        Eintrag *       ein;            /* Variablenbeschreibung in ST-Format */
        int             firstelem;      /* Art der Variablen (PARZ-Typ) */
        int             scavec;         /* skalar/vektor bei indirektem Zugriff */
        int             free;           /* soll/muss die Variable freigegeben werden ? */
        int             dir_indir;      /* Variable wird direkt oder indirekt benutzt */
        }       VARNODE;

/* Alle Variablenknoten einer Prozedur bzw. des Hauptteils */
extern VARNODE * VARi; /* fuer die Freigabe aller Hilfsvariablen */


extern HVARS * hvarsscal, * hvarsvect; /* Ketten der freien Hilfsvariablen */



