static char _sccsid[] = "Parallaxis Version: @(#)standard.c	2.13  2/28/92 15:10:05";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : standard.c                                                        */
/*                                                                           */
/* Auswertung von Standardfunktionen und -prozeduren                         */
/*                                                                           */
/* ************************************************************************* */


#include "pass2.h"
#ifdef PC
# ifdef MAC
extern int errno;
# endif
#define HUGE 3.4e38
#endif
extern int nomore;
extern ST_CONST * erzeuge_string();
extern int fp_error;
extern int divisionstest;
extern int calc_verbindungen;


/* ************************************************************************* */
/* Auswertung der Standardfunktionen                                         */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Nummer der Standardfunktion                                   */
/*             Ausdruck des Funktionsaufrufes                                */
/*             Liste der Parameterausdruecke                                 */
/*                                                                           */
/* ************************************************************************* */

Standardfunktionen(nr,funccall,exprlist)
int nr;
T_EXPR * funccall, * exprlist;
{ if ((exprlist == NULL) && (nr != PROC_SIRANDOM) && (nr != PROC_SRRANDOM) &&
      (nr != PROC_SCRANDOM) && (nr != PROC_SBRANDOM) &&
      (nr != PROC_VIRANDOM) && (nr != PROC_VRRANDOM) &&
      (nr != PROC_VCRANDOM) && (nr != PROC_VBRANDOM))
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[284]);
    interpreter = funccall->error = 1;
  }
  else
  { if (exprlist != NULL)
      func_as_param(exprlist);
    switch (nr)
    { case PROC_ABS :
        if (stf_abs(funccall,exprlist))
          return;
        break;
      case PROC_CAP :
        if (stf_cap(funccall,exprlist))
          return;
        break;
      case PROC_CHR :
        if (stf_chr(funccall,exprlist))
          return;
        break;
      case PROC_EVEN :
        if (stf_even(funccall,exprlist))
          return;
        break;
      case PROC_FLOAT :
        if (stf_float(funccall,exprlist))
          return;
        break;
      case PROC_MAX :
        if (stf_max(funccall,exprlist))
          return;
        break;
      case PROC_MIN :
        if (stf_min(funccall,exprlist))
          return;
        break;
      case PROC_ODD :
        if (stf_odd(funccall,exprlist))
          return;
        break;
      case PROC_ORD :
        if (stf_ord(funccall,exprlist))
          return;
        break;
      case PROC_SIZE :
        if (stf_size(funccall,exprlist))
          return;
        break;
      case PROC_TRUNC :
        if (stf_trunc(funccall,exprlist))
          return;
        break;
      case PROC_VAL :
        if (stf_val(funccall,exprlist))
          return;
        break;
      case PROC_STRCMP :
        if (stf_strcmp(funccall,exprlist))
          return;
        break;
      case PROC_STREQ :
        if (stf_streq(funccall,exprlist))
          return;
        break;
      case PROC_SIRANDOM :
        if (stf_sirandom(funccall,exprlist))
          return;
        break;
      case PROC_SRRANDOM :
        if (stf_srrandom(funccall,exprlist))
          return;
        break;
      case PROC_SCRANDOM :
        if (stf_scrandom(funccall,exprlist))
          return;
        break;
      case PROC_SBRANDOM :
        if (stf_sbrandom(funccall,exprlist))
          return;
        break;
      case PROC_VIRANDOM :
        if (stf_virandom(funccall,exprlist))
          return;
        break;
      case PROC_VRRANDOM :
        if (stf_vrrandom(funccall,exprlist))
          return;
        break;
      case PROC_VCRANDOM :
        if (stf_vcrandom(funccall,exprlist))
          return;
        break;
      case PROC_VBRANDOM :
        if (stf_vbrandom(funccall,exprlist))
          return;
        break;
      case PROC_INCONN :
        if (stf_inconn(funccall,exprlist))
          return;
        break;
      case PROC_OUTCONN :
        if (stf_outconn(funccall,exprlist))
          return;
        break;
      case PROC_INLINECON :
        if (stf_inlinecon(funccall,exprlist))
          return;
        break;
      case PROC_OUTLINECON :
        if (stf_outlinecon(funccall,exprlist))
          return;
        break;
      case PROC_ARCCOS :
        if (stf_arccos(funccall,exprlist))
          return;
        break;
      case PROC_ARCSIN :
        if (stf_arcsin(funccall,exprlist))
          return;
        break;
      case PROC_ARCTAN :
        if (stf_arctan(funccall,exprlist))
          return;
        break;
      case PROC_COS :
        if (stf_cos(funccall,exprlist))
          return;
        break;
      case PROC_SIN :
        if (stf_sin(funccall,exprlist))
          return;
        break;
      case PROC_TAN :
        if (stf_tan(funccall,exprlist))
          return;
        break;
      case PROC_SQRT :
        if (stf_sqrt(funccall,exprlist))
          return;
        break;
      case PROC_EXP :
        if (stf_exp(funccall,exprlist))
          return;
        break;
      case PROC_LN :
        if (stf_ln(funccall,exprlist))
          return;
        break;
      case PROC_ARCTAN2 :
        if (stf_arctan2(funccall,exprlist))
          return;
        break;
      case PROC_OPENWINDOW :
        if (stf_openwindow(funccall,exprlist))
          return;
        break;
      case PROC_OPENABSWINDOW :
        if (stf_openabswindow(funccall,exprlist))
          return;
        break;
      case PROC_GETPIXEL :
        if (stf_getpixel(funccall,exprlist))
          return;
        break;

      /* nur REDUCE-Funktionen */
      case PROC_FIRST :
      case PROC_LAST :
      case PROC_SUM :
      case PROC_PRODUCT :
        SEMERROR(funccall->Zeile,funccall->Posit,0,0,
                 text[305]);
        interpreter = 1;
        break;
    }
  }
  funccall->erg_typ = typ_error;
  funccall->erg_art = ERG_VAR;
  funccall->error = 1;
  interpreter = funccall->error = 1;
}
/* #ifndef PC
/* open file */
/* ************************************************************************* */
/* Auswertung der Standardproceduren                                         */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Anweisung mit Standardprozedur                                */
/*             Nummer der Standardfunktion                                   */
/*             Liste der Parameterausdruecke                                 */
/*             Zeilennummer des Aufrufs                                      */
/*             Spaltennummer des Aufrufs                                     */
/*                                                                           */
/* ************************************************************************* */

Standardprozeduren(stat,procnr,exlist,zeile,posit)
T_STATEMENT * stat;
int procnr;
T_EXPR * exlist;
int zeile,posit;
{ ZWCODE * zw;
  if (exlist == NULL)
  { switch (procnr)
    { case PROC_WRITELN :
        stat->zeilen = 1;
        GET_MEM(zw,1,ZWCODE)
        zw->art = CO_WRITELN;
        stat->code = zw;
        break;
      case PROC_CLOSEINPUT :
        stat->zeilen = 1;
        GET_MEM(zw,1,ZWCODE)
        zw->art = CO_CLOSEINPUT;
        stat->code = zw;
        break;
      case PROC_CLOSEOUTPUT :
        stat->zeilen = 1;
        GET_MEM(zw,1,ZWCODE)
        zw->art = CO_CLOSEOUTPUT;
        stat->code = zw;
        break;
      case PROC_HALT :
        { ZWCODE * zw;
          GET_MEM(zw,1,ZWCODE);
          zw->art = CO_HALT;
          stat->code = zw;
          stat->zeilen = 1;
          nomore = 1;
        }
        break;
      case PROC_NOTRACE :
        if (debug_trace_flag)
        { ZWCODE * zw;
          GET_MEM(zw,1,ZWCODE);
          zw->art = CO_NOTRACE;
          stat->code = zw;
          stat->zeilen = 1;
        }
        break;
      default :
        SEMERROR(zeile,posit,0,0,text[284]);
        stat->error = interpreter = 1;
    }
    return;
  }
  exprlist_auswerten(exlist,0);
  func_as_param(exlist);
  switch (procnr)
  { case PROC_DEC :
      stp_dec(stat,exlist,zeile,posit);
    break;
    case PROC_EXCL :
      stp_excl(stat,exlist,zeile,posit);
    break;
    case PROC_INC :
      stp_inc(stat,exlist,zeile,posit);
    break;
    case PROC_INCL :
      stp_incl(stat,exlist,zeile,posit);
    break;
    case PROC_NEW :
      stp_new(stat,exlist,zeile,posit);
    break;
    case PROC_DISPOSE :
      stp_dispose(stat,exlist,zeile,posit);
    break;
    case PROC_WRITE :
      stp_write(stat,exlist,zeile,posit);
    break;
    case PROC_WRITESTRING :
      stp_writestring(stat,exlist,zeile,posit);
    break;
    case PROC_WRITEBOOL :
      stp_writebool(stat,exlist,zeile,posit);
    break;
    case PROC_WRITEINT :
      stp_writeint(stat,exlist,zeile,posit);
    break;
    case PROC_WRITECARD :
      stp_writecard(stat,exlist,zeile,posit);
    break;
    case PROC_WRITEREAL :
      stp_writereal(stat,exlist,zeile,posit);
    break;
    case PROC_WRITEFIXPT :
      stp_writefixpt(stat,exlist,zeile,posit);
    break;
    case PROC_WRITELN :
      SEMERROR(zeile,posit,exlist->Zeile,exlist->Posit,text[315]);
      stat->error = interpreter = 1;
    break;
    case PROC_DRAW :
      stp_draw(stat,exlist,zeile,posit);
    break;
    case PROC_DRAWSTRING :
      stp_drawstring(stat,exlist,zeile,posit);
    break;
    case PROC_DRAWBOOL :
      stp_drawbool(stat,exlist,zeile,posit);
    break;
    case PROC_DRAWINT :
      stp_drawint(stat,exlist,zeile,posit);
    break;
    case PROC_DRAWCARD :
      stp_drawcard(stat,exlist,zeile,posit);
    break;
    case PROC_DRAWREAL :
      stp_drawreal(stat,exlist,zeile,posit);
    break;
    case PROC_DRAWFIXPT :
      stp_drawfixpt(stat,exlist,zeile,posit);
    break;
    case PROC_READ :
      stp_read(stat,exlist,zeile,posit);
    break;
    case PROC_READSTRING :
      stp_readstring(stat,exlist,zeile,posit);
    break;
    case PROC_READBOOL :
      stp_readbool(stat,exlist,zeile,posit);
    break;
    case PROC_READINT :
      stp_readint(stat,exlist,zeile,posit);
    break;
    case PROC_READCARD :
      stp_readcard(stat,exlist,zeile,posit);
    break;
    case PROC_READREAL :
      stp_readreal(stat,exlist,zeile,posit);
    break;
    case PROC_OPENOUTPUT :
      stp_openoutput(stat,exlist,zeile,posit);
    break;
    case PROC_OPENINPUT :
      stp_openinput(stat,exlist,zeile,posit);
    break;
    case PROC_CLOSEOUTPUT :
      SEMERROR(zeile,posit,exlist->Zeile,exlist->Posit,text[317]);
      stat->error = interpreter = 1;
    break;
    case PROC_CLOSEINPUT :
      SEMERROR(zeile,posit,exlist->Zeile,exlist->Posit,text[318]);
      stat->error = interpreter = 1;
    break;
    case PROC_DEBUG :
      stp_debug(stat,exlist);
    break;
    case PROC_TRACE :
      stp_trace(stat,exlist);
    break;
    case PROC_NOTRACE :
      stp_notrace(stat,exlist);
    break;
    case PROC_SELECTWINDOW :
      stp_selectwindow(stat,exlist,zeile,posit);
    break;
    case PROC_SETCOLOR :
      stp_setcolor(stat,exlist,zeile,posit);
    break;
    case PROC_SETPIXEL :
      stp_setpixel(stat,exlist,zeile,posit);
    break;
    case PROC_MOVETO :
      stp_moveto(stat,exlist,zeile,posit);
    break;
    case PROC_LINE :
      stp_lineto(stat,exlist,zeile,posit);
    break;
    case PROC_WINDOWSIZE :
      stp_windowsize(stat,exlist,zeile,posit);
    break;
    case PROC_HALT :
      SEMERROR(zeile,posit,exlist->Zeile,exlist->Posit,text[324]);
      stat->error = interpreter = 1;
    break;
    case PROC_CLOSEWINDOW :
      stp_closewindow(stat,exlist,zeile,posit);
    break;
  }
}
/* close file */
/* #endif*/
/* ************************************************************************* */
/* erzeugt fuer Funktions- und Randomergebnisse eine Hilfsvariable           */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Ausdruck                                                      */
/*                                                                           */
/* ************************************************************************* */

func_as_param(ex)
T_EXPR * ex;
{ while (ex != NULL)
  { if ((ex->erg_art == ERG_PROC) || (ex->erg_art == ERG_RAND))
    { mache_Constexpr(ex,ex->erg_typ,0); }
    if ((ex->erg_art == ERG_CONST) && (ex->erg.Const->Art == ST_CTYPDESC))
      mache_Constexpr(ex,ex->erg_typ,1);
    ex = ex->link;
  }
}
 

