/* Parallaxis Version: @(#)symbols.h	2.13  2/28/92 14:47:46  */
/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : symbols.h                                                         */
/*                                                                           */
/* Definitionen zur Symboltabelle                                            */
/*                                                                           */
/* ************************************************************************* */


/* Definitionen fuer die Symboltabelle */

#define TABELLENGROESSE         257
#define HASH_FAKTOR             107

/* Arten der Eintraege */
#define N_UNDEF                 0
#define N_SYSTEM                1
#define N_CONSTANT              2
#define N_TYPE                  3
#define N_CONFIGURATION         4
#define N_IO                    5
#define N_IOK                   6
#define N_SCALAR                7
#define N_VECTOR                8
#define N_PROCEDURE             9
#define N_INPUT                 10
#define N_OUTPUT                11
#define N_INPUTK                12
#define N_OUTPUTK               13
#define N_RECORDCOMP            14
#define N_SPEZIAL_SKA           15
/* Done etc. */
#define N_SPEZIAL_VEK           16
/* ID_NO, DIMx */
#define N_TEMP                  17
/* nur innerhalb der Verbindungen */
#define N_STDFUNC               18
/* Standardfunktion/-prozedur */
#define N_VAR                   32
/* VAR-Parameter */

/* Nummern der Standardfunktionen und Prozeduren */
#define PROC_ABS                -1
#define PROC_CAP                -2
#define PROC_CHR                -3
#define PROC_EVEN               -4
#define PROC_FLOAT              -5
#define PROC_MAX                -6
#define PROC_MIN                -7
#define PROC_ODD                -8
#define PROC_ORD                -9
#define PROC_SIZE               -10
#define PROC_TRUNC              -11
#define PROC_VAL                -12
#define PROC_STRCMP             -13
#define PROC_STREQ              -14
#define PROC_SIRANDOM           -15
#define PROC_SRRANDOM           -16
#define PROC_SCRANDOM           -17
#define PROC_SBRANDOM           -18
#define PROC_VIRANDOM           -19
#define PROC_VRRANDOM           -20
#define PROC_VCRANDOM           -21
#define PROC_VBRANDOM           -22
#define PROC_INCONN             -23
#define PROC_OUTCONN            -24
#define PROC_INLINECON          -25
#define PROC_OUTLINECON         -26
#define PROC_ARCCOS             -27
#define PROC_ARCSIN             -28
#define PROC_ARCTAN             -29
#define PROC_ARCTAN2            -30
#define PROC_COS                -31
#define PROC_EXP                -32
#define PROC_LN                 -33
#define PROC_SIN                -34
#define PROC_SQRT               -35
#define PROC_TAN                -36
#define PROC_OPENWINDOW         -37
#define PROC_GETPIXEL           -38
#define PROC_OPENABSWINDOW      -39

#define PROC_FIRST              -60
#define PROC_LAST               -61
#define PROC_SUM                -62
#define PROC_PRODUCT            -63


#define PROC_DEC                -64
#define PROC_EXCL               -65
#define PROC_INC                -66
#define PROC_INCL               -67
#define PROC_WRITE              -68
#define PROC_WRITESTRING        -69
#define PROC_WRITEBOOL          -70
#define PROC_WRITEINT           -71
#define PROC_WRITECARD          -72
#define PROC_WRITEREAL          -73
#define PROC_WRITEFIXPT         -74
#define PROC_WRITELN            -75
#define PROC_READ               -76
#define PROC_READSTRING         -77
#define PROC_READBOOL           -78
#define PROC_READINT            -79
#define PROC_READCARD           -80
#define PROC_READREAL           -81
#define PROC_OPENOUTPUT         -82
#define PROC_OPENINPUT          -83
#define PROC_CLOSEOUTPUT        -84
#define PROC_CLOSEINPUT         -85
#define PROC_DEBUG              -86
#define PROC_TRACE              -87
#define PROC_NOTRACE            -88
#define PROC_HALT               -89
#define PROC_NEW                -90
#define PROC_DISPOSE            -91
#define PROC_SELECTWINDOW       -92
#define PROC_SETCOLOR           -93
#define PROC_SETPIXEL           -94
#define PROC_LINE               -95
#define PROC_WINDOWSIZE         -96
#define PROC_CLOSEWINDOW        -97
#define PROC_DRAW               -98
#define PROC_DRAWSTRING         -99
#define PROC_DRAWBOOL          -100
#define PROC_DRAWINT           -101
#define PROC_DRAWCARD          -102
#define PROC_DRAWREAL          -103
#define PROC_DRAWFIXPT         -104
#define PROC_MOVETO            -105


/* Variablenarten von PARZ */
#define BOOLEAN                 0
#define CHAR                    1
#define INTEGER                 2
#define REAL                    3

/* Zugriff fuer die Gesamtzahl der Variablen */                                
#ifndef ALL
#define ALL                     4
#endif


/* Informationen ueber die Prozedurverwendung */
#define PI_SCALAR               1       /* Prozedur enthaelt PARALLEL */
#define PI_SELECT               2       /* Prozedur enthaelt Auswahl */
#define PI_REDUCE               4       /* Prozedur enthaelt REDUCE-Ausdruck oder */
                                        /* Prozedur enthaelt LOAD/STORE/PROPAGATE */
#define PI_VECTORVAR            8       /* Vektorvariablen definiert */
#define PI_VECTOR               16      /* Prozedur enthaelt Vektoroperation */
#define PI_REDUCED              32      /* Prozedur wird als REDUCE-Funktion verwendet */


/* Antworten auf JA/NEIN-Fragen */
#define JA                      1
#define NEIN                    0


/* Suchart in der Symboltabelle */
#define LOCAL                   0
#define GLOBAL                  1


/* Arten der Konstanteneintraege */
#define ST_CINT                 1
#define ST_CREAL                2
#define ST_CREC                 3
#define ST_CSTRING              5
#define ST_CELEM                6
#define ST_CENUM                7
#define ST_CBOOL                8
#define ST_CPI                  9
#define ST_CEOL                 10
#define ST_CSET                 11
#define ST_CTYPDESC             12
#define ST_CNIL                 13


/* Typdefinition fuer eine Konstante in der Symboltabelle */
typedef struct ST_Const {
    struct ST_Const *   link;                /* Verkettung fuer Records */
    int                 Art;                 /* Auswahl */
    int                 gueltig;             /* Eintrag ist vollstaendig */
    int                 nr;                  /* Nummer in der Konstantentabelle */
    long                name;                /* Symbolname */
    struct ST_type *    type;                /* Konstante entspricht diesem Datentyp */
    union {
        int             i;                   /* Integerzahl */
        float           r;                   /* Realzahl */
        struct {
            int         len;                 /* Stringlaenge */
            unsigned char * string;          /* String */
            }           s;                   /* Stringeintrag */
        struct ST_Const * recConst;          /* Konstantenwerte */
        struct {
            int         val;                 /* Zahlenwert */
            int         von,bis;             /* innerhalb von */
            }           range;               /* Aufzaehlung, Bereich */
        struct {
            unsigned *  set;                 /* Zeiger auf die Menge */
            int         count;               /* Kennung ob leere Menge */
            }           set;                 /* Menge */
        struct {
            int         portart;             /* Portart */
            struct zwcode * portdesc;        /* Portbeschreibung */
            }           port;                /* Portangabe */
        }               wert;
    } ST_CONST;


/* Arten der Typeintraege */
#define ST_TUNDEF               0
#define ST_TINT                 1
#define ST_TCHAR                2
#define ST_TBOOL                3
#define ST_TREAL                4
#define ST_TARRAY               5
#define ST_TRECORD              6
#define ST_TRECORDREST          7
#define ST_TSET                 8
#define ST_TRANGE               9
#define ST_TSUBRANGE            10
#define ST_TSARRAY              11
#define ST_TRANDOM              12
#define ST_TID_NO               13
#define ST_TDIM                 14
#define ST_TVARIANT             15
#define ST_TPOINTER             16
#define ST_TNIL                 17
#define ST_TPORT                18
#define ST_TPORTTYPE            19

/* Mitglieder in Aufz"ahlungen und Strukturen */
typedef struct members {
    struct members * link;      /* Verkettung aller Mitglieder eines Programs */
    struct members * next;      /* Verkettung aller Mitglieder einer Struktur */
    int nummer;                 /* Nummer des Mitglieds */
    struct Eintr * ein;         /* Name des Mitglieds */
    int art;                    /* Konstante oder Recordkomponente */
    union {
        int wert;               /* Nummer der Konstanten */
        struct ST_type *  typ;  /* Datentyp */
        } inh;
    int flag;                   /* letztes Element */
    } MEMBERS;

extern MEMBERS * all_members;   /* alle Mitgliedereintraege */
    
/* Typdefinition fuer einen Datentyp in der Symboltabelle */
typedef struct ST_type {
    struct ST_type *    link;                /* Verkettung fuer Records */
    struct ST_type *    liste;               /* Verkettung fuer Debugausgaben */
    int                 Art;                 /* Auswahl */
    long                name;                /* Nummer im WB des Typnamen */
    int                 nummer;              /* Nummer des Typs in der Typenliste */
    int                 used[ALL+1];         /* benutzte Anzahl pro Variablentyp & gesamt */ 
    int                 gueltig;             /* Eintrag ist vollstaendig */
    int                 firstelem;           /* Typ des ersten Elements */
    union {
        struct {
            struct ST_type * super;          /* Datentyp des Basistyps bei Unterbereichen */
            int         von,bis;             /* Bereichs-, Aufzaehlung- u. Mengengrenzen */
            int         basis;               /* Anfang eines Bereichs (Unterbereich) */                  
            MEMBERS     * mem;               /* Anfang der Mitglieder */                  
            } range;
        struct {
            int         anzahl;              /* Gesamtgroesse des Feldes */
            int         top;                 /* Feld ist direkt als ARRAY definiert */
            struct ST_type * bereich;        /* Bereich einer Dimension */
            struct ST_type * typ;            /* Typ eines Elements */
            }           array;
        struct {
            struct S_T  * symtab;            /* Symboltabelle fuer Variantennamen */
            MEMBERS     * member;            /* Mitglieder */
            MEMBERS     * mem;               /* Anfang der Mitglieder */                  
            }           record;
        struct {
            struct ST_type * type;           /* Zeiger auf den Datentyp */
            struct Eintr * forw;             /* forward Deklaration */
            }           pointer;
        struct {
            long        key;                 /* Key der Konfiguration */
            int         von,bis;             /* Bereichs-, Aufzaehlung- u. Mengengrenzen */
            } port;
        }               info;
    } ST_TYPE;


/* Arten der Variableneintraege */
#define DIRECT                  0
#define INDIRECT                1
#define ADRESS                  2
#define SPEZIAL                 3


/* Typdefinition fuer eine Parameterbeschreibung */
typedef struct ST_param {
    struct ST_param *   link;                /* Verkettung */
    int                 mode;                /* Beschreibung der Art des Parameters */
    int                 anzahl;              /* Anzahl der gleichen Parameter */
    ST_TYPE *           type;                /* Typbeschreibung */
    } ST_PARAM;


/* Typdefinition fuer einen Symboltabelleneintrag */
typedef struct Eintr
{   struct Eintr *      next;                /* Verkettung innerhalb der Hasheintraege */
    struct Eintr *      link;                /* Verkettung innerhalb einzelner Typen */
    int                 Art;                 /* Eintragsart */
    int                 Zeile, Posit;        /* Ort der Definition */
    int                 gueltig;             /* Eintrag ist korrekt */
    int                 timestamp;           /* Zeitmarkierung */
    union {
        ST_CONST *      Const;               /* Konstanten */
        ST_TYPE *       type;                /* Typen */
        struct {
            int         used;                /* Variable wird verwendet */
            int         dir_indir;           /* Zugriff in PARZ ueber Zeiger oder nicht ? */
            int         art;                 /* PARZ Typbezeichnung */
            int         ebene;               /* Variablenebene */
            int         nummer;              /* relative Nummer */
            int         vektoriell;          /* 1 : skalarer Zeiger auf vekt. Element */
            ST_TYPE *   type;                /* Typebeschreibung */
            struct hvars * list;             /* Hilfsvariablenliste */
            }           var;                 /* skalare und vektorielle Variablen */
        struct {
            int         reladr;              /* relative Adresse innerhalb der Struktur */
            ST_TYPE *   type;                /* Typbeschreibung */
            ST_TYPE *   styp;                /* Recordtyp */
            }           komp;                /* Strukturkomponente */
        struct {
            int         info;
            int         used;                /* Prozedur wird verwendet */
            int         parall;              /* Kennung, ob Prozedur nur Parallel ist und/oder als Reducefunktion verwendet wird/werden kann */
            int         proc_mode;           /* Inhalt einer Funktion */
            int         conf_nr;             /* Nummer der zugeh"orenden Topologie */
            int         posnr;               /* Labelnummer der Prozedur (bei Standardfunktionen Funktionsnummer) */
            int         scavec;              /* ist Funktionsergebnis skalar oder vektoriell */
            int         complex;             /* Ergebnis als Zeiger */
            int         debug;               /* Funktion soll DEBUGed werden */
            ST_TYPE *   result;              /* Typbeschreibung des Ergebnisses */
            ST_PARAM *  param;               /* Parameterbeschreibung */
            struct scope * scop;             /* Geltungsbereich */
            }           proz;                /* Prozedur */
        struct {
            int         portnr;              /* Portnummer */
            int         intext;              /* interner oder externer Port */
            int *       bitfeld;             /* Zeiger auf moegliche Ziele */
            int         von,bis;             /* Bereich der Portangaben (mit Klammern) */
            int         conf_nr;             /* Nummer der Konfiguration */
            int         conf_group;          /* Nummer der Konfigurationsgruppe */
            ST_TYPE *   port_typ;            /* Typbeschreibung fuer die Indizierung */
            }           inout;               /* Ausgabe- und Eingabeportbeschreibung */
        struct {
            int         dim_anz;             /* Zahl der Dimensionen */
            int         proz_anz;            /* Zahl der Prozessoren */
            int         conf_nr;             /* Nummer der Konfiguration */
            int         conf_group;          /* Nummer der Konfigurationsgruppe */
            ST_TYPE *   typ;                 /* Datentyp f"ur die Topologie */
            ST_TYPE *   port_typ;            /* Datentyp f"ur die Ports ohne Bereiche */
            struct S_T * tab;                /* Symboltabelle f"ur die Vektorvariablen */
            int         first_PE;            /* Nummer des ersten PEs */
            }           config;              /* Konfiguration */
        }               param;               /* Parameter */
    long                name_nr;             /* Nummer im Woerterbuch */
/*  char                Name[1];             /* Name des Identifiers */
} Eintrag;


/* Typdefinition fuer die Symboltabelle */
typedef struct S_T
{   struct  S_T *       Obertabelle;         /* Baumstruktur */
    struct  S_T *       link;                /* Verkettung f"ur die Debugausgabe */
    struct  S_T *       others;              /* Verkettung f"ur die Vektortabellen */
    int                 Ebene;               /* Symboltabellenebene */
    int                 startnr,anz;         /* Begin und Gr"o"se der Tabelle in eintr"agen */
    int                 confselect;          /* Bit 0 : Configuration wird definiert */
                                             /* Bit 1 : Configuration wird darueber definiert */
    int                 is_vector;           /* Symboltabelle ist reine Vektortabelle */
    int                 gueltig;             /* 0 bei nicht aktiven Vektortabellen */
    int                 ControlVarAnz[ALL+1];  /* Anzahlen der verschiedenen SCALAR-Variablen */
    int                 ControlHilfVarAnz[ALL+1];  /* Anzahlen der verschiedenen SCALAR-Variablen */
    int                 ControlVarAnzMem[ALL+1];  /* Anzahlen der verschiedenen SCALAR-Variablen */
    int                 LocalVarAnz[ALL+1];    /* Anzahlen der verschiedenen VECTOR-Variablen */
    int                 LocalHilfVarAnz[ALL+1];    /* Anzahlen der verschiedenen VECTOR-Variablen */
    int                 LocalVarAnzMem[ALL+1];    /* Anzahlen der verschiedenen VECTOR-Variablen */
    struct hvars *      hvarsscal, * hvarsvect; /* Ketten der freien Hilfsvariablen */
    Eintrag *           record;              /* Verkettung aller Strukturkomponenten */
    Eintrag *           scalar;              /* Verkettung aller Scalar-Variablen */
    Eintrag *           vector;              /* Verkettung aller Vector-Variablen */
    Eintrag *           configuration;       /* Verkettung aller Konfigurationen */
    Eintrag *           output;              /* Verkettung aller out-ports */
    Eintrag *           input;               /* Verkettung aller in-ports */
    Eintrag *           io;                  /* Verkettung aller io-ports */
    Eintrag *           dim;                 /* Verkettung aller DIMis */
    Eintrag *    Eintraege[TABELLENGROESSE]; /* Feld fuer die Eintraege */
} ST;

/* der Wert PI */
extern float C_PI;

/* jeweils aktuelle Symboltabelle */
extern ST * akt_ST;
extern ST * vector_ST;        /* Symboltabelle f"ur Vektorvariablen und Verbindungen */


/* extern-Definitionen der Symboltabellenfunktionen */


/* ************************************************************************* */
/* erzeuge neue Symboltabelle                                                */
/*                                                                           */
/* Ergebnis :  Zeiger auf die neu erstellte Symboltabelle                    */
/*                                                                           */
/* Parameter : Zeiger auf die alte Symboltabelle                             */
/*             Offset zur Berechnung der Ebenen-Nummer aus der alten ST      */
/*                                                                           */
/* ************************************************************************* */
extern ST * neue_ST();

/* ************************************************************************* */
/* erzeuge einen neuen Eintrag fuer die Symboltabelle                        */
/*                                                                           */
/* Ergebnis :  Zeiger auf den neu erzeugten Eintrag                          */
/*                                                                           */
/* Parameter : Zeiger auf den Identifier-Namen                               */
/*             Laenge des Identifiers                                        */
/*                                                                           */
/* ************************************************************************* */
extern Eintrag * neuer_Eintrag();

/* ************************************************************************* */
/* suche einen Eintrag in der Symboltabelle                                  */
/*                                                                           */
/* Ergebnis :  Zeiger auf den Symboltabelleneintrag oder NULL                */
/*                                                                           */
/* Parameter : Zeiger auf den Identifier-Namen                               */
/*             Zeiger auf die Anfangssymboltabelle                           */
/*             Kennzeichner fuer globales oder lokales Suchen                */
/*                                                                           */
/* ************************************************************************* */
extern Eintrag * suche_Eintrag();

/* ************************************************************************* */
/* fuege einen neuen Eintrag in die Symboltabelle ein                        */
/*                                                                           */
/* Ergenbis :  Zeiger auf den Eintrag in der Symboltabelle                   */
/*                                                                           */
/* Parameter : Zeiger auf den Identifier-Namen                               */
/*             Rueckgabeadresse fuer den Kennzeichner, ob ein solcher        */
/*                  Eintrag bereits existiert hat oder nicht.                */
/*                                                                           */
/* ************************************************************************* */
extern Eintrag * mache_Eintrag();
                     
extern ST * vector_ST_entfernen(); 

extern ST * vector_ST_eintragen();

extern ST * all_tables;

extern int timestamp;
