static char _sccsid[] = "Parallaxis Version: @(#)symboltabelle.c	2.13  2/28/92 15:10:05";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : symboltabelle.c                                                   */
/*                                                                           */
/* Funktionen zur Verwaltung der Symboltabellen                              */
/*                                                                           */
/* ************************************************************************* */

# include "defines.h"
# include "parallax.h"

# include "symbols.h"

ST * all_tables = NULL;
static int hashnr;
int timestamp = 0;
int akt_timestamp = 0;
Eintrag spez_eintr;
int activ_check = 1;

/* ************************************************************************* */
/* Hashfunktion                                                              */
/*                                                                           */
/* Ergebnis : Hashzahl                                                       */
/*                                                                           */
/* Parameter : String                                                        */
/*                                                                           */
/* ************************************************************************* */

int hash(z)
char * z;
{   register int h = 0;
    while (*z)
    {   h = ((h * HASH_FAKTOR) + *z++) % TABELLENGROESSE; }
    hashnr = h;
    return h;
}

/* ************************************************************************* */
/* erzeuge neue Symboltabelle                                                */
/*                                                                           */
/* Ergebnis :  Zeiger auf die neu erstellte Symboltabelle                    */
/*                                                                           */
/* Parameter : Zeiger auf die alte Symboltabelle                             */
/*             Offset zur Berechnung der Ebenen-Nummer aus der alten ST      */
/*                                                                           */
/* ************************************************************************* */

ST * neue_ST(STsz, offset)
ST * STsz;
int offset;
{   ST * zw;
    register int i;

    GET_MEM(zw, 1, ST);
    zw->link = all_tables;
    all_tables = zw;
    zw->Obertabelle = STsz;
    if (STsz == NULL)
    {   zw->Ebene = offset; }
    else
    {   zw->Ebene = STsz->Ebene + offset; }
    for(i = 0; i < TABELLENGROESSE; zw->Eintraege[i++] = NULL);
    for (i = BOOLEAN; i <= ALL; i++)
    {   zw->ControlVarAnz[i] = 0;
        zw->LocalVarAnz[i] = 0; }
    zw->record = NULL;
    zw->scalar = NULL;
    zw->vector = NULL;
    zw->gueltig = 1;
    return(zw) ;
}

/* ************************************************************************* */
/* erzeuge einen neuen Eintrag fuer die Symboltabelle                        */
/*                                                                           */
/* Ergebnis :  Zeiger auf den neu erzeugten Eintrag                          */
/*                                                                           */
/* Parameter : Zeiger auf den Identifier-Namen                               */
/*             Laenge des Identifiers                                        */
/*                                                                           */
/* ************************************************************************* */

Eintrag * neuer_Eintrag(n)
long n;
{   register Eintrag * z;
    GET_MEM(z,1,Eintrag)

    z->next = NULL;
    z->Art = N_UNDEF;
    z->name_nr = n;
    z->timestamp = timestamp++;
    return(z);
}

/* ************************************************************************* */
/* suche einen Eintrag in der Symboltabelle                                  */
/*                                                                           */
/* Ergebnis :  Zeiger auf den Symboltabelleneintrag oder NULL                */
/*                                                                           */
/* Parameter : Nummer des Identifiers im WB                                  */
/*             Zeiger auf die Anfangssymboltabelle                           */
/*             Kennzeichner fuer globales oder lokales Suchen                */
/*                                                                           */
/* ************************************************************************* */

Eintrag * suche_Eintrag(n,s,g_l,ts)
long n;
ST * s;
int g_l;
int ts;
{   register Eintrag *z, *z1 = NULL;
    hashnr = n % TABELLENGROESSE;
    while(s != NULL)
    {   if (s->is_vector && s->Obertabelle)
        {   s = s->Obertabelle; }
        if ((!s->is_vector) && s->others)
        {   s = s->others; }
        if (s->is_vector)
        {   do
            {   z = s->Eintraege[hashnr];
                while(z != NULL)
                {   if (n == z->name_nr)
                    {   if (((ts == 0) || (ts >= z->timestamp)) &&
                            (activ_check || s->gueltig))
                             return(z);
                        else
                            if (z->Art != N_TEMP)
                            {   if (z->Art == N_SPEZIAL_VEK)
                                {   z1 = z; }
                                else
                                {   if ((ts != 0) && (ts <= z->timestamp))
                                        return NULL;
                                    spez_eintr = *z;
                                    return (&spez_eintr); 
                                }
                            }
                    }
                    z = z->next;
                }
                if (!s->others)
                {   if (z1)
                    {   spez_eintr = *z1;
                        return (&spez_eintr); 
                    }                  
                    break;
                }
                s = s->others;
            } while (1);
            s = s->Obertabelle;
        }
        z=s->Eintraege[hashnr];
        while(z != NULL)
        {   if(n == z->name_nr)
            {  if ((ts == 0) || (ts >= z->timestamp))
                 return(z);
               else
                 if (z->Art != N_TEMP)
                   return(NULL);
            }
            z = z->next;
        }
        s = s->Obertabelle;
        s = (s && (g_l != LOCAL)) ? s : NULL;
    }
    return(NULL);
}

/* ************************************************************************* */
/* fuege einen neuen Eintrag in die Symboltabelle ein                        */
/*                                                                           */
/* Ergenbis :  Zeiger auf den Eintrag in der Symboltabelle                   */
/*                                                                           */
/* Parameter : Nummer des Identifiers im WB                                  */
/*             Rueckgabeadresse fuer den Kennzeichner, ob ein solcher        */
/*                  Eintrag bereits existiert hat oder nicht.                */
/*                                                                           */
/* ************************************************************************* */

Eintrag * mache_Eintrag(n,ex,mode)
long n;
int * ex, mode;
{   register Eintrag * z;
    ST * a_ST = (is_vector(mode)) ? vector_ST : akt_ST;
    if (n >= 0l)
    {   if ((z = suche_Eintrag(n,(vector_ST) ? vector_ST : akt_ST,
                               LOCAL,timestamp)) == NULL)
        {   z = neuer_Eintrag(n);
            *ex = NEIN;
            z->next = a_ST->Eintraege[hashnr];
            a_ST->Eintraege[hashnr] = z;
            z->Art = mode;
            z->link = NULL; 
            switch (mode)
                  /* Eintrag in Speziallisten einhaengen */
            { case N_CONFIGURATION :
                z->link = a_ST->configuration;
                a_ST->configuration = z;
                z->timestamp = 0;
                break;
              case N_RECORDCOMP :
                z->link = a_ST->record;
                a_ST->record = z;
                break;
              case N_SPEZIAL_VEK :
                z->link = a_ST->dim;
                a_ST->dim = z;
                break;
          
              case N_PROCEDURE :
               z->timestamp = 0;
               break;
 
             case N_SCALAR :
                z->param.var.dir_indir = DIRECT;
                z->link = a_ST->scalar;
                a_ST->scalar = z;
                z->param.var.ebene = a_ST->Ebene;
                break;
              case N_SCALAR | N_VAR :
                z->param.var.dir_indir = INDIRECT;
                z->link = a_ST->scalar;
                a_ST->scalar = z;
                z->param.var.ebene = a_ST->Ebene;
                break;
              case N_VECTOR :
                z->param.var.dir_indir = DIRECT;
                z->link = a_ST->vector;
                a_ST->vector = z;
                z->param.var.ebene = a_ST->Ebene;
                break;
              case N_VECTOR | N_VAR :
                z->param.var.dir_indir = INDIRECT;
                z->link = a_ST->vector;
                a_ST->vector = z;
                z->param.var.ebene = a_ST->Ebene;
                break;
            }
        }
        else
            *ex = JA;
    }
    else
    {   z = NULL;
        *ex = NEIN;
    }
    return(z);
}

/* ************************************************************************* */
/* Mu"s der Eintrag in die Vektortabelle ?                                   */
/*                                                                           */
/* Ergebnis : JA oder NEIN                                                   */
/*                                                                           */
/* Parameter : Eintragsart                                                   */
/*                                                                           */
/* ************************************************************************* */

int is_vector(m)
int m;
{ switch (m & ~32)
  { case N_VECTOR :
    case N_IO :
    case N_INPUT :
    case N_OUTPUT :
    case N_IOK :
    case N_INPUTK :
    case N_OUTPUTK :
    case N_SPEZIAL_VEK :
    case N_TEMP :
      return JA;
  }
  return NEIN;
}

/* ************************************************************************* */
/* entferne einen Vektortabelle aus dem Symboltabellenbaum                   */
/*                                                                           */
/* Ergebnis : die entfernte Symboltabelle                                    */
/*                                                                           */
/* Parameter :                                                               */
/*                                                                           */
/* ************************************************************************* */

ST * vector_ST_entfernen()
{ ST * t1,* t,* v;
  if ((v = vector_ST)->is_vector)
  { deactivate_dimis();
    v->gueltig = 0;
    vector_ST = vector_ST->Obertabelle;
    return v;
  }
  t = (t1 = vector_ST)->Obertabelle;
  while (t && !t->is_vector)
  { t1 = t;
    t = t->Obertabelle;
  }
  if (t)
  { vector_ST = t;
    deactivate_dimis();
    t->gueltig = 0;
    t1->Obertabelle = t->Obertabelle;
    vector_ST = v;
  }
  return t;
}

/* ************************************************************************* */
/* h"ange eine Vektortabelle in den Symboltabellenbaum ein                   */
/*                                                                           */
/* Ergebnis : eine evtl. entfernte Vektortabelle                             */
/*                                                                           */
/* Parameter : einzuh"angende Vektortabelle                                  */
/*                                                                           */
/* ************************************************************************* */

ST * vector_ST_eintragen(t)
ST * t;
{ ST * t1, * t2;
  ST * t3 ;
  if (!t)
    return NULL;
            /* zuerst ander Vektortabelle entfernen */
  t3 = vector_ST_entfernen();
  t1 = vector_ST;
  if (t1 == (t2 = t->Obertabelle))  /* Vektortabelle mu"s ganz nach oben */
  { vector_ST = t;
    t->gueltig = 1;
    return t3;
  }
  while (t1 && t1->Obertabelle != t2)  /* suche die passende Obertabelle */
  { t1 = t1->Obertabelle; }
  if (t1)
  { t1->Obertabelle = t;
    t->gueltig = 1;
    return t3;
  }
  bug("vector_ST_eintragen : ST not found");
}

/* ************************************************************************* */
/* mache alle Vektortabellen ungueltig                                       */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter :                                                               */
/*                                                                           */
/* ************************************************************************* */

reset_vector_STs()
{ ST * t = all_tables;
  while (t)
  { if (t->is_vector)
      t->gueltig = 0;
    t = t->link;
  }
}


