letter       [a-zA-Z_]
digit        [0-9]
letter_digit [0-9A-Za-z_]
whitespace   [ \t\r]

%{ 
static char _sccsid[] = "Parallaxis Version: @(#)v2.l	2.13  2/28/92 14:31:18";

/* *************************** Datei parallaxis.l ************************ *
 *                                                                         *
 * Scanner                                                                 *
 *                                                                         *
 * Ingo Barth                                                              *
 *                                                                         */


# include "defines.h"
# include  "typen.h"

/* Anfang eines Tokens vermerken */
# define POSITION if (yyposition == -1) { yyposition = 0; letzte_laenge = 0; };\
                  yyposition += letzte_laenge;\
                  zeichen_gelesen = 1;\
                  letzte_laenge = yyleng

/* Rueckgabeparameter aufbauen und Position des Tokens vermerken */
#define SE       yylval.t_scan_elem = (SCAN_ELEM *) my_calloc(1,sizeof(SCAN_ELEM));\
                  if (yylval.t_scan_elem == NULL) fatal(text[100]);\
                  sp_zeile = yylval.t_scan_elem -> Zeile = yylineno;\
                  sp_pos = yylval.t_scan_elem -> Posit = yyposition;

/* Spezialbehandlung von Schluesselworten */
# define MEMO     speicher = s;\
                  unput(' ');\
                  SE\
                  return Fine[key_nr];

/* Wert in Rueckgabestruktur einsetzten */
#define WERT(x)   yylval.t_scan_elem -> wert.x 

/* Tokenart vermerken */
#define ART(x)    yylval.t_scan_elem -> Art = x

# include "y_tab.h"
#       define  token(x)    x

# include "parallax.h"
#ifdef MAC
extern double myatof();
#endif
extern char * strsave();    /* Zeichenkette speichern */
extern int ende;            /* kann ein END gelesen werden */
extern int key_nr;          /* welches Schluesselwort ? */
extern int nur_int_zahl;    /* num. soll als num und . und nicht als realnum zerlegt werden */
extern int proc_parall_count; /* innerhalb eines PARALLEL-ENDPARALLEL-Blocks ? */
#ifdef DEBUG
extern int yydebug;   
#endif
extern int yynerrs;         /* Anzahl der Fehler */
extern short yyerrflag, yyerrflag1;
long mom_ident_nr;

/* Protokoll- und Prozedurdebug-Befehlen */
PROTOKOLL * debug_proz = NULL; /* Liste mit den Namen aller Prozeduren, die debugged
                                  werden sollen */
PROTOKOLL * protokoll = NULL; /* Liste mit den Namen aller Prozeduren, die protokolliert
                                 werden sollen */

static PROTOKOLL * anhaengen(); /* Funktion zum Aufbau der obigen Listen */

static int yyposition = -1; /* Position in der Zeile */
static letzte_laenge = 0;   /* Laenge des letzten Tokens */
static int yycomline[MAX_COM]; /* Zeilennummern der offenen Kommentare */
static int yycompos[MAX_COM];  /* Spaltennummern der offenen Kommentare */
static int zeichen_gelesen = 0; /* wurde ein Zeichen gelesen ? */
static int yycomc = 0;      /* innerhalb eine Kommentars ? */
static int yydebcom = 0;    /* Identifier in Debug-Liste einhaengen ? */
static int yyprotcom = 0;   /* Identifier in Protokoll-Liste einhaengen ? */
int  sp_pos2, yylineno2;
int sp_pos, sp_zeile; /* Positionsangaben fuer Fehlermeldungen */

int no_char_read = 0;       /* wurde ueberhaupt etwas gelesen ? */
int max_zeilenzahl = 0;     /* Zeilennummer der EOF */

%}

%%
^[^\n]+/"\n"                                  { /* ganze Zeile lesen */
                                                Zeile_einlesen(yytext,yyleng,yylineno);
                                                REJECT;
                                              }
\(\*{whitespace}*\$[dD]{whitespace}*          { /* Debug-Listenkopf */
                                                POSITION;
                                                if (yycomc < MAX_COM)
                                                {  yycompos[yycomc] = yyposition;
                                                   yycomline[yycomc] = yylineno; }
                                                yydebcom = 1;
                                                yyprotcom = 0;
                                                yycomc++;
                                              }
\(\*{whitespace}*\$[rR]{whitespace}*          { /* Protokoll-Listenkopf */
                                                POSITION;
                                                if (yycomc < MAX_COM)
                                                {  yycompos[yycomc] = yyposition;
                                                   yycomline[yycomc] = yylineno; }
                                                yyprotcom = 1;
                                                yydebcom = 0;
                                                yycomc++;
                                              }
"*)"                                          { /* Ende eines Kommentars */
                                                POSITION;
                                                yyprotcom = yydebcom = 0;
                                                if (yycomc == 0)
                                                   {
#ifdef DEBUG
                                                     if (yydebug) printf("COMMENT\n");
#endif
                                                     SE return token(COMMENT);}
                                                else
                                                   {  --yycomc; }
                                              }
"!!1!!"                                       {   /* nur fuer DEBUG-Version */
                                                  POSITION;
                                                  if (yycomc)
#ifdef DEBUG
                                                        { yydebug = 1; }
#else
                                                        {}
#endif
                                                  else
                                                        REJECT; }
"!!0!!"                                       {   /* nur fuer DEBUG-Version */
                                                  POSITION;
                                                  if (yycomc)
#ifdef DEBUG
                                                        { yydebug = 0; }
#else
                                                        {}
#endif
                                                  else
                                                        REJECT; }
"(*"                                          { /* Kommentaranfang */
                                                POSITION;
                                                if (yycomc < MAX_COM)
                                                {  yycompos[yycomc] = yyposition;
                                                   yycomline[yycomc] = yylineno; }
                                                yycomc++;
                                                yyprotcom = yydebcom = 0;
                                              }
"\""[^\"\n]*/"\n"                             { /* Fehlerhafter String "abc */
                                                if (yycomc)
                                                  REJECT;
                                                POSITION;
                                                if (yycomc == 0)
                                                { if (yyleng == 2)
                                                  {
#ifdef DEBUG
                                                    if (yydebug) printf("CHARCONSTANT : %s\n",yytext);
#endif
                                                    SE
                                                    ART(CHARCONSTANT);
                                                    WERT(c) = yytext[1];
                                                    SYNERROR;
                                                    fehler(text[101]);
                                                    return token(CHARCONSTANT);
                                                  }
                                                  else
                                                  {
#ifdef DEBUG
                                                    if (yydebug) printf("STRINGCONSTANT : %s\n",yytext);
#endif
                                                    SE
                                                    ART(STRINGCONSTANT);
                                                    WERT(s) = strsave(&yytext[1]);
                                                    SYNERROR;
                                                    fehler(text[101]);
                                                    return token(STRINGCONSTANT);
                                                  }
                                                }
                                                else
                                                  yyprotcom = yydebcom = 0;
                                              }
"\'"[^\'\n]*/"\n"                             { /* Fehlerhafter String 'abc */
                                                if (yycomc)
                                                  REJECT;
                                                POSITION;
                                                if (yycomc == 0)
                                                { if (yyleng == 2)
                                                  {
#ifdef DEBUG
                                                    if (yydebug) printf("CHARCONSTANT : %s\n",yytext);
#endif
                                                    SE
                                                    ART(CHARCONSTANT);
                                                    WERT(c) = yytext[1];
                                                    SYNERROR;
                                                    fehler(text[101]);
                                                    return token(CHARCONSTANT);
                                                  }
                                                  else
                                                  {
#ifdef DEBUG
                                                    if (yydebug) printf("STRINGCONSTANT : %s\n",yytext);
#endif
                                                    SE
                                                    ART(STRINGCONSTANT);
                                                    WERT(s) = strsave(&yytext[1]);
                                                    SYNERROR;
                                                    fehler(text[101]);
                                                    return token(STRINGCONSTANT);
                                                  }
                                                }
                                                else
                                                  yyprotcom = yydebcom = 0;
                                              }
"\""[^\"\n]*"\""                              { /* STring oder Einzelzeichen */
                                                if (yycomc)
                                                  REJECT;
                                                POSITION;
                                                if (yycomc == 0)
                                                { if (yyleng == 3)
                                                  {
#ifdef DEBUG
                                                    if (yydebug) printf("CHARCONSTANT : %s\n",yytext);
#endif
                                                    SE
                                                    ART(CHARCONSTANT);
                                                    WERT(c) = yytext[1];
                                                    return token(CHARCONSTANT);
                                                  }
                                                  else
                                                  {
#ifdef DEBUG
                                                    if (yydebug) printf("STRINGCONSTANT : %s\n",yytext);
#endif
                                                    SE
                                                    ART(STRINGCONSTANT);
                                                    yytext[yyleng-1] = '\0';
                                                    WERT(s) = strsave(&yytext[1]);
                                                    yytext[yyleng-1] = '"';
                                                    return token(STRINGCONSTANT);
                                                  }
                                                }
                                                else
                                                  yyprotcom = yydebcom = 0;
                                              }
"\'"[^\'\n]*"\'"                              { /* STring oder Einzelzeichen */
                                                if (yycomc)
                                                  REJECT;
                                                POSITION;
                                                if (yycomc == 0)
                                                { if (yyleng == 3)
                                                  {
#ifdef DEBUG
                                                    if (yydebug) printf("CHARCONSTANT : %s\n",yytext);
#endif
                                                    SE
                                                    ART(CHARCONSTANT);
                                                    WERT(c) = yytext[1];
                                                    return token(CHARCONSTANT);
                                                  }
                                                  else
                                                  {
#ifdef DEBUG
                                                    if (yydebug) printf("STRINGCONSTANT : %s\n",yytext);
#endif
                                                    SE
                                                    ART(STRINGCONSTANT);
                                                    yytext[yyleng-1] = '\0';
                                                    WERT(s) = strsave(&yytext[1]);
                                                    yytext[yyleng-1] = '"';
                                                    return token(STRINGCONSTANT);
                                                  }
                                                }
                                                else
                                                  yyprotcom = yydebcom = 0;
                                              }
{letter}{letter_digit}*                       { /* Name oder Schluesselwort */
                                                POSITION;
                                                if (yycomc == 0) 
                                                { return texte();     }
                                                else
                                                { if (yydebcom)
                                                  { debug_proz = anhaengen(debug_proz); }
                                                  else if (yyprotcom)
                                                  { protokoll = anhaengen(protokoll); }
                                                }
                                              }
{digit}+/".."                                 { /* Integerzahl mit folgendem .. */
                                                POSITION;
                                                if (yycomc == 0) 
                                                {
#ifdef DEBUG
                                                  if (yydebug) printf("INTCONSTANT : %s\n",yytext);
#endif
                                                  SE
                                                  ART(INTCONSTANT);
                                                  sscanf(yytext,"%d",&WERT(i));
                                                  return token(INTCONSTANT);
                                                }
                                                else
                                                  yyprotcom = yydebcom = 0;
                                              }
{digit}*"."{digit}+([Ee][+-]?{digit}+)?       |
{digit}+"."{digit}*([Ee][+-]?{digit}+)?       { /* Realzahl */
                                                if (nur_int_zahl)
                                                  { REJECT; }
                                                POSITION;
                                                if (yycomc == 0) 
                                                { 
#ifdef DEBUG
                                                  if (yydebug) printf("REALCONSTANT : %s\n",yytext);
#endif
                                                  SE
                                                  ART(REALCONSTANT);
#ifdef MAC
                                                  WERT(r) = myatof(yytext);
#else
#ifdef DOUBLEFLOAT
                                                  sscanf(yytext,"%lf",&WERT(r));
#else
                                                  sscanf(yytext,"%f",&WERT(r));
#endif
#endif
                                                  return token(REALCONSTANT);
                                                }
                                                else
                                                  yyprotcom = yydebcom = 0;
                                              }
{digit}+                                      { /* Integerzahl */
                                                POSITION;
                                                if (yycomc == 0) 
                                                {
#ifdef DEBUG
                                                  if (yydebug) printf("INTCONSTANT : %s\n",yytext);
#endif
                                                  SE
                                                  ART(INTCONSTANT);
                                                  sscanf(yytext,"%d",&WERT(i));
                                                  return token(INTCONSTANT);
                                                }
                                                else
                                                  yyprotcom = yydebcom = 0;
                                              }                             
".."                                          { /* .. */
                                                POSITION;
                                                if (yycomc == 0) 
                                                {
#ifdef DEBUG
                                                  if (yydebug) printf("PP\n");
#endif
                                                  SE
                                                  ART(PP);
                                                  return token(PP);
                                                }
                                                else
                                                  yyprotcom = yydebcom = 0;
                                              }
"->"                                          { /* -> */
                                                POSITION;
                                                if (yycomc == 0) 
                                                {
#ifdef DEBUG
                                                  if (yydebug) printf("ARROW\n");
#endif
                                                  SE
                                                  ART(ARROW);
                                                  WERT(i) = 0;
                                                  return token(ARROW);
                                                }
                                                else
                                                  yyprotcom = yydebcom = 0;
                                              }
"<->"                                         { /* <-> */
                                                POSITION;
                                                if (yycomc == 0) 
                                                {
#ifdef DEBUG
                                                  if (yydebug) printf("ARROW2\n");
#endif
                                                  SE
                                                  ART(ARROW2);
                                                  WERT(i) = 1;
                                                  return token(ARROW);
                                                }
                                                else
                                                  yyprotcom = yydebcom = 0;
                                              }
"<>"                                          { /* <> */
                                                POSITION;
                                                if (yycomc == 0) 
                                                {
#ifdef DEBUG
                                                  if (yydebug) printf("UNEQ\n");
#endif
                                                  SE
                                                  ART(UNEQ);
                                                  return token(UNEQ);
                                                }
                                                else
                                                  yyprotcom = yydebcom = 0;
                                              }
"<="                                          { /* <= */
                                                POSITION;
                                                if (yycomc == 0) 
                                                {
#ifdef DEBUG
                                                  if (yydebug) printf("LEEQ\n");
#endif
                                                  SE
                                                  ART(LEEQ);
                                                  return token(LEEQ);
                                                }
                                                else
                                                  yyprotcom = yydebcom = 0;
                                              }
">="                                          { /* >= */
                                                POSITION;
                                                if (yycomc == 0) 
                                                {
#ifdef DEBUG
                                                  if (yydebug) printf("GREQ\n");
#endif
                                                  SE
                                                  ART(GREQ);
                                                  return token(GREQ);
                                                }
                                                else
                                                  yyprotcom = yydebcom = 0;
                                              }
":="                                          { /* := */
                                                POSITION;
                                                if (yycomc == 0) 
                                                {
#ifdef DEBUG
                                                  if (yydebug) printf("IS\n");
#endif
                                                  SE
                                                  ART(IS);
                                                  return token(IS);
                                                }
                                                else
                                                  yyprotcom = yydebcom = 0;
                                              }
"**"                                          { /* ** */
                                                POSITION;
                                                if (yycomc == 0) 
                                                {
#ifdef DEBUG
                                                  if (yydebug) printf("POWER\n");
#endif
                                                  SE
                                                  ART(POWER);
                                                  return token(POWER);
                                                }
                                                else
                                                  REJECT;/*yyprotcom = yydebcom = 0;*/
                                              }
{whitespace}+                                 { /* Leerraum */
                                                int zeichen_gelesen_mem = zeichen_gelesen;
                                                POSITION - 1;
                                                zeichen_gelesen = zeichen_gelesen_mem;
                                                /* Spezialbehandlung */
                                                letzte_laenge += 1;
                                              }
"\n"                                          { /* neue Zeile */
                                                yyposition = -1;
                                              }
.                                             { /* sonstiges */
                                                zeichen_gelesen = 1;
                                                if (yycomc == 0) 
                                                {
#ifdef DEBUG
                                                  if (yydebug) printf("%s\n",yytext);
#endif
                                                  POSITION; SE
                                                  ART(yytext[0]);
                                                  return token(yytext[0]);
                                                }
                                                else
                                                  yyprotcom = yydebcom = 0;
                                                POSITION;
                                              }
%%

/* ************************************************************************* */
/* ermittelt das Token, das fuer den String in yytext zurueckgegeben wird    */
/*                                                                           */
/* Ergebnis : Tokennummer                                                    */
/*                                                                           */
/* Parameter :                                                               */
/*                                                                           */
/* ************************************************************************* */

int texte()
{ int s = IDENT;
  long yyident;        /* Identifiernummer im WB */

  enterstring(yytext,&yyident,&s);
  if (s == IDENT)
  { SE
    ART(IDENT);
    WERT(ident_nr) = mom_ident_nr = yyident;
  }
  else
  { SE
    ART(s);
  }
  return s;
}

/* ************************************************************************* */
/* was tun am Dateiende. Kommentarfehler melden und Programm abschliessen    */
/*                                                                           */
/* Ergebnis : 1 = absolutes Ende, 0 = weiter lesen                           */
/*                                                                           */
/* Parameter :                                                               */
/*                                                                           */
/* ************************************************************************* */

yywrap()
{      register int count;
       int saveline, savepos;
       char ch;
                   
       max_zeilenzahl = yylineno;
       if (zeichen_gelesen == 0)
       { no_char_read = 1; }
       if (yycomc)
       {       saveline = yylineno;
               savepos = yyposition;
               ch = yytext[0];
               for (count = 0; (count < yycomc) &&
                               (count < MAX_COM); count++)
               {       yylineno = yycomline[count];
                       sp_pos = yycompos[count];
                       parsestate = -1;
                       yyerror(NULL,NULL);
                       yynerrs++;
                       do_fehler_warn(1,yynerrs);
                       fehler(text[102]);
               }
               yylineno = saveline;
               sp_pos = savepos;
               if (yycomc > MAX_COM)
               {       parsestate = -1;
                       yyerror(NULL,NULL);
                       yynerrs++;
                       do_fehler_warn(1,yynerrs);
                       fehler(text[103]);
               }
               yytext[0] = ch;
       }
       return(1);
}

/* ************************************************************************* */
/* fuegt Protokoll- und Funktionsdebug-Information in Liste ein              */
/*                                                                           */
/* Ergebnis : Liste mit neuem Element                                        */
/*                                                                           */
/* Parameter : Liste an die es angehaengt wird                               */
/*                                                                           */
/* ************************************************************************* */

static PROTOKOLL * anhaengen(p)
PROTOKOLL * p;
{ PROTOKOLL * p1;
  int i = IDENT;
  GET_MEM(p1,1,PROTOKOLL);
  enterstring(yytext,&p1->name_nr,&i);
  p1->link = p;
  return p1;
}

#ifdef MAC
#undef NLSTATE
#endif
  
