static char _sccsid[] = "Parallaxis Version: @(#)actions.c	2.13  2/28/92 15:00:01";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : actions.c                                                         */
/*                                                                           */
/* semantische Funktionen im Parser                                          */
/*                                                                           */
/* ************************************************************************* */


# include "defines.h"
# include "typen.h"
# include "makro.h"
# include "parallax.h"
# include "symbols.h"
# include "y_tab.h"
# include "procs.h"

extern int Zeile, Posit;
extern int leeres_statement, fieldlistident;
extern int yychar;
extern char * perrortext[];  /* 'erwartet wird' Fehlermeldungstexte */
extern int parseerror[];

int akt_conf_nr = 0;    /* Nummer der Topologie */
extern int akt_conf_group; /* Nummer der Topologiegruppe */
extern ST_TYPE * typ_int;

Const_eintragen(c)
T_CONSTDECL * c;
{ int dummy;
  Eintrag * ein;
  if (c)
  { if (c->link)
      Const_eintragen(c->link);
    ein = mache_Eintrag(c->ident->wert.ident_nr,&dummy,N_CONSTANT);
    if (dummy)
    { ein->Art = N_UNDEF;
      SEMERROR(ein->Zeile,ein->Posit,c->ident->Zeile,c->ident->Posit,
               text[113]);
    }
    else
    { ein->Zeile = c->ident->Zeile;
      ein->Posit = c->ident->Posit;
    }
  }
}


Type_eintragen(t)
T_TYPEDECL * t;
{ int dummy;
  Eintrag * ein;
  if (t)
  { if (t->link)
      Type_eintragen(t->link);
    ein = mache_Eintrag(t->ident->wert.ident_nr,&dummy,N_TYPE);
    if (dummy)
    { ein->Art = N_UNDEF;
      SEMERROR(ein->Zeile,ein->Posit,t->ident->Zeile,t->ident->Posit,
               text[113]);
    }
    else
    { ein->Zeile = t->ident->Zeile;
      ein->Posit = t->ident->Posit;
    }
    typ_eintragen(t->type);
  }
}

identlist_eintragen(i,art)
T_IDENTLIST * i;
int art;
{ int dummy;
  Eintrag * ein;
  if (i)
  { if (i->link)
      identlist_eintragen(i->link,art);
    i->ein = ein = mache_Eintrag(i->ident->wert.ident_nr,&dummy,art);
    if (dummy)
    { ein->Art = N_UNDEF;
      SEMERROR(ein->Zeile,ein->Posit,i->ident->Zeile,i->ident->Posit,
               text[113]);
    }
    else
    { ein->Zeile = i->ident->Zeile;
      ein->Posit = i->ident->Posit;
    }
  }
}    

Config_eintragen(c)
T_CONFIG * c;
{ int dummy;
  Eintrag * ein;

  if (c)
  { if (c->link)
      Config_eintragen(c->link);
    ein = mache_Eintrag(c->ident->wert.ident_nr,&dummy,N_CONFIGURATION);
    if (dummy)
    { ein->Art = N_UNDEF;
      SEMERROR(ein->Zeile,ein->Posit,c->ident->Zeile,c->ident->Posit,
               text[113]);
    }
    else
    { ein->param.config.tab = vector_ST;
      ein->param.config.conf_nr = ++akt_conf_nr;
      ein->param.config.conf_group = akt_conf_group;
      if (c->ranges)
      { ein->param.config.dim_anz = c->ranges->count; }
      else
      { ein->param.config.dim_anz = 0; }
      ein->Zeile = c->ident->Zeile;
      ein->Posit = c->ident->Posit;
    }
  }
}


Vardef_eintragen(v,art)
T_VARDEF * v;
int art;
{ if (v)
  { Vardef_eintragen(v->link,art);
    identlist_eintragen(v->ident_list,art);
    typ_eintragen(v->type);
  }
}

typ_eintragen(t)
T_TYPE * t;
{ if (t)
  { switch (t->art)
    { case TY_ENUM :
        enum_typ_eintragen(t);
        break;
      case TY_SET :
        enum_typ_eintragen(t->typ.settyp);
        break;
      case TY_ARRAY :
        array_typ_eintragen(t);
        break;
      case TY_RECORD :
        record_typ_eintragen(t);
        break;
    }
  }
}

enum_typ_eintragen(t)
T_TYPE * t;
{ if (t)
    if (t->art == TY_ENUM)
      if (t->typ.identlist)
        identlist_eintragen(t->typ.identlist,N_CONSTANT);
}

array_typ_eintragen(t)
T_TYPE * t;
{ if (t)
  { enum_typ_eintragen(t->typ.array.dimen);
    typ_eintragen(t->typ.array.type);
  }
}

record_typ_eintragen(t)
T_TYPE * t;
{ if (t)
    recdef_typ_eintragen(t->typ.record.fieldlist);
}

recdef_typ_eintragen(r)
T_RECDEF * r;
{ if (r && (r != silly))
  { if (r->select == REC_NORM)
    { if (r->art.norm)
        typ_eintragen(r->art.norm->type);
    }
    else
    { typ_eintragen(r->art.selected.typ);
      variant_typ_eintragen(r->art.selected.vari);
      recdef_typ_eintragen(r->art.selected.elseteil);
    }
  }
}

variant_typ_eintragen(v)
T_VARIANT * v;
{ if (v)
  { variant_typ_eintragen(v->link);
    recdef_typ_eintragen(v->fieldlist);
  }
}

Procedure_eintragen(i,p)
SCAN_ELEM * i;
T_PROCEDECL * p;
{ int dummy;
  Eintrag * ein;
  if (p)
  { if (p->ident = i)
    { p->reference = ein = mache_Eintrag(i->wert.ident_nr,&dummy,N_PROCEDURE);
      if (dummy)
      { ein->Art = N_UNDEF;
        SEMERROR(ein->Zeile,ein->Posit,i->Zeile,i->Posit,
                 text[113]);
      }
      else
      { ein->Zeile = i->Zeile;
        ein->Posit = i->Posit;
/*        ein->param.proz.conf_nr = akt_conf_nr;*/
      }
    }
    p->ST = vector_ST;
    vector_ST = akt_ST = neue_ST(akt_ST,1);
    param_eintragen(p->paramseq);
    typ_eintragen(p->type);
    if (p->type)
    { ein = mache_Eintrag(0l,&dummy,(p->scavec->Art == _SCALAR) ? N_SCALAR : N_VECTOR); }
  }
}

param_eintragen(par)
T_PARAM * par;
{ if (par)
  { if (par->link)
      param_eintragen(par->link);
    Vardef_eintragen(par->vardef,((par->skavecvar & P_SCALAR) ? N_SCALAR : N_VECTOR) |
                                 ((par->skavecvar & P_VAR) ? N_VAR : 0));
  }
}

Transfer_eintragen(t)
T_TRANSFER * t;
{ int dummy, sort;
  Eintrag * ein;
  if (t)
  { if (t->link)
      Transfer_eintragen(t->link);
    sort = (t->out_ident->Const) ? ((t->arrow) ? N_IOK : N_OUTPUTK)
                                 : ((t->arrow) ? N_IO : N_OUTPUT);
    ein = mache_Eintrag(t->out_ident->ident->wert.ident_nr,&dummy,sort);
    t->out_ident->timestamp = timestamp;
    if (dummy && (ein->Art != sort))
    { if ((ein->Art != ((t->out_ident->Const) ? N_INPUTK : N_INPUT)) &&
          (ein->Art != ((t->out_ident->Const) ? N_OUTPUTK : N_OUTPUT)) &&
          (ein->Art != ((t->out_ident->Const) ? N_IOK : N_IO)))
      { ein->Art = N_UNDEF;
        SEMERROR(ein->Zeile,ein->Posit,
                 t->out_ident->ident->Zeile,t->out_ident->ident->Posit,
                 text[113]);
      }
      else
      { ein->Art = (t->out_ident->Const) ? N_IOK : N_IO; }
    }
    if (!dummy)
    { ein->Zeile = t->out_ident->ident->Zeile;
      ein->Posit = t->out_ident->ident->Posit;
    }
    switch (ein->Art)
    { case N_INPUTK :
      case N_OUTPUTK :
      case N_IOK :
        ein->param.inout.von = 1;
        ein->param.inout.bis = 0;
        break;
    }
    Destination_eintragen(t->destinations,t->arrow);
  }
}

Destination_eintragen(d,arr)
T_DESTINATION * d;
int arr;
{ int dummy, sort;
  Eintrag * ein;
  if (d)
  { if (d->link)
      Destination_eintragen(d->link);
    if (d->in_ident){
    sort = (d->in_ident->Const) ? ((arr) ? N_IOK : N_INPUTK)
                                 : ((arr) ? N_IO : N_INPUT);
    ein = mache_Eintrag(d->in_ident->ident->wert.ident_nr,&dummy,sort);
    d->in_ident->timestamp = timestamp;
    if (dummy && (ein->Art != sort))
    { if ((ein->Art != ((d->in_ident->Const) ? N_OUTPUTK : N_OUTPUT)) &&
          (ein->Art != ((d->in_ident->Const) ? N_INPUTK : N_INPUT)) &&
          (ein->Art != ((d->in_ident->Const) ? N_IOK : N_IO)))
      { ein->Art = N_UNDEF;
        SEMERROR(ein->Zeile,ein->Posit,d->in_ident->ident->Zeile,d->in_ident->ident->Posit,
                 text[113]);
      }
      else
      { ein->Art = (d->in_ident->Const) ? N_IOK : N_IO; }
    }
    if (!dummy)
    { ein->Zeile = d->in_ident->ident->Zeile;
      ein->Posit = d->in_ident->ident->Posit;
    }
    switch (ein->Art)
    { case N_INPUTK :
      case N_OUTPUTK :
      case N_IOK :
        ein->param.inout.von = 1;
        ein->param.inout.bis = 0;
        break;
    }}
  }
}

proc_mode_anal(d)
T_DECLARATIONS * d;
{ int ret = 0;
  if (d)
  { ret |= proc_mode_anal(d->link);
    switch (d->select)
    { case N_PROCEDURE :
        if (d->art.procs)
          ret |= d->art.procs->proc_info;
        break;
      case N_CONFIGURATION :
        return SELEKTION;
    }
  }
  return ret;
}







