static char _sccsid[] = "Parallaxis Version: @(#)hilfsvar.c	2.13  2/28/92 15:09:58";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : hilfsvar.c                                                        */
/*                                                                           */
/* Funktionen, die die Hilfsvariablen erzeugen und verwalten                 */
/*                                                                           */
/* ************************************************************************* */


#include "defines.h"
#include "pass2.h"

extern ST_TYPE * typ_s;
extern WITH_COMP * wcomp;

#ifdef DEBUG
extern no_internal;
#endif

/* ************************************************************************* */
/* Hilfsvariable nicht zaehlen da sie zu konstantem AND bzw. OR gehoert      */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Hilfsvariable                                                 */
/*                                                                           */
/* ************************************************************************* */

no_count(var,mode)
VARNODE * var;
int mode;
{ int ruse = reusevar;
  HVARS * help;
  if (var)
  { reusevar = 1;
    free_hvar(var);
    reusevar = ruse;
    if (mode)
      help = var->ein->param.var.list;
    else
      help = hvarsscal;
    while (help)
    { if (help->typ == typ_bool)
      { help->totalanz--;
        return;
      }
      help = help->link;
    }
  }
}



/* ************************************************************************* */
/* Hole neue Hilfsvariable                                                   */
/*                                                                           */
/* Ergebnis : Hilfsvariable                                                  */
/*                                                                           */
/* Parameter : Datentyp                                                      */
/*             skalar oder vektoriell                                        */
/*                                                                           */
/* ************************************************************************* */

Eintrag * get_hvar(typ,scavec)
ST_TYPE * typ;
int scavec;
{ HVARS * help;
  Eintrag * ein;
  int len;
  ST_TYPE * mem_typ;
#ifdef DEBUG
  if (interpreter)
    printf("get_hvar : Variable trotz Fehler ?\n");
#endif
  switch (scavec) /* skalare oder vektorielle Hilfsvariable */
  { case 1 :
      help = hvarsvect;
      break;
    case 0 :
      help = hvarsscal;
      break;
    default :
      bug("get_hvar: scavec");
      return NULL;
  }
  if (typ->Art == ST_TSARRAY)
      /* konstanter String als Parameter uebergeben ==> an Hilfsvariable(n) zuweisen */
  { len = typ->info.array.bereich->info.range.bis;
    mem_typ = typ;
    typ = typ_s;
  }
  if (typ->Art == ST_TRANGE)
      /* Aufzaehlung entspricht Integer */
  { typ = typ_int; }
  if (typ->Art == ST_TSUBRANGE)
  { if (typ->info.range.super == typ_char)
        /* Unterbereich mit Char */
    { typ = typ_char; }
    else
    { typ = typ_int; }
  }
  if (help == NULL)
      /* noch nie benutzt */
  { GET_MEM(help,1,HVARS);
    help->ein = NULL;
    help->anz = 0;
    help->typ = typ;
    switch (scavec)
    { case 1 :
        hvarsvect = help;
        break;
      case 0 :
        hvarsscal = help;
        break;
      default :
        bug("get_hvar: na sowas");
        return NULL;
    }
  }
  while (help != NULL)
     /* suche die Liste mit dem entsprechenden Typ */
  { if (help->typ == typ)
    { if (help->ein != NULL)
      { if (typ == typ_s)
            /* String muss hineinpassen */
        { Eintrag * e1, * e2;
          e1 = NULL;
          e2 = help->ein;
          while ((e2 != NULL) &&
                 (e2->param.var.type->info.array.bereich->info.range.bis < len))
              /* FIRST-FIT */
          { e1 = e2;
            e2 = e1->link;
          }
          if (e2 == NULL)
              /* kein passender Bereich gefunden, neue Hilfsvariable erzeugen */
          { GET_MEM(ein,1,Eintrag);
            ein->Art = (scavec == 1) ? N_VECTOR : N_SCALAR;
            ein->param.var.type = mem_typ;
            ein->param.var.art = CHAR;
            ein->param.var.nummer = -1;
            ein->param.var.list = help;
            help->anz++;
            help->totalanz += len + 1;
          }
          else
          { /* passenden Bereich aushaegen */
            if (e1 == NULL)
            { ein = help->ein;
              help->ein = ein->link;
              ein->link = NULL;
              help->totalanz += len + 1;
            }
            else
            { ein = e2;
              e1->link = e2->link;
              ein->link = NULL;
              help->totalanz += len + 1;
            }
          }
        }
        else
          /* normale Variablen, erste Variable nehmen */
        { ein = help->ein;
          help->ein = ein->link;
          ein->link = NULL;
          help->totalanz++;
        }
      }
      else
         /* neue Variable erzeugen */
      { GET_MEM(ein,1,Eintrag);
        ein->Art = (scavec == 1) ? N_VECTOR : N_SCALAR;
        if (typ == typ_s)
        { ein->param.var.type = mem_typ; }
        else
        { ein->param.var.type = typ; }
        ein->param.var.art = typ->firstelem;
        ein->param.var.nummer = -1;
        ein->param.var.list = help;
        help->anz++;
        help->totalanz++;
      }
      return ein;
    }
    else
        /* Variablentyp tritt neu auf */
    { if (help->link == NULL)
      { HVARS * h;
        GET_MEM(h,1,HVARS);
        h->ein = NULL;
        h->anz = 0;
        h->totalanz = 0;
        h->typ = typ;
        help->link = h;
      }
      else
      { help = help->link; }
    }
  }
 return NULL;
}
      
/* ************************************************************************* */
/* erzeugt Variablenknoten zu einem Ausdruck                                 */
/*                                                                           */
/* Ergebnis : Variablenknoten                                                */
/*                                                                           */
/* Parameter : Ausdruck                                                      */
/*                                                                           */
/* ************************************************************************* */

VARNODE * neue_hv(expr)  /* liefert die Zieladresse fuer die Operation */
T_EXPR * expr;
{ VARNODE * var;
#ifdef DEBUG
  if (interpreter)
    printf("neue_hv : Variable trotz Fehler ?");
#endif
  if (expr->hv == NULL)
      /* keine Variable als Ziel vorgesehen, Hilfsvariable holen */
  { GET_MEM(var,1,VARNODE);
    var->lk = VARi;
    VARi = var;
    var->ein = get_hvar(expr->erg_typ,var->scavec = expr->scavec);
    var->free = 1;
    expr->hv = var;
  }
  else
      /* vorgesehene Variable benutzen */
  { var = expr->hv; }
  return var;
}

/* ************************************************************************* */
/* Gebe Hilfsvariable wieder frei                                            */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Variablenknoten                                               */
/*                                                                           */
/* ************************************************************************* */

free_hvar(var)
VARNODE * var;
{ ST_TYPE * typ;
  HVARS * help;
  Eintrag * ein;
  int nein;
  if (reusevar)  /* soll die Variable freigegeben werden ? */
  { while (var != NULL)
      /* Variablenkette abarbeiten */
    { nein = var->free;
      if (nein == 1)
          /* Variable soll freigegeben werden */
      { ein = var->ein;
        switch (ein->Art)
              /* skalar oder vektoriell */
        { case N_SCALAR :
            help = hvarsscal;
            break;
          case N_VECTOR :
            help = ein->param.var.list;
            break;
          default :
            nein = 0;
            break;
        }
        if ((ein->param.var.nummer < 0) && (nein == 1))
            /* nur Variablen ohne Nummer freigeben */
        { if (ein->link == NULL)
             /* keine Endlosschleifen zulassen */
          { typ = ein->param.var.type;
            if (typ->Art == ST_TSARRAY)
               /* String als Parameter */
            { typ = typ_s; }
            while (help != NULL)
                /* vorne in die passende Liste einhaengen */
            { if (help->typ == typ)
              { ein->link = help->ein;
                help->ein = ein;
              }
              help = help->link;
            }
          }
          else
          { /* sollte nicht auftreten: Endlosschleife kann entstehen */
#ifdef DEBUG
            if (no_internal) printf("Hilfe ********** %x\n",ein);
#endif
          }
        }
      }
      var->free = 0; /* nicht doppelt freigeben */
      var = var->link; /* der naechste bitte */
    }
  }
}

/* ************************************************************************* */
/* erzeuge die PARZ-Variablenbezeichnung fuer Komponentennamen nach WITH     */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Komponentenlist                                               */
/*                                                                           */
/* ************************************************************************* */

vergebe_comp_nummer(wc)
WITH_COMP * wc;
{ if (wc != NULL)
  { vergebe_comp_nummer(wc->link);
       /*  Ebene und Nummer von den Hilfsvariablen uebernehmen */
    wc->komp->param.var.ebene = wc->hvar->param.var.ebene;
    wc->komp->param.var.nummer = wc->hvar->param.var.nummer;
    my_free(wc);
  }
  wcomp = NULL;
}

/* ************************************************************************* */
/* vergebe die PARZ-Variablenbezeichnung fuer die Hilfsvariablen             */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Liste aller Hilfsvariablen                                    */
/*             Feld mit der Gesamtzahl der Variablen pro PARZ-Typ            */
/*             Feld mit der Gesamtzahl der Variablen pro PARZ-Typ fuer die   */
/*                  theoretisch benoetigten Variablen                        */
/*             Nummer der Prozedurebene                                      */
/*                                                                           */
/* ************************************************************************* */

vergebe_var_nummer(liste,feld1,feld2,ebene)
HVARS * liste;
int feld1[], feld2[];
int ebene;
{ Eintrag * ein;
  ST_TYPE * t;
  int zaehl, nr;
  while (liste != NULL)
      /* fuer alle Listen */
  { ein = liste->ein;
    zaehl = 0;
    while (ein != NULL)
      /* fuer alle Eintraege */
    { zaehl++;
      nr = feld1[ein->param.var.art];
      ein->param.var.nummer = nr + 1;
      ein->param.var.ebene = ebene;
      t = ein->param.var.type;
      for (nr = BOOLEAN; nr <= ALL; nr++)
      { feld1[nr] += t->used[nr]; }
      ein = ein->link;
    }
    /* wieviele waeren benoetigt worden ohne Freigabe ? */
    if ((t = liste->typ) != typ_s)
      /* Strings sind was besonderes */
    { for (nr = BOOLEAN; nr <= ALL; nr++)
      { feld2[nr] += t->used[nr] * liste->totalanz; }
    }
    else
    { feld2[CHAR] += liste->totalanz;
      feld2[ALL] += liste->totalanz;
    }
    if (zaehl != liste->anz)
      /* sind soviele bearbeitet worden wie alloziert wurden ? */
    { bug("vergebe_var_nummer %d %d",zaehl,liste->anz); }
    liste = liste->link;
  }
}

/* ************************************************************************* */
/* pruefe, ob  Variablenknoten eine Hilfsvariable enthaelt                   */
/*                                                                           */
/* Ergebnis : JA oder NEIN                                                   */
/*                                                                           */
/* Parameter : Variablenknoten                                               */
/*                                                                           */
/* ************************************************************************* */

int hilfs_var(var)
VARNODE * var;
{ if ((var != NULL) &&
      ((var->ein->Art == N_SCALAR) || (var->ein->Art == N_VECTOR)) &&
      (var->ein->param.var.nummer == -1))
    return JA;
  return NEIN;
}

