static char _sccsid[] = "Parallaxis Version: @(#)list.c	2.13  2/28/92 15:09:58";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei :list.c                                                             */
/*                                                                           */
/* Ausgabe des Listings mit den Fehler- und Warnmeldungen                    */
/*                                                                           */
/* ************************************************************************* */


#include "outputx.h"

/* ************************************************************************* */
/* Ausgabe der des Listings mit Fehlermeldungen                              */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter :                                                               */
/*                                                                           */
/* ************************************************************************* */

listing(infile,listname/*,yynerrs*/)
char * infile;
char * listname;
/*int yynerrs;*/
{ if ((no_char_read == 0) && (listingausgeben /*|| yynerrs*/))
  { if (listname == NULL)
    { int l;
      if (infile == NULL)
      { if (!pipeline)
          fprintf(stderr,"cannot create the filename for the listing\n");
        return;
      }
      GET_MEM(listname,(l = my_strlen(infile)) + 6,char);
      if ((infile[l-2] == '.') && (infile[l-1] == 'z'))
      { strcpy(listname,infile);
        strcpy(&listname[l-1],"list");
      }
      else
      { strcpy(listname,infile);
        strcpy(&listname[l],".list");
      }
    }
    if ((listfile = fopen(listname,"w")) != NULL)
    { listing_ausgeben(); }
    else
    { fprintf(stderr,text[32],listname); }
  }
}

/* ************************************************************************* */
/* Ausgabe der des Listings mit Fehlermeldungen                              */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter :                                                               */
/*                                                                           */
/* ************************************************************************* */

listing_ausgeben()
{ int i = 1;
  ZEILE * line = list_anf;
  fprintf(listfile,"%s",text[97]);
  while (line != NULL)
  { if (i == line->nummer)
    { if (i == max_zeilenzahl)
      { fprintf(listfile,"%s\n",text[96]);
        fehlerausgeben(line,0);
        line = line->next;
      }
      else
      { fprintf(listfile,"%5d     %s\n",i,line->sourcetext);
        fehlerausgeben(line,1);
        line = line->next;
      }
    }
    else
    { fprintf(listfile,"%5d\n",i); }
    i++;
  }
}

/* ************************************************************************* */
/* Ausgabe der Fehlermeldungen im Listing                                    */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Zeileninformationsstruktur                                    */
/*             Positionsmarker erforderlich ?                                */
/*                                                                           */
/* ************************************************************************* */

fehlerausgeben(z,posit)
ZEILE * z;
int posit;
{ FEHLER_WARN * fw;
  if ((z != NULL) && ((fw = z->fehl_warn) != NULL))
  { char * s = z->sourcetext;
    int i;
    while (fw != NULL)
    { if (fw->fehl_warn == 0)
      { fprintf(listfile,text[73]); }
      else
      { fprintf(listfile,text[74]); }
      if (posit)
      { for (i = 0; i < fw->posit1; i++)
          fprintf(listfile,"%c",(s[i] == '\t') ? '\t' : ' ');
        if (i++ < fw->posit2)
        { fprintf(listfile,"^");
          while (i < fw->posit2)
            fprintf(listfile,"%c",(s[i++] == '\t') ? '\t' : ' ');
        }
        if (fw->state < 0)
          fprintf(listfile,"^\n****(%4d)  %s\n",fw->nummer,fw->str);
        else
          if (fw->str && (*fw->str != '\0'))
            fprintf(listfile,"^\n****(%4d)  %s%s\n\t\t\t%s\n",fw->nummer,text[88],
                             perrortext[parseerror[fw->state]],fw->str);
          else
            fprintf(listfile,"^\n****(%4d)  %s%s\n",fw->nummer,text[88],
                             perrortext[parseerror[fw->state]]);
      }
      else
      { if (fw->state < 0)
          fprintf(listfile,"\n****(%4d)  %s\n",fw->nummer,fw->str);
        else
          if (*fw->str != '\0')
            fprintf(listfile,"\n****(%4d)  %s%s\n\t\t\t%s\n",fw->nummer,text[88],
                             perrortext[parseerror[fw->state]],fw->str);
          else
            fprintf(listfile,"\n****(%4d)  %s%s\n",fw->nummer,text[88],
                             perrortext[parseerror[fw->state]]);
      }
      fw = fw->link;
    }
  }
}

