static char _sccsid[] = "Parallaxis Version: @(#)param.c	2.13  2/28/92 15:10:02";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : param.c                                                           */
/*                                                                           */
/* Funktionen, die die Parameterliste von Prozeduren und Funktionen pruefen  */
/*                                                                           */
/* ************************************************************************* */


#include "pass2.h"

int param_anz;
ST_PARAM * param_typ;
extern ZWCODE * nach_pruefung;

/* ************************************************************************* */
/* Negation eines Ausdrucks                                                  */
/*                                                                           */
/* Ergebnis : Zwischencode fuer Parameteranalyse                             */
/*                                                                           */
/* Parameter : Namensliste                                                   */
/*             Datentyp der Parameter                                        */
/*             skalar oder vektoriell                                        */
/*             direkt oder indirekt                                          */
/*                                                                           */
/* ************************************************************************* */

ZWCODE * parameter_code(idlist,type,scavec,mode)
T_IDENTLIST * idlist;
ST_TYPE * type;
int scavec, mode;
{ if (idlist != NULL)
  { ZWCODE * zw;
    VARNODE * var;
    Eintrag * ein;
    GET_MEM(zw,1,ZWCODE);
    if (idlist->link != NULL)
      zw->link = parameter_code(idlist->link,type,scavec,mode);
    ein = suche_Eintrag(idlist->ident->wert.ident_nr,vector_ST,LOCAL,0);
    if (ein == NULL)
      bug("parameter_code");
    if (interpreter)
      return NULL;
    switch (ein->param.var.type->Art)
    { case ST_TINT :
      case ST_TCHAR :
      case ST_TRANGE :
      case ST_TREAL :
      case ST_TBOOL :
      case ST_TSUBRANGE :
      case ST_TDIM :
      case ST_TID_NO :
      case ST_TPOINTER :
        zw->art = CO_POP;
        GET_MEM(var,1,VARNODE);
        var->lk = VARi;
        VARi = var;
        var->ein = ein;
        var->dir_indir = mode;
        var->scavec = scavec;
        zw->com.pop.erg = var;
        zw->com.pop.scavec = scavec;
        idlist->zeilen = 1;
        break;
      case ST_TSET :
      case ST_TRECORD :
      case ST_TARRAY :
        if (mode == INDIRECT)
        { zw->art = CO_POP;
          GET_MEM(var,1,VARNODE);
          var->lk = VARi;
          VARi = var;
          var->ein = ein;
          var->dir_indir = DIRECT;
          var->scavec = scavec;
          zw->com.pop.erg = var;
          zw->com.pop.scavec = scavec;
          idlist->zeilen = 1;
        }
        else
        { zw->art = CO_POPBLOCK;
          GET_MEM(var,1,VARNODE);
          var->lk = VARi;
          VARi = var;
          var->ein = ein;
          var->dir_indir = DIRECT;
          var->scavec = scavec;
          zw->com.popblock.erg = var;
          GET_MEM(var,1,VARNODE);
          var->lk = VARi;
          VARi = var;
          var->ein = get_hvar(typ_int,scavec);
          var->dir_indir = DIRECT;
          var->scavec = scavec;
          var->firstelem = ein->param.var.type->firstelem;
          var->free = 1;
          zw->com.popblock.temp = var;
          zw->com.popblock.scavec = scavec;
          zw->com.popblock.typ = type;
          idlist->zeilen = 2;
          free_hvar(var);
        }
        break;
    }
    return zw;
  }
  return NULL;
}

/* ************************************************************************* */
/* erzeuge Liste der Parameter fuer den Eintrag der Prozedur in der ST       */
/*                                                                           */
/* Ergebnis :Parameterliste in ST-Form                                       */
/*                                                                           */
/* Parameter : Parameterliste in Syntax-Form                                 */
/*                                                                           */
/* ************************************************************************* */

ST_PARAM * erzeuge_param(p)
T_PARAM * p;
{ ST_PARAM * prev, * erg;
  int partyp, mode;
  prev = NULL;
  while (p != NULL)
  { partyp = p->skavecvar;
    mode = ((partyp & P_VECTOR) ? N_VECTOR : N_SCALAR) |
           ((partyp & P_VAR) ? N_VAR : 0);
    if ((prev != NULL) &&
        (p->paramtyp == prev->type) &&
        (mode == prev->mode))
    { prev->anzahl += p->par_anz; }
    else
    { GET_MEM(erg,1,ST_PARAM);
      erg->type = p->paramtyp;
      erg->mode = mode;
      erg->link = prev;
      erg->anzahl = p->par_anz;
      prev = erg;
    }
    p = p->link;
  }
  return prev;
} 

/* ************************************************************************* */
/* erzeuge Zwischencode der Parameter                                        */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Parameterliste in Syntax-Form                                 */
/*                                                                           */
/* ************************************************************************* */

erzeuge_param_code(p)
T_PARAM * p;
{ int partyp, mode, scavec;
  T_IDENTLIST * id;
  while (p != NULL)
  { partyp = p->skavecvar;
    mode = ((partyp & P_VECTOR) ? N_VECTOR : N_SCALAR) |
           ((partyp & P_VAR) ? N_VAR : 0);
    scavec = (partyp & P_VECTOR) ? 1 : 0;
    if ((p->vardef == NULL) || ((id = p->vardef->ident_list) == NULL))
      return;
    if (mode & N_VAR)
    { p->code = parameter_code(id,p->paramtyp,scavec,INDIRECT);
      p->zeilen = id->count;
    }
    else
    { p->code = parameter_code(id,p->paramtyp,scavec,DIRECT);
      p->zeilen += id->zeilen * id->count;
    }
    p = p->link;
  }
} 

/* ************************************************************************* */
/* trage die Parameternamen in die Prozedursymboltabelle ein                 */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Parameterliste in Syntax-Form                                 */
/*                                                                           */
/* ************************************************************************* */

trage_param_ein(p)
T_PARAM * p;
{ T_IDENTLIST * list;

  if (p != NULL)
  { if (p->link != NULL)
    { trage_param_ein(p->link); }
    if ((p->vardef != NULL) && p->vardef->ident_list)
    { if ((list = p->vardef->ident_list) != NULL)
      { p->par_anz = list->count;
        set_typlist(p->vardef->type,FREE);
        trage_var_ein(list,p->paramtyp = p->vardef->type->erg_typ);
      }
    }
  }
}

/* ************************************************************************* */
/* pruefe ob Liste von Ausdruecken mit Paramterliste vertraeglich ist        */
/*                                                                           */
/* Ergebnis : JA oder NEIN                                                   */
/*                                                                           */
/* Parameter : Parameterliste in ST-Form                                     */
/*             Liste von Ausdruecken                                         */
/*             Zeilennummer                                                  */
/*             Spaltennummer des Funktionsnamen                              */
/*                                                                           */
/* ************************************************************************* */

int teste_parameter(pa,expr,z,p)
ST_PARAM * pa;
T_EXPR * expr;
int z,p;
{ param_typ = pa;
  if (pa == NULL)
  { param_anz = 0; }
  else
  { param_anz = pa->anzahl; }
  if ((expr == NULL) && (pa == NULL))
    return JA;
  if ((pruefe_parameter(expr) == JA) && (param_typ != NULL) && (param_anz == 0) &&
      (param_typ->link == NULL))
    return JA;
  if (param_typ != NULL)
  { SEMERROR(z,p,0,0,text[295]);
    interpreter = 1;
  }
  if (param_typ == NULL)
  { SEMERROR(z,p,0,0,text[286]);
    interpreter = 1;
  }
  return NEIN;
}             

/* ************************************************************************* */
/* pruefe ob ein Ausdruck mit einem Parameter vertraeglich ist               */
/*                                                                           */
/* Ergebnis : JA oder NEIN                                                   */
/*                                                                           */
/* Parameter : Ausdruck                                                      */
/*                                                                           */
/* ************************************************************************* */

int pruefe_parameter(expr)
T_EXPR * expr;
{ int rueck = JA;
  if (expr != NULL)
  { if (expr->link != NULL)
      rueck = pruefe_parameter(expr->link);
    if (param_typ == NULL)
      return NEIN;
    if (param_anz == 0)
    { param_typ = param_typ->link;
      if (param_typ == NULL)
      { param_anz = 1;
        return NEIN;
      }
      param_anz = param_typ->anzahl;
    }
    param_anz--;
    if (expr->error != 0)
      return NEIN;
    if (match_typen(expr->erg_typ,param_typ->type,
                    ((param_typ->mode & N_VAR) == N_VAR) ? 2 : 0) != JA)
    { SEMERROR(expr->Zeile,expr->Posit,0,0,text[319]);
      interpreter = 1;
      return NEIN;
    }
    if ((expr->scavec == 1) &&
        ((param_typ->mode & (N_VAR - 1)) == N_SCALAR))
    { SEMERROR(expr->Zeile,expr->Posit,0,0,text[313]);
      interpreter = 1;
      return NEIN;
    }
    if ((param_typ->mode & N_VAR) == N_VAR)
    { if (expr->erg_art != ERG_SPEC)
      { SEMERROR(expr->Zeile, expr->Posit,0,0,text[320]);
        interpreter = 1;
        return NEIN;
      }
      else
      { ZWCODE * zw;
        T_EXPR ex;
        if (((param_typ->mode & (N_VAR - 1)) == N_VECTOR) && (expr->scavec == 0))
        { SEMERROR(expr->Zeile,expr->Posit,0,0,text[283]);
          interpreter = 1;
          return NEIN;
        }
        ex.erg_typ = param_typ->type;
        ex.hv = expr->hv;
        ex.code = NULL;
        ex.zeilen = 0;
        ex.erg_art = ERG_SPEC;
        ex.error = 0;
        zw = check_ranges(&ex,expr->erg_typ);
        if (zw)
        { if (nach_pruefung)
          { ZWCODE * zw1 = nach_pruefung;
            while (zw1->link)
            { zw1 = zw1->link; }
            zw1->link = zw;
          }
          else
            nach_pruefung = zw;
        }
        expr->zeilen += ex.zeilen;
      }
    }      
    if (((param_typ->mode & N_VAR) == 0) && (expr->erg_art == ERG_SPEC))
    { expr->erg_art = ERG_VAR; }
    if (((expr->erg_art == ERG_PROC) || (expr->erg_art == ERG_RAND) ||
         (expr->erg_art == ERG_CONST)) &&
        (interpreter == 0))
    { expr->scavec = ((param_typ->mode & ~N_VAR) == N_SCALAR) ? 0 : 1;
      mache_Constexpr(expr,param_typ->type,0);
    }
    else
    { if ((interpreter == 0) && (expr->erg_art == ERG_REC))
        Zuweisung(expr,neue_hv(expr));
      else
      { if (interpreter == 0)
        { check_ranges(expr,param_typ->type); }
      }
    }
    if ((expr->scavec == 0) &&
        ((param_typ->mode & (N_VAR - 1)) == N_VECTOR))
    { expr->scavec = 2; }
    return rueck;
  }
  return NEIN;
}

/* ************************************************************************** */
/* trage Parameter in Symboltabelle ein und erzeuge Parameterliste in ST-Form */
/*                                                                            */
/* Ergebnis :                                                                 */
/*                                                                            */
/* Parameter : Symboltabelleneintrag des Prozedurnamens                       */
/*             Parameterliste in Syntax-Form                                  */
/*                                                                            */
/* ************************************************************************** */

setze_parameter(ein,p)
Eintrag * ein;
T_PARAM * p;
{ /* setzt die Parameter in den ST-Eintrag des Prozedurnamens */
  trage_param_ein(p);
  ein->param.proz.param = erzeuge_param(p);
}

