static char _sccsid[] = "Parallaxis Version: @(#)typ.c	2.14  10/27/92 08:02:07";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : typ.c                                                             */
/*                                                                           */
/* Funktionen zur Verarbeitung der Datentypen                                */
/*                                                                           */
/* ************************************************************************* */

#include "pass2.h"
#include "scope.h"

extern char * getstring();
static int Zeile, Posit;

typ_anal(t)
T_TYPEDECL * t;
{ Eintrag * rueck;
  SCAN_ELEM * name;

  if (t)
  { typ_anal(t->link);
    if ((name = t->ident) != NULL)
    { rueck = suche_Eintrag(name->wert.ident_nr,vector_ST,GLOBAL,0);
      if (rueck->Art == N_TYPE)
      { /* Typdefinition ermitteln und eintragen */
        set_typlist(t->type,FREE);
        rueck->param.type = t->type->erg_typ;
        rueck->gueltig = rueck->ST_TGUELT;
        rueck->param.type->name = name->wert.ident_nr;
      }
      else
        set_typlist(t->type,FREE);
    }
  }
}


int enum_top;
/* ************************************************************************* */
/* trage die Namen einer Aufzaehlung in die Symboltabelle ein                */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Namensliste                                                   */
/*             Datentyp der Aufzaehlung                                      */
/*                                                                           */
/* ************************************************************************* */

set_enumlist(il,type)
T_IDENTLIST * il;
ST_TYPE * type;
{ int rueck;
  Eintrag * name;
  rueck = 0;
  if (il)
  { if (il->link)
    { rueck = set_enumlist(il->link,type); }
    else
    { rueck = 1; }
    if (name = suche_Eintrag(il->ident->wert.ident_nr,vector_ST,GLOBAL,0))
    { GET_MEM(name->param.Const, 1, ST_CONST);
      name->gueltig = name->ST_CGUELT = 1;
      name->ST_CSEL = ST_CENUM;
      name->ST_CLINK = NULL;
      name->ST_CRVAL = il->count - 1;
      name->ST_CRVON = 0;
      name->ST_CRBIS = enum_top;
      name->ST_CTYP = type;
    }
    else
    { rueck = 0;
      SEMERROR(name->Zeile,name->Posit,il->ident->Zeile,il->ident->Posit,text[113]);
      interpreter = 1;
    }
  }
  return rueck;
}
      
/* ************************************************************************* */
/* erzeuge interne Typdefinition aus Syntax-Typdefinition                    */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Syntax-Typdefinition                                          */
/*             Nur einfache Typen                                            */
/*                                                                           */
/* ************************************************************************* */

set_typlist(toz,mode)
T_TYPE * toz;
int mode;
{ Eintrag * name;
  SCAN_ELEM * mem;
  ST_TYPE * type = typ_error;

  if (toz != NULL)
  { if (toz->link != NULL)
    { set_typlist(toz->link,mode); }

    switch (toz->art)
    { case TY_UNDEF :
        SEMERROR(toz->Zeile,toz->Posit,0,0,
                 text[278]);
        interpreter = 1;
        break;
      case TY_NAME :
        if((name = suche_Eintrag((mem = toz->typ.ident)->wert.ident_nr,
                                 vector_ST,GLOBAL,(mode == POINTER) ? 0 : akt_timestamp)) != NULL)
        { if ((name->Art == N_TYPE) && (name->param.type !=NULL))
          { type = name->param.type;
            switch (type->Art = name->ST_TSEL)
            { case ST_TUNDEF :
              case ST_TINT :
              case ST_TCHAR :
              case ST_TREAL :
              case ST_TARRAY :
              case ST_TRECORD :
              case ST_TSET :
                if (mode == RANGE)
                { SEMERROR(mem->Zeile,mem->Posit,0,0,
                           text[279]);
                  type = typ_error;
                  interpreter = 1;
                }
                break;
              case ST_TRECORDREST :
                bug("set_typlist  ST_TRECORDREST");
                break;
              default :
                break;
            }
          }
          else
          { if (name->Art != N_TYPE)
            { SEMERROR(name->Zeile,name->Posit,mem->Zeile,mem->Posit,
                 text[280]);
              interpreter = 1;
            }
            else
            { if (mode != POINTER)
              { SEMERROR(name->Zeile,name->Posit,mem->Zeile,mem->Posit,
                   text[281]);
                interpreter = 1;
              }
              else
                type = NULL;
            }
          }
        }
        else
        { SEMERROR(mem->Zeile,mem->Posit,0,0,
                   text[173]);
          interpreter = 1;
        }
        break;
       
      case TY_ENUM :
        if (toz->typ.identlist != NULL)
        { GET_MEM(type,1,ST_TYPE);
          type->liste = typen_liste;
          typen_liste = type;
          type->info.range.basis = type->info.range.von = 0;
          type->info.range.bis = toz->typ.identlist->count - 1;
          enum_top = (toz->typ.identlist) ? toz->typ.identlist->count - 1 : 0;
          type->gueltig = set_enumlist(toz->typ.identlist,type);
          if (type->gueltig)
            build_enum_members(toz->typ.identlist);
          type->info.range.mem = all_members;
          type->used[INTEGER] = type->used[ALL] = 1;
          type->firstelem = INTEGER;
          type->Art = ST_TRANGE;
        }
        break;

      case TY_RANGE :
        { T_SUBRANGE * mem = toz->typ.range; 
          int art, bas, bas2, von, top;
          ST_TYPE * typ_v, * typ_b;
          GET_MEM(type,1,ST_TYPE);
          type->liste = typen_liste;
          typen_liste = type;
          type->gueltig = 1;
          if (mem == NULL)
          { toz->erg_typ = typ_error;
            return;
          }
          if (mem->von != NULL)
          { expr_auswerten(mem->von,1);
            if (mem->von->erg_art == ERG_CONST)
            { if (ermittle_grenze(mem->von->erg.Const,&von,&bas,
                            mem->bis->Zeile,mem->bis->Posit,&typ_v) != JA)
              { type->gueltig = 0;
                typ_v = typ_error;
              }
              art = 0;
            }
            else
            { type->gueltig = 0;
              if (mem->von->error == 0)
                SEMERROR(mem->von->Zeile,mem->von->Posit,0,0,
                         text[270]);
              typ_v = typ_error;
              interpreter = 1;
            }
          }
          else
          { von = bas = 0;
            typ_v = typ_int;
            art = -1 /* 0 */;
          }
          expr_auswerten(mem->bis,1);
          if (mem->bis->erg_art == ERG_CONST)
          { ermittle_grenze(mem->bis->erg.Const,&top,&bas2,
                            mem->bis->Zeile,mem->bis->Posit,&typ_b);
            if (match_typen(typ_v,typ_b,1) == JA)
            { top += art;
              if (top < von)
              { if (art != 0)
                { type->gueltig = 0;
                  if (mem->bis->error == 0)
                    SEMERROR(mem->bis->Zeile,mem->bis->Posit,0,0,
                             text[282]);
                }
                else
                { type->gueltig = 0;
                  if ((mem->von->error == 0) && (mem->bis->error == 0))
                    SEMERROR(mem->von->Zeile,mem->von->Posit,
                             mem->bis->Zeile,mem->bis->Posit,
                             text[266]);
                }
                interpreter = 1;
              }
              else
              { type->info.range.super = typ_b;
                type->info.range.basis = bas;
                type->info.range.von = von;
                type->info.range.bis = top;
              }
            }
            else
            { type->gueltig = 0;
              if (mem->von == NULL)
              { if (mem->bis->error == 0)
                  SEMERROR(mem->bis->Zeile,mem->bis->Posit,0,0,
                           text[260]);
              }
              else
                if ((mem->von->error == 0) && (mem->bis->error == 0))
                  SEMERROR(mem->von->Zeile,mem->von->Posit,
                           mem->bis->Zeile,mem->bis->Posit,
                           text[271]);
              interpreter = 1;
            }
          }
          else
          { type->gueltig = 0;
            if (mem->bis->error == 0)
              SEMERROR(mem->bis->Zeile,mem->bis->Posit,0,0,
                       text[270]);
            interpreter = 1;
          }
          if (match_typen(typ_v,typ_bool,0) == JA)
          { type->used[BOOLEAN] = type->used[ALL] = 1;
            type->firstelem = BOOLEAN;
          }
          else
          { if (match_typen(typ_v, typ_char,0) == JA)
            { type->used[CHAR] = type->used[ALL] = 1;
              type->firstelem = CHAR;
            }
            else
            { type->used[INTEGER] = type->used[ALL] = 1;
              type->firstelem = INTEGER;
            }
          }
          type->Art = ST_TSUBRANGE;
        }
        break;

      case TY_ARRAY :
        if (mode != RANGE)
        { T_TYPE * typ_mem1;
          ST_TYPE * type1, * type2;
          int zaehl,zaehl1;

          GET_MEM(type,1,ST_TYPE);
          type->liste = typen_liste;
          typen_liste = type;
          zaehl = 1;
          set_typlist(toz->typ.array.dimen,RANGE);
          set_typlist(toz->typ.array.type,FREE);
          type2 = type->info.array.typ = toz->typ.array.type->erg_typ; 
          type->firstelem = type2->firstelem;
          type->gueltig = type2->gueltig;
          type->Art = ST_TARRAY;
          typ_mem1 = toz->typ.array.dimen;
          while (typ_mem1->link != NULL)
          { type->info.array.bereich = type1 = typ_mem1->erg_typ;
            type->info.array.anzahl = zaehl *=
                    (zaehl1 = (type1->info.range.bis -
                               type1->info.range.von + 1));
            type->gueltig *= type1->gueltig;
            if (type->gueltig != 0)
            { int i;
              for(i = BOOLEAN; i <= ALL; i++)
              { type->used[i] = type2->used[i] * zaehl1; }
              if ((zaehl1 < 0) || (type->used[ALL] < 0) || (type->used[BOOLEAN] < 0) ||
                  (type->used[CHAR] < 0) || (type->used[INTEGER] < 0) ||
                  (type->used[REAL] < 0))
              { SEMERROR(toz->Zeile,toz->Posit,0,0,text[261]);
                type->gueltig = 0;
              }
            }
            typ_mem1 = typ_mem1->link;
            type2 = type;
            GET_MEM(type,1,ST_TYPE);
            type->liste = typen_liste;
            typen_liste = type;
            type->Art = ST_TARRAY;
            type->link = NULL;
            type->info.array.typ = type2;
            type->firstelem = type2->firstelem;
            type->gueltig = type2->gueltig;
          }
          type->info.array.bereich = type1 = typ_mem1->erg_typ;
          type->info.array.anzahl = zaehl *
                  (zaehl1 = (type1->info.range.bis -
                             type1->info.range.von + 1));
          if ((type->gueltig *= type1->gueltig) != 0)
          { int i;
            for(i = BOOLEAN; i <= ALL; i++)
            { type->used[i] = type2->used[i] * zaehl1; }
            type->firstelem = type2->firstelem;
            if ((zaehl1 < 0) || (type->used[ALL] < 0) || (type->used[BOOLEAN] < 0) ||
                (type->used[CHAR] < 0) || (type->used[INTEGER] < 0) ||
                (type->used[REAL] < 0))
            { SEMERROR(toz->Zeile,toz->Posit,0,0,text[261]);
              type->gueltig = 0;
            }
          }
          type->info.array.top = 1;
          type->Art = ST_TARRAY;
        }
        else
        { SEMERROR(toz->Zeile,toz->Posit,0,0,
                   text[279]);
          interpreter = 1;
        }
        break;

      case TY_RECORD :
        if (mode != RANGE)
        { ST * v = vector_ST;
          ST * a = akt_ST;
          Zeile = toz->Zeile;
          Posit = toz->Posit;
          fieldlist_anal(toz->typ.record.fieldlist,1);
          type = toz->typ.record.fieldlist->typ;
          if (type)
          { type->Art = ST_TRECORD;
            type->gueltig = 1;
          }
          toz->typ.record.ST = akt_ST;
          akt_ST = a;
          vector_ST = v;
        }
        else
        { SEMERROR(toz->Zeile,toz->Posit,0,0,
                   text[279]);
          interpreter = 1;
        }
        break;

      case TY_SET :
        if (mode != RANGE)
        { set_typlist(toz->typ.settyp,RANGE);
          if ((type = toz->typ.settyp->erg_typ) != typ_error)
          { ST_TYPE * type1;
            GET_MEM(type1,1,ST_TYPE);
            *type1 = *type;
            type1->liste = typen_liste;
            typen_liste = type1;
            type1->info.range.super = type;
            type = type1;
            type->used[INTEGER] = type->used[BOOLEAN] = type->used[CHAR] = 0;
            if (type->gueltig != 0)
            { if ((type->used[BOOLEAN] = type->used[ALL] =
                  type->info.range.bis - type->info.range.von + 1) < 0)
              { SEMERROR(toz->Zeile,toz->Posit,0,0,text[330]);
                type->gueltig = 0;
              }
            }
            else
              type->used[ALL] = 0;
            type->firstelem = BOOLEAN;
            type->Art = ST_TSET;
          }
        }
        else
        { SEMERROR(toz->Zeile,toz->Posit,0,0,
                   text[279]);
          interpreter = 1;
        }
        break;

      case TY_POINTER :
        if (mode != RANGE)
        { ST_TYPE * type1;
          set_typlist(toz->typ.settyp,POINTER);
          GET_MEM(type1,1,ST_TYPE);
          type1->liste = typen_liste;
          typen_liste = type1;
          if ((type1->info.pointer.type = toz->typ.settyp->erg_typ) == NULL)
            type1->info.pointer.forw = suche_Eintrag(toz->typ.settyp->typ.ident->wert.ident_nr,
                                                     vector_ST,GLOBAL,0);
          type = type1;
          type->used[INTEGER] = type->used[ALL] = 1;
          type->firstelem = INTEGER;
          type->Art = ST_TPOINTER;
          type->gueltig = 1;
        }
        else
        { SEMERROR(toz->Zeile,toz->Posit,0,0,
                   text[279]);
          interpreter = 1;
        }
        break;

      default :
        bug("set_typlist Auswahl");
        break;
    }
    toz->erg_typ = type;
  }
}

/* ************************************************************************* */
/* wie gross ist ein Bereich                                                 */
/*                                                                           */
/* Ergebnis : Maximum - Minimum oder -1                                      */
/*                                                                           */
/* Parameter : ST-Typdefinition                                              */
/*                                                                           */
/* ************************************************************************* */

int elementezahl(t)
ST_TYPE * t;
{ if ((t != NULL) && ((t->Art == ST_TRANGE) || (t->Art == ST_TSUBRANGE) || (t == typ_bool)))
    return t->info.range.bis - t->info.range.von;
  return -1;
}

/* ************************************************************************* */
/* sind zwei Typen typvertraeglich ?                                         */
/*                                                                           */
/* Ergebnis : JA oder NEIN                                                   */
/*                                                                           */
/* Parameter : ST-Typdefinition                                              */
/*             ST-Typdefinition                                              */
/*             wie muss die Vertraeglichkeit sein                            */
/*                 0 : normale Zuweisung                                     */
/*                 1 : nur die Obertypen (fuer Ausgabe und Strings)          */
/*                 2 : t2 muss echter Teil von t1 sein                       */
/*                                                                           */
/* ************************************************************************* */

int match_typen(t1,t2,art)
ST_TYPE * t1, * t2;
int art;
{ int changed = 0;
  if ((t1 == NULL) || (t2 == NULL) || (t1 == typ_error) || (t2 == typ_error))
    return NEIN;
  if (t1 == t2)
    return JA;
  if ((t1->Art == ST_TNIL) && (t2->Art == ST_TPOINTER))
    return JA;
  if ((t2->Art == ST_TNIL) && (t1->Art == ST_TPOINTER))
    return JA;
  if ((t1->Art == ST_TPOINTER) && (t2->Art == ST_TPOINTER))
    return (t1->info.pointer.type == t2->info.pointer.type) ? JA : NEIN;
  if ((t1->Art == ST_TID_NO) || (t1->Art == ST_TDIM))
    return match_typen(typ_int,t2,art);
  if ((t2->Art == ST_TID_NO) || (t2->Art == ST_TDIM))
    return match_typen(t1,typ_int,art);
  if ((t1->Art == ST_TARRAY) &&
      (t1->info.array.typ == typ_char))
  { if (t2 == typ_string)
      return JA;
    if ((t2->Art == ST_TSARRAY) &&
        (elementezahl(t1->info.array.bereich) >= t2->info.array.bereich->info.range.bis))
      return JA;
  }
  if ((t2->Art == ST_TARRAY) &&
      (t2->info.array.typ == typ_char))
  { if (t1 == typ_string)
      return JA;
    if ((t1->Art == ST_TSARRAY) &&
        (elementezahl(t2->info.array.bereich) >= t1->info.array.bereich->info.range.bis))
      return JA;
  }
  if ((t2->Art == ST_TSUBRANGE) || (t2 == typ_string))
  { ST_TYPE * t;
    t = t1;
    t1 = t2;
    t2 = t;
    changed = 1;
  }
  if (t1->Art == ST_TSUBRANGE)
  { if (t2->Art == ST_TSUBRANGE)
    { if (match_typen(t1->info.range.super,t2->info.range.super,art) == JA)
      { if ((art == 1) || ((t1->info.range.von <= t2->info.range.bis) && 
                    (t2->info.range.von <= t1->info.range.bis)))
        { if ((art != 2) || ((t2->info.range.von <= t1->info.range.von) && 
                             (t1->info.range.bis <= t2->info.range.bis)))
            return JA;
        }    
      }
    }
    else
      if (changed)
        return match_typen(t2,t1->info.range.super,art);
      else
        return match_typen(t1->info.range.super,t2,art);
  }
  if (t1 == typ_string)
    return match_typen(typ_char, t2,art);

  return NEIN;
}

/* ************************************************************************* */
/* berechne den Ergebnistyp einer binaeren Operation                         */
/*                                                                           */
/* Ergebnis : ST-Ergebnistypdefinition                                       */
/*                                                                           */
/* Parameter : Operator                                                      */
/*             ST-Typdefinition                                              */
/*             St-Typdefinition                                              */
/*                                                                           */
/* ************************************************************************* */

ST_TYPE * typ_berechnung(op,t1,t2)
int op;
ST_TYPE * t1, * t2;
{ if ((t1 != typ_error) && (t2 != typ_error))
  { switch(op)
    { case '+' :
      case '-' :
      case '*' :
        if ((t1 != NULL) && (t1->Art == ST_TSET) && (t2 != NULL) && (t2->Art == ST_TSET))
        { if (t1 == t2) return t1; }
        else
        { if (((t1 != NULL) && (t1->Art == ST_TSET)) ||
              ((t2 != NULL) && (t2->Art == ST_TSET)))
            return typ_error;
          if (match_typen(t1,t2,1) == JA)
          { if (match_typen(typ_int,t1,0) == JA)
              return typ_int;
            if (match_typen(typ_real,t1,0) == JA)
              return typ_real;
          }
        }
        break;
      case '/' :
        if ((t1 != NULL) && (t1->Art == ST_TSET) && (t2 != NULL) && (t2->Art == ST_TSET))
        { if (t1 == t2) return t1; }
        if ((match_typen(typ_real,t1,0) == JA) &&
            (match_typen(typ_real,t2,0) == JA))
          return typ_real;
        break;
      case POWER :
        { if (match_typen(typ_int, t2,0) == JA)
          { if (match_typen(typ_int, t1,0) == JA)
              return typ_int;
            if (match_typen(typ_real,t1,0) == JA)
              return typ_real;
          }
          else
          if ((match_typen(typ_real,t1,0) == JA) &&
              (match_typen(typ_real, t2,0) == JA))
            return typ_real;
        }
        break;
      case _DIV :
      case _MOD :
        if ((match_typen(typ_int,t1,0) == JA) &&
            (match_typen(typ_int,t2,0) == JA))
          return typ_int;
        break;
      case _AND :
      case _OR :
        if ((match_typen(typ_bool,t1,0) == JA) &&
            (match_typen(typ_bool,t2,0) == JA))
          return typ_bool;
        break;
      case '=' :
      case UNEQ :
        if (((t1 != NULL) && (t1->Art == ST_TSET)) ||
            ((t2 != NULL) && (t2->Art == ST_TSET)))
        { if (t1 == t2)
            return typ_bool;
          return typ_error;
        }
        if (match_typen(t1,t2,1) == JA)
          return typ_bool;
        break;
      case '<' :
      case '>' :
        if ((match_typen(t1,t2,1) == JA) &&
            ((((match_typen(typ_real,t1,0) == JA) ||
               (match_typen(typ_int,t1,0) == JA) ||
               (match_typen(typ_char,t1,0) == JA) ||
               (match_typen(typ_bool,t1,0) == JA)) &&
              ((match_typen(typ_real,t1,0) == JA) ||
               (match_typen(typ_int,t1,0) == JA) ||
               (match_typen(typ_char,t1,0) == JA) ||
               (match_typen(typ_bool,t1,0) == JA))) ||
             (((t1->Art == ST_TRANGE) || (t1->Art == ST_TSUBRANGE)) &&
              ((t2->Art == ST_TRANGE) || (t2->Art == ST_TSUBRANGE)))))
          return typ_bool;
        break;
      case GREQ :
      case LEEQ :
        if ((match_typen(t1,t2,1) == JA) &&
            ((((match_typen(typ_real,t1,0) == JA) ||
               (match_typen(typ_int,t1,0) == JA) ||
               (match_typen(typ_char,t1,0) == JA) ||
               (match_typen(typ_bool,t1,0) == JA)) &&
              ((match_typen(typ_real,t1,0) == JA) ||
               (match_typen(typ_int,t1,0) == JA) ||
               (match_typen(typ_char,t1,0) == JA) ||
               (match_typen(typ_bool,t1,0) == JA))) ||
             (((t1->Art == ST_TRANGE) || (t1->Art == ST_TSUBRANGE)) &&
              ((t2->Art == ST_TRANGE) || (t2->Art == ST_TSUBRANGE)))))
          return typ_bool;
        if ((match_typen(t1,t2,1) == JA) && (t1->Art == ST_TSET) && (t2->Art == ST_TSET))
          return typ_bool;
        break;
      case _IN :
        if ((t1 != NULL) && (t2 != NULL) && 
            (t2->Art == ST_TSET) && (t1->Art != ST_TSET))
        { if (match_typen(t1,t2->info.range.super,0) == JA)
            return typ_bool;
        }
        break;
      case IS :
        if (match_typen(t1,t2,0) == JA)
          return t1;
        break;
      default :
        bug("typ_berechnung Auswahl");
        break;
    }
  }
  return typ_error;
}

/* ************************************************************************* */
/* vergleicht Array bzgl. LOAD/STORE mit Vektorvariable                      */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : ST-Typdefinition                                              */
/*             ST-Typdefinition                                              */
/*             Zeilennummer vektorielle Variable                             */
/*             Spaltennummer vektorielle Variable                            */
/*             Zeilennummer skalares Feld                                    */
/*             Spaltennummer skalares Feld                                   */
/*             Fehlermeldungsstring                                          */
/*             LOAD/STORE                                                    */
/*                                                                           */
/* ************************************************************************* */

typ_vergleich(von,nach,zvon,pvon,znach,pnach,error_string,mode)
ST_TYPE * von, * nach;
int zvon,pvon,znach,pnach, mode;
char * error_string;
{ if ((von == typ_error) || (von == NULL) ||
      (nach == typ_error) || (nach == NULL))
  { interpreter = 1;
    return ;
  }
  if (match_typen(von,nach,0) != JA)
  { if ((mode == _LOAD) && (von->Art == ST_TARRAY))
    { typ_vergleich(von->info.array.typ,nach,zvon,pvon,znach,pnach,error_string,mode);
      return;
    }
    if ((mode == _STORE) && (nach->Art == ST_TARRAY))
    { typ_vergleich(von,nach->info.array.typ,zvon,pvon,znach,pnach,error_string,mode);
      return;
    }
    SEMERROR(zvon,pvon,znach,pnach,error_string);
    interpreter = 1;
    return;
  }
  if (nach->Art == ST_TSUBRANGE)
  { if (von->Art == ST_TBOOL)
    { if ((nach->info.range.von > 0) || (nach->info.range.bis < 1))
      { SEMERROR(zvon,pvon,znach,pnach,error_string);
        interpreter = 1;
        return;
      }
      return;
    }
    else
    { if ((von->Art == ST_TSUBRANGE) || (von->Art == ST_TRANGE))
      { if ((von->info.range.von < nach->info.range.von) ||
            (von->info.range.bis > nach->info.range.bis))
        { SEMERROR(zvon,pvon,znach,pnach,error_string);
          interpreter = 1;
          return;
        }
        return;
      }
      SEMERROR(zvon,pvon,znach,pnach,error_string);
      interpreter = 1;
      return;
    }
  }
  else
  { if ((nach->used[ALL] > 1) && (von != nach))
    { SEMERROR(zvon,pvon,znach,pnach,error_string);
      interpreter = 1;
      return;
    }
  }    
}

/* ************************************************************************* */
/* ist der Datentyp ein Aufzaehlungstyp ?                                    */
/*                                                                           */
/* Ergebnis :JA oder NEIN                                                    */
/*                                                                           */
/* Parameter : ST-Typdefinition                                              */
/*                                                                           */
/* ************************************************************************* */

int enumeration_typ(t)
ST_TYPE * t;
{ if (t == NULL) return NEIN;
  switch (t->Art)
  { case ST_TINT :
    case ST_TCHAR :
    case ST_TBOOL :
    case ST_TRANGE :
    case ST_TSUBRANGE :
    case ST_TID_NO :
    case ST_TDIM :
      return JA;
  }
  return NEIN;
}

/* ************************************************************************* */
/* ist der Ausdruck vom Typ CARDINAL ?                                       */
/*                                                                           */
/* Ergebnis : JA oder NEIN                                                   */
/*                                                                           */
/* Parameter : Ausdruck                                                      */
/*                                                                           */
/* ************************************************************************* */

int ist_cardinal(ex)
T_EXPR * ex;
{ if (ex == NULL) return NEIN;
  if ((ex->error == 0) && (ex->erg_typ != NULL) && (ex->erg_art != ERG_TYPE))
  { if (ex->erg_art == ERG_CONST)
    { ST_CONST * c = ex->erg.Const;
      if ((c->Art == ST_TINT) && (c->wert.i >= 0))
        return JA;
    }
    else
    { ST_TYPE * t = ex->erg_typ;
      if ((t->Art == ST_TID_NO) ||
	  ((t->Art == ST_TSUBRANGE) &&
	   (match_typen(t->info.range.super,typ_int,0) == JA) &&
           (t->info.range.von >= 0)) ||
	  (t == typ_int))
        return JA;
    }
  }
  return NEIN;
}

/* ************************************************************************* */
/* ist der Datentyp ein Stringtyp ?                                          */
/*                                                                           */
/* Ergebnis : JA oder NEIN                                                   */
/*                                                                           */
/* Parameter : ST-Typdefinition                                              */
/*                                                                           */
/* ************************************************************************* */

int ist_stringtyp(t)
ST_TYPE * t;
{ if ((t != NULL) &&
      ((t->Art == ST_TSARRAY) ||
       ((t->Art == ST_TARRAY) && (t->info.array.typ == typ_char)) ||
       (t == typ_string)))
    return JA;
  return NEIN;
}

/* ************************************************************************* */
/* ist der Datentyp ein einfacher Datentyp ?                                 */
/*                                                                           */
/* Ergebnis : JA oder NEIN                                                   */
/*                                                                           */
/* Parameter : ST-Typdefinition                                              */
/*                                                                           */
/* ************************************************************************* */

int ist_einfacher_typ(t)
ST_TYPE * t;
{ if (t != NULL)
  { switch (t->Art)
    { case ST_TINT :
      case ST_TCHAR :
      case ST_TBOOL :
      case ST_TREAL :
      case ST_TRANGE :
      case ST_TSUBRANGE :
      case ST_TRANDOM :
      case ST_TID_NO :
      case ST_TDIM :
      case ST_TNIL :
      case ST_TPOINTER :
        return JA;
    }
  }
  return NEIN;
}

/* ************************************************************************* */
/* kann eine Variable einen Wert = 0 enthalten ?                             */
/*                                                                           */
/* Ergebnis : JA oder NEIN                                                   */
/*                                                                           */
/* Parameter : Typ der Variablen                                             */
/*                                                                           */
/* ************************************************************************* */

int ist_gleich_null(t)
ST_TYPE * t;
{ if (t)
    if ((t->Art == ST_TSUBRANGE) && (t->info.range.von > 0))
      return NEIN;
  return JA;
}

/* ************************************************************************* */
/* ueberpruefe die Komponenten einer Feldzuweisung                           */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Ausdruck der Feldzuweisung                                    */
/*             Komponentenausdruecke                                         */
/*             Typ der einzelnen Komponenten                                 */
/*                                                                           */
/* ************************************************************************* */

array_elemente_test(expr,exlist,t)
T_EXPR * expr;
T_EXPR * exlist;
ST_TYPE * t;
{ if (exlist)
  { array_elemente_test(expr,exlist->link,t);
    if (match_typen(exlist->erg_typ,t,0) != JA)
    { if (exlist->error == 0)
        SEMERROR(expr->Zeile,expr->Posit,exlist->Zeile,exlist->Posit,text[341]);
      expr->error = interpreter = 1;
    }
  }
}


build_enum_members(i)
T_IDENTLIST  * i;
{ MEMBERS * m;
  int  flag = 1;
  while (i)
  { GET_MEM(m,1,MEMBERS);
    m->link = all_members;
    all_members = m;
    m->ein = suche_Eintrag(i->ident->wert.ident_nr,vector_ST,GLOBAL,0);
    m->art = 0;
    m->inh.wert = i->count-1;
    m->flag = flag;
    flag = 0;
    i = i->link;
  }
}


extern MEMBERS * mache_fieldlist_eintraege();
extern MEMBERS * record_members();
extern MEMBERS * mache_record_eintraege();
extern MEMBERS * variant_auswertung();

/* ************************************************************************* */
/* ************************************************************************* */
MEMBERS * record_members(i,t,m)
T_IDENTLIST * i;
ST_TYPE * t;
MEMBERS * m;
{ MEMBERS * m1;
  if (i)
  { m1 = record_members(i->link,t,m);
    GET_MEM(m,1,MEMBERS);
    m->next = m1;
    m->ein = i->ein;
    m->art = 1;
    m->inh.typ = t;
  }
  return m;
}

/* ************************************************************************* */
/* trage die Komponentennamen einer Struktur in die Symboltabelle ein        */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Variablendefinitionen                                         */
/*                                                                           */
/* ************************************************************************* */

MEMBERS * mache_record_eintraege(vardef)
T_VARDEF * vardef;
{ ST_TYPE * type;
  MEMBERS * m1, * m2;
  if (vardef != NULL)
  { m1 = mache_record_eintraege(vardef->link);
    set_typlist(vardef->type,FREE);
    if (vardef->type)
    { type = vardef->typbeschr = vardef->type->erg_typ; }
    else
    { type = vardef->typbeschr = typ_error; }
    trage_var_ein(vardef->ident_list,type);
    m2 = record_members(vardef->ident_list,type,m1);
    return m2;
  }
  return NULL;
}

/* ************************************************************************* */
/* wertet eine RECORD-Variante aus                                           */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Typ des Selektors                                             */
/*             Varianten                                                     */
/*                                                                           */
/* ************************************************************************* */

MEMBERS * variant_auswertung(typ,vari)
ST_TYPE * typ;
T_VARIANT * vari;
{ MEMBERS * m, * m1;
  if (vari != NULL)
  { m1 = variant_auswertung(typ,vari->link);
    typ_caselabel_auswertung(typ,vari->link, vari->caselist);
    fieldlist_anal(vari->fieldlist,0);
    GET_MEM(m,1,MEMBERS);
    m->next = m1;
    m->ein = NULL;
    m->art = 1;
    m->inh.typ = vari->fieldlist->typ;
    return m;
  }
  return NULL;
}

/* ************************************************************************* */
/* wertet die CASELABELS einer RECORD-Varianten aus                          */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Typ des Selektors                                             */
/*             Varianten                                                     */
/*             CASELABEL-Varianten                                           */
/*                                                                           */
/* ************************************************************************* */

typ_caselabel_auswertung(typ,vari,caselabel)
ST_TYPE * typ;
T_VARIANT * vari;
T_CASELABEL * caselabel;
{ ST_CONST * lb, * ub;
  if (caselabel != NULL)
  { T_EXPR * von, * bis;
    int unten, oben;
    typ_caselabel_auswertung(typ,vari,caselabel->link);
    expr_auswerten(von = caselabel->von,1);
    if (von->erg_art != ERG_CONST)
    { if (von->error == 0)
        SEMERROR(von->Zeile,von->Posit,0,0,text[268]);
      von->error = interpreter = 1;
    }
    if (match_typen(von->erg_typ,typ,0) != JA)
    { if (von->error == 0)
        SEMERROR(von->Zeile,von->Posit,0,0,text[182]);
      von->error = interpreter = 1;
    }
    if ((von->erg_art == ERG_CONST) && (von->error == 0))
    { switch ((lb = von->erg.Const)->Art)
      { case ST_CINT :
          unten = lb->wert.i;
          break;
        case ST_CSTRING :
          unten = lb->wert.s.string[0];
          break;
        default :
          unten = lb->wert.range.val;
          break;
      }
    }
    if ((bis = caselabel->bis) != NULL)
    { expr_auswerten(bis,1);
      if (bis->erg_art != ERG_CONST)
      { if (bis->error == 0)
          SEMERROR(bis->Zeile,bis->Posit,0,0,text[268]);
        bis->error = interpreter = 1;
      }
      if (match_typen(bis->erg_typ,typ,0) != JA)
      { if (bis->error == 0)        
        SEMERROR(bis->Zeile,bis->Posit,0,0,text[182]);
        bis->error = interpreter = 1;
      }
      if ((bis->erg_art == ERG_CONST) && (bis->error == 0))
      { switch ((ub = bis->erg.Const)->Art)
        { case ST_CINT :
            oben = ub->wert.i;
            break;
          case ST_CSTRING :
            oben = ub->wert.s.string[0];
            break;
          default :
            oben = ub->wert.range.val;
            break;
        }
      }
      if (unten > oben)
      { if ((von->error == 0) && (bis->error == 0))
          SEMERROR(von->Zeile,von->Posit,bis->Zeile,bis->Posit,text[266]);
        von->error = bis->error = interpreter = 1;
      }
      if ((von->error == 0) && (bis->error == 0))
      { typ_pruefe_ueberlappung(unten,oben,von->Zeile,von->Posit,caselabel->link,vari); }
    }
    else
    { if (von->error == 0)
      { typ_pruefe_ueberlappung(unten,unten,von->Zeile,von->Posit,caselabel->link,vari); }
      oben = unten;
      ub = lb;
    }
    caselabel->unten = unten;
    caselabel->oben = oben;
  }
}
    
/* ************************************************************************* */
/* pruefe CASE-Varianten auf Ueberlappung der Bereiche                       */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Anfang des Bereichs                                           */
/*             Ende des Bereichs                                             */
/*             Zeilennummer der Bereichsangabe                               */
/*             Spaltennummer der Bereichsangabe                              */
/*             zu pruefende CASELABEL-Varianten                              */
/*             zu pruefende Varianten                                        */
/*                                                                           */
/* ************************************************************************* */

typ_pruefe_ueberlappung(von,bis,Z1,P1,caselabel,vari)
int von,bis,Z1,P1;
T_CASELABEL * caselabel;
T_VARIANT * vari;
{ while (1)
  { while (caselabel != NULL)
    { if (((caselabel->unten <= von) && (caselabel->oben >= von)) ||
          ((caselabel->unten <= bis) && (caselabel->oben >= bis)) ||
          ((von <= caselabel->unten) && (bis >= caselabel->unten)) ||
          ((von <= caselabel->oben) && (bis >= caselabel->oben)))
      { SEMERROR(Z1,P1,caselabel->von->Zeile,caselabel->von->Posit,text[269]);
        interpreter = 1;
        return;
      }
      caselabel = caselabel->link;
    }
    if (vari == NULL)
      return;
    else
      caselabel = vari->caselist;
    vari = vari->link;
  }
}


varlist_eintragen(v)
T_VARDEF * v;
{ if (v)
  { varlist_eintragen(v->link);
    identlist_eintragen(v->ident_list,N_RECORDCOMP);
  }
}


variant_varlist_eintragen(v)
T_VARIANT * v;
{ if (v)
  { variant_varlist_eintragen(v->link);
    record_varlist_eintragen(v->fieldlist);
  }
}


record_varlist_eintragen(r)
T_RECDEF * r;
{ if (r)
  { record_varlist_eintragen(r->link);
    if (r->select == REC_NORM)
      varlist_eintragen(r->art.norm);
    else
    { identlist_eintragen(r->art.selected.ident,N_RECORDCOMP);
      variant_varlist_eintragen(r->art.selected.vari);
      record_varlist_eintragen(r->art.selected.elseteil);
    }
  }
}


MEMBERS * mache_fieldlist_eintraege(r)
T_RECDEF * r;
{ MEMBERS * m, * m1, *m2, *m3;
  if (r)
  { m2 = mache_fieldlist_eintraege(r->link);
    if (r->select == REC_NORM)
    { m1 = m = mache_record_eintraege(r->art.norm);
      while (m1->next)
      { m1 = m1->next; }
      m1->next = m2;
      return m;
    }
    else
    { ST_TYPE * typ, * typ1;
      set_typlist(r->art.selected.typ,FREE);
      if (r->art.selected.typ)
      { typ = r->art.selected.typ->erg_typ; }
      else
      { typ = typ_error; }
      if (r->art.selected.ident)
      { trage_var_ein(r->art.selected.ident,typ);
        GET_MEM(m3,1,MEMBERS);
        m3->next = m2;
        m3->ein = r->art.selected.ident->ein;
        m3->art = 1;
        m3->inh.typ = typ;
      }
      else
      { m3 = m2; }
      m2 = variant_auswertung(typ,r->art.selected.vari);
      if (r->art.selected.elseteil)
      { GET_MEM(typ1,1,ST_TYPE);
        typ1->liste = typen_liste;
        typen_liste = typ1;
        typ1->Art = ST_TRECORDREST;
        typ1->gueltig = 1;
        m = mache_fieldlist_eintraege(r->art.selected.elseteil);
        typ1->info.record.member = m;
        GET_MEM(m1,1,MEMBERS);
        m1->next = m2;
        m1->ein = NULL;
        m1->art = 1;
        m1->inh.typ = typ1;
      }
      else
      { m1 = m2; }
      GET_MEM(typ1,1,ST_TYPE);
      typ1->liste = typen_liste;
      typen_liste = typ1;
      typ1->Art = ST_TVARIANT;
      typ1->gueltig = 1;
      typ1->info.record.member = m1;
      GET_MEM(m,1,MEMBERS);
      m->next = m3;
      m->ein = NULL;
      m->art = 1;
      m->inh.typ = typ1;
      return m;
    }
  }
  return NULL;
}

fieldlist_anal(r,mode)
T_RECDEF * r;
int mode;
{ ST_TYPE * type;
  if (r != silly)
  { Eintrag * e1;
    GET_MEM(type,1,ST_TYPE);
    type->liste = typen_liste;
    typen_liste = type;
    if (mode)
    { akt_ST = neue_ST(vector_ST,0);
      all_tables = all_tables->link;
      vector_ST = akt_ST;
      type->info.record.symtab = akt_ST;
      record_varlist_eintragen(r);
    }
    type->Art = ST_TRECORDREST;
    type->gueltig = 1;
    type->info.record.member = mache_fieldlist_eintraege(r);
    if (mode)
    { build_fieldlist_members(type);
      e1 = akt_ST->record;
      while (e1 != NULL)
      { e1->param.komp.styp = type;
        e1->timestamp = akt_timestamp;
        e1 = e1->link;
      }
    }
    r->typ = type;
  }
  else
    r->typ = typ_error;
}

build_fieldlist_members(t)
ST_TYPE * t;
{ ST_TYPE * t1;
  MEMBERS * m = t->info.record.member;
  int i, neu = 1;
  while (m)
  { t1 = m->inh.typ;
    if (t1)
    { switch (t1->Art)
      { case ST_TRECORDREST :
        case ST_TVARIANT :
          build_fieldlist_members(t1);
      }
    }
    t->gueltig *= t1->gueltig;
    for (i = BOOLEAN; i <= ALL; i++)
    { t->used[i] += t1->used[i]; }
    if (t->gueltig && ((t->used[ALL] < 0) || (t->used[BOOLEAN] < 0) ||
        (t->used[CHAR] < 0) || (t->used[INTEGER] < 0) ||
        (t->used[REAL] < 0)))
    { SEMERROR(Zeile,Posit,0,0,text[276]);
      t->gueltig = 0;
    }
    m = m->next;
  }
  m = t->info.record.member;
  while (m)
  { m->link = all_members;
    all_members = m;
    m->flag = neu;
    neu = 0;
    m = m->next;
  }
  t->info.record.mem =  all_members;
  t->firstelem = all_members->inh.typ->firstelem;
}

