static char _sccsid[] = "Parallaxis Version: @(#)conf.c	2.13  2/28/92 15:09:56";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : conf.c                                                            */
/*                                                                           */
/* Funktionen, die die CONFIGURATIONEN analysiert und die Portnummern vergibt*/
/*                                                                           */
/* ************************************************************************* */


#include "pass2.h"

extern int proz_anz;
extern ST_TYPE * build_ranges();
C_CONF * akt_conf, * default_conf;
C_GROUP * all_groups = NULL;
static Eintrag * conf_eint;

int portnr = 0;
int t_portnr;
int moment_group = 0;

/* ************************************************************************* */
/* Vergebe die Portnummern pf"ur alle Konfigurationsgruppen                  */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Konfigurationsgruppen                                         */
/*                                                                           */
/* ************************************************************************* */

portnummernvergabe(g)
C_GROUP * g;
{ C_GROUP * g1 = g;
  int p;
  if (g)
    conf_eint = g->vectors->Obertabelle->configuration;
  while (g)
  { t_portnr = 0;
    numeriere_ports(g->vectors,0);
    portnr = (t_portnr > portnr) ? t_portnr : portnr;
    g->port_anz = t_portnr;
    g = g->link;
  }
  t_portnr = portnr;
  g = g1;
  while (g)
  { numeriere(g->vectors->io,1);
    if (t_portnr > portnr)
    { g->port_anz = t_portnr; }
    portnr = t_portnr;
    g = g->link;
  }
  g = g1;
  p = portnr;
  while (g)
  { numeriere(g->vectors->input,1);
    if (t_portnr > portnr)
    { g->port_anz = t_portnr; }
    portnr = t_portnr;
    g = g->link;
  }
  g = g1;
  t_portnr = p;
  while (g)
  { p = t_portnr;
    numeriere(g->vectors->output,1);
    if (t_portnr > p)
    { if (g->port_anz < t_portnr)
        g->port_anz = t_portnr;
    }
/*    portnr = t_portnr;*/
    g = g->link;
  }
  portnr = (t_portnr > portnr) ? t_portnr : portnr;
}

/* ************************************************************************* */
/* Numerierie die Ports                                                      */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Symboltabelle                                                 */
/*             normal oder gruppen"ubergreifend                              */
/*                                                                           */
/* ************************************************************************* */

numeriere_ports(s,m)
ST * s;
{ if (s)
  { int t1,t2;
    numeriere(s->io,m);
    t1 = t_portnr;
    numeriere(s->input,m);
    t2 = t_portnr;
    t_portnr = t1;
    numeriere(s->output,m);
    t_portnr = (t2 > t_portnr) ? t2 : t_portnr;
  }
}

/* ************************************************************************* */
/* Ermittlung des Konfigurationsnamens                                       */
/*                                                                           */
/* Ergebnis : Nummer im W"orterbuch                                          */
/*                                                                           */
/* Parameter : Konfigurationsnummer                                          */
/*                                                                           */
/* ************************************************************************* */

long conf_key(i)
int i;
{ Eintrag * e = conf_eint;
  while (e)
  { if (e->param.config.conf_nr == i)
      return e->name_nr;
    e = e->link;
  }
  return 0l;
}

/* ************************************************************************* */
/* ermittle den Porttyp                                                      */
/*                                                                           */
/* Ergebnis : Porttyp                                                        */
/*                                                                           */
/* Parameter : Konfigurationsnummer                                          */
/*                                                                           */
/* ************************************************************************* */

ST_TYPE * port_typ(i)
int i;
{ Eintrag * e = conf_eint;
  while (e)
  { if (e->param.config.conf_nr == i)
      return e->param.config.port_typ;
    e = e->link;
  }
  return NULL;
}

/* ************************************************************************* */
/* Numeriere die Porteintr"age                                               */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Liste der Eintr"age                                           */
/*             normal oder gruppen"ubergreifend                              */
/*                                                                           */
/* ************************************************************************* */

numeriere(e,m)
Eintrag * e;
int m;
{ ST_TYPE *  t;
  while (e)
  { switch (e->Art)
    { case N_IOK :
      case N_INPUTK :
      case N_OUTPUTK :
        if (m == e->param.inout.intext)
        { e->param.inout.portnr = ++t_portnr;
          t_portnr += e->param.inout.bis - e->param.inout.von;
          GET_MEM(t,1,ST_TYPE);
          t->liste = typen_liste;
          e->param.inout.port_typ = typen_liste = t;
          t->gueltig = 1;
          t->Art = ST_TPORTTYPE;
          t->info.port.von = e->param.inout.von;
          t->info.port.bis = e->param.inout.bis;
          t->info.port.key = conf_key(e->param.inout.conf_nr);
        }
        break;
      case N_IO :
      case N_INPUT :
      case N_OUTPUT :
        if (m == e->param.inout.intext)
        { e->param.inout.portnr = ++t_portnr;
          e->param.inout.port_typ = port_typ(e->param.inout.conf_nr);
        }
        break;
    }
    e = e->link;
  } 
}


/* ************************************************************************* */
/* Ermittle die Gesamtzahl der Prozessorelemente aller Konfigurationsgruppen */
/*                                                                           */
/* Ergebnis : Zahl der Prozessorelemente                                     */
/*                                                                           */
/* Parameter : Liste der Konfigurationsgruppen                               */
/*                                                                           */
/* ************************************************************************* */

int proz_zaehlen(g)
C_GROUP * g;
{ int anz = 0;
  if (g)
  { anz = proz_zaehlen(g->link);
    g->first_proz = anz;
    return anz + g->proz_anz;
  }
  return 0;
}


/* ************************************************************************* */
/* Auswertung einer Konfigurationsdeklaration                                */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : konfigurationsdeklaration                                     */
/*                                                                           */
/* ************************************************************************* */

int do_config_anal(c)
T_CONFIG * c;
{ if (c)
  { Eintrag * ein;
    int anz_a;
    if (c->link)
      anz_a = do_config_anal(c->link);
    else
      anz_a = -1;
    if (c->ident)
    { ein = suche_Eintrag(c->ident->wert.ident_nr,akt_ST,LOCAL,0);
      if (ein)
      { C_CONF * co;
        C_GROUP * g;
        GET_MEM(co,1,C_CONF);
        co->name = ein;
        conf_einhaengen(co,ein->param.config.conf_nr,
                        moment_group = ein->param.config.conf_group);
        if (c->ranges)
        { int dims = co->dims = c->ranges->count;
          GET_MEM(co->wert_von,dims,int);
          GET_MEM(co->wert_bis,dims,int);
          GET_MEM(co->wert_faktoren,dims,int);
          build_ranges(c->ranges,co);
          adjust_conf_array(co->typ);
          if (!ein->param.config.port_typ)
          { ST_TYPE * t;
            GET_MEM(t,1,ST_TYPE);
            t->liste = typen_liste;
            typen_liste = t;
            t->Art = ST_TPORT;
            t->gueltig = 1;
            t->info.port.key = c->ident->wert.ident_nr;
            ein->param.config.port_typ = t;
          }
          if (ein->param.config.typ = co->typ)
          { ein->param.config.proz_anz = ein->param.config.typ->used[ALL] = 
                                         count_proz_anz(co->typ);
          }
          if (ein->param.config.proz_anz == anz_a || anz_a == -1)
          { anz_a = ein->param.config.proz_anz;
          }
          else
          { if (ein->param.config.typ && ein->param.config.typ->gueltig)
            { SEMERROR(c->ident->Zeile,c->ident->Posit,
                       c->link->ident->Zeile,c->link->ident->Posit,
                       text[255]);
              interpreter = 1;
            }
            ein->param.config.proz_anz = anz_a;
          }
          if (c->group = g = get_group(ein->param.config.conf_nr))
          { g->proz_anz = anz_a;
            g->dims = (g->dims > dims) ? g->dims : dims;
            vector_ST = g->vectors;
            vector_ST->LocalVarAnz[INTEGER] = vector_ST->LocalVarAnz[ALL] = g->dims;
            ein->param.config.first_PE = g->first_proz + 1;
          }
        }
        else
        { interpreter = 1;
          ein->param.config.proz_anz = -1;
        }
      }
      else
      { interpreter = 1; }
    }
    else
    { interpreter = 1; }
    return anz_a;
  }
  return -1;
}

/* ************************************************************************* */
/* Analysiere die Bereichsangaben und bilde den entsprechenden DIM-Datentyp  */
/*                                                                           */
/* Ergebnis : Datentyp                                                       */
/*                                                                           */
/* Parameter : von-Expr, bis-Expr                                            */
/*             Konfiguration                                                 */
/*             Dimensionsnummer                                              */
/*                                                                           */
/* ************************************************************************* */

ST_TYPE * construct_range(v,b,c,n)
T_EXPR * v, * b;
C_CONF * c;
int n;
{ ST_TYPE * t;
  int art, bas, bas2, von, top;
  ST_TYPE * typ_v, * typ_b;
  GET_MEM(t,1,ST_TYPE);
  t->liste = typen_liste;
  typen_liste = t;
  t->gueltig = 0;
  if (v != NULL)
  { expr_auswerten(v,1);
    if (v->erg_art == ERG_CONST)
    { if (ermittle_grenze(v->erg.Const,&von,&bas,
                          v->Zeile,v->Posit,&typ_v) != JA)
      { typ_v = typ_error;
      }
      art = 0;
    }
    else
    { if (v->error == 0)
        SEMERROR(v->Zeile,v->Posit,0,0,
                 text[270]);
      typ_v = typ_error;
      interpreter = 1;
    }
  }
  else
  { von = bas = 0;
    typ_v = typ_int;
    art = -1 /* 0 */;
  }
  if (match_typen(typ_int, typ_v,1) != JA)
  { if (v->error == 0)
      SEMERROR(v->Zeile,v->Posit,0,0,text[235]);
    interpreter = v->error = 1;
  }
  expr_auswerten(b,1);
  if (b->erg_art == ERG_CONST)
  { ermittle_grenze(b->erg.Const,&top,&bas2,
                    b->Zeile,b->Posit,&typ_b);
    if (match_typen(typ_v,typ_b,1) == JA)
    { top += art;
      if (top < von)
      { if (art != 0)
        { if (b->error == 0)
            SEMERROR(b->Zeile,b->Posit,0,0,
                     text[282]);
        }
        else
        { if ((v->error == 0) && (b->error == 0))
            SEMERROR(v->Zeile,v->Posit,b->Zeile,b->Posit,
                     text[266 /* 283 */]);
        }
        interpreter = 1;
      }
      else
      { t->gueltig = 1;
        t->info.range.super = typ_b;
        t->info.range.basis = bas;
        t->firstelem = INTEGER;
        c->wert_von[n] = t->info.range.von = von;
        c->wert_bis[n] = t->info.range.bis = top;
        c->wert_faktoren[n] = top -von + 1;
      }
    }
    else
    { if (v == NULL)
      { if (b->error == 0)
          SEMERROR(b->Zeile,b->Posit,0,0,text[260]);
      }
      else
        if ((v->error == 0) && (b->error == 0))
          SEMERROR(v->Zeile,v->Posit,b->Zeile,b->Posit,text[271]);
      interpreter = 1;
    }
  }
  else
  { if (b->error == 0)
      SEMERROR(b->Zeile,b->Posit,0,0,text[270]);
    interpreter = 1;
  }
  t->used[INTEGER] = 1;
  t->used[ALL] = 1;
  t->Art = ST_TSUBRANGE;
  return t;
}


/* ************************************************************************* */
/* Auswertung der Unterbereichsangaben einer Konfigurationsdeklaration       */
/*                                                                           */
/* Ergebnis : Datentyp der Konfiguration (ARRAY [..] OF ...                  */
/*                                                                           */
/* Parameter : Unterbereich                                                  */
/*             Konfiguration                                                 */
/*                                                                           */
/* ************************************************************************* */

ST_TYPE * build_ranges(s,c)
T_SUBRANGE * s;
C_CONF * c;
{ if (s)
  { ST_TYPE * t, * t1 = NULL;
    GET_MEM(t,1,ST_TYPE);
    t->liste = typen_liste;
    typen_liste = t;
    t->Art  = ST_TARRAY;
    if (s->link)
    { t1 = build_ranges(s->link,c); }
    else
    { c->typ = t; }
    t->info.array.bereich = construct_range(s->von,s->bis,c,s->count-1);
    if (t1 && (t1 != typ_error))
    { t1->info.array.typ = t; }
    if (t->info.array.bereich)
    { t->gueltig = t->info.array.bereich->gueltig; }
    return t;
  }
  return typ_error;
}

/* ************************************************************************* */
/* Anpassung des Konfigurationstyps                                          */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Konfigurationstyp                                             */
/*                                                                           */
/* ************************************************************************* */

adjust_conf_array(t)
ST_TYPE * t;
{ if (t)
  { adjust_conf_array(t->info.array.typ);
    t->used[ALL] = t->info.array.bereich->info.range.bis -
                   t->info.array.bereich->info.range.von + 1;
    if (t->info.array.typ)
      t->used[ALL] *= t->info.array.typ->used[ALL];
  }
}

/* ************************************************************************* */
/* Hole die zur Konfigurationsnummer geh"orende Gruppe                       */
/*                                                                           */
/* Ergebnis : Konfigurationsgruppe                                           */
/*                                                                           */
/* Parameter : Konfigurationsnummer                                          */
/*                                                                           */
/* ************************************************************************* */

C_GROUP * get_group(nr)
int nr;
{ C_GROUP * g = conf_groups;
  C_CONF * c;
  while (g)
  { c = g->conf;
    while (c)
    { if (c->conf_nr == nr)
        return g;
      c = c->link;
    }
    g = g->link;
  }
  return NULL;
}


/* ************************************************************************* */
/* Hole die zur Konfigurationsgruppennummer geh"orende Gruppe                */
/*                                                                           */
/* Ergebnis : Konfigurationsgruppe                                           */
/*                                                                           */
/* Parameter : Konfigurationsgruppennummer                                   */
/*                                                                           */
/* ************************************************************************* */

C_GROUP * get_group_nr(nr)
int nr;
{ C_GROUP * g = conf_groups;
  while (g)
  { if (g->group_nr == nr)
      return g;
    g = g->link;
  }
  return NULL;
}

/* ************************************************************************* */
/* Einh"angen einer Konfiguration in die entsprechnede Konfigurationsgruppe  */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Konfiguration                                                 */
/*             Konfigurationsnummer                                          */
/*             Konfigurationsgruppennummer                                   */
/*                                                                           */
/* ************************************************************************* */

conf_einhaengen(c,c_nr,g_nr)
C_CONF * c;
int c_nr, g_nr;
{ C_GROUP * g;
  if (g = get_group_nr(g_nr))
  { vector_ST = g->vectors;
    if (g->conf_anf > c_nr || g->conf_anf == 0)
    { g->conf_anf = c_nr; }
    if (g->conf_end < c_nr)
    { g->conf_end = c_nr; }
    c->conf_nr = c_nr;
    c->link = g->conf;
    g->conf = c;
  }
}

/* ************************************************************************* */
/* Berechne die Prozessorelemente aus dem Konfigurationstyp                  */
/*                                                                           */
/* Ergebnis : Anzahl der Prozessorelemente der Konfiguration                 */
/*                                                                           */
/* Parameter : Konfigurationstyp                                             */
/*                                                                           */
/* ************************************************************************* */

int count_proz_anz(t)
ST_TYPE * t;
{ if (t)
  { int i = count_proz_anz(t->info.array.typ);
    if (t->info.array.bereich)
      i *= (t->info.array.bereich->info.range.bis - 
            t->info.array.bereich->info.range.von + 1);
    return i;
  }
  return 1;
}
    
