static char _sccsid[] = "Parallaxis Version: @(#)conn.c	2.13  2/28/92 15:09:56";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : conn.c                                                            */
/*                                                                           */
/* Auswertung der Verbindungen eines Parallaxisprogramms                     */
/*                                                                           */
/* ************************************************************************* */

# include "defines.h"
# include "makro2.h"
# include "makro.h"
# include "typen.h"
# include "symbols.h"
# include "y_tab.h"
# include "hilfsvar.h"
# include "conf.h"
# include "code.h"

extern int interpreter;
extern Eintrag * get_hvar();
extern int yylineno, yylineno2, sp_pos, sp_pos2, yynerrs;
extern int sp_pos;
extern ST_TYPE * typ_int, * typ_char, * typ_real, * typ_bool;

static ST_TYPE * conf_typ;
static VARNODE * hvar;
static int has_range;
static int has_range1;
extern int proz_anz;   /* Zahl der Prozessoren */
extern int calc_verbindungen;
extern int * connect;
extern int max_dims;

SINGLE_CON * einzelverbind;
int port_anz;
Eintrag ** variables;
Eintrag ** einheits;
int * source_con;
/* Zeiger auf die Namen der Ein- und Ausgabeports */
Eintrag * aus, * ein;
int zeile_a, posit_a, zeile_e, posit_e;
/* Symboltabelle fuer die Verbindungsvariablen */
ST * temp_ST;
extern char * null_eins_string;
/* Feld fuer die Zeiger auf die Aktivierung pro Dimension */
extern int ** string_01;

extern int MAXINTEGER;

C_GROUP * a_group;
C_CONF * s_conf, * d_conf;

int sc_zeile, sc_posit;
int same_group;

/* ************************************************************************* */
/* werte die Verbindungsdefinitionen aus                                     */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : alle Deklarationen                                            */
/*                                                                           */
/* ************************************************************************* */

do_connections(d)
T_DECLARATIONS * d;
{ if (d)
  { do_connections(d->link);
    if (d->select == N_CONFIGURATION)
    { int i;
      Eintrag *  e;
      if (a_group = d->art.conf->group)
      { vector_ST = a_group->vectors;
        temp_ST = a_group->temp;
        temp_ST->LocalVarAnz[ALL] = temp_ST->LocalVarAnz[INTEGER] = max_dims + 1;
        GET_MEM(connect,a_group->port_anz *
                (port_anz = ((a_group->port_anz + sizeof(int) * 8 - 1) /
                             (sizeof(int) * 8))), int);
        a_group->bitfeld = connect;
        GET_MEM(einzelverbind,a_group->port_anz,SINGLE_CON);
        a_group->einzel = einzelverbind;
      }
      else
      { temp_ST = neue_ST(vector_ST,1);
        all_tables = all_tables->link;
      }
      for (i = 0; i <= max_dims; i++)
      { GET_MEM(e,1,Eintrag);
        e->next = NULL;
        e->Art = N_VECTOR;
        e->gueltig = 1;
        e->param.var.art = INTEGER;
        e->param.var.ebene = temp_ST->Ebene;
        e->param.var.nummer = i + 1;
        e->param.var.type = typ_int;
        e->timestamp = akt_timestamp - 1;
        einheits[i] = e; 
        e->link = temp_ST->vector;
        temp_ST->vector = e;
      }
    }
    else if ((d->select == N_INPUT) && d->art.conn->trans)
    { akt_timestamp = d->art.conn->timestamp;
      erzeuge_verbindung(d->art.conn->trans);
    }
  }
}


/* ************************************************************************* */
/* suche den Porteintrag in der ST                                           */
/*                                                                           */
/* Ergebnis : Porteintrag                                                    */
/*                                                                           */
/* Parameter : Portbeschreibung                                              */
/*             Portnummer                                                    */
/*             Zeilennummer der Portdefinition                               */
/*             Spaltennummer der Portdefinition                              */
/*                                                                           */
/* ************************************************************************* */

Eintrag * ermittle_Port(io,pnr,zeile,posit)
T_IO_IDENT * io;
int * pnr, * zeile, * posit;
{ Eintrag * rueck;
  if (io == NULL) return NULL;
  rueck = suche_Eintrag(io->ident->wert.ident_nr,vector_ST,GLOBAL,0);
  * pnr = rueck->param.inout.portnr;
  * zeile = io->ident->Zeile;
  * posit = io->ident->Posit;
  if (io->Const != NULL)
  { int offset,bas;
    offset = get_Constant(io->Const,&bas);
    if (bas != 0)
    { SEMERROR(io->Const->Zeile,io->Const->Posit,0,0,
               text[272]);
      offset = 0;
    }
    *pnr += offset - rueck->param.inout.von;
  }
  return rueck;
}

/* ************************************************************************* */
/* suche den Configuartioneintrag in der ST                                  */
/*                                                                           */
/* Ergebnis : Konfiguration                                                  */
/*                                                                           */
/* Parameter : Konfigurationsname                                            */
/*                                                                           */
/* ************************************************************************* */

C_CONF * ermittle_Conf(name)
SCAN_ELEM * name;
{ Eintrag * rueck;
  C_GROUP * g;
  C_CONF * c;
  if (name == NULL) return NULL;
  rueck = suche_Eintrag(name->wert.ident_nr,vector_ST,GLOBAL,0);
  if (rueck)
  { if (rueck->Art == N_CONFIGURATION)
    { if (g = get_group(rueck->param.config.conf_nr))
      { c = g->conf;
        while (c && (c->conf_nr != rueck->param.config.conf_nr))
        { c = c->link; }
        return c;
      }
      SEMERROR(rueck->Zeile,rueck->Posit,name->Zeile,name->Posit,text[124]);
      return NULL;
    }
    SEMERROR(rueck->Zeile,rueck->Posit,name->Zeile,name->Posit,text[124]);
    return NULL;
  }
  SEMERROR(name->Zeile,name->Posit,0,0,text[124]);
  return NULL;
}

/* ************************************************************************* */
/* Verbindungen erzeugen                                                     */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Verbindungliste                                               */
/*                                                                           */
/* ************************************************************************* */

erzeuge_verbindung(tr)
T_TRANSFER * tr;
{ int pnr, i;
  if (tr ->link != NULL)
    erzeuge_verbindung(tr->link);
  aus = ermittle_Port(tr->out_ident,&pnr,&zeile_a,&posit_a);
  if ((s_conf = ermittle_Conf(tr->conf_ident)) == NULL)
  { return; }
  sc_zeile = tr->conf_ident->Zeile;
  sc_posit = tr->conf_ident->Posit;
  if (tr->sources && (tr->sources->count >= s_conf->dims))
    setze_sourcevar(tr->sources);
  else
  { SEMERROR(tr->conf_ident->Zeile,tr->conf_ident->Posit,0,0,text[139]);
    setze_sourcevar(tr->sources);
  }
  vector_ST = temp_ST;
  for (i = 0; i < a_group->dims; i++)
  { if (variables[i] != NULL)
    { variables[i]->gueltig = variables[i]->param.Const->gueltig = 1; }
  }
  berechne_ziele(&connect[(pnr - 1) * ((port_anz + sizeof(int) * 8 - 1) /
                                       (sizeof(int) * 8))],pnr,tr->destinations,tr->arrow);
  for (i = 0; i < a_group->dims; i++)
  { if (variables[i] != NULL)
    { variables[i]->gueltig = 0; }
  }
  vector_ST = temp_ST->Obertabelle;
}
  
/* ************************************************************************* */
/* Alle Zielbeschreibungen nacheinander eintragen                            */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Menge mit allen Verbindungen                                  */
/*             Nummer des OUT-Ports                                          */
/*             Zielbeschreibungen                                            */
/*                                                                           */
/* ************************************************************************* */

extern ZWCODE * berechnung_ausfuehren();
       
berechne_ziele(bitfeld,apnr,dest,arr)
int bitfeld[];
int apnr;
int arr;
T_DESTINATION * dest;
{ int i, epnr, berech_zeilen,yyn = yynerrs;
  C_GROUP * g1, * g2;
  ZWCODE * zw;
  C_GROUP * g;
  if (dest != NULL)
  { Eintrag * e;
    if (dest->link != NULL)
      berechne_ziele(bitfeld,apnr,dest->link,arr);
    ein = ermittle_Port(dest->in_ident,&epnr,&zeile_e,&posit_e);
    if ((d_conf = ermittle_Conf(dest->conf_ident)) == NULL)
      return;
    g1 = get_group(s_conf->conf_nr);
    g2 = get_group(d_conf->conf_nr);
    if ((g1 != a_group) && (g2 != a_group))
    { SEMERROR(sc_zeile,sc_posit,dest->conf_ident->Zeile,dest->conf_ident->Posit,text[168]);
      same_group = 0;
    }
    else
    { same_group = (g1 == g2); }
    if (ein == NULL) return;
    has_range = 0;
    has_range1 = 0;
    vector_ST = temp_ST;
    SET_BIT(epnr,bitfeld);
    if (same_group)
    { if ((i = einzelverbind[apnr - 1].zahl++) == 0)
      { einzelverbind[apnr - 1].epnr = epnr; }
      else
      { if ((i == 1) && (einzelverbind[apnr - 1].epnr == epnr))
        { einzelverbind[apnr - 1].zahl = 1; }
      }
    }
    if (arr)
    { int *bitfeld1;
      bitfeld1 = &connect[(epnr - 1) * ((port_anz + sizeof(int) * 8 - 1) /
                                       (sizeof(int) * 8))];
      SET_BIT(apnr,bitfeld1);
      if (same_group)
      { if ((i = einzelverbind[epnr - 1].zahl++) == 0)
        { einzelverbind[epnr - 1].epnr = apnr; }
        else
        { if ((i == 1) && (einzelverbind[epnr - 1].epnr == apnr))
          { einzelverbind[epnr - 1].zahl = 1; }
        }
      }
    }
    has_range = 0;
    if (expr_vorbereiten(dest) == 0)
      return;
    if (yynerrs == yyn)
    { T_SUBRANGE * s;
      int constants = 0;
      int neg = 0;
      ZWCODE * zw1, * zw2, * zw3;
      interpreter = 0;
      vector_ST = temp_ST;
      hvarsvect = g1->temp->hvarsvect;
      hvarsscal = g1->temp->hvarsscal;
      for (i = 0; i < s_conf/*a_group*/->dims; i++)
      { if ((variables[i]) != NULL)
        { variables[i]->link = einheits[i]; }
        else
        { constants++; }
      }
      GET_MEM(hvar,1,VARNODE);
      hvar->lk = VARi;
      VARi = hvar;
      hvar->ein = einheits[max_dims];
      hvar->firstelem = INTEGER;
      hvar->scavec = 1;
      hvar->dir_indir =  DIRECT;
      if (dest->discexpr)
      { expr_auswerten(dest->discexpr,0);
        if (dest->discexpr->erg_art == ERG_CONST)
        { if (dest->discexpr->erg.Const->wert.range.val == 0)
            return;
          dest->discexpr = NULL;
        }
        else
        { free_hvar(dest->discexpr->hv); }
      }
      /*constants = (constants > has_range) ? constants - has_range : 0;*/
      GET_MEM(zw,1,ZWCODE);
      zw->art = CO_CONNECTION;
      zw->com.connection.has_range = has_range;
      zw->com.connection.conf = s_conf;
      zw->com.connection.dconf = d_conf;
      zw->com.connection.max_dim = max_dims;
      g = get_group(d_conf->conf_nr);
      if (dest->discexpr)
      { zw->com.connection.bexpr = dest->discexpr->code;
        zw->com.connection.bvar = dest->discexpr->hv;
      }
      code_einhaengen(zw,s_conf,zw->com.connection.group = g1);
      conf_typ = d_conf->typ;
      zw->com.connection.von = apnr;
      zw->com.connection.bis = epnr;
      zw->com.connection.mode = arr;
      zw1 = zw2 = NULL;
      zw3 = zw->com.connection.rest = berechnung_ausfuehren(dest->exprlist);
      if (zw3)
      { while (((zw3->art == CO_CONN) && (zw3->com.conn.next)) ||
               ((zw3->art == CO_CORANGE) && (zw3->com.corange.next)))
        { if (zw3->art == CO_CONN)
          { if (zw1 == NULL)
              zw1 = zw3;
            zw2 = zw3;
            zw3 = zw3->com.conn.next;
          }
          else
            zw3 = zw3->com.corange.next;
        }
        if (zw3->art == CO_CONN)
        { zw2 = zw3;
          if (zw1 == NULL)
            zw1 = zw3;
        }           
        if (zw1)
        {  zw1->com.conn.mode |= 2;
           zw1->com.conn.off = 0;
        }
        if (zw2)
        { zw2->com.conn.mode |= 1;
          zw2->com.conn.off = g->first_proz + 1;
        }
      }
      interpreter = 1;
      s = dest->exprlist;
      berech_zeilen = (has_range) ? 1 : 0;
      while (s)
      { if (s->von && s->von->code)
        { free_hvar(s->von->code->com.corange.var1);
          free_hvar(s->von->code->com.corange.var2);
        }
        else
          free_hvar(s->bis->hv);
        berech_zeilen += s->bis->zeilen + 1;
        s = s->link;
      }
      if (constants)
      { int * t;
        GET_MEM(t,2 * constants, int);
        zw->com.connection.source = t;
        for (i = 0; i < a_group->dims; i++)
        { if ((e = variables[i]) != NULL)
          { e->gueltig = 0; }
          else
          { *t++ = source_con[i];
            *t++ = i + 1;
            if (source_con[i] < 0)
              neg = 1;
          }
        } 
      }
      if (neg)
      { VARNODE * var;
        GET_MEM(var,1,VARNODE);
        var->lk = VARi;
        VARi = var;
        var->ein = get_hvar(typ_int,var->scavec = 1);
        var->firstelem = INTEGER;
        var->dir_indir = DIRECT;
        var->free = 1;
        free_hvar(var);
        zw->com.connection.ihv = var;
      }
      if ((zw->com.connection.constants = constants) > 1)
      { VARNODE * var1, * var2;
        GET_MEM(var1,1,VARNODE);
        var1->lk = VARi;
        VARi = var1;
        var1->ein = get_hvar(typ_bool,var1->scavec = 1);
        var1->firstelem = BOOLEAN;
        var1->dir_indir =  DIRECT;
        var1->free = 1;
        GET_MEM(var2,1,VARNODE);
        var2->lk = VARi;
        VARi = var2;
        var2->ein = get_hvar(typ_bool,var2->scavec = 1);
        var2->firstelem = BOOLEAN;
        var2->dir_indir =  DIRECT;
        var2->free = 1;
        free_hvar(var1);
        free_hvar(var2);
        zw->com.connection.b1var = var1;
        zw->com.connection.b2var = var2;
        zw->com.connection.czeilen = 2;
      }
      else
      { if (constants)
        { zw->com.connection.czeilen = 2; }
        else
        { zw->com.connection.czeilen = -1; }
      }
      zw->com.connection.zeilen = berech_zeilen;
      zw->com.connection.czeilen += berech_zeilen;
      if (dest->discexpr)
        zw->com.connection.czeilen += dest->discexpr->zeilen + 3;
      g1->zeilen += zw->com.connection.czeilen + 1;
      if (has_range == d_conf->dims)
        zw->com.connection.czeilen--;
      g1->temp->hvarsvect = hvarsvect;
      g1->temp->hvarsscal = hvarsscal;
      vector_ST = temp_ST->Obertabelle;
    }
  }
}

/* ************************************************************************* */
/* erzeuge f"ur eine Verbindung den Zwischencode                             */
/*                                                                           */
/* Ergebnis : der Zwischencode                                               */
/*                                                                           */
/* Parameter : die Bereichsausdr"ucke                                        */
/*                                                                           */
/* ************************************************************************* */

ZWCODE * berechnung_ausfuehren(sexpr)
T_SUBRANGE * sexpr;
{ T_EXPR * ex1, * ex2;
  int z = '-';
  int error = 0;
  SCAN_ELEM * sc;
  ZWCODE * zw, * zw1, * zw3;
  T_EXPR * expr;
  if (sexpr == NULL)
    return NULL;
  zw1 = berechnung_ausfuehren(sexpr->link);
  if (sexpr->von)
  { VARNODE * var1, * var2;
    ZWCODE * zw2 = NULL;
    int anz_pe;
    if ((sexpr->von->erg.Const->wert.i < conf_typ->info.array.bereich->info.range.von) ||
        (sexpr->von->erg.Const->wert.i > conf_typ->info.array.bereich->info.range.bis))
    { if (sexpr->von->error == 0)
        SEMERROR(sexpr->von->Zeile,sexpr->von->Posit,0,0,text[273]);
      error = sexpr->von->error = interpreter = 1;
    }
    if ((sexpr->bis->erg.Const->wert.i > conf_typ->info.array.bereich->info.range.bis) ||
        (sexpr->bis->erg.Const->wert.i < conf_typ->info.array.bereich->info.range.von))
    { if (sexpr->bis->error == 0)
        SEMERROR(sexpr->bis->Zeile,sexpr->bis->Posit,0,0,text[273]);
      error = sexpr->bis->error = interpreter = 1;
    }
    if (error)
    { conf_typ = conf_typ->info.array.typ;
      return zw1;
    }
    GET_MEM(zw,1,ZWCODE);
    zw->art = CO_CORANGE;
    zw->com.corange.bis = sexpr->bis->erg.Const->wert.i - sexpr->von->erg.Const->wert.i;
    zw->com.corange.bas = (sexpr->von->erg.Const->wert.i -
                           conf_typ->info.array.bereich->info.range.von) *
                           (zw->com.corange.add = (conf_typ->info.array.typ)
                                                   ? conf_typ->info.array.typ->used[ALL]
                                                   : 1);
    if (has_range1)
    { GET_MEM(var1,1,VARNODE);
      var1->lk = VARi;
      VARi = var1;
      var1->ein = get_hvar(typ_int,var1->scavec = 1);
      var1->firstelem = INTEGER;
      var1->dir_indir =  DIRECT;
      var1->free = 1;
    }
    else
    { var1 = NULL;
      has_range1 = 1;
    }
    GET_MEM(var2,1,VARNODE);
    var2->lk = VARi;
    VARi = var2;
    var2->ein = get_hvar(typ_int,var2->scavec = 0);
    var2->firstelem = INTEGER;
    var2->dir_indir =  DIRECT;
    var2->free = 1;
    zw->com.corange.var1 = var1;
    zw->com.corange.var2 = var2;
    zw->com.corange.var3 = hvar;
    sexpr->von->code = zw;
    sexpr->zeilen = 1;
    anz_pe = conf_typ->info.array.bereich->info.range.bis -
             conf_typ->info.array.bereich->info.range.von + 1;
    conf_typ = conf_typ->info.array.typ;
    if (zw1)
    { zw3 = zw1;
      while (((zw3->art == CO_CONN) && (zw3->com.conn.next)) ||
             ((zw3->art == CO_CORANGE) && (zw3->com.corange.next)))
      { if (zw3->art == CO_CONN)
        { zw2 = zw3;
          zw3 = zw3->com.conn.next;
        }
        else
          zw3 = zw3->com.corange.next;
      }
      if (zw3->art == CO_CONN)
        zw2 = zw3;
/*      if (zw2)
      { zw2->com.conn.fak *= anz_pe; }*/
      if (zw3->art == CO_CONN)
        zw3->com.conn.next = zw;
      else
        zw3->com.corange.next = zw;
      return zw1;
    }
    else
      return zw;
  }
  else
  { expr = sexpr->bis;
    if (expr)
    { ST_TYPE * t;
      if (conf_typ->info.array.bereich->info.range.von)
      { GET_MEM(sc,1,SCAN_ELEM);
        sc->Art = INTCONSTANT;
        sc->wert.i = conf_typ->info.array.bereich->info.range.von;
        if (sc->wert.i < 0)
        { sc->wert.i = -sc->wert.i;
          z = '+';
        } 
        MAKE_CONST(&ex1,sc);
        GET_MEM(sc,1,SCAN_ELEM);
        sc->Art = z;
        MAKE_BINOP(&ex2,expr,sc,ex1);
        sexpr->bis = ex2;
      }
      else
        ex2 = expr;
      expr_auswerten(ex2,0);
      GET_MEM(zw,1,ZWCODE);
      zw->art = CO_CONN;
      if (ex2->erg_art == ERG_CONST)
      { zw->com.conn.offset = ex2->erg.Const->wert.i;
        if ((zw->com.conn.offset > (conf_typ->info.array.bereich->info.range.bis -
                                   conf_typ->info.array.bereich->info.range.von)) ||
            (zw->com.conn.offset < 0))
        { SEMERROR(sexpr->bis->Zeile,sexpr->bis->Posit,0,0,text[273]);
          error = sexpr->bis->error = interpreter = 1;
        }
      }
      else
      { zw->com.conn.exprvar = ex2->hv; }
      zw->com.conn.expr = ex2->code;
      zw->com.conn.hvar = hvar;
      if (t = conf_typ->info.array.typ)
      { t = t->info.array.bereich;
        zw->com.conn.fak = t->info.range.bis - t->info.range.von + 1;
      }
      else
        zw->com.conn.fak = 1;
      zw->com.conn.top = conf_typ->info.array.bereich->info.range.bis -
                         conf_typ->info.array.bereich->info.range.von;
      conf_typ = conf_typ->info.array.typ;
      if (zw1)
      { zw3 = zw1;
        while (((zw3->art == CO_CONN) && (zw3->com.conn.next)) ||
               ((zw3->art == CO_CORANGE) && (zw3->com.corange.next)))
        { if (zw3->art == CO_CONN)
            zw3 = zw3->com.conn.next;
          else
            zw3 = zw3->com.corange.next;
        }
        if (zw3->art == CO_CONN)
          zw3->com.conn.next = zw;
        else
          zw3->com.corange.next = zw;
        return zw1;
      }
      else
        return zw;
    }
  }
  return NULL;
}


/* ************************************************************************* */
/* trage die Variablen in der Verbindungsdefinition ein                      */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Variablenliste                                                */
/*                                                                           */
/* ************************************************************************* */

setze_sourcevar(source)
T_SOURCE * source;
{ int c, w;
  Eintrag * eintr;
  if (source != NULL)
  { if (source->link != NULL)
      setze_sourcevar(source->link);
    if ((source->wert != NULL) && ((c = source->count - 1) < s_conf->dims))
    { if (source->wert->Art == IDENT)
      { if ((eintr = suche_Eintrag(source->wert->wert.ident_nr,vector_ST,GLOBAL,0)) != NULL)
        { variables[c] = NULL;
          if (eintr->Art == N_CONSTANT)
          { if ((eintr->gueltig == 1) && (eintr->param.Const != NULL))
            { if (eintr->param.Const->Art == ST_CINT)
              { source_con[c] = w = eintr->ST_CGINT;
                if ((w >= s_conf->wert_von[c]) && (w <= s_conf->wert_bis[c]))
                { }
                else
                { SEMERROR(source->wert->Zeile,source->wert->Posit,eintr->Zeile,eintr->Posit,
                           text[273]);
                }
              }
              else
              { SEMERROR(source->wert->Zeile,source->wert->Posit,eintr->Zeile,eintr->Posit,
                         text[174]);
              }
            }
            else
            { SEMERROR(source->wert->Zeile,source->wert->Posit,eintr->Zeile,eintr->Posit,
                       text[171]);
            }
          }
          else
          { switch(eintr->Art)
            { case N_SYSTEM :
              case N_TYPE :
              case N_CONFIGURATION :
              case N_IO :
              case N_IOK :
              case N_INPUT :
              case N_INPUTK :
              case N_OUTPUT :
              case N_OUTPUTK :
              case N_SPEZIAL_SKA :
              case N_SPEZIAL_VEK :
                SEMERROR(source->wert->Zeile,source->wert->Posit,eintr->Zeile,eintr->Posit,
                         text[172]);
                break;
              default :
                vector_ST = temp_ST;
                eintr = mache_Eintrag(source->wert->wert.ident_nr,&dummy,N_TEMP);
                vector_ST = temp_ST->Obertabelle;
                if (dummy == NEIN)
                { ST_CONST * con;
                  GET_MEM(con,1,ST_CONST);
                  eintr->param.Const = con;
                  con->gueltig = 1;
                  con->Art = ST_CINT;
                  con->type = typ_int;
                }
                eintr->timestamp = akt_timestamp-1;
                if (eintr->param.Const->gueltig == 1)
                { eintr->param.Const->gueltig = 0;
                  (variables[c] = eintr)->param.Const->wert.i = s_conf->wert_von[c];
                }
                else
                  variables[c] = eintr;
                break;
            }
          }
        }
        else
        { vector_ST = temp_ST;
          eintr = mache_Eintrag(source->wert->wert.ident_nr,&dummy,N_TEMP);
          vector_ST = temp_ST->Obertabelle;
          if (dummy == NEIN)
          { ST_CONST * con;
            GET_MEM(con,1,ST_CONST);
            eintr->param.Const = con;
            con->gueltig = 1;
            con->Art = ST_CINT;
            con->type = typ_int;
          }
          eintr->timestamp = akt_timestamp-1;
          if (eintr->param.Const->gueltig == 1)
          { eintr->param.Const->gueltig = 0;
            (variables[c] = eintr)->param.Const->wert.i = s_conf->wert_von[c];
          }
          else
            variables[c] = eintr;
        }
      }
      else
      { source_con[c] = w = source->wert->wert.i;
        if ((w < s_conf->wert_von[c]) || (w > s_conf->wert_bis[c]))
        { SEMERROR(source->wert->Zeile,source->wert->Posit,0,0,
                   text[273]);
        }
        variables[c] = NULL;
      }
    }
  }
}

/* ************************************************************************* */
/* Auswahlausdruck und Zielausdruecke vorbereiten                            */
/*                                                                           */
/* Ergebnis : 0 oder 1                                                       */
/*                                                                           */
/* Parameter : Zielbeschreibung                                              */
/*                                                                           */
/* ************************************************************************* */

int expr_vorbereiten(dest)
T_DESTINATION * dest;
{ T_EXPR * ex;
  T_SUBRANGE * sr;
  int res = 1;
  if ((ex = dest->discexpr) != NULL)
  { calc_verbindungen = 1;
    expr_auswerten(ex,1);
    calc_verbindungen = 0;
    if ((match_typen(ex->erg_typ,typ_bool,0) != JA) || (ex->erg_art != ERG_CONST))
    { if (ex->error == 0)
      { SEMERROR(ex->Zeile,ex->Posit,0,0,
                 text[137]);
      }
      res = 0;
    }
  }
  if (dest->exprlist->count < d_conf->dims)
  { SEMERROR(dest->conf_ident->Zeile,dest->conf_ident->Posit,0,0,text[274]);
    make_intexpr(dest->exprlist);
    vector_ST = temp_ST->Obertabelle;
    return 0;
  }
  if (dest->exprlist->count > d_conf->dims)
  { sr = dest->exprlist;
    while (sr->count > (d_conf->dims + 1))
    { sr = sr->link; }
    make_intexpr(sr->link);
    if (sr->von)
      SEMERROR(sr->von->Zeile,sr->von->Posit,0,0,text[275]);
    else
      SEMERROR(sr->bis->Zeile,sr->bis->Posit,0,0,text[275]);
    vector_ST = temp_ST->Obertabelle;
    return 0;
  }
  res *= make_intexpr(dest->exprlist);
  vector_ST = temp_ST->Obertabelle;
  return res;
}

/* ************************************************************************* */
/* Integerausdruecke vorbereiten                                             */
/*                                                                           */
/* Ergebnis : 0 oder 1                                                       */
/*                                                                           */
/* Parameter :Liste von Ausdruecken                                          */
/*                                                                           */
/* ************************************************************************* */

int make_intexpr(expr)
T_SUBRANGE * expr;
{ int ret;
  T_EXPR * ex;
  ret = 1;
  if (expr->link != NULL)
  { ret *= make_intexpr(expr->link); }
  calc_verbindungen = 1;
  if (expr->von)
  { expr_auswerten(ex = expr->von,0);
    if ((match_typen(ex->erg_typ, typ_int,0) != JA) || (ex->erg_art != ERG_CONST))
    { if (ex->error == 0)
      { SEMERROR(ex->Zeile,ex->Posit,0,0,
                 text[259]);
      }
      ret = 0;
    }
    if (ret && (ex->erg.Const->Art == ST_CTYPDESC))
    { SEMERROR(ex->Zeile,ex->Posit,0,0,text[338]);
      ret = 0;
    }
    expr_auswerten(ex = expr->bis,0);
    if ((match_typen(ex->erg_typ, typ_int,0) != JA) || (ex->erg_art != ERG_CONST))
    { if (ex->error == 0)
      { SEMERROR(ex->Zeile,ex->Posit,0,0,
                 text[259]);
      }
      return 0;
    }
    if (ex->erg.Const->Art == ST_CTYPDESC)
    { SEMERROR(ex->Zeile,ex->Posit,0,0,text[338]);
      return 0;
    }
    if (ret && (ex->erg.Const->wert.i < expr->von->erg.Const->wert.i))
    { SEMERROR(expr->von->Zeile,expr->von->Posit,ex->Zeile,ex->Posit,text[264]);
      return 0;
    }
    if (ex->erg.Const->wert.i == expr->von->erg.Const->wert.i)
    { expr->von = NULL; }
    else
      has_range++;
  }
  else
  { expr_auswerten(ex = expr->bis,1);
    if ((match_typen(ex->erg_typ, typ_int,0) != JA) || (ex->erg_art != ERG_CONST))
    { if (ex->error == 0)
      { SEMERROR(ex->Zeile,ex->Posit,0,0,
                 text[259]);
      }
      return 0;
    }
    if (ex->erg.Const->Art == ST_CTYPDESC)
    { SEMERROR(ex->Zeile,ex->Posit,0,0,text[338]);
      return 0;
    }
  }
  calc_verbindungen = 0;
  return ret;
}


/* ************************************************************************* */
/* h"ange den Zwischencode konfigurationsabh"angig ein                       */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : die Bereichsausdr"ucke                                        */
/*             Konfiguration                                                 */
/*             Konfigurationsgruppe                                          */
/*                                                                           */
/* ************************************************************************* */

code_einhaengen(zw,s,g)
ZWCODE * zw;
C_CONF * s;
C_GROUP * g;
{ ZWCODE * zw1, * zw2 = NULL;
  if (zw1 = g->code)
  { while (1)
    { if (s == zw1->com.connection.conf)
      { zw2 = zw1;
        while (zw2->link)
        { if (zw2->link->com.connection.conf)
          { zw->link = zw2->link;
            zw2->link = zw;
            zw->com.connection.conf = NULL;
            return;
          }
          zw2 = zw2->link;
        }
        zw2->link = zw;
        zw->com.connection.conf = NULL;
        return;
      }
      if (zw1->link == NULL)
      { zw->link = NULL;
        zw1->link = zw;
        g->zeilen++;
        return;
      }
      zw1 = zw1->link;
    }
  }
  g->zeilen++;
  zw->link = g->code;
  g->code = zw;
}

