static char _sccsid[] = "Parallaxis Version: @(#)crosscheck.c	2.13  2/28/92 15:09:56";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : crosscheck.c                                                      */
/*                                                                           */
/* Funktionen, die die Prozeduren gegenseitig auf PARALLEL-Bl"ocke untersucht*/
/*                                                                           */
/* ************************************************************************* */


#include "pass2.h"

static int f[7][7][2] = {{{0,0},{1,1},{1,1},{3,3},{4,4},{5,5},{6,6}},
                         {{1,1},{1,1},{1,1},{-1,-1},{-1,-5},{-1,-5},{-1,-5}},
                         {{2,2},{-2,-2},{-2,-2},{-3,2},{2,-5},{2,-5},{2,-5}},
                         {{3,3},{-2,-2},{-2,-2},{-3,3},{3,-5},{3,-5},{3,-5}},
                         {{4,4},{-2,-2},{-2,-2},{-3,-3},{4,4},{4,4},{4,4}},
                         {{5,5},{-2,-2},{-2,-2},{-3,-3},{4,4},{5,5},{5,5}},
                         {{6,6},{-2,-2},{-2,-2},{-3,-3},{-4,-4},{6,6},{6,6}}};

/* ************************************************************************* */
/* Anpassungsfunktion f"ur die Prozedur"uberpr"ufungen                       */
/*                                                                           */
/* Ergebnis : alter Wert                                                     */
/*                                                                           */
/* Parameter : neuer, negativer Wert                                         */
/*                                                                           */
/* ************************************************************************* */

int adapt_proz(i)
int i;
{ if (i < 0)   /* bereits behandelt */
    return i;
  if (i & 2)   /* enth"alt CONFIGURATION */
    return -2;
  if (i & 4)   /* Selektion */
    return -3;
  if (i & 8)   /* Datenaustauschanweisung */
    return -4;
  if (i & 32)  /* zur Reduktion verwendet */
    return -6;
  if (i & 16)  /* verwendet vektorielle Variablen oder hat vektorielle Parameter */
    return -5;
  if (i & 1)   /* enth"alt noch kein CONFIGURATION */
    return -1;
  return 0;    /* skalar */
}


/* ************************************************************************* */
/* "uberpr"uft die Funktionen auf versteckte, geschachtelte PARALLEL-Bl"ocke */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter :                                                               */
/*                                                                           */
/* ************************************************************************* */

cross_checking()
{ PROCLIST * p1;
  int x1,x2,x, cn,flag = 1;
  p1 = used_proc;
  while (p1)
  { if (p1->wo)
      p1->wo->param.proz.info = adapt_proz(p1->wo->param.proz.info);
    if (p1->wer)
      p1->wer->param.proz.info = adapt_proz(p1->wer->param.proz.info);
    p1 = p1->link;
  }
  p1 = used_proc;
  while (p1)
  { if (p1->wo)
    { x = p1->wo->param.proz.info;
      if (x < 0)
        p1->wo->param.proz.info = -x;
    }
    if (p1->wer)
    { x = p1->wer->param.proz.info;
      if (x < 0)
        p1->wer->param.proz.info = -x;
      p1 = p1->link;
    }
  }
  while (flag)
  { flag = 0;
    p1 = used_proc;
    while (p1)
    { if (p1->wo)
        x1 = p1->wo->param.proz.info;
      else
        x1 = -1;
      if (p1->wer)
        x2 = p1->wer->param.proz.info;
      else
        x2 = -1;
      if ((x1 >= 0) && (x2 >= 0))
      { if (((x = f[x1][x2][(p1->mode & PI_VECTOR) ? 0 : 1]) < 0) &&
            (p1->error == 0))
        { interpreter = 1;
          SEMERROR(p1->Zeile,p1->Posit,0,0,text[344-x]);
          p1->error = 1;
        }
        if (p1->wo)
        { if ((x >= 0) && (x != p1->wo->param.proz.info))
          { flag = 1 ;
            p1->wo->param.proz.info = x;
          }
        }
        if (p1->mode & PI_VECTOR)
        { if ((cn = p1->wer->param.proz.conf_nr) > 0)
          { if ((cn != p1->conf) && (p1->error == 0))
            { interpreter = 1;
              SEMERROR(p1->Zeile,p1->Posit,0,0,text[350]);
              p1->error = 1;
            }
          }
          if ((p1->wo->param.proz.conf_nr == 0) && (p1->error == 0))
          { p1->wo->param.proz.conf_nr = p1->wer->param.proz.conf_nr; }
        }
        else
        { if ((p1->wo->param.proz.conf_nr == 0) && (p1->error == 0))
          { p1->wo->param.proz.conf_nr = p1->wer->param.proz.conf_nr; }
        }
      }
      p1 = p1->link;
    }
  }
}

