static char _sccsid[] = "Parallaxis Version: @(#)expr.c	2.15  12/7/92 16:48:59";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : expr.c                                                            */
/*                                                                           */
/* Funktionen, die die Ausdr"ucke analysieren                                */
/*                                                                           */
/* ************************************************************************* */


#include "pass2x.h"
#include "conf.h"

#include "wb.h"

extern long min_nr, max_nr;
extern int divisionstest;
extern int nil_pointertest;
extern int member_of_conf, actual_group_nr, vector_Ebene;
extern Eintrag spez_eintr;
int pointer_check = 0;
extern ZWCODE * pointer_filter();


/* ************************************************************************* */
/* Auswertung eines Ausdrucks                                                */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Ausdruck                                                      */
/*             Konstanter Ausdruck (1) oder nicht (0)                        */
/*                                                                           */
/* ************************************************************************* */

expr_auswerten(expr,mode)
int mode;
T_EXPR * expr;
{ int desig = 0;
  if (expr == NULL) return;
  expr->erg_art = ERG_UNDEF;
  expr->scavec = 0;
  switch(expr->select)
  { case E_BINOP :
      binop_expr(expr,mode);
      break;
    case E_DESIGNAT :
      desig = 1;
    case E_DESIGN :
      desig_expr(expr,desig,mode);
      break;
    case E_KLEXPR :
      klexpr_expr(expr,mode);
      break;
    case E_NOTEXPR :
      notexpr_expr(expr,mode);
      break;
    case E_CONST :
      const_expr(expr,mode);
      break;
    case E_SINOP :
      sinop_expr(expr,mode);
      break;
    case E_FUNC :
      func_expr(expr,mode);
      break;
    case E_SET :
      set_expr(expr);
      break;
    case E_REDUCE :
      reduce_expr(expr);
      break;
    default :
      bug("expr_auswerten Auswahl  %d",expr->select);
  }
  if (mode && (((expr->erg_art != ERG_CONST) && (expr->erg_art != ERG_TYPE)) ||
               (expr->erg.Const == NULL) || (expr->erg.Const->Art == ST_CTYPDESC)))
  { if (expr->error == 0)
    { SEMERROR(expr->Zeile,expr->Posit,0,0,text[268]); }
    expr->error = interpreter = 1;
  }
}

/* ************************************************************************* */
/* Auswertung einer Liste von Ausdruecken                                    */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Liste von Ausdruecken                                         */
/*             Liste von konstanten Ausdruecken (1) oder nicht (0)           */
/*                                                                           */
/* ************************************************************************* */

exprlist_auswerten(expr,mode)
T_EXPR * expr;
int mode;
{ if (expr != NULL)
  { if (expr->link != NULL)
      exprlist_auswerten(expr->link,mode);
    expr_auswerten(expr,mode);
  }
}




binop_expr(expr,mode)
T_EXPR * expr;
int mode;
{ T_EXPR * ex1, * ex2;
  if ((expr->factors.binop.twice & EX_DOPP) == EX_DOPP)  /* a < b < c */
  { T_EXPR * ex3;
    VARNODE * hbvvar, * hbsvar;
    if (mode || interpreter)
      hbsvar = hbvvar = NULL;
    else
    { GET_MEM(hbvvar,1,VARNODE);
      hbvvar->lk = VARi;
      VARi = hbvvar;
      hbvvar->firstelem = BOOLEAN;
      hbvvar->free = 1;
      hbvvar->dir_indir = DIRECT;
      hbvvar->ein = get_hvar(typ_bool,hbvvar->scavec = 1);
      GET_MEM(hbsvar,1,VARNODE);
      hbsvar->lk = VARi;
      VARi = hbsvar;
      hbsvar->firstelem = BOOLEAN;
      hbsvar->free = 1;
      hbsvar->dir_indir = DIRECT;
      hbsvar->ein = get_hvar(typ_bool,hbsvar->scavec = 0);
    }
    ex1 = expr->factors.binop.expr1;
    ex1->factors.binop.twice |= EX_SPEC;
    expr_auswerten(ex1,mode);                             /* a < b */
    if (match_typen(ex1->erg_typ,typ_bool,
                    (expr->factors.binop.operator->Art == _IN) ? 0 : 1) != JA)
    { if (ex1->error == 0)
      { SEMERROR(ex1->Zeile,ex1->Posit,0,0,text[181]);
      }
      expr->error = ex1->error = interpreter = 1;
    }
    free_hvar(ex1->hv);
    ex2 = expr->factors.binop.expr2;
    ex3 = ex1->factors.binop.expr2;
    expr_auswerten(ex2,mode);
    expr->scavec = ex1->scavec | ex2->scavec;
    if ((ex3->error == 0) && (ex2->error == 0))
    { if ((expr->erg_typ = typ_berechnung(expr->factors.binop.operator->Art,
                 ex3->erg_typ, ex2->erg_typ)) != typ_error)
      { if (((ex1->erg_art == ERG_CONST) && (ex1->erg.Const->Art != ST_CTYPDESC)) &&
            ((ex2->erg_art == ERG_CONST) && (ex2->erg.Const->Art != ST_CTYPDESC)))
        { ST_CONST * c;
          expr->erg_art = ERG_CONST;
          c = eval_binexpr(expr->factors.binop.operator->Art,
                           ex3->erg.Const,ex2->erg.Const);
          expr->erg.Const = eval_binexpr(_AND,ex1->erg.Const,c);
          expr->erg_typ = typ_bool;
          if (hbvvar)
          { no_count(hbvvar,1);
            no_count(hbsvar,0);
          }
        }
        else
        { if ((ex1->erg_art == ERG_CONST) && (ex2->erg_art == ERG_CONST))
          { if (ex1->erg.Const->Art == ST_CTYPDESC)
            { mache_Constexpr(ex1,typ_int,1); }
            else
            { mache_Constexpr(ex2,typ_int,1); }
          }
          expr->erg_art = ERG_VAR;
          if (interpreter == 0)
          { VARNODE * hbvar;
            if (expr->scavec)
            { hbvar = hbvvar;
              no_count(hbsvar,0);
            }
            else  
            { hbvar = hbsvar;
              no_count(hbvvar,1);
            }
            expr_relopconn(expr,hbvar);
          }
          expr->erg_typ = typ_bool;
        }
      }
      else
      { SEMERROR(ex3->Zeile,ex3->Posit,ex2->Zeile,ex2->Posit,text[182]);
        expr->error = interpreter = 1;
      }
    }
    else
    { expr->error = interpreter = 1; }
  }
  else
  { VARNODE * hbsvar, * hbvvar;
    ex1 = expr->factors.binop.expr1;
    ex2 = expr->factors.binop.expr2;
    if ((mode == 0) && (interpreter == 0) &&
        ((expr->factors.binop.operator->Art == _AND) ||
         (expr->factors.binop.operator->Art == _OR)))
    { GET_MEM(hbsvar,1,VARNODE);
      hbsvar->lk = VARi;
      VARi = hbsvar;
      hbsvar->firstelem = BOOLEAN;
      hbsvar->free = 1;
      hbsvar->dir_indir = DIRECT;
      hbsvar->ein = get_hvar(typ_bool,hbsvar->scavec = 0);
      GET_MEM(hbvvar,1,VARNODE);
      hbvvar->lk = VARi;
      VARi = hbvvar;
      hbvvar->firstelem = BOOLEAN;
      hbvvar->free = 1;
      hbvvar->dir_indir = DIRECT;
      hbvvar->ein = get_hvar(typ_bool,hbvvar->scavec = 1);
    }
    else
      hbsvar = hbvvar = NULL;
    expr_auswerten(ex1,mode);
    if (hbsvar || hbvvar)
      free_hvar(ex1->hv);
    expr_auswerten(ex2,mode);
    interpreter |= expr->error = ex1->error | ex2->error;
    expr->scavec = ex1->scavec | ex2->scavec;
    if ((expr->erg_typ = typ_berechnung(expr->factors.binop.operator->Art,
                                        ex1->erg_typ, ex2->erg_typ)) != typ_error)
    { if (((ex1->erg_art == ERG_CONST) && (ex1->erg.Const->Art != ST_CTYPDESC)) &&
          ((ex2->erg_art == ERG_CONST) && (ex2->erg.Const->Art != ST_CTYPDESC)))
      { expr->erg_art = ERG_CONST;
        LINE1 = ex1->Zeile;
        COL1 = ex1->Posit;
        LINE2 = ex2->Zeile;
        COL2 = ex2->Posit;
        expr->erg.Const = eval_binexpr(expr->factors.binop.operator->Art,
                                       ex1->erg.Const,ex2->erg.Const);
        if (hbsvar || hbvvar)
        { no_count(hbsvar,0); 
          no_count(hbvvar,1);
        }
      }
      else
      { if ((ex1->erg_art == ERG_CONST) && (ex2->erg_art == ERG_CONST))
        { if (ex1->erg.Const->Art == ST_CTYPDESC)
          { mache_Constexpr(ex1,typ_int,1); }
          else
          { mache_Constexpr(ex2,typ_int,1); }
        }
        if (interpreter == 0)
        { VARNODE * hbvar;
          if (expr->scavec)
          { hbvar = hbvvar;
            no_count(hbsvar,0);
          }
          else  
          { hbvar = hbsvar;
            no_count(hbvvar,1);
          }
          if (hbvar)
            and_or_expr(expr,hbvar);
          else
            expr_binop(expr);
        }
        expr->erg_art = ERG_VAR;
      }
    }
    else
    { if (expr->error == 0)
      { SEMERROR(ex1->Zeile,ex1->Posit,ex2->Zeile,ex2->Posit,text[182]);
        interpreter = expr->error = 1;
      }
    }
  }
}

desig_expr(expr,desig,mode)
T_EXPR * expr;
int desig, mode;
{ T_DESIGNREST * d;
  Eintrag * eintr;
  VARNODE * var;
  ZWCODE * zw;
  ST_TYPE * t;

  eintr = suche_Eintrag(expr->factors.designator.ident->wert.ident_nr,vector_ST,GLOBAL,akt_timestamp);
  if (eintr != NULL)
  { switch (eintr->Art & ~N_VAR)
    { case N_PROCEDURE :
        if (desig == 1)
        { if (eintr->param.proz.result != NULL)
          { SEMERROR(expr->Zeile,expr->Posit,0,0,text[183]);
          }
          else
          { SEMERROR(expr->Zeile,expr->Posit,0,0,text[184]);
          }
          interpreter = expr->error = 1;
          expr->erg_typ = typ_error;
          expr->erg_art = ERG_VAR;
        }
        else
        { SEMERROR(expr->Zeile,expr->Posit,0,0,text[185]);
          interpreter = expr->error = 1;
          expr->erg_typ = typ_error;
          expr->erg_art = ERG_VAR;
        }
        break;
      case N_CONSTANT :         
        if (eintr->gueltig == 1)
        { t = eintr->param.Const->type;
          if  (desig == 1)
          { if ((t->Art == ST_TRECORD) ||
                ((d = expr->factors.designator.selector) == NULL))
            { ST_TYPE * erg;
              if (mode && (expr->factors.designator.selector != NULL))
              { SEMERROR(expr->Zeile,expr->Posit,0,0,text[186]);
                interpreter = expr->error = 1;
              }
              expr->erg_art = ERG_CONST;
              expr->erg.Const = hole_Constkomp(eintr->param.Const,t,
                                               expr->factors.designator.selector,
                                               &erg);
              expr->erg_typ = erg;
            }
            else
            { while (d->link)
                d = d->link;
              SEMERROR(d->Zeile,d->Posit,0,0,text[186]);
              interpreter = expr->error = 1;
            }
          }
          else
          { SEMERROR(expr->Zeile,expr->Posit,0,0,text[187]);
            interpreter = expr->error = 1;
          }
        }
        else
        { SEMERROR(expr->Zeile,expr->Posit,eintr->Zeile,eintr->Posit,text[188]);
          expr->erg_typ = NULL;
          interpreter = expr->error = 1;
        }
        if (interpreter == 0)
        { if (expr->hv != NULL)
          { switch (t->Art)
            { case ST_TINT :
              case ST_TCHAR :
              case ST_TBOOL :
              case ST_TREAL :
              case ST_TRANGE :
              case ST_TSUBRANGE :
              case ST_TNIL :
                GET_MEM(zw,1,ZWCODE);
                zw->art = CO_CONSTASS;
                zw->com.Constass.erg = expr->hv;
                zw->com.Constass.charst = 0;
                zw->com.Constass.wert = expr->erg.Const;
                expr->code = zw;
                expr->zeilen += 1;
                break;
              case ST_TSARRAY :
                break;
              case ST_TARRAY :
                break;
              case ST_TSET :
                break;
              case ST_TRECORD :
                break;
            }
          }
        }
        break;
      case N_VECTOR :
        if (member_of_conf == 0)
          if (vector_Ebene == eintr->param.var.ebene)
            member_of_conf = actual_group_nr;
        info_proc |= 16;
        expr->scavec = 1;
        if (eintr->gueltig && (eintr == &spez_eintr))
        { SEMERROR(expr->Zeile,expr->Posit,eintr->Zeile,eintr->Posit,
                   text[116]);
          expr->error = interpreter = 1;
        }
      case N_SCALAR :
        eintr->param.var.used = 1;
        if (expr->erg_typ = t = eintr->param.var.type)
        { switch (t->Art)
          { case ST_TINT :
            case ST_TCHAR :
            case ST_TBOOL :
            case ST_TREAL :
            case ST_TSUBRANGE :
            case ST_TRANGE :
            case ST_TSET :
              if ((d = expr->factors.designator.selector) == NULL)
              { expr->erg_art = ERG_SPEC;
                expr->erg.eintr = eintr;
                eintr->param.var.used = 1;
                GET_MEM(var,1,VARNODE);
                var->lk = VARi;
                VARi = var;
                var->ein = eintr;
                var->firstelem = eintr->param.var.type->firstelem;
                var->scavec = expr->scavec;
                var->dir_indir = DIRECT;
                if (expr->hv != NULL)
                { switch (t->Art)
                  { case ST_TINT :
                    case ST_TCHAR :
                    case ST_TBOOL :
                    case ST_TREAL :
                    case ST_TRANGE :
                    case ST_TSUBRANGE :
                    case ST_TID_NO :
                    case ST_TDIM :
                      GET_MEM(zw,1,ZWCODE);
                      zw->art = CO_ASSIGN;
                      zw->com.assign.erg = expr->hv;
                      zw->com.assign.wert = var;
                      expr->code = zw;
                      expr->zeilen += 1;
                      break;
                    case ST_TSARRAY :
                    case ST_TARRAY :
                    case ST_TSET :
                    case ST_TRECORD :
                      GET_MEM(zw,1,ZWCODE);
                      zw->art = CO_BLOCKASS;
                      zw->com.blockass.erg = expr->hv;
                      zw->com.blockass.wert = var;
                      zw->com.blockass.typ = t;
                      expr->code = zw;
                      expr->zeilen += 1;
                      break;
                  }
                  expr->hv->link = var;
                }
                else
                { expr->hv = var; }
              }
              else
              { while (d->link)
                  d = d->link;
                SEMERROR(d->Zeile,d->Posit,0,0,text[186]);
                interpreter = expr->error = 1;
              }
              break;
            case ST_TDIM :
            case ST_TID_NO :
              info_proc |= 16;
              if (desig == 1)
              { if ((d = expr->factors.designator.selector) == NULL)
                { expr->erg_art = ERG_VAR;
                  expr->scavec = 1;
                  expr->erg.eintr = eintr;
                  eintr->param.var.used = 1;
                  GET_MEM(var,1,VARNODE);
                  var->lk = VARi;
                  VARi = var;
                  var->ein = eintr;
                  var->firstelem = INTEGER;
                  var->scavec = 1;
                  var->dir_indir = DIRECT;
                  if (expr->hv != NULL)
                  { GET_MEM(zw,1,ZWCODE);
                    zw->art = CO_ASSIGN;
                    zw->com.assign.erg = expr->hv;
                    zw->com.assign.wert = var;
                    expr->code = zw;
                    expr->zeilen += 1;
                    expr->hv->link = var;
                  }
                  else
                  { expr->hv = var; }
                }
                else
                { while (d->link)
                    d = d->link;
                  SEMERROR(d->Zeile,d->Posit,0,0,text[186]);
                  interpreter = expr->error = 1;
                }
              }
              else
              { SEMERROR(expr->Zeile,expr->Posit,0,0,text[187]);
                interpreter = expr->error = 1;
              }
              break;
            case ST_TARRAY :
            case ST_TRECORD :
            case ST_TPOINTER :
              expr->erg_art = ERG_SPEC;
              if (expr->factors.designator.selector == NULL)
              { expr->erg.eintr = eintr;
                eintr->param.var.used = 1;
                GET_MEM(var,1,VARNODE);
                var->lk = VARi;
                VARi = var;
                var->ein = eintr;
                var->firstelem = eintr->param.var.type->firstelem;
                var->scavec = expr->scavec;
                var->dir_indir = DIRECT;
                if (expr->hv != NULL)
                { if (t->Art == ST_TPOINTER)
                  { GET_MEM(zw,1,ZWCODE);
                    zw->art = CO_ASSIGN;
                    zw->com.assign.erg = expr->hv;
                    zw->com.assign.wert = var;
                    expr->code = zw;
                    expr->zeilen += 1;
                    expr->hv->link = var;
                  }
                  else
                  { GET_MEM(zw,1,ZWCODE);
                    zw->art = CO_BLOCKASS;
                    zw->com.blockass.erg = expr->hv;
                    zw->com.blockass.wert = var;
                    zw->com.blockass.typ = t;
                    expr->code = zw;
                    expr->zeilen += 1;
                    expr->hv->link = var;
                  }
                }
                else
                { expr->hv = var; }
              }
              else
              { AR_COMP * ar = NULL;
                expr->erg_typ = designrest(expr->factors.designator.selector,t,
                                         expr->scavec, &ar,eintr->param.var.dir_indir);
                if (expr->erg_typ == typ_error)
                  interpreter = expr->error = 1;
                if (interpreter == 0)
                { AR_COMP * har;
                  ZWCODE * zw;
                  VARNODE * var;
                  int scavec = 0;
                  int neu = 0;
                  har = ar;
                  GET_MEM(zw,1,ZWCODE);
                  zw->art = CO_ZUGRIFF;
                  GET_MEM(var,1,VARNODE);
                  var->free = 0;
                  var->dir_indir = DIRECT;
                  var->firstelem = expr->erg_typ->firstelem;
                  var->ein = eintr;
/*                  if (eintr->Art & N_VAR)*/
                    scavec = expr->scavec;
                  var->scavec = expr->scavec;
                  zw->com.zugriff.comp = ar;
                  zw = pointer_filter(expr,zw,har,&scavec,&neu);
                  zw->com.zugriff.basis = var;
                  if (neu)
                  { GET_MEM(var,1,VARNODE);
                    var->lk = VARi;
                    VARi = var;
                    var->free = 1;
                    var->dir_indir = INDIRECT;
                    var->firstelem = expr->erg_typ->firstelem;
                    var->ein = get_hvar(typ_int,scavec);
                    var->scavec = expr->scavec;
                    zw->com.zugriff.var = var;
                    expr->zeilen += zw->com.zugriff.pos + zw->com.zugriff.neg + 
                                    zw->com.zugriff.arr;
                    har = ar;
                    while (har != NULL)
                    { if ((har->art == 0) && (har->ar.array.erg != NULL))
                      { VARNODE * var1;
                        free_hvar(har->ar.array.erg);
                        GET_MEM(var1,1,VARNODE);
                        var1->lk = VARi;
                        VARi = var1;
                        var1->free = 1;
                        var1->dir_indir = DIRECT;
                        var1->firstelem = INTEGER;
                        var1->ein = get_hvar(typ_int,var1->scavec = scavec);
                        har->ar.array.var = var1;
                        free_hvar(var1);
                        expr->zeilen++;
                        har = har->link;
                      }
                      else
                      { if (har->art == 2)
                        { AR_COMP * har1 = har->link;
                          har->ar.pointer.erg = var;
                          har->ar.pointer.rest->com.zugriff.var = var;
                          har->ar.pointer.rest->com.zugriff.basis = var;
                          if (nil_pointertest)
                          { pointer_check = 1;
                            expr->zeilen += 2;
                          }
                          else
                            expr->zeilen++;
                          har = har1;
                        }
                        else
                          har = har->link;
                      }
                    }
                  }
                  expr->code = zw;
                  if (expr->hv != NULL)
                  { zw->com.zugriff.erg = expr->hv;
                    free_hvar(var);
                    switch (expr->erg_typ->Art)
                    { case ST_TINT :
                      case ST_TCHAR :
                      case ST_TBOOL :
                      case ST_TREAL :
                      case ST_TRANGE :
                      case ST_TSUBRANGE :
                      case ST_TID_NO :
                      case ST_TDIM :
                      case ST_TPOINTER :
                        GET_MEM(zw,1,ZWCODE);
                        zw->art = CO_ASSIGN;
                        zw->com.assign.erg = expr->hv;
                        zw->com.assign.wert = var;
                        zw->com.assign.ex1 = expr->code;
                        expr->code = zw;
                        expr->zeilen += 1;
                        break;
                      case ST_TSARRAY :
                      case ST_TARRAY :
                      case ST_TSET :
                      case ST_TRECORD :
                        GET_MEM(zw,1,ZWCODE);
                        zw->art = CO_BLOCKASS;
                        zw->com.blockass.erg = expr->hv;
                        zw->com.blockass.wert = var;
                        zw->com.blockass.typ = expr->erg_typ;
                        zw->com.blockass.ex1 = expr->code;
                        expr->code = zw;
                        expr->zeilen += 1;
                        break;
                    }
                    expr->hv->link = var;
                  }
                  else
                  { expr->hv = var; }
                }
              }
              break;
            default :
              SEMERROR(expr->factors.designator.ident->Zeile,
                       expr->factors.designator.ident->Posit,
                       eintr->Zeile, eintr->Posit,text[189]);
              interpreter = expr->error = 1;
              break;
          }
        }
        else
        { SEMERROR(expr->factors.designator.ident->Zeile,
                   expr->factors.designator.ident->Posit,
                   eintr->Zeile, eintr->Posit,text[244]);
          interpreter = expr->error = 1;
        }
        break;
      case N_TEMP :
        if ((d = expr->factors.designator.selector) == NULL)
        { if (mode)
          { expr->erg_art = ERG_CONST;
            expr->erg.Const = eintr->param.Const;
            expr->erg_typ = typ_int;
          }
          else
          { expr->erg_art = ERG_VAR;
            expr->scavec = 1;
            expr->erg.eintr = eintr->link;
            GET_MEM(var,1,VARNODE);
            var->lk = VARi;
            VARi = var;
            var->ein = eintr->link;
            var->firstelem = INTEGER;
            var->scavec = 1;
            var->dir_indir = DIRECT;
            if (expr->hv != NULL)
            { GET_MEM(zw,1,ZWCODE);
              zw->art = CO_ASSIGN;
              zw->com.assign.erg = expr->hv;
              zw->com.assign.wert = var;
              expr->code = zw;
              expr->zeilen += 1;
              expr->hv->link = var;
            }
            else
            { expr->hv = var; }
          }
        }
        else
        { while (d->link)
            d = d->link;
          SEMERROR(d->Zeile,d->Posit,0,0,text[186]);
          interpreter = expr->error = 1;
        }
        break;
      case N_SPEZIAL_VEK :
        info_proc |= 16;
        expr->erg_art = ERG_VAR;
        expr->erg_typ = eintr->param.var.type;
        expr->erg.eintr = eintr;
        expr->scavec = 1;
        expr->readonly = 1;
        eintr->param.var.used = 1;
        { VARNODE * var;
          GET_MEM(var,1,VARNODE);
          var->lk = VARi;
          VARi = var;
          var->ein = eintr;
          if (expr->hv != NULL)
          { GET_MEM(zw,1,ZWCODE);
            zw->art = CO_ASSIGN;
            zw->com.assign.erg = expr->hv;
            zw->com.assign.wert = var;
            expr->code = zw;
            expr->zeilen += 1;
            expr->hv->link = var;
          }
          else
          { expr->hv = var; }
          if (!eintr->gueltig)
          { SEMERROR(expr->Zeile,expr->Posit,0,0,text[169]);
            interpreter = expr->error = 1;
            expr->erg_typ = typ_error;
          }
        }               
        break;
      case N_SPEZIAL_SKA :
        expr->erg_art = ERG_VAR;
        expr->erg_typ = eintr->param.var.type;
        expr->scavec = 0;
        expr->readonly = 1;
        { VARNODE * var;
          GET_MEM(var,1,VARNODE);
          var->lk = VARi;
          VARi = var;
          var->ein = eintr;
          if (expr->hv != NULL)
          { GET_MEM(zw,1,ZWCODE);
            zw->art = CO_ASSIGN;
            zw->com.assign.erg = expr->hv;
            zw->com.assign.wert = var;
            expr->code = zw;
            expr->zeilen += 1;
            expr->hv->link = var;
          }
          else
          { expr->hv = var; }
        }               
        break;
      case N_TYPE :
        if ((d = expr->factors.designator.selector) == NULL)
        { if (eintr->gueltig == 1)
          { expr->erg_art = ERG_TYPE;
            expr->erg.eintr = eintr;
            expr->erg_typ = typ_error;
          }
          else
          { SEMERROR(expr->factors.designator.ident->Zeile,
                     expr->factors.designator.ident->Posit,
                     eintr->Zeile, eintr->Posit,text[191]);
            interpreter = expr->error = 1;
          }
        }
        else
        { while (d->link)
            d = d->link;
          SEMERROR(d->Zeile,d->Posit,0,0,text[186]);
          interpreter = expr->error = 1;
        }
        break;
      case N_IO :
      case N_INPUT :
      case N_OUTPUT :
        if ((eintr->gueltig == 0) && (eintr == &spez_eintr))
        { SEMERROR(expr->Zeile,expr->Posit,eintr->Zeile,eintr->Posit,
                   text[116]);
          expr->error = interpreter = 1;
        }
        info_proc |= 16;
        expr->erg_art = ERG_PORT;
        portanalyse(eintr,expr,NULL);
        break;
      default :
        SEMERROR(expr->factors.designator.ident->Zeile,
                 expr->factors.designator.ident->Posit,
                 eintr->Zeile, eintr->Posit,text[190]);
        interpreter = expr->error = 1;
        break;
    }
  }
  else
  { SEMERROR(expr->factors.designator.ident->Zeile,
             expr->factors.designator.ident->Posit,0,0,text[173]);
    interpreter = expr->error = 1;
    expr->erg_art = ERG_VAR;
  }
}



klexpr_expr(expr,mode)
T_EXPR * expr;
int mode;
{ T_EXPR * ex;

  ex = expr->factors.klexpr;
  ex->hv = expr->hv;
  expr_auswerten(ex,mode);
  expr->erg_typ = ex->erg_typ;
  expr->erg_art = ex->erg_art;
  expr->scavec = ex->scavec;
  expr->erg = ex->erg;
  expr->error = ex->error;
  expr->hv = ex->hv;
  expr->zeilen = ex->zeilen;
  expr->code = ex->code;
}


#ifndef PC
/* open file */

notexpr_expr(expr,mode)
T_EXPR * expr;
int mode;
{ T_EXPR * ex = expr->factors.notexpr;

  /*ex->hv = expr->hv;*/
  expr_auswerten(ex,mode);
  if ((expr->error = ex->error) == 0)
  { switch(ex->erg_art)
    { case ERG_CONST :
        if (ex->erg.Const->Art == ST_CBOOL)
        { ST_CONST * c1;
          int h;
          h = ex->erg.Const->wert.range.val;
          GET_MEM(c1,1,ST_CONST);
          expr->erg_typ = typ_bool;
          expr->erg.Const = c1;
          c1->wert.range.val = (h == 1) ? 0 : 1;
          expr->erg_art = ERG_CONST;
          c1->wert.range.von = 0;
          c1->wert.range.bis = 1;
          c1->type = typ_bool;
          c1->gueltig = 1;
          c1->Art = ST_CBOOL;
        }
        else
        { if (expr->error == 0)
          { SEMERROR(ex->Zeile,ex->Posit,0,0,text[181]);
            interpreter = expr->error = 1;
          }
        }
        break;
      case ERG_VAR :
      case ERG_SPEC :
        if (match_typen(typ_bool,ex->erg_typ,1) == JA)
        { expr->erg_art = ERG_VAR;
          expr->erg_typ = typ_bool;
          expr->scavec = ex->scavec;
          if (expr->error == 0)
            expr_not(expr);
        }
        else
        { SEMERROR(ex->Zeile,ex->Posit,0,0,text[181]);
          interpreter = expr->error = 1;
        }
        break;
      case ERG_PROC :
      case ERG_RAND :
        if (match_typen(typ_bool,ex->erg_typ,1) == JA)
        { mache_Constexpr(ex,typ_bool,0);
          expr->scavec = ex->scavec;
          expr->erg_typ = typ_bool;
          if (expr->error == 0)
            expr_not(expr);
        }
        else
        { SEMERROR(ex->Zeile,ex->Posit,0,0,text[181]);
          interpreter = expr->error = 1;
        }
        break;
      case ERG_REC :
      case ERG_TYPE :
      case ERG_PORT :
        if (ex->error == 0)
          SEMERROR(ex->Zeile,ex->Posit,0,0,text[181]);
        interpreter = expr->error = 1;
        break;
      default :
        bug("2 expr_auswerten E_NOTEXPR");
        break;
    }
  }
}



const_expr(expr,mode)
T_EXPR * expr;
int mode;
{ ST_CONST * c;
  SCAN_ELEM * se;

  GET_MEM(c,1,ST_CONST);
  expr->erg.Const = c;
  expr->erg_art = ERG_CONST;
  c->gueltig = 1;
  switch((se = expr->factors.Const)->Art)
  { case INTCONSTANT :
      c->Art = ST_CINT;
      c->wert.i = se->wert.i;
      expr->erg_typ = c->type = typ_int;
      break;
    case REALCONSTANT :
      c->Art = ST_CREAL;
      c->wert.r = se->wert.r;
      expr->erg_typ = c->type = typ_real;
      break;
    case CHARCONSTANT :
      { unsigned char * hi;
        GET_MEM(hi,2,unsigned char);
        c->Art = ST_CSTRING;
        c->wert.s.string = hi;
        * hi = se->wert.c;
        c->wert.s.len = 1;
        expr->erg_typ = c->type = typ_string;
      }
      break;
    case STRINGCONSTANT :
      { ST_TYPE * t;
        c->Art = ST_CSTRING;
        c->wert.s.string = (unsigned char *) se->wert.s;
        c->wert.s.len = my_strlen(se->wert.s);
        GET_MEM(t,1,ST_TYPE);
        if (mode)
        { t->liste = typen_liste;
          typen_liste = t;
        }
        (expr->erg_typ = c->type = t)->gueltig = 1;
        t->firstelem = CHAR;
        t->Art = ST_TSARRAY;
        t->used[CHAR] = t->used[ALL] = c->wert.s.len + 1;
        t->info.array.typ =typ_char;
        GET_MEM(t,1,ST_TYPE);
        if (mode)
        { t->liste = typen_liste;
          typen_liste = t;
        }
        c->type->info.array.bereich = t;
        t->gueltig = 1;
        t->Art = ST_TSUBRANGE;
        t->info.range.super = typ_int;
        t->info.range.von = t->info.range.basis = 0;
        t->info.range.bis = c->wert.s.len;
      }
      break;
    default :
      interpreter = expr->error = 1;
      c->gueltig = 0;
      break;
  }
}



sinop_expr(expr,mode)
T_EXPR * expr;
int mode;
{ T_EXPR * ex;
  ST_TYPE * t;

  ex = expr->factors.binop.expr2;
  if (expr->factors.binop.operator->Art == '+')
    ex->hv = expr->hv;
  expr_auswerten(ex = expr->factors.binop.expr2,mode);
  expr->error = ex->error;
  expr->scavec = ex->scavec;
  if ((match_typen(typ_real,
                   (t = typ_berechnung('+',typ_real, ex->erg_typ)),0) == JA) ||
      (match_typen(typ_int,
                   (t = typ_berechnung('+',typ_int, ex->erg_typ)),0) == JA))
  { expr->erg_typ = t;
    switch (expr->factors.binop.operator->Art)
    { case '+' : 
        switch (expr->erg_art = ex->erg_art)
        { case ERG_CONST :
            expr->erg.Const = ex->erg.Const;
            expr->erg_typ = ex->erg_typ;
            break;
          default :
            expr->hv = ex->hv;
            expr->erg_typ = ex->erg_typ;
            expr->erg.eintr = ex->erg.eintr;
            expr->zeilen = ex->zeilen;
	    expr->code = ex->code;
            break; 
        }
        expr->scavec = ex->scavec;
        break;
      case '-' :
        switch (expr->erg_art = ex->erg_art)
        { case ERG_CONST :
            { ST_CONST * c, * c1;
              GET_MEM(c,1,ST_CONST);
              c->gueltig = 1;
              switch(c->Art = (c1 = ex->erg.Const)->Art)
              { case ST_CINT :
                  c->wert.i = - c1->wert.i;
                  break;
                case ST_CPI :
                  c->Art = ST_CREAL;
                case ST_CREAL :
                  c->wert.r = - c1->wert.r;
                  break;
                case ST_CTYPDESC :
                  if (expr->error == 0)
                  { mache_Constexpr(ex,typ_int,1);
                    expr_negation(expr);
                  }
                  expr->erg_art = ERG_VAR;
                  expr->erg_typ = ex->erg_typ;
                  expr->erg.eintr = ex->erg.eintr;
                  return;
                default :
                  c->gueltig = 0;
                  break;
              }
              c->type = c1->type;
              expr->erg.Const = c;
              expr->erg_typ = ex->erg_typ;
            }
            break;
          default :
            if (expr->error == 0)
              expr_negation(expr);
            expr->erg_typ = ex->erg_typ;
            expr->erg.eintr = ex->erg.eintr;
            break; 
        }
        expr->scavec = ex->scavec;
        break;
      default :
        bug("expr_auswerten E_SINOP");
        break;
    }
  }
  else
  { if (ex->error == 0)
    { SEMERROR(ex->Zeile,ex->Posit,0,0,text[192]);
      interpreter = expr->error = 1;
    }
  }
}



func_expr(expr,mode)
T_EXPR * expr;
int mode;
{ T_EXPR * exlist = expr->factors.funccall.exprlist;
  SCAN_ELEM * sc;
  Eintrag * eintr;

  eintr = suche_Eintrag((sc = expr->factors.funccall.funcident)->wert.ident_nr,vector_ST,
                        GLOBAL,akt_timestamp);
  if (eintr != NULL)
  { int art = eintr->Art;
    if (((art == N_STDFUNC) ||
         ((art == N_PROCEDURE) && (eintr->param.proz.result != NULL)) ||
         ((art == N_TYPE) && (eintr->param.type != NULL)) ||
         (art == N_IOK) || (art == N_INPUTK) || (art == N_OUTPUTK)) &&     
        (eintr->gueltig != 0))
    { if ((art == N_PROCEDURE) || (art == N_STDFUNC))
      { int inter = interpreter;
        expr->erg_art = ERG_VAR;
        if ((art == N_STDFUNC) && (eintr->param.proz.posnr == PROC_SIZE))
          interpreter = 1;
        exprlist_auswerten(exlist,mode);
        if (!yynerrs)
          interpreter = inter;
        /* Parameter- und Ergebnistypen vergeichen */
        if (eintr->Art == N_STDFUNC)
        { Standardfunktionen(eintr->param.proz.posnr,expr, exlist); }
        else
        { if ((eintr->param.proz.parall & (PI_SCALAR | PI_SELECT)) &&
              ((proc_info & PI_VECTOR) != 0))
          { SEMERROR(sc->Zeile,sc->Posit,eintr->Zeile,eintr->Posit,text[193]);
            expr->error = interpreter = 1;
          }
          else
          { if ((eintr->param.proz.parall & PI_VECTOR) &&
                (proc_info & (PI_SCALAR | PI_SELECT)))
            { SEMERROR(sc->Zeile,sc->Posit,eintr->Zeile,eintr->Posit,text[194]);
              expr->error = interpreter = 1;
            }
            else
            { proc_info |= eintr->param.proz.parall; }
          }
          if (((exlist != NULL) || (eintr->param.proz.param != NULL)) &&
              (teste_parameter(eintr->param.proz.param,exlist,
                               expr->Zeile, expr->Posit) != JA))
          { interpreter = expr->error = 1; }
          else
          { ZWCODE * zw, * zw1, * zw2;
            T_EXPR * e = exlist;
            procedure_benutzen(eintr,expr->Zeile,expr->Posit,proc_info);
            expr->zeilen = 2;
            GET_MEM(zw,1,ZWCODE);
            zw->art = CO_FUNCCALL;
            zw->com.funccall.proc = eintr;
            zw->com.funccall.nach = nach_pruefung;
            zw->com.funccall.complex = eintr->param.proz.complex;
            zw1 = zw2 = NULL;
            while (exlist != NULL)
            { zw2 = zw1;
              GET_MEM(zw1,1,ZWCODE);
              if (exlist->erg_art == ERG_CONST)
              { zw1->art = CO_PARAMCO;
                zw1->com.param.Const = exlist->erg.Const;
              }
              else
              { zw1->art = CO_PARAM;
                if (exlist->scavec == 2)
                { exlist->scavec = 1;
                  if (ist_einfacher_typ(exlist->erg_typ) != JA)
                  { zw1->com.param.tpar = exlist->hv;
                    free_hvar(exlist->hv);
                    exlist->hv = NULL;
                    zw1->com.param.par = neue_hv(exlist);
                    zw1->com.param.ttyp = exlist->erg_typ;
                    free_hvar(exlist->hv);
                    exlist->zeilen++;
                  }
                  else
                  { zw1->com.param.tpar = NULL;
                    zw1->com.param.par = exlist->hv;
                  }
                }
                else
                { zw1->com.param.tpar = NULL;
                  zw1->com.param.par = exlist->hv;
                }
                zw1->com.param.scavec = exlist->scavec;
                zw1->com.param.code = exlist->code;
                zw1->com.param.mode = exlist->erg_art;
                if ((exlist->erg_art == ERG_SPEC) ||
                    (ist_einfacher_typ(exlist->erg_typ) != JA))
                { zw1->com.param.mode = ERG_SPEC; }
              }
              zw1->com.param.scavec = exlist->scavec;
              expr->zeilen += 1 + exlist->zeilen;
              zw1->link = zw2;
              exlist = exlist->link;
            }
            while (e)
            { free_hvar(e->hv);
              e = e->link;
            }
            zw->com.funccall.param = zw1;
            zw->com.funccall.scavec = eintr->param.proz.scavec;
            expr->code = zw;
          }
          nach_pruefung = NULL;
          expr->erg_art = ERG_PROC;
          expr->erg_typ = eintr->param.proz.result;
          expr->scavec = eintr->param.proz.scavec;
        }                  
        eintr->param.proz.used = 1;
      }
      else
      { if (art == N_TYPE)
        { ST_TYPE * t;
          T_EXPR * ex, *ex1;
          ST_CONST * c, * c1;
          int sv, Constant_record = NEIN;
          sv = 0;
          switch ((expr->erg_typ = t = eintr->param.type)->Art)
          { case ST_TRECORD :
              exprlist_auswerten(ex1 = ex = exlist,mode);
              c = NULL;
              while ((ex != NULL) && (ex->erg_art == ERG_CONST) &&
                     (ex->erg.Const != NULL))
              { if (ex->erg.Const->link || ex->erg.Const->name)
                { ST_CONST * c;
                  GET_MEM(c,1,ST_CONST);
                  *c = *(ex->erg.Const);
                  ex->erg.Const = c;
                }
                ex->erg.Const->link = c;
                c = ex->erg.Const;
                ex = ex->link;
              }
              while (ex1 != NULL)
              { sv = sv | ex1->scavec;
                ex1 = ex1->link;
              }
              expr->scavec = sv;
              expr->erg_art = ERG_REC;
              if ((ex == NULL) || (ex->erg_art == ERG_CONST))
              { GET_MEM(c1,1,ST_CONST);
                c1->Art = ST_CREC;
                c1->type = t;
                c1->wert.recConst = c;
                c1->gueltig = (c) ? c->gueltig : 0;
                expr->erg.Const = c1;
                expr->erg_art = ERG_CONST;
                Constant_record = JA;
              }
              if (teste_record(t,expr->factors.funccall.exprlist,
                               expr->Zeile,expr->Posit,Constant_record) != JA) 
              { interpreter = expr->error = 1; }
              else
              { if (mode == 0)
                  mache_Constexpr(expr,t,0);
              }
              break;
            case ST_TINT :
            case ST_TSUBRANGE :
              if ((eintr == integer_eintr) || (eintr == cardinal_eintr))
              { T_EXPR * ex;
                if ((ex = exlist)->count > 1)
                { SEMERROR(expr->Zeile,expr->Posit,0,0,text[275]);
                  expr->error = interpreter = 1;
                  while (ex->link)
                  { ex = ex->link; }
                }
                ex->hv = expr->hv;
                exprlist_auswerten(exlist,mode);
                if (eintr == cardinal_eintr)
                { mache_Constexpr(ex,typ_card,0);
                  expr->erg_typ = typ_card;
                }
                else
                { expr->erg_typ = typ_int; }
		expr->scavec = ex->scavec;
                expr->erg.Const = ex->erg.Const;
                expr->erg_art = ex->erg_art;
                expr->zeilen = ex->zeilen;
                expr->code = ex->code;
                expr->hv = ex->hv;
                if (match_typen(typ_int,ex->erg_typ,0) == JA)
                { expr->error = ex->error; }
                else
                { if (ex->error == 0)
                  { SEMERROR(ex->Zeile, ex->Posit,0,0,text[195]);
                  }
                  interpreter = expr->error = 1;
                }
              }
              else
              { SEMERROR(expr->Zeile,expr->Posit,eintr->Zeile,eintr->Posit,text[196]);
                interpreter = expr->error = 1;
                expr->erg_art = ERG_VAR;
                expr->erg_typ = typ_error;
              }
              break;
            case ST_TARRAY :
              { ST_TYPE * type = t->info.array.typ;
                T_EXPR * ex, *ex1;
                int sv = 0;
                int con = 1;
                int anz = elementezahl(t->info.array.bereich) + 1;
                while (type && (type->Art == ST_TARRAY) && (type->info.array.top == 0))
                { anz *= (elementezahl(type->info.array.bereich) + 1);
                  type = type->info.array.typ;
                }
                exprlist_auswerten(ex1 = ex = exlist,mode);
                array_elemente_test(expr,exlist,type);
                if ((exlist == 0) || (exlist->count < anz))
                { SEMERROR(expr->Zeile,expr->Posit,0,0,text[207]);
                  expr->error = interpreter = 1;
                }
                if (exlist && (exlist->count > anz))
                { SEMERROR(expr->Zeile,expr->Posit,0,0,text[208]);
                  expr->error = interpreter = 1;
                }
                while (ex1)
                { sv |= ex1->scavec;
                  con *= (ex1->erg_art == ERG_CONST) ? 1 : 0;
                  ex1 = ex1->link;
                }
                expr->erg_typ = t;
                if (con)
                { ST_CONST * c = NULL;
                  while (ex && (ex->erg.Const != NULL))
                  { if (ex->erg.Const->link)
                    { ST_CONST * c;
                      GET_MEM(c,1,ST_CONST);
                      *c = *(ex->erg.Const);
                      ex->erg.Const = c;
                    }
                    ex->erg.Const->link = c;
                    c = ex->erg.Const;
                    ex = ex->link;
                  }
                  GET_MEM(c1,1,ST_CONST);
                  c1->Art = ST_CREC;
                  c1->type = t;
                  c1->wert.recConst = c;
                  c1->gueltig = (c) ? c->gueltig : 0;
                  expr->erg.Const = c1;
                  expr->erg_art = ERG_CONST;
                  expr->scavec = 0;
                }
                else
                { expr->scavec = sv;
                  expr->erg_art = ERG_REC;
                }
                if ((mode == 0) && (interpreter == 0))
                  mache_Constexpr(expr,t,0);
              }
              break;
            default :
              SEMERROR(expr->Zeile,expr->Posit,eintr->Zeile, eintr->Posit,text[196]);
              interpreter = expr->error = 1;
              expr->erg_art = ERG_VAR;
              expr->erg_typ = typ_error;
              break;
          }                   
        }
        else
        { expr->erg_art = ERG_PORT;
          exprlist_auswerten(exlist,0);
          portanalyse(eintr,expr,exlist);
        }
      }
    }
    else
    { if (art == N_PROCEDURE)
      { SEMERROR(expr->Zeile,expr->Posit,eintr->Zeile, eintr->Posit,text[184]);
         interpreter = expr->error = 1;
         expr->erg_art = ERG_VAR;
         expr->erg_typ = typ_error;
      }                   
      else
      { SEMERROR(expr->Zeile,expr->Posit,eintr->Zeile, eintr->Posit,text[197]);
         interpreter = expr->error = 1;
         expr->erg_art = ERG_VAR;
         expr->erg_typ = typ_error;
      }
    }                   
  }
  else
  { SEMERROR(expr->Zeile,expr->Posit,0,0,text[173]);
    interpreter = expr->error = 1;
  }
}


set_expr(expr)
T_EXPR * expr;
{ Eintrag * eintr;
  ST_TYPE * t;

  if (expr->factors.sets.setident != NULL)
  { eintr = suche_Eintrag(expr->factors.sets.setident->wert.ident_nr,vector_ST,
                          GLOBAL,akt_timestamp);
    if (eintr != NULL)
    { if ((eintr->Art == N_TYPE) && (eintr->gueltig == 1) &&
        ((t = eintr->param.type) != NULL) && (t->Art == ST_TSET))
      { besetze_set(expr,expr->factors.sets.elements,expr->erg_typ = t);
      }
      else
      { SEMERROR(eintr->Zeile,eintr->Posit,expr->Zeile,expr->Posit,text[198]);
        interpreter = expr->error = 1;
      }
    }
    else
    { SEMERROR(expr->Zeile,expr->Posit,0,0,text[173]);
      interpreter = expr->error = 1;
    }
  }
  else
  { besetze_set(expr,expr->factors.sets.elements,expr->erg_typ = typ_bitset); }
}



reduce_expr(expr)
T_EXPR * expr;
{ T_EXPR * ex;
  Eintrag * rueck = NULL;
  int spez = 0;
  VARNODE * bool = NULL;
  T_SELECT * sel = NULL;
  C_CONF * co = NULL;
  SCOPE * sco = NULL;
  SCAN_ELEM * sc = expr->factors.reduce.redident;

  /* reduce */
  if (((proc_info & PI_VECTOR) == 0) && (!expr->factors.reduce.select) && novector_st())
  { T_SELECT * s;
    GET_MEM(s,1,T_SELECT);
    expr->factors.reduce.select = s;
    s->art = SE_NONE;
  }
  if (expr->factors.reduce.select)
    proc_info |= PI_VECTOR;
  if (sc->Art == _AND)
  { rueck = suche_Eintrag(min_nr,grund_ST,GLOBAL,akt_timestamp);
    spez = 1;
  }
  if (sc->Art == _OR)
  { rueck = suche_Eintrag(max_nr,grund_ST,GLOBAL,akt_timestamp);
    spez = 1;
  }
  if (rueck == NULL)
    rueck = suche_Eintrag(sc->wert.ident_nr,vector_ST,GLOBAL,akt_timestamp);
  if ((rueck != NULL) && (rueck->Art == N_PROCEDURE))
  { /* parameter berechnen */
    if (((rueck->param.proz.parall & (PI_SCALAR | PI_SELECT | PI_REDUCE)) != 0) || 
        (rueck->gueltig == 0))
    { SEMERROR(sc->Zeile,sc->Posit,rueck->Zeile,rueck->Posit,text[199]);
      expr->error = interpreter = 1;
    }
    else
    { if ((rueck->param.proz.parall & PI_REDUCED) == 0)
      { ST_PARAM *pa = rueck->param.proz.param;
        if ((pa == NULL) || (pa->link != NULL) ||
            (pa->anzahl != 2) || (pa->mode != N_VECTOR) ||
            (pa->type != rueck->param.proz.result) ||
            (rueck->param.proz.scavec == 0))
        { SEMERROR(sc->Zeile,sc->Posit,rueck->Zeile,rueck->Posit,text[199]);
          expr->error = interpreter = 1;
        }
        else                                    
        { rueck->param.proz.parall |= PI_REDUCED;
          rueck->param.proz.info |= 32;
          procedure_benutzen(rueck,sc->Zeile,sc->Posit,proc_info);
        }
      }
    }
    if (sel = expr->factors.reduce.select)
    { if (within_selection)
      { SEMERROR(expr->Zeile,expr->Posit,0,0,text[152]);
        interpreter = 1;
      }
      else
      { if (sel->count)
        { GET_MEM(bool,1,VARNODE);
          bool->lk = VARi;
          VARi = bool;
          bool->free = 1;
          bool->dir_indir = DIRECT;
          bool->firstelem = BOOLEAN;
          bool->ein = get_hvar(typ_bool,bool->scavec = 0);
        }
      }
      analyse_select(sel,expr->Zeile,expr->Posit,&co);
      sco = expr->factors.reduce.scop = sel->scop;
    }
    expr_auswerten(ex = expr->factors.reduce.expr,0);
    if (match_typen(ex->erg_typ,rueck->param.proz.result,0) != JA)
    { if (ex->error == 0)
        SEMERROR(ex->Zeile,ex->Posit,sc->Zeile,sc->Posit,text[200]);
      ex->error = expr->error = interpreter = 1;
    }
    if (ex->erg_art == ERG_CONST)
    { ex->scavec = 1; }
    expr->erg_typ = rueck->param.proz.result;
    mache_Constexpr(ex,rueck->param.proz.result,1);
    free_hvar(ex->hv);
    if (ex->scavec == 0)
    { if (ex->error == 0)
        SEMERROR(ex->Zeile,ex->Posit,0,0,text[201]);
       ex->error = expr->error = interpreter = 1;
    }
  }
  else
  { if ((rueck != NULL) && (rueck->Art == N_STDFUNC))
    { switch (rueck->param.proz.posnr)
      { case PROC_MAX :
        case PROC_MIN :
        case PROC_FIRST :
        case PROC_LAST :
          if (sel = expr->factors.reduce.select)
          { if (within_selection)
            { SEMERROR(expr->Zeile,expr->Posit,0,0,text[152]);
              interpreter = 1;
            }
            else
            { if (sel->count)
              { GET_MEM(bool,1,VARNODE);
                bool->lk = VARi;
                VARi = bool;
                bool->free = 1;
                bool->dir_indir = DIRECT;
                bool->firstelem = BOOLEAN;
                bool->ein = get_hvar(typ_bool,bool->scavec = 0);
              }
            }
            analyse_select(sel,expr->Zeile,expr->Posit,&co);
            sco = expr->factors.reduce.scop = sel->scop;
          }
          expr_auswerten(ex = expr->factors.reduce.expr,0);
          if ((((match_typen(typ_int,ex->erg_typ,0) == JA) ||
                (match_typen(typ_real,ex->erg_typ,0) == JA) ||
                (match_typen(typ_char,ex->erg_typ,0) == JA)) && (spez == 0)) ||
              (match_typen(typ_bool,ex->erg_typ,0) == JA))
          { expr->erg_typ = ex->erg_typ;
            if (ex->erg_art == ERG_CONST)
            { ex->scavec = 1; }
            mache_Constexpr(ex,ex->erg_typ,1);
            free_hvar(ex->hv);
            if (ex->scavec == 0)
            { if (ex->error == 0)
                SEMERROR(ex->Zeile,ex->Posit,0,0,text[201]);
              ex->error = expr->error = interpreter = 1;
            }
          }
          else
          { if (spez)
            { if (ex->error == 0)
                SEMERROR(ex->Zeile,ex->Posit,0,0,text[202]);
            }
            else
              if (ex->error == 0)
                SEMERROR(ex->Zeile,ex->Posit,0,0,text[203]);
            ex->error = expr->error = interpreter = 1;
          }
          break;
        case PROC_SUM :
        case PROC_PRODUCT :
          if (sel = expr->factors.reduce.select)
          { if (within_selection)
            { SEMERROR(expr->Zeile,expr->Posit,0,0,text[152]);
              interpreter = 1;
            }
            else
            { if (sel->count)
              { GET_MEM(bool,1,VARNODE);
                bool->lk = VARi;
                VARi = bool;
                bool->free = 1;
                bool->dir_indir = DIRECT;
                bool->firstelem = BOOLEAN;
                bool->ein = get_hvar(typ_bool,bool->scavec = 0);
              }
            }
            analyse_select(sel,expr->Zeile,expr->Posit,&co);
            sco = expr->factors.reduce.scop = sel->scop;
          }
          expr_auswerten(ex = expr->factors.reduce.expr,0);
          if ((match_typen(typ_int,ex->erg_typ,0) == JA) ||
              (match_typen(typ_real,ex->erg_typ,0) == JA))
          { expr->erg_typ = (match_typen(typ_int,ex->erg_typ,0) == JA) ? typ_int
                                                                     : typ_real;
            if (ex->erg_art == ERG_CONST)
            { ex->scavec = 1; }
            mache_Constexpr(ex,ex->erg_typ,1);
            free_hvar(ex->hv);
            if (ex->scavec == 0)
            { if (ex->error == 0)
                SEMERROR(ex->Zeile,ex->Posit,0,0,text[201]);
              ex->error = expr->error = interpreter = 1;
            }
          }
          else
          { if (ex->error == 0)
              SEMERROR(sc->Zeile,sc->Posit,ex->Zeile,ex->Posit,text[204]);
            ex->error = expr->error = interpreter = 1;
          }
          break;
        default :
          SEMERROR(expr->factors.reduce.redident->Zeile,expr->factors.reduce.redident->Posit,
                   0,0,text[199]);
          interpreter = expr->error = 1;
          break;
      }
    }
    else
    { if (rueck != NULL)
      { SEMERROR(sc->Zeile,sc->Posit,rueck->Zeile,rueck->Posit,text[205]);
      }
      else
      { SEMERROR(sc->Zeile,sc->Posit,0,0,text[173]);
      }
      expr->error = interpreter = 1;
      expr_auswerten(expr->factors.reduce.expr,0);
    }
  }      
  expr->scavec = 0;  
  expr->erg_art = ERG_PROC;
  if (sel)
  { vector_ST->hvarsvect = hvarsvect;
    vector_ST_entfernen();
    vector_ST = akt_ST;
    hvarsvect = vector_ST->hvarsvect;
  }
  if (sco)
  { akt_scope  = sco->super; }
  if (interpreter == 0)
  { ZWCODE * zw;
    GET_MEM(zw,1,ZWCODE);
    zw->art = CO_REDUCE;
    zw->com.reduce.expr = ex->code;
    zw->com.reduce.pna = rueck;
    zw->com.reduce.var = ex->hv;
    if (expr->hv && (expr->hv->scavec || expr->hv->ein->param.var.vektoriell))
    { VARNODE * scal;
      ZWCODE * zw1;
      GET_MEM(scal,1,VARNODE);
      scal->lk = VARi;
      VARi = scal;
      scal->free = 1;
      scal->dir_indir = DIRECT;
      scal->firstelem = expr->hv->firstelem;
      scal->ein = get_hvar(expr->erg_typ,scal->scavec = 0);
      GET_MEM(zw1,1,ZWCODE);
      zw->link = zw1;
      expr->zeilen++;
      zw1->art = CO_ASSIGN;
      zw1->com.assign.erg = expr->hv;
      expr->hv = zw->com.reduce.erg = zw1->com.assign.wert = scal;
      free_hvar(scal);
    }
    else
      zw->com.reduce.erg = expr->hv;
    zw->com.reduce.ziel = expr->code;
    zw->com.reduce.spez = spez;
    zw->com.reduce.scop = sco;
    if (sel)
    { zw->com.reduce.prozanz = sel->proc;
      zw->com.reduce.select = sel->code;
      zw->com.reduce.sel = sel->var;
      if (zw->com.reduce.bool = (sel->var) ? bool : NULL)
      { null_prozessoren = 1; }      
      expr->zeilen += sel->zeilen + (((sel->count) && sel->var) ? 3 : 0);
      if (bool)
        free_hvar(bool);
      if (sel)
      { vector_ST->hvarsvect = hvarsvect;
        vector_ST_entfernen();
        hvarsvect = vector_ST->hvarsvect;
      }
    }
    else
    { zw->com.reduce.prozanz = akt_proz_anz; }
    expr->code = zw;
    zw->com.reduce.lines = expr->zeilen += ex->zeilen + 1;
  }
  if (expr->factors.reduce.select)
  { proc_info &= ~PI_VECTOR; }
}

ZWCODE * pointer_filter(expr,zw,ar,scavec,neu)
T_EXPR * expr;
ZWCODE * zw;
AR_COMP * ar;
int * scavec, * neu;
{ ZWCODE * zw1;
  while (ar)
  { switch (ar->art)
    { case 0 :
        *scavec |= ar->ar.array.scavec;
        expr->zeilen += ar->ar.array.zeilen;
        if (ar->ar.array.offset != 0)
        { if (ar->ar.array.offset < 0)
            *neu = zw->com.zugriff.neg = 1;
          else
            *neu = zw->com.zugriff.pos = 1;
        }
        if (ar->ar.array.erg != NULL)
          zw->com.zugriff.arr += *neu = 1;
        break;
      case 1 :
        if (ar->ar.record.comp != 0)
          *neu = zw->com.zugriff.pos = 1;
        break;
      case 2 :
        expr->zeilen += zw->com.zugriff.neg + zw->com.zugriff.pos +
                        zw->com.zugriff.arr;
        GET_MEM(zw1,1,ZWCODE);
        zw1->art = CO_ZUGRIFF;
        zw1->com.zugriff.comp = ar;
        zw1->com.zugriff.basis = NULL;
        ar->ar.pointer.rest = zw;
        *neu = 1;
        zw = zw1;
        break;
    }
    ar = ar->link;
  }
  return zw;
}

int novector_st()
{ ST * s = akt_ST;
  while (s)
  { if (s->is_vector)
      return 0;
    s = s->Obertabelle;
  }
  return 1;
}
/* close file */
#endif
