static char _sccsid[] = "Parallaxis Version: @(#)fehler.c	2.13  2/28/92 15:00:01";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : fehler.c                                                          */
/*                                                                           */
/* Fehlermeldungen ausgeben                                                  */
/*                                                                           */
/* ************************************************************************* */

#include "defines.h"

#include "parallax.h"

FILE * yyerfp = stderr;
extern char * Zeile_ausgeben();

/* ************************************************************************* */
/* Fehlermeldung ausgeben                                                    */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Meldungsstring                                                */
/*             zusammengesetzter Meldungsstring                              */
/*                                                                           */
/* ************************************************************************* */

yyerror(s, t)
    register char * s, * t;
{   extern int yynerrs;   /* Fehleranzahl */
    static int list = 0;

    if (no_char_read || (yynerrs >= error_max_count)) return;
    if (s || ! list)
    {   /* neue Fehlermeldung vom Parser */
        fprintf(yyerfp, text[89], yynerrs+1);
        yywhere();
        if (s)
            /* nur ein Text */
        {   fputs(s, yyerfp);
            putc('\n', yyerfp);
            return;
        }
        if (t)
            /* einzelne Komponenten */
        {   fputs(text[88], yyerfp);
            fputs(t, yyerfp);
            list = 1;
            return;
        }
           /* Standardtext */
        fputs(text[85], yyerfp);
        putc('\n', yyerfp);
        return;
    }
       /* weitere Komponente */
    if (t)
    {   if (*t)
        {   putc(' ', yyerfp);
            fputs(t, yyerfp);
        }
        return;
    }
       /* keine Komponente folgt mehr */
    putc('\n', yyerfp);
    list = 0;
}

extern int yyleng;               /* und seine Laenge */
extern int yylineno;             /* aktuelle Eingabezeile */
extern int sp_pos;               /* aktuelle Position */                
extern int yylineno2;            /* aktuelle Eingabezeile */
extern int sp_pos2;              /* aktuelle Position */                
extern char yytext[];            /* zuletzt gelesenes Zeichen */


/* ************************************************************************* */
/* Position des Fehlers ausgeben                                             */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter :                                                               */
/*                                                                           */
/* ************************************************************************* */

yywhere()
{   char * text1, * text2;
    char colon = 0;
    int zeile1, zeile2;
    int sp1, sp2;

    if (((yylineno > yylineno2) && (yylineno2 > 0)) || (yylineno == 0))
       /* Reihenfolge der Zeilen */
    { zeile1 = yylineno2;
      zeile2 = yylineno;
      sp1 = sp_pos2;
      sp2 = sp_pos;
    }
    else
    { zeile2 = yylineno2;
      zeile1 = yylineno;
      if (zeile1 == zeile2)
          /* Reihenfolge der Spalten */
      { if (sp_pos > sp_pos2)
        { sp1 = sp_pos2;
          sp2 = sp_pos;
        }
        else
        { sp2 = sp_pos2;
          sp1 = sp_pos;
        }
      }
      else
      {     
        sp2 = sp_pos2;
        sp1 = sp_pos;
      }
    }
    text1 = Zeile_ausgeben(zeile1);
    if (zeile2 > 0)
        /* zweite Zeile */
    { text2 = Zeile_ausgeben(zeile2); }
    else
      text2 = NULL;

    if (zeile1 == max_zeilenzahl)
        /* Dateiende ? */
    {   if (colon)
            fputs(", ",yyerfp);
        fprintf(yyerfp, text[87]);
    }
    else
    {   /* Zeile ausgeben */
        if (zeile1 > 0)
        {   if (colon)
                fputs(", ",yyerfp);
            fprintf(yyerfp, text[90],zeile1);
            if ((zeile2 > 0) && (zeile1 != zeile2))
              fprintf(yyerfp, text[91],zeile2);
            colon = 1;
        }
        if (text1 != NULL)
        {   register char * z;
            int i;
               /* 1. Zeile mit ^ ausgeben */
            fprintf(yyerfp,"\n%s\n",text1);
            z = text1;
            for (i = 0; i < sp1; i++)
                fprintf(yyerfp,"%c",(z[i] == '\t') ? '\t' : ' ');

            if (text2 != NULL)
            { if (zeile1 != zeile2)
                /* 2. Zeile muss ausgegeben werden */
              { fprintf(yyerfp,"^\n%s\n",text2);
                z = text2;
                for (i = 0; i < sp2; i++)
                    fprintf(yyerfp,"%c",(z[i] == '\t') ? '\t' : ' '); 
              }
              else
              { if (sp1 != sp2)
                { fprintf(yyerfp,"^");
                  /* 2. Position markieren */
                  while (++i < sp2)
                    fprintf(yyerfp,"%c",(z[i] == '\t') ? '\t' : ' ');
                }
              }
            }
            fprintf(yyerfp,"^\n****  ");
        }
        else
        { if (*yytext)
             /* keine Zeilenausgabe */
          {   register int i;

              for (i = 0; i < 20; ++ i)
                  if (!yytext[i] || yytext[i] == '\n')
                      break;
              if (i)
              {   if (colon)
                      putc(' ', yyerfp);
                  fprintf(yyerfp, text[92], i, yytext);
                  colon = 1;
              }
          }

          if (colon)
              fputs(": ", yyerfp);
        }
    }
}

/* ************************************************************************* */
/* Position des Fehlers ausgeben                                             */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Zeilen- und Spaltenangaben fuer die beiden Fehlerpositionen   */
/*             Fehlertext                                                    */
/*                                                                           */
/* ************************************************************************* */

SEMERROR(z1,p1,z2,p2,str)
int z1,p1,z2,p2;
char * str;
{ int zeile, pos;
  zeile = yylineno;
  pos = sp_pos;
  yylineno = z1;
  sp_pos = p1;
  yylineno2 = z2;
  sp_pos2 = p2;
  yyerror(text[86],NULL);
  yynerrs++;
  do_fehler_warn(1,yynerrs);
  fehler(str);
  yylineno = zeile;
  sp_pos = pos;
  yylineno2 = 0;
  sp_pos2 = 0;
}


extern FILE * ausDatei, * yyerfp;

/* ************************************************************************* */
/* Fehler bei Zeilenzaehlung ist aufgetreten                                 */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : quellzeile                                                    */
/*             berechnete Zeilenzahl                                         */
/*             Beginn des fehlerhaften Bereichs im PARZ-Code                 */
/*             Ende des fehlerhaften Bereichs im PARZ-Code                   */
/*                                                                           */
/* ************************************************************************* */

output_error(quell,zahl,anf,end)
int quell,zahl,anf,end;
{ char t[100];
  sprintf(t,text[81],quell,zahl,anf,end);
  fputs(text[95], yyerfp);
  fprintf(yyerfp, t);
  putc('\n', yyerfp);
  fclose(ausDatei);
  my_exit(1);
}

/* ************************************************************************* */
/* Fehler bei Zeilenzaehlung ist aufgetreten                                 */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : berechnete Zeilennummer                                       */
/*             tats"achliche Zeilennummer                                    */
/*                                                                           */
/* ************************************************************************* */

firstline_error(calc,exact)
int calc,exact;
{ char t[100];
  sprintf(t,text[82],calc,exact);
  fputs(text[95], yyerfp);
  fprintf(yyerfp, t);
  putc('\n', yyerfp);
  fclose(ausDatei);
  my_exit(1);
}

/* ************************************************************************* */
/* Fehler bei Zeilenzaehlung ist aufgetreten                                 */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : berechnete Zeilennummer                                       */
/*             tats"achliche Zeilennummer                                    */
/*                                                                           */
/* ************************************************************************* */

procfirstline_error(pnr,calc,exact)
long pnr;
int calc,exact;
{ char t[100];
  sprintf(t,text[83],getstring(pnr),calc,exact);
  fputs(text[95], yyerfp);
  fprintf(yyerfp, t);
  putc('\n', yyerfp);
  fclose(ausDatei);
  my_exit(1);
}

                      
