/* Parallaxis Version: @(#)fehler.h	2.13  2/28/92 14:46:03  */
/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : fehler.h                                                          */
/*                                                                           */
/* Definitionen fuer die Ausgabe von Fehlermeldungen                         */
/*                                                                           */
/* ************************************************************************* */

/* semantischer Fehler (2 Positionsangaben und 1 String) * /
#define SEMERROR(z1,p1,z2,p2,str)   { int ______zeile, ______pos;\
                                      ______zeile = yylineno;\
                                      ______pos = sp_pos;\
                                      yylineno = z1;\
                                      sp_pos = p1;\
                                      yylineno2 = z2;\
                                      sp_pos2 = p2;\
                                      yyerror(text[86],NULL);\
                                      yynerrs++;\
                                      do_fehler_warn(1,yynerrs);\
                                      fehler(str);\
                                      yylineno = ______zeile;\
                                      sp_pos = ______pos;\
                                      yylineno2 = 0;\
                                      sp_pos2 = 0;\
                                    }

/* syntaktischer Fehler (2 Positionsangaben und 1 String) */
#define SYNTAXERROR(z1,p1,z2,p2,str)   { int ______zeile, ______pos;\
                                      ______zeile = yylineno;\
                                      ______pos = sp_pos;\
                                      yylineno = z1;\
                                      sp_pos = p1;\
                                      yylineno2 = z2;\
                                      sp_pos2 = p2;\
                                      yyerror(text[85],NULL);\
                                      yynerrs++;\
                                      do_fehler_warn(1,yynerrs);\
                                      fehler(str);\
                                      yylineno = ______zeile;\
                                      sp_pos = ______pos;\
                                      yylineno2 = 0;\
                                      sp_pos2 = 0;\
                                    }

/* Warnung (1 Positionsangabe und 1 String) */
#define WARNING(z1,p1,str)          { int ______zeile, ______pos;\
                                      ______zeile = yylineno;\
                                      ______pos = sp_pos;\
                                      yylineno = z1;\
                                      sp_pos = p1;\
                                      yylineno2 = 0;\
                                      sp_pos2 = 0;\
                                      warning(str);\
                                      yylineno = ______zeile;\
                                      sp_pos = ______pos;\
                                    }

/* sytaktischen Fehler im Parser ausloesen */
#define SYNERROR     if (yyerrflag1 == 0)\
                     { yylineno2 = 0;\
                       sp_pos2 = 0;\
                       yyerror(text[85],NULL);\
                       yynerrs++;\
                       parsestate = -1;\
                       do_fehler_warn(1,yynerrs);\
                       yyerrflag1 = yyerrflag = 3;\
                     }

/* Fehlermeldungen ins Listing einbauen */

typedef struct fehler_warn {
   struct fehler_warn * link;
   int fehl_warn;    /* 0 : Fehler; 1 : Warnung */
   int nummer;       /* Fehlernummer */
   int posit1;       /* Position 1*/
   int posit2;       /* Position 2*/
   int state;        /* Parserzustand */ 
   char * str;       /* Fehlerstring */
   } FEHLER_WARN;

/* in den Makros verwendete Variablen */
extern int parsestate;   /* Parserstatus fuer die 'erwartet wird'-Fehlermeldung */
extern int yylineno, yylineno2, sp_pos, sp_pos2; /* Zeilen- und Spalteninformation */

