static char _sccsid[] = "Parallaxis Version: @(#)listing.c	2.13  2/28/92 15:09:59";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : listing.c                                                         */
/*                                                                           */
/* Verwaltung der internen Repraesentation des Programmlistings              */
/*                                                                           */
/* ************************************************************************* */


#include "defines.h"
# include "parallax.h"

ZEILE * list_anf = NULL; /* Anfang der Kette */
ZEILE * list_end = NULL; /* Ende der Kette */

/* ************************************************************************* */
/* einfuegen einer neuen Zeile                                               */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : einzulagernde Zeile                                           */
/*             Laenge der Zeile                                              */
/*             Zeilennummer gesamt                                           */
/*             Zeilennummer vom Precompiler                                  */
/*                                                                           */
/* ************************************************************************* */

Zeile_einlesen(z,l,nr)
char * z;       /* einzulagernde Zeile */
int l,          /* Laenge der Zeile */
    nr;         /* Zeilennummer */
{   int i;
    ZEILE * m; 

    if ((m = (ZEILE *) my_calloc(1, sizeof(ZEILE) + l)) == NULL)
      fatal(text[100]);
    m -> next = NULL;
    if (list_anf != NULL)
    {   list_end -> next = m;
        list_end = m; }
    else
    {   list_anf = list_end =  m; }
    m -> nummer = nr;
    for(i = 0; i <= l; i++)
    {   m -> sourcetext[i] = *z++; }
}

/* ************************************************************************* */
/* String und Preprozessorzeilennummer einer Zeile ermitteln                 */
/*                                                                           */
/* Ergebnis : Text der Zeile                                                 */
/*                                                                           */
/* Parameter : Zeilennummer                                                  */
/*             Preprozessorzeilennummer                                      */
/*                                                                           */
/* ************************************************************************* */

char *
Zeile_ausgeben(nr)
int nr;         /* Zeilennummer im Listing */
{   ZEILE * z;

    for (z = list_anf; z != NULL; z = z->next)
    {   if (z->nummer == nr){ return(z->sourcetext); } }
    return(NULL);
}

/* ************************************************************************* */
/* ermittle komplette Zeilenstruktur zu einer Zeilennummer                   */
/*                                                                           */
/* Ergebnis : Zeilenstruktur                                                 */
/*                                                                           */
/* Parameter : Zeilennummer                                                  */
/*                                                                           */
/* ************************************************************************* */

ZEILE * get_line(nr)
int nr;
{ ZEILE * z;
    for (z = list_anf; z != NULL; z = z->next)
    {   if (z->nummer == nr) return z; }
    if ((nr != 0) && (nr == max_zeilenzahl))
        /* Dateiende wird fuer Fehlermeldung benoetigt */
    { GET_MEM(z,1,ZEILE);
      z -> nummer = nr;
      if (list_anf)
      { list_end->next = z;
        list_end = z;
      }
      else
      { list_anf = list_end = z; }
      return z; 
    }
    return(NULL);
}
  
