static char _sccsid[] = "Parallaxis Version: @(#)message.c	2.13  2/28/92 15:10:01";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : message.c                                                         */
/*                                                                           */
/* Meldungen ausgeben (nach 'Compiler bauen mit UNIX' von Schreiner,Friedman)*/
/*                                                                           */
/* ************************************************************************* */


#include "defines.h"
#include <stdio.h>
/*#ifdef PC
#include <string.h>
#else
#   ifdef HP
#      include <string.h>
#   else
#      include <strings.h>
#   endif
#endif*/
#include <ctype.h>
#include "parallax.h"

#define VARARG fmt, v1, v2, v3, v4, v5
#define VARPARM (VARARG) char * fmt;
extern int yynerrs, yylineno, yylineno2, sp_pos, sp_pos2;
extern FILE * yyerfp;
int fehler_anz = 0;
extern ZEILE * get_line();
FEHLER_WARN * fw_1 = NULL;
FEHLER_WARN * fw_2 = NULL;

/* ************************************************************************* */
/* Fehlermeldung erzeugen                                                    */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Text und Integerzahlen                                        */
/*                                                                           */
/* ************************************************************************* */
/*VARARGS1*/
fehler VARPARM
{   if (no_char_read) return;
    if (fw_1 != NULL)
      fw_1->str = fmt;
    if (fw_2 != NULL)
      fw_2->str = fmt;
    fw_1 = fw_2 = NULL;
    if (fehler_anz < yynerrs)
    {   if (yynerrs <= error_max_count)
        {   fprintf(yyerfp,"\t\t\t");
            fprintf(yyerfp,VARARG);
            fehler_anz++;
            putc('\n', yyerfp);
        }
    }
}

/* ************************************************************************* */
/* Meldung erzeugen                                                          */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Text und Integerzahlen                                        */
/*                                                                           */
/* ************************************************************************* */

/*VARARGS1*/
message VARPARM
{
    yywhere();
    fprintf(yyerfp, VARARG);
    putc('\n', yyerfp);
}

/* ************************************************************************* */
/* Fehlermeldung erzeugen                                                    */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Text und Integerzahlen                                        */
/*                                                                           */
/* ************************************************************************* */

/*VARARGS1*/
error VARPARM
{   extern int yynerrs;
    if (fw_1 != NULL)
      fw_1->str = fmt;
    if (fw_2 != NULL)
      fw_2->str = fmt;
    fw_1 = fw_2 = NULL;
    if (yynerrs++ < error_max_count)
    {   fprintf(yyerfp, text[89], yynerrs);
        message(VARARG);
    }
}

/* ************************************************************************* */
/* Warnung erzeugen                                                          */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Text und Integerzahlen                                        */
/*                                                                           */
/* ************************************************************************* */

/*VARARGS1*/
warning VARPARM
{
    if (yywarning++ < warn_max_count)
    {
        fprintf(yyerfp, text[93], yywarning);
        message(VARARG);
    }
        /* Fehlermeldung fuer das Listing sichern */
    do_fehler_warn(0,yywarning);
    if (fw_1 != NULL)
      fw_1->str = fmt;
    if (fw_2 != NULL)
      fw_2->str = fmt;
    fw_1 = fw_2 = NULL;
}

/* ************************************************************************* */
/* fataten Fehler melden                                                     */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Text und Integerzahlen                                        */
/*                                                                           */
/* ************************************************************************* */

/*VARARGS1*/
fatal VARPARM
{
    fputs(text[94], yyerfp);
    message(VARARG);
    my_exit(1);
}

/* ************************************************************************* */
/* Systemfehler melden                                                       */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Text und Integerzahlen                                        */
/*                                                                           */
/* ************************************************************************* */

/*VARARGS1*/
bug VARPARM
{
    fputs(text[95], yyerfp);
    message(VARARG);
    my_exit(1);
}

/* ************************************************************************* */
/* Text speichern                                                            */
/*                                                                           */
/* Ergebnis : gespeicherter Text                                             */
/*                                                                           */
/* Parameter : zuspeichernder Text                                           */
/*                                                                           */
/* ************************************************************************* */

char * strsave(s)
    register char * s;
{   register char * cp = (char *) my_calloc(my_strlen(s)+1, 1);

    if (cp)
    {   strcpy(cp, s);
        return cp; }
    fatal(text[100]);
}

/* ************************************************************************* */
/* Fehler und Warnungen fuer Listing merken                                  */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Fehler oder Warnung                                           */
/*             Zeilennummer                                                  */
/*                                                                           */
/* ************************************************************************* */

do_fehler_warn(mode,nummer)
int mode;    /* Fehler oder Warnung */
int nummer;
{ ZEILE * line = get_line(yylineno);
  int posit;
  if (line != NULL)
  { FEHLER_WARN * fw, *fw1 = line->fehl_warn;
    GET_MEM(fw,1,FEHLER_WARN);
    fw->fehl_warn = mode;
    fw->nummer = nummer;
    fw->state = parsestate;
    if (yylineno == yylineno2)
        /* Reihenfolge festlegen */
    { posit = fw->posit1 = (sp_pos > sp_pos2) ? sp_pos2 : sp_pos;
      fw->posit2 = (sp_pos < sp_pos2) ? sp_pos2 : sp_pos;
    }
    else
    { posit = fw->posit1 = fw->posit2 = sp_pos; }
    fw_1 = fw;
    if (fw1 != NULL)
    { if (fw1->posit1 <= posit)
      { while ((fw1->link != NULL) && (fw1->link->posit1 <= posit))
          /* nach Spalten sortieren */
        { fw1 = fw1->link; }
        fw->link = fw1->link;
        fw1->link = fw;
        return;
      }
      fw->link = fw1;
    }
    line->fehl_warn = fw;
  }
  line = get_line(yylineno2);
  if ((yylineno != yylineno2) && (line != NULL))
      /* zweite Zeile */
  { FEHLER_WARN * fw, *fw1 = line->fehl_warn;
    GET_MEM(fw,1,FEHLER_WARN);
    fw_2 = fw;
    fw->fehl_warn = mode;
    fw->nummer = nummer;
    fw->posit1 = fw->posit2 = sp_pos2;
    fw->state = parsestate;
    if (fw1 != NULL)
    { if (fw1->posit1 <= sp_pos2)
        /* nach Spalten sortieren */
      { while ((fw1->link != NULL) && (fw1->link->posit1 <= sp_pos2))
        { fw1 = fw1->link; }
        fw->link = fw1->link;
        fw1->link = fw;
        return;
      }
      fw->link = fw1;
    }
    line->fehl_warn = fw;
  }
}

