static char _sccsid[] = "Parallaxis Version: @(#)out_func.c	2.16  12/14/92 10:29:25";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : out_func.c                                                        */
/*                                                                           */
/* Funktionen, die den PARZ-Code ausgeben                                    */
/*                                                                           */
/* ************************************************************************* */


#include "outputx.h"
#include "conf.h"

out_rtest(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ zeilennummer(err);
  fprintf(ausDatei,"IF ");
  variable_ausgeben(zw->com.rtest.var,zw->com.rtest.var->dir_indir);
  fprintf(ausDatei," < ");
  bereichsgrenze(zw->com.rtest.typ->info.range.von,
                 zw->com.rtest.typ->info.range.super);
  fprintf(ausDatei," CALL %d;",bereich_fehler);
  if (zw->com.rtest.typ->info.range.bis < MAXINTEGER)
  { zeilennummer(err);
    fprintf(ausDatei,"IF ");
    bereichsgrenze(zw->com.rtest.typ->info.range.bis,
                   zw->com.rtest.typ->info.range.super);
    fprintf(ausDatei," < ");
    variable_ausgeben(zw->com.rtest.var,zw->com.rtest.var->dir_indir);
    fprintf(ausDatei," CALL %d;",bereich_fehler);
  }
}


out_rntest(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ zeilennummer(err);
  variable_ausgeben(zw->com.rtest.hvar,DIRECT);
  fprintf(ausDatei," := %d;",zw->com.rtest.typ->info.range.von);
  zeilennummer(err);
  fprintf(ausDatei,"IF ");
  variable_ausgeben(zw->com.rtest.var,zw->com.rtest.var->dir_indir);
  fprintf(ausDatei," < ");
  variable_ausgeben(zw->com.rtest.hvar,DIRECT);
  fprintf(ausDatei," CALL %d;",bereich_fehler);
  if (zw->com.rtest.typ->info.range.bis < MAXINTEGER)
  { zeilennummer(err);
    fprintf(ausDatei,"IF %d < ",zw->com.rtest.typ->info.range.bis);
    variable_ausgeben(zw->com.rtest.var,zw->com.rtest.var->dir_indir);
    fprintf(ausDatei," CALL %d;",bereich_fehler);
  }
}


out_rnntest(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ zeilennummer(err);
  variable_ausgeben(zw->com.rtest.hvar,DIRECT);
  fprintf(ausDatei," := %d;",zw->com.rtest.typ->info.range.von);
  zeilennummer(err);
  fprintf(ausDatei,"IF ");
  variable_ausgeben(zw->com.rtest.var,zw->com.rtest.var->dir_indir);
  fprintf(ausDatei," < ");
  variable_ausgeben(zw->com.rtest.hvar,DIRECT);
  fprintf(ausDatei," CALL %d;",bereich_fehler);
  zeilennummer(err);
  variable_ausgeben(zw->com.rtest.hvar,DIRECT);
  fprintf(ausDatei," := %d;",zw->com.rtest.typ->info.range.bis);
  zeilennummer(err);
  fprintf(ausDatei,"IF ");
  variable_ausgeben(zw->com.rtest.hvar,DIRECT);
  fprintf(ausDatei," < ");
  variable_ausgeben(zw->com.rtest.var,zw->com.rtest.var->dir_indir);
  fprintf(ausDatei," CALL %d;",bereich_fehler);
}


out_ntest(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ zeilennummer(err);
  fprintf(ausDatei,"IF ");
  variable_ausgeben(zw->com.ntest.var,zw->com.ntest.var->dir_indir);
  fprintf(ausDatei," = 0");
  if (match_typen(typ_real,zw->com.ntest.typ,0) == JA)
    fprintf(ausDatei,".0");
  fprintf(ausDatei," CALL %d;",divisions_fehler);
}


out_ctest(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ zeilennummer(err);
  fprintf(ausDatei,"IF ");
  variable_ausgeben(zw->com.ctest.var,zw->com.ctest.var->dir_indir);
  fprintf(ausDatei," < 0");
  fprintf(ausDatei," CALL %d;",bereich_fehler);
}


out_unop(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.unop.ex1);
  code_ausgeben(err,zw->com.unop.ziel);
  zeilennummer(err);
  variable_ausgeben(zw->com.unop.erg,zw->com.unop.erg->dir_indir);
  if (zw->com.unop.op == '-')
  { fprintf(ausDatei," := - "); }
  else
  { fprintf(ausDatei," := NOT "); }
  variable_ausgeben(zw->com.unop.op1,zw->com.unop.op1->dir_indir);
  fprintf(ausDatei,";");
}


out_binop(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.binop.ex1);
  code_ausgeben(err,zw->com.binop.ex2);
  code_ausgeben(err,zw->com.binop.ziel);
  zeilennummer(err);
  variable_ausgeben(zw->com.binop.erg,zw->com.binop.erg->dir_indir);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.binop.op1,zw->com.binop.op1->dir_indir);
  switch(zw->com.binop.op)
  { case '+' :
      fprintf(ausDatei," + ");
      break;
    case '-' :
      fprintf(ausDatei," - ");
      break;
    case '*' :
      fprintf(ausDatei," * ");
      break;
    case '/' :
    case _DIV :
      fprintf(ausDatei," / ");
      break;
    case POWER :
      fprintf(ausDatei," ^ ");
      break;
    case _MOD :
      fprintf(ausDatei," MOD ");
      break;
    case '<' :
      fprintf(ausDatei," < ");
      break;
    case '>' :
      fprintf(ausDatei," > ");
      break;
    case GREQ :
      fprintf(ausDatei," >= ");
      break;
    case LEEQ :
      fprintf(ausDatei," <= ");
      break;
    case '=' :
      fprintf(ausDatei," = ");
      break;
    case UNEQ :
      fprintf(ausDatei," <> ");
      break;
    case _AND :
      fprintf(ausDatei," AND ");
      break;
    case _OR :
      fprintf(ausDatei," OR ");
      break;
  }
  variable_ausgeben(zw->com.binop.op2,zw->com.binop.op2->dir_indir);
  fprintf(ausDatei,";");
}


out_constbinop(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.Constbinop.ex2);
  code_ausgeben(err,zw->com.Constbinop.ziel);
  zeilennummer(err);
  variable_ausgeben(zw->com.Constbinop.erg,zw->com.Constbinop.erg->dir_indir);
  fprintf(ausDatei," := ");
  char_string = 0;
  konstante_ausgeben(zw->com.Constbinop.op1);
  switch(zw->com.Constbinop.op)
  { case '+' :
      fprintf(ausDatei," + ");
      break;
    case '-' :
      fprintf(ausDatei," - ");
      break;
    case '*' :
      fprintf(ausDatei," * ");
      break;
    case '/' :
    case _DIV :
      fprintf(ausDatei," / ");
      break;
    case POWER :
      fprintf(ausDatei," ^ ");
      break;
    case _MOD :
      fprintf(ausDatei," MOD ");
      break;
    case '<' :
      fprintf(ausDatei," < ");
      break;
    case '>' :
      fprintf(ausDatei," > ");
      break;
    case GREQ :
      fprintf(ausDatei," >= ");
      break;
    case LEEQ :
      fprintf(ausDatei," <= ");
      break;
    case '=' :
      fprintf(ausDatei," = ");
      break;
    case UNEQ :
      fprintf(ausDatei," <> ");
      break;
  }
  variable_ausgeben(zw->com.Constbinop.op2,zw->com.Constbinop.op2->dir_indir);
  fprintf(ausDatei,";");
}


out_binopconst(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.binopConst.ex1);
  code_ausgeben(err,zw->com.binopConst.ziel);
  zeilennummer(err);
  variable_ausgeben(zw->com.binopConst.erg,zw->com.binopConst.erg->dir_indir);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.binopConst.op1,zw->com.binopConst.op1->dir_indir);
  switch(zw->com.binopConst.op)
  { case '+' :
      fprintf(ausDatei," + ");
      break;
    case '-' :
      fprintf(ausDatei," - ");
      break;
    case '*' :
      fprintf(ausDatei," * ");
      break;
    case '/' :
    case _DIV :
      fprintf(ausDatei," / ");
      break;
    case POWER :
      fprintf(ausDatei," ^ ");
      break;
    case _MOD :
      fprintf(ausDatei," MOD ");
      break;
    case '=' :
      fprintf(ausDatei," = ");
      break;
    case '<' :
      fprintf(ausDatei," < ");
      break;
    case '>' :
      fprintf(ausDatei," > ");
      break;
    case LEEQ :
      fprintf(ausDatei," <= ");
      break;
    case GREQ :
      fprintf(ausDatei," >= ");
      break;
    case UNEQ :
      fprintf(ausDatei," <> ");
      break;
  }
  char_string = 0;
  konstante_ausgeben(zw->com.binopConst.op2);
  fprintf(ausDatei,";");
}


out_assign(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.assign.ex1);
  code_ausgeben(err,zw->com.assign.ziel);
  zeilennummer(err);
  variable_ausgeben(zw->com.assign.erg,zw->com.assign.erg->dir_indir);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.assign.wert,zw->com.assign.wert->dir_indir);
  fprintf(ausDatei,";");
}


out_constass(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ zeilennummer(err);
  code_ausgeben(err,zw->com.Constass.ziel);
  variable_ausgeben(zw->com.Constass.erg,zw->com.Constass.erg->dir_indir);
  fprintf(ausDatei," := ");
  char_string = zw->com.Constass.charst;
  konstante_ausgeben(zw->com.Constass.wert);
  fprintf(ausDatei,";");
}


out_blockass(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.blockass.ex1);
  code_ausgeben(err,zw->com.blockass.ziel);
  zeilennummer(err);
  fprintf(ausDatei,"MOVE ");
  variable_ausgeben(zw->com.blockass.wert,zw->com.blockass.wert->dir_indir);
  fprintf(ausDatei," TO ");
  variable_ausgeben(zw->com.blockass.erg,zw->com.blockass.erg->dir_indir);
  zeilenfuellung = 1;
  fprintf(ausDatei," AS");
  indent_tab = "\t\t\t";
  typdef_ausgeben(ausDatei,zw->com.blockass.typ,1l);
  fprintf(ausDatei,";");
}


out_setass(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ int i = zw->com.setass.anz;
  int j = sizeof(unsigned) * 8;
  int l = 1;
  int flag = 0;
  unsigned k, *z = zw->com.setass.set;
  k = 1;
  zeilennummer(err);
  variable_ausgeben(zw->com.setass.erg,zw->com.setass.erg->dir_indir);
  if (zw->com.setass.set)
  { fprintf(ausDatei," := INITSET %c",(*z & k) ? '1' : '0');
    i--;
    while (i > 0)
    { k = k << 1;
      if ((l++ % j) == 0)
      { k = 1;
        z = &z[1];
      }
      fprintf(ausDatei,"%c",(*z & k) ? '1' : '0');
      i--;
      if (i && ((l % 50) == 0))
        fprintf(ausDatei,"\n\t\t\t");
    }
  }
  else
  { fprintf(ausDatei," := ");
    while (i > 0)
    { fprintf(ausDatei,"0");
      i--;
    }
  }
  fprintf(ausDatei,";");
/*  fprintf(ausDatei," := %s;",(*z & k) ? "TRUE" : "FALSE");
  while (i > 0)
  { k = k << 1;
    if ((l++ % j) == 0)
    { k = 1;
      z = &z[1];
    }
    zeilennummer(err);
    variable_ausgeben(zw->com.setass.help,DIRECT);
    fprintf(ausDatei," := ");
    if (flag)
      variable_ausgeben(zw->com.setass.help,DIRECT);
    else
      variable_ausgeben(zw->com.setass.erg,ADRESS);
    flag = 1;
    fprintf(ausDatei," + SIZE( B1 );");
    zeilennummer(err);
    variable_ausgeben(zw->com.setass.help,INDIRECT);
    fprintf(ausDatei," := %s;",(*z & k) ? "TRUE" : "FALSE");
    i--;
  }*/
}


out_clearset(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ zeilennummer(err);
  variable_ausgeben(zw->com.clearset.help2,DIRECT);
  fprintf(ausDatei," := 0;");
  zeilennummer(err);
  variable_ausgeben(zw->com.clearset.help1,DIRECT);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.clearset.erg,ADRESS);
  fprintf(ausDatei," + ");
  variable_ausgeben(zw->com.clearset.help2,DIRECT);
  fprintf(ausDatei,";");
  zeilennummer(err);
  variable_ausgeben(zw->com.clearset.help1,INDIRECT);
  fprintf(ausDatei," := FALSE;");
  zeilennummer(err);
  variable_ausgeben(zw->com.clearset.help2,DIRECT);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.clearset.help2,DIRECT);
  fprintf(ausDatei," + SIZE( B1 );");
  zeilennummer(err);
  fprintf(ausDatei,"IF ");
  variable_ausgeben(zw->com.clearset.help2,DIRECT);
  fprintf(ausDatei," < SIZE( B%d ) GOTO %d;",zw->com.clearset.anz,linenr-4);
}


out_setop(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ int nummer;
  code_ausgeben(err,zw->com.setop.ex1);
  code_ausgeben(err,zw->com.setop.ex2);
  zeilennummer(err);
  variable_ausgeben(zw->com.setop.count, DIRECT);
  fprintf(ausDatei," := 0;");
  nummer = linenr;
  zeilennummer(err);
  variable_ausgeben(zw->com.setop.help1,DIRECT);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.setop.op1,ADRESS);
  fprintf(ausDatei, " + ");
  variable_ausgeben(zw->com.setop.count,DIRECT);
  fprintf(ausDatei, ";");
  zeilennummer(err);
  variable_ausgeben(zw->com.setop.help2,DIRECT);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.setop.op2,ADRESS);
  fprintf(ausDatei, " + ");
  variable_ausgeben(zw->com.setop.count,DIRECT);
  fprintf(ausDatei, ";");
  zeilennummer(err);
  variable_ausgeben(zw->com.setop.helpe,DIRECT);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.setop.erg,ADRESS);
  fprintf(ausDatei, " + ");
  variable_ausgeben(zw->com.setop.count,DIRECT);
  fprintf(ausDatei, ";");
  switch(zw->com.setop.op)
  { case '+' :
      zeilennummer(err);
      variable_ausgeben(zw->com.setop.helpe,INDIRECT);
      fprintf(ausDatei," := ");
      variable_ausgeben(zw->com.setop.help1,INDIRECT);
      fprintf(ausDatei," OR ");
      variable_ausgeben(zw->com.setop.help2,INDIRECT);
      fprintf(ausDatei,";");
      break;
    case '*' :
      zeilennummer(err);
      variable_ausgeben(zw->com.setop.helpe,INDIRECT);
      fprintf(ausDatei," := ");
      variable_ausgeben(zw->com.setop.help1,INDIRECT);
      fprintf(ausDatei," AND ");
      variable_ausgeben(zw->com.setop.help2,INDIRECT);
      fprintf(ausDatei,";");
      break;
    case '-' :
      zeilennummer(err);
      variable_ausgeben(zw->com.setop.bhelp1,DIRECT);
      fprintf(ausDatei," := NOT ");
      variable_ausgeben(zw->com.setop.help2,INDIRECT);
      fprintf(ausDatei,";");
      zeilennummer(err);
      variable_ausgeben(zw->com.setop.helpe,INDIRECT);
      fprintf(ausDatei," := ");
      variable_ausgeben(zw->com.setop.help1,INDIRECT);
      fprintf(ausDatei," AND ");
      variable_ausgeben(zw->com.setop.bhelp1,DIRECT);
      fprintf(ausDatei,";");
      break;
    case '/' :
      zeilennummer(err);
/*      variable_ausgeben(zw->com.setop.bhelp1,DIRECT);
      fprintf(ausDatei," := NOT ");
      variable_ausgeben(zw->com.setop.help1,INDIRECT);
      fprintf(ausDatei,";");
      zeilennummer(err);
      variable_ausgeben(zw->com.setop.bhelp1,DIRECT);
      fprintf(ausDatei," := ");
      variable_ausgeben(zw->com.setop.bhelp1,DIRECT);
      fprintf(ausDatei," AND ");
      variable_ausgeben(zw->com.setop.help2,INDIRECT);
      fprintf(ausDatei,";");
      zeilennummer(err);
      variable_ausgeben(zw->com.setop.bhelp2,DIRECT);
      fprintf(ausDatei," := NOT ");
      variable_ausgeben(zw->com.setop.help2,INDIRECT);
      fprintf(ausDatei,";");
      zeilennummer(err);
      variable_ausgeben(zw->com.setop.bhelp2,DIRECT);
      fprintf(ausDatei," := ");
      variable_ausgeben(zw->com.setop.help1,INDIRECT);
      fprintf(ausDatei," AND ");
      variable_ausgeben(zw->com.setop.bhelp2,DIRECT);
      fprintf(ausDatei,";");
      zeilennummer(err);
      variable_ausgeben(zw->com.setop.helpe,INDIRECT);
      fprintf(ausDatei," := ");
      variable_ausgeben(zw->com.setop.bhelp1,DIRECT);
      fprintf(ausDatei," OR ");
      variable_ausgeben(zw->com.setop.bhelp2,DIRECT);*/
      variable_ausgeben(zw->com.setop.helpe,INDIRECT);
      fprintf(ausDatei," := ");
      variable_ausgeben(zw->com.setop.help1,INDIRECT);
      fprintf(ausDatei," <> ");
      variable_ausgeben(zw->com.setop.help2,INDIRECT);
      fprintf(ausDatei,";");
      break;
  }
  zeilennummer(err);
  variable_ausgeben(zw->com.setop.count,DIRECT);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.setop.count,DIRECT);
  fprintf(ausDatei, " + SIZE( B1 );");
  zeilennummer(err);
  fprintf(ausDatei,"IF ");
  variable_ausgeben(zw->com.setop.count,DIRECT);
  fprintf(ausDatei," < SIZE( B%d ) GOTO %d;",zw->com.setop.anz,nummer);
}


out_setincl(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ int nummer;
  code_ausgeben(err,zw->com.setop.ex1);
  code_ausgeben(err,zw->com.setop.ex2);
  zeilennummer(err);
  variable_ausgeben(zw->com.setop.count, DIRECT);
  fprintf(ausDatei," := 0;");
  zeilennummer(err);
  variable_ausgeben(zw->com.setop.erg,zw->com.setop.erg->dir_indir);
  fprintf(ausDatei, " := TRUE;");
  nummer = linenr;
  zeilennummer(err);
  variable_ausgeben(zw->com.setop.help1,DIRECT);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.setop.op1,ADRESS);
  fprintf(ausDatei, " + ");
  variable_ausgeben(zw->com.setop.count,DIRECT);
  fprintf(ausDatei, ";");
  zeilennummer(err);
  variable_ausgeben(zw->com.setop.help2,DIRECT);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.setop.op2,ADRESS);
  fprintf(ausDatei, " + ");
  variable_ausgeben(zw->com.setop.count,DIRECT);
  fprintf(ausDatei, ";");
  zeilennummer(err);
  variable_ausgeben(zw->com.setop.bhelp1,DIRECT);
  fprintf(ausDatei," := NOT ");
  variable_ausgeben(zw->com.setop.help1,INDIRECT);
  fprintf(ausDatei,";");
  zeilennummer(err);
  variable_ausgeben(zw->com.setop.bhelp1,DIRECT);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.setop.bhelp1,DIRECT);
  fprintf(ausDatei," OR ");
  variable_ausgeben(zw->com.setop.help2,INDIRECT);
  fprintf(ausDatei,";");
  zeilennummer(err);
  variable_ausgeben(zw->com.setop.erg,zw->com.setop.erg->dir_indir);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.setop.erg,zw->com.setop.erg->dir_indir);
  fprintf(ausDatei," AND ");
  variable_ausgeben(zw->com.setop.bhelp1,DIRECT);
  fprintf(ausDatei,";");
  zeilennummer(err);
  variable_ausgeben(zw->com.setop.count,DIRECT);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.setop.count,DIRECT);
  fprintf(ausDatei, " + SIZE( B1 );");
  zeilennummer(err);
  fprintf(ausDatei,"IF ");
  variable_ausgeben(zw->com.setop.count,DIRECT);
  fprintf(ausDatei," < SIZE( B%d ) GOTO %d;",zw->com.setop.anz,nummer);
}


out_equal(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.vergl.ex1);
  code_ausgeben(err,zw->com.vergl.ex2);
  code_ausgeben(err,zw->com.vergl.ziel);
  zeilennummer(err);
  fprintf(ausDatei,"EQUAL ");
  variable_ausgeben(zw->com.vergl.op1,zw->com.vergl.op1->dir_indir);
  fprintf(ausDatei," ");
  variable_ausgeben(zw->com.vergl.op2,zw->com.vergl.op2->dir_indir);
  zeilenfuellung = 1;
  fprintf(ausDatei," AS");
  indent_tab = "\t\t\t";
  typdef_ausgeben(ausDatei,zw->com.vergl.typ,1l);
  fprintf(ausDatei,";");
  zeilennummer(err);
  variable_ausgeben(zw->com.vergl.erg,zw->com.vergl.erg->dir_indir);
  fprintf(ausDatei," := %cResult;",(zw->com.vergl.scavec == 0) ? 'S' : 'V');
}


out_unequal(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.vergl.ex1);
  code_ausgeben(err,zw->com.vergl.ex2);
  code_ausgeben(err,zw->com.vergl.ziel);
  zeilennummer(err);
  fprintf(ausDatei,"EQUAL ");
  variable_ausgeben(zw->com.vergl.op1,zw->com.vergl.op1->dir_indir);
  fprintf(ausDatei," ");
  variable_ausgeben(zw->com.vergl.op2,zw->com.vergl.op2->dir_indir);
  zeilenfuellung = 1;
  fprintf(ausDatei," AS");
  indent_tab = "\t\t\t";
  typdef_ausgeben(ausDatei,zw->com.vergl.typ,1l);
  fprintf(ausDatei,";");
  zeilennummer(err);
  variable_ausgeben(zw->com.vergl.erg,zw->com.vergl.erg->dir_indir);
  fprintf(ausDatei," := %cResult;",(zw->com.vergl.scavec == 0) ? 'S' : 'V');
  zeilennummer(err);
  variable_ausgeben(zw->com.vergl.erg,zw->com.vergl.erg->dir_indir);
  fprintf(ausDatei," := NOT ");
  variable_ausgeben(zw->com.vergl.erg,zw->com.vergl.erg->dir_indir);
  fprintf(ausDatei,";");
}


out_andor(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ int mode = zw->com.andor.op;
  zeilennummer(err);
  variable_ausgeben(zw->com.andor.hbv,DIRECT);
  if (((mode & 17) == 17) || ((mode & 17) == 0))
  { fprintf(ausDatei," := TRUE;"); }
  else
  { fprintf(ausDatei," := FALSE;"); }
  code_ausgeben(err,zw->com.andor.ex1);
  zeilennummer(err);
  fprintf(ausDatei,"IF ");
  if (mode & 16)
  { if (mode & 2)
    { if (mode & 8)
      { fprintf(ausDatei," FALSE %s %d;",(mode & 1) ? "CALL" : "GOTO",
                         linenr + ((mode & 1) ? 2 : (zw->com.andor.zeilen + 1)));
      }
      else
      { fprintf(ausDatei," TRUE %s %d;",(mode & 1) ? "CALL" : "GOTO",
                         linenr + ((mode & 1) ? 2 : (zw->com.andor.zeilen + 1)));
      }
    }
    else
    { variable_ausgeben(zw->com.andor.op1,zw->com.andor.op1->dir_indir);
      fprintf(ausDatei," = FALSE %s %d;",(mode & 1) ? "CALL" : "GOTO",
                       linenr + ((mode & 1) ? 2 : (zw->com.andor.zeilen + 1)));
    }
    if (mode & 1)
    { zeilennummer(err);
      fprintf(ausDatei,"IF ");
      variable_ausgeben(zw->com.andor.hbv,DIRECT);
      fprintf(ausDatei," CALL %d;",linenr + 4);
    }
  }
  else
  { if (zw->com.andor.op & 2)
    { if (zw->com.andor.op & 8)
      { fprintf(ausDatei,"TRUE %s %d;",(mode & 1) ? "CALL" : "GOTO",
                         linenr + ((mode & 1) ? 2 : (zw->com.andor.zeilen + 1)));
      }
      else
      { fprintf(ausDatei,"FALSE %s %d;",(mode & 1) ? "CALL" : "GOTO",
                         linenr + ((mode & 1) ? 2 : (zw->com.andor.zeilen + 1)));
      }
    }
    else
    { variable_ausgeben(zw->com.andor.op1,zw->com.andor.op1->dir_indir);
      fprintf(ausDatei," %s %d;",(mode & 1) ? "CALL" : "GOTO",
                       linenr + ((mode & 1) ? 2 : (zw->com.andor.zeilen + 1)));
    }
    if (mode & 1)
    { zeilennummer(err);
      fprintf(ausDatei,"IF ");
      variable_ausgeben(zw->com.andor.hbv,DIRECT);
      fprintf(ausDatei," = FALSE CALL %d;",linenr + 4);
    }
  }
  if (mode & 1)
  { zeilennummer(err);
    fprintf(ausDatei,"GOTO %d;",linenr + 6 + zw->com.andor.zeilen);
    zeilennummer(err);
    fprintf(ausDatei,"PROC %d;",proc_ebene + 1);
    zeilennummer(err);
    variable_ausgeben(zw->com.andor.hbv,DIRECT);
    fprintf(ausDatei," := %s;",(zw->com.andor.op & 16) ? "FALSE" : "TRUE");
    zeilennummer(err);
    fprintf(ausDatei,"RETURN;");
    zeilennummer(err);
    fprintf(ausDatei,"PROC %d;",proc_ebene + 1);
  }
  code_ausgeben(err,zw->com.andor.ex2);
  zeilennummer(err);
  variable_ausgeben(zw->com.andor.hbv,DIRECT);
  fprintf(ausDatei," := ");
  if (mode & 4)
    fprintf(ausDatei," %s",(mode & 8) ? "TRUE" : "FALSE");
  else
    variable_ausgeben(zw->com.andor.op2,zw->com.andor.op2->dir_indir);
  fprintf(ausDatei,";");    
  if (mode & 1)
  { zeilennummer(err);
    fprintf(ausDatei,"RETURN;");
  }
  if (zw->com.andor.erg->ein != zw->com.andor.hbv->ein)
  { zeilennummer(err);
    variable_ausgeben(zw->com.andor.erg,zw->com.andor.erg->dir_indir);
    fprintf(ausDatei," := ");
    variable_ausgeben(zw->com.andor.hbv,DIRECT);
    fprintf(ausDatei,";");
  }
}


out_pop(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ zeilennummer(err);
  fprintf(ausDatei,"POP%c ",(zw->com.pop.scavec & 1) ? 'V' : 'S');
  variable_ausgeben(zw->com.pop.erg,SPEZIAL);
  fprintf(ausDatei,";");
}


out_popblock(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ zeilennummer(err);
  fprintf(ausDatei,"POP%c ",(zw->com.popblock.scavec & 1) ? 'V' : 'S');
  variable_ausgeben(zw->com.popblock.temp,DIRECT);
  fprintf(ausDatei,";");
  zeilennummer(err);
  fprintf(ausDatei,"MOVE ");
  variable_ausgeben(zw->com.popblock.temp,INDIRECT);
  fprintf(ausDatei," TO ");
  variable_ausgeben(zw->com.popblock.erg,DIRECT);
  fprintf(ausDatei," AS");
  zeilenfuellung = 1;
  indent_tab = "\t\t\t";
  typdef_ausgeben(ausDatei,zw->com.popblock.typ,1l);
  fprintf(ausDatei,";");
}


out_funccall(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.funccall.param);
  if (zw->com.funccall.complex)
  { zeilennummer(err);
    fprintf(ausDatei,"PUSH%c ",(zw->com.funccall.scavec == 0) ? 'S' : 'V');
    variable_ausgeben(zw->com.funccall.erg,ADRESS);
    fprintf(ausDatei,";");
  }
  zeilennummer(err);
  fprintf(ausDatei,"CALL %d; %s",zw->com.funccall.proc->param.proz.posnr +
                                   normal_basis,
                                   getstring(zw->com.funccall.proc->name_nr));
  if (zw->com.funccall.complex == 0)
  { zeilennummer(err);
    fprintf(ausDatei,"POPV ");
    variable_ausgeben(zw->com.funccall.erg,zw->com.funccall.erg->dir_indir);
    fprintf(ausDatei,";");
  }
  code_ausgeben(err,zw->com.funccall.nach);
}


out_abs(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.abs.expr);
  zeilennummer(err);
  variable_ausgeben(zw->com.abs.erg,zw->com.abs.erg->dir_indir);
  fprintf(ausDatei," := ABS ");
  variable_ausgeben(zw->com.abs.var,zw->com.abs.var->dir_indir);
  fprintf(ausDatei,";");
}


out_float(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.abs.expr);
  zeilennummer(err);
  variable_ausgeben(zw->com.abs.erg,zw->com.abs.erg->dir_indir);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.abs.var,zw->com.abs.var->dir_indir);
  fprintf(ausDatei,";");
}


out_even(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.oddeven.expr);
  zeilennummer(err);
  variable_ausgeben(zw->com.oddeven.temp,DIRECT);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.oddeven.var,zw->com.oddeven.var->dir_indir);
  fprintf(ausDatei," MOD 2;");
  zeilennummer(err);
  variable_ausgeben(zw->com.oddeven.erg,zw->com.oddeven.erg->dir_indir);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.oddeven.temp,DIRECT);
  fprintf(ausDatei,";");
  zeilennummer(err);
  variable_ausgeben(zw->com.oddeven.erg,zw->com.oddeven.erg->dir_indir);
  fprintf(ausDatei," := NOT ");
  variable_ausgeben(zw->com.oddeven.erg,zw->com.oddeven.erg->dir_indir);
  fprintf(ausDatei,";");
}


out_odd(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.oddeven.expr);
  zeilennummer(err);
  variable_ausgeben(zw->com.oddeven.temp,DIRECT);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.oddeven.var,zw->com.oddeven.var->dir_indir);
  fprintf(ausDatei," MOD 2;");
  zeilennummer(err);
  variable_ausgeben(zw->com.oddeven.erg,zw->com.oddeven.erg->dir_indir);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.oddeven.temp,DIRECT);
  fprintf(ausDatei,";");
}


out_cap(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.cap.expr);
  zeilennummer(err);
  variable_ausgeben(zw->com.cap.hilf2,DIRECT);
  fprintf(ausDatei," := 'A';");
  zeilennummer(err);
  variable_ausgeben(zw->com.cap.hilf3,DIRECT);
  fprintf(ausDatei," := 'a';");
  zeilennummer(err);
  variable_ausgeben(zw->com.cap.hilf2,DIRECT);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.cap.hilf2,DIRECT);
  fprintf(ausDatei," - ");
  variable_ausgeben(zw->com.cap.hilf3,DIRECT);
  fprintf(ausDatei,";");
  zeilennummer(err);
  variable_ausgeben(zw->com.cap.hilf1,DIRECT);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.cap.var,zw->com.cap.var->dir_indir);
  fprintf(ausDatei," >= 'a';");
  zeilennummer(err);
  variable_ausgeben(zw->com.cap.hilf3,DIRECT);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.cap.hilf1,DIRECT);
  fprintf(ausDatei,";");
  zeilennummer(err);
  variable_ausgeben(zw->com.cap.hilf2,DIRECT);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.cap.hilf2,DIRECT);
  fprintf(ausDatei," * ");
  variable_ausgeben(zw->com.cap.hilf3,DIRECT);
  fprintf(ausDatei,";");
  zeilennummer(err);
  variable_ausgeben(zw->com.cap.hilf1,DIRECT);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.cap.var,zw->com.cap.var->dir_indir);
  fprintf(ausDatei," <= 'z';");
  zeilennummer(err);
  variable_ausgeben(zw->com.cap.hilf3,DIRECT);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.cap.hilf1,DIRECT);
  fprintf(ausDatei,";");
  zeilennummer(err);
  variable_ausgeben(zw->com.cap.hilf2,DIRECT);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.cap.hilf2,DIRECT);
  fprintf(ausDatei," * ");
  variable_ausgeben(zw->com.cap.hilf3,DIRECT);
  fprintf(ausDatei,";");
  zeilennummer(err);
  variable_ausgeben(zw->com.cap.hilf3,DIRECT);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.cap.var,zw->com.cap.var->dir_indir);
  fprintf(ausDatei,";");
  zeilennummer(err);
  variable_ausgeben(zw->com.cap.hilf2,DIRECT);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.cap.hilf2,DIRECT);
  fprintf(ausDatei," + ");
  variable_ausgeben(zw->com.cap.hilf3,DIRECT);
  fprintf(ausDatei,";");
  zeilennummer(err);
  variable_ausgeben(zw->com.cap.erg,zw->com.cap.erg->dir_indir);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.cap.hilf2,DIRECT);
  fprintf(ausDatei,";");
}


out_random(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.rand.erg);
  zeilennummer(err);
  variable_ausgeben(zw->com.rand.random,zw->com.rand.random->dir_indir);
  fprintf(ausDatei," := RANDOM;");
}


out_reduce(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ int se = selection_exit;
  int sx1,sx2;
  sx1 = selection_exit = linenr + zw->com.reduce.lines - 1;
  if (zw->com.reduce.scop && (zw->com.reduce.scop->entry == 0))
    (with_scope = zw->com.reduce.scop)->entry = zw->com.reduce.scop->von = linenr;
  if (zw->com.reduce.select)
  { selection_exit--; }
  if (zw->com.reduce.bool && (zw->com.reduce.true == 0))
  { zeilennummer(err);
    variable_ausgeben(zw->com.reduce.bool, DIRECT);
    fprintf(ausDatei," := TRUE;");
    zw->com.reduce.true = 1;
  }
  code_ausgeben(err,zw->com.reduce.select);
  sx2 = selection_exit;
  if (zw->com.reduce.sel == NULL)
  { int nr;
    if (zw->com.reduce.bool)
    { zeilennummer(err);
      variable_ausgeben(zw->com.reduce.bool, DIRECT);
      fprintf(ausDatei," := FALSE;");
    }
    code_ausgeben(err,zw->com.reduce.expr);
    code_ausgeben(err,zw->com.reduce.ziel);
    zeilennummer(err);
    variable_ausgeben(zw->com.reduce.erg,zw->com.reduce.erg->dir_indir);
    fprintf(ausDatei," := REDUCE ");
    if ((nr = zw->com.reduce.pna->param.proz.posnr) < 0)
    { switch (nr)
      { case PROC_FIRST :
          fprintf(ausDatei,"FIRST");
          break;
        case PROC_LAST :
          fprintf(ausDatei,"LAST");
          break;
        case PROC_SUM :
          fprintf(ausDatei,"SUM");
          break;
        case PROC_PRODUCT :
          fprintf(ausDatei,"PRODUCT");
          break;
        case PROC_MAX :
          fprintf(ausDatei,"MAX");
          break;
        case PROC_MIN :
          fprintf(ausDatei,"MIN");
          break;
      }
    }
    else
      fprintf(ausDatei,"%d",nr + normal_basis);
    fprintf(ausDatei," OF ");
    variable_ausgeben(zw->com.reduce.var,zw->com.reduce.var->dir_indir);
    if (zw->com.reduce.spez)
    { if (nr == PROC_MAX)
        fprintf(ausDatei,"; OR");
      else
        fprintf(ausDatei,"; AND");
    }
    else
      fprintf(ausDatei,"; %s",getstring(zw->com.reduce.pna->name_nr));
    if (zw->com.reduce.select && (sx1 != sx2))
    { parallel_string_ausgeben(err); }
  }
  else
  { ZWCODE * zw1 = zw->com.reduce.sel;
    ZWCODE * zw2 = zw->com.reduce.select;
    ZWCODE * zw3 = zw->link;
    zw->link = NULL;
    while (zw1->com.dyn.next != NULL)
    { zw1 = zw1->com.dyn.next; }
    zw1->com.dyn.next= zw;
    zw1 = zw->com.reduce.sel;
    zw->com.reduce.sel = NULL;
    zw->com.reduce.select = NULL;
    zw->com.reduce.prozanz = proz_anz;
    code_ausgeben(err,zw1);
    if (zw2 && (sx1 != sx2))
    { parallel_string_ausgeben(err); }
    zeilennummer(err);
    fprintf(ausDatei,"IF ");
    variable_ausgeben(zw->com.reduce.bool, DIRECT);
    fprintf(ausDatei," CALL %d;",keine_prozessoren);
    zw->link = zw3;
  }
  selection_exit = se;
  if (zw->com.reduce.scop)
    zw->com.reduce.scop->bis = linenr;
}


out_dyn(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.dyn.select);
  zeilennummer(err);
  fprintf(ausDatei,"IF ");
  variable_ausgeben(zw->com.dyn.var,zw->com.dyn.var->dir_indir);
  fprintf(ausDatei," CALL %d;",linenr + 1);
  zeilennummer(err);
  fprintf(ausDatei,"GOTO %d;",selection_exit--);
  zeilennummer(err);
  fprintf(ausDatei,"PROC %d;",proc_ebene + 1);
  if (zw->com.dyn.next != NULL)
    code_ausgeben(err,zw->com.dyn.next);
  else
    statements_ausgeben(zw->com.dyn.stat);
  zeilennummer(err);
  fprintf(ausDatei,"RETURN;");
}


out_zugriff(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ int basis = (zw->com.zugriff.var == zw->com.zugriff.basis);
  VARNODE * vx;
  if (zw->com.zugriff.comp != NULL)
  { expr_berechnen(err,zw->com.zugriff.comp);
    if (zw->com.zugriff.neg)
    { zeilennummer(err);
      variable_ausgeben(zw->com.zugriff.var,DIRECT);
      fprintf(ausDatei," := ");
      if (basis)
        variable_ausgeben(zw->com.zugriff.var,zw->com.zugriff.dir_indir);
      else
        variable_ausgeben(zw->com.zugriff.basis,ADRESS);
      basis = 1;
      fprintf(ausDatei," - SIZE(");
      zeilenfuellung = 1;
      indent_tab = "\t\t\t";
      neg_offset(zw->com.zugriff.comp,1);
      fprintf(ausDatei," );");
    }
    if (zw->com.zugriff.pos)
    { zeilennummer(err);
      variable_ausgeben(zw->com.zugriff.var,DIRECT);
      fprintf(ausDatei," := ");
      if (basis)
        variable_ausgeben(zw->com.zugriff.var,zw->com.zugriff.dir_indir);
      else
        variable_ausgeben(zw->com.zugriff.basis,ADRESS);
      basis = 1;
      fprintf(ausDatei," + SIZE(");
      zeilenfuellung = 1;
      indent_tab = "\t\t\t";
      pos_offset(zw->com.zugriff.comp,1);
      fprintf(ausDatei," );");
    }
    if (zw->com.zugriff.arr)
    { expr_offset(err,zw->com.zugriff.comp,zw->com.zugriff.var,
                  zw->com.zugriff.basis,&basis);
    }
    if (basis)
      vx = NULL;
    else
      vx = zw->com.zugriff.basis;
    pointer_offset(zw->com.zugriff.comp,err,&vx);
    basis = (vx == NULL);
  }
}


out_recoffset(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.recoff.code);
  zeilennummer(err);
  zw->com.recoff.var->firstelem = zw->com.recoff.firstelem;
  variable_ausgeben(zw->com.recoff.var,DIRECT);
  fprintf(ausDatei," := ");
  variable_ausgeben(zw->com.recoff.basis,ADRESS);
  fprintf(ausDatei," + SIZE(");
  record_offset(zw->com.recoff.typ,zw->com.recoff.offset);
  fprintf(ausDatei," );");
}


out_arroffset(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.arroff.code);
  zeilennummer(err);
  zw->com.arroff.var->firstelem = zw->com.arroff.firstelem;
  variable_ausgeben(zw->com.arroff.var,DIRECT);
  fprintf(ausDatei," := ");
  if (zw->com.arroff.erst)
  { variable_ausgeben(zw->com.arroff.basis,ADRESS);
/*                      (zw->com.arroff.basis->dir_indir == INDIRECT) ? DIRECT
                                                                    : ADRESS);*/
  }
  else
  { variable_ausgeben(zw->com.arroff.var,DIRECT); }
  fprintf(ausDatei," + SIZE(");
  indent_tab = "\t\t\t";
  typdef_ausgeben(ausDatei,zw->com.arroff.typ,1l);
  fprintf(ausDatei," );");
}


out_in(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.setin.ex1);
  code_ausgeben(err,zw->com.setin.ex2);
  if (zw->com.setin.mode)
  { VARNODE var;
    var = *zw->com.setin.op1;
    zeilennummer(err);
    variable_ausgeben(zw->com.setin.help,DIRECT);
    fprintf(ausDatei," := ");
    variable_ausgeben(zw->com.setin.op1,zw->com.setin.op1->dir_indir);
    fprintf(ausDatei,";");
    var = *zw->com.setin.help;
    var.dir_indir = DIRECT;
    if (zw->com.setin.von != 0)
    { zeilennummer(err);
      variable_ausgeben(zw->com.setin.help,DIRECT);
      fprintf(ausDatei," := ");
      variable_ausgeben(zw->com.setin.help,DIRECT);
      fprintf(ausDatei," %c %d;",(zw->com.setin.von > 0) ? '-' : '+',
                                (zw->com.setin.von > 0) ? zw->com.setin.von
                                                        : -zw->com.setin.von);
    }
    if (zw->com.setin.boolhelp)
    { zeilennummer(err);
      variable_ausgeben(zw->com.setin.boolhelp,DIRECT);
      fprintf(ausDatei," := TRUE;");
      zeilennummer(err);
      fprintf(ausDatei,"IF 0 > ");
      variable_ausgeben(&var,var.dir_indir);
      fprintf(ausDatei," CALL %d;",linenr + 3);
      zeilennummer(err);
      fprintf(ausDatei,"IF ");
      variable_ausgeben(&var,var.dir_indir);
      fprintf(ausDatei," > %d CALL %d;",zw->com.setin.bis,linenr + 2);
      zeilennummer(err);
      fprintf(ausDatei,"IF ");
      variable_ausgeben(zw->com.setin.boolhelp,DIRECT);
      fprintf(ausDatei," CALL %d;",linenr + 5);
      zeilennummer(err);
      fprintf(ausDatei,"GOTO %d;",linenr + 9);
      zeilennummer(err);
      fprintf(ausDatei,"PROC %d;",proc_ebene + 1);
      zeilennummer(err);
      variable_ausgeben(zw->com.setin.boolhelp,DIRECT);
      fprintf(ausDatei," := FALSE;");
      zeilennummer(err);
      variable_ausgeben(zw->com.setin.erg,zw->com.setin.erg->dir_indir);
      fprintf(ausDatei," := FALSE;");
      zeilennummer(err);
      fprintf(ausDatei,"RETURN;");
      zeilennummer(err);
      fprintf(ausDatei,"PROC %d;",proc_ebene + 1);
    }
    else
    { zeilennummer(err);
      fprintf(ausDatei,"IF 0 > ");
      variable_ausgeben(&var,var.dir_indir);
      fprintf(ausDatei," GOTO %d;",linenr + 5);
      zeilennummer(err);
      fprintf(ausDatei,"IF ");
      variable_ausgeben(&var,var.dir_indir);
      fprintf(ausDatei," > %d GOTO %d;",zw->com.setin.bis,linenr + 4);
    }
    zeilennummer(err);
    variable_ausgeben(zw->com.setin.help,DIRECT);
    fprintf(ausDatei," := ");
    variable_ausgeben(&var,var.dir_indir);
    fprintf(ausDatei," * SIZE( B1 );");
    zeilennummer(err);
    variable_ausgeben(zw->com.setin.help,DIRECT);
    fprintf(ausDatei," := ");
    variable_ausgeben(zw->com.setin.op2,ADRESS);
    fprintf(ausDatei," + ");
    variable_ausgeben(zw->com.setin.help,DIRECT);
    fprintf(ausDatei,";");
    zeilennummer(err);
    variable_ausgeben(zw->com.setin.erg,zw->com.setin.erg->dir_indir);
    fprintf(ausDatei," := ");
    variable_ausgeben(zw->com.setin.help,INDIRECT);
    fprintf(ausDatei,";");
    if (zw->com.setin.boolhelp)
    { zeilennummer(err);
      fprintf(ausDatei,"RETURN;");
    }
    else
    { zeilennummer(err);
      fprintf(ausDatei,"GOTO %d;",linenr + 1);
      zeilennummer(err);
      variable_ausgeben(zw->com.setin.erg,zw->com.setin.erg->dir_indir);
      fprintf(ausDatei," := FALSE;");
    }  
  }
  else
  { if (zw->com.setin.op1 != NULL)
    { VARNODE var;
      var = *zw->com.setin.op1;
      if (zw->com.setin.von != 0)
      { zeilennummer(err);
        variable_ausgeben(zw->com.setin.help,DIRECT);
        fprintf(ausDatei," := ");
        variable_ausgeben(zw->com.setin.op1,zw->com.setin.op1->dir_indir);
        fprintf(ausDatei," %c %d;",(zw->com.setin.von > 0) ? '-' : '+',
                                  (zw->com.setin.von > 0) ? zw->com.setin.von
                                                          : -zw->com.setin.von);
        var = *zw->com.setin.help;
        var.dir_indir = DIRECT;
      }
      if (zw->com.setin.boolhelp)
      { zeilennummer(err);
        variable_ausgeben(zw->com.setin.boolhelp,DIRECT);
        fprintf(ausDatei," := TRUE;");
        zeilennummer(err);
        fprintf(ausDatei,"IF 0 > ");
        variable_ausgeben(&var,var.dir_indir);
        fprintf(ausDatei," CALL %d;",linenr + 3);
        zeilennummer(err);
        fprintf(ausDatei,"IF ");
        variable_ausgeben(&var,var.dir_indir);
        fprintf(ausDatei," > %d CALL %d;",zw->com.setin.bis,linenr + 2);
        zeilennummer(err);
        fprintf(ausDatei,"IF ");
        variable_ausgeben(zw->com.setin.boolhelp,DIRECT);
        fprintf(ausDatei," CALL %d;",linenr + 5);
        zeilennummer(err);
        fprintf(ausDatei,"GOTO %d;",linenr + 9);
        zeilennummer(err);
        fprintf(ausDatei,"PROC %d;",proc_ebene + 1);
        zeilennummer(err);
        variable_ausgeben(zw->com.setin.boolhelp,DIRECT);
        fprintf(ausDatei," := FALSE;");
        zeilennummer(err);
        variable_ausgeben(zw->com.setin.erg,zw->com.setin.erg->dir_indir);
        fprintf(ausDatei," := FALSE;");
        zeilennummer(err);
        fprintf(ausDatei,"RETURN;");
        zeilennummer(err);
        fprintf(ausDatei,"PROC %d;",proc_ebene + 1);
      }
      else
      { zeilennummer(err);
        fprintf(ausDatei,"IF 0 > ");
        variable_ausgeben(&var,var.dir_indir);
        fprintf(ausDatei," GOTO %d;",linenr + 5);
        zeilennummer(err);
        fprintf(ausDatei,"IF ");
        variable_ausgeben(&var,var.dir_indir);
        fprintf(ausDatei," > %d GOTO %d;",zw->com.setin.bis,linenr + 4);
      }
      zeilennummer(err);
      variable_ausgeben(zw->com.setin.help,DIRECT);
      fprintf(ausDatei," := ");
      variable_ausgeben(&var,var.dir_indir);
      fprintf(ausDatei," * SIZE( B1 );");
      zeilennummer(err);
      variable_ausgeben(zw->com.setin.help,DIRECT);
      fprintf(ausDatei," := ");
      variable_ausgeben(zw->com.setin.op2,ADRESS);
      fprintf(ausDatei," + ");
      variable_ausgeben(zw->com.setin.help,DIRECT);
      fprintf(ausDatei,";");
      zeilennummer(err);
      variable_ausgeben(zw->com.setin.erg,zw->com.setin.erg->dir_indir);
      fprintf(ausDatei," := ");
      variable_ausgeben(zw->com.setin.help,INDIRECT);
      fprintf(ausDatei,";");
      if (zw->com.setin.boolhelp)
      { zeilennummer(err);
        fprintf(ausDatei,"RETURN;");
      }
      else
      { zeilennummer(err);
        fprintf(ausDatei,"GOTO %d;",linenr + 1);
        zeilennummer(err);
        variable_ausgeben(zw->com.setin.erg,zw->com.setin.erg->dir_indir);
        fprintf(ausDatei," := FALSE;");
      }  
    }
    else
    { if (zw->com.setin.nummer != 0)
      { zeilennummer(err);
        variable_ausgeben(zw->com.setin.help,DIRECT);
        fprintf(ausDatei,"  := %d * SIZE( B1 );",(zw->com.setin.nummer > 0) ?
                                                 zw->com.setin.nummer :
                                                 -zw->com.setin.nummer);
        zeilennummer(err);
        variable_ausgeben(zw->com.setin.help,DIRECT);
        fprintf(ausDatei," := ");
        variable_ausgeben(zw->com.setin.op2,ADRESS);
        fprintf(ausDatei," %c ",(zw->com.setin.nummer > 0) ? '+' : '-');
        variable_ausgeben(zw->com.setin.help,DIRECT);
        fprintf(ausDatei,";");
      }
      zeilennummer(err);
      variable_ausgeben(zw->com.setin.erg,zw->com.setin.erg->dir_indir);
      fprintf(ausDatei," := ");
      if (zw->com.setin.nummer != 0)
        variable_ausgeben(zw->com.setin.help,INDIRECT);
      else
        variable_ausgeben(zw->com.setin.op2,zw->com.setin.op2->dir_indir);
      fprintf(ausDatei,";");
    }
  }
}


out_strcmp(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.strcmp.ex1);
  code_ausgeben(err,zw->com.strcmp.ex2);
  zeilennummer(err);
  variable_ausgeben(zw->com.strcmp.erg,zw->com.strcmp.erg->dir_indir);
  fprintf(ausDatei," := STRCMP ");
  variable_ausgeben(zw->com.strcmp.op1,zw->com.strcmp.op1->dir_indir);
  fprintf(ausDatei," ");
  variable_ausgeben(zw->com.strcmp.op2,zw->com.strcmp.op2->dir_indir);
  fprintf(ausDatei,";");
  if (zw->com.strcmp.help != NULL)
  { zeilennummer(err);
    variable_ausgeben(zw->com.strcmp.help,zw->com.strcmp.help->dir_indir);
    fprintf(ausDatei," := ");
    variable_ausgeben(zw->com.strcmp.erg,zw->com.strcmp.erg->dir_indir);
    fprintf(ausDatei,";");
    zeilennummer(err);
    variable_ausgeben(zw->com.strcmp.help,zw->com.strcmp.help->dir_indir);
    fprintf(ausDatei," := NOT ");
    variable_ausgeben(zw->com.strcmp.help,zw->com.strcmp.help->dir_indir);
    fprintf(ausDatei,";");
  }
}


out_setexcl(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.setexcl.ex1);
  code_ausgeben(err,zw->com.setexcl.ex2);
  if (zw->com.setexcl.help == NULL)
  { zeilennummer(err);
    variable_ausgeben(zw->com.setexcl.set,zw->com.setexcl.set->dir_indir);
    fprintf(ausDatei," := %s;",(zw->com.setexcl.mode & 1) ? "TRUE" : "FALSE");
  }
  else
  { int bas = 0;
    if (zw->com.setexcl.mode & 2)
    { zeilennummer(err);
      variable_ausgeben(zw->com.setexcl.help,DIRECT);
      fprintf(ausDatei," := ");
      variable_ausgeben(zw->com.setexcl.wert,zw->com.setexcl.wert->dir_indir);
      fprintf(ausDatei,";");
      bas = 1;
    }
    if ((zw->com.setexcl.wert != NULL) && (zw->com.setexcl.off != 0))
    { zeilennummer(err);
      variable_ausgeben(zw->com.setexcl.help,DIRECT);
      fprintf(ausDatei," := ");
      if (bas)
        variable_ausgeben(zw->com.setexcl.help,DIRECT);
      else
        variable_ausgeben(zw->com.setexcl.wert,zw->com.setexcl.wert->dir_indir);
      if (zw->com.setexcl.off < 0)
        fprintf(ausDatei," - %d;",-zw->com.setexcl.off);
      else
        fprintf(ausDatei," + %d;",zw->com.setexcl.off);
      bas = 1;
    }
    if (zw->com.setexcl.wert != NULL)
    { zeilennummer(err);
      variable_ausgeben(zw->com.setexcl.help,DIRECT);
      fprintf(ausDatei," := ");
      if (bas)
        variable_ausgeben(zw->com.setexcl.help,DIRECT);
      else
        variable_ausgeben(zw->com.setexcl.wert,zw->com.setexcl.wert->dir_indir);
      fprintf(ausDatei," * SIZE( B1 );");
      bas = 1;
    }
    zeilennummer(err);
    variable_ausgeben(zw->com.setexcl.help,DIRECT);
    fprintf(ausDatei," := ");
    variable_ausgeben(zw->com.setexcl.set,ADRESS);
    if (bas)
    { fprintf(ausDatei," + ");
      variable_ausgeben(zw->com.setexcl.help,DIRECT);
      fprintf(ausDatei,";");
    }
    else
    { if (zw->com.setexcl.off < 0)
        fprintf(ausDatei," - SIZE( B%d );",-zw->com.setexcl.off);
      else
        fprintf(ausDatei," + SIZE( B%d );",zw->com.setexcl.off);
    }
    zeilennummer(err);
    variable_ausgeben(zw->com.setexcl.help,INDIRECT);
    fprintf(ausDatei," := %s;",(zw->com.setexcl.mode & 1) ? "TRUE" : "FALSE");
  }
}


out_dimsel(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ if (zw->com.dimsel.hv2 != NULL)
  { code_ausgeben(err,zw->com.dimsel.ex1);
    code_ausgeben(err,zw->com.dimsel.ex2);
    zeilennummer(err);
    variable_ausgeben(zw->com.dimsel.hv1,DIRECT);
    fprintf(ausDatei," := ");
    if (zw->com.dimsel.von)
      variable_ausgeben(zw->com.dimsel.von,zw->com.dimsel.von->dir_indir);
    else
    { char_string = 0;
      konstante_ausgeben(zw->com.dimsel.co1);
    }
    fprintf(ausDatei," <= ");
    variable_ausgeben(zw->com.dimsel.dim,DIRECT);
    fprintf(ausDatei,";");
    zeilennummer(err);
    variable_ausgeben(zw->com.dimsel.hv2,DIRECT);
    fprintf(ausDatei," := ");
    variable_ausgeben(zw->com.dimsel.dim,DIRECT);
    fprintf(ausDatei," <= ");
    if (zw->com.dimsel.bis)
      variable_ausgeben(zw->com.dimsel.bis,zw->com.dimsel.bis->dir_indir);
    else
    { char_string = 0;
      konstante_ausgeben(zw->com.dimsel.co2);
    }
    fprintf(ausDatei,";");
    zeilennummer(err);
    variable_ausgeben(zw->com.dimsel.hv1,DIRECT);
    fprintf(ausDatei," := ");
    variable_ausgeben(zw->com.dimsel.hv1,DIRECT);
    fprintf(ausDatei," AND ");
    variable_ausgeben(zw->com.dimsel.hv2,DIRECT);
  }
  else
  { code_ausgeben(err,zw->com.dimsel.ex2);
    zeilennummer(err);
    variable_ausgeben(zw->com.dimsel.hv1,DIRECT);
    fprintf(ausDatei," := ");
    if (zw->com.dimsel.bis)
      variable_ausgeben(zw->com.dimsel.bis,zw->com.dimsel.bis->dir_indir);
    else
    { char_string = 0;
      konstante_ausgeben(zw->com.dimsel.co2);
    }
    fprintf(ausDatei," = ");
    variable_ausgeben(zw->com.dimsel.dim,DIRECT);
  }
  fprintf(ausDatei,";");
}


out_math(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.math.expr);
  if (divisionstest)
  { switch (zw->com.math.ftyp)
    { case PROC_LN :
        zeilennummer(err);
        fprintf(ausDatei,"IF ");
        variable_ausgeben(zw->com.math.var,zw->com.math.var->dir_indir);
        fprintf(ausDatei," <= 0.0 CALL %d;",bereich_fehler);
        break;
      case PROC_SQRT :
        zeilennummer(err);
        fprintf(ausDatei,"IF ");
        variable_ausgeben(zw->com.math.var,zw->com.math.var->dir_indir);
        fprintf(ausDatei," < 0.0 CALL %d;",bereich_fehler);
        break;
      case PROC_ARCCOS :
      case PROC_ARCSIN :
        zeilennummer(err);
        variable_ausgeben(zw->com.math.help,DIRECT); 
        fprintf(ausDatei," := -1.0;");
        zeilennummer(err);
        fprintf(ausDatei,"IF ");
        variable_ausgeben(zw->com.math.var,zw->com.math.var->dir_indir);
        fprintf(ausDatei," > 1.0 CALL %d;",bereich_fehler);
        zeilennummer(err);
        fprintf(ausDatei,"IF ");
        variable_ausgeben(zw->com.math.var,zw->com.math.var->dir_indir);
        fprintf(ausDatei," < ");
        variable_ausgeben(zw->com.math.help,DIRECT); 
        fprintf(ausDatei," CALL %d;",bereich_fehler);
        break;
    }
  }
  zeilennummer(err);
  variable_ausgeben(zw->com.math.erg,zw->com.math.erg->dir_indir);
  fprintf(ausDatei," := %s ",funktionsname(zw->com.math.ftyp));
  variable_ausgeben(zw->com.math.var,zw->com.math.var->dir_indir);
  fprintf(ausDatei,";");
}


out_arctan2(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.arctan2.expr1);
  code_ausgeben(err,zw->com.arctan2.expr2);
  if (divisionstest && zw->com.arctan2.var2)
  { zeilennummer(err);
    fprintf(ausDatei,"IF ");
    variable_ausgeben(zw->com.arctan2.var2,zw->com.arctan2.var2->dir_indir);
    fprintf(ausDatei," = 0.0 CALL %d;",divisions_fehler);
  }
  zeilennummer(err);
  variable_ausgeben(zw->com.arctan2.erg,zw->com.arctan2.erg->dir_indir);
  fprintf(ausDatei," := ARCTANT ");
  if (zw->com.arctan2.var1)
    variable_ausgeben(zw->com.arctan2.var1,zw->com.arctan2.var1->dir_indir);
  else
    konstante_ausgeben(zw->com.arctan2.con);
  fprintf(ausDatei," ");
  if (zw->com.arctan2.var2)
    variable_ausgeben(zw->com.arctan2.var2,zw->com.arctan2.var2->dir_indir);
  else
    konstante_ausgeben(zw->com.arctan2.con);
  fprintf(ausDatei,";");
}


out_zuweis(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.zuweis.erg);
  code_ausgeben(err,zw->com.zuweis.op);
}


out_param(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.param.link);
  code_ausgeben(err,zw->com.param.code);
  if (zw->com.param.tpar)
  { zeilennummer(err);
    fprintf(ausDatei,"MOVE ");
    variable_ausgeben(zw->com.param.tpar,zw->com.param.tpar->dir_indir);
    fprintf(ausDatei," TO ");
    variable_ausgeben(zw->com.param.par,zw->com.param.par->dir_indir);
    zeilenfuellung = 1;
    fprintf(ausDatei," AS");
    indent_tab = "\t\t\t";
    typdef_ausgeben(ausDatei,zw->com.param.ttyp,1l);
    fprintf(ausDatei,";");
  }
  zeilennummer(err);
  fprintf(ausDatei,"PUSH%c ",(zw->com.param.scavec == 0) ? 'S' : 'V');
  variable_ausgeben(zw->com.param.par,(zw->com.param.mode == ERG_SPEC)? ADRESS
                                       :zw->com.param.par->dir_indir);
  fprintf(ausDatei,";");
}


#ifndef PC
/* open file */


out_paramco(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.param.link);
  zeilennummer(err);
  fprintf(ausDatei,"PUSH%c ",(zw->com.param.scavec == 0) ? 'S' : 'V');
  char_string = 0;
  konstante_ausgeben(zw->com.param.Const);
  fprintf(ausDatei,";");
}


out_constsel(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ int nl,i;
  C_GROUP * g;
  char * s;
  zeilennummer(err);
  fprintf(ausDatei,"CALL %d;",zw->com.Constsel.conf->initdim);
  if (with_scope)
    with_scope->entry = with_scope->von = linenr;
  if ((s = zw->com.Constsel.string) &&
      strchr(s,'0'))
  { zeilennummer(err);
    g = get_group(zw->com.Constsel.conf->conf_nr);
    nl = 0;
    fprintf(ausDatei,"PARALLEL\t");
    for (i = 0; i < g->first_proz; i++)
    { if (nl == 50)
      { fprintf(ausDatei,"\n\t\t\t\t");
        nl = 0;
      }
      fprintf(ausDatei,"0");
      nl++;
    }
    for (i = 0; i < g->proz_anz; i++)
    { if (nl == 50)
      { fprintf(ausDatei,"\n\t\t\t\t");
        nl = 0;
      }
      fprintf(ausDatei,"%c",*s++);
      nl++;
    }
    for (i = g->first_proz + g->proz_anz; i < proz_anz; i++)
    { if (nl == 50)
      { fprintf(ausDatei,"\n\t\t\t\t");
        nl = 0;
      }
      fprintf(ausDatei,"0");
      nl++;
    }
    fprintf(ausDatei,";");
  }
  else
  { if (!s)
      selection_exit++;
  }
}


out_proccall(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.proc.param);
  zeilennummer(err);
  fprintf(ausDatei,"CALL %d; %s",zw->com.proc.proc->param.proz.posnr + normal_basis,
                                 getstring(zw->com.proc.proc->name_nr));
  code_ausgeben(err,zw->com.proc.nach);
}


out_ifthen(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ int next_statement;
  if (zw->com.ifthen.scavec == 0)
  { next_statement = zw->com.ifthen.size + linenr;
    code_ausgeben(err,zw->com.ifthen.expr);
    zeilennummer(err);
    fprintf(ausDatei,"IF ");
    variable_ausgeben(zw->com.ifthen.bool,zw->com.ifthen.bool->dir_indir);
    fprintf(ausDatei," = FALSE GOTO %d;",linenr + zw->com.ifthen.cont);
    statements_ausgeben(zw->com.ifthen.stat);
    if (zw->com.ifthen.elsif != NULL)
    { zeilennummer(err);
      fprintf(ausDatei,"GOTO %d;",next_statement);
      code_ausgeben(err,zw->com.ifthen.elsif);
    }
    else
    { if (zw->com.ifthen.elsest != NULL)
      { zeilennummer(err);
        fprintf(ausDatei,"GOTO %d;",next_statement);
      }
      statements_ausgeben(zw->com.ifthen.elsest);
    }
  }
  else
  { int z;
    if (zw->com.ifthen.plus == 1)
    { code_ausgeben(err,zw->com.ifthen.expr);
      zeilennummer(err);
      variable_ausgeben(zw->com.ifthen.main,DIRECT);
      fprintf(ausDatei," := TRUE;");
      zeilennummer(err);
      fprintf(ausDatei,"IF ");
      variable_ausgeben(zw->com.ifthen.bool,zw->com.ifthen.bool->dir_indir);
      if (zw->com.ifthen.elsif != NULL)
      { z = zw->com.ifthen.elsif->com.ifthen.size; }
      else
      { if (zw->com.ifthen.elsest != NULL)
        { z = statement_lines(zw->com.ifthen.elsest) + 4; }
        else
        { z = 1; }
      }
      fprintf(ausDatei," CALL %d;",linenr + z);
    }
    else
    { if (zw->com.ifthen.main)
      { zeilennummer(err);
        fprintf(ausDatei,"IF ");
        variable_ausgeben(zw->com.ifthen.main,DIRECT);
        if (zw->com.ifthen.elsif != NULL)
        { z = zw->com.ifthen.elsif->com.ifthen.size; }
        else
        { if (zw->com.ifthen.elsest != NULL)
          { z = statement_lines(zw->com.ifthen.elsest) + 4; }
          else
          { z = 1; }
        }
        fprintf(ausDatei," CALL %d;",linenr + z);
      }
      else
      { code_ausgeben(err,zw->com.ifthen.expr);
        zeilennummer(err);
        fprintf(ausDatei,"IF ");
        variable_ausgeben(zw->com.ifthen.bool,zw->com.ifthen.bool->dir_indir);
        if (zw->com.ifthen.elsif != NULL)
        { z = zw->com.ifthen.elsif->com.ifthen.size; }
        else
        { if (zw->com.ifthen.elsest != NULL)
          { z = statement_lines(zw->com.ifthen.elsest) + 4; }
          else
          { z = 1; }
        }
        fprintf(ausDatei," CALL %d;",linenr + z);
      }
    }
    code_ausgeben(err,zw->com.ifthen.elsif);
    if (zw->com.ifthen.elsest != NULL)
    { zeilennummer(err);
      fprintf(ausDatei,"IF ");
      variable_ausgeben(zw->com.ifthen.main,DIRECT);
      fprintf(ausDatei," CALL %d;",linenr + 1);
      zeilennummer(err);
      fprintf(ausDatei,"GOTO %d;",zw->com.ifthen.cont + linenr);
      zeilennummer(err);
      fprintf(ausDatei,"PROC %d;",proc_ebene + 1);
      statements_ausgeben(zw->com.ifthen.elsest);
      zeilennummer(err);
      fprintf(ausDatei,"RETURN;");
    }
    else
    { if (zw->com.ifthen.elsif == NULL)
      { zeilennummer(err);
        fprintf(ausDatei,"GOTO %d;",zw->com.ifthen.cont + linenr);
      }
    }
    if (!zw->com.ifthen.plus && zw->com.ifthen.main)
    { zeilennummer(err);
      fprintf(ausDatei,"PROC %d;",proc_ebene + 1);
      code_ausgeben(err,zw->com.ifthen.expr);
      zeilennummer(err);
      fprintf(ausDatei,"IF ");
      variable_ausgeben(zw->com.ifthen.bool,zw->com.ifthen.bool->dir_indir);
      fprintf(ausDatei," CALL %d;",linenr + 1);
      zeilennummer(err);
      fprintf(ausDatei,"RETURN;");
    }
    zeilennummer(err);
    fprintf(ausDatei,"PROC %d;",proc_ebene + 1);
    if ((zw->com.ifthen.elsif != NULL) || (zw->com.ifthen.elsest != NULL))
    { zeilennummer(err);
      variable_ausgeben(zw->com.ifthen.main,DIRECT);
      fprintf(ausDatei," := FALSE;");
    }
    statements_ausgeben(zw->com.ifthen.stat);
    zeilennummer(err);
    fprintf(ausDatei,"RETURN;");
  }
}


out_while(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ if (zw->com.whiledo.scavec == 0)
  { int z, ns, akt_z, z1;
    char t[MAX_EXPR_LENGTH + 1];
    LINENR * l;
    strcpy(t,text3);
    ns = neues_statement;
    neues_statement = 0;
    akt_z = aktuelle_zeile;
    zeilennummer(err);
    z = linenr;
    fprintf(ausDatei,"GOTO %d;",statement_lines(zw->com.whiledo.stat) + linenr);
    if (ns)
    { GET_MEM(l,1,LINENR);
      l->link = all_lines;
      all_lines = l;
    }
    statements_ausgeben(zw->com.whiledo.stat);
    neues_statement = ns;
    aktuelle_zeile = akt_z;
    strcpy(comment2,t);
    z1 = linenr;
    code_ausgeben(err,zw->com.whiledo.expr);
    zeilennummer(err);
    fprintf(ausDatei,"IF ");
    variable_ausgeben(zw->com.whiledo.bool,zw->com.whiledo.bool->dir_indir);
    fprintf(ausDatei," GOTO %d;",z);
    if (ns)
    { l->source = aktuelle_zeile;
      l->drain = z1;
      l->next = linenr;
    }
  }
  else
  { int z;
    z = linenr;
    code_ausgeben(err,zw->com.whiledo.expr);
    if (z == linenr)
    { zeilennummer(err);
      fprintf(ausDatei,"WHILE ");
      variable_ausgeben(zw->com.whiledo.bool,zw->com.whiledo.bool->dir_indir);
      fprintf(ausDatei," CALL %d;",linenr + 1);
      zeilennummer(err);
      fprintf(ausDatei,"GOTO %d;",linenr + 2 +
                                  statement_lines(zw->com.whiledo.stat));
    }
    else
    { zeilennummer(err);
      variable_ausgeben(zw->com.whiledo.sbool,DIRECT);
      fprintf(ausDatei," := REDUCE MAX OF ");
      variable_ausgeben(zw->com.whiledo.bool,zw->com.whiledo.bool->dir_indir);
      fprintf(ausDatei,";");
      zeilennummer(err);
      fprintf(ausDatei,"IF ");
      variable_ausgeben(zw->com.whiledo.sbool,DIRECT);
      fprintf(ausDatei," = FALSE GOTO %d;",linenr + 4 +
                                           statement_lines(zw->com.whiledo.stat));
      zeilennummer(err);
      fprintf(ausDatei,"IF ");
      variable_ausgeben(zw->com.whiledo.bool,zw->com.whiledo.bool->dir_indir);
      fprintf(ausDatei," CALL %d;",linenr + 1);
      zeilennummer(err);
      fprintf(ausDatei,"GOTO %d;",z);
    }
    zeilennummer(err);
    fprintf(ausDatei,"PROC %d;",proc_ebene + 1);
    statements_ausgeben(zw->com.whiledo.stat);
    zeilennummer(err);
    fprintf(ausDatei,"RETURN;");
  }
}


out_repeat(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ LINENR * l;
  if (zw->com.repeat.scavec == 0)
  { int z, akt_z;
    char t[MAX_EXPR_LENGTH + 1];
    t[0] = '\0';
    akt_z = aktuelle_zeile;
    strcpy(t,text3);
    z = linenr;
    statements_ausgeben(zw->com.repeat.stat);
    aktuelle_zeile = akt_z;
    if (z != linenr)
    { neues_statement = 1;
      strcpy(comment2,t);
    }
    GET_MEM(l,1,LINENR);
    l->link = all_lines;
    all_lines = l;
    l->source = zw->com.repeat.untilex;
    l->drain = linenr;
    code_ausgeben(err,zw->com.repeat.expr);
    zeilennummer(err);
    fprintf(ausDatei,"IF ");
    variable_ausgeben(zw->com.repeat.bool,zw->com.repeat.bool->dir_indir);
    fprintf(ausDatei," = FALSE GOTO %d;",z);
    l->next = linenr;
  }
  else
  { int z, akt_z;
    char t[MAX_EXPR_LENGTH + 1];
    t[0] = '\0';
    strcpy(t,text3);
    akt_z = aktuelle_zeile;
    zeilennummer(err);
    fprintf(ausDatei,"CALL %d;",linenr + zw->com.repeat.lines + 4);
    z = linenr;
    neues_statement = 1;
    aktuelle_zeile = akt_z;
    strcpy(comment2,t);
    code_ausgeben(err,zw->com.repeat.expr);
    zeilennummer(err);
    variable_ausgeben(zw->com.repeat.sbool,DIRECT);
    fprintf(ausDatei," := REDUCE MIN OF ");
    variable_ausgeben(zw->com.repeat.bool,zw->com.repeat.bool->dir_indir);
    fprintf(ausDatei,";");
    zeilennummer(err);
    fprintf(ausDatei,"IF ");
    variable_ausgeben(zw->com.repeat.sbool,DIRECT);
    fprintf(ausDatei," GOTO %d;",linenr + 4 +
                                           statement_lines(zw->com.repeat.stat));
    zeilennummer(err);
    fprintf(ausDatei,"IF ");
    variable_ausgeben(zw->com.repeat.bool,zw->com.repeat.bool->dir_indir);
    fprintf(ausDatei," = FALSE CALL %d;",linenr + 1);
    zeilennummer(err);
    fprintf(ausDatei,"GOTO %d;",z);
    zeilennummer(err);
    fprintf(ausDatei,"PROC %d;",proc_ebene + 1);
    GET_MEM(l,1,LINENR);
    l->link = all_lines;
    all_lines = l;
    statements_ausgeben(zw->com.repeat.stat);
    zeilennummer(err);
    fprintf(ausDatei,"RETURN;");
    l->source = zw->com.repeat.untilex;
    l->drain = z;
    l->next = linenr;
  }
}


out_loop(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ int mem,z;
  mem = loop_exit;
  loop_exit = statement_lines(zw->com.loop) + 1 + linenr;
  z = linenr;
  statements_ausgeben(zw->com.loop);
  zeilennummer(err);
  fprintf(ausDatei,"GOTO %d;",z);
  loop_exit = mem;
}


out_for(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ int mode, z, akt_z;
  char t[MAX_EXPR_LENGTH + 1];
  LINENR * l;
  t[0] = '\0';
  strcpy(t,text3);
  akt_z = aktuelle_zeile;
  mode = zw->com.forto.mode;
  code_ausgeben(err,zw->com.forto.ex1);
  code_ausgeben(err,zw->com.forto.ex2);
  z = linenr;
  aktuelle_zeile = akt_z;
  neues_statement = 1;
  strcpy(comment2,t);
  zeilennummer(err);
  GET_MEM(l,1,LINENR);
  l->link = all_lines;
  all_lines = l;
  if ((mode & 1) == 0)
  { fprintf(ausDatei,"IF ");
    variable_ausgeben(zw->com.forto.lauf,DIRECT);
    if ((mode & 2) == 0)
    { fprintf(ausDatei," > "); }
    else
    { fprintf(ausDatei," < "); }
    if (zw->com.forto.bis)
      variable_ausgeben(zw->com.forto.bis,zw->com.forto.bis->dir_indir);
    else
    { char_string = 0;
      konstante_ausgeben(zw->com.forto.bisc);
    }
    fprintf(ausDatei," GOTO %d;",statement_lines(zw->com.forto.stat) +
                                   linenr + 2 +
                                   ((zw->com.forto.temp != zw->com.forto.lauf)
                                    ? 2 : 0));
    statements_ausgeben(zw->com.forto.stat);
    if (zw->com.forto.temp != zw->com.forto.lauf)
    { zeilennummer(err);
      variable_ausgeben(zw->com.forto.temp,DIRECT);
      fprintf(ausDatei," := ");
      variable_ausgeben(zw->com.forto.lauf,DIRECT);
      fprintf(ausDatei,";");
    }
    zeilennummer(err);
    variable_ausgeben(zw->com.forto.temp,DIRECT);
    fprintf(ausDatei," := ");
    variable_ausgeben(zw->com.forto.temp,DIRECT);
    if ((mode & 2) == 0)
    { fprintf(ausDatei," + %d;",zw->com.forto.inc); }
    else
    { fprintf(ausDatei," - %d;",zw->com.forto.inc); }
    if (zw->com.forto.temp != zw->com.forto.lauf)
    { zeilennummer(err);
      variable_ausgeben(zw->com.forto.lauf,DIRECT);
      fprintf(ausDatei," := ");
      variable_ausgeben(zw->com.forto.temp,DIRECT);
      fprintf(ausDatei,";");
    }
    zeilennummer(err);
    fprintf(ausDatei,"GOTO %d;",z);
  }
  else
  { variable_ausgeben(zw->com.forto.vbool,DIRECT);
    fprintf(ausDatei," := ");
    variable_ausgeben(zw->com.forto.lauf,DIRECT);
    if ((mode & 2) == 0)
    { fprintf(ausDatei," <= "); }
    else
    { fprintf(ausDatei," >= "); }
    if (zw->com.forto.bis)
      variable_ausgeben(zw->com.forto.bis,zw->com.forto.bis->dir_indir);
    else
    { char_string = 0;
      konstante_ausgeben(zw->com.forto.bisc);
    }
    fprintf(ausDatei,";");
    zeilennummer(err);
    variable_ausgeben(zw->com.forto.sbool,DIRECT);
    fprintf(ausDatei," := REDUCE MAX OF ");
    variable_ausgeben(zw->com.forto.vbool,DIRECT);
    fprintf(ausDatei,";");
    zeilennummer(err);
    fprintf(ausDatei,"IF ");
    variable_ausgeben(zw->com.forto.sbool,DIRECT);
    fprintf(ausDatei," = FALSE GOTO %d;",statement_lines(zw->com.forto.stat) +
                     linenr + 5 +
                     ((zw->com.forto.temp != zw->com.forto.lauf) ? 2 : 0));
    zeilennummer(err);
    fprintf(ausDatei,"IF ");
    variable_ausgeben(zw->com.forto.vbool,DIRECT);
    fprintf(ausDatei," CALL %d;",linenr + 1);
    zeilennummer(err);
    fprintf(ausDatei,"GOTO %d;",z);
    zeilennummer(err);
    fprintf(ausDatei,"PROC %d;",proc_ebene + 1);
    statements_ausgeben(zw->com.forto.stat);
    if (zw->com.forto.temp != zw->com.forto.lauf)
    { zeilennummer(err);
      variable_ausgeben(zw->com.forto.temp,DIRECT);
      fprintf(ausDatei," := ");
      variable_ausgeben(zw->com.forto.lauf,DIRECT);
      fprintf(ausDatei,";");
    }
    zeilennummer(err);
    variable_ausgeben(zw->com.forto.temp,DIRECT);
    fprintf(ausDatei," := ");
    variable_ausgeben(zw->com.forto.temp,DIRECT);
    if ((mode & 2) == 0)
    { fprintf(ausDatei," + %d;",zw->com.forto.inc); }
    else
    { fprintf(ausDatei," - %d;",zw->com.forto.inc); }
    if (zw->com.forto.temp != zw->com.forto.lauf)
    { zeilennummer(err);
      variable_ausgeben(zw->com.forto.lauf,DIRECT);
      fprintf(ausDatei," := ");
      variable_ausgeben(zw->com.forto.temp,DIRECT);
      fprintf(ausDatei,";");
    }
    zeilennummer(err);
    fprintf(ausDatei,"RETURN;");
  }
  l->source = akt_z;
  l->drain = z;
  l->next = linenr;
}


out_case(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ int zeilen, all;
  zeilen = linenr + zw->com.cases.zeilen;
  all = linenr + zw->com.cases.all;
  code_ausgeben(err,zw->com.cases.expr);
  if (zw->com.cases.first == 1)
  { zeilennummer(err);
    variable_ausgeben(zw->com.cases.var,DIRECT);
    fprintf(ausDatei," := FALSE;");
  }
  code_ausgeben(err,zw->com.cases.sel);
  if (zw->com.cases.var && (zw->com.cases.first < 2))
  { zeilennummer(err);
    fprintf(ausDatei,"IF ");
    variable_ausgeben(zw->com.cases.erg,DIRECT);
    fprintf(ausDatei," > ");
    variable_ausgeben(zw->com.cases.var,DIRECT);
    fprintf(ausDatei," CALL %d;",zeilen -
                                 statement_lines(zw->com.cases.stat) - 3);
    code_ausgeben(err,zw->com.cases.next);
    zeilennummer(err);
    fprintf(ausDatei,"PROC %d;",proc_ebene + 1);
    zeilennummer(err);
    variable_ausgeben(zw->com.cases.var,DIRECT);
    fprintf(ausDatei," := TRUE;");
    statements_ausgeben(zw->com.cases.stat);
    zeilennummer(err);
    fprintf(ausDatei,"RETURN;");
  }
  else
  { if (zw->com.cases.first >= 2)
    { if (zw->com.cases.var != NULL)
      { zeilennummer(err);
        fprintf(ausDatei,"IF ");
        variable_ausgeben(zw->com.cases.var,DIRECT);
        fprintf(ausDatei," = FALSE CALL %d;",linenr + 1);
        zeilennummer(err);
        fprintf(ausDatei,"GOTO %d;",all);
        zeilennummer(err);
        fprintf(ausDatei,"PROC %d;",proc_ebene + 1);
        if (zw->com.cases.stat != NULL)
          statements_ausgeben(zw->com.cases.stat);
        else
        { zeilennummer(err);
          fprintf(ausDatei,"ERROR \"%s\";",text[78]);
        }
        zeilennummer(err);
        fprintf(ausDatei,"RETURN;");
      }
      else
      { if (zw->com.cases.stat != NULL)
          statements_ausgeben(zw->com.cases.stat);
        else
        { zeilennummer(err);
          fprintf(ausDatei,"ERROR \"%s\";",text[78]);
        }
      }
    }
    else
    { zeilennummer(err);
      fprintf(ausDatei,"IF ");
      variable_ausgeben(zw->com.cases.erg,DIRECT);
      fprintf(ausDatei," = FALSE GOTO %d;",zeilen);
      statements_ausgeben(zw->com.cases.stat);
      zeilennummer(err);
      fprintf(ausDatei,"GOTO %d;",all);
      code_ausgeben(err,zw->com.cases.next);
    }
  }
}


out_caselabel(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.caselabel.lowex);
  zeilennummer(err);
  variable_ausgeben(zw->com.caselabel.hvar1,DIRECT);
  fprintf(ausDatei," := ");
  if (zw->com.caselabel.lowb == NULL)
  { char_string = 0;
    konstante_ausgeben(zw->com.caselabel.unten);
  }
  else
    variable_ausgeben(zw->com.caselabel.lowb,DIRECT);
  if (zw->com.caselabel.hvar2 != NULL)
  { fprintf(ausDatei," <= ");
    variable_ausgeben(zw->com.caselabel.erg,zw->com.caselabel.erg->dir_indir);
    fprintf(ausDatei,";");
    code_ausgeben(err,zw->com.caselabel.upex);
    zeilennummer(err);
    variable_ausgeben(zw->com.caselabel.hvar2,DIRECT);
    fprintf(ausDatei," := ");
    if (zw->com.caselabel.upb == NULL)
    { char_string = 0;
      konstante_ausgeben(zw->com.caselabel.oben);
    }
    else
      variable_ausgeben(zw->com.caselabel.upb,DIRECT);
    fprintf(ausDatei," >= ");
    variable_ausgeben(zw->com.caselabel.erg,zw->com.caselabel.erg->dir_indir);
    fprintf(ausDatei,";");
    zeilennummer(err);
    variable_ausgeben(zw->com.caselabel.hvar1,DIRECT);
    fprintf(ausDatei," := ");
    variable_ausgeben(zw->com.caselabel.hvar1,DIRECT);
    fprintf(ausDatei," AND ");
    variable_ausgeben(zw->com.caselabel.hvar2,DIRECT);
    fprintf(ausDatei,";");
  }
  else
  { fprintf(ausDatei," = ");
    variable_ausgeben(zw->com.caselabel.erg,zw->com.caselabel.erg->dir_indir);
    fprintf(ausDatei,";");
  }
  if (zw->com.caselabel.hvar1 != zw->com.caselabel.var)
  { zeilennummer(err);
    variable_ausgeben(zw->com.caselabel.var,DIRECT);
    fprintf(ausDatei," := ");
    variable_ausgeben(zw->com.caselabel.var,DIRECT);
    fprintf(ausDatei," OR ");
    variable_ausgeben(zw->com.caselabel.hvar1,DIRECT);
    fprintf(ausDatei,";");
  }
  if (zw->com.caselabel.next)
    code_ausgeben(err,zw->com.caselabel.next);
}


out_with(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.with.prev);
  if (zw->com.with.nach)
  { zeilennummer(err);
    variable_ausgeben(zw->com.with.nach,DIRECT);
    fprintf(ausDatei," := ");
    variable_ausgeben(zw->com.with.var,zw->com.with.adres);
    fprintf(ausDatei," + SIZE(");
    record_offset(zw->com.with.typ,zw->com.with.nummer);
    fprintf(ausDatei," );");
  }
  if (with_scope)
    with_scope->entry = with_scope->von = linenr;
  statements_ausgeben(zw->com.with.stat);
}


out_exit(err)
int err;  /* erreichbar ?*/
{ zeilennummer(err);
  fprintf(ausDatei,"GOTO %d; EXIT",loop_exit);
}


out_return(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.retcode);
  zeilennummer(err);
  fprintf(ausDatei,"GOTO %d; RETURN",proc_return);
}


out_parallel(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ int sx1, sx2;
  sx1 = selection_exit = linenr + zw->com.paral.lines;
  if (zw->com.paral.select)
    selection_exit--;
  code_ausgeben(err,zw->com.paral.select);
  sx2 = selection_exit;
  if (zw->com.paral.var != NULL)
  { ZWCODE * zw1 = zw->com.paral.var;
    ZWCODE *zw2 = zw->com.paral.select;
    while (zw1->com.dyn.next != NULL)
    { zw1 = zw1->com.dyn.next; }
    zw1->com.dyn.stat = zw->com.paral.stat;
    zw1 = zw->com.load.var;
    zw->com.paral.select = NULL;
    zw->com.paral.var = NULL;
    zw->com.paral.prozanz = proz_anz;
    code_ausgeben(err,zw1);
    if (zw2 && (sx1 != sx2))
    { parallel_string_ausgeben(err); }
  }
  else
  { int akt_zeile;
    statements_ausgeben(zw->com.paral.stat);
    akt_zeile = linenr;
    if (zw->com.paral.select && (sx1 != sx2))
    { neues_statement = 1;
      aktuelle_zeile = zw->com.paral.Zeile2;
      parallel_string_ausgeben(err);
      if (linenr != akt_zeile)
      { LINENR * l;
        GET_MEM(l,1,LINENR);
        l->link = all_lines;
        all_lines = l;
        l->source = zw->com.paral.Zeile2;
        l->drain = akt_zeile;
        l->next = linenr;
      }
    }
  }
}


out_propagate(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ int mode = zw->com.prop.mode;
  code_ausgeben(err,zw->com.prop.vonex);
  code_ausgeben(err,zw->com.prop.nachex);
  if (zw->com.prop.von != zw->com.prop.nach)
  { zeilennummer(err);
    variable_ausgeben(zw->com.prop.nach,zw->com.prop.nach->dir_indir);
    fprintf(ausDatei," := ");
    variable_ausgeben(zw->com.prop.von,zw->com.prop.von->dir_indir);
    fprintf(ausDatei,";");
  }
  code_ausgeben(err,zw->com.prop.code);
  if (mode & 8)
  { zeilennummer(err);
    fprintf(ausDatei,"IF ");
    variable_ausgeben(zw->com.prop.anz.var,zw->com.prop.anz.var->dir_indir);
    fprintf(ausDatei," > 0 GOTO %d;",linenr + 1);
    zeilennummer(err);
    fprintf(ausDatei,"ERROR \"%s\";",text[79]);
  }
  if ((mode & 4) || (mode & 8))
  { zeilennummer(err);
    variable_ausgeben(zw->com.prop.temp,DIRECT);
    fprintf(ausDatei," := 0;");
  }
  zeilennummer(err);
  fprintf(ausDatei,"PROPAGATE ");
  variable_ausgeben(zw->com.prop.nach,zw->com.prop.nach->dir_indir);
  fprintf(ausDatei," OUT ");
  if (mode & 1)
  { variable_ausgeben(zw->com.prop.out.port,DIRECT); }
  else
  { fprintf(ausDatei,"%d",zw->com.prop.out.pnr); }
  fprintf(ausDatei," IN ");
  if (mode & 2)
  { variable_ausgeben(zw->com.prop.in.port,DIRECT); }
  else
  { if (mode & 16)
    { fprintf(ausDatei,"SI%d:[",zw->com.prop.ebene);
      variable_ausgeben(zw->com.prop.out.port,DIRECT);
      fprintf(ausDatei,"]");
    }
    else
      fprintf(ausDatei,"%d",zw->com.prop.in.pnr); }
  fprintf(ausDatei,";");
  if ((mode & 4) || (mode & 8))
  { zeilennummer(err);
    variable_ausgeben(zw->com.prop.temp,DIRECT);
    fprintf(ausDatei," := ");
    variable_ausgeben(zw->com.prop.temp,DIRECT);
    fprintf(ausDatei," + 1;");
    zeilennummer(err);
    fprintf(ausDatei,"IF ");
    variable_ausgeben(zw->com.prop.temp,DIRECT);
    fprintf(ausDatei," < ");
    if (mode & 8)
    { variable_ausgeben(zw->com.prop.anz.var,DIRECT); }
    else
    { fprintf(ausDatei,"%d",zw->com.prop.anz.anz); }
    fprintf(ausDatei," GOTO %d;",linenr - 3);
  }
  code_ausgeben(err,zw->com.prop.test);
}

out_propagatere(err,zw,m)
int err;  /* erreichbar ?*/
ZWCODE * zw;
int m;
{ int mode = zw->com.propre.mode;
  int nr;
  code_ausgeben(err,zw->com.propre.vonex);
  code_ausgeben(err,zw->com.propre.nachex);
  if ((zw->com.propre.von != zw->com.propre.nach) && (m == 0))
  { zeilennummer(err);
    variable_ausgeben(zw->com.propre.nach,zw->com.propre.nach->dir_indir);
    fprintf(ausDatei," := ");
    variable_ausgeben(zw->com.propre.von,zw->com.propre.von->dir_indir);
    fprintf(ausDatei,";");
  }
  code_ausgeben(err,zw->com.propre.code);
  zeilennummer(err);
  fprintf(ausDatei,"PUSHS ");
  if (mode & 1)
  { variable_ausgeben(zw->com.propre.out.port,DIRECT); }
  else
  { fprintf(ausDatei,"%d",zw->com.propre.out.pnr); }
  fprintf(ausDatei,";");
  zeilennummer(err);
  fprintf(ausDatei,"PUSHS ");
  if (mode & 2)
  { variable_ausgeben(zw->com.propre.in.port,DIRECT); }
  else
  { if (mode & 16)
    { fprintf(ausDatei,"SI%d:[",zw->com.propre.ebene);
      variable_ausgeben(zw->com.propre.out.port,DIRECT);
      fprintf(ausDatei,"]");
    }
    else
      fprintf(ausDatei,"%d",zw->com.propre.in.pnr); }
  fprintf(ausDatei,";");
  zeilennummer(err);
  fprintf(ausDatei,"%s ",(m == 0) ? "PROPAGATE" : ((m == 1) ? "SEND" : "RECEIVE") );
  variable_ausgeben(zw->com.propre.von,zw->com.propre.von->dir_indir);
  fprintf(ausDatei," %s ",(m == 2) ? "FROM" : "TO" );
  variable_ausgeben(zw->com.propre.nach,zw->com.propre.nach->dir_indir);
  if (zw->com.propre.pna)
  { fprintf(ausDatei," REDUCE ");
    if ((nr = zw->com.propre.pna->param.proz.posnr) < 0)
    { switch (nr)
      { case PROC_FIRST :
          fprintf(ausDatei,"FIRST");
          break;
        case PROC_LAST :
          fprintf(ausDatei,"LAST");
          break;
        case PROC_SUM :
          fprintf(ausDatei,"SUM");
          break;
        case PROC_PRODUCT :
          fprintf(ausDatei,"PRODUCT");
          break;
        case PROC_MAX :
          fprintf(ausDatei,"MAX");
          break;
        case PROC_MIN :
          fprintf(ausDatei,"MIN");
          break;
      }
    }
    else
      fprintf(ausDatei,"%d",nr + normal_basis);
  }
  fprintf(ausDatei,";");
  code_ausgeben(err,zw->com.propre.test);
}


out_store(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ int sx1, sx2;
  int tests = zw->com.load.tests;
  ZWCODE * zwh = zw->com.load.select;
  if (zw->com.load.testvar && (zw->com.load.tests == 0))
  { zeilennummer(err);
    variable_ausgeben(zw->com.load.testvar,DIRECT);
    fprintf(ausDatei," := TRUE;");
    zw->com.load.lines++;
    zw->com.load.tests = 1;
  }
  sx1 = selection_exit = linenr + zw->com.load.lines;
  if (zw->com.load.select)
  { selection_exit--; }
  code_ausgeben(err,zwh);
  sx2 = selection_exit;
  if (zw->com.load.var != NULL)
  { ZWCODE * zw1 = zw->com.load.var;
    while (zw1->com.dyn.next != NULL)
    { zw1 = zw1->com.dyn.next; }
    zw1->com.dyn.next = zw;
    zw1 = zw->com.load.var;
    zw->com.load.select = NULL;
    zw->com.load.var = NULL;
    zw->com.load.prozanz = proz_anz;
    code_ausgeben(err,zw1);
  }
  else
  { if (zw->com.load.testvar)
    { zeilennummer(err);
      variable_ausgeben(zw->com.load.testvar,DIRECT);
      fprintf(ausDatei," := FALSE;");
    }
    code_ausgeben(err,zw->com.load.vekex);
    code_ausgeben(err,zw->com.load.skaex);
    code_ausgeben(err,zw->com.load.lenex);
    if (zw->com.load.len != NULL)
    { zeilennummer(err);
      fprintf(ausDatei,"MaxTrans := ");
      variable_ausgeben(zw->com.load.len,zw->com.load.len->dir_indir);
      fprintf(ausDatei,";");
    }
    zeilennummer(err);
    if (zw->art == CO_LOAD)
      fprintf(ausDatei,"LOAD ");
    else
      fprintf(ausDatei,"STORE ");
    variable_ausgeben(zw->com.load.vek,zw->com.load.vek->dir_indir);
    if (zw->art == CO_LOAD)
      fprintf(ausDatei," WITH ");
    else
      fprintf(ausDatei," TO ");
    variable_ausgeben(zw->com.load.ska,zw->com.load.ska->dir_indir);
    if (zw->com.load.typ->used[ALL] > 1)
    { fprintf(ausDatei," AS");
      indent_tab = "\t\t\t";
      zeilenfuellung = 1;
      typdef_ausgeben(ausDatei,zw->com.load.typ,1l);
    }
    fprintf(ausDatei,";");
    if (zw->com.load.len != NULL)
    { zeilennummer(err);
      variable_ausgeben(zw->com.load.len,zw->com.load.len->dir_indir);
      fprintf(ausDatei," := ActTrans;");
    }
  }
  if (zw->com.load.testvar && (tests == 0))
  { zeilennummer(err);
    fprintf(ausDatei,"IF ");
    variable_ausgeben(zw->com.load.testvar,DIRECT);
    fprintf(ausDatei," CALL %d;",keine_prozessoren);
  }
  else
    zw->com.load.tests = 2;
  if (zwh && (sx1 != sx2))
  { parallel_string_ausgeben(err); }
}


out_notrace(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.debtr.rest);
  code_ausgeben(err,zw->com.debtr.ex);
  zeilennummer(err);
  switch(zw->art)
  { case CO_DEBUG :
      fprintf(ausDatei,"DEBUG ");
      break;
    case CO_TRACE :
      fprintf(ausDatei,"TRACE ");
      break;
    case CO_NOTRACE :
      fprintf(ausDatei,"NOTRACE ");
      break;
  }
  if (zw->com.debtr.var != NULL)
  { variable_ausgeben(zw->com.debtr.var,zw->com.debtr.var->dir_indir);
    fprintf(ausDatei," ");
    if (zw->com.debtr.con != NULL)
    { char_string = 1;
      konstante_ausgeben(zw->com.debtr.con);
      fprintf(ausDatei," AS");
      zeilenfuellung = 1;
      indent_tab = "\t\t\t";
      typdef_ausgeben(ausDatei,zw->com.debtr.typ,1l);
    }
  }
  fprintf(ausDatei,";");
}


out_halt(err)
int err;  /* erreichbar ?*/
{ zeilennummer(err);
  fprintf(ausDatei,"HALT;");
}


out_port(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.port.ex);
  zeilennummer(err);
  fprintf(ausDatei,"IF ");
  variable_ausgeben(zw->com.port.port,zw->com.port.port->dir_indir);
  fprintf(ausDatei," < %d CALL %d;",zw->com.port.low,bereich_fehler);
  zeilennummer(err);
  fprintf(ausDatei,"IF ");
  variable_ausgeben(zw->com.port.port,zw->com.port.port->dir_indir);
  fprintf(ausDatei," > %d CALL %d;",zw->com.port.high,bereich_fehler);
  if (zw->com.port.pnr != 0)
  { zeilennummer(err);
    variable_ausgeben(zw->com.port.nach,DIRECT);
    fprintf(ausDatei," := ");
    variable_ausgeben(zw->com.port.port,zw->com.port.port->dir_indir);
    if (zw->com.port.pnr < 0)
    { fprintf(ausDatei," - %d;",-zw->com.port.pnr); }
    else
    { fprintf(ausDatei," + %d;",zw->com.port.pnr); }
  }
}


out_inc(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.incdec.expr1);
  code_ausgeben(err,zw->com.incdec.expr2);
  if (zw->com.incdec.temp != NULL)
  { zeilennummer(err);
    variable_ausgeben(zw->com.incdec.temp,DIRECT);
    fprintf(ausDatei," := ");
    variable_ausgeben(zw->com.incdec.erg,zw->com.incdec.erg->dir_indir);
    fprintf(ausDatei,";");
  }
  zeilennummer(err);
  if (zw->com.incdec.temp != NULL)
    variable_ausgeben(zw->com.incdec.temp,DIRECT);
  else
    variable_ausgeben(zw->com.incdec.erg,zw->com.incdec.erg->dir_indir);
  fprintf(ausDatei," := ");
  if (zw->com.incdec.temp != NULL)
    variable_ausgeben(zw->com.incdec.temp,DIRECT);
  else
    variable_ausgeben(zw->com.incdec.erg,zw->com.incdec.erg->dir_indir);
  if (zw->art == CO_DEC)
  { fprintf(ausDatei," - "); }
  else
  { fprintf(ausDatei," + "); }
  if (zw->com.incdec.var != NULL)
  { variable_ausgeben(zw->com.incdec.var,zw->com.incdec.var->dir_indir); }
  else
  { fprintf(ausDatei,"%d",zw->com.incdec.wert); }
  fprintf(ausDatei,";");
  if (zw->com.incdec.temp != NULL)
  { zeilennummer(err);
    variable_ausgeben(zw->com.incdec.erg,zw->com.incdec.erg->dir_indir);
    fprintf(ausDatei," := ");
    variable_ausgeben(zw->com.incdec.temp,DIRECT);
    fprintf(ausDatei,";");
  }
  code_ausgeben(err,zw->com.incdec.test);
}


out_writeln(err)
int err;  /* erreichbar ?*/
{ zeilennummer(err);
  fprintf(ausDatei,"WRITE EOL;");
}


out_writebool(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ char_string = 0;
  code_ausgeben(err,zw->com.write.expr1);
  zeilennummer(err);
  fprintf(ausDatei,"WRITE ");
  if (zw->com.write.var1 != NULL)
  { variable_ausgeben(zw->com.write.var1,zw->com.write.var1->dir_indir); }
  else
  { konstante_ausgeben(zw->com.write.Const1); }
  fprintf(ausDatei,";");
}


out_writereal(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.write.expr1);
  code_ausgeben(err,zw->com.write.expr2);
  zeilennummer(err);
  fprintf(ausDatei,"WRITE ");
  if (zw->com.write.var1 != NULL)
  { variable_ausgeben(zw->com.write.var1,zw->com.write.var1->dir_indir); }
  else
  { konstante_ausgeben(zw->com.write.Const1); }
  fprintf(ausDatei," ");
  if (zw->com.write.var2 != NULL)
  { variable_ausgeben(zw->com.write.var2,zw->com.write.var2->dir_indir); }
  else
  { fprintf(ausDatei,"%d",zw->com.write.Const2); }
  fprintf(ausDatei,";");
}


out_writestring(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ char_string = 1;
  code_ausgeben(err,zw->com.write.expr1);
  code_ausgeben(err,zw->com.write.expr2);
  zeilennummer(err);
  fprintf(ausDatei,"WRITE ");
  if (zw->com.write.var1 != NULL)
  { variable_ausgeben(zw->com.write.var1,zw->com.write.var1->dir_indir);
    fprintf(ausDatei," ");
    fprintf(ausDatei,"%d",zw->com.write.Const2);
  }
  else
  { konstante_ausgeben(zw->com.write.Const1); }
  fprintf(ausDatei,";");
}


out_writefixpt(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.write.expr1);
  code_ausgeben(err,zw->com.write.expr2);
  zeilennummer(err);
  fprintf(ausDatei,"WRITE ");
  if (zw->com.write.var1 != NULL)
  { variable_ausgeben(zw->com.write.var1,zw->com.write.var1->dir_indir); }
  else
  { konstante_ausgeben(zw->com.write.Const1); }
  fprintf(ausDatei," ");
  if (zw->com.write.var2 != NULL)
  { variable_ausgeben(zw->com.write.var2,zw->com.write.var2->dir_indir); }
  else
  { fprintf(ausDatei,"%d",zw->com.write.Const2); }
  fprintf(ausDatei," ");
  if (zw->com.write.var3 != NULL)
  { variable_ausgeben(zw->com.write.var3,zw->com.write.var3->dir_indir); }
  else
  { fprintf(ausDatei,"%d",zw->com.write.Const3); }
  fprintf(ausDatei,";");
}


out_drawbool(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ char_string = 0;
  code_ausgeben(err,zw->com.draw.expr1);
  zeilennummer(err);
  fprintf(ausDatei,"DRAW ");
  if (zw->com.draw.var1 != NULL)
  { variable_ausgeben(zw->com.draw.var1,zw->com.draw.var1->dir_indir); }
  else
  { konstante_ausgeben(zw->com.draw.Const1); }
  fprintf(ausDatei,";");
}


out_drawreal(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.draw.expr1);
  code_ausgeben(err,zw->com.draw.expr2);
  zeilennummer(err);
  fprintf(ausDatei,"DRAW ");
  if (zw->com.draw.var1 != NULL)
  { variable_ausgeben(zw->com.draw.var1,zw->com.draw.var1->dir_indir); }
  else
  { konstante_ausgeben(zw->com.draw.Const1); }
  fprintf(ausDatei," ");
  if (zw->com.draw.var2 != NULL)
  { variable_ausgeben(zw->com.draw.var2,zw->com.draw.var2->dir_indir); }
  else
  { fprintf(ausDatei,"%d",zw->com.draw.Const2); }
  fprintf(ausDatei,";");
}


out_drawstring(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ char_string = 1;
  code_ausgeben(err,zw->com.draw.expr1);
  code_ausgeben(err,zw->com.draw.expr2);
  zeilennummer(err);
  fprintf(ausDatei,"DRAW ");
  if (zw->com.draw.var1 != NULL)
  { variable_ausgeben(zw->com.draw.var1,zw->com.draw.var1->dir_indir);
    fprintf(ausDatei," ");
    fprintf(ausDatei,"%d",zw->com.draw.Const2);
  }
  else
  { konstante_ausgeben(zw->com.draw.Const1); }
  fprintf(ausDatei,";");
}


out_drawfixpt(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.draw.expr1);
  code_ausgeben(err,zw->com.draw.expr2);
  zeilennummer(err);
  fprintf(ausDatei,"DRAW ");
  if (zw->com.draw.var1 != NULL)
  { variable_ausgeben(zw->com.draw.var1,zw->com.draw.var1->dir_indir); }
  else
  { konstante_ausgeben(zw->com.draw.Const1); }
  fprintf(ausDatei," ");
  if (zw->com.draw.var2 != NULL)
  { variable_ausgeben(zw->com.draw.var2,zw->com.draw.var2->dir_indir); }
  else
  { fprintf(ausDatei,"%d",zw->com.draw.Const2); }
  fprintf(ausDatei," ");
  if (zw->com.draw.var3 != NULL)
  { variable_ausgeben(zw->com.draw.var3,zw->com.draw.var3->dir_indir); }
  else
  { fprintf(ausDatei,"%d",zw->com.draw.Const3); }
  fprintf(ausDatei,";");
}


out_read(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.read.expr);
  zeilennummer(err);
  fprintf(ausDatei,"READ ");
  variable_ausgeben(zw->com.read.var,zw->com.read.var->dir_indir);
  if (zw->com.read.mode == 1)
  { fprintf(ausDatei," %d",zw->com.read.len); }
  fprintf(ausDatei,";");
  code_ausgeben(err,zw->com.read.test);
}


out_openinput(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.open.expr);
  zeilennummer(err);
  fprintf(ausDatei,"OPENINPUT ");
  if (zw->com.open.var != NULL)
  { variable_ausgeben(zw->com.open.var,zw->com.open.var->dir_indir); }
  else
  { char_string = 1;
    konstante_ausgeben(zw->com.open.Const);
  }
  fprintf(ausDatei,";");
}


out_openoutput(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.open.expr);
  zeilennummer(err);
  fprintf(ausDatei,"OPENOUTPUT ");
  if (zw->com.open.var != NULL)
  { variable_ausgeben(zw->com.open.var,zw->com.open.var->dir_indir); }
  else
  { char_string = 1;
    konstante_ausgeben(zw->com.open.Const);
  }
  fprintf(ausDatei,";");
}


out_closeinput(err)
int err;  /* erreichbar ?*/
{ zeilennummer(err);
  fprintf(ausDatei,"CLOSEINPUT;");
}


out_closeoutput(err)
int err;  /* erreichbar ?*/
{ zeilennummer(err);
  fprintf(ausDatei,"CLOSEOUTPUT;");
}


out_connect(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.connect.code1);
  code_ausgeben(err,zw->com.connect.code2);
  zeilennummer(err);
  variable_ausgeben(zw->com.connect.erg,zw->com.connect.erg->dir_indir);
  fprintf(ausDatei," := CONNECTED ");
  if (zw->com.connect.mode & 1)
    fprintf(ausDatei,"OUT ");
  else
    fprintf(ausDatei,"IN ");
  if (zw->com.connect.mode & 2)
    variable_ausgeben(zw->com.connect.p1.port,zw->com.connect.p1.port->dir_indir);
  else
    fprintf(ausDatei,"%d",zw->com.connect.p1.pnr);
  if (zw->com.connect.mode & 8)
  { if (zw->com.connect.mode & 1)
      fprintf(ausDatei," IN ");
    else
      fprintf(ausDatei," OUT ");
    if (zw->com.connect.mode & 4)
      variable_ausgeben(zw->com.connect.p2.port,zw->com.connect.p2.port->dir_indir);
    else
      fprintf(ausDatei,"%d",zw->com.connect.p2.pnr);
  }
  fprintf(ausDatei,";");
}


out_new(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.new.expr);
  zeilennummer(err);
  variable_ausgeben(zw->com.new.var,zw->com.new.var->dir_indir);
  fprintf(ausDatei," := NEW ");
  typdef_ausgeben(ausDatei,zw->com.new.type,1l);
  fprintf(ausDatei,";");
}


out_dispose(err,zw)
int err;  /* erreichbar ?*/
ZWCODE * zw;
{ code_ausgeben(err,zw->com.new.expr);
  zeilennummer(err);
/* #ifdef DISPOSE*/
  fprintf(ausDatei,"DISPOSE ");
  variable_ausgeben(zw->com.new.var,zw->com.new.var->dir_indir);
/*#else
  fprintf(ausDatei,"NOP");
#endif*/
  fprintf(ausDatei,";");
}

parallel_string_ausgeben(err)
int err;
{ int i, nl = 0;
  zeilennummer(err);
  fprintf(ausDatei,"PARALLEL\t");
  for (i = 0; i < proz_anz; i++)
  { if (nl == 50)
    { fprintf(ausDatei,"\n\t\t\t\t");
      nl = 0;
    }
    fprintf(ausDatei,"1");
    nl++;
  }
  fprintf(ausDatei,";");
}

out_connection(zw)
ZWCODE * zw;
{ ZWCODE * zw1;
  if (zw->com.connection.conf)
    dimis_berechnen(zw->com.connection.group,zw->com.connection.conf,
                    zw->com.connection.group->vectors->Ebene,0,1);
  if (zw->com.connection.has_range == zw->com.connection.dconf->dims)
  { zeilennummer();
    fprintf(ausDatei,"VI%d:%d",
                     zw->com.connection.group->vectors->Ebene,
                     zw->com.connection.max_dim + 1);
    fprintf(ausDatei," := %d;",zw->com.connection.group->first_proz+1);
  }
  if (zw->com.connection.constants)
  { int w;
    zeilennummer(0);
    if (zw->com.connection.constants == 1)
    { if ((w = zw->com.connection.source[0]) < 0)
      { variable_ausgeben(zw->com.connection.ihv,DIRECT);
        fprintf(ausDatei," := - %d;" ,-w);
        nozeilennummer();
        fprintf(ausDatei,"IF VI%d:%d = ",zw->com.connection.group->vectors->Ebene,
                                  zw->com.connection.source[1]);
        variable_ausgeben(zw->com.connection.ihv,DIRECT);
        fprintf(ausDatei," CALL %d;",linenr);
      }
      else
        fprintf(ausDatei,"IF VI%d:%d = %d CALL %d;",zw->com.connection.group->vectors->Ebene,
                                  zw->com.connection.source[1],
                                  zw->com.connection.source[0],linenr);
    }
    else
    { int i,j, *t;
      t = zw->com.connection.source;
      j = zw->com.connection.constants - 1;
      for (i = 0; i <= j; i++)
      { if ((w = *t++) < 0)
        { variable_ausgeben(zw->com.connection.ihv,DIRECT);
          fprintf(ausDatei," := - %d;" ,-w);
          nozeilennummer();
        }
        if (i)
          variable_ausgeben(zw->com.connection.b2var,DIRECT);
        else
          variable_ausgeben(zw->com.connection.b1var,DIRECT);
        fprintf(ausDatei," := VI%d:%d = ",zw->com.connection.group->vectors->Ebene,*t++);
        if (w < 0)
          variable_ausgeben(zw->com.connection.ihv,DIRECT);
        else
          fprintf(ausDatei,"%d",w);
        fprintf(ausDatei,";");
        nozeilennummer();
        if (i && (i != j))
        { variable_ausgeben(zw->com.connection.b1var,DIRECT);
          fprintf(ausDatei," := ");
          variable_ausgeben(zw->com.connection.b1var,DIRECT);
          fprintf(ausDatei," AND ");
          variable_ausgeben(zw->com.connection.b2var,DIRECT);
          fprintf(ausDatei,";");
          nozeilennummer();
        }
      }
      variable_ausgeben(zw->com.connection.b1var,DIRECT);
      fprintf(ausDatei," := ");
      variable_ausgeben(zw->com.connection.b1var,DIRECT);
      fprintf(ausDatei," AND ");
      variable_ausgeben(zw->com.connection.b2var,DIRECT);
      fprintf(ausDatei,";");
      nozeilennummer();
      fprintf(ausDatei,"IF ");
      variable_ausgeben(zw->com.connection.b1var,DIRECT);
      fprintf(ausDatei," CALL %d;",linenr);
    }
    nozeilennummer();
    fprintf(ausDatei,"GOTO %d;", linenr + zw->com.connection.czeilen);
    zeilennummer(0);
    fprintf(ausDatei,"PROC %d;",zw->com.connection.group->vectors->Ebene+1);
  }
  if (zw->com.connection.bvar)
  { code_ausgeben(0,zw->com.connection.bexpr);
    zeilennummer(0);
    fprintf(ausDatei,"IF ");
    variable_ausgeben(zw->com.connection.bvar,zw->com.connection.bvar->dir_indir);
    fprintf(ausDatei," CALL %d;",linenr);
    nozeilennummer();
    fprintf(ausDatei,"GOTO %d;",zw->com.connection.zeilen + linenr + 2);
    zeilennummer(0);
    fprintf(ausDatei,"PROC %d;",zw->com.connection.group->vectors->Ebene+1);
  }    
  code_ausgeben(0,zw1 = zw->com.connection.rest);
  while (zw1)
  { if ((zw1->art == CO_CONN) && (zw1->com.conn.exprvar))
    { nozeilennummer();
      fprintf(ausDatei,"IF ");
      variable_ausgeben(zw1->com.conn.exprvar,zw1->com.conn.exprvar->dir_indir);
      fprintf(ausDatei," < 0 CALL 2;");
      nozeilennummer();
      fprintf(ausDatei,"IF ");
      variable_ausgeben(zw1->com.conn.exprvar,zw1->com.conn.exprvar->dir_indir);
      fprintf(ausDatei," > %d CALL 2;",zw1->com.conn.top);
    }
    zw1 = zw1->com.conn.next;
  }
  nozeilennummer();
  if (zw->com.connection.has_range)
  { if (zw->com.connection.has_range != zw->com.connection.dconf->dims)
    { fprintf(ausDatei,"IF VI%d:%d > 0 CALL %d;",
                       zw->com.connection.group->vectors->Ebene,
                       zw->com.connection.max_dim + 1, linenr);
      nozeilennummer();
      fprintf(ausDatei,"GOTO %d;",linenr + zw->com.connection.has_range + 1);
      zeilennummer(1);
      fprintf(ausDatei,"PROC %d;",zw->com.connection.group->vectors->Ebene+1);
    }
    erster_teil( zw->com.connection.rest);
    zeilennummer(1);
  }
  fprintf(ausDatei,"%sCONNECT %d TO %d AT VI%d:%d;",(zw->com.connection.mode) ? "BI" : "",
                    zw->com.connection.von,zw->com.connection.bis,
                    zw->com.connection.group->vectors->Ebene,
                    zw->com.connection.max_dim + 1);
  if (zw->com.connection.has_range)
  { zweiter_teil( zw->com.connection.rest);
    if (zw->com.connection.has_range != zw->com.connection.dconf->dims)
    { nozeilennummer();
      fprintf(ausDatei,"RETURN;");
    }
  }  
  if (zw->com.connection.bvar)
  { zeilennummer(1);
    fprintf(ausDatei,"RETURN;");
  }
  if (zw->com.connection.constants)
  { zeilennummer(0);
    fprintf(ausDatei,"RETURN;");
  }
}


out_conn(zw)
ZWCODE * zw;
{ int flag = 0;
  code_ausgeben(0,zw->com.conn.expr);
  if ((zw->com.conn.mode & 2) == 0)
  { zeilennummer(0);
    flag = 1;
    variable_ausgeben(zw->com.conn.hvar,DIRECT);
    fprintf(ausDatei," := ");
    variable_ausgeben(zw->com.conn.hvar,DIRECT);
    fprintf(ausDatei," + ");
    if (zw->com.conn.exprvar)
      variable_ausgeben(zw->com.conn.exprvar,zw->com.conn.exprvar->dir_indir);
    else
    { fprintf(ausDatei,"%d",zw->com.conn.offset + zw->com.conn.off);
      zw->com.conn.offset = zw->com.conn.off = 0;
      zw->com.conn.mode &= ~1;
    }
    fprintf(ausDatei,";");
  }
  if (((zw->com.conn.mode & 1) == 0) || (zw->com.conn.fak > 1) ||
      (zw->com.conn.mode & 2))
  { if (flag)
      nozeilennummer();
    else
      zeilennummer(0);
    flag = 1;
    variable_ausgeben(zw->com.conn.hvar,DIRECT);
    fprintf(ausDatei," := ");
    if ((zw->com.conn.mode & 2) == 0)
      variable_ausgeben(zw->com.conn.hvar,DIRECT);
    else
    { if (zw->com.conn.exprvar)
        variable_ausgeben(zw->com.conn.exprvar,zw->com.conn.exprvar->dir_indir);
      else
      { fprintf(ausDatei,"%d",zw->com.conn.offset);
        zw->com.conn.mode &= ~1;
      }
    }
    zw->com.conn.mode &= ~2;
    if (zw->com.conn.fak > 1)
    { fprintf(ausDatei," * ");
      fprintf(ausDatei,"%d",zw->com.conn.fak);
    }
    fprintf(ausDatei,";");
  }
  if (zw->com.conn.mode & 1)
  { zw->com.conn.off += zw->com.conn.offset; }
  if (zw->com.conn.off)
  { if (flag)
      nozeilennummer();
    else
      zeilennummer(0);
    flag = 1;
    variable_ausgeben(zw->com.conn.hvar,DIRECT);
    fprintf(ausDatei," := ");
    if ((zw->com.conn.mode & 2) == 0)
    { variable_ausgeben(zw->com.conn.hvar,DIRECT);
      fprintf(ausDatei," + ");
    }
    else
    { if (zw->com.conn.exprvar)
      { variable_ausgeben(zw->com.conn.exprvar,zw->com.conn.exprvar->dir_indir);
        fprintf(ausDatei," + ");
      }
    }
    fprintf(ausDatei,"%d",zw->com.conn.off);
    fprintf(ausDatei,";");
  }
  code_ausgeben(0,zw->com.conn.next);
}

out_corange(zw)
ZWCODE * zw;
{ code_ausgeben(0,zw->com.corange.next); }

erster_teil(zw)
ZWCODE * zw;
{ while(zw)
  { if (zw->art == CO_CORANGE)
    { if (zw->com.corange.var1)
      { zeilennummer(1);
        variable_ausgeben(zw->com.corange.var1,DIRECT);
        fprintf(ausDatei," := ");
        variable_ausgeben(zw->com.corange.var3,DIRECT);
        fprintf(ausDatei,";");
      }
      nozeilennummer();
      variable_ausgeben(zw->com.corange.var2,DIRECT);
      fprintf(ausDatei," := 0;");
      if (zw->com.corange.bas)
      { nozeilennummer();
        variable_ausgeben(zw->com.corange.var3,DIRECT);
        fprintf(ausDatei," := ");
        variable_ausgeben(zw->com.corange.var3,DIRECT);
        fprintf(ausDatei," + %d;",zw->com.corange.bas);
      }
      zw->com.corange.line = linenr;
      zw = zw->com.corange.next;
    }
    else
      zw = zw->com.conn.next;
  }
}

zweiter_teil(zw)
ZWCODE * zw;
{ if (zw)
  { if (zw->art == CO_CORANGE)
    { zweiter_teil(zw->com.corange.next);
      nozeilennummer();
      variable_ausgeben(zw->com.corange.var3,DIRECT);
      fprintf(ausDatei," := ");
      variable_ausgeben(zw->com.corange.var3,DIRECT);
      fprintf(ausDatei," + %d;",zw->com.corange.add);
      nozeilennummer();
      variable_ausgeben(zw->com.corange.var2,DIRECT);
      fprintf(ausDatei," := ");
      variable_ausgeben(zw->com.corange.var2,DIRECT);
      fprintf(ausDatei," + 1;",zw->com.corange.bas);
      nozeilennummer();
      fprintf(ausDatei,"IF ");
      variable_ausgeben(zw->com.corange.var2,DIRECT);
      fprintf(ausDatei," <= ");
      fprintf(ausDatei," %d GOTO %d;",zw->com.corange.bis,zw->com.corange.line);
      if (zw->com.corange.var1)
      { nozeilennummer();
        variable_ausgeben(zw->com.corange.var3,DIRECT);
        fprintf(ausDatei," := ");
        variable_ausgeben(zw->com.corange.var1,DIRECT);
        fprintf(ausDatei,";");
      }
    }
    else
      zweiter_teil(zw->com.conn.next);
  }
}


out_open_get(zw,m,err)
ZWCODE * zw;
int m,err;
{ int mode = zw->com.open_get.mode;
  code_ausgeben(err,zw->com.open_get.ziel);
  code_ausgeben(err,zw->com.open_get.expr1);
  code_ausgeben(err,zw->com.open_get.expr2);
  if (!m && range_test)
  { if ((mode & 1) == 0)
    { zeilennummer(err);
      fprintf(ausDatei,"IF ");
      variable_ausgeben(zw->com.open_get.one.var,zw->com.open_get.one.var->dir_indir);
      fprintf(ausDatei," <= 0.0 CALL %d;",bereich_fehler);
    }
    if ((mode & 2) == 0)
    { zeilennummer(err);
      fprintf(ausDatei,"IF ");
      variable_ausgeben(zw->com.open_get.two.var,zw->com.open_get.two.var->dir_indir);
      fprintf(ausDatei," <= 0.0 CALL %d;",bereich_fehler);
    }
  }
  zeilennummer(err);
  variable_ausgeben(zw->com.open_get.erg,zw->com.open_get.erg->dir_indir);
  if (m)
    if (m == 1)
      fprintf(ausDatei," := GETPIXEL ");
    else
      fprintf(ausDatei," := OPENABSW ");
  else
    fprintf(ausDatei," := OPENW ");
  if (mode & 1)
    konstante_ausgeben(zw->com.open_get.one.con);
  else
    variable_ausgeben(zw->com.open_get.one.var,zw->com.open_get.one.var->dir_indir);
  fprintf(ausDatei," ");
  if (mode & 2)
    konstante_ausgeben(zw->com.open_get.two.con);
  else
    variable_ausgeben(zw->com.open_get.two.var,zw->com.open_get.two.var->dir_indir);
  fprintf(ausDatei,";");
}

out_setpixel(zw,err)
ZWCODE * zw;
int err;
{ int mode = zw->com.open_get.mode;
  code_ausgeben(err,zw->com.open_get.expr1);
  code_ausgeben(err,zw->com.open_get.expr2);
  zeilennummer(err);
  fprintf(ausDatei,"SETPIXEL ");
  if (mode & 1)
    konstante_ausgeben(zw->com.open_get.one.con);
  else
    variable_ausgeben(zw->com.open_get.one.var,zw->com.open_get.one.var->dir_indir);
  fprintf(ausDatei," ");
  if (mode & 2)
    konstante_ausgeben(zw->com.open_get.two.con);
  else
    variable_ausgeben(zw->com.open_get.two.var,zw->com.open_get.two.var->dir_indir);
  fprintf(ausDatei,";");
}

out_moveto(zw,err)
ZWCODE * zw;
int err;
{ int mode = zw->com.open_get.mode;
  code_ausgeben(err,zw->com.open_get.expr1);
  code_ausgeben(err,zw->com.open_get.expr2);
  zeilennummer(err);
  fprintf(ausDatei,"MOVETO ");
  if (mode & 1)
    konstante_ausgeben(zw->com.open_get.one.con);
  else
    variable_ausgeben(zw->com.open_get.one.var,zw->com.open_get.one.var->dir_indir);
  fprintf(ausDatei," ");
  if (mode & 2)
    konstante_ausgeben(zw->com.open_get.two.con);
  else
    variable_ausgeben(zw->com.open_get.two.var,zw->com.open_get.two.var->dir_indir);
  fprintf(ausDatei,";");
}

out_lineto(zw,err)
ZWCODE * zw;
int err;
{ int mode = zw->com.lineto.mode;
  code_ausgeben(err,zw->com.lineto.expr1);
  code_ausgeben(err,zw->com.lineto.expr2);
  code_ausgeben(err,zw->com.lineto.expr3);
  code_ausgeben(err,zw->com.lineto.expr4);
  zeilennummer(err);
  fprintf(ausDatei,"MOVETO ");
  if (mode & 1)
    konstante_ausgeben(zw->com.lineto.one.con);
  else
    variable_ausgeben(zw->com.lineto.one.var,zw->com.lineto.one.var->dir_indir);
  fprintf(ausDatei," ");
  if (mode & 2)
    konstante_ausgeben(zw->com.lineto.two.con);
  else
    variable_ausgeben(zw->com.lineto.two.var,zw->com.lineto.two.var->dir_indir);
  fprintf(ausDatei,";");
  zeilennummer(err);
  fprintf(ausDatei,"IF DONE = FALSE GOTO %d;\n\t\t",linenr);
  fprintf(ausDatei,"LINETO ");
  if (mode & 4)
    konstante_ausgeben(zw->com.lineto.three.con);
  else
    variable_ausgeben(zw->com.lineto.three.var,zw->com.lineto.three.var->dir_indir);
  fprintf(ausDatei," ");
  if (mode & 8)
    konstante_ausgeben(zw->com.lineto.four.con);
  else
    variable_ausgeben(zw->com.lineto.four.var,zw->com.lineto.four.var->dir_indir);
  fprintf(ausDatei,";");
}

out_select_set(zw,m,err)
ZWCODE * zw;
int m,err;
{ int mode = zw->com.select_set.mode;
  code_ausgeben(err,zw->com.select_set.expr);
  zeilennummer(err);
  if (m)
  { if (m == 1)
      fprintf(ausDatei,"SETCOLOR ");
    else
      fprintf(ausDatei,"CLOSEW ");
  }
  else
    fprintf(ausDatei,"SELECTW ");
  if (mode & 1)
    konstante_ausgeben(zw->com.select_set.one.con);
  else
    variable_ausgeben(zw->com.select_set.one.var,zw->com.select_set.one.var->dir_indir);
  fprintf(ausDatei,";");
}

out_windowsize(zw,err)
ZWCODE * zw;
int err;
{ code_ausgeben(err,zw->com.windowsize.expr1);
  code_ausgeben(err,zw->com.windowsize.expr2);
  zeilennummer(err);
  fprintf(ausDatei,"WSIZE ");
  variable_ausgeben(zw->com.windowsize.var1,zw->com.windowsize.var1->dir_indir);
  fprintf(ausDatei," ");
  variable_ausgeben(zw->com.windowsize.var2,zw->com.windowsize.var2->dir_indir);
  fprintf(ausDatei,";");
  code_ausgeben(err,zw->com.windowsize.expr3);
  code_ausgeben(err,zw->com.windowsize.expr4);
}
/* close file */
#endif

