/* Parallaxis Version: @(#)parallax.h	2.13  2/28/92 14:47:45  */
/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : parallax.h                                                        */
/*                                                                           */
/* Definitionen, globale Variablen und Typen allgemeiner Art                 */
/*                                                                           */
/* ************************************************************************* */

#ifndef stdin
#    include <stdio.h>
#endif

#ifndef strlen
#ifdef PC
#   include <string.h>
#else
#   ifdef HP
#      include <string.h>
#   else
#      include <strings.h>
#   endif
#endif
#endif

    /* bei gesetztem DEBUG muss die Datei print.o hinzu gelinkt werden */
#ifdef DEBUG
        /* sammle Informationen ueber den Verbrauch von Speicher */
#undef my_calloc
#undef my_free
#      define my_calloc my_my_calloc
#      define my_free my_my_free
#endif

#include "fehler.h"

extern int max_zeilenzahl;  /* hoechste Zeilennummer */

#ifndef IBM
   extern char * calloc();
#endif

/* Hole  Speicher:
        nach   ist der Zeiger auf den Bereich,
        anz   die Anzahl der Elemente und
        elem   ist der Datentyp */

#define GET_MEM(nach, anz, elem)  if((nach = (elem *) my_calloc((anz) ? anz : 1, sizeof(elem))) == NULL)\
                                    fatal(text[100]);


#define BITSET_MAXIMUM          32    /* Anzahl der Mengenelemente fuer BITSET */
#define MAXCHAR                 255   /* VAL(groesstem ASCII-Wert) */
#define ERROR_MAX_COUNT         10    /* Anzahl der Fehlermeldungen auf stderr */
#define WARN_MAX_COUNT          10    /* Anzahl der Warnungen auf stderr */
#define MAX_EXPR_LENGTH         50    /* Laenge der Debug- und Trace-Information */
#define MAX_COM                 10    /* Zahl der Kommentare die gespeichert werden */
#define NIL                     "NIL"   /* Repr"asentation von NIL */

/* Der PARZ-Scanner kann nicht alle Zeichen korrekt lesen, deshalb werden nur die Zeichen
   des folgenden Bereichs direkt als Zeichen im PARZ-Code ausgeben. Die anderen werden
   mit CHR(num) uebergeben */
#define MINIMAL_PRINT_CHAR      ' '             /* kleinstes zu druckendes Zeichen */
#define MAXIMAL_PRINT_CHAR      '\176'          /* groesstes zu druckendes Zeichen */

/* Laenge von Kommentaren und DEBUG und TRACE Informationen */
#define MAX_ZEILENBREITE  20


extern int yynerrs;    /* Anzahl der Fehler */
extern int yywarning;  /* Anzahl der Warnungen */

/* Flags fuer die Compileroptionen */
extern int listingausgeben;   /* Listing erzeugen */
extern int error_max_count;   /* Anzahl der max. gemeldeten Fehler */
extern int warn_max_count;    /* Anzahl der max. gemeldeten Warnungen */
extern int range_test;        /* Bereichsgrenzen im PARZ-Kode pruefen */
extern int verbose_flag;      /* Informationen ueber den Stand der Uebersetzung */
extern int debug_trace_flag;  /* DEBUG und TRACE in PARZ-uebersetzen */
extern int uppercase_flag;    /* unterscheide Gross- und Kleinschrift */
extern int reusevar;          /* Hilfsvariablen mehrfach verwenden */
extern int pipeline;          /* von stdin lesen nach stdout schreiben */
extern int timestamp;         /* Timestamp f"ur die Symboltabellenverwaltung */
extern int akt_timestamp;     /* Timestamp f"ur Record-Komponenten */
extern int akt_conf_nr;       /* Konfigurationsnummer */

extern char * infile;    /* Dateiname der Quelldatei */
extern char * listname;  /* Dateiname der Listing-Datei */
extern FILE * listfile;  /* Dateizeiger fuer die Listingdatei */
extern char * d_name;    /* Ausgabedatei */

extern char * text[];    /* Texte fuer Meldungen */

extern int no_char_read; /* kein Programm gelesen ? */

extern struct ST_type * typen_liste; /* Liste aller Datentypen f"ur die Debuggerausgabe */

/* interne Repraesentation einer Zeile des Parallaxis-Programms */
typedef
   struct zeile
   {    struct zeile * next;
        struct fehler_warn * fehl_warn; /* Fehler oder Warnung */
        int nummer;    /* Zeilennummer */
        char sourcetext[1];  /* Zeile selbst */
   } ZEILE;

/* Pseudokommentare aufsammeln */
typedef struct proto
   {    struct proto * link;
        long name_nr;     /* Nummer des Namens im WB */
   } PROTOKOLL;

extern PROTOKOLL * protokoll,  /* Pseudokommentare fuer Protokollsteuerung */
                 * debug_proz; /* Pseudokommentare fuer Prozedurverfolgung */

