static char _sccsid[] = "Parallaxis Version: @(#)pass2.c	2.15  5/27/92 10:28:54";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : pass2.c                                                           */
/*                                                                           */
/* Funktionen zur semantischen Analyse und Zwischencodeerzeugung             */
/*                                                                           */
/* ************************************************************************* */


#include "defines.h"
# include <math.h>
# undef _REDUCE
# include <errno.h>
# include <signal.h>
# include "makro2.h"
# include "makro.h"
# include "typen.h"
# include "symbols.h"
# include "y_tab.h"
# include "hilfsvar.h"
# include "code.h"        /* Codeerzeugung */
# include "conf.h"
# include "procs.h"
# include "scope.h"


#include "wb.h"

#define FREE 0
#define EXAKT 1

#ifdef DEBUG
extern int no_internal;
#endif
extern ST_TYPE * typ_error, * typ_int, * typ_card, * typ_char, * typ_real,
               * typ_bool, * typ_string, * typ_bitset;
extern Eintrag * integer_eintr, * cardinal_eintr;
extern int error_range;
extern int null_prozessoren;
extern int proc_info, proc_parall;
extern int port_variable;
extern int enum_top;
extern C_CONF * default_conf, * akt_conf;
extern C_GROUP * all_groups;
/* in calc.c */

extern ST_CONST * hole_Constkomp();

extern ST_CONST * eval_binexpr();


/* in code.c */

extern ZWCODE * check_ranges();


/* in hilfsvar.c */

extern Eintrag * get_hvar();
      
extern VARNODE * neue_hv();  /* liefert die Zieladresse fuer die Operation */

extern int hilfs_var();


/* in param.c */

extern int teste_parameter();


/* in typ.c */

extern int elementezahl();

extern int match_typen();

extern ST_TYPE * typ_berechnung();

extern int enumeration_typ();

extern int ist_cardinal();

extern int ist_stringtyp();

extern int ist_einfacher_typ();


/* in strings.c */

extern ST_CONST * erzeuge_string();


/* in pass2.c */

extern int get_Constant();

extern ST_TYPE * arrayexpr();

extern ST_TYPE * designrest();

extern ST_CONST * set_Constlist();

extern int teste_record();

extern int pruefe_record();

extern int ermittle_grenze();

extern int trage_varlist_ein();

extern int trage_var_ein();

extern int Namensliste();

extern int traceable();

extern int elsif_anweisungen();

extern int statement_lines();

extern int build_selection();

extern int activ_check;

/* ******************** */

typedef struct Proclist {
    struct Proclist * link;
    Eintrag * wer;
    Eintrag * wo;
    int Zeile, Posit;
    int mode;
    int conf;
    int error;
    } PROCLIST;

Eintrag * akt_proc_eintr;
PROCLIST * used_proc = NULL;

VARNODE * VARi = NULL;    /* Alle Varablenknoten einer Prozedur bzw. des Hauptteils */
HVARS * hvarsscal, * hvarsvect; /* Kette der freien Hilfsvariablen */
ST_TYPE * typ_s;
int LINE1, LINE2, COL1, COL2;
int interpreter;
ST * dim_ST;

int haupt_program = 0;
int dummy;
int proz_anz = 0;
int akt_proz_anz = 0;
int * connect;
int has_selection = 1;
ST_TYPE * record_typ;
ST * vector_tab = NULL;
extern MEMBERS * record_mem;
int record_scavec;
int max_dims;            /* Zahl der maximalen Dimensionen */
long * max_wert_faktoren;
ST_TYPE * returntyp;
int retexit;            /* return oder exit erlaubt */
#define ERL_RET         1
#define ERL_EXIT        2
#define ERL_EXITLOOP    4
int proc_scavec;        /* Prozedurergebnis ist skalar oder vektoriell */

char * null_eins_string;        /* Auswahlstring bei statischer Selection */
int ** string_01;               /* Feld mit der Auswahl pro Dimension */
int sel_proz_anz;               /* Anzahl der Prozessoren nach Auswahl */
int select_expr;                /* Auswahl kann Zahl oder boolscher Ausdruck */
int Const_expr;                 /* Nur Konstanten erlaubt (fuer Const_records) */
int loopleft = 0;               /* wird LOOP .. END verlassen ? */
int nomore = 0;                 /* kann das naechste Statement erreicht werden ? */
int yywarning = 0;              /* Anzahl der Warnungen */

int prozedur_zeilen;  /* Anzahl der Zeilen fuer die Prozeduren */
int returnstat;       /* Funktion muss ein RETURN enthalten */
ST * grund_ST;        /* Tabelle mit Standardfunktionen */
int within_selection = 0; /* reduce innerhalb einer Selektion nur ohne Selektion */
ZWCODE * nach_pruefung = NULL; /* Code zur Pruefung von VAR-Parametern nach Prozurausfruf */
WITH_COMP * wcomp = NULL;                                      
int info_proc;
int member_of_conf = 0;
int actual_group_nr = 0;
int vector_Ebene = -1;
ST_TYPE * dim_typen;

/* ************************************************************************* */
/* Floating-point-exception behandeln                                        */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Signalart                                                     */
/*                                                                           */
/* ************************************************************************* */

int fp_error;

/*ARGSUSED*/
void fpexep(sig)           /* wird bei floating-point-exception aufgerufen */
int sig;
{ fp_error = JA;
#ifdef DEBUG
  if (no_internal) printf("fp-error\n");
#endif
#ifndef ATARI_ST
  signal(SIGFPE,fpexep);
#endif
}


/* ************************************************************************* */
/* Steuerung der semantischen Analyse                                        */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Programmzeiger                                                */
/*             Hauptsymboltabelle                                            */
/*                                                                           */
/* ************************************************************************* */

pass2(p,s)
T_SYSTEM * p;
ST * s;
{ int i,reusemem = reusevar;
  ST * a_ST;
  VARNODE * var, * vtemp = VARi;
  SCOPE * sc;
#ifndef ATARI_ST
#ifdef SUN
  void
#else
# ifdef MAC
    void
# else
  int
# endif
#endif
       (*sigalt)() = signal(SIGFPE, fpexep);
#endif
  VARi = NULL;
  fp_error = NEIN;
  akt_scope = NULL;
  parsestate = -1;
  GET_MEM(typ_s,1,ST_TYPE);
  typ_s->liste = typen_liste;
  typen_liste = typ_s;
  typ_s->Art = ST_TSARRAY;
  typ_s->firstelem = CHAR;
  dim_ST = s;

  interpreter = 1;
  a_ST = akt_ST;
  dim_strings_vorbereiten();  
  do_connections(p->decl);
  var = VARi;
  reusevar = 1;
  while (var != NULL)
  { free_hvar(var);
    var = var->lk;
  }
  reusevar = reusemem;
  grund_ST = (akt_ST = a_ST)->Obertabelle;
  vector_ST = akt_ST;
  Const_expr = 0;
  VARi = vtemp;
  Const_expr = 1;
  akt_conf = default_conf = NULL;
  if (p->confs)
  { if (p->confs->link == NULL)
    { if (p->confs->conf)
      { if (p->confs->conf->link == NULL)
        { default_conf = p->confs->conf;
          dim_typen = default_conf->typ;
          vector_ST = p->confs->vectors;
          activation(vector_ST->dim);
        }
      } 
    }
    conf_groups = p->confs;
  }
  vector_ST_entfernen();
  sc = new_scope(akt_scope);
  akt_scope = sc;
  if (p->sys_ident)
    sc->ein = suche_Eintrag(p->sys_ident->wert.ident_nr,akt_ST,GLOBAL,0);
  sc->st = akt_ST;
  p->scop = sc;
  activ_check = 0;
  reset_vector_STs();
  proc_anweisungen(p->decl);
  nomore = 0;
  loopleft = 0;
  if (yynerrs == 0)
  { interpreter = 0; }
  else
  { interpreter = 1; }
  for (i = BOOLEAN; i <= ALL; i++)
  { s->ControlVarAnzMem[i] = s->ControlVarAnz[i];
    s->LocalVarAnzMem[i] = s->LocalVarAnz[i];
  }
  akt_ST = s;
  proc_info = PI_SCALAR;
  info_proc = (p->confs) ? 2 : 1;
  proc_parall = 0;
  VARi = NULL;
  hvarsvect = hvarsscal = NULL;
  vector_ST_entfernen();
  akt_timestamp = timestamp;
  if (p->sys_ident)
  { akt_proc_eintr = suche_Eintrag(p->sys_ident->wert.ident_nr,akt_ST,GLOBAL,0); }
  else
    akt_proc_eintr = NULL;
  haupt_program = 1;
  member_of_conf = -1;
  anweisungen(p->statements);
  if (akt_proc_eintr)
    akt_proc_eintr->param.proz.info = info_proc;
  if (interpreter == 0)
  { VARNODE * var;
    int reusemem = reusevar;
    if (p->confs)
    { int port_var = 0;
      C_GROUP * g = p->confs;
      while (g)
      { port_var = (port_var >= g->port_variable) ?  port_var : g->port_variable;
        g = g->link;
      }
      if (p->port_variables = port_var)
      { Eintrag * e = akt_ST->scalar;
        while (e)
        { if (e->param.var.dir_indir || (e->param.var.type->firstelem == INTEGER))
          { e->param.var.nummer += port_var; }
         e = e->link;
        }
        akt_ST->ControlVarAnz[ALL] += port_var;
        akt_ST->ControlVarAnz[INTEGER] += port_var;
      }
    }
    var = VARi;
    reusevar = 1;
    while (var != NULL)
    { free_hvar(var);
      var = var->lk;
    }
    reusevar = reusemem;
    if (p->confs)
    { C_GROUP * g = p->confs;
      while (g)
      { vergebe_var_nummer(g->vectors->hvarsvect,g->vectors->LocalVarAnz,
                           g->vectors->LocalHilfVarAnz,0); 
        g = g->link;
      }
    }
    else
    { vergebe_var_nummer(hvarsvect,akt_ST->LocalVarAnz,akt_ST->LocalHilfVarAnz,0); }
    vergebe_var_nummer(akt_ST->hvarsscal = hvarsscal,akt_ST->ControlVarAnz,
                       akt_ST->ControlHilfVarAnz,0);
    vergebe_comp_nummer(wcomp);
  }
  cross_checking();
  if (interpreter == 0)
    programm_ausgeben(p,Namensliste(protokoll,p->sys_ident->wert.ident_nr));
#ifndef ATARI_ST
  signal(SIGFPE,sigalt);
#endif
}

/* ************************************************************************* */
/* Auswertung der Anweisungen einer Prozedur/Funktion                        */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Deklarationen                                                 */
/*                                                                           */
/* ************************************************************************* */

proc_anweisungen(d)
T_DECLARATIONS * d;
{ if (d)
  { proc_anweisungen(d->link);
    if (d->select == N_PROCEDURE)
    { procedure_anweisungen(d->art.procs); }
    else if (d->select == N_CONFIGURATION)
    { C_GROUP * g;
      if (g = d->art.conf->group)
      { HVARS * hv, * hs;
        int reusemem;
        VARNODE * var;
        hv = hvarsvect;
        hs = hvarsscal;
        hvarsvect = g->temp->hvarsvect;
        hvarsscal = g->temp->hvarsscal;
        var = VARi;
        reusemem = reusevar;
        reusevar = 1;
        while (var != NULL)
        { free_hvar(var);
          var = var->lk;
        }
        reusevar = reusemem;
        vergebe_var_nummer(g->temp->hvarsvect,g->temp->LocalVarAnz,
                           g->temp->LocalHilfVarAnz,g->temp->Ebene); 
        vergebe_var_nummer(g->temp->hvarsscal,g->temp->ControlVarAnz,
                           g->temp->ControlHilfVarAnz,g->temp->Ebene); 
        hvarsvect = hv;
        hvarsscal = hs;
        vector_Ebene = (vector_tab = g->vectors)->Ebene;
        actual_group_nr = g->group_nr;
      }
      else
      { vector_tab = NULL;
        actual_group_nr = 0;
        vector_Ebene = -1;
      }
      vector_ST_entfernen();
      activate_vector_vars(d->art.conf);
      if ((!g->link) && (g->conf_anf == g->conf_end) &&
	  (d->art.conf && !d->art.conf->link))
        default_conf = g->conf;
      else
        default_conf = NULL;;
    }
  }
}

/* ************************************************************************* */
/* Aktiviere die Vektortabelle die zur Konfiguration geh"ort                 */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Konfigurationsdeklaration                                     */
/*                                                                           */
/* ************************************************************************* */

activate_vector_vars(c)
T_CONFIG * c;
{ Eintrag * ein;
  if (c)
  { if (ein =  suche_Eintrag(c->ident->wert.ident_nr,akt_ST,GLOBAL,0))
    { if (ein->Art == N_CONFIGURATION)
      { vector_ST_eintragen(ein->param.config.tab); }
      else
        activate_vector_vars(c->link);
    }
    else
      activate_vector_vars(c->link);
  }
}


/* ************************************************************************* */
/* Deaktiviere die Nur-Lese-Variablen DIMi                                   */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter :                                                               */
/*                                                                           */
/* ************************************************************************* */

deactivate_dimis()
{ Eintrag * e = vector_ST->dim;
  if (default_conf)
  { C_GROUP * g = get_group(default_conf->conf_nr);
    if (vector_ST == g->vectors)
      return;
  }
  while (e)
  { e->gueltig = 0;
    e->param.var.type = typ_int;
    e = e->link;
  }
}


/* ************************************************************************* */
/* Aktiviere die Nur-Lese-Variablen DIMi                                     */
/*                                                                           */
/* Ergebnis : die Konfiguration                                              */
/*                                                                           */
/* Parameter : Name der Konfiguration                                        */
/*                                                                           */
/* ************************************************************************* */

C_CONF * activate_dimis(s)
SCAN_ELEM * s;
{ Eintrag * ein;
  if (s)
  { if (ein = suche_Eintrag(s->wert.ident_nr,akt_ST,GLOBAL,akt_timestamp))
    { if (ein->Art == N_CONFIGURATION)
      { C_GROUP * g;
        C_CONF * c;
        ST * v_ST = ein->param.config.tab;
        if (v_ST)
          vector_Ebene = v_ST->Ebene;
        else
          vector_Ebene = -1;
        dim_typen = ein->param.config.typ;
        akt_proz_anz = ein->param.config.proz_anz;
        vector_ST_eintragen(v_ST);
        if (v_ST->Ebene == akt_ST->Ebene)
        { akt_ST->hvarsvect = hvarsvect;
          hvarsvect = v_ST->hvarsvect;
        }
        activation(v_ST->dim);
        if (g = get_group(ein->param.config.conf_nr))
        { c = g->conf;
          actual_group_nr = g->group_nr;
          port_variable = g->port_variable;
          while (c && (c->conf_nr != ein->param.config.conf_nr))
          { c = c->link; }
          return (akt_conf = c);
        }
        interpreter = 1;
        return (akt_conf = NULL);
      }
      else
      { SEMERROR(s->Zeile,s->Posit,ein->Zeile,ein->Posit,text[124]);
        interpreter = 1;
        return (akt_conf = NULL);
      }
    }
    else
    { SEMERROR(s->Zeile,s->Posit,0,0,text[124]);
      interpreter = 1;
      return (akt_conf = NULL);
    }
  }
  else
  { if (default_conf)
    { C_GROUP * g = get_group(default_conf->conf_nr);
      if (g)
      { ST * v_ST = g->vectors;
        dim_typen = default_conf->typ;
        akt_proz_anz = g->proz_anz;
        vector_ST_eintragen(v_ST);
        if (v_ST->Ebene == akt_ST->Ebene)
        { akt_ST->hvarsvect = hvarsvect;
          hvarsvect = v_ST->hvarsvect;
        }
        activation(v_ST->dim);
        return (akt_conf = default_conf);
      }
      return (akt_conf = default_conf);
    }
    interpreter = 1;
    return (akt_conf = NULL);
  }
}

/* ************************************************************************* */
/* Aktivierung der DIMi-Variablen                                            */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Liste der Variablen                                           */
/*                                                                           */
/* ************************************************************************* */

activation(e)
Eintrag * e;
{ if (e)
  { activation(e->link);
    if (dim_typen)
    { e->gueltig = 1;
      e->param.var.type = dim_typen->info.array.bereich;
      dim_typen = dim_typen->info.array.typ;
    }
    else
    { e->gueltig = 0;
      e->param.var.type = typ_int;
    }
  }
}
  
extern ST_PARAM * erzeuge_param();

/* ************************************************************************* */
/* Auswertung der Anweisungen einer Prozedur/Funktion                        */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Prozedurzeiger                                                */
/*                                                                           */
/* ************************************************************************* */

procedure_anweisungen(z)
T_PROCEDECL * z;
{ T_PARAM * pa;
  int i,reusemem = reusevar;
  VARNODE * var, * vtemp;
  ST * st = akt_ST;
  ST * vst = vector_ST;
  ST * vector_tmp = NULL;
  int vector_flag = 0;
  C_CONF * a_con = akt_conf, * d_con = default_conf;
  SCOPE * sc;
  C_GROUP  * g = NULL;
  int has_sel = has_selection;
  has_selection = 0;
  if (z->proc_mode & SELEKTION)
    has_selection = 1;
  if (z->confs)
    conf_groups = z->confs;
  akt_conf = default_conf = NULL;
  akt_ST = z->ST;
  vtemp = VARi;
  VARi = NULL;
  do_connections(z->decls);
  var = VARi;
  reusevar = 1;
  while (var != NULL)
  { free_hvar(var);
    var = var->lk;
  }
  reusevar = reusemem;
  VARi = vtemp;
  akt_ST = z->ST;
  vector_ST = akt_ST;
  if (z->confs)
  { if (z->confs->link == NULL)
    { if (z->confs->conf)
      { if (z->confs->conf->link == NULL)
        { default_conf = z->confs->conf;
          vector_ST = z->confs->vectors;
        }
      }
    }
  }
  else
    default_conf = d_con;
  sc = new_scope(akt_scope);
  akt_scope  = sc;
  sc->st = z->ST;
  akt_ST->Obertabelle = vst;
  sc->ein = z->reference;
  z->protokollart = Namensliste(protokoll,sc->ein->name_nr);
  if (z->reference != NULL)
  { z->reference->param.proz.scop = sc;
    z->reference->param.proz.debug = Namensliste(debug_proz,sc->ein->name_nr);
  }
  proc_anweisungen(z->decls);
  member_of_conf = 0;
  if (has_selection || (!default_conf && (z->proc_mode & SELEKTION)))
  { vector_tmp = vector_ST_entfernen();
    vector_ST = akt_ST;
    member_of_conf = -1;
  }
  else
  { if (default_conf && !(z->proc_mode & SELEKTION))
    { g = get_group(default_conf->conf_nr);
      if (g)
      { port_variable = g->port_variable;
        akt_proz_anz = g->proz_anz;
        vector_ST_eintragen(g->vectors);
        if (g->conf_anf == g->conf_end)
          activate_dimis(NULL);
        vector_flag = 1;
      }
      akt_conf = default_conf;
    }
    else
    { if (!(z->proc_mode & SELEKTION) && (vector_tab))
      vector_ST_eintragen(vector_tab);
      vector_flag = 1;
    }
  }
  if (z->proc_mode & SELEKTION)
    member_of_conf = -1;
  z->scop = sc;
  akt_timestamp = z->last_index;
  z->zeilen += 2;
  proc_info = z->proc_info;
  if (proc_info & PI_VECTOR)
  { proc_parall = P_PARAL; }
  for (i = BOOLEAN; i <= ALL; i++)
  { akt_ST->ControlVarAnzMem[i] = akt_ST->ControlVarAnz[i];
    akt_ST->LocalVarAnzMem[i] = akt_ST->LocalVarAnz[i];
  }
  hvarsvect = akt_ST->hvarsvect;
  hvarsscal = akt_ST->hvarsscal;
    
  if (yynerrs == 0)
  { interpreter = 0; }
  else
  { interpreter = 1; }
  if ((akt_proc_eintr = z->reference) != NULL)
  { z->reference->param.proz.posnr = prozedur_zeilen;
    proc_info |= z->reference->param.proz.parall;
    info_proc = z->reference->param.proz.info;
    proc_scavec = z->reference->param.proz.scavec;
    erzeuge_param_code(z->paramseq);
  }
  else
  { info_proc = proc_info = proc_scavec = 0;
    erzeuge_param_code(z->paramseq);
  }
  info_proc |= (z->confs) ? 2 : 0;
/*  VARi = z->hvlist;*/
  retexit = ERL_RET;
  if (z->type != NULL)
  { returntyp = z->type->erg_typ;
    returnstat = 0;
    proc_scavec = ((z->scavec != NULL) && (z->scavec->Art == _VECTOR)) ? 1 : 0;
  }
  else
  { returntyp = NULL;
    returnstat = 1;
    proc_scavec = 0;
  }
  nomore = 0;
  loopleft = 0;
  anweisungen(z->statements);
  if ((member_of_conf > 0) && z->reference)
    z->reference->param.proz.conf_nr = member_of_conf;
  if (g)
    g->port_variable = port_variable;
  if (vector_flag)
    vector_ST_entfernen();
  if (vector_tmp)
    vector_ST_eintragen(vector_tmp);
  if ((returnstat == 0) && (nomore == 0))
  { SEMERROR(z->Zeile,z->Posit,0,0,text[328]);
    interpreter = 1;
  }
  if (interpreter == 0)
  { VARNODE * var;
    int reusemem = reusevar;
    if (z->confs)
    { int port_var = 0;
      C_GROUP * g = z->confs;
      while (g)
      { port_var = (port_var >= g->port_variable) ?  port_var : g->port_variable;
        g = g->link;
      }
      if (z->port_variables = port_var)
      { Eintrag * e = akt_ST->scalar;
        while (e)
        { if (e->param.var.dir_indir || (e->param.var.type->firstelem == INTEGER))
          { e->param.var.nummer += port_var; }
         e = e->link;
        }
        akt_ST->ControlVarAnz[ALL] += port_var;
        akt_ST->ControlVarAnz[INTEGER] += port_var;
      }
    }
    reusevar = 1;
    var = VARi;
    while (var != NULL)
    { free_hvar(var);
      var = var->lk;
    }
    VARi = NULL;
    reusevar = reusemem;
    if (z->confs)
    { C_GROUP * g = z->confs;
      while (g)
      { vergebe_var_nummer(g->vectors->hvarsvect,g->vectors->LocalVarAnz,
                           g->vectors->LocalHilfVarAnz,g->vectors->Ebene); 
        g = g->link;
      }
    }
    else
    { vergebe_var_nummer(hvarsvect,akt_ST->LocalVarAnz,akt_ST->LocalHilfVarAnz,akt_ST->Ebene);
      akt_ST->hvarsvect = hvarsvect;
    }
    vergebe_var_nummer(hvarsscal,akt_ST->ControlVarAnz,akt_ST->ControlHilfVarAnz,akt_ST->Ebene);
    vergebe_comp_nummer(wcomp);
    pa = z->paramseq;
    while (pa != NULL)
    { z->zeilen += pa->zeilen;
      pa = pa->link;
    }
    z->zeilen += statement_lines(z->statements); 
    akt_ST->hvarsscal = hvarsscal;
  }
  retexit = 0;
  if (z->reference != NULL)
  { z->reference->param.proz.parall = proc_info;
    z->zeilen += (z->reference->param.proz.debug == 0) ? 0 :
                 ((z->type == NULL) ? 2 : 3);
    z->reference->param.proz.info = info_proc;
  }
  if (z->confs)
  { vector_tab = NULL; }
  prozedur_zeilen += z->zeilen;
  akt_conf = a_con;
  default_conf = d_con;
  akt_ST = st;
  vector_ST = vst;
  has_selection |= has_sel;
  akt_scope = akt_scope->super;
}

/* ************************************************************************* */
/* ermittle den Wert eines Namens und des Anfangs ihres Datentyps            */
/*                                                                           */
/* Ergebnis : Wert der Konstanten                                            */
/*                                                                           */
/* Parameter : Name                                                          */
/*             Beginn des Bereichs                                           */
/*                                                                           */
/* ************************************************************************* */

int get_Constant(z,bas)
SCAN_ELEM * z;
int * bas;
{ if (z != NULL)
  { if (z->Art == INTCONSTANT)
    { * bas = 0;
      return (z->wert.i);
    }
    else
    if (z->Art == IDENT)
    { Eintrag * ein;
      if ((ein = suche_Eintrag(z->wert.ident_nr,vector_ST,GLOBAL,akt_timestamp)) != NULL)
      { if (ein->Art == N_CONSTANT)
        { if (ein->gueltig)
          { int wert, basis;
            switch (ein->ST_CSEL)
            { case ST_CINT :
                basis = 0;
                wert = ein->ST_CGINT;
                break;
              case ST_CENUM :
                basis = ein->ST_CRVON;
                wert = ein->ST_CRVAL;
                break;
              default :
                SEMERROR(z->Zeile,z->Posit,ein->Zeile,ein->Posit,text[170]);
                interpreter = 1;
                wert = basis = 0;
                break;
            }
            * bas = basis;
            return wert;
          }
          else
          { SEMERROR(z->Zeile,z->Posit,ein->Zeile,ein->Posit,text[171]);
            interpreter = 1;
            * bas = 0;
            return 0;
          }
        }
        else       
        { SEMERROR(z->Zeile,z->Posit,ein->Zeile,ein->Posit,text[172]);
          interpreter = 1;
          * bas = 0;
          return 0;
        }
      }
      else
      { SEMERROR(z->Zeile,z->Posit,0,0,text[173]);
        interpreter = 1;
        * bas = 0;
        return 0;
      }
    }
    else
    { SEMERROR(z->Zeile,z->Posit,0,0,text[174]);
      interpreter = 1;
      * bas = 0;
      return 0;
    }
  }
  return 0;
}

/* ************************************************************************* */
/* ermittle den Typ eines Ausdrucks mit Indizierung                          */
/*                                                                           */
/* Ergebnis : Datentyp                                                       */
/*                                                                           */
/* Parameter : Indizierungsausdruecke                                        */
/*             Datentyp des Feldes                                           */
/*             scalar oder vektorielles Feld                                 */
/*             Zugriffszwischencode fuer den Zugriff                         */
/*                                                                           */
/* ************************************************************************* */

ST_TYPE * arrayexpr(expr,t,pnp,arc)
T_EXPR * expr;
ST_TYPE * t;
int pnp;
AR_COMP ** arc;
{ if (expr != NULL)
  { if (expr->link != NULL)
    { t = arrayexpr(expr->link,t,pnp,arc); }
    expr_auswerten(expr,0);
    if (t != NULL)
    { if (t->Art == ST_TARRAY)
      { if (match_typen(t->info.array.bereich,expr->erg_typ,0) == JA)
        { if ((expr->scavec > pnp) && (expr->error == 0))
          { SEMERROR(expr->Zeile,expr->Posit,0,0,text[175]);
            interpreter = 1;
          }
          array_offset(expr,t->info.array.bereich,t->info.array.typ,arc);
          t = t->info.array.typ;
        }
        else
        { if ((t != typ_error) && (expr->error == 0))
            SEMERROR(expr->Zeile,expr->Posit,0,0,text[176]);
          interpreter = 1;
          t = typ_error;
        }
      }
      else
      { if (t != typ_error)
          SEMERROR(expr->Zeile,expr->Posit,0,0,text[177]);
        interpreter = 1;
        t = typ_error;
      }
    }
  }
  return t;
}

/* ************************************************************************* */
/* ermittle den Typ eines Ausdrucks mit Selektion                            */
/*                                                                           */
/* Ergebnis : Datentyp                                                       */
/*                                                                           */
/* Parameter : Selektionsname(n)                                             */
/*             Datentyp des Feldes                                           */
/*             scalar oder vektorielles Feld                                 */
/*             Zugriffszwischencode fuer den Zugriff                         */
/*                                                                           */
/* ************************************************************************* */

ST_TYPE * designrest(design,t,pnp,arc,dind)
T_DESIGNREST *  design;
ST_TYPE * t;
int pnp;
AR_COMP ** arc;
int dind;
{ if (design != NULL)
  { if (design->link != NULL)
    { t = designrest(design->link,t,pnp,arc,0); }
    if (design->select == D_RECORD)
    { if ((t->Art == ST_TRECORD) || (t->Art == ST_TRECORDREST))
      { Eintrag * rueck;
        rueck = suche_Eintrag(design->design.ident->wert.ident_nr,t->info.record.symtab,
                              LOCAL,0);
        if (rueck != NULL)
        { AR_COMP * ar;
          t = rueck->param.komp.type;
          if (rueck->param.komp.reladr)
          { GET_MEM(ar,1,AR_COMP);
            ar->link = *arc;
            *arc = ar;
            ar->art = 1;
            ar->ar.record.comp = rueck->param.komp.reladr;
            ar->ar.record.typ = rueck->param.komp.styp;
          }
        }
        else
        { SEMERROR(design->design.ident->Zeile,design->design.ident->Posit,0,0,text[178]);
          interpreter = 1;
          t = typ_error;
        }
      }
      else
      { if (t != typ_error)
          SEMERROR(design->design.ident->Zeile,design->design.ident->Posit,0,0,text[179]);
        interpreter = 1;
        t = typ_error;
      }
    }
    else
    { if (design->select == D_ARRAY)
      { if (t->Art == ST_TARRAY)
        { t = arrayexpr(design->design.exprlist,t,pnp,arc); }
        else
        { if (t != typ_error)
            SEMERROR(design->design.exprlist->Zeile,design->design.exprlist->Posit,0,0,
                     text[180]);
          interpreter = 1;
          t = typ_error;
        }
      }
      else
      { if (t->Art == ST_TPOINTER)
        { AR_COMP * ar;
          t = t->info.pointer.type;
          GET_MEM(ar,1,AR_COMP);
          ar->link = *arc;
          *arc = ar;
          ar->art = 2;
          ar->ar.pointer.mode = 1;
          if (dind)
          { GET_MEM(ar,1,AR_COMP);
            ar->link = *arc;
            *arc = ar;
            ar->art = 2;
            ar->ar.pointer.mode = 1;
          }
        }
        else
        { if (t != typ_error)
            SEMERROR(design->design.deref->Zeile,design->design.deref->Posit,0,0,
                     text[180]);
          interpreter = 1;
          t = typ_error;
        }
      }
    }
  }
  return t;
}

/* #ifndef PC
/* open file */
/* ************************************************************************* */
/* pruefe Strukturkomponenten und Liste von Ausdruecken auf Typvertraeglichk.*/
/*                                                                           */
/* Ergebnis : JA oder NEIN                                                   */
/*                                                                           */
/* Parameter : Typ der Struktur                                              */
/*             Liste der Ausdruecke                                          */
/*             Zeilennummer des Strukturnamens                               */
/*             Spaltennummer des Strukturnamen                               */
/*             Zuweisung an Variable Ja oder Nein                            */
/*                                                                           */
/* ************************************************************************* */

int teste_record(t,expr,z,p,cr)
ST_TYPE * t;
T_EXPR * expr;
int z,p,cr;
{ /* vergleiche Exprlistkomponenten mit Strukturbeschreibung */
  record_typ = t;
  record_mem = t->info.record.mem;
  if ((pruefe_record(expr,cr) == JA)  && (record_mem == NULL))
    return JA;
  if (record_mem)
  { SEMERROR(z,p,0,0,text[207]);
    interpreter = 1;
    return NEIN;
  }
  if ((record_mem == NULL) && (record_typ == NULL))
  { SEMERROR(z,p,0,0,text[208]);
    interpreter = 1;
    return NEIN;
  }
  return NEIN;
}


/* ************************************************************************* */
/* pruefe eine Strukturkomponente und einen Ausdruck auf Typvertraeglichkeit */
/*                                                                           */
/* Ergebnis : JA oder NEIN                                                   */
/*                                                                           */
/* Parameter : Ausdruck                                                      */
/*             Zuweisung an Variable Ja oder Nein                            */
/*                                                                           */
/* ************************************************************************* */

int pruefe_record(ex,cr)
T_EXPR * ex;
int cr;
{ int rueck;
  rueck = JA;
  if (ex != NULL)
  { if (ex->link != NULL)
      rueck = pruefe_record(ex->link,cr);
    if ((record_typ == NULL) || (record_mem == NULL))
      return NEIN;
    if (match_typen(record_mem->inh.typ,ex->erg_typ,0) != JA)
    { if (ex->error == 0)
        SEMERROR(ex->Zeile,ex->Posit,0,0,text[209]);
      interpreter = 1;
      return NEIN;
    }
    if (cr != JA)
    { if (ex->erg_art == ERG_CONST)
      { ex->zeilen = ex->erg_typ->used[ALL] * 2 - 1; }
    }
    else
    { ex->erg.Const->type = record_mem->inh.typ; }
    if  (record_mem->flag)
    { record_typ = NULL;
      record_mem = NULL;
    }
    else
      record_mem = record_mem->link;
    record_scavec |= ex->scavec;
    return rueck;
  }
  return NEIN;
}
          
/* ************************************************************************* */
/* ermittle Wert, Basis und Typ einer Konstanten (Bereichsgrenzen)           */
/*                                                                           */
/* Ergebnis : JA oder NEIN                                                   */
/*                                                                           */
/* Parameter : Konstante                                                     */
/*             Wert der Konstanten                                           */
/*             Basis der Konstanten                                          */
/*             Zeilennummer des Namens                                       */
/*             Spaltennummer des Namens                                      */
/*             Datentyp der Konstanten                                       */
/*                                                                           */
/* ************************************************************************* */

int ermittle_grenze(se,wert,basis,Zeile,Posit,typ)
ST_CONST * se;
int * wert, * basis;
int Zeile, Posit;
ST_TYPE ** typ;
{ int ret;
  ret = NEIN;
  *wert = -1;
  *basis = -3;
  *typ = typ_error;
  if (se != NULL)
  { switch (se->Art)
    { case ST_CINT :
        *wert = se->wert.i;
        *basis = 0;
        *typ = typ_int;
        ret = JA;
        break;
      case ST_CSTRING :
        if (se->wert.s.len == 1)
        { *wert = 0 + *(se->wert.s.string);
          *basis = 0;
          *typ = typ_char;
          ret = JA;
        }
        else
        { SEMERROR(Zeile,Posit,0,0,text[210]);
          interpreter = 1;
        }
        break;
      case ST_CBOOL :
        *basis = 0;
        *wert = se->wert.range.val;
        *typ = typ_bool;
        ret = JA;
        break;
      case ST_CENUM :
        *basis = se->wert.range.von;
        *wert = se->wert.range.val;
        *typ = se->type;
        ret = JA;
        break;
      default :
        { SEMERROR(Zeile,Posit,0,0,text[211]);
          interpreter = 1;
        }
        break;
    }
  }
  return ret;
}

/* ************************************************************************* */
/* trage die Datentypen zu den Variablen ein                                 */
/*                                                                           */
/* Ergebnis : JA oder NEIN                                                   */
/*                                                                           */
/* Parameter : Variablendefinitionen                                         */
/*                                                                           */
/* ************************************************************************* */

int trage_varlist_ein(z)
T_VARDEF * z;
{ T_IDENTLIST * list;
  int erg;

  erg = JA;
  if (z != NULL)
  { if (z->link != NULL)
    { erg = trage_varlist_ein(z->link); }
    if ((list = z->ident_list) != NULL)
    { set_typlist(z->type,FREE);
      erg *= trage_var_ein(list,(z->typbeschr = z->type->erg_typ));
    }
  }
  return erg;
}

/* ************************************************************************* */
/* trage den Datentyp zu einer Liste von Namen ein                           */
/*                                                                           */
/* Ergebnis : JA oder NEIN                                                   */
/*                                                                           */
/* Parameter : Liste von Namen                                               */
/*             Datentyp                                                      */
/*                                                                           */
/* ************************************************************************* */

int trage_var_ein(list,typ)
T_IDENTLIST * list;
ST_TYPE * typ;
{ Eintrag * rueck;
  int erg, hi;
  int art;

  erg = JA;
  if (list != NULL)
  { if (list->link != NULL)
    { erg = trage_var_ein(list->link,typ); }
    if (!(rueck = suche_Eintrag(list->ident->wert.ident_nr,vector_ST,GLOBAL,0)))
      return NEIN;
    if (((((art = rueck->Art) & ~N_VAR) == N_SCALAR) ||
         ((rueck->Art & ~N_VAR) == N_VECTOR)) && (typ != NULL))
    { /* Variablendefinition ermitteln und eintragen */
      rueck->param.var.type = typ;
      rueck->param.var.art = hi = typ->firstelem;
      switch (art)
      { case N_SCALAR :
          rueck->param.var.nummer = akt_ST->ControlVarAnz[hi] + 1;
          for (hi = BOOLEAN; hi <= ALL; hi++)
          { akt_ST->ControlVarAnz[hi] += typ->used[hi]; }
          rueck->param.var.dir_indir = DIRECT;
          break;
        case N_VECTOR :
          info_proc |= 16;
          rueck->param.var.nummer = vector_ST->LocalVarAnz[hi] + 1;
          for (hi = BOOLEAN; hi <= ALL; hi++)
          { vector_ST->LocalVarAnz[hi] += typ->used[hi]; }
          rueck->param.var.dir_indir = DIRECT;
          break;
        case N_SCALAR | N_VAR :
          rueck->param.var.nummer = ++(akt_ST->ControlVarAnz[INTEGER]);
          akt_ST->ControlVarAnz[ALL]++;
          rueck->param.var.dir_indir = INDIRECT;
          break;
        case N_VECTOR | N_VAR :
          info_proc |= 16;
          rueck->param.var.nummer = ++(akt_ST->LocalVarAnz[INTEGER]);
          akt_ST->LocalVarAnz[ALL]++;
          rueck->param.var.dir_indir = INDIRECT;
          break;
      }
      rueck->gueltig = typ->gueltig;
      return (typ->gueltig * erg) ? JA : NEIN;
    }
    else
    { if (art == N_RECORDCOMP)
      { rueck->param.komp.type = typ;
        rueck->param.komp.reladr = akt_ST->ControlVarAnz[ALL];
        for (hi = BOOLEAN; hi <= ALL; hi++)
        { akt_ST->ControlVarAnz[hi] += typ->used[hi]; }
        rueck->gueltig = typ->gueltig;
        return (typ->gueltig * erg) ? JA : NEIN;
      }
      return NEIN;
    }
  }
  return NEIN;
}

/* ************************************************************************* */
/* kommt der Namn in der angegebenen Liste vor                               */
/*                                                                           */
/* Ergebnis : JA oder NEIN                                                   */
/*                                                                           */
/* Parameter : Liste mit Namen                                               */
/*             Namen                                                         */
/*                                                                           */
/* ************************************************************************* */

int Namensliste(p,s)
PROTOKOLL * p;
long s;
{ while (p)
  { if (p->name_nr == s) return JA;
    p = p->link;
  }
  return NEIN;
}
/* close file */
/* open file */
/* ************************************************************************* */
/* kann die Variable getraced werden ?                                       */
/*                                                                           */
/* Ergebnis : JA oder NEIN                                                   */
/*                                                                           */
/* Parameter : Variablenknoten                                               */
/*                                                                           */
/* ************************************************************************* */

int traceable(var)
VARNODE * var;
{ if ((var != NULL) &&
      (((var->dir_indir == DIRECT) &&
        (var->ein->param.var.dir_indir != INDIRECT)) ||
       ((var->ein->Art & ~N_VAR) == N_SCALAR)))
    return JA;
  return NEIN;
}

/* ************************************************************************* */
/* werte eine LOAD-/STORE-Anweisung aus                                      */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Anweisung                                                     */
/*             LOAD oder STORE                                               */
/*                                                                           */
/* ************************************************************************* */

down_load_anal(st,art)
T_STATEMENT * st;
int art;
{ int zahl, proz_anz_tmp = akt_proz_anz;
  ST * tmp = vector_ST;
  ZWCODE * sel, * zw, * vari;
  T_EXPR * ex1, * ex2, * ex3;
  ST_TYPE * v_typ;
  VARNODE * var = NULL;
  C_CONF * co;
  SCOPE * sc = NULL;
  info_proc |= 8;
  if ((ex3 = st->st.load.lengident) && (st->st.load.selection != NULL) &&
      (st->st.load.selection->count) &&(interpreter == 0))
  { GET_MEM(var,1,VARNODE);
    var->lk = VARi;
    VARi = var;
    var->free = 1;
    var->firstelem = BOOLEAN;
    var->ein = get_hvar(typ_bool,var->scavec = 0);
    var->dir_indir = DIRECT;
    null_prozessoren = 1;
  }
  if (((proc_info & PI_VECTOR) == 0) && (!st->st.load.selection) && novector_st())
  { T_SELECT * s;
    GET_MEM(s,1,T_SELECT);
    st->st.load.selection = s;
    s->art = SE_NONE;
  }
  if (st->st.load.selection != NULL)
  { analyse_select(st->st.load.selection,
                   st->st.load.loadpos->Zeile,st->st.load.loadpos->Posit,&co);
    zahl = st->st.load.selection->proc;
    sc = st->st.load.scop = st->st.load.selection->scop;
    sel = st->st.load.selection->code;
    vari = st->st.load.selection->var;
    st->zeilen = st->st.load.selection->zeilen;
    info_proc |= 4;
    proc_info |= PI_VECTOR;
  }
  else
  { zahl = akt_proz_anz;
    sel = NULL;
    vari = NULL;
  }
  v_typ = typ_error;
  expr_auswerten(ex1 = st->st.load.vecident,0);
  if (ex1->scavec == 1)
  { v_typ = ex1->erg_typ;
    if ((ex1->erg_art == ERG_SPEC) && (ex1->error == 0))
    { zahl *= v_typ->used[ALL]; }
    else
    { if (ex1->error == 0)
        SEMERROR(ex1->Zeile,ex1->Posit,0,0,text[245]);
      ex1->error = interpreter = 1;
    }
  }
  else
  { if (ex1->error == 0)
      SEMERROR(ex1->Zeile,ex1->Posit,0,0,text[245]);
    ex1->error = interpreter = 1;
  }
  expr_auswerten(ex2 = st->st.load.scalident,0);
  if (ex2->scavec == 0)
  { if ((ex2->erg_art == ERG_SPEC) && (ex2->error == 0))
    { ST_TYPE * typ = ex2->erg_typ;
      if ((zahl > typ->used[ALL]) && (ex3 == NULL) && (ex2->error == 0))
          WARNING(/*SEMERROR(ex1->Zeile,ex1->Posit,*/ex2->Zeile,ex2->Posit,text[252]);
      { if (art == _LOAD)
        { typ_vergleich(typ,v_typ,ex1->Zeile,ex1->Posit,ex2->Zeile,ex2->Posit,
                        text[253],_LOAD);
        }
        else
        { typ_vergleich(v_typ,typ,ex1->Zeile,ex1->Posit,ex2->Zeile,ex2->Posit,
                        text[253],_STORE);
        }
      }
    }
    else
    { if (ex2->error == 0)
        SEMERROR(ex2->Zeile,ex2->Posit,0,0,text[340]);
      ex2->error = interpreter = 1;
    }
  }
  else
  { if (ex2->error == 0)
      SEMERROR(ex2->Zeile,ex2->Posit,0,0,text[256]);
    ex2->error = interpreter = 1;
  }
  if (sc)
  { akt_scope  = sc->super; }
  free_hvar(ex1->hv);
  free_hvar(ex2->hv);
  if (v_typ != typ_error)
    zahl = zahl / v_typ->used[ALL];
  if (ex3 != NULL)
  { ST_TYPE t;
    t.Art = ST_TSUBRANGE;
    t.gueltig = 1;
    t.info.range.super = typ_int;
    t.info.range.von = t.info.range.basis = 0;
    t.info.range.bis = zahl;
    expr_auswerten(ex3,0);
    if (ex3->scavec == 0)
    { if (ex3->error == 0)
      { if (ex3->erg_art == ERG_SPEC)
        { if (match_typen(ex3->erg_typ,&t,0) == JA)
          { char tx[80];
            sprintf(tx,text[343],zahl);
            typ_vergleich(&t,ex3->erg_typ,ex3->Zeile,ex3->Posit,0,0,tx,0);
          }
          else
          { SEMERROR(ex3->Zeile,ex3->Posit,0,0,text[257]);
            interpreter = 1;
          }
        }
        else
        { SEMERROR(ex3->Zeile,ex3->Posit,0,0,text[340]);
          interpreter = 1;
        }
      }
    }
    else
    { if (ex3->error == 0)
        SEMERROR(ex3->Zeile,ex3->Posit,0,0,text[256]);
      ex3->error = interpreter = 1;
    }
    free_hvar(ex3->hv);
  }
  if (interpreter == 0)
  { GET_MEM(zw,1,ZWCODE);
    zw->com.load.vek = ex1->hv;
    zw->com.load.ska = ex2->hv;
    zw->com.load.vekex = ex1->code;
    zw->com.load.skaex = ex2->code;
    zw->com.load.typ = v_typ;
    st->zeilen += ex1->zeilen + ex2->zeilen;
    if (ex3)
    { zw->com.load.len = ex3->hv;
      zw->com.load.lenex = ex3->code;
      st->zeilen += ex3->zeilen + 2;
    }
    zw->com.load.select = sel;
    zw->com.load.var = vari;
    zw->com.load.lines = st->zeilen += 1;
    zw->com.load.prozanz = zahl;
    zw->com.load.testvar = var;
    if (var)
    { st->zeilen += 3;
      free_hvar(var);
    }
    st->code = zw;
  }
  if (st->st.load.selection != NULL)
    proc_info &= ~PI_VECTOR;
  vector_ST->hvarsvect = hvarsvect;
  vector_ST = tmp;
  hvarsvect = vector_ST->hvarsvect;
  akt_proz_anz = proz_anz_tmp;
}

/* ************************************************************************* */
/* werte den Selektionsausdruck aus                                          */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Selektionsausdruck                                            */
/*             Zeilennummer der Auswahlbedingung                             */
/*             Spaltennummer der Auswahlbedingung                            */
/*                                                                           */
/* ************************************************************************* */

analyse_select(sel,zeile,posit,co)
T_SELECT * sel;
int zeile,posit;
C_CONF ** co;
{ within_selection = 1;
  if (sel != NULL)
  { SCOPE * s;
    C_GROUP * g;
    has_selection = 1;
    s = new_scope(akt_scope);
    s->parallel = 1;
    akt_scope = s;
    sel->scop = s;
    if ((*co = activate_dimis(sel->ident)) != NULL)
    { s->ein = (*co)->name;
      if (sel->count == (*co)->dims)
      { ZWCODE * code = NULL;
        calc_selection(sel);
        sel_proz_anz = akt_proz_anz;
        if (interpreter == 0)
        { T_SELECT * s = sel;
            /* echter Code */
          while (s != NULL)
          { if ((s->art != SE_ALL) && ((s->var != NULL) || (s->ranges->bis->hv != NULL)))
            { ZWCODE * zw;
              GET_MEM(zw,1,ZWCODE);
              zw->art = CO_DYN;
              zw->com.dyn.select = s->var;
              zw->com.dyn.next = code;
              zw->com.dyn.var = s->ranges->bis->hv;
              sel->zeilen += 4;
              code = zw;
            }
            s = s->link;
          }
        }
        Const_selection(sel,*co);
        sel->zeilen += 2;
        sel->var = code;
        sel->proc = sel_proz_anz;
      }
      else
      { if (sel->count != 0)
        { SEMERROR(zeile,posit,0,0,text[258]);
          interpreter = 1;
          calc_selection(sel);
        }
        else
        { sel->zeilen += 2;
          Const_selection(sel,*co);
        }
      }
      g = get_group((*co)->conf_nr);
      s->st = g->vectors;
    }
    else
    { if (default_conf)
      { dim_typen = default_conf->typ;
        activation(vector_ST->dim);
        g = get_group(default_conf->conf_nr);
        s->st = g->vectors;
        s->ein = default_conf->name;
        akt_conf = default_conf;
      }
      else
      { SEMERROR(zeile,posit,0,0,text[124]);
        interpreter = 1;
      }
      *co = NULL;
    }
  }
  within_selection = 0;
}

/* ************************************************************************* */
/* berechne die Selektionen                                                  */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Selektionen                                                   */
/*                                                                           */
/* ************************************************************************* */

calc_selection(sel)
T_SELECT * sel;
{ if (sel->link != NULL)
  { calc_selection(sel->link);
    sel->zeilen = sel->link->zeilen;
  }
  if (sel->art == SE_ALL)
    return;
  if (sel->ranges->count > 1)
  { select_expr = 0; }
  else
  { select_expr = 1; }
  sel_proz_anz = 0;
  subrange_auswerten(sel->ranges,sel->count);
  sel->var = sel->ranges->bis->code;
  sel->zeilen += sel->ranges->zeilen;
  sel->anzahl = sel_proz_anz;
}

/* ************************************************************************* */
/* werte die Unterbereiche aus                                               */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Unterbereiche                                                 */
/*             Nummer der Dimension (fuer dimi)                              */
/*                                                                           */
/* ************************************************************************* */

subrange_auswerten(sr,dimens)
T_SUBRANGE * sr;
int dimens;
{ int dim_select = 0;
  if (sr->link != NULL)
  { subrange_auswerten(sr->link,dimens);
    sr->zeilen = sr->link->zeilen;
  }
  if (sr->von != NULL)
  { expr_auswerten(sr->von,0);
    if ((sr->von->error == 0) && (match_typen(sr->von->erg_typ,typ_int,0) != JA))
    { SEMERROR(sr->von->Zeile,sr->von->Posit,0,0,text[259]);
      interpreter = sr->von->error = 1;
    }
    if (select_expr == 0)
    { if ((sr->von->error == 0) && (sr->von->erg_art != ERG_CONST))
      { SEMERROR(sr->von->Zeile,sr->von->Posit,0,0,text[260]);
        interpreter = sr->von->error = 1;
      }
    }
    else
      if (sr->von->erg_art != ERG_CONST)
      { dim_select = 1; }
  }
  expr_auswerten(sr->bis,0);
  if ((sr->bis->error == 0) && select_expr && (sr->von == NULL) &&
      (match_typen(sr->bis->erg_typ,typ_bool,0) == JA))
  { if (sr->bis->erg_art != ERG_CONST)
      mache_Constexpr(sr->bis,typ_bool,0);
    sr->zeilen += sr->bis->zeilen;
    free_hvar(sr->bis->hv);
    return;
  }
  if ((sr->bis->error == 0) && (match_typen(sr->bis->erg_typ,typ_int,0) != JA))
  { SEMERROR(sr->bis->Zeile,sr->bis->Posit,0,0,text[259]);
    interpreter = sr->bis->error = 1;
  }
  else
  { if (select_expr == 0)
    { if ((sr->bis->error == 0) && (sr->bis->erg_art != ERG_CONST))
      { SEMERROR(sr->bis->Zeile,sr->bis->Posit,0,0,text[260]);
        interpreter = sr->bis->error = 1;
      }
    }
    else
      if (sr->bis->scavec == 0)
        sel_proz_anz = 1;
  }
  if ((sr->bis->erg_art != ERG_CONST) && (match_typen(sr->bis->erg_typ,typ_int,0) == JA))
  { dim_select = 1; }
  if (dim_select && (interpreter == 0))
  { char tx[15];
    VARNODE * var;
    VARNODE * var1, * var2;
    ZWCODE * zw;
    long nr;
    int art = IDENT;
    GET_MEM(zw,1,ZWCODE);
    zw->art = CO_DIMSEL;
    GET_MEM(var,1,VARNODE);
    var->free = 0;
    var->firstelem = INTEGER;
    var->dir_indir = DIRECT;
    GET_MEM(var1,1,VARNODE);
    var1->lk = VARi;
    VARi = var1;
    var1->free = 1;
    var1->dir_indir = DIRECT;
    var1->scavec = 1;
    var1->firstelem = BOOLEAN;
    var1->ein = get_hvar(typ_bool,1);
    zw->com.dimsel.hv1 = var1;
    sprintf(tx,"DIM%d",dimens);
    enterstring(tx,&nr,&art);
    var->ein = suche_Eintrag(nr,vector_ST,GLOBAL,akt_timestamp);
    zw->com.dimsel.dim = var;
    mache_Constexpr(sr->bis,typ_int,0);
    if (sr->von != NULL)
    { mache_Constexpr(sr->von,typ_int,0); 
      GET_MEM(var2,1,VARNODE);
      var2->lk = VARi;
      VARi = var2;
      var2->free = 1;
      var2->dir_indir = DIRECT;
      var2->scavec = 1;
      var2->firstelem = BOOLEAN;
      var2->ein = get_hvar(typ_bool,1);
      free_hvar(var2);
      free_hvar(sr->von->hv);
      zw->com.dimsel.von = sr->von->hv;
      if (sr->von->erg_art == ERG_CONST)
        zw->com.dimsel.co1 = sr->von->erg.Const;
      zw->com.dimsel.ex1 = sr->von->code;
      sr->zeilen += sr->von->zeilen + 2;
      zw->com.dimsel.hv2 = var2;
    }
    free_hvar(var1);
    free_hvar(sr->bis->hv);
    zw->com.dimsel.ex2 = sr->bis->code;
    zw->com.dimsel.bis = sr->bis->hv;
    if (sr->bis->erg_art == ERG_CONST)
      zw->com.dimsel.co2 = sr->bis->erg.Const;
    sr->zeilen += 1;
    sr->bis->code = zw;
    var1->link = sr->bis->hv;
    sr->bis->hv = var1;
  }    
  sr->zeilen += sr->bis->zeilen;
}
  

/* ************************************************************************* */
/* werte die ELSIF-Teile einer Anweisung aus                                 */
/*                                                                           */
/* Ergebnis : skalar oder vektoriell                                         */
/*                                                                           */
/* Parameter : ELSIF-Teil                                                    */
/*             bisher skalar oder vektoriell                                 */
/*             Hilfsvariable bei vektoriell                                  */
/*             mit ELSE/ELSIF danach                                         */
/*                                                                           */
/* ************************************************************************* */

int elsif_anweisungen(elsif,scavec,m,i,s)
T_ELSIF * elsif;
int scavec;
VARNODE ** m;
int i, * s;
{ T_EXPR * expr;
  ZWCODE * zw;
  int mem = retexit;
  int nomore_mem;
  int plus = 0;
  int merke = 0;
  nomore_mem = nomore;
  if (elsif->link != NULL)
  { scavec = elsif_anweisungen(elsif->link,scavec,m,i + 1,s); }
  expr_auswerten(expr = elsif->expr,0);
  if ((match_typen(typ_bool,expr->erg_typ,0) != JA) && (expr->error == 0))
  { SEMERROR(expr->Zeile,expr->Posit,0,0,text[137]);
    interpreter = 1;
  }
  else
  { if (expr->erg_art == ERG_CONST)
    { WARNING(expr->Zeile,expr->Posit,text[216]);
      if (expr->erg.Const->wert.range.val == 0)
      { nomore = (nomore == 0) ? 1 : nomore;
        merke = 1;
      }
    }
    mache_Constexpr(expr,typ_bool,1);
    if (expr->scavec == 1)
    { if ((expr->error == 0) && (proc_info & PI_SCALAR) && ((proc_info & PI_VECTOR) == 0))
      { SEMERROR(expr->Zeile,expr->Posit,0,0,text[262]);
        interpreter = 1;
      }
      else
      { if ((proc_info & PI_SCALAR) == 0)
          proc_info |= PI_VECTOR;
      }
      scavec = 1;
      retexit = 0;
    }
  }
  if ((scavec == 1) && i && (*m == NULL))
  { VARNODE * var;
    GET_MEM(var,1,VARNODE);
    var->lk = VARi;
    VARi = var;
    var->dir_indir = DIRECT;
    var->free = 1;
    var->ein = get_hvar(typ_bool,var->scavec = 1);
    var->firstelem = BOOLEAN;
    *m = var;
    plus = 1;
  }
  free_hvar(elsif->expr->hv);
  if (*s)
    nomore = (nomore == 0) ? 1 : nomore;
  anweisungen(elsif->statements);
  if (merke)
  { *s = 1; }
  nomore = nomore_mem;
  if (interpreter == 0)
  { int z, z1, z2;
    z1 = ((*m == NULL) || plus) ? 0 : (expr->zeilen + 3);
    z2 = ((*m == NULL) || plus) ? expr->zeilen : 0;
    GET_MEM(zw,1,ZWCODE);
    zw->art = CO_IFTHEN;
    zw->com.ifthen.scavec = scavec;
    zw->com.ifthen.main = *m;
    zw->com.ifthen.bool = expr->hv;
    zw->com.ifthen.stat = elsif->statements;
    zw->com.ifthen.expr = expr->code;
    zw->com.ifthen.plus = plus;
    zw->com.ifthen.cont = z = statement_lines(elsif->statements) + scavec * (2 +
                              ((i) ? 1 : 0)) + z1;
    z = zw->com.ifthen.size = z + 1 + plus + z2;  
    elsif->code = zw;
    elsif->zeilen = z;
  }
  retexit = mem;
  return scavec;
}

/* ************************************************************************* */
/* wieviel PARZ-Zeilen benoetigt eine Folge von Anweisungen                  */
/*                                                                           */
/* Ergebnis : Anzahl der Zeilen                                              */
/*                                                                           */
/* Parameter : Folge von Anweisungen                                         */
/*                                                                           */
/* ************************************************************************* */

int statement_lines(st)
T_STATEMENT * st;
{ int sum = 0;
  while (st != NULL)
  { sum += st->zeilen;
    st = st->link;
  }
  return sum;
}


/* ************************************************************************* */
/* vermerke eine Prozedur als benutzt in der Liste der Prozeduren            */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Zeiger auf die Prozedur                                       */
/*             Zeilennummer der Benutzung                                    */
/*             Spaltennummer der Benutzung                                   */
/*             im parallelen oder im skalaren Teil                           */
/*                                                                           */
/* ************************************************************************* */

procedure_benutzen(eintr,Zeile,Posit,mode)
Eintrag * eintr;
int Zeile,Posit,mode;
{ PROCLIST * pl;
  GET_MEM(pl,1,PROCLIST);
  pl->wo = akt_proc_eintr;
  pl->wer = eintr;
  pl->Zeile = Zeile;
  pl->Posit = Posit;
  pl->mode = mode;
  pl->conf = actual_group_nr;
  pl->link = used_proc;
  used_proc = pl;
}

/* ************************************************************************* */
/* bilde eine Menge aus den Element-Angaben                                  */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Ausdruck der die Menge beschreibt                             */
/*             Liste der Elemente                                            */
/*             Datentyp der Menge                                            */
/*                                                                           */
/* ************************************************************************* */

besetze_set(expr,elements,typ)
T_EXPR * expr;
T_SUBRANGE * elements;
ST_TYPE * typ;
{ VARNODE * var1, * var2;
  int i,b;
  unsigned *z, g;
  ST_CONST * c;
  expr->erg_art = ERG_CONST;
  berechne_elem(expr,elements,typ);
  if (expr->error == 0)
  { if (expr->zeilen == 0)
    { if (expr->hv != NULL)
        mache_Constexpr(expr,typ,0);
      return;
    }
    expr->erg_art = ERG_VAR;
    GET_MEM(var1,1,VARNODE);
    var1->lk = VARi;
    VARi = var1;
    var1->ein = get_hvar(typ_int,expr->scavec);
    var1->free = 1;
    if ((var2 = expr->hv) == NULL)
    { GET_MEM(var2,1,VARNODE);
      var2->lk = VARi;
      VARi = var2;
      var2->ein = get_hvar(typ,expr->scavec);
      var2->free = 0;
      expr->hv = var2;
    }
    var2->link = var1;
    z = expr->erg.Const->wert.set.set;
    b = typ->info.range.bis - typ->info.range.von;
    for (i = 0; i <= b; i++)
    { if ((i % 32) == 0)
      { g = *z++; }
      if ((g % 2) == 1)
      { GET_MEM(c,1,ST_CONST);
        c->Art = ST_CINT;
        c->gueltig = 1;
        c->type = typ_int;
        c->wert.i = i;
        if (i != 0)
        { expr->zeilen += 2; }
        else
        { expr->zeilen += 1; }
      }
      g = g / 2;
    }
    free_hvar(expr->hv);
    expr->hv->free = 1;
  }    
}

/* ************************************************************************* */
/* bilde eine konstante Menge aus den Element-Angaben                        */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Ausdruck der die Menge beschreibt                             */
/*             Liste der Elemente                                            */
/*             Datentyp der Menge                                            */
/*                                                                           */
/* ************************************************************************* */

berechne_elem(expr,element,typ)
T_EXPR * expr;
T_SUBRANGE * element;
ST_TYPE * typ;
{ T_EXPR * ex1, *ex2;
  ST_CONST * c;
  int von;
  if (element != NULL)
  { if (element->link != NULL)
      berechne_elem(expr,element->link,typ);
    if ((ex1 = element->von) != NULL)
    { expr_auswerten(ex1,1);
      if (typ_berechnung(_IN,ex1->erg_typ,typ) != typ_bool)
      { if (ex1->error == 0)
        { SEMERROR(ex1->Zeile,ex1->Posit,0,0,text[263]);
           interpreter = ex1->error = 1;
        }
        interpreter = expr->error = 1;
      }
      if (ex1->error == 0)
      { if (ex1->erg_art == ERG_CONST)
        { c = ex1->erg.Const;
          switch (c->Art)
          { case ST_CINT :
              if ((c->wert.i >= typ->info.range.von) && (c->wert.i <= typ->info.range.bis))
              { von = c->wert.i - typ->info.range.von; }
              else
              { interpreter = expr->error = 1;
                SEMERROR(ex1->Zeile,ex1->Posit,0,0,text[264]);
              }
              break;
            case ST_CSTRING :
              if ((*(c->wert.s.string) >= typ->info.range.von) &&
                  (*(c->wert.s.string) <= typ->info.range.bis))
              { von = *(c->wert.s.string) - typ->info.range.von; }
              else
              { interpreter = expr->error = 1;
                SEMERROR(ex1->Zeile,ex1->Posit,0,0,text[264]);
              }
              break;
            case ST_CELEM :
            case ST_CENUM :
            case ST_CBOOL :
              if ((c->wert.range.val >= typ->info.range.von) &&
                  (c->wert.range.val <= typ->info.range.bis))
              { von = c->wert.range.val - typ->info.range.von; }
              else
              { interpreter = expr->error = 1;
                SEMERROR(ex1->Zeile,ex1->Posit,0,0,text[264]);
              }
              break;
            case ST_CEOL :
              if ((typ->info.range.von <= '\n') && (typ->info.range.bis >= '\n')) 
                von = '\n' - typ->info.range.von;
              else
              { interpreter = expr->error = 1;
                SEMERROR(ex1->Zeile,ex1->Posit,0,0,text[264]);
              }
              break;
            default :
              interpreter = expr->error = 1;
              SEMERROR(ex1->Zeile,ex1->Posit,0,0,text[263]);
              break;
          }
        }
        else
        { if (ex1->error == 0)
            SEMERROR(ex1->Zeile,ex1->Posit,0,0,text[265]);
          interpreter = expr->error = 1;
        }
      }
    }
    expr_auswerten(ex2 = element->bis,1);
    expr->scavec |= ex2->scavec;
    if (ex2->error != 0)
    { interpreter = expr->error = 1;
      free_hvar(ex2->hv);
      free_hvar(element->hv);
      return;
    }
    if (typ_berechnung(_IN,ex2->erg_typ,typ) != typ_bool)
    { SEMERROR(ex2->Zeile,ex2->Posit,0,0,text[263]);
      interpreter = expr->error = 1;
      free_hvar(ex2->hv);
      free_hvar(element->hv);
      return;
    }
    if (ex2->erg_art == ERG_CONST)
    { c = ex2->erg.Const;
      switch (c->Art)
      { case ST_CINT :
          if ((c->wert.i >= typ->info.range.von) && (c->wert.i <= typ->info.range.bis))
          { int bis = c->wert.i - typ->info.range.von;
            if (ex1 == NULL)
            { setze(expr,bis,bis,typ); }
            else
            { if (von <= bis)
                setze(expr,von,bis,typ);
              else
              { if (expr->error == 0)
                  SEMERROR(ex1->Zeile,ex1->Posit,ex2->Zeile,ex2->Posit,text[266]);
                interpreter = expr->error = 1;
              }
            }
          }
          else
          { interpreter = expr->error = 1;
            SEMERROR(ex2->Zeile,ex2->Posit,0,0,text[264]);
          }
          break;
        case ST_CSTRING :
          if ((*(c->wert.s.string) >= typ->info.range.von) &&
              (*(c->wert.s.string) <= typ->info.range.bis))
          { int bis = *(c->wert.s.string) - typ->info.range.von;
            if (ex1 == NULL)
            { setze(expr,bis,bis,typ); }
            else
            { if (von <= bis)
                setze(expr,von,bis,typ);
              else
              { if (expr->error == 0)
                  SEMERROR(ex1->Zeile,ex1->Posit,ex2->Zeile,ex2->Posit,text[266]);
                interpreter = expr->error = 1;
              }
            }
          }
          else
          { interpreter = expr->error = 1;
            SEMERROR(ex2->Zeile,ex2->Posit,0,0,text[264]);
          }
          break;
        case ST_CELEM :
        case ST_CENUM :
        case ST_CBOOL :
          if ((c->wert.range.val >= typ->info.range.von) &&
              (c->wert.range.val <= typ->info.range.bis))
          { int bis = c->wert.range.val - typ->info.range.von;
            if (ex1 == NULL)
            { setze(expr,bis,bis,typ); }
            else
            { if (von <= bis)
                setze(expr,von,bis,typ);
              else
              { if (expr->error == 0)
                  SEMERROR(ex1->Zeile,ex1->Posit,ex2->Zeile,ex2->Posit,text[266]);
                interpreter = expr->error = 1;
              }
            }
          }
          else
          { interpreter = expr->error = 1;
            SEMERROR(ex2->Zeile,ex2->Posit,0,0,text[264]);
          }
          break;
        case ST_CEOL :
          if ((typ->info.range.von <= '\n') && (typ->info.range.bis >= '\n')) 
          { int bis = '\n' - typ->info.range.von;
            if (ex1 == NULL)
            { setze(expr,bis,bis,typ); }
            else
            { if (von <= bis)
                setze(expr,von,bis,typ);
              else
              { if (expr->error == 0)
                  SEMERROR(ex1->Zeile,ex1->Posit,ex2->Zeile,ex2->Posit,text[266]);
                interpreter = expr->error = 1;
              }
            }
          }
          else
          { interpreter = expr->error = 1;
            SEMERROR(ex2->Zeile,ex2->Posit,0,0,text[264]);
          }
          break;
        default :
          interpreter = expr->error = 1;
          SEMERROR(ex2->Zeile,ex2->Posit,0,0,text[263]);
          break;
      }
    }
    else
    { if (ex2->error == 0)
        SEMERROR(ex2->Zeile,ex2->Posit,0,0,text[265]);
      interpreter = expr->error = 1;
    }
  }
  else
  { ST_CONST * c;
    unsigned * z;
    int len;
    expr->erg_art = ERG_CONST;
    GET_MEM(c,1,ST_CONST);
    expr->erg.Const = c;
    c->Art = ST_CSET;
    c->gueltig = 1;
    c->type = typ;
    len = (typ->info.range.bis - typ->info.range.von + sizeof(unsigned)*8) /
          (sizeof(unsigned)*8);
    GET_MEM(z,len,unsigned);
    c->wert.set.set = z;
    c->wert.set.count = 0;
  }
}
      
            
/* ************************************************************************* */
/* setze die Elemente einer Menge in Bitfeld auf 1                           */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Ausdruck der die Menge beschreibt                             */
/*             untere Grenze                                                 */
/*             obere Grenze                                                  */
/*             Datentyp der Menge                                            */
/*                                                                           */
/* ************************************************************************* */

setze(expr,von,bis,typ)
T_EXPR * expr;
int von, bis;    
ST_TYPE * typ;
{ ST_CONST * c;
  unsigned * z,g;
  int i, j;
  expr->erg_art = ERG_CONST;
  c = expr->erg.Const;
  if (c == NULL)
  { int len;
    GET_MEM(c,1,ST_CONST);
    expr->erg.Const = c;
    c->Art = ST_CSET;
    c->gueltig = 1;
    c->type = typ;
    len = (typ->info.range.bis - typ->info.range.von + sizeof(unsigned)*8) /
          (sizeof(unsigned)*8);
    GET_MEM(z,len,unsigned);
    c->wert.set.set = z;
  }
  z = c->wert.set.set;
  g = (1 << (j = (von % (sizeof(unsigned) * 8))));
  z= &z[von / (sizeof(unsigned) * 8)];
  for (i = von; i <= bis; i++)
  { z[0] |= g;
    g = g << 1;
    if ((++j % (sizeof(unsigned) * 8)) == 0)
    { z++; g = 1; }
  }
  c->wert.set.count = 1;
}

/* ************************************************************************* */
/* erzeuge einen Selektionsstring aus den Feldern fuer die einzelnen Dimens. */
/*                                                                           */
/* Ergebnis :  JA, alle Prozessoren selektiert oder NEIN                     */
/*                                                                           */
/* Parameter : Dimensionsnummer                                              */
/*             muss auf 1 gesetzt werden ?                                   */
/*                                                                           */
/* ************************************************************************* */

int build_selection(nr,val,co)
int nr, val;
C_CONF * co;
{ int *s,i,m,f = 1;
  int k = co->wert_faktoren[nr - 1];
  int dim = co->dims;
  
  s = string_01[nr - 1];
  for (i = 0; i < k; i++,s++)
  { if (nr == dim)
    { *null_eins_string++ = (m = (val * *s)) + '0';
      f *= m;
    }
    else
    { f *= build_selection(nr + 1, val * *s,co); }
  }
  return f;
}

/* ************************************************************************* */
/* loesche alle einzelnen Dimensionsstrings                                  */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter :                                                               */
/*                                                                           */
/* ************************************************************************* */

clear_selection()
{ int i,j, k;
  int * s;
  for (i = 0; i < max_dims; i++)
  { s = string_01[i];
    k = max_wert_faktoren[i];
    for (j = 0; j < k; j++)
    { *s++ = 0; }
  }
}

/* ************************************************************************* */
/* erzeuge aus den konstanten Selektionsteilen eine Selektionstring          */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter :                                                               */
/*                                                                           */
/* ************************************************************************* */

Const_selection(sel,co)
T_SELECT * sel;
C_CONF * co;
{ ZWCODE * zw = NULL;
  T_SELECT * s = sel;
  char * st_free;
  int i;
  if (interpreter == 0)
  { GET_MEM(zw,1,ZWCODE);
    zw->art = CO_CONSTSEL;
    zw->com.Constsel.conf = akt_conf;
  }
  
  clear_selection();
  if (sel->count == 0)
  { sel->art = SE_ALL;
    for (i = co->dims - 1; i >= 0; i--)
    { besetze_selection(string_01[i],co->wert_von[i],co->wert_bis[i],sel); }
  }
  else
  { for (i = co->dims - 1; i >= 0; i--)
    { besetze_selection(string_01[i],co->wert_von[i],co->wert_bis[i],s);
      s = s->link;
    }
  }
  GET_MEM(null_eins_string,akt_proz_anz + 1,char);
  st_free = null_eins_string;
  if (interpreter == 0)
    zw->com.Constsel.string = null_eins_string;
 
  if (build_selection(1,1,co) == 0)
  { sel->code = zw;
    sel->zeilen += 1;
  }
  else
  { sel->code = zw;
    if (interpreter == 0)
    { if (my_strlen(st_free) == proz_anz)
      { zw->com.Constsel.string =  NULL;
        sel->zeilen -=  1;
      }
/*      else
        sel->zeilen +=  1;*/
    }
  }
}

/* ************************************************************************* */
/* setze die Felder in den einzelnen Dimensionsstring                        */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Dimensionsstring                                              */
/*             Anfang des Bereichs                                           */
/*             Ende des Bereichs                                             */
/*             Selektor                                                      */
/*                                                                           */
/* ************************************************************************* */

besetze_selection(s,v,b,sel)
int * s;
int v,b;
T_SELECT * sel;
{ T_SUBRANGE * sr;
  int i,c = 0;
  if (sel->art == SE_ALL)
  { for (i = 0; i <= b - v; i++)
    { s[i] = 1; }
    return;
  }
  sr = sel->ranges;
  while (sr != NULL)
  { subrange_besetzen(s,v,b,sr);
    sr = sr->link;
  }
  if (sel->anzahl == 0)
  { for (i = 0; i <= b - v; i++)
    { c += *s++; }
  }
  else
    c = 1;
  sel_proz_anz = c * (sel_proz_anz / (b - v + 1));
}

/* ************************************************************************* */
/* setze die Felder in den einzelnen Dimensionsstring bei einem Bereich      */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Dimensionsstring                                              */
/*             Anfang des Bereichs                                           */
/*             Ende des Bereichs                                             */
/*                                                                           */
/* ************************************************************************* */

subrange_besetzen(s,v,b,sr)
int * s, v, b;
T_SUBRANGE * sr;
{ T_EXPR * ex;
  int f,t,i;
  if ((sr->bis->erg_art != ERG_CONST) || ((sr->von) && (sr->von->erg_art != ERG_CONST)))
  { f = v; t = b; }
  else
  { if (match_typen(sr->bis->erg_typ,typ_bool,0) == JA)
    { if (sr->bis->erg.Const->wert.range.val)
      { f = v; t = b; }
      else
      { f = v; t = v - 1; }
    }
    else
    { t = sr->bis->erg.Const->wert.i;
      if ((ex = sr->von) != NULL)
      { f = ex->erg.Const->wert.i; }
      else
      { f = t; }
    }
  }
  f = (f < v) ? 0: f - v;
  t = (t > b) ? b - v : t - v;
  for (i = f; i <= t; i++)
  { s[i] = 1; }
}

/* ************************************************************************* */
/* wertet die Indizierung bei einem Feldzugriff aus                          */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Ausdruck                                                      */
/*             Datentyp der Feldkomponente                                   */
/*             Datentyp des Ausdrucks                                        */
/*             Zugriffszwischencode fuer den Zugriff                         */
/*                                                                           */
/* ************************************************************************* */

array_offset(expr,typ,elemtyp,arc)
T_EXPR * expr;
ST_TYPE * typ, * elemtyp;
AR_COMP ** arc;
{ AR_COMP * ar;
  if (interpreter == 0)
  { GET_MEM(ar,1,AR_COMP)
    ar->link = *arc;
    *arc = ar;
    ar->art = 0;
    ar->ar.array.typ = elemtyp;
    ar->ar.array.offset = - typ->info.range.von;
    ar->ar.array.scavec = expr->scavec;
    if (expr->erg_art == ERG_CONST)
    { ST_CONST * c = expr->erg.Const;
      int i;
      switch (c->Art)
      { case ST_CINT :
          i = ar->ar.array.offset += c->wert.i;
          if ((i < 0) || (c->wert.i > typ->info.range.bis))
          { SEMERROR(expr->Zeile,expr->Posit,0,0,text[267]);
            interpreter = 1;
          }
          break;
        case ST_CSTRING :
          i = ar->ar.array.offset += *c->wert.s.string;
          if ((i < 0) || (*c->wert.s.string > typ->info.range.bis))
          { SEMERROR(expr->Zeile,expr->Posit,0,0,text[267]);
            interpreter = 1;
          }
          break;
        default :
          i = ar->ar.array.offset += c->wert.range.val;
          if ((i < 0) || (c->wert.range.val > typ->info.range.bis))
          { SEMERROR(expr->Zeile,expr->Posit,0,0,text[267]);
            interpreter = 1;
          }
          break;
      }
    }
    else
    { mache_Constexpr(expr,typ,0);
      if ((match_typen(typ,typ_int,0) == JA) || (typ->Art == ST_TRANGE))
      { ar->ar.array.zeilen = expr->zeilen;
        ar->ar.array.erg = expr->hv;
        ar->ar.array.code = expr->code;
      }
      else
      { ZWCODE * zw;
        VARNODE * var;
        GET_MEM(zw,1,ZWCODE);
        GET_MEM(var,1,VARNODE);
        var->lk = VARi;
        VARi = var;
        var->free = 1;
        var->firstelem = INTEGER;
        var->ein = get_hvar(typ_int,var->scavec = expr->scavec);
        var->dir_indir = DIRECT;
        zw->art = CO_ASSIGN;
        zw->com.assign.erg = var;
        zw->com.assign.wert = expr->hv;
        free_hvar(expr->hv);
        zw->com.assign.ex1 = expr->code;
        ar->ar.array.zeilen = 1 + expr->zeilen;
        ar->ar.array.code = zw;
        ar->ar.array.erg = var;
      }
    }
  }
  else
  { if (expr->erg_art == ERG_CONST)
    { ST_CONST * c = expr->erg.Const;
      if (expr->error == 0)
      { switch (c->Art)
        { case ST_CINT :
            if ((c->wert.i < typ->info.range.von) || (c->wert.i > typ->info.range.bis))
            { SEMERROR(expr->Zeile,expr->Posit,0,0,text[267]);
              interpreter = 1;
            }
            break;
          case ST_CSTRING :
          if ((*c->wert.s.string < typ->info.range.von) ||
              (*c->wert.s.string > typ->info.range.bis))
            { SEMERROR(expr->Zeile,expr->Posit,0,0,text[267]);
              interpreter = 1;
            }
            break;
        default :
            if ((c->wert.range.val < typ->info.range.von) ||
                (c->wert.range.val > typ->info.range.bis))
            { SEMERROR(expr->Zeile,expr->Posit,0,0,text[267]);
              interpreter = 1;
            }
            break;
        }
      }
    }
  }
}

/* ************************************************************************* */
/* wertet eine CASE-Anweisung aus                                            */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Ausdruck                                                      */
/*             CASE-Varianten                                                */
/*             Hilfsvariable bei vektoriellem CASE                           */
/*                                                                           */
/* ************************************************************************* */

case_auswertung(expr,cases,var)
T_EXPR * expr;
T_CASES * cases;
VARNODE * var;
{ VARNODE * varx = NULL;
  if (cases != NULL)
  { T_CASELABEL * caselabel;
    ZWCODE * zw1 = NULL;
    int lines = 0;
    int nomore_mem;
    nomore_mem = nomore;
    case_auswertung(expr,cases->link,var);
    caselabel_auswertung(expr,cases->link,caselabel = cases->caselabel,&varx);
    if (interpreter == 0)
    { while (caselabel != NULL)
      { caselabel->code->com.caselabel.next = zw1;
        lines += caselabel->zeilen;
        zw1 = caselabel->code;
        caselabel = caselabel->link;
      }
    }
    free_hvar(varx);
    anweisungen(cases->statements);
    if (interpreter == 0)
    { ZWCODE * zw;
      GET_MEM(zw,1,ZWCODE);
      if (expr->scavec != 0)
      { cases->zeilen = 3 + lines; }
      else
      { cases->zeilen = 1 + lines; }
      zw->com.cases.erg = varx;
      zw->art = CO_CASE;
      if (cases->link == NULL)
      { zw->com.cases.expr = expr->code;
        if (expr->scavec != 0)
        { zw->com.cases.first = 1; }
        cases->zeilen += expr->zeilen + expr->scavec;
      }
      zw->com.cases.var = var;
      zw->com.cases.sel = zw1;
      zw->com.cases.stat = cases->statements;
      cases->code = zw;
      zw->com.cases.zeilen = cases->zeilen += statement_lines(cases->statements);
      if (expr->scavec == 0)
        zw->com.cases.all = cases->zeilen;   
      else
        zw->com.cases.all = 2 + expr->scavec + statement_lines(cases->statements);   
    }
    nomore = nomore_mem;
  }
}

/* ************************************************************************* */
/* wertet die CASELABELS einer CASE-Anweisung aus                            */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Ausdruck                                                      */
/*             CASE-Varianten                                                */
/*             CASELABEL-Varianten                                           */
/*             Hilfsvariable bei vektoriellem CASE                           */
/*                                                                           */
/* ************************************************************************* */

caselabel_auswertung(expr,cases,caselabel,varx)
T_EXPR * expr;
T_CASES * cases;
T_CASELABEL * caselabel;
VARNODE ** varx;
{ VARNODE * var1 = NULL;
  VARNODE * var2 = NULL;
  ST_CONST * lb, * ub;
  if (caselabel != NULL)
  { T_EXPR * von, * bis;
    int unten, oben, nomore_mem;
    caselabel_auswertung(expr,cases,caselabel->link,varx);
    nomore_mem = nomore;
    expr_auswerten(von = caselabel->von,1);
    if (von->erg_art != ERG_CONST)
    { if (von->error == 0)
        SEMERROR(von->Zeile,von->Posit,0,0,text[268]);
      von->error = interpreter = 1;
    }
    if (expr && (match_typen(von->erg_typ,expr->erg_typ,0) != JA))
    { if ((von->error == 0) && (expr->error == 0))
        SEMERROR(von->Zeile,von->Posit,expr->Zeile,expr->Posit,text[182]);
      von->error = interpreter = 1;
    }
    if ((von->erg_art == ERG_CONST) && (von->error == 0))
    { switch ((lb = von->erg.Const)->Art)
      { case ST_CINT :
          unten = lb->wert.i;
          break;
        case ST_CSTRING :
          unten = lb->wert.s.string[0];
          break;
        default :
          unten = lb->wert.range.val;
          break;
      }
    }
    if (expr)
      mache_Constexpr(von,expr->erg_typ,0);
    if (interpreter == 0)
    { GET_MEM(var1,1,VARNODE);
      var1->lk = VARi;
      VARi = var1;
      var1->free = 1;
      var1->firstelem = BOOLEAN;
      var1->dir_indir = DIRECT;
      var1->ein = get_hvar(typ_bool,var1->scavec = expr->scavec);
      if ((caselabel->link == NULL) && (*varx == NULL))
        *varx = var1;
    }
    if ((bis = caselabel->bis) != NULL)
    { expr_auswerten(bis,1);
      if (bis->erg_art != ERG_CONST)
      { if (bis->error == 0)
          SEMERROR(bis->Zeile,bis->Posit,0,0,text[268]);
        bis->error = interpreter = 1;
      }
      if (expr && (match_typen(bis->erg_typ,expr->erg_typ,0) != JA))
      { if ((bis->error == 0) && (expr->error == 0))        
        SEMERROR(bis->Zeile,bis->Posit,expr->Zeile,expr->Posit,text[182]);
        bis->error = interpreter = 1;
      }
      if ((bis->erg_art == ERG_CONST) && (bis->error == 0))
      { switch ((ub = bis->erg.Const)->Art)
        { case ST_CINT :
            oben = ub->wert.i;
            break;
          case ST_CSTRING :
            oben = ub->wert.s.string[0];
            break;
          default :
            oben = ub->wert.range.val;
            break;
        }
      }
      if (unten > oben)
      { if ((von->error == 0) && (bis->error == 0))
          SEMERROR(von->Zeile,von->Posit,bis->Zeile,bis->Posit,text[266]);
        von->error = bis->error = interpreter = 1;
      }
      if ((von->error == 0) && (bis->error == 0))
      { pruefe_ueberlappung(unten,oben,von->Zeile,von->Posit,caselabel->link,cases); }
      if (expr)
        mache_Constexpr(bis,expr->erg_typ,0);
      if (interpreter == 0)
      { GET_MEM(var2,1,VARNODE);
        var2->lk = VARi;
        VARi = var2;
        var2->free = 1;
        var2->firstelem = BOOLEAN;
        var2->dir_indir = DIRECT;
        var2->ein = get_hvar(typ_bool,var2->scavec = expr->scavec);
      }
      free_hvar(bis->hv);
      free_hvar(var2);
    }
    else
    { if (von->error == 0)
      { pruefe_ueberlappung(unten,unten,von->Zeile,von->Posit,caselabel->link,cases); }
      oben = unten;
      ub = lb;
    }
    caselabel->unten = unten;
    caselabel->oben = oben;
    free_hvar(von->hv);
    if (var1 != *varx)
      free_hvar(var1);
    if (interpreter == 0)
    { ZWCODE * zw;
      GET_MEM(zw,1,ZWCODE);
      caselabel->zeilen = 2;
      zw->com.caselabel.hvar2 = var2;
      if (var2)
        caselabel->zeilen += 2;
      zw->com.caselabel.hvar1 = var1;
      zw->art = CO_CASELABEL;
      zw->com.caselabel.unten = lb;
      zw->com.caselabel.lowb = von->hv;
      zw->com.caselabel.lowex = von->code;
      caselabel->zeilen += von->zeilen;
      if (bis != NULL)
      { zw->com.caselabel.oben = ub;
        zw->com.caselabel.upb = bis->hv;
        zw->com.caselabel.upex = bis->code;
        caselabel->zeilen += bis->zeilen;
      }
      else
      { zw->com.caselabel.oben = ub; }
      zw->com.caselabel.erg = expr->hv;
      zw->com.caselabel.var = *varx;
      caselabel->code = zw;
    }
    nomore = nomore_mem;
  }
}
    
/* ************************************************************************* */
/* pruefe CASE-Varianten auf Ueberlappung der Bereiche                       */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Anfang des Bereichs                                           */
/*             Ende des Bereichs                                             */
/*             Zeilennummer der Bereichsangabe                               */
/*             Spaltennummer der Bereichsangabe                              */
/*             zu pruefende CASELABEL-Varianten                              */
/*             zu pruefende CASE-Varianten                                   */
/*                                                                           */
/* ************************************************************************* */

pruefe_ueberlappung(von,bis,Z1,P1,caselabel,cases)
int von,bis,Z1,P1;
T_CASELABEL * caselabel;
T_CASES * cases;
{ while (1)
  { while (caselabel != NULL)
    { if (((caselabel->unten <= von) && (caselabel->oben >= von)) ||
          ((caselabel->unten <= bis) && (caselabel->oben >= bis)) ||
          ((von <= caselabel->unten) && (bis >= caselabel->unten)) ||
          ((von <= caselabel->oben) && (bis >= caselabel->oben)))
      { SEMERROR(Z1,P1,caselabel->von->Zeile,caselabel->von->Posit,text[269]);
        interpreter = 1;
        return;
      }
      caselabel = caselabel->link;
    }
    if (cases == NULL)
      return;
    else
      caselabel = cases->caselabel;
    cases = cases->link;
  }
}

/* ************************************************************************* */
/* Ports als Parameter moeglich machen                                       */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Symboltabelleneintrag                                         */
/*             Ausdruck der ausgewertet werden soll                          */
/*             geklammerter Ausdruck                                         */
/*                                                                           */
/* ************************************************************************* */

portanalyse(ein,ex1,ex2)
Eintrag * ein;
T_EXPR * ex1, * ex2;
{ int apnr, offsetnra;
  ZWCODE * propzw;
  VARNODE * op;
  ST_CONST * c;
  GET_MEM(c,1,ST_CONST);
  GET_MEM(propzw,1,ZWCODE);
  c->wert.port.portdesc = propzw;
  ex1->erg.Const = c;
  switch (ein->Art)
  { case N_IO :
    case N_IOK :
      c->wert.port.portart = N_IO;
      break;
    case N_INPUT :
    case N_INPUTK :
      c->wert.port.portart = N_INPUT;
      break;
    case N_OUTPUT :
    case N_OUTPUTK :
      c->wert.port.portart = N_OUTPUT;
      break;
  }
  switch (ein->Art)
  { case N_IO :
    case N_INPUT :
    case N_OUTPUT :
      propzw->art = CO_PORT;
      propzw->com.port.ex = NULL;
      propzw->com.port.low = ein->param.inout.portnr;
      propzw->com.port.high = ein->param.inout.portnr;
      propzw->com.port.nach = NULL;
      propzw->com.port.pnr = ein->param.inout.portnr;
      propzw->com.port.port = NULL;
      error_range = 1;
      break;
    case N_IOK :
    case N_INPUTK :
    case N_OUTPUTK :
      apnr = ein->param.inout.portnr - ein->param.inout.von;
      switch (ex2->erg_art)
      { case ERG_CONST :
          if (match_typen(typ_int,ex2->erg_typ,0) == JA)
          { ST_CONST * c;
            c = ex2->erg.Const;
            if (c->Art = ST_CINT)
            { offsetnra = c->wert.i; }
            else
            { offsetnra = c->wert.range.val; }
            if ((offsetnra < ein->param.inout.von) ||
                (offsetnra > ein->param.inout.bis))
            { SEMERROR(ex2->Zeile,ex2->Posit,0,0,text[234]);
              interpreter = ex1->error = 1;
            }
            else
            { apnr += offsetnra;
              propzw->art = CO_PORT;
              propzw->com.port.ex = NULL;
              propzw->com.port.low = apnr;
              propzw->com.port.high = apnr;
              propzw->com.port.nach = NULL;
              propzw->com.port.pnr = apnr;
              propzw->com.port.port = NULL;
              error_range = 1;
            }
          }
          else
          { SEMERROR(ex2->Zeile,ex2->Posit,0,0,text[235]);
            interpreter = ex1->error = 1;
          }
          break;
        case ERG_RAND :
        case ERG_PROC :
          mache_Constexpr(ex2,typ_int,0);
        case ERG_VAR :
        case ERG_SPEC :
          if (match_typen(typ_int,ex2->erg_typ,0) == JA)
          { if (ex2->scavec == 1)
            { SEMERROR(ex2->Zeile,ex2->Posit,0,0,text[232]);
              ex1->error = interpreter = 1;
            }
            if (interpreter == 0)
            { if (apnr != 0)
              { GET_MEM(op,1,VARNODE);
                free_hvar(ex2->hv);
                op->lk = VARi;
                VARi = op;
                op->ein = get_hvar(typ_int,op->scavec = 0);
                op->firstelem = INTEGER;
                op->free = 1;
                op->dir_indir = DIRECT;
                propzw->com.port.port = ex2->hv;
              }
              else
              { op = propzw->com.port.port = ex2->hv; }
              propzw->art = CO_PORT;
              propzw->com.port.ex = ex2->code;
              propzw->com.port.low = ein->param.inout.von;
              propzw->com.port.high = ein->param.inout.bis;
              propzw->com.port.nach = op;
              propzw->com.port.pnr = apnr;
              ex1->hv = op;
              error_range = 1;
            }
            ex1->zeilen = 2 + ex2->zeilen + ((apnr != 0) ? 1 : 0);
          }
          else
          { SEMERROR(ex2->Zeile,ex2->Posit,0,0,text[236]);
            interpreter = ex1->error = 1;
          }
          break;
        case ERG_TYPE :
        case ERG_REC :
        case ERG_UNDEF :
        case ERG_PORT :
          if (ex2->error == 0)
          { SEMERROR(ex2->Zeile,ex2->Posit,0,0,text[236]); }
          interpreter = ex1->error = 1;
          break;
        default :
          bug("portanalyse expr Ergebnis");
          break;
      }
      break;
  }
}

extern Eintrag ** variables;
extern Eintrag ** einheits;
extern int * source_con;

/* ************************************************************************* */
/* ANlegen der Strings f"ur die konstanten Selektionen pro Dimension         */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter :                                                               */
/*                                                                           */
/* ************************************************************************* */

dim_strings_vorbereiten()
{ int i;
  C_GROUP * ag;
  C_CONF * c;
  int * s;
  ag = all_groups;
  max_dims = 0;
  while(ag)
  { max_dims = (max_dims >= ag->dims) ? max_dims : ag->dims;
    ag = ag->next;
  }
  GET_MEM(max_wert_faktoren,max_dims,long);
  ag = all_groups;
  while(ag)
  { c = ag->conf;
    while (c)
    { for (i = 0; i < c->dims; i++)
      { max_wert_faktoren[i] = (max_wert_faktoren[i] >= c->wert_faktoren[i])
                               ? max_wert_faktoren[i]
                               : c->wert_faktoren[i];
      }
      c = c->link;
    }
    ag = ag->next;
  }
  GET_MEM(string_01,max_dims,int*);
  for (i = 0; i < max_dims; i++)
  { GET_MEM(s,(int)max_wert_faktoren[i],int);
    string_01[i] = s;
  }
  GET_MEM(source_con,max_dims,int);
  GET_MEM(variables,max_dims,Eintrag *);
  GET_MEM(einheits,max_dims+1,Eintrag *);
  ag = all_groups;
  while(ag)
  { ag->max_dim = max_dims;
    ag = ag->next;
  }
}
/* close file */
/*#endif*/
