/* Parallaxis Version: @(#)pass2.h	2.13  2/28/92 14:47:45  */
/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : pass2.h                                                           */
/*                                                                           */
/* Definitionen fuer die semantische Analyse und die Zwischencodeerzeugung   */
/*                                                                           */
/* ************************************************************************* */

#include "defines.h"
# include <math.h>
# undef _REDUCE
# include <errno.h>
# include <signal.h>
# include "makro2.h"
# include "makro.h"
# include "typen.h"
# include "symbols.h"
# include "y_tab.h"
# include "hilfsvar.h"
# include "code.h"        /* Codeerzeugung */
# include "conf.h"

#define FREE 0
#define RANGE 1
#define POINTER 2
#define EXAKT 1



/* Liste aller Prozeduren, die von einer Prozedur aufgerufen werden */
typedef struct Proclist {
    struct Proclist * link;
    Eintrag * wer;
    Eintrag * wo;
    int Zeile, Posit;
    int mode;
    int conf;
    int error;
    } PROCLIST;

extern PROCLIST * used_proc;
extern int info_proc;

/* wichtige vordefinierte Datentypen */
extern ST_TYPE * typ_error, * typ_int, * typ_char, * typ_real, * typ_card,
               * typ_bool, * typ_string, * typ_nil, * typ_color;

extern int interpreter;     /* muss PARZ-Kode erzeugt werden ? */

extern int error_div, error_range;  /* koennen Laufzeitfehler auftreten ? */

/* in calc.c */

/* ************************************************************************* */
/* ermittelt eine Konstante aus einer Strukturkonstanten                     */
/*                                                                           */
/* Ergebnis : Konstante                                                      */
/*                                                                           */
/* Parameter : Strukturkonstante                                             */
/*             Typ der Strukturkonstanten                                    */
/*             Auswahlbeschreibung                                           */
/*             Typ des Ergebnisses                                           */
/*                                                                           */
/* ************************************************************************* */
extern ST_CONST * hole_Constkomp();

/* ************************************************************************* */
/* berechnet konstanten Ausdruck von zwei Operanden                          */
/*                                                                           */
/* Ergebnis : Konstante                                                      */
/*                                                                           */
/* Parameter : Operationsnummer                                              */
/*             Operand 1                                                     */
/*             Operand 2                                                     */
/*                                                                           */
/* ************************************************************************* */
extern ST_CONST * eval_binexpr();


/* in code.c */

/* ************************************************************************* */
/* ueberprueft die Grenzen bei Unterbereichstypen                            */
/*                                                                           */
/* Ergebnis : Zwischencode fuer die Ueberpruefung                            */
/*                                                                           */
/* Parameter : Ausdruck                                                      */
/*             Datentyp des erwarteten Ergebnisses                           */
/*                                                                           */
/* ************************************************************************* */
extern ZWCODE * check_ranges();


/* in hilfsvar.c */

/* ************************************************************************* */
/* Hole neue Hilfsvariable                                                   */
/*                                                                           */
/* Ergebnis : Hilfsvariable                                                  */
/*                                                                           */
/* Parameter : Datentyp                                                      */
/*             skalar oder vektoriell                                        */
/*                                                                           */
/* ************************************************************************* */
extern Eintrag * get_hvar();
      
/* ************************************************************************* */
/* erzeugt Variablenknoten zu einem Ausdruck                                 */
/*                                                                           */
/* Ergebnis : Variablenknoten                                                */
/*                                                                           */
/* Parameter : Ausdruck                                                      */
/*                                                                           */
/* ************************************************************************* */
extern VARNODE * neue_hv();  /* liefert die Zieladresse fuer die Operation */

/* ************************************************************************* */
/* pruefe, ob  Variablenknoten eine Hilfsvariable enthaelt                   */
/*                                                                           */
/* Ergebnis : JA oder NEIN                                                   */
/*                                                                           */
/* Parameter : Variablenknoten                                               */
/*                                                                           */
/* ************************************************************************* */
extern int hilfs_var();


/* in param.c */

/* ************************************************************************* */
/* pruefe ob Liste von Ausdruecken mit Paramterliste vertraeglich ist        */
/*                                                                           */
/* Ergebnis : JA oder NEIN                                                   */
/*                                                                           */
/* Parameter : Parameterliste in ST-Form                                     */
/*             Liste von Ausdruecken                                         */
/*             Zeilennummer                                                  */
/*             Spaltennummer des Funktionsnamen                              */
/*                                                                           */
/* ************************************************************************* */
extern int teste_parameter();


/* in typ.c */

/* ************************************************************************* */
/* wie gross ist ein Bereich                                                 */
/*                                                                           */
/* Ergebnis : Maximum - Minimum oder -1                                      */
/*                                                                           */
/* Parameter : ST-Typdefinition                                              */
/*                                                                           */
/* ************************************************************************* */
extern int elementezahl();

/* ************************************************************************* */
/* sind zwei Typen typvertraeglich ?                                         */
/*                                                                           */
/* Ergebnis : JA oder NEIN                                                   */
/*                                                                           */
/* Parameter : ST-Typdefinition                                              */
/*             ST-Typdefinition                                              */
/*                                                                           */
/* ************************************************************************* */
extern int match_typen();

/* ************************************************************************* */
/* berechne den Ergebnistyp einer binaeren Operation                         */
/*                                                                           */
/* Ergebnis : ST-Ergebnistypdefinition                                       */
/*                                                                           */
/* Parameter : Operator                                                      */
/*             ST-Typdefinition                                              */
/*             St-Typdefinition                                              */
/*                                                                           */
/* ************************************************************************* */
extern ST_TYPE * typ_berechnung();

/* ************************************************************************* */
/* ist der Datentyp ein Aufzaehlungstyp ?                                    */
/*                                                                           */
/* Ergebnis :JA oder NEIN                                                    */
/*                                                                           */
/* Parameter : ST-Typdefinition                                              */
/*                                                                           */
/* ************************************************************************* */
extern int enumeration_typ();

/* ************************************************************************* */
/* ist der Ausdruck vom Typ CARDINAL ?                                       */
/*                                                                           */
/* Ergebnis : JA oder NEIN                                                   */
/*                                                                           */
/* Parameter : Ausdruck                                                      */
/*                                                                           */
/* ************************************************************************* */
extern int ist_cardinal();

/* ************************************************************************* */
/* ist der Datentyp ein Stringtyp ?                                          */
/*                                                                           */
/* Ergebnis : JA oder NEIN                                                   */
/*                                                                           */
/* Parameter : ST-Typdefinition                                              */
/*                                                                           */
/* ************************************************************************* */
extern int ist_stringtyp();

/* ************************************************************************* */
/* ist der Datentyp ein einfacher Datentyp ?                                 */
/*                                                                           */
/* Ergebnis : JA oder NEIN                                                   */
/*                                                                           */
/* Parameter : ST-Typdefinition                                              */
/*                                                                           */
/* ************************************************************************* */
extern int ist_einfacher_typ();



