static char _sccsid[] = "Parallaxis Version: @(#)st_funcs.c	2.15  12/1/92 12:38:40";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : st_funcs.c                                                        */
/*                                                                           */
/* Funktionen, die die Standardfunktionen auswerten und codieren             */
/*                                                                           */
/* ************************************************************************* */


#include "pass2.h"
#ifdef PC
# ifdef MAC
extern int errno;
# endif
#define HUGE 3.4e38
#else
# ifdef HP
#  undef HUGE
#  define HUGE MAXFLOAT
# endif
#endif
extern int nomore;
extern ST_CONST * erzeuge_string();
extern int fp_error;
extern int divisionstest;
extern int calc_verbindungen;


int stf_abs(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ ST_CONST * c1, *c2;
  int i;
  if (exprlist->count == 1)
  { if (match_typen(exprlist->erg_typ,typ_int,0) == JA)
    { funccall->erg_typ = typ_card;
      if ((funccall->erg_art = exprlist->erg_art) == ERG_CONST)
      { GET_MEM(c1,1,ST_CONST);
        c2 = exprlist->erg.Const;
        if (c2->Art == ST_CINT)
        { i = c2->wert.i;
          i = (i > 0) ? i : -i;
        }
        else
        { i = c2->wert.range.val; }
        c1->wert.i =i;
        c1->type = typ_int;
        c1->gueltig = 1;
        c1->Art = ST_CINT;
        funccall->scavec = 0;
        funccall->erg.Const = c1;
        funccall->erg_art = ERG_CONST;
      }
      else
      { /* Hilfsvariablen */
        funccall->scavec = exprlist->scavec;
        if (interpreter == 0)
        { ZWCODE * zw;
          GET_MEM(zw,1,ZWCODE);
          funccall->erg_art = ERG_VAR;
          zw->art = CO_ABS;
          zw->com.abs.erg = neue_hv(funccall);
          if (exprlist->hv == NULL)
          { exprlist->hv = zw->com.abs.erg;
            mache_Constexpr(exprlist,typ_int,0);
          }
          free_hvar(exprlist->hv);
          zw->com.abs.expr = exprlist->code;
          zw->com.abs.var = exprlist->hv;
          funccall->code = zw;
          funccall->zeilen = 1 + exprlist->zeilen;
        }
      }
      return 1;
    }
    else
    { if (match_typen(exprlist->erg_typ,typ_real,0) == JA)
      { float r;
        funccall->erg_typ = typ_real;
        if ((funccall->erg_art = exprlist->erg_art) == ERG_CONST)
        { GET_MEM(c1,1,ST_CONST);
          c2 = exprlist->erg.Const;
          r = c2->wert.r;
          c1->wert.r = (r > 0) ? r : -r;
          c1->type = typ_real;
          c1->gueltig = 1;
          c1->Art = ST_CREAL;
          funccall->scavec = 0;
          funccall->erg.Const = c1;
          funccall->erg_art = ERG_CONST;
        }
        else
        { /* Hilfsvariablen */
          funccall->scavec = exprlist->scavec;
          if (interpreter == 0)
          { ZWCODE * zw;
            GET_MEM(zw,1,ZWCODE);
            funccall->erg_art = ERG_VAR;
            zw->art = CO_ABS;
            zw->com.abs.erg = neue_hv(funccall);
            if (exprlist->hv == NULL)
            { exprlist->hv = zw->com.abs.erg;
              mache_Constexpr(exprlist,typ_real,0);
            }
            free_hvar(exprlist->hv);
            zw->com.abs.expr = exprlist->code;
            zw->com.abs.var = exprlist->hv;
            funccall->code = zw;
            funccall->zeilen = 1 + exprlist->zeilen;
          }
        }
        return 1;
      }
      else
      { if (exprlist->error == 0)
          SEMERROR(funccall->Zeile,funccall->Posit,exprlist->Zeile,exprlist->Posit,
                   text[339]);
        funccall->error = interpreter = 1;
      }
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_cap(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ if (exprlist->count > 1)
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    interpreter = funccall->error = 1;
  }
  else
  { if (match_typen(exprlist->erg_typ,typ_char,0) == JA)
    { if (exprlist->erg_art == ERG_CONST)
      { char c = *exprlist->erg.Const->wert.s.string;
        unsigned char * hi;
        ST_CONST * co;
        GET_MEM(hi,2,unsigned char);
        c = ((c < 'a') || (c > 'z')) ? c : c - 'a' + 'A';
        GET_MEM(co,1,ST_CONST);
        co->Art = ST_CSTRING;
        co->wert.s.string = hi;
        co->wert.s.len = 1;
        *hi = c;
        funccall->erg.Const = co;
        funccall->erg_typ = typ_char;
        funccall->erg_art = ERG_CONST;
      }
      else
      { funccall->erg_typ = typ_char;
        funccall->scavec = exprlist->scavec;
        funccall->erg_art = ERG_VAR;
        if (interpreter == 0)
        { int scavec = exprlist->scavec;
          ZWCODE * zw;
          VARNODE * var;
          GET_MEM(zw,1,ZWCODE);
          zw->art = CO_CAP;
          GET_MEM(var,1,VARNODE)
          var->free = 1;
          var->lk = VARi;
          VARi = var;
          var->ein = get_hvar(typ_int,var->scavec = scavec);
          var->firstelem = INTEGER;
          var->dir_indir = DIRECT;
          zw->com.cap.hilf2 = var;
          GET_MEM(var,1,VARNODE)
          var->free = 1;
          var->lk = VARi;
          VARi = var;
          var->ein = get_hvar(typ_int,var->scavec = scavec);
          var->firstelem = INTEGER;
          var->dir_indir = DIRECT;
          zw->com.cap.hilf3 = var;
          free_hvar(var);
          free_hvar(zw->com.cap.hilf2);
          GET_MEM(var,1,VARNODE)
          var->free = 1;
          var->lk = VARi;
          VARi = var;
          var->ein = get_hvar(typ_bool,var->scavec = scavec);
          var->firstelem = BOOLEAN;
          var->dir_indir = DIRECT;
          zw->com.cap.hilf1 = var;
          free_hvar(var);
          zw->com.cap.erg = neue_hv(funccall);
          if (exprlist->hv == NULL)
          { exprlist->hv = funccall->hv;
            mache_Constexpr(exprlist,typ_char,0);
          }
          free_hvar(exprlist->hv);
          zw->com.cap.expr = exprlist->code;
          zw->com.cap.var = exprlist->hv;
          funccall->code = zw;
          funccall->zeilen = exprlist->zeilen + 12;
        }
      }
      return 1;
    }
    else
    { if (exprlist->error == 0)
        SEMERROR(funccall->Zeile,funccall->Posit,
                 exprlist->Zeile,exprlist->Posit,
                 text[287]);
      funccall->error = interpreter = 1;
    }
  }
  return 0;
}

int stf_chr(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ ST_CONST * c1;
  if (exprlist->count == 1)
  { if (match_typen(exprlist->erg_typ,typ_int,0) == JA)
    { funccall->erg_typ = typ_char;
      if ((funccall->erg_art = exprlist->erg_art) == ERG_CONST)
      { unsigned char * s;
        GET_MEM(s,2,unsigned char);
        GET_MEM(c1,1,ST_CONST);
        c1->Art = ST_CSTRING;
        c1->wert.s.string = s;
        * s = (char) exprlist->erg.Const->wert.i;
        c1->wert.s.len = 1;
        c1->gueltig = 1;
        funccall->erg.Const = c1;
        funccall->scavec = 0;
      }
      else
      { /* Hilfsvariablen */
        if (interpreter == 0)
        { ZWCODE * zw;
          GET_MEM(zw,1,ZWCODE);
          funccall->scavec = exprlist->scavec;
          funccall->erg_art = ERG_VAR;
          zw->com.abs.erg = neue_hv(funccall);
          mache_Constexpr(exprlist,typ_int,0);
          zw->com.abs.expr = exprlist->code;
          zw->com.abs.var = exprlist->hv;
          zw->art = CO_CHR;
          free_hvar(exprlist->hv);
          funccall->code = zw;
          funccall->zeilen = 1 + exprlist->zeilen;
        }
        funccall->erg_art = ERG_VAR;
      }
      return 1;
    }
    else
    { if (exprlist->error == 0)
        SEMERROR(funccall->Zeile,funccall->Posit,exprlist->Zeile,exprlist->Posit,
                 text[285]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_even(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ ST_CONST * c1, *c2;
  int i;
  if (exprlist->count == 1)
  { if (match_typen(exprlist->erg_typ,typ_int,0) == JA)
    { funccall->erg_typ = typ_bool;
      if ((funccall->erg_art = exprlist->erg_art) == ERG_CONST)
      { GET_MEM(c1,1,ST_CONST);
        c2 = exprlist->erg.Const;
        if (c2->Art == ST_CINT)
        { i = c2->wert.i % 2; }
        else
        { i = c2->wert.range.val % 2; }
        c1->wert.range.von = 0;
        c1->wert.range.bis = 1;
        c1->type = typ_bool;
        c1->gueltig = 1;
        c1->Art = ST_CBOOL;
        c1->wert.range.val = (i == 1) ? 0 : 1;
        funccall->scavec = 0;
        funccall->erg.Const = c1;
      }
      else
      { /* Hilfsvariablen */
        if (interpreter == 0)
        { ZWCODE * zw;
          VARNODE * var;
          GET_MEM(zw,1,ZWCODE);
          funccall->scavec = exprlist->scavec;
          funccall->erg_art = ERG_VAR;
          zw->com.oddeven.erg = neue_hv(funccall);
          mache_Constexpr(exprlist,typ_int,0);
          zw->com.oddeven.expr = exprlist->code;
          zw->com.oddeven.var = exprlist->hv;
          zw->art = CO_EVEN;
          free_hvar(exprlist->hv);
          GET_MEM(var,1,VARNODE);
          var->lk = VARi;
          VARi = var;
          var->free = 1;
          var->dir_indir = DIRECT;
          var->firstelem = INTEGER;
          var->ein = get_hvar(typ_int,var->scavec = exprlist->scavec);
          zw->com.oddeven.temp = var;
          free_hvar(var);
          funccall->code = zw;
          funccall->zeilen = 3 + exprlist->zeilen;
        }
        funccall->erg_art = ERG_VAR;
      }
      return 1;
    }
    else
    { if (exprlist->error == 0)
        SEMERROR(funccall->Zeile,funccall->Posit,exprlist->Zeile,exprlist->Posit,
                 text[285]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_float(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ ST_CONST * c1;
  if (exprlist->count == 1)
  { if (match_typen(exprlist->erg_typ,typ_int,0) == JA)
    { funccall->erg_typ = typ_real;
      if ((funccall->erg_art = exprlist->erg_art) == ERG_CONST)
      { GET_MEM(c1,1,ST_CONST);
        c1->wert.r = exprlist->erg.Const->wert.i;
        c1->type = typ_real;
        c1->gueltig = 1;
        c1->Art = ST_CREAL;
        funccall->scavec = 0;
        funccall->erg.Const = c1;
      }
      else
      { /* Hilfsvariablen */
        if (interpreter == 0)
        { ZWCODE * zw;
          GET_MEM(zw,1,ZWCODE);
          funccall->erg_art = ERG_VAR;
          funccall->scavec = exprlist->scavec;
          zw->com.abs.erg = neue_hv(funccall);
          mache_Constexpr(exprlist,typ_int,0);
          zw->com.abs.expr = exprlist->code;
          zw->com.abs.var = exprlist->hv;
          zw->art = CO_FLOAT;
          free_hvar(exprlist->hv);
          funccall->code = zw;
          funccall->zeilen = 1 + exprlist->zeilen;
        }
        funccall->erg_art = ERG_VAR;
      }
      funccall->erg_typ = typ_real;
      return 1;
    }
    else
    { if (exprlist->error == 0)
        SEMERROR(funccall->Zeile,funccall->Posit,exprlist->Zeile,exprlist->Posit,
                 text[285]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_max(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ if (exprlist->count == 1)
  { if (exprlist->erg_art == ERG_TYPE)
    { ST_TYPE * t = exprlist->erg.eintr->param.type;
      if ((t->Art == ST_TRANGE) || (t->Art == ST_TSUBRANGE) || (t->Art == ST_TBOOL))
      { ST_CONST * c;
        GET_MEM(c,1,ST_CONST);
        if (match_typen(typ_int,t,0) == JA)
        { c->Art = ST_CINT;
          c->wert.i = t->info.range.bis;
        }
        else
        { c->Art = ST_CENUM;
          c->wert.range.val = c->wert.range.bis = t->info.range.bis;
          c->wert.range.von = t->info.range.von;
        }
        c->gueltig = 1;
        c->type = t;
        funccall->erg_art = ERG_CONST;
        funccall->erg_typ = t;
        funccall->erg.Const = c;
        return 1;
      }
      if (t->Art == ST_TINT)
      { ST_CONST * c;
        GET_MEM(c,1,ST_CONST);
        c->Art = ST_CINT;
        c->wert.i = MAXINTEGER;
        c->gueltig = 1;;
        c->type = typ_int;
        funccall->erg_art = ERG_CONST;
        funccall->erg_typ = t;
        funccall->erg.Const = c;
        return 1;
      }
      if (t->Art == ST_TCHAR)
      { unsigned char * hi;
        ST_CONST * c;
        GET_MEM(c,1,ST_CONST);
        GET_MEM(hi,2,unsigned char);
        c->Art = ST_CSTRING;
        c->wert.s.string = hi;
        * hi = (unsigned char) MAXCHAR;
        c->wert.s.len = 1;
        c->type = typ_string;
        c->gueltig = 1;
        funccall->erg_art = ERG_CONST;
        funccall->erg_typ = t;
        funccall->erg.Const = c;
        return 1;
      }
      if (exprlist->error == 0)
        SEMERROR(exprlist->Zeile,exprlist->Posit,0,0,
                 text[288]);
      funccall->error = interpreter = 1;
    }
    else
    { if (exprlist->error == 0)
        SEMERROR(exprlist->Zeile,exprlist->Posit,0,0,
                 text[289]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_min(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ if (exprlist->count == 1)
  { if (exprlist->erg_art == ERG_TYPE)
    { ST_TYPE * t = exprlist->erg.eintr->param.type;
      if ((t->Art == ST_TRANGE) || (t->Art == ST_TSUBRANGE) || (t->Art == ST_TBOOL))
      { ST_CONST * c;
        GET_MEM(c,1,ST_CONST);
        if (match_typen(typ_int,t,0) == JA)
        { c->Art = ST_CINT;
          c->wert.i = t->info.range.von;
        }
        else
        { c->Art = ST_CENUM;
          c->wert.range.bis = t->info.range.bis;
          c->wert.range.val = c->wert.range.von = t->info.range.von;
        }
        c->gueltig = 1;
        c->type = t;
        funccall->erg_art = ERG_CONST;
        funccall->erg_typ = t;
        funccall->erg.Const = c;
        return 1;
      }
      if (t->Art == ST_TINT)
      { ST_CONST * c;
        GET_MEM(c,1,ST_CONST);
        c->Art = ST_CINT;
        c->wert.i = ~MAXINTEGER;
        c->gueltig = 1;
        c->type = typ_int;
        funccall->erg_art = ERG_CONST;
        funccall->erg_typ = t;
        funccall->erg.Const = c;
        return 1;
      }
      if (t->Art == ST_TCHAR)
      { unsigned char * hi;
        ST_CONST * c;
        GET_MEM(c,1,ST_CONST);
        GET_MEM(hi,2,unsigned char);
        c->Art = ST_CSTRING;
        c->wert.s.string = hi;
        * hi = '\0';
        c->wert.s.len = 1;
        c->type = typ_string;
        c->gueltig = 1;
        funccall->erg_art = ERG_CONST;
        funccall->erg_typ = t;
        funccall->erg.Const = c;
        return 1;
      }
      if (exprlist->error == 0)
        SEMERROR(exprlist->Zeile,exprlist->Posit,0,0,
                 text[288]);
      funccall->error = interpreter = 1;
    }
    else
    { if (exprlist->error == 0)
        SEMERROR(exprlist->Zeile,exprlist->Posit,0,0,
                 text[289]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_odd(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ ST_CONST * c1, *c2;
  int i;
  if (exprlist->count == 1)
  { if (match_typen(exprlist->erg_typ,typ_int,0) == JA)
    { funccall->erg_typ = typ_bool;
      if ((funccall->erg_art = exprlist->erg_art) == ERG_CONST)
      { GET_MEM(c1,1,ST_CONST);
        c2 = exprlist->erg.Const;
        if (c2->Art == ST_CINT)
        { i = c2->wert.i % 2; }
        else
        { i = c2->wert.range.val % 2; }
        c1->wert.range.von = 0;
        c1->wert.range.bis = 1;
        c1->type = typ_bool;
        c1->gueltig = 1;
        c1->Art = ST_CBOOL;
        c1->wert.range.val = (i == 0) ? 0 : 1;
        funccall->erg.Const = c1;
        funccall->scavec = 0;
        funccall->erg_art = ERG_CONST;
      }
      else
      { /* Hilfsvariablen */
        if (interpreter == 0)
        { ZWCODE * zw;
          VARNODE * var;
          GET_MEM(zw,1,ZWCODE);
          funccall->erg_art = ERG_VAR;
          funccall->scavec = exprlist->scavec;
          zw->com.oddeven.erg = neue_hv(funccall);
          mache_Constexpr(exprlist,typ_int,0);
          zw->com.oddeven.expr = exprlist->code;
          zw->com.oddeven.var = exprlist->hv;
          zw->art = CO_ODD;
          free_hvar(exprlist->hv);
          GET_MEM(var,1,VARNODE);
          var->lk = VARi;
          VARi = var;
          var->free = 1;
          var->dir_indir = DIRECT;
          var->firstelem = INTEGER;
          var->ein = get_hvar(typ_int,var->scavec = exprlist->scavec);
          zw->com.oddeven.temp = var;
          free_hvar(var);
          funccall->code = zw;
          funccall->zeilen = 2 + exprlist->zeilen;
        }
        funccall->erg_art = ERG_VAR;
      }
      return 1;
    }
    else
    { if (exprlist->error == 0)
        SEMERROR(funccall->Zeile,funccall->Posit,exprlist->Zeile,exprlist->Posit,
                 text[285]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_ord(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ ST_CONST * c1, *c2;
  if (exprlist->count == 1)
  { funccall->erg_typ = typ_card;
    funccall->erg_art = exprlist->erg_art;
    funccall->scavec = exprlist->scavec;
    if (exprlist->erg_art == ERG_CONST)
    { c2 = exprlist->erg.Const;
      funccall->erg_art = ERG_CONST;
      if (exprlist->erg_typ == typ_string)
        exprlist->erg_typ = typ_char;
      if (exprlist->erg_typ)
      { switch (exprlist->erg_typ->Art)
        { case ST_TINT :
            funccall->erg.Const = c2;
            funccall->scavec = 0;
            if (c2->wert.i < 0)
              funccall->erg_typ = typ_int;
            return 1;
          case ST_TCHAR :
            if (c2->wert.s.len <= 1)
            { GET_MEM(c1,1,ST_CONST);
              c1->Art = ST_CINT;
              c1->gueltig = 1;
              c1->type = typ_int;
              c1->wert.i = c2->wert.s.string[0];
              funccall->erg.Const = c1;
              return 1;
            }
            else
            { SEMERROR(exprlist->Zeile,exprlist->Posit,0,0,
                       text[290]);
              funccall->error = interpreter = 1;
            }
            break;
          case ST_TBOOL :
          case ST_TRANGE :
          case ST_TSUBRANGE :
            GET_MEM(c1,1,ST_CONST);
            c1->Art = ST_CINT;
            c1->gueltig = 1;
            c1->type = typ_int;
            if ((c1->wert.i = c2->wert.range.val) < 0)
              funccall->erg_typ = typ_int;
            funccall->erg.Const = c1;
            return 1;
          default :
            if (exprlist->error == 0)
            { SEMERROR(exprlist->Zeile,exprlist->Posit,0,0,
                      text[291]);
              funccall->error = interpreter = 1;
            }
            break;
        }
      }
    }
    else
    { funccall->erg_art = ERG_VAR;
      if (exprlist->erg_typ)
      { switch (exprlist->erg_typ->Art)
        { case ST_TINT :
            funccall->erg_typ = typ_int;
          case ST_TID_NO :
          case ST_TDIM :
            funccall->erg_art = exprlist->erg_art;
            funccall->erg.eintr = exprlist->erg.eintr;
            funccall->code = exprlist->code;
            funccall->zeilen = exprlist->zeilen;
            funccall->hv = exprlist->hv;
            return 1;
          case ST_TCHAR : 
          case ST_TBOOL :
          case ST_TRANGE :
          case ST_TSUBRANGE :
            if (exprlist->erg_typ->info.range.von < 0)
              funccall->erg_typ = typ_int;
            if (interpreter == 0)
            { ZWCODE * zw;
              GET_MEM(zw,1,ZWCODE);
              zw->com.abs.erg = neue_hv(funccall);
              mache_Constexpr(exprlist,exprlist->erg_typ,0);
              zw->com.abs.expr = exprlist->code;
              zw->com.abs.var = exprlist->hv;
              zw->art = CO_ORD;
              free_hvar(exprlist->hv);
              funccall->code = zw;
              funccall->zeilen = 1 + exprlist->zeilen;
              funccall->scavec = exprlist->scavec;
            }
            return 1;
          default :
            if (exprlist->error == 0)
            { SEMERROR(exprlist->Zeile,exprlist->Posit,0,0,
                      text[291]);
              funccall->error = interpreter = 1;
            }
            break;
        }
      }
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_size(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ if (exprlist->count == 1)
  { if (exprlist->erg_art == ERG_SPEC)
    { ST_CONST * c;
      GET_MEM(c,1,ST_CONST);
      c->Art = ST_CTYPDESC;
      c->gueltig = 1;
      c->wert.i = 1;
      c->type = exprlist->erg_typ;
      funccall->erg_art = ERG_CONST;
      funccall->erg_typ = typ_card;
      funccall->erg.Const = c;
      return 1;
    }
    else
    { if (exprlist->error == 0)
        SEMERROR(exprlist->Zeile,exprlist->Posit,0,0,
                 text[306]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_trunc(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ ST_CONST * c1;
  if (exprlist->count == 1)
  { if (match_typen(exprlist->erg_typ,typ_real,0) == JA)
    { funccall->erg_typ = typ_int;
      if ((funccall->erg_art = exprlist->erg_art) == ERG_CONST)
      { GET_MEM(c1,1,ST_CONST);
        c1->wert.i = exprlist->erg.Const->wert.r;
        c1->type = typ_int;
        c1->gueltig = 1;
        c1->Art = ST_CINT;
        funccall->scavec = 0;
        funccall->erg.Const = c1;
      }
      else
      { /* Hilfsvariablen */
        if (interpreter == 0)
        { ZWCODE * zw;
          GET_MEM(zw,1,ZWCODE);
          funccall->scavec = exprlist->scavec;
          funccall->erg_art = ERG_VAR;
          mache_Constexpr(exprlist,typ_real,0);
          zw->com.abs.expr = exprlist->code;
          zw->com.abs.var = exprlist->hv;
          zw->art = CO_TRUNC;
          zw->com.abs.erg = neue_hv(funccall);
          free_hvar(exprlist->hv);
          funccall->code = zw;
          funccall->zeilen = 1 + exprlist->zeilen;
        }
        funccall->erg_art = ERG_VAR;
      }
      return 1;
    }
    else
    { if (exprlist->error == 0)
        SEMERROR(funccall->Zeile,funccall->Posit,exprlist->Zeile,exprlist->Posit,
                 text[292]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_val(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ ST_CONST * c1;
  if (exprlist->count <= 2)
  { if (exprlist->count == 2)
    { T_EXPR * ex = exprlist->link;
      if (ex->erg_art == ERG_TYPE)
      { ST_TYPE * t = ex->erg.eintr->param.type;
        switch (t->Art)
        { case ST_TINT :
          case ST_TCHAR :
          case ST_TBOOL :
          case ST_TRANGE :
          case ST_TSUBRANGE :
            funccall->erg_typ = t;
            funccall->scavec = exprlist->scavec;
            if (ist_cardinal(exprlist) == JA)
            { if (exprlist->erg_art == ERG_CONST)
              { int i = 0;
                switch (exprlist->erg_typ->Art)
                { case ST_TINT :
                    i = exprlist->erg.Const->wert.i;
                    break;
                  case ST_TSUBRANGE :
                    i = exprlist->erg.Const->wert.range.val;
                    break;
                }
                GET_MEM(c1,1,ST_CONST);
                c1->type = t;
                c1->gueltig = 1;
                funccall->scavec = 0;
                funccall->erg.Const = c1;
                funccall->erg_art = ERG_CONST;
                switch (t->Art)
                { case ST_TINT :
                    c1->Art = ST_CINT;
                    c1->wert.i = i;
                    return 1;
                  case ST_TCHAR :
                    { unsigned char * hi;
                      c1->Art = ST_CSTRING;
                      GET_MEM(hi,2,unsigned char);
                      c1->wert.s.string = hi;
                      c1->wert.s.len = 1;
                      *hi = i;
                    }
                    return 1;
                  case ST_TBOOL :
                    c1->Art = ST_CBOOL;
                    c1->wert.range.von = 0;
                    c1->wert.range.bis = 1;
                    c1->wert.range.val = (i) ? 1 : 0;
                    return 1;
                  case ST_TRANGE :
                  case ST_TSUBRANGE :
                    { int l,h;
                      c1->Art = ST_CENUM;
                      l = c1->wert.range.von = t->info.range.von;
                      h = c1->wert.range.bis = t->info.range.bis;
                      if ((l <= i) && (i <= h))
                      { c1->wert.range.val = i;
                        return 1;
                      }
                      if ((ex->error == 0) && (exprlist->error == 0))
                        SEMERROR(ex->Zeile,ex->Posit,exprlist->Zeile,exprlist->Posit,
                                 text[273]);
                    }
                    break;
                  default :
                    bug("Standardfunktionen");
                    break;
                }
              }
              else
              { if ((match_typen(t,typ_char,0) == JA) ||
                    (match_typen(t,typ_bool,0) == JA) ||
                    (funccall->hv != NULL))
                { ZWCODE * zw;
                  mache_Constexpr(exprlist,typ_card,0);
                  GET_MEM(zw,1,ZWCODE);
                  zw->art = CO_ASSIGN;
                  zw->com.assign.erg = neue_hv(funccall);
                  zw->com.assign.wert = exprlist->hv;
                  zw->com.assign.ex1 = exprlist->code;
                  funccall->code = zw;
                  funccall->zeilen += 1 + exprlist->zeilen;
                }
                else
                { mache_Constexpr(exprlist,typ_card,0);
                  funccall->zeilen = exprlist->zeilen;
                  funccall->hv = exprlist->hv;
                }
                funccall->erg_typ = t;
                funccall->erg_art = ERG_VAR;
                return 1;
              }
            }
            else
            { if (exprlist->error == 0)
                SEMERROR(exprlist->Zeile,exprlist->Posit,0,0,
                         text[293]);
            }
            interpreter = funccall->error = 1;
            break;
          default :
            SEMERROR(ex->Zeile,ex->Posit,0,0,
                     text[294]);
            if (ist_cardinal(exprlist) != JA)
            { if (exprlist->error == 0)
                SEMERROR(exprlist->Zeile,exprlist->Posit,0,0,
                         text[293]);
            }
            interpreter = funccall->error = 1;
            break;
        }
      }         
      else
      { if (ist_cardinal(exprlist) != JA)
        { if (exprlist->error == 0)
            SEMERROR(exprlist->Zeile,exprlist->Posit,0,0,
                     text[293]);
        }
        interpreter = funccall->error = 1;
      }     
    }
    else
    { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
               text[295]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_strcmp(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ if (exprlist->count <= 2)
  { if (exprlist->count == 2)
    { T_EXPR * ex = exprlist->link;
      if (ist_stringtyp(ex->erg_typ) != JA)
      { if (ex->error == 0)
          SEMERROR(ex->Zeile,ex->Posit,0,0,
                   text[296]);
        interpreter = funccall->error = 1;
      }
      if (ist_stringtyp(exprlist->erg_typ) != JA)
      { if (exprlist->error == 0)
          SEMERROR(exprlist->Zeile,exprlist->Posit,0,0,
                   text[296]);
        interpreter = funccall->error = 1;
      }
      if (funccall->error == 0)
      { ZWCODE * zw;
        funccall->scavec = exprlist->scavec | ex->scavec;
        if ((ex->erg_art == ERG_CONST) && (exprlist->erg_art == ERG_CONST))
        { ST_CONST * c;
          unsigned char * s1 = ex->erg.Const->wert.s.string;
          unsigned char * s2 = exprlist->erg.Const->wert.s.string;
          GET_MEM(c,1,ST_CONST);
          c->Art = ST_CINT;
          c->gueltig = 1;
          c->type = typ_int;
          while ((*s1 == *s2) && *s1)
          { s1++; s2++; }
          if (*s1)
          { if (*s1 > *s2)
              c->wert.i = 1;
            else
              c->wert.i = -1;
          }
          else
            c->wert.i = 0;
          funccall->erg.Const = c;
          funccall->erg_typ = typ_int;
          funccall->erg_art = ERG_CONST;
          return 1;
        }
        if (ex->erg_art == ERG_CONST)
          mache_Constexpr(ex,exprlist->erg_typ,0);
        else
          mache_Constexpr(ex,ex->erg_typ,0);
        if (exprlist->erg_art == ERG_CONST)
          mache_Constexpr(exprlist,ex->erg_typ,0);
        else
          mache_Constexpr(exprlist,exprlist->erg_typ,0);
        free_hvar(ex->hv);
        free_hvar(exprlist->hv);
        GET_MEM(zw,1,ZWCODE);
        zw->art = CO_STRCMP;
        zw->com.strcmp.ex1 = ex->code;
        zw->com.strcmp.op1 = ex->hv;
        zw->com.strcmp.ex2 = exprlist->code;
        zw->com.strcmp.op2 = exprlist->hv;
        funccall->erg_typ = typ_int;
        funccall->erg_art = ERG_VAR;
        zw->com.strcmp.erg = neue_hv(funccall);
        funccall->zeilen += ex->zeilen + exprlist->zeilen + 1;
        funccall->code = zw;
        return 1;
      }
    }
    else
    { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
               text[295]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_streq(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ if (exprlist->count <= 2)
  { if (exprlist->count == 2)
    { T_EXPR * ex = exprlist->link;
      if (ist_stringtyp(ex->erg_typ) != JA)
      { if (ex->error == 0)
          SEMERROR(ex->Zeile,ex->Posit,0,0,
                   text[296]);
        interpreter = funccall->error = 1;
      }
      if (ist_stringtyp(exprlist->erg_typ) != JA)
      { if (exprlist->error == 0)
          SEMERROR(exprlist->Zeile,exprlist->Posit,0,0,
                   text[296]);
        interpreter = funccall->error = 1;
      }
      if (funccall->error == 0)
      { ZWCODE * zw;
        VARNODE * var;
        funccall->scavec = exprlist->scavec | ex->scavec;
        if ((ex->erg_art == ERG_CONST) && (exprlist->erg_art == ERG_CONST))
        { ST_CONST * c;
          unsigned char * s1 = ex->erg.Const->wert.s.string;
          unsigned char * s2 = exprlist->erg.Const->wert.s.string;
          GET_MEM(c,1,ST_CONST);
          c->Art = ST_CBOOL;
          c->gueltig = 1;
          c->type = typ_bool;
          while ((*s1 == *s2) && *s1)
          { s1++; s2++; }
          if (*s1)
            c->wert.range.val = 0;
          else
            c->wert.range.val = 1;
          c->wert.range.von = 0;
          c->wert.range.bis = 1;
          funccall->erg.Const = c;
          funccall->erg_typ = typ_bool;
          funccall->erg_art = ERG_CONST;
          return 1;
        }
        if (ex->erg_art == ERG_CONST)
          mache_Constexpr(ex,exprlist->erg_typ,0);
        else
          mache_Constexpr(ex,ex->erg_typ,0);
        if (exprlist->erg_art == ERG_CONST)
          mache_Constexpr(exprlist,ex->erg_typ,0);
        else
          mache_Constexpr(exprlist,exprlist->erg_typ,0);
        free_hvar(ex->hv);
        free_hvar(exprlist->hv);
        GET_MEM(var,1,VARNODE);
        var->lk = VARi;
        VARi = var;
        var->free = 1;
        var->firstelem = INTEGER;
        var->dir_indir = DIRECT;
        var->ein = get_hvar(typ_int,var->scavec = funccall->scavec);
        free_hvar(var);
        GET_MEM(zw,1,ZWCODE);
        zw->com.strcmp.erg = var;
        zw->art = CO_STRCMP;
        zw->com.strcmp.ex1 = ex->code;
        zw->com.strcmp.op1 = ex->hv;
        zw->com.strcmp.ex2 = exprlist->code;
        zw->com.strcmp.op2 = exprlist->hv;
        funccall->erg_typ = typ_bool;
        funccall->erg_art = ERG_VAR;
        zw->com.strcmp.help = neue_hv(funccall);
        funccall->zeilen += ex->zeilen + exprlist->zeilen + 3;
        funccall->code = zw;
        return 1;
      }
    }
    else
    { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
               text[295]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_sirandom(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ if (exprlist != NULL)
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[297]);
    funccall->error = interpreter = 1;
  }
  funccall->erg_art = ERG_RAND;
  funccall->erg_typ = typ_int;
  return 1;
}

int stf_srrandom(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ if (exprlist != NULL)
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[298]);
    funccall->error = interpreter = 1;
  }
  funccall->erg_art = ERG_RAND;
  funccall->erg_typ = typ_real;
  return 1;
}

int stf_scrandom(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ if (exprlist != NULL)
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[299]);
    funccall->error = interpreter = 1;
  }
  funccall->erg_art = ERG_RAND;
  funccall->erg_typ = typ_char;
  return 1;
}

int stf_sbrandom(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ if (exprlist != NULL)
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[300]);
    funccall->error = interpreter = 1;
  }
  funccall->erg_art = ERG_RAND;
  funccall->erg_typ = typ_bool;
  return 1;
}

int stf_virandom(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ if (exprlist != NULL)
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[301]);
    funccall->error = interpreter = 1;
  }
  funccall->erg_art = ERG_RAND;
  funccall->scavec = 1;
  funccall->erg_typ = typ_int;
  return 1;
}

int stf_vrrandom(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ if (exprlist != NULL)
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[302]);
    funccall->error = interpreter = 1;
  }
  funccall->erg_art = ERG_RAND;
  funccall->scavec = 1;
  funccall->erg_typ = typ_real;
  return 1;
}

int stf_vcrandom(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ if (exprlist != NULL)
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[303]);
    funccall->error = interpreter = 1;
  }
  funccall->erg_art = ERG_RAND;
  funccall->scavec = 1;
  funccall->erg_typ = typ_char;
  return 1;
}

int stf_vbrandom(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ if (exprlist != NULL)
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[304]);
    funccall->error = interpreter = 1;
  }
  funccall->erg_art = ERG_RAND;
  funccall->scavec = 1;
  funccall->erg_typ = typ_bool;
  return 1;
}

int stf_inconn(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ if (exprlist->count == 1)
  { if (exprlist->erg_art == ERG_PORT)
    { if (exprlist->erg.Const &&
          (exprlist->erg.Const->wert.port.portart != N_OUTPUT))
      { if (interpreter == 0)
        { ZWCODE * zw;
          GET_MEM(zw,1,ZWCODE);
          zw->art = CO_CONNECT;
          if (zw->com.connect.p1.port =
              exprlist->erg.Const->wert.port.portdesc->com.port.nach)
          { zw->com.connect.code1 = exprlist->erg.Const->wert.port.portdesc;
            zw->com.connect.mode = 2;
          }
          else
          { zw->com.connect.p1.pnr =
             exprlist->erg.Const->wert.port.portdesc->com.port.pnr;
            zw->com.connect.mode = 0;
            zw->com.connect.code1 =
             exprlist->erg.Const->wert.port.portdesc->com.port.ex;
          }
          funccall->code = zw;
        }
        free_hvar(exprlist->hv);
        funccall->zeilen = exprlist->zeilen + 1;
        funccall->erg_art = ERG_PROC;
        funccall->scavec = 1;
        funccall->erg_typ = typ_int;
        return 1;
      }
      else
      { if (exprlist->error == 0)
        { SEMERROR(funccall->Zeile,funccall->Posit,
                   exprlist->Zeile,exprlist->Posit, text[336]);
        }
        funccall->error = interpreter = 1;
      }
    }
    else
    { if (exprlist->error == 0)
      { SEMERROR(funccall->Zeile,funccall->Posit,
                 exprlist->Zeile,exprlist->Posit, text[336]);
      }
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_outconn(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ if (exprlist->count == 1)
  { if (exprlist->erg_art == ERG_PORT)
    { if (exprlist->erg.Const &&
          (exprlist->erg.Const->wert.port.portart != N_INPUT))
      { if (interpreter == 0)
        { ZWCODE * zw;
          GET_MEM(zw,1,ZWCODE);
          zw->art = CO_CONNECT;
          if (zw->com.connect.p1.port =
              exprlist->erg.Const->wert.port.portdesc->com.port.nach)
          { zw->com.connect.code1 = exprlist->erg.Const->wert.port.portdesc;
            zw->com.connect.mode = 3;
          }
          else
          { zw->com.connect.p1.pnr =
             exprlist->erg.Const->wert.port.portdesc->com.port.pnr;
            zw->com.connect.mode = 1;
            zw->com.connect.code1 =
             exprlist->erg.Const->wert.port.portdesc->com.port.ex;
          }
          funccall->code = zw;
        }
        free_hvar(exprlist->hv);
        funccall->zeilen = exprlist->zeilen + 1;
        funccall->erg_art = ERG_PROC;
        funccall->scavec = 1;
        funccall->erg_typ = typ_int;
        return 1;
      }
      else
      { if (exprlist->error == 0)
        { SEMERROR(funccall->Zeile,funccall->Posit,
                   exprlist->Zeile,exprlist->Posit, text[337]);
        }
        funccall->error = interpreter = 1;
      }
    }
    else
    { if (exprlist->error == 0)
      { SEMERROR(funccall->Zeile,funccall->Posit,
                 exprlist->Zeile,exprlist->Posit, text[337]);
      }
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_inlinecon(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ if (exprlist->count <= 2)
  { if (exprlist->count == 2)
    { ZWCODE * zw;
      T_EXPR * ex = exprlist->link;
      if (ex->erg_art != ERG_PORT)
      { if (ex->error == 0)
        { SEMERROR(funccall->Zeile,funccall->Posit,
                   ex->Zeile,ex->Posit, text[337]);
        }
        funccall->error = interpreter = 1;
      }
      else
      { if ((ex->erg.Const == NULL) ||
            (ex->erg.Const->wert.port.portart == N_INPUT))
        { if (ex->error == 0)
          { SEMERROR(funccall->Zeile,funccall->Posit,
                     ex->Zeile,ex->Posit, text[337]);
          }
          funccall->error = interpreter = 1;
        }
        else
        { GET_MEM(zw,1,ZWCODE);
          zw->art = CO_CONNECT;
          if (zw->com.connect.p2.port =
              ex->erg.Const->wert.port.portdesc->com.port.nach)
          { zw->com.connect.code1 = ex->erg.Const->wert.port.portdesc;
            zw->com.connect.mode = 12;
          }
          else
          { zw->com.connect.p2.pnr =
             ex->erg.Const->wert.port.portdesc->com.port.pnr;
            zw->com.connect.mode = 8;
            zw->com.connect.code1 =
             ex->erg.Const->wert.port.portdesc->com.port.ex;
          }
        }
      }
      if (exprlist->erg_art == ERG_PORT)
      { if (exprlist->erg.Const &&
            (exprlist->erg.Const->wert.port.portart != N_OUTPUT))
        { if (interpreter == 0)
          { if (zw->com.connect.p1.port =
              exprlist->erg.Const->wert.port.portdesc->com.port.nach)
            { zw->com.connect.code2 = exprlist->erg.Const->wert.port.portdesc;
              zw->com.connect.mode |= 2;
            }
            else
            { zw->com.connect.p1.pnr =
               exprlist->erg.Const->wert.port.portdesc->com.port.pnr;
              zw->com.connect.code2 =
               exprlist->erg.Const->wert.port.portdesc->com.port.ex;
            }
            funccall->code = zw;
          }
          free_hvar(ex->hv);
          free_hvar(exprlist->hv);
          if (funccall->error == 0)
          { funccall->zeilen = ex->zeilen + exprlist->zeilen + 1;
            funccall->erg_art = ERG_PROC;
            funccall->scavec = 1;
            funccall->erg_typ = typ_int;
            return 1;
          }
        }
        else
        { if (exprlist->error == 0)
          { SEMERROR(funccall->Zeile,funccall->Posit,
                     exprlist->Zeile,exprlist->Posit, text[336]);
          }
          funccall->error = interpreter = 1;
        }
      }
      else
      { if (exprlist->error == 0)
        { SEMERROR(funccall->Zeile,funccall->Posit,
                   exprlist->Zeile,exprlist->Posit, text[336]);
        }
        funccall->error = interpreter = 1;
      }
    }
    else
    { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
               text[295]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_outlinecon(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ if (exprlist->count <= 2)
  { if (exprlist->count == 2)
    { ZWCODE * zw;
      T_EXPR * ex = exprlist->link;
      if (ex->erg_art != ERG_PORT)
      { if (ex->error == 0)
        { SEMERROR(funccall->Zeile,funccall->Posit,
                   ex->Zeile,ex->Posit, text[337]);
        }
        funccall->error = interpreter = 1;
      }
      else
      { if ((ex->erg.Const == NULL) ||
            (ex->erg.Const->wert.port.portart == N_INPUT))
        { if (ex->error == 0)
          { SEMERROR(funccall->Zeile,funccall->Posit,
                     ex->Zeile,ex->Posit, text[337]);
          }
          funccall->error = interpreter = 1;
        }
        else
        { GET_MEM(zw,1,ZWCODE);
          zw->art = CO_CONNECT;
          if (zw->com.connect.p1.port =
              ex->erg.Const->wert.port.portdesc->com.port.nach)
          { zw->com.connect.code1 = ex->erg.Const->wert.port.portdesc;
            zw->com.connect.mode = 11;
          }
          else
          { zw->com.connect.p1.pnr =
             ex->erg.Const->wert.port.portdesc->com.port.pnr;
            zw->com.connect.mode = 9;
            zw->com.connect.code1 =
             ex->erg.Const->wert.port.portdesc->com.port.ex;
          }
        }
      }
      if (exprlist->erg_art == ERG_PORT)
      { if (exprlist->erg.Const &&
            (exprlist->erg.Const->wert.port.portart != N_OUTPUT))
        { if (interpreter == 0)
          { if (zw->com.connect.p2.port =
              exprlist->erg.Const->wert.port.portdesc->com.port.nach)
            { zw->com.connect.code2 = exprlist->erg.Const->wert.port.portdesc;
              zw->com.connect.mode |= 4;
            }
            else
            { zw->com.connect.p2.pnr =
               exprlist->erg.Const->wert.port.portdesc->com.port.pnr;
              zw->com.connect.code2 =
               exprlist->erg.Const->wert.port.portdesc->com.port.ex;
            }
            funccall->code = zw;
          }
          free_hvar(ex->hv);
          free_hvar(exprlist->hv);
          if (funccall->error == 0)
          { funccall->zeilen = ex->zeilen + exprlist->zeilen + 1;
            funccall->erg_art = ERG_PROC;
            funccall->scavec = 1;
            funccall->erg_typ = typ_int;
            return 1;
          }
        }
        else
        { if (exprlist->error == 0)
          { SEMERROR(funccall->Zeile,funccall->Posit,
                     exprlist->Zeile,exprlist->Posit, text[336]);
          }
          funccall->error = interpreter = 1;
        }
      }
      else
      { if (exprlist->error == 0)
        { SEMERROR(funccall->Zeile,funccall->Posit,
                   exprlist->Zeile,exprlist->Posit, text[336]);
        }
        funccall->error = interpreter = 1;
      }
    }
    else
    { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
               text[295]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_arccos(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ ST_CONST * c1;
  if (exprlist->count == 1)
  { if (match_typen(exprlist->erg_typ,typ_real,0) == JA)
    { funccall->erg_typ = typ_real;
      if ((funccall->erg_art = exprlist->erg_art) == ERG_CONST)
      { float r = exprlist->erg.Const->wert.r;
        GET_MEM(c1,1,ST_CONST);
        c1->gueltig = 1;
        if ((r > 1) || (r < -1))
        { if (calc_verbindungen == 0)
          { if (exprlist->error == 0)
              SEMERROR(exprlist->Zeile,exprlist->Posit,0,0,text[273]);
            funccall->error = interpreter = 1;
            c1->wert.r = HUGE;
            c1->gueltig = 0;
          }
          else
          { c1->wert.r = 1.0; }
        }
        else
        { c1->wert.r = acos(r);
          if (fp_error == JA)
          { fp_error = NEIN;
            SEMERROR(funccall->Zeile,funccall->Posit,
                     exprlist->Zeile,exprlist->Posit,text[323]);
            c1->wert.r = HUGE;
            c1->gueltig = 0;
            funccall->error = interpreter = 1;
          }
        }
        c1->type = typ_real;
        c1->Art = ST_CREAL;
        funccall->scavec = 0;
        funccall->erg.Const = c1;
      }
      else
      { /* Hilfsvariablen */
        if (interpreter == 0)
        { ZWCODE * zw;
          VARNODE * var;
          GET_MEM(var,1,VARNODE);
          var->lk = VARi;
          VARi = var;
          var->free = 1;
          var->firstelem = REAL;
          var->dir_indir = DIRECT;
          var->ein = get_hvar(typ_real,var->scavec = 0);
          free_hvar(var);
          GET_MEM(zw,1,ZWCODE);
          zw->com.math.help = var;
          funccall->scavec = exprlist->scavec;
          funccall->erg_art = ERG_VAR;
          mache_Constexpr(exprlist,typ_real,0);
          zw->com.math.expr = exprlist->code;
          zw->com.math.var = exprlist->hv;
          zw->art = CO_MATH;
          zw->com.math.ftyp = PROC_ARCCOS;
          zw->com.math.erg = neue_hv(funccall);
          free_hvar(exprlist->hv);
          funccall->code = zw;
          funccall->zeilen = (divisionstest * 3) + 1 + exprlist->zeilen;
          if (divisionstest)
            error_range = 1;
        }
        funccall->erg_art = ERG_VAR;
      }
      return 1;
    }
    else
    { if (exprlist->error == 0)
        SEMERROR(funccall->Zeile,funccall->Posit,exprlist->Zeile,exprlist->Posit,
                 text[292]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_arcsin(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ ST_CONST * c1;
  if (exprlist->count == 1)
  { if (match_typen(exprlist->erg_typ,typ_real,0) == JA)
    { funccall->erg_typ = typ_real;
      if ((funccall->erg_art = exprlist->erg_art) == ERG_CONST)
      { float r = exprlist->erg.Const->wert.r;
        GET_MEM(c1,1,ST_CONST);
        c1->gueltig = 1;
        if ((r > 1) || (r < -1))
        { if (calc_verbindungen == 0)
          { if (exprlist->error == 0)
              SEMERROR(exprlist->Zeile,exprlist->Posit,0,0,text[273]);
            funccall->error = interpreter = 1;
            c1->wert.r = HUGE;
            c1->gueltig = 0;
          }
          else
          { c1->wert.r = 1.0; }
        }
        else
        { c1->wert.r = asin(r);
          if (fp_error == JA)
          { fp_error = NEIN;
            SEMERROR(funccall->Zeile,funccall->Posit,
                     exprlist->Zeile,exprlist->Posit,text[323]);
            c1->wert.r = HUGE;
            c1->gueltig = 0;
            funccall->error = interpreter = 1;
          }
        }
        c1->type = typ_real;
        c1->Art = ST_CREAL;
        funccall->scavec = 0;
        funccall->erg.Const = c1;
      }
      else
      { /* Hilfsvariablen */
        if (interpreter == 0)
        { ZWCODE * zw;
          VARNODE * var;
          GET_MEM(var,1,VARNODE);
          var->lk = VARi;
          VARi = var;
          var->free = 1;
          var->firstelem = REAL;
          var->dir_indir = DIRECT;
          var->ein = get_hvar(typ_real,var->scavec = 0);
          free_hvar(var);
          GET_MEM(zw,1,ZWCODE);
          zw->com.math.help = var;
          funccall->scavec = exprlist->scavec;
          funccall->erg_art = ERG_VAR;
          mache_Constexpr(exprlist,typ_real,0);
          zw->com.math.expr = exprlist->code;
          zw->com.math.var = exprlist->hv;
          zw->art = CO_MATH;
          zw->com.math.ftyp = PROC_ARCSIN;
          zw->com.math.erg = neue_hv(funccall);
          free_hvar(exprlist->hv);
          funccall->code = zw;
          funccall->zeilen = (divisionstest * 3) + 1 + exprlist->zeilen;
          if (divisionstest)
            error_range = 1;
        }
        funccall->erg_art = ERG_VAR;
      }
      return 1;
    }
    else
    { if (exprlist->error == 0)
        SEMERROR(funccall->Zeile,funccall->Posit,exprlist->Zeile,exprlist->Posit,
                 text[292]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_arctan(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ ST_CONST * c1;
  if (exprlist->count == 1)
  { if (match_typen(exprlist->erg_typ,typ_real,0) == JA)
    { funccall->erg_typ = typ_real;
      if ((funccall->erg_art = exprlist->erg_art) == ERG_CONST)
      { GET_MEM(c1,1,ST_CONST);
        c1->gueltig = 1;
        c1->wert.r = atan(exprlist->erg.Const->wert.r);
        if (fp_error == JA)
        { fp_error = NEIN;
          SEMERROR(funccall->Zeile,funccall->Posit,
                   exprlist->Zeile,exprlist->Posit,text[323]);
          c1->wert.r = HUGE;
          c1->gueltig = 0;
          funccall->error = interpreter = 1;
        }
        c1->type = typ_real;
        c1->Art = ST_CREAL;
        funccall->scavec = 0;
        funccall->erg.Const = c1;
      }
      else
      { /* Hilfsvariablen */
        if (interpreter == 0)
        { ZWCODE * zw;
          GET_MEM(zw,1,ZWCODE);
          funccall->scavec = exprlist->scavec;
          funccall->erg_art = ERG_VAR;
          mache_Constexpr(exprlist,typ_real,0);
          zw->com.math.expr = exprlist->code;
          zw->com.math.var = exprlist->hv;
          zw->art = CO_MATH;
          zw->com.math.ftyp = PROC_ARCTAN;
          zw->com.math.erg = neue_hv(funccall);
          free_hvar(exprlist->hv);
          funccall->code = zw;
          funccall->zeilen = 1 + exprlist->zeilen;
        }
        funccall->erg_art = ERG_VAR;
      }
      return 1;
    }
    else
    { if (exprlist->error == 0)
        SEMERROR(funccall->Zeile,funccall->Posit,exprlist->Zeile,exprlist->Posit,
                 text[292]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_cos(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ ST_CONST * c1;
  if (exprlist->count == 1)
  { if (match_typen(exprlist->erg_typ,typ_real,0) == JA)
    { funccall->erg_typ = typ_real;
      if ((funccall->erg_art = exprlist->erg_art) == ERG_CONST)
      { GET_MEM(c1,1,ST_CONST);
        c1->gueltig = 1;
        c1->wert.r = cos(exprlist->erg.Const->wert.r);
        if (fp_error == JA)
        { fp_error = NEIN;
          SEMERROR(funccall->Zeile,funccall->Posit,
                   exprlist->Zeile,exprlist->Posit,text[323]);
          c1->wert.r = HUGE;
          c1->gueltig = 0;
          funccall->error = interpreter = 1;
        }
        c1->type = typ_real;
        c1->Art = ST_CREAL;
        funccall->scavec = 0;
        funccall->erg.Const = c1;
      }
      else
      { /* Hilfsvariablen */
        if (interpreter == 0)
        { ZWCODE * zw;
          GET_MEM(zw,1,ZWCODE);
          funccall->scavec = exprlist->scavec;
          funccall->erg_art = ERG_VAR;
          mache_Constexpr(exprlist,typ_real,0);
          zw->com.math.expr = exprlist->code;
          zw->com.math.var = exprlist->hv;
          zw->art = CO_MATH;
          zw->com.math.ftyp = PROC_COS;
          zw->com.math.erg = neue_hv(funccall);
          free_hvar(exprlist->hv);
          funccall->code = zw;
          funccall->zeilen = 1 + exprlist->zeilen;
        }
        funccall->erg_art = ERG_VAR;
      }
      return 1;
    }
    else
    { if (exprlist->error == 0)
        SEMERROR(funccall->Zeile,funccall->Posit,exprlist->Zeile,exprlist->Posit,
                 text[292]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_sin(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ ST_CONST * c1;
  if (exprlist->count == 1)
  { if (match_typen(exprlist->erg_typ,typ_real,0) == JA)
    { funccall->erg_typ = typ_real;
      if ((funccall->erg_art = exprlist->erg_art) == ERG_CONST)
      { GET_MEM(c1,1,ST_CONST);
        c1->gueltig = 1;
        c1->wert.r = sin(exprlist->erg.Const->wert.r);
        if (fp_error == JA)
        { fp_error = NEIN;
          SEMERROR(funccall->Zeile,funccall->Posit,
                   exprlist->Zeile,exprlist->Posit,text[323]);
          c1->wert.r = HUGE;
          c1->gueltig = 0;
          funccall->error = interpreter = 1;
        }
        c1->type = typ_real;
        c1->Art = ST_CREAL;
        funccall->scavec = 0;
        funccall->erg.Const = c1;
      }
      else
      { /* Hilfsvariablen */
        if (interpreter == 0)
        { ZWCODE * zw;
          GET_MEM(zw,1,ZWCODE);
          funccall->scavec = exprlist->scavec;
          funccall->erg_art = ERG_VAR;
          mache_Constexpr(exprlist,typ_real,0);
          zw->com.math.expr = exprlist->code;
          zw->com.math.var = exprlist->hv;
          zw->art = CO_MATH;
          zw->com.math.ftyp = PROC_SIN;
          zw->com.math.erg = neue_hv(funccall);
          free_hvar(exprlist->hv);
          funccall->code = zw;
          funccall->zeilen = 1 + exprlist->zeilen;
        }
        funccall->erg_art = ERG_VAR;
      }
      return 1;
    }
    else
    { if (exprlist->error == 0)
        SEMERROR(funccall->Zeile,funccall->Posit,exprlist->Zeile,exprlist->Posit,
                 text[292]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_tan(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ ST_CONST * c1;
  if (exprlist->count == 1)
  { if (match_typen(exprlist->erg_typ,typ_real,0) == JA)
    { funccall->erg_typ = typ_real;
      if ((funccall->erg_art = exprlist->erg_art) == ERG_CONST)
      { GET_MEM(c1,1,ST_CONST);
        c1->gueltig = 1;
        c1->wert.r = tan(exprlist->erg.Const->wert.r);
        if (fp_error == JA)
        { fp_error = NEIN;
          SEMERROR(funccall->Zeile,funccall->Posit,
                   exprlist->Zeile,exprlist->Posit,text[323]);
          c1->wert.r = HUGE;
          c1->gueltig = 0;
          funccall->error = interpreter = 1;
        }
        c1->type = typ_real;
        c1->Art = ST_CREAL;
        funccall->scavec = 0;
        funccall->erg.Const = c1;
      }
      else
      { /* Hilfsvariablen */
        if (interpreter == 0)
        { ZWCODE * zw;
          GET_MEM(zw,1,ZWCODE);
          funccall->scavec = exprlist->scavec;
          funccall->erg_art = ERG_VAR;
          mache_Constexpr(exprlist,typ_real,0);
          zw->com.math.expr = exprlist->code;
          zw->com.math.var = exprlist->hv;
          zw->art = CO_MATH;
          zw->com.math.ftyp = PROC_TAN;
          zw->com.math.erg = neue_hv(funccall);
          free_hvar(exprlist->hv);
          funccall->code = zw;
          funccall->zeilen = 1 + exprlist->zeilen;
        }
        funccall->erg_art = ERG_VAR;
      }
      return 1;
    }
    else
    { if (exprlist->error == 0)
        SEMERROR(funccall->Zeile,funccall->Posit,exprlist->Zeile,exprlist->Posit,
                 text[292]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_sqrt(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ ST_CONST * c1;
  if (exprlist->count == 1)
  { if (match_typen(exprlist->erg_typ,typ_real,0) == JA)
    { funccall->erg_typ = typ_real;
      if ((funccall->erg_art = exprlist->erg_art) == ERG_CONST)
      { float r = exprlist->erg.Const->wert.r;
        GET_MEM(c1,1,ST_CONST);
        c1->gueltig = 1;
        if (r < 0)
        { if (calc_verbindungen == 0)
          { if (exprlist->error == 0)
              SEMERROR(exprlist->Zeile,exprlist->Posit,0,0,text[273]);
            c1->wert.r = HUGE;
            c1->gueltig = 0;
            funccall->error = interpreter = 1;
          }
          else
          { c1->wert.r = 1.0; }
        }
        else
        { c1->wert.r = sqrt(exprlist->erg.Const->wert.r);
          if (fp_error == JA)
          { fp_error = NEIN;
            SEMERROR(funccall->Zeile,funccall->Posit,
                     exprlist->Zeile,exprlist->Posit,text[323]);
            c1->wert.r = HUGE;
            c1->gueltig = 0;
            funccall->error = interpreter = 1;
          }
        }
        c1->type = typ_real;
        c1->Art = ST_CREAL;
        funccall->scavec = 0;
        funccall->erg.Const = c1;
      }
      else
      { /* Hilfsvariablen */
        if (interpreter == 0)
        { ZWCODE * zw;
          GET_MEM(zw,1,ZWCODE);
          funccall->scavec = exprlist->scavec;
          funccall->erg_art = ERG_VAR;
          mache_Constexpr(exprlist,typ_real,0);
          zw->com.math.expr = exprlist->code;
          zw->com.math.var = exprlist->hv;
          zw->art = CO_MATH;
          zw->com.math.ftyp = PROC_SQRT;
          zw->com.math.erg = neue_hv(funccall);
          free_hvar(exprlist->hv);
          funccall->code = zw;
          funccall->zeilen = divisionstest + 1 + exprlist->zeilen;
          if (divisionstest)
            error_range = 1;
        }
        funccall->erg_art = ERG_VAR;
      }
      return 1;
    }
    else
    { if (exprlist->error == 0)
        SEMERROR(funccall->Zeile,funccall->Posit,exprlist->Zeile,exprlist->Posit,
                 text[292]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_exp(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ ST_CONST * c1;
  if (exprlist->count == 1)
  { if (match_typen(exprlist->erg_typ,typ_real,0) == JA)
    { funccall->erg_typ = typ_real;
      if ((funccall->erg_art = exprlist->erg_art) == ERG_CONST)
      { GET_MEM(c1,1,ST_CONST);
        errno = 0;
        c1->gueltig = 1;
        c1->wert.r = exp(exprlist->erg.Const->wert.r);
        if (c1->wert.r && ((EDOM == errno) || (ERANGE == errno)))
        { fp_error = NEIN;
          SEMERROR(funccall->Zeile,funccall->Posit,
                   exprlist->Zeile,exprlist->Posit,text[323]);
          c1->wert.r = HUGE;
          c1->gueltig = 0;
          funccall->error = interpreter = 1;
        }
        c1->type = typ_real;
        c1->Art = ST_CREAL;
        funccall->scavec = 0;
        funccall->erg.Const = c1;
      }
      else
      { /* Hilfsvariablen */
        if (interpreter == 0)
        { ZWCODE * zw;
          GET_MEM(zw,1,ZWCODE);
          funccall->scavec = exprlist->scavec;
          funccall->erg_art = ERG_VAR;
          mache_Constexpr(exprlist,typ_real,0);
          zw->com.math.expr = exprlist->code;
          zw->com.math.var = exprlist->hv;
          zw->art = CO_MATH;
          zw->com.math.ftyp = PROC_EXP;
          zw->com.math.erg = neue_hv(funccall);
          free_hvar(exprlist->hv);
          funccall->code = zw;
          funccall->zeilen = 1 + exprlist->zeilen;
        }
        funccall->erg_art = ERG_VAR;
      }
      return 1;
    }
    else
    { if (exprlist->error == 0)
        SEMERROR(funccall->Zeile,funccall->Posit,exprlist->Zeile,exprlist->Posit,
                 text[292]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_ln(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ ST_CONST * c1;
  if (exprlist->count == 1)
  { if (match_typen(exprlist->erg_typ,typ_real,0) == JA)
    { funccall->erg_typ = typ_real;
      if ((funccall->erg_art = exprlist->erg_art) == ERG_CONST)
      { float r = exprlist->erg.Const->wert.r;
        GET_MEM(c1,1,ST_CONST);
        c1->gueltig = 1;
        if (r <= 0)
        { if (calc_verbindungen == 0)
          { if (exprlist->error == 0)
              SEMERROR(exprlist->Zeile,exprlist->Posit,0,0,text[273]);
            c1->wert.r = HUGE;
            c1->gueltig = 0;
            funccall->error = interpreter = 1;
          }
          else
          { c1->wert.r = 1.0; }
        }
        else
        { c1->wert.r = log(exprlist->erg.Const->wert.r);
          if (fp_error == JA)
          { fp_error = NEIN;
            SEMERROR(funccall->Zeile,funccall->Posit,
                     exprlist->Zeile,exprlist->Posit,text[323]);
            c1->wert.r = HUGE;
            c1->gueltig = 0;
            funccall->error = interpreter = 1;
          }
        }
        c1->type = typ_real;
        c1->Art = ST_CREAL;
        funccall->scavec = 0;
        funccall->erg.Const = c1;
      }
      else
      { /* Hilfsvariablen */
        if (interpreter == 0)
        { ZWCODE * zw;
          GET_MEM(zw,1,ZWCODE);
          funccall->scavec = exprlist->scavec;
          funccall->erg_art = ERG_VAR;
          mache_Constexpr(exprlist,typ_real,0);
          zw->com.math.expr = exprlist->code;
          zw->com.math.var = exprlist->hv;
          zw->art = CO_MATH;
          zw->com.math.ftyp = PROC_LN;
          zw->com.math.erg = neue_hv(funccall);
          free_hvar(exprlist->hv);
          funccall->code = zw;
          funccall->zeilen = divisionstest + 1 + exprlist->zeilen;
          if (divisionstest)
            error_range = 1;
        }
        funccall->erg_art = ERG_VAR;
      }
      return 1;
    }
    else
    { if (exprlist->error == 0)
        SEMERROR(funccall->Zeile,funccall->Posit,exprlist->Zeile,exprlist->Posit,
                 text[292]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_arctan2(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ ST_CONST * c1;
  if (exprlist->count <= 2)
  { if (exprlist->count == 2)
    { T_EXPR * ex = exprlist->link;
      if (match_typen(ex->erg_typ,typ_real,0) != JA)
      { if (ex->error == 0)
          SEMERROR(funccall->Zeile,funccall->Posit,ex->Zeile,ex->Posit,
                   text[292]);
        funccall->error = interpreter = 1;
      }
      if (match_typen(exprlist->erg_typ,typ_real,0) == JA)
      { funccall->erg_typ = typ_real;
        if ((exprlist->erg_art == ERG_CONST) && (ex->erg_art == ERG_CONST))
        { float r = exprlist->erg.Const->wert.r;
          GET_MEM(c1,1,ST_CONST);
          c1->gueltig = 1;
          if (r == 0)
          { if (calc_verbindungen == 0)
            { if (exprlist->error == 0)
                SEMERROR(exprlist->Zeile,exprlist->Posit,0,0,text[77]);
              c1->wert.r = HUGE;
              c1->gueltig = 0;
              funccall->error = interpreter = 1;
            }
            else
            { c1->wert.r; }
          }
          else
          { c1->wert.r = atan2(ex->erg.Const->wert.r,r);
            if (fp_error == JA)
            { fp_error = NEIN;
              SEMERROR(ex->Zeile,ex->Posit,exprlist->Zeile,exprlist->Posit,text[323]);
              c1->wert.r = HUGE;
              c1->gueltig = 0;
              funccall->error = interpreter = 1;
            }
          }
          c1->type = typ_real;
          c1->Art = ST_CREAL;
          funccall->scavec = 0;
          funccall->erg.Const = c1;
          funccall->erg_art = ERG_CONST;
        }
        else
        { /* Hilfsvariablen */
          if (interpreter == 0)
          { ZWCODE * zw;
            GET_MEM(zw,1,ZWCODE);
            funccall->scavec = exprlist->scavec;
            funccall->erg_art = ERG_VAR;
            mache_Constexpr(ex,typ_real,0);
            mache_Constexpr(exprlist,typ_real,0);
            zw->com.arctan2.expr1 = ex->code;
            zw->com.arctan2.expr2 = exprlist->code;
            zw->com.arctan2.var1 = ex->hv;
            zw->com.arctan2.var2 = exprlist->hv;
            if (ex->erg_art == ERG_CONST)
              zw->com.arctan2.con = ex->erg.Const;
            if (exprlist->erg_art == ERG_CONST)
            { zw->com.arctan2.con = exprlist->erg.Const;
              if (exprlist->erg.Const->wert.r == 0)
              { if (exprlist->error == 0)
                  SEMERROR(exprlist->Zeile,exprlist->Posit,0,0,text[77]);
                interpreter = funccall->error = 1;
              }
              else
                funccall->zeilen -= 1;
            }
            zw->art = CO_ARCTAN2;
            zw->com.arctan2.erg = neue_hv(funccall);
            free_hvar(ex->hv);
            free_hvar(exprlist->hv);
            funccall->code = zw;
            funccall->zeilen = divisionstest + 1 + ex->zeilen + exprlist->zeilen;
            if (divisionstest)
              error_div = 1;
          }
          funccall->erg_art = ERG_VAR;
        }
        return 1;
      }
      else
      { if (exprlist->error == 0)
          SEMERROR(funccall->Zeile,funccall->Posit,exprlist->Zeile,exprlist->Posit,
                 text[292]);
        funccall->error = interpreter = 1;
      }
    }
    else
    { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
               text[295]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_openwindow(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ if (exprlist->count <= 2)
  { if (exprlist->count == 2)
    { T_EXPR * ex = exprlist->link;
      if (match_typen(ex->erg_typ,typ_real,0) != JA)
      { if (ex->error == 0)
          SEMERROR(funccall->Zeile,funccall->Posit,ex->Zeile,ex->Posit,
                   text[292]);
        funccall->error = interpreter = 1;
      }
      else
      { if (ex->scavec)
        { if (ex->error == 0)
            SEMERROR(funccall->Zeile,funccall->Posit,ex->Zeile,ex->Posit,
                     text[313]);
          funccall->error = interpreter = 1;
        }
      }
      if (match_typen(exprlist->erg_typ,typ_real,0) == JA)
      { int mode = 0;
        if (exprlist->scavec)
        { if (exprlist->error == 0)
            SEMERROR(funccall->Zeile,funccall->Posit,exprlist->Zeile,exprlist->Posit,
                     text[313]);
          funccall->error = interpreter = 1;
        }
        funccall->erg_typ = typ_int;
        if (ex->erg_art == ERG_CONST)
        { float r = ex->erg.Const->wert.r;
          mode = 1;
          if (r <= 0.0)
          { if (ex->error == 0)
            { SEMERROR(ex->Zeile,ex->Posit,0,0,text[143]);
              funccall->error = interpreter = 1;
            }
          }
        }
        if (exprlist->erg_art == ERG_CONST)
        { float r = exprlist->erg.Const->wert.r;
          mode |= 2;
          if (r <= 0.0)
          { if (exprlist->error == 0)
            { SEMERROR(exprlist->Zeile,exprlist->Posit,0,0,text[143]);
              funccall->error = interpreter = 1;
            }
          }
        }
        funccall->scavec = 0;
        if (interpreter == 0)
        { ZWCODE * zw;
          GET_MEM(zw,1,ZWCODE);
          mache_Constexpr(ex,typ_real,0);
          mache_Constexpr(exprlist,typ_real,0);
          zw->com.open_get.expr1 = ex->code;
          zw->com.open_get.expr2 = exprlist->code;
          if (ex->erg_art == ERG_CONST)
            zw->com.open_get.one.con = ex->erg.Const;
          else
          { zw->com.open_get.one.var = ex->hv;
            if (range_test)
            { ex->zeilen++;
              error_range = 1;
            }
          }
          if (exprlist->erg_art == ERG_CONST)
            zw->com.open_get.two.con = exprlist->erg.Const;
          else
          { zw->com.open_get.two.var = exprlist->hv;
            if (range_test)
            { exprlist->zeilen++;
              error_range = 1;
            }
          }
          zw->com.open_get.mode = mode;
          zw->art = CO_OPENWINDOW;
          zw->com.open_get.erg = neue_hv(funccall);
          free_hvar(ex->hv);
          free_hvar(exprlist->hv);
          funccall->code = zw;
          funccall->zeilen = 1 + ex->zeilen + exprlist->zeilen;
        }
        funccall->erg_art = ERG_VAR;
        return 1;
      }
      else
      { if (exprlist->error == 0)
          SEMERROR(funccall->Zeile,funccall->Posit,exprlist->Zeile,exprlist->Posit,
                  text[292]);
          funccall->error = interpreter = 1;
      }
    }
    else
    { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
               text[295]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_openabswindow(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ if (exprlist->count <= 2)
  { if (exprlist->count == 2)
    { T_EXPR * ex = exprlist->link;
      if (match_typen(ex->erg_typ,typ_card,0) != JA)
      { if (ex->error == 0)
          SEMERROR(funccall->Zeile,funccall->Posit,ex->Zeile,ex->Posit,
                   text[293]);
        funccall->error = interpreter = 1;
      }
      else
      { if (ex->scavec)
        { if (ex->error == 0)
            SEMERROR(funccall->Zeile,funccall->Posit,ex->Zeile,ex->Posit,
                     text[313]);
          funccall->error = interpreter = 1;
        }
      }
      if (match_typen(exprlist->erg_typ,typ_card,0) == JA)
      { int mode = 0;
        if (exprlist->scavec)
        { if (exprlist->error == 0)
            SEMERROR(funccall->Zeile,funccall->Posit,exprlist->Zeile,exprlist->Posit,
                     text[313]);
          funccall->error = interpreter = 1;
        }
        funccall->erg_typ = typ_int;
        if (ex->erg_art == ERG_CONST)
        { int i = ex->erg.Const->wert.i;
          mode = 1;
          if (i <= 0)
          { if (ex->error == 0)
            { SEMERROR(ex->Zeile,ex->Posit,0,0,text[143]);
              funccall->error = interpreter = 1;
            }
          }
        }
        if (exprlist->erg_art == ERG_CONST)
        { int i = exprlist->erg.Const->wert.i;
          mode |= 2;
          if (i <= 0)
          { if (exprlist->error == 0)
            { SEMERROR(exprlist->Zeile,exprlist->Posit,0,0,text[143]);
              funccall->error = interpreter = 1;
            }
          }
        }
        funccall->scavec = 0;
        if (interpreter == 0)
        { ZWCODE * zw;
          GET_MEM(zw,1,ZWCODE);
          mache_Constexpr(ex,typ_card,0);
          mache_Constexpr(exprlist,typ_card,0);
          zw->com.open_get.expr1 = ex->code;
          zw->com.open_get.expr2 = exprlist->code;
          if (ex->erg_art == ERG_CONST)
            zw->com.open_get.one.con = ex->erg.Const;
          else
          { zw->com.open_get.one.var = ex->hv;
          }
          if (exprlist->erg_art == ERG_CONST)
            zw->com.open_get.two.con = exprlist->erg.Const;
          else
          { zw->com.open_get.two.var = exprlist->hv;
          }
          zw->com.open_get.mode = mode;
          zw->art = CO_OPENABSWINDOW;
          zw->com.open_get.erg = neue_hv(funccall);
          free_hvar(ex->hv);
          free_hvar(exprlist->hv);
          funccall->code = zw;
          funccall->zeilen = 1 + ex->zeilen + exprlist->zeilen;
        }
        funccall->erg_art = ERG_VAR;
        return 1;
      }
      else
      { if (exprlist->error == 0)
          SEMERROR(funccall->Zeile,funccall->Posit,exprlist->Zeile,exprlist->Posit,
                  text[293]);
          funccall->error = interpreter = 1;
      }
    }
    else
    { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
               text[295]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

int stf_getpixel(funccall,exprlist)
T_EXPR * funccall, *exprlist;
{ if (exprlist->count <= 2)
  { if (exprlist->count == 2)
    { T_EXPR * ex = exprlist->link;
      if (match_typen(ex->erg_typ,typ_card,0) != JA)
      { if (ex->error == 0)
          SEMERROR(funccall->Zeile,funccall->Posit,ex->Zeile,ex->Posit,
                   text[292]);
        funccall->error = interpreter = 1;
      }
      else
      { if (ex->scavec)
        { if (ex->error == 0)
            SEMERROR(funccall->Zeile,funccall->Posit,ex->Zeile,ex->Posit,
                     text[313]);
          funccall->error = interpreter = 1;
        }
      }
      if (match_typen(exprlist->erg_typ,typ_card,0) == JA)
      { int mode = 0;
        if (exprlist->scavec)
        { if (exprlist->error == 0)
            SEMERROR(funccall->Zeile,funccall->Posit,exprlist->Zeile,exprlist->Posit,
                     text[313]);
          funccall->error = interpreter = 1;
        }
        funccall->erg_typ = typ_color;
        if (ex->erg_art == ERG_CONST)
        { int i = ex->erg.Const->wert.i;
          mode = 1;
          if (i < 0)
          { if (ex->error == 0)
            { SEMERROR(ex->Zeile,ex->Posit,0,0,text[143]);
              funccall->error = interpreter = 1;
            }
          }
        }
        if (exprlist->erg_art == ERG_CONST)
        { int i = exprlist->erg.Const->wert.i;
          mode |= 2;
          if (i < 0)
          { if (exprlist->error == 0)
            { SEMERROR(exprlist->Zeile,exprlist->Posit,0,0,text[143]);
              funccall->error = interpreter = 1;
            }
          }
        }
        funccall->scavec = 0;
        if (interpreter == 0)
        { ZWCODE * zw;
          GET_MEM(zw,1,ZWCODE);
          mache_Constexpr(ex,typ_card,0);
          mache_Constexpr(exprlist,typ_card,0);
          zw->com.open_get.expr1 = ex->code;
          zw->com.open_get.expr2 = exprlist->code;
          if (ex->erg_art == ERG_CONST)
            zw->com.open_get.one.con = ex->erg.Const;
          else
            zw->com.open_get.one.var = ex->hv;
          if (exprlist->erg_art == ERG_CONST)
            zw->com.open_get.two.con = exprlist->erg.Const;
          else
            zw->com.open_get.two.var = exprlist->hv;
          zw->com.open_get.mode = mode;
          zw->art = CO_GETPIXEL;
          zw->com.open_get.erg = neue_hv(funccall);
          free_hvar(ex->hv);
          free_hvar(exprlist->hv);
          funccall->code = zw;
          funccall->zeilen = 1 + ex->zeilen + exprlist->zeilen;
        }
        funccall->erg_art = ERG_VAR;
        return 1;
      }
      else
      { if (exprlist->error == 0)
        { SEMERROR(funccall->Zeile,funccall->Posit,exprlist->Zeile,exprlist->Posit,
                  text[292]);
          funccall->error = interpreter = 1;
        }
      }
    }
    else
    { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
               text[295]);
      funccall->error = interpreter = 1;
    }
  }
  else
  { SEMERROR(funccall->Zeile,funccall->Posit,0,0,
             text[286]);
    funccall->error = interpreter = 1;
  }
  return 0;
}

