static char _sccsid[] = "Parallaxis Version: @(#)stat.c	2.13  2/28/92 15:00:02";

/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : stat.c                                                            */
/*                                                                           */
/* Funktionen, die die Anweisungen auswerten und codieren                    */
/*                                                                           */
/* ************************************************************************* */


#include "pass2x.h"
#include "conf.h"

#include "wb.h"

extern C_CONF * akt_conf, * default_conf;
extern ST_TYPE * dim_typen;

/* ************************************************************************* */
/* werte eine Anweisungsliste aus                                            */
/*                                                                           */
/* Ergebnis :                                                                */
/*                                                                           */
/* Parameter : Anweisungsliste                                               */
/*                                                                           */
/* ************************************************************************* */

anweisungen(stat)
T_STATEMENT * stat;
{ if (stat != NULL)
  { if (stat->link != NULL)
    { anweisungen(stat->link); }
    if (nomore == 1)
    { WARNING(stat->Zeile,stat->Posit,text[212]);
      nomore = 2;
    }
    if (nomore)
      stat->unreached = 1;
    switch (stat->select)
    { case S_ASSIGN :
          st_assign(stat);
        break;
      case S_PROCCALL :
          st_proccall(stat);
        break;
      case S_IF :
          st_if(stat);
        break;
      case S_CASE :
          st_case(stat);
        break;
      case S_WHILE :
          st_while(stat);
        break;
      case S_REPEAT :
          st_repeat(stat);
        break;
      case S_LOOP :
          st_loop(stat);
        break;
      case S_FOR :
          st_for(stat);
        break;
      case S_WITH :
          st_with(stat);
        break;
      case S_EXIT :
          st_exit(stat);
        break;
      case S_RETURN :
          st_return(stat);
        break;
      case S_PARALLEL :
          st_parallel(stat);
        break;
      case S_PROPAGATE :
          st_propagate(stat);
        break;
      case S_LOAD :
          st_load(stat);
        break;
      case S_STORE :
          st_store(stat);
        break;
      case S_NICHTS :
        break;
      default :
        bug("anweisungen Auswahl");
        break;
    }
  }
}

st_assign(stat)
T_STATEMENT * stat;
{ ZWCODE * zw;
  VARNODE * var;
  T_EXPR * expr1, * expr2;
  expr_auswerten(expr1 = stat->st.assign.design,0);
  stat->Zeile = expr1->Zeile;
  stat->Posit = expr1->Posit;
  expr2 = stat->st.assign.expr;
  if (interpreter == 0)
  { GET_MEM(var,1,VARNODE);
    *var = *(expr1->hv);
    var->lk = VARi;
    VARi = var;
    var->free = 0;
    var->link = NULL;
    expr2->hv = var;
  }
  expr_auswerten(expr2,0);
  if (expr1->readonly != 0)
  { SEMERROR(expr1->Zeile,expr1->Posit,0,0,text[213]);
    interpreter = expr1->error = 1;
  }
  if (match_typen(expr1->erg_typ,expr2->erg_typ,0) == JA)
  { if (expr1->scavec < expr2->scavec)
    { SEMERROR(expr1->Zeile,expr1->Posit,expr2->Zeile,expr2->Posit,text[214]);
      interpreter = 1;
    }
    else
    { if (expr1->scavec == 1)
      { if (((proc_info & PI_VECTOR) == 0) && (proc_info & PI_SCALAR))
        { SEMERROR(expr1->Zeile,expr1->Posit,0,0,text[215]);
          interpreter = 1;
        }
        else
        { proc_info |= PI_VECTOR;
        }
      }
      mache_Constexpr(expr2,expr1->erg_typ,0);
    }
  }
  else
  { if ((expr1->error | expr2->error) == 0)
      SEMERROR(expr1->Zeile,expr1->Posit,expr2->Zeile,expr2->Posit,text[253]);
    interpreter = 1;
  }
  free_hvar(expr1->hv);
  free_hvar(expr2->hv);
  if (interpreter == 0)
  { GET_MEM(zw,1,ZWCODE);
    zw->art = CO_ZUWEIS;
    zw->com.zuweis.erg = expr1->code;
    zw->com.zuweis.op = expr2->code;
    stat->zeilen = expr1->zeilen + expr2->zeilen;
    stat->code = zw;
  }
}


st_proccall(stat)
T_STATEMENT * stat;
{ Eintrag * rueck;
  T_EXPR * expr;
  SCAN_ELEM * sc;
  if ((rueck = suche_Eintrag((sc = stat->st.proc.procident)->wert.ident_nr,
                             vector_ST,GLOBAL,akt_timestamp)) != NULL)
  { if (rueck->Art == N_PROCEDURE)
    { if (rueck->param.proz.posnr < 0)
      { Standardprozeduren(stat,rueck->param.proz.posnr,
                            stat->st.proc.exprlist,sc->Zeile,sc->Posit);
      }
      else
      { if (rueck->param.proz.result != NULL)
        { SEMERROR(sc->Zeile,sc->Posit,rueck->Zeile,rueck->Posit,text[329]);
          interpreter = 1;
        }
        else
        { if ((rueck->param.proz.parall & (PI_SCALAR | PI_SELECT)) &&
              ((proc_info & PI_VECTOR) != 0))
          { SEMERROR(sc->Zeile,sc->Posit,rueck->Zeile,rueck->Posit,text[217]);
            interpreter = 1;
          }
          else
          { if ((rueck->param.proz.parall & PI_VECTOR) &&
                (proc_info & (PI_SCALAR | PI_SELECT)))
            { SEMERROR(sc->Zeile,sc->Posit,rueck->Zeile,rueck->Posit,text[218]);
              interpreter = 1;
            }
            else
            { proc_info |= rueck->param.proz.parall; }
          }
        }
        exprlist_auswerten(expr = stat->st.proc.exprlist,0);
        if (teste_parameter(rueck->param.proz.param,expr,sc->Zeile,sc->Posit) == JA)
        { ZWCODE * zw, * zw1, * zw2;
          T_EXPR * e = expr;
          GET_MEM(zw,1,ZWCODE);
          zw->art = CO_PROCCALL;
          zw->com.proc.proc = rueck;
          zw->com.proc.nach = nach_pruefung;
          zw1 = zw2 = NULL;
          stat->zeilen = 1;
          while (expr != NULL)
          { zw2 = zw1;
            GET_MEM(zw1,1,ZWCODE);
            if (expr->erg_art == ERG_CONST)
            { zw1->art = CO_PARAMCO;
              zw1->com.param.Const = expr->erg.Const;
            }
            else
            { zw1->art = CO_PARAM;
              if (expr->scavec == 2)
              { expr->scavec = 1;
                if (ist_einfacher_typ(expr->erg_typ) != JA)
                { zw1->com.param.tpar = expr->hv;
                  free_hvar(expr->hv);
                  expr->hv = NULL;
                  zw1->com.param.par = neue_hv(expr);
                  zw1->com.param.ttyp = expr->erg_typ;
                  expr->zeilen++;
                }
                else
                { zw1->com.param.tpar = NULL;
                  zw1->com.param.par = expr->hv;
                }
              }
              else
              { zw1->com.param.tpar = NULL;
                zw1->com.param.par = expr->hv;
              }
              zw1->com.param.code = expr->code;
              zw1->com.param.mode = expr->erg_art;
              if ((expr->erg_art == ERG_SPEC) ||
                  (ist_einfacher_typ(expr->erg_typ) != JA))
              { zw1->com.param.mode = ERG_SPEC; }
            }
            zw1->com.param.scavec = expr->scavec;
            stat->zeilen += 1 + expr->zeilen;
            zw1->link = zw2;
            expr = expr->link;
          }
          while (e)
          { free_hvar(e->hv);
            e = e->link;
          }
          zw->com.proc.param = zw1;
          stat->code = zw;
        }
        nach_pruefung = NULL;
        procedure_benutzen(rueck,sc->Zeile,sc->Posit,proc_info);
      }
    }
    else
    { SEMERROR(sc->Zeile,sc->Posit,rueck->Zeile,rueck->Posit,text[219]);
      interpreter = 1;
      exprlist_auswerten(stat->st.proc.exprlist,0);
    }
  }
  else
  { SEMERROR(sc->Zeile,sc->Posit,0,0,text[173]);
    interpreter = 1;
    exprlist_auswerten(stat->st.proc.exprlist,0);
  }
  stat->Zeile = sc->Zeile;
  stat->Posit = sc->Posit;
}


st_if(stat)
T_STATEMENT * stat;
{ T_EXPR * expr;
  int scavec;
  int nomore_mem;
  int mem;
  int sonstige = 0;
  int plus = 0;
  VARNODE * m_mem, * m = NULL;
  mem = retexit;
  nomore_mem = nomore;
  if (expr = stat->st.ifthen.expr)
  { expr_auswerten(expr,0);
    scavec = expr->scavec;
    if ((match_typen(typ_bool,expr->erg_typ,0) != JA) && (expr->error == 0))
    { SEMERROR(expr->Zeile,expr->Posit,0,0,text[137]);
      interpreter = 1;
    }
    else
    { if (expr->erg_art == ERG_CONST)
      { WARNING(expr->Zeile,expr->Posit,text[254]);
        if (expr->erg.Const->wert.range.val == 1)
        { sonstige = 1; }
        else
        { nomore = (nomore == 0) ? 1 : nomore; }
      }
      mache_Constexpr(expr,typ_bool,1);
      if (scavec == 1)
      { if ((expr->error == 0) && ((proc_info & PI_VECTOR) == 0) &&
            (proc_info & PI_SCALAR))
        { SEMERROR(expr->Zeile,expr->Posit,0,0,text[220]);
          interpreter = 1;
        }
        else
        { if ((proc_info & PI_SCALAR) == 0)
          proc_info |= PI_VECTOR;
        }
        retexit &= ERL_EXITLOOP;
        if ((stat->st.ifthen.elseselect != NULL) ||
            (stat->st.ifthen.elsifselect != NULL))
        { GET_MEM(m,1,VARNODE);
          m->lk = VARi;
          VARi = m;
          m->ein = get_hvar(typ_bool,1);
          m->firstelem = BOOLEAN;
          m->scavec = 1;
          m->dir_indir = DIRECT;
          m->free = 1;
          plus = 1;
        }
      } 
    }
  }
  m_mem = m;
  anweisungen(stat->st.ifthen.statements);
  nomore = nomore_mem;
  if (sonstige)
    nomore = (nomore == 0) ? 1 : nomore;
  if (expr)
    free_hvar(expr->hv);
  if (stat->st.ifthen.elsifselect != NULL)
    elsif_anweisungen(stat->st.ifthen.elsifselect,scavec,&m,
                      (stat->st.ifthen.elseselect != NULL) ? 1 : 0,&sonstige);
  nomore = nomore_mem;
  if (sonstige)
    nomore = (nomore == 0) ? 1 : nomore;
  anweisungen(stat->st.ifthen.elseselect);
  nomore = nomore_mem;
  if (interpreter == 0)
  { T_ELSIF * el;
    ZWCODE * zw1, *zw2;
    int z;
    zw2 = NULL;
    el = stat->st.ifthen.elsifselect;
    while (el != NULL)
    { zw1 = el->code;
      zw1->com.ifthen.elsif = zw2;
      zw1->com.ifthen.main = m;
      if (zw2 == NULL)
      { zw1->com.ifthen.elsest = stat->st.ifthen.elseselect;
        if (zw1->com.ifthen.scavec == 1)
        { if ((z = statement_lines(stat->st.ifthen.elseselect)) != 0)
          { zw1->com.ifthen.size += 4 + z;
            zw1->com.ifthen.cont += 2 + z;
          }
          else
          { zw1->com.ifthen.size += 1;
          }
        }
        else
        { if ((z = statement_lines(stat->st.ifthen.elseselect)) != 0)
          { zw1->com.ifthen.size += 1 + z;
            zw1->com.ifthen.cont += 1;
          }
        }
      }
      else
      { if (zw2->com.ifthen.scavec == 1)
        { zw2->com.ifthen.last = zw1->com.ifthen.bool;
          zw1->com.ifthen.size += zw2->com.ifthen.size +
                                 ((zw1->com.ifthen.scavec == 0) ? 1 : 0);
          zw1->com.ifthen.cont += ((zw1->com.ifthen.scavec == 0) ? 1 : 0);
        }
        else
        { zw1->com.ifthen.size += zw2->com.ifthen.size + 1;
          zw1->com.ifthen.cont += 1;
        }
      }
      if (zw1->com.ifthen.scavec == 1)
      { free_hvar(el->expr->hv);
        zw1->com.ifthen.main = m;
      }
      zw2 = zw1;
      el = el->link;
    }
    free_hvar(expr->hv);
    GET_MEM(zw1,1,ZWCODE);
    zw1->art = CO_IFTHEN;
    zw1->com.ifthen.main = m_mem;
    zw1->com.ifthen.scavec = expr->scavec;
    zw1->com.ifthen.bool = expr->hv;
    zw1->com.ifthen.stat = stat->st.ifthen.statements;
    zw1->com.ifthen.expr = expr->code;
    zw1->com.ifthen.elsif = zw2;
    zw1->com.ifthen.plus = plus;
    zw1->com.ifthen.cont = statement_lines(stat->st.ifthen.statements) + 
                           (expr->scavec * (2 + ((m_mem != NULL) ? 1 : 0)));
    zw1->com.ifthen.size = zw1->com.ifthen.cont + 1 + expr->zeilen + plus;
    stat->code = zw1;
    if (zw2 == NULL)
    { zw1->com.ifthen.elsest = stat->st.ifthen.elseselect;
      if (zw1->com.ifthen.scavec == 1)
      { int z;
        if ((z = statement_lines(stat->st.ifthen.elseselect)) != 0)
        { zw1->com.ifthen.size += 4 + z;
          zw1->com.ifthen.cont += 2 + z;
        }
        else
        { zw1->com.ifthen.size += 1; }
      }
      else
      { int z;
        if ((z = statement_lines(stat->st.ifthen.elseselect)) != 0)
        { zw1->com.ifthen.size += 1 + z;
          zw1->com.ifthen.cont += 1;
        }
      }
    }
    else
    { zw1->com.ifthen.elsif = zw2;
      if (zw2->com.ifthen.scavec == 1)
      { zw2->com.ifthen.last = zw1->com.ifthen.bool;
        zw1->com.ifthen.size += zw2->com.ifthen.size +
                                ((expr->scavec == 0) ? 1 : 0);
        zw1->com.ifthen.cont += ((zw1->com.ifthen.scavec == 0) ? 1 : 0);
      }
      else
      { zw1->com.ifthen.size += zw2->com.ifthen.size + 1;
        zw1->com.ifthen.cont += 1;
      }
    }
    stat->zeilen = zw1->com.ifthen.size;
    while (zw1->com.ifthen.elsif != NULL)
    { zw2 = zw1->com.ifthen.elsif;
      if (zw1->com.ifthen.scavec == 1)
        zw2->com.ifthen.cont += zw1->com.ifthen.cont;
      zw1 = zw2;
    }
    free_hvar(m);
  }  
  retexit = mem;
}


st_case(stat)
T_STATEMENT * stat;
{ T_EXPR * expr;
  VARNODE * var = NULL;
  ZWCODE * zw;
  int mem, nomore_mem;
  mem = retexit;
  nomore_mem = nomore;
  if (expr = stat->st.caseof.expr)
  { expr_auswerten(expr,0);
    if (expr->erg_art == ERG_CONST)
      WARNING(expr->Zeile,expr->Posit,text[216]);
    mache_Constexpr(expr,expr->erg_typ,1);
    if (enumeration_typ(expr->erg_typ) != JA)
    { if (expr->error == 0)
        SEMERROR(expr->Zeile,expr->Posit,0,0,text[221]);
      expr->error = 1;
    }
    if (expr->scavec == 1)
    { retexit &= ERL_EXITLOOP;
      GET_MEM(var,1,VARNODE);
      var->lk = VARi;
      VARi = var;
      var->free = 1;
      var->ein = get_hvar(typ_bool,var->scavec = 1);
      var->firstelem = BOOLEAN;
      var->dir_indir = DIRECT;
    }
  }
  case_auswertung(expr,stat->st.caseof.cases,var);
  nomore = nomore_mem;
  if (stat->st.caseof.elseselect != NULL)
  { anweisungen(stat->st.caseof.elseselect);
    if (interpreter == 0)
    { GET_MEM(zw,1,ZWCODE);
      zw->art = CO_CASE;
      zw->com.cases.stat = stat->st.caseof.elseselect;
      zw->com.cases.first = 2;
      zw->com.cases.var = var;
      zw->com.cases.zeilen = zw->com.cases.all =
                             statement_lines(stat->st.caseof.elseselect) +
                             expr->scavec * 4;
    }
  }
  else
  { if (interpreter == 0)
    { GET_MEM(zw,1,ZWCODE);
      zw->art = CO_CASE;
      zw->com.cases.first = 3;
      zw->com.cases.var = var;
      zw->com.cases.all = zw->com.cases.zeilen = expr->scavec * 4 + 1;
    }
  }
  nomore = nomore_mem;
  if (interpreter == 0)
  { T_CASES * cases = stat->st.caseof.cases;
    ZWCODE * zw1 = zw;
    int scavec = expr->scavec;
    int lines = zw->com.cases.zeilen;
    while (cases != NULL)
    { cases->code->com.cases.next = zw;
      lines += cases->code->com.cases.zeilen;
      if (scavec == 0)
      { cases->code->com.cases.all += zw->com.cases.all; }
      else
      { zw1->com.cases.all += cases->code->com.cases.all;
        cases->code->com.cases.zeilen += zw->com.cases.zeilen;
      }
      zw = cases->code;
      cases = cases->link;
    }
    stat->code = zw;
    stat->zeilen = lines;
    free_hvar(expr->hv);
    if (var != NULL)
      free_hvar(var);
  }
  retexit = mem;
}


st_while(stat)
T_STATEMENT * stat;
{ T_EXPR * expr;
  int mem, nomore_mem;
  int sonstige = 0;
  mem = retexit;
  if (expr = stat->st.whiledo.expr)
  { expr_auswerten(expr,0);
    if (match_typen(typ_bool,expr->erg_typ,0) != JA)
    { if (expr->error == 0)
        SEMERROR(expr->Zeile,expr->Posit,0,0,text[137]);
      interpreter = 1;
    }
    else
    { if (expr->erg_art == ERG_CONST)
      { WARNING(expr->Zeile,expr->Posit,text[254]);
        if (expr->erg.Const->wert.range.val == 1)
        { sonstige = 1; }
        else
        { nomore = (nomore == 0) ? 1 : nomore; }
      }
      mache_Constexpr(expr,typ_bool,1);
      if (expr->scavec == 1)
      { if (((proc_info & PI_VECTOR) == 0) &&
            (proc_info & PI_SCALAR))
        { if (expr->error == 0)
            SEMERROR(expr->Zeile,expr->Posit,0,0,text[220]);
          interpreter = 1;
        }
        else
        { if  (((proc_info & PI_VECTOR) == 0) && (proc_info & PI_SCALAR))
            proc_info |= PI_VECTOR;
          
        }
        retexit &= ERL_EXITLOOP;
      }
    }
    free_hvar(expr->hv);
  }
  nomore_mem = nomore;
  anweisungen(stat->st.whiledo.statements);
  nomore = nomore_mem;
  if (sonstige)
    nomore = (nomore == 0) ? 1 : nomore;
  if (interpreter == 0)
  { ZWCODE * zw;
    int z;
    GET_MEM(zw,1,ZWCODE);
    z = statement_lines(stat->st.whiledo.statements) + 1 + expr->scavec * 2;
    stat->zeilen = expr->zeilen + z + 1;
    zw->art = CO_WHILE;
    zw->com.whiledo.bool = expr->hv;
    zw->com.whiledo.expr = expr->code;
    zw->com.whiledo.stat = stat->st.whiledo.statements;
    if (((zw->com.whiledo.scavec = expr->scavec) == 1) && (expr->zeilen > 0))
    { VARNODE * var;
      GET_MEM(var,1,VARNODE);
      var->lk = VARi;
      VARi = var;
      var->scavec = 0;
      var->ein = get_hvar(typ_bool,0);
      var->dir_indir = DIRECT;
      var->firstelem = BOOLEAN;
      var->free = 1;
      zw->com.whiledo.sbool = var;
      stat->zeilen += 2;
      free_hvar(var);
    }
    stat->code = zw;
  }
  retexit = mem;
}


st_repeat(stat)
T_STATEMENT * stat;
{ T_EXPR * expr;
  int mem, nomore_mem;
  int sonstige = 0;
  mem = retexit;
  if (expr = stat->st.repeat.expr)
  { expr_auswerten(expr,0);
    if (expr->scavec == 1)
    { retexit &= ERL_EXITLOOP; }
    if (match_typen(typ_bool,expr->erg_typ,0) != JA)
    { if (expr->error == 0) 
        SEMERROR(expr->Zeile,expr->Posit,0,0,text[137]);
      interpreter = 1;
    }
    else
    { if (expr->erg_art == ERG_CONST)
      { WARNING(expr->Zeile,expr->Posit,text[254]);
        if (expr->erg.Const->wert.range.val == 0)
        { sonstige = 1; }
      }
      mache_Constexpr(expr,typ_bool,1);
      if (expr->scavec)
      { if (((proc_info & PI_VECTOR) == 0) &&
            (proc_info & PI_SCALAR))
        { if (expr->error == 0)
            SEMERROR(expr->Zeile,expr->Posit,0,0,text[220]);
        interpreter = 1;
        }
        else
        { if ((proc_info & PI_SCALAR) == 0)
            proc_info |= PI_VECTOR;
        }
      }
    }
    free_hvar(expr->hv);
  }
  nomore_mem = nomore;
  anweisungen(stat->st.repeat.statements);
  nomore = nomore_mem;
  if (sonstige)
    nomore = (nomore == 0) ? 1 : nomore;
  if (interpreter == 0)
  { ZWCODE * zw;
    int z;
    GET_MEM(zw,1,ZWCODE);
    z = statement_lines(stat->st.repeat.statements) + expr->scavec * 4;
    zw->com.repeat.lines = expr->zeilen;
    stat->zeilen = expr->zeilen + z + 1;
    zw->art = CO_REPEAT;
    zw->com.repeat.untilex = expr->Zeile;
    zw->com.repeat.bool = expr->hv;
    zw->com.repeat.expr = expr->code;
    zw->com.repeat.stat = stat->st.repeat.statements;
    if ((zw->com.repeat.scavec = expr->scavec) == 1)
    { VARNODE * var;
      GET_MEM(var,1,VARNODE);
      var->lk = VARi;
      VARi = var;
      var->scavec = 0;
      var->ein = get_hvar(typ_bool,0);
      var->dir_indir = DIRECT;
      var->firstelem = BOOLEAN;
      var->free = 1;
      zw->com.repeat.sbool = var;
      stat->zeilen += 2;
      free_hvar(var);
    }
    stat->code = zw;
  }
  retexit = mem;
}


st_loop(stat)
T_STATEMENT * stat;
{ int mem, nomore_mem, loopleft_mem;
  mem = retexit;
  retexit |= ERL_EXIT | ERL_EXITLOOP;
  nomore_mem = nomore;
  loopleft_mem = loopleft;
  loopleft = 0;
  anweisungen(stat->st.doloop.statements);
  nomore = nomore_mem;
  if (loopleft == 0)
    nomore = (nomore == 0) ? 1 : nomore;
  loopleft = loopleft_mem;
  if (interpreter == 0)
  { ZWCODE * zw;
    stat->zeilen = 1 + statement_lines(stat->st.doloop.statements);
    GET_MEM(zw,1,ZWCODE);
    zw->art = CO_LOOP;
    zw->com.loop = stat->st.doloop.statements;
    stat->code = zw;
  }
  retexit = mem;
}


st_for(stat)
T_STATEMENT * stat;
{ T_STATEMENT * st;
  T_EXPR * ex1, * ex2, * ex3;
  VARNODE * var, * var1, * var2;
  int mode, mem, nomore_mem;
  var = var2 = NULL;
  mem = retexit;
  mode = 0;
  anweisungen(st = stat->st.forto.st_fo_assign);
  ex1 = st->st.assign.design;
  if ((ex1->erg.eintr != NULL) && (ex1->erg.eintr->Art & N_VAR) != 0)
  { if (ex1->error == 0)
      SEMERROR(ex1->Zeile,ex1->Posit,0,0,text[222]);
    interpreter = ex1->error = 1;
  }
  else
  { if (ex1->erg_typ && (ex1->erg_typ->used[INTEGER] != 1))
    { if (ex1->error == 0)
        SEMERROR(ex1->Zeile,ex1->Posit,0,0,text[223]);
      interpreter = ex1->error = 1;
    }
  }
  if (interpreter == 0)
  { if (match_typen(typ_int,ex1->erg_typ,0) != JA)
    { GET_MEM(var,1,VARNODE);
      var->lk = VARi;
      VARi = var;
      var->free = 1;
      var->firstelem = INTEGER;
      var->dir_indir = DIRECT;
      var->ein = get_hvar(typ_int,var->scavec = ex1->scavec);
    }
    else
    { var = NULL; }
    var1 = NULL;
    if (ex1->scavec == 1)
    { mode = 1;
      retexit &= ERL_EXITLOOP;
      GET_MEM(var1,1,VARNODE);
      var1->lk = VARi;
      VARi = var1;
      var1->free = 1;
      var1->firstelem = BOOLEAN;
      var1->dir_indir = DIRECT;
      var1->ein = get_hvar(typ_bool,var1->scavec = 0);
      GET_MEM(var2,1,VARNODE);
      var2->lk = VARi;
      VARi = var2;
      var2->free = 1;
      var2->firstelem = BOOLEAN;
      var2->dir_indir = DIRECT;
      var2->ein = get_hvar(typ_bool,var2->scavec = 1);
    }
  }
  ex2 = stat->st.forto.toexpr;
  ex2->erg_typ = ex1->erg_typ;
  ex2->scavec = ex1->scavec;
  if (interpreter == 0)
    ex2->hv = neue_hv(ex2);
  ex2->scavec = 0;
  ex2->erg_typ = NULL;
  expr_auswerten(ex2,0);
  if (match_typen(ex1->erg_typ,ex2->erg_typ,0) != JA)
  { if ((ex1->error == 0) && (ex2->error == 0))
      SEMERROR(ex1->Zeile,ex1->Posit,ex2->Zeile,ex2->Posit,text[253]);
    interpreter = ex2->error = 1;
  }
  else
  { mache_Constexpr(ex2,ex1->erg_typ,0); }
  if (ex2->scavec > ex1->scavec)
  { if ((ex1->error == 0) && (ex2->error == 0))
      SEMERROR(ex1->Zeile,ex1->Posit,ex2->Zeile,ex2->Posit,text[277]);
    interpreter = 1;
  }
  if ((ex3 = stat->st.forto.byexpr) != NULL)
  { expr_auswerten(ex3,1);
    if (ex3->erg_art != ERG_CONST)
    { if (ex3->error == 0)
        SEMERROR(ex3->Zeile,ex3->Posit,0,0,text[206]);
      interpreter = ex3->error = 1;
    }
    if (match_typen(typ_int,ex3->erg_typ,0) != JA)
    { if (ex3->error == 0) 
        SEMERROR(ex3->Zeile,ex3->Posit,0,0,text[223]);
      ex3->error = interpreter = 1;
    }
    if (ex3->erg.Const && (ex3->erg.Const->wert.i == 0))
    { if (ex3->error == 0)
        SEMERROR(ex3->Zeile,ex3->Posit,0,0,text[344]);
      ex3->error = interpreter = 1;
    }
  }
  nomore_mem = nomore;
  anweisungen(stat->st.forto.statements);
  nomore = nomore_mem;
  if (interpreter == 0)
  { ZWCODE * zw;
    GET_MEM(zw,1,ZWCODE);
    zw->art = CO_FOR;
    zw->com.forto.ex1 = st->code;
    zw->com.forto.ex2 = ex2->code;
    zw->com.forto.lauf = ex1->hv;
    if (var != NULL)
    { zw->com.forto.temp = var;
      stat->zeilen += 2;
    }
    else
    { zw->com.forto.temp = ex1->hv; }
    zw->com.forto.sbool = var1;
    zw->com.forto.vbool = var2;
    zw->com.forto.stat = stat->st.forto.statements;
    zw->com.forto.bis = ex2->hv;
    if (ex2->erg_art == ERG_CONST)
      zw->com.forto.bisc = ex2->erg.Const;
    if (ex3 != NULL)
    { long i;
      if (ex3->erg.Const->Art == ST_CINT)
      { i = ex3->erg.Const->wert.i; }
      else
      { i = ex3->erg.Const->wert.range.val; }
      if (i < 0)
      { i = -i;
        mode |= 2;
      }
      zw->com.forto.inc = i;
    }
    else
    { zw->com.forto.inc = 1; }
    stat->code = zw;
    stat->zeilen += st->zeilen + ex2->zeilen +
                    statement_lines(stat->st.forto.statements) + 3 +
                    ex1->scavec * 5;
    zw->com.forto.mode = mode;
  }
  if (mode & 1)
  { free_hvar(var1);
    free_hvar(var2);
  }
  if (var != NULL)
  { free_hvar(var); }
  free_hvar(ex1->hv);
  free_hvar(ex2->hv);
  retexit = mem;
}


st_with(stat)
T_STATEMENT * stat;
{ VARNODE * var;
  WITH_COMP * wc;
  Eintrag * comp;
  T_EXPR * expr;
  ST * st, * a, * v;
  VARNODE * vari = NULL;
  SCOPE * sc;
  v = vector_ST;
  a = akt_ST;
  stat->st.with.ST = vector_ST = akt_ST = neue_ST(vector_ST,0);
  sc = new_scope(akt_scope);
  akt_scope  = sc;
  sc->st = akt_ST;
  stat->st.with.scop = sc;
  expr_auswerten(expr = stat->st.with.design,0);
  if (expr->erg_art == ERG_SPEC)
  { if ((expr->erg_typ != NULL) && (expr->erg_typ->Art == ST_TRECORD))
    { ZWCODE * zw = expr->code;
      int lines = expr->zeilen;
      st = expr->erg_typ->info.record.symtab;
      comp = st->record;
      if (comp && (comp->link == NULL))
      { ZWCODE * zw1;
        GET_MEM(zw1,1,ZWCODE);
        zw1->art = CO_WITH;
        zw1->com.with.prev = zw;
        zw1->com.with.nach = NULL;
        zw1->com.with.nummer = 0;
        zw = zw1;
      } 
      while (comp != NULL)
      { Eintrag * ein;
        int ex, art;
        if ((expr) && (expr->hv) && (expr->hv->ein))
          art = expr->hv->ein->Art;
        else
          art = N_SCALAR;
        ein = mache_Eintrag(comp->name_nr,&ex,
                            (( (expr->hv && expr->hv->ein &&
                                (expr->hv->ein->param.var.nummer <= 0) && 
                                (expr->hv->ein->param.var.dir_indir)) ||
                              (comp->param.komp.reladr)) ? N_VAR : 0) | art);
        ein->timestamp = akt_timestamp - 1 ;
        ein->Zeile = stat->Zeile;
        ein->Posit = stat->Posit;
        ein->gueltig = 1;
        ein->param.var.dir_indir = INDIRECT;
        ein->param.var.art = INTEGER;
        ein->param.var.vektoriell = expr->scavec;
        ein->param.var.type = comp->param.komp.type;
        if (interpreter == 0)
        { GET_MEM(wc,1,WITH_COMP);
          wc->link = wcomp;
          wcomp = wc;
          wc->komp = ein;
          if (comp->param.komp.reladr == 0)
          { wc->hvar = expr->hv->ein;
            if (expr->hv->ein->param.var.nummer != -1)
            { ein->param.var.dir_indir = wc->hvar->param.var.dir_indir;
              ein->param.var.ebene = wc->hvar->param.var.ebene;
              ein->param.var.nummer = wc->hvar->param.var.nummer;
            }
          }
          else
          { ZWCODE * zw1;
            GET_MEM(var,1,VARNODE);
            var->free = 1;
            var->firstelem = ein->param.var.type->firstelem;
            var->scavec = expr->scavec;
            var->dir_indir = INDIRECT;
            wc->hvar = var->ein = get_hvar(typ_int,((art & ~N_VAR) == N_SCALAR)
                                                   ? 0 : 1);
            var->lk = vari;
            vari = var;
            GET_MEM(zw1,1,ZWCODE);
            zw1->art = CO_WITH;
            zw1->com.with.adres = (expr->hv->ein->param.var.nummer > 0)
                                  ? ADRESS : DIRECT;
            zw1->com.with.prev = zw;
            zw1->com.with.var = expr->hv;
            zw1->com.with.nach = var;
            zw1->com.with.nummer = comp->param.komp.reladr;
            zw1->com.with.typ = comp->param.komp.styp;
            zw = zw1;
            lines++;
          }
        }
        comp = comp->link;
      }
      anweisungen(stat->st.with.statements);
      if (interpreter == 0)
        lines += statement_lines(zw->com.with.stat = stat->st.with.statements);
      stat->zeilen = lines;
      stat->code = zw;
      free_hvar(expr->hv);
      var = vari;
      while (var != NULL)
      { free_hvar(var);
        if (var->lk == NULL)
        { var->lk = VARi;
          var = NULL;
        }
        else
        { var = var->lk; }
      }
      if (vari != NULL)
        VARi = vari;
    }
    else
    { if (expr->error == 0)
        SEMERROR(expr->Zeile,expr->Posit,0,0,text[224]);
      expr->error = interpreter = 1;
    }
  }
  else
  { if (expr->error == 0)
      SEMERROR(expr->Zeile, expr->Posit,0,0,text[225]);
    expr->error = interpreter = 1;
    anweisungen(stat->st.with.statements);
  }
  akt_ST = a;
  vector_ST = v;          
  akt_scope = akt_scope->super;
}


st_exit(stat)
T_STATEMENT * stat;
{ if ((retexit & ERL_EXITLOOP) == 0)
  { SEMERROR(stat->Zeile,stat->Posit,0,0,text[342]);
    interpreter = 1;
  }
  else
    if ((retexit & ERL_EXIT) == 0)
    { SEMERROR(stat->Zeile,stat->Posit,0,0,text[226]);
      interpreter = 1;
    }
  if (interpreter == 0)
  { ZWCODE * zw;
    GET_MEM(zw,1,ZWCODE);
    zw->art = CO_EXIT;
    stat->code = zw;
    stat->zeilen = 1;
  }
  if (nomore == 0)
  { nomore = 1;
    loopleft = 1;
  }
}

extern int haupt_program;

st_return(stat)
T_STATEMENT * stat;
{ ST_TYPE * erg;
  T_EXPR * expr;
  int error;
  erg = NULL;
  error = 0;
  if ((retexit & ERL_RET) == 0)
  { if (haupt_program)
      SEMERROR(stat->Zeile,stat->Posit,0,0,text[251]);
    else
      SEMERROR(stat->Zeile,stat->Posit,0,0,text[227]);
    error = interpreter = 1;
  }
  if (nomore == 0)
  { returnstat = 1;
    nomore = 1;
  }
  if ((expr = stat->st.ret.expr) != NULL)
  { if (returntyp != NULL)
    { VARNODE * var;
      Eintrag * ein;
      ein = suche_Eintrag(0l,vector_ST,GLOBAL,0);
      GET_MEM(var,1,VARNODE);
      var->scavec = ((ein->Art & ~N_VAR) == N_SCALAR) ? 0 : 1;
      var->ein = ein;
      var->dir_indir = ein->param.var.dir_indir;
      var->firstelem = ein->param.var.type->firstelem;
      expr->hv = stat->st.ret.expr->hv = var;
    }
    expr_auswerten(expr,0);
    erg = expr->erg_typ;
    error |= expr->error;
  }
  else
  { if (returntyp != NULL)
    { if (error == 0)
      { SEMERROR(stat->Zeile,stat->Posit,0,0,text[327]);
        interpreter = error = 1;
      }
    }
  }
  if ((erg != returntyp) &&
     (match_typen(returntyp,erg,0) != JA))
  { if ((error == 0) && (returntyp == NULL))
    { SEMERROR(expr->Zeile,expr->Posit,0,0,text[184]);
      interpreter = error = 1;
    }
    else
    { if (error == 0)
      { SEMERROR(expr->Zeile,expr->Posit,0,0,text[228]); }
      interpreter = 1;
    }
  }
  else
  { if (expr != NULL)
    { if ((expr->scavec) && (proc_scavec == 0))
      { if (error == 0)
          SEMERROR(expr->Zeile,expr->Posit,0,0,text[229]);
        interpreter = error = 1;
      }
      else
      { mache_Constexpr(expr,returntyp,0); }
    }
  }
  if (interpreter == 0)
  { ZWCODE * zw;
    GET_MEM(zw,1,ZWCODE);
    zw->art = CO_RETURN;
    if (expr != NULL)
    { zw->com.retcode = expr->code;
      stat->zeilen = expr->zeilen + 1;
    }
    else
    { zw->com.retcode = NULL;
      stat->zeilen = 1;
    }
    stat->code = zw;
  }
}


st_parallel(stat)
T_STATEMENT * stat;
{ int status1, status2, zahl;
  ZWCODE * zw, *sel;
  ZWCODE * vari = NULL;
  C_CONF * co;
  SCOPE *  sc = NULL;
  status1 = proc_info;
  status2 = proc_parall;
  info_proc |= 4;
  /* selection */ 
  if (!stat->st.parallel.selection)
  { T_SELECT * s;
    GET_MEM(s,1,T_SELECT);
    stat->st.parallel.selection = s;
    s->art = SE_NONE;
  }
  analyse_select(stat->st.parallel.selection,
                 stat->st.parallel.parpos->Zeile,stat->st.parallel.parpos->Posit,&co);
  if (stat->st.parallel.selection != NULL)
  { zahl = stat->st.parallel.selection->proc;
    sel = stat->st.parallel.selection->code;
    sc = stat->st.parallel.scop = stat->st.parallel.selection->scop;
    vari = stat->st.parallel.selection->var;
    stat->zeilen = stat->st.parallel.selection->zeilen;
  }
  else
  { sel = NULL;
    zahl = akt_proz_anz;
  }

  if (proc_info & PI_VECTOR)
  { if (stat->error == 0)
    { SEMERROR(stat->st.parallel.parpos->Zeile,stat->st.parallel.parpos->Posit,
               0,0,text[145]);
      interpreter = 1;
    }
  }
  else
  { proc_info = PI_VECTOR;
    proc_parall = P_PARAL;
  }
  anweisungen(stat->st.parallel.statements);
  if (sc)
  { akt_scope  = sc->super; }
/*  if (co)
  { C_GROUP * g = get_group(co->conf_nr);
    if (g)
      g->port_variable = port_variable;
  }*/
  port_variable = 0;
  proc_parall = status2;
  proc_info = status1;
  akt_proz_anz = 0;
  vector_ST->hvarsvect = hvarsvect;
  vector_ST_entfernen();
  vector_ST = akt_ST;
  hvarsvect = vector_ST->hvarsvect;
  if (interpreter == 0)
  { GET_MEM(zw,1,ZWCODE);
    zw->art = CO_PARALLEL;
    zw->com.paral.prozanz = zahl;
    zw->com.paral.stat = stat->st.parallel.statements;
    zw->com.paral.Zeile2 = stat->st.parallel.Zeile2;
    zw->com.paral.select = sel;
    zw->com.paral.var = vari;
    stat->code = zw;
    zw->com.paral.lines = stat->zeilen +=
                          statement_lines(stat->st.parallel.statements);
  }
}

extern Eintrag * reduce_anal();

st_propagate(stat)
T_STATEMENT * stat;
{ info_proc |= 8;
  if ((proc_info & PI_SCALAR) && ((proc_info & PI_VECTOR) == 0))
  { if (stat->error == 0)
    { SEMERROR(stat->st.propagate.proppos->Zeile,stat->st.propagate.proppos->Posit,
               0,0,text[146]);
      interpreter = 1;
    }
  }
  { VARNODE * von, * nach;
    Eintrag * aus, * ein, * anzein;
    int epnr, apnr;
    long anznr;
    int ausanz, * bitfeld;
    int i, j, exist, offseta, conf1, conf2, confx = 0;
    SCAN_ELEM * se;
    T_SENDDIR * anal;
    ZWCODE * propzw = NULL;
    VARNODE * op = NULL;
    VARNODE * ip = NULL;
    T_EXPR * ex1, * ex2;
    int modus, mode = 0;
    int s_mode;
    s_mode = (modus = (stat->st.propagate.proppos->Art == _RECEIVE)) ? 2 : 3;
    ein = NULL;
    port_anal(anal = stat->st.propagate.senddir,s_mode,&apnr,&propzw,&stat->zeilen,
              &stat->error,&op,&offseta,&conf1,&mode,&aus,1,&confx);
    s_mode = (s_mode & 1) ? 0 : 1;
    anznr = 1;
    if ((se = anal->anzahl) != NULL)
    { if (se->Art == INTCONSTANT)
      { anznr = se->wert.i;
        anzein = NULL;
        if (anznr == 0)
        { SEMERROR(se->Zeile,se->Posit,0,0,text[79]);
          interpreter = stat->error = 1;
        }
      }
      else
      { anzein = suche_Eintrag(se->wert.ident_nr,vector_ST,GLOBAL,akt_timestamp);
        if (anzein != NULL)
        { switch (anzein->Art)
          { case N_CONSTANT :
              if (anzein->param.Const != NULL)
              { if (match_typen(typ_int, anzein->param.Const->type,0) == JA)
                { if (anzein->param.Const->Art == ST_CINT)
                  { anznr = anzein->param.Const->wert.i; }
                  else
                  { anznr = anzein->param.Const->wert.range.val; }
                  if (anznr <= 0)
                  { SEMERROR(se->Zeile,se->Posit,anzein->Zeile,anzein->Posit,
                             text[230]);
                    interpreter = stat->error = 1;
                    anznr = 1;
                  }
                  anzein = NULL;
                }
                else
                { SEMERROR(se->Zeile,se->Posit,anzein->Zeile,anzein->Posit,
                           text[230]);
                  interpreter = stat->error = 1;
                  anznr = 1;
                  anzein = NULL;
                }
              }
              else
              { SEMERROR(se->Zeile,se->Posit,anzein->Zeile,anzein->Posit,
                         text[171]);
                interpreter = stat->error = 1;
                anznr = 1;
                anzein = NULL;
              }
              break;
            case N_SCALAR :
              anzein->param.var.used = 1;
              if (match_typen(typ_int, anzein->param.var.type,0) != JA)
              { SEMERROR(se->Zeile,se->Posit,anzein->Zeile,anzein->Posit,
                         text[231]);
                interpreter = stat->error = 1;
                anznr = 1;
                anzein = NULL;
              }
              break;
            case N_VECTOR :
              SEMERROR(se->Zeile,se->Posit,anzein->Zeile,anzein->Posit,text[232]);
              interpreter = stat->error = 1;
              anznr = 1;
              anzein = NULL;
              break;
            default :
              { SEMERROR(se->Zeile,se->Posit,anzein->Zeile,anzein->Posit,
                         text[233]);
                interpreter = stat->error = 1;
                anznr = 1;
                anzein = NULL;
              }
              break;
          }
        }
        else
        { SEMERROR(se->Zeile,se->Posit,0,0,text[173]);
          interpreter = stat->error = 1;
          anzein = NULL;
          anznr = 1;
        }
      }
    }
    else
    { anzein = NULL;
      anznr = 1;
    }
    if (stat->st.propagate.proppos->Art == _SEND)
    { expr_auswerten(ex1 = stat->st.propagate.vonident,0);
      if (ex1->scavec == 1)
      { if (ist_einfacher_typ(ex1->erg_typ) == JA)
        { von = ex1->hv; }
        else
        { SEMERROR(ex1->Zeile,ex1->Posit,0,0,text[243]);
          interpreter = 1;
          von = NULL;
        }
      }
      else
      { if (ex1->error == 0)
        { if (ex1->erg_art != ERG_SPEC)
          { SEMERROR(ex1->Zeile,ex1->Posit,0,0,text[340]);
            interpreter = 1;
          }
          else
          { SEMERROR(ex1->Zeile,ex1->Posit,0,0,text[201]);
            interpreter = 1;
          }
        }
        von = NULL;
      }
    }
    else
    { if (stat->st.propagate.proppos->Art == _RECEIVE)
      { expr_auswerten(ex1 = stat->st.propagate.vonident,0);
        if ((ex1->erg_art == ERG_SPEC) && (ex1->scavec == 1))
        { if (ist_einfacher_typ(ex1->erg_typ) == JA)
          { von = ex1->hv; }
          else
          { SEMERROR(ex1->Zeile,ex1->Posit,0,0,text[243]);
            interpreter = 1;
            von = NULL;
          }
        }
        else
        { if (ex1->error == 0)
          { if (ex1->erg_art != ERG_SPEC)
            { SEMERROR(ex1->Zeile,ex1->Posit,0,0,text[340]);
              interpreter = 1;
            }
            else
            { SEMERROR(ex1->Zeile,ex1->Posit,0,0,text[201]);
              interpreter = 1;
            }
          }
          von = NULL;
        }
      }
    }
    if ((anal = stat->st.propagate.receivedir) != NULL)
    { ZWCODE * pzw = NULL;
      if (propzw)
      { pzw = propzw;
        propzw = NULL;
      }
      port_anal(stat->st.propagate.receivedir,s_mode,&epnr,&propzw,&stat->zeilen,&stat->error,
                &ip,&i,&conf2,&mode,&ein,2,&confx);
      if (confx == 0)
      { confx = conf1; }
      if (propzw)
        propzw->link = pzw;
      else
        propzw = pzw;
    }
    else
    { confx = conf2 = conf1;
      if (einzelverbind && aus)
      { if (offseta == 0)
        { ausanz = einzelverbind[apnr-1].zahl;
          epnr = einzelverbind[apnr-1].epnr;
        }
        else
        { ausanz = 1;
          for (j = apnr + aus->param.inout.von;j <= apnr + aus->param.inout.bis;j++)
          { if (einzelverbind[j-1].zahl != 1)
              ausanz = 2;
          }
          if (ausanz == 1)
          { C_GROUP * g;
            if (akt_conf || default_conf)
              g = get_group((akt_conf) ? akt_conf->conf_nr
                                       : default_conf->conf_nr);
            j = apnr + aus->param.inout.bis;
            if (g)
            { port_variable = g->port_variable;
              port_variable = (port_variable > j) ? port_variable : j;
              g->port_variable = port_variable;
            }
            mode |= 16;
          }
        }
      }
      else
      { ausanz = 0; }
      if (ausanz != 1)
      { anal = stat->st.propagate.senddir;
        if (stat->error == 0)
          SEMERROR(anal->send->Zeile,anal->send->Posit,0,0,text[241]);
        interpreter = stat->error = 1;
      }
    }
    if ((conf1 >= 0) && (conf2 >= 0) && (stat->st.propagate.proppos->Art == _PROPAGATE))
    { if (get_group(conf1) != get_group(conf2))
      { if (stat->error == 0)
        {  SEMERROR(stat->st.propagate.senddir->send->Zeile,
                    stat->st.propagate.senddir->send->Posit,
                    stat->st.propagate.receivedir->send->Zeile,
                    stat->st.propagate.receivedir->send->Posit,
                    text[147]); /* neuer Text */
          interpreter = stat->error = 1;
        }
      }
    }
    exist = 0;
    if ((stat->error == 0) && ((mode & 16) == 0))
    { C_GROUP * g;
      if (g = get_group(confx))
      { connect = g->bitfeld;
        if (aus)
        { for (j = apnr + aus->param.inout.von; j <= apnr + aus->param.inout.bis; j++)
          { if (bitfeld = &connect[(j-1) * port_anz])
            { for(i = epnr + ((ein != NULL) ? ein->param.inout.von : 0);
                  i <= epnr + ((ein != NULL) ? ein->param.inout.bis : 0); i++)
                exist |= GET_BIT(i,bitfeld);
            }
          }
        }
      }
      else
        exist = 1;
    }
    else
      exist = 1;
    if (exist == 0)
    { SEMERROR(stat->st.propagate.proppos->Zeile,stat->st.propagate.proppos->Posit,
               0,0,text[242]);
      interpreter = stat->error = 1;
    }
    if (stat->st.propagate.proppos->Art == _PROPAGATE)
    { if (ex1 = stat->st.propagate.vonident)
      { expr_auswerten(ex1,0);
        if (ex1->scavec == 1)
        { if (ist_einfacher_typ(ex1->erg_typ) == JA)
          { von = ex1->hv; }
          else
          { SEMERROR(ex1->Zeile,ex1->Posit,0,0,text[243]);
            interpreter = 1;
          }
        }
        else
        { if (ex1->error == 0)
          { if (ex1->erg_art != ERG_SPEC)
            { SEMERROR(ex1->Zeile,ex1->Posit,0,0,text[340]);
              interpreter = 1;
            }
            else
            { SEMERROR(ex1->Zeile,ex1->Posit,0,0,text[201]);
              interpreter = 1;
            }
          }
          von = NULL;
        }
      }
      expr_auswerten(ex2 = stat->st.propagate.nachident,0);
      if ((ex2->erg_art == ERG_SPEC) && (ex2->scavec == 1))
      { if (ist_einfacher_typ(ex2->erg_typ) == JA)
        { if (ex1 && (ex1->error == 0))
          { if (match_typen(ex1->erg_typ,ex2->erg_typ,0) != JA)
            { SEMERROR(ex1->Zeile,ex1->Posit,ex2->Zeile,ex2->Posit,text[182]);
              interpreter = 1;
            }
          }
          nach = ex2->hv;
        }
        else
        { SEMERROR(ex2->Zeile,ex2->Posit,0,0,text[243]);
          interpreter = 1;
        }
      }
      else
      { if (ex2->error == 0)
        { if (ex2->erg_art != ERG_SPEC)
          { SEMERROR(ex2->Zeile,ex2->Posit,0,0,text[340]);
            interpreter = 1;
          }
          else
          { SEMERROR(ex2->Zeile,ex2->Posit,0,0,text[201]);
            interpreter = 1;
          }
        }
        nach = NULL;
      }
      if (ex1 == NULL)
      { von = nach; }
    }
    else
    { ST * v;
      int vx = 0;
      C_GROUP * g;
      C_CONF * ac;
      if (g = get_group(conf2))
      { v = vector_ST_eintragen(g->vectors);
        if (g->vectors)
          activation(g->vectors->dim);
        vx = 1;
      }
      ex2 = stat->st.propagate.nachident;
      if ((ex2->select == E_DESIGNAT) && (!ex2->factors.designator.selector))
      { expr_auswerten(ex2 = stat->st.propagate.nachident,0);
        if ((ex2->erg_art == ERG_SPEC) && (ex2->scavec == 1))
        { if (ist_einfacher_typ(ex2->erg_typ) == JA)
          { if (ex1 && (ex1->error == 0))
            { if (match_typen(ex1->erg_typ,ex2->erg_typ,0) != JA)
              { SEMERROR(ex1->Zeile,ex1->Posit,ex2->Zeile,ex2->Posit,text[182]);
                interpreter = 1;
              }
            }
            nach = ex2->hv;
          }
          else
          { SEMERROR(ex2->Zeile,ex2->Posit,0,0,text[243]);
            interpreter = 1;
          }
        }
        else
        { if (ex2->error == 0)
          { if (ex2->erg_art != ERG_SPEC)
            { SEMERROR(ex2->Zeile,ex2->Posit,0,0,text[340]);
              interpreter = 1;
            }
            else
            { SEMERROR(ex2->Zeile,ex2->Posit,0,0,text[201]);
              interpreter = 1;
            }
          }
          nach = NULL;
        }
      }
      else
      { SEMERROR(ex2->Zeile,ex2->Posit,0,0,text[245]); /* neuer Text */
        interpreter = stat->error = 1;
      }
      if (vx)
      { vector_ST_eintragen(v);
        if (v)
          activation(v->dim);
      }
      ac = (akt_conf) ? akt_conf : default_conf;
      if (ac && (g = get_group(ac->conf_nr)))
      { dim_typen = ac->typ;
        vector_ST_eintragen(g->vectors);
        if (g->vectors)
          activation(g->vectors->dim);
      }
    }
    if ((stat->st.propagate.proppos->Art != _PROPAGATE) ||
        (stat->st.propagate.reduce_ident))
    { Eintrag * rein = NULL;
      if (stat->st.propagate.reduce_ident)
      { if (ex1)
        { rein = reduce_anal(stat->st.propagate.reduce_ident,
                             ex1->error,ex1->Zeile,ex1->Posit,ex2->erg_typ,
                             ex2->error,ex2->Zeile,ex2->Posit,ex2->erg_typ,&stat->error);
        }
        else
        { rein = reduce_anal(stat->st.propagate.reduce_ident,0,0,0,NULL,
                             ex2->error,ex2->Zeile,ex2->Posit,ex2->erg_typ,&stat->error);
        }
      }
      if (interpreter == 0)
      { ZWCODE * zw;
        C_GROUP * g;
        GET_MEM(zw,1,ZWCODE);
        switch(stat->st.propagate.proppos->Art)
        { case _PROPAGATE :  zw->art = CO_PROPAGATERE;
          break;
          case _SEND :  zw->art = CO_SEND;
          break;
          case _RECEIVE :  zw->art = CO_RECEIVE;
          break;
        }
        if (mode & 16)
        { g = get_group(akt_conf->conf_nr);
          zw->com.prop.ebene = g->vectors->Ebene;
        }
        zw->com.propre.code = propzw;
        zw->com.propre.pna = rein;
        if (mode & 1)
        { if (modus)
            zw->com.propre.in.port = op;
          else
            zw->com.propre.out.port = op;
        }
        else
        { if (modus)
            zw->com.propre.in.pnr = apnr;
          else
            zw->com.propre.out.pnr = apnr;
        }
        if (mode & 2)
        { if (modus)
            zw->com.propre.out.port = ip;
          else
            zw->com.propre.in.port = ip;
        }
        else
        { if (modus)
            zw->com.propre.out.pnr = epnr;
          else
            zw->com.propre.in.pnr = epnr;
        }
        if (modus)
        { int m = mode & ~3;
          m |= ((mode & 1) ? 2 : 0);
          m |= ((mode & 2) ? 1 : 0);
          mode = m;
        }
        zw->com.propre.von = von;
        zw->com.propre.nach = nach;
        if (ex1)
        { zw->com.propre.vonex = ex1->code;
          free_hvar(ex1->hv);
        }
        else
          zw->com.propre.vonex = NULL;
        zw->com.propre.nachex = ex2->code;
        free_hvar(ex2->hv);
        if (ip != NULL)
        { free_hvar(ip); }
        if (op != NULL)
        { free_hvar(op); }
        zw->com.propre.mode = mode;
        if (ex1 && (stat->st.propagate.proppos->Art != _SEND))
        { int z;
          ST_TYPE * t;
          if (modus)
          { t = ex1->erg_typ;
            ex1->erg_typ = ex2->erg_typ;
            z = ex1->zeilen;
            ex1->zeilen = 0;
            ex1->code = NULL;
            zw->com.propre.test = check_ranges(ex1,t);
            ex1->zeilen += z;
          }
          else
          { t = ex2->erg_typ;
            ex2->erg_typ = ex1->erg_typ;
            z = ex2->zeilen;
            ex2->zeilen = 0;
            ex2->code = NULL;
            zw->com.propre.test = check_ranges(ex2,t);
            ex2->zeilen += z;
          }
        }
        stat->zeilen += 3 + ((ex1 == NULL) ? (ex2->zeilen) :
                        (((stat->st.propagate.proppos->Art != _PROPAGATE) ? 0 : 1) + 
                        ex1->zeilen + ex2->zeilen));
        stat->code = zw;
      }
    }
    else
    { if (interpreter == 0)
      { ZWCODE * zw;
        VARNODE * var = NULL;
        C_GROUP * g;
        GET_MEM(zw,1,ZWCODE);
        zw->art = CO_PROPAGATE;
        if (mode & 16)
        { g = get_group(akt_conf->conf_nr);
          zw->com.prop.ebene = g->vectors->Ebene;
        }
        if (anzein == NULL)
        { if (anznr > 1)
          { mode |= 4;
            zw->com.prop.anz.anz = anznr;
            GET_MEM(var,1,VARNODE);
            var->lk = VARi;
            VARi = var;
            var->ein = get_hvar(typ_int,var->scavec = 0);
            var->firstelem = INTEGER;
            var->free = 1;
            var->dir_indir = DIRECT;
            free_hvar(var);
            zw->com.prop.temp = var;
            stat->zeilen += 3;
          }
          else
          { zw->com.prop.anz.anz = 1; }
        }
        else
        { mode |= 12;
          GET_MEM(var,1,VARNODE);
          var->lk = VARi;
          VARi = var;
          var->ein = anzein;
          var->firstelem = INTEGER;
          var->free = 1;
          var->dir_indir = DIRECT;
          zw->com.prop.anz.var = var;
          GET_MEM(var,1,VARNODE);
          var->lk = VARi;
          VARi = var;
          var->ein = get_hvar(typ_int,var->scavec = 0);
          var->firstelem = INTEGER;
          var->free = 1;
          var->dir_indir = DIRECT;
          free_hvar(var);
          zw->com.prop.temp = var;
          stat->zeilen += 5;
        }
        zw->com.prop.code = propzw;
        if (mode & 1)
        { zw->com.prop.out.port = op; }
        else
        { zw->com.prop.out.pnr = apnr; }
        if (mode & 2)
        { zw->com.prop.in.port = ip; }
        else
        { zw->com.prop.in.pnr = epnr; }
        zw->com.prop.von = von;
        zw->com.prop.nach = nach;
        if (ex1)
        { zw->com.prop.vonex = ex1->code;
          free_hvar(ex1->hv);
        }
        else
          zw->com.prop.vonex = NULL;
        zw->com.prop.nachex = ex2->code;
        free_hvar(ex2->hv);
        if (ip != NULL)
        { free_hvar(ip); }
        if (op != NULL)
        { free_hvar(op); }
        zw->com.prop.mode = mode;
        if (ex1)
        { int z;
          ST_TYPE * t = ex2->erg_typ;
          ex2->erg_typ = ex1->erg_typ;
          z = ex2->zeilen;
          ex2->zeilen = 0;
          ex2->code = NULL;
          zw->com.prop.test = check_ranges(ex2,t);
/*          stat->zeilen += ex2->zeilen;*/
          ex2->zeilen += z;
        }
        stat->zeilen += 1 + ((ex1 == NULL) ? (ex2->zeilen) :
                                             (1 + ex1->zeilen + ex2->zeilen));
        stat->code = zw;
      }
    }
#ifdef DEBUG
    if (no_internal)
    { printf("Propagate   %d %d    %d    ",apnr,epnr);
      if (anzein == NULL)
      { printf(" %d\n",anznr); }
      else
      { printf(" %s\n",anzein->Name); }
    }
#endif
  }
}


st_load(stat)
T_STATEMENT * stat;
{ info_proc |= 8;
  if ((proc_info & PI_VECTOR) && stat->st.load.selection)
  { if (stat->error == 0)
    { SEMERROR(stat->st.load.loadpos->Zeile,stat->st.load.loadpos->Posit,
               0,0,text[152]);
      interpreter = 1;
    }
  }
  down_load_anal(stat,_LOAD);
  if (interpreter == 0)
  { stat->code->art = CO_LOAD; }
}

st_store(stat)
T_STATEMENT * stat;
{ info_proc |= 8;
  if ((proc_info & PI_VECTOR) && stat->st.load.selection)
  { if (stat->error == 0)
    { SEMERROR(stat->st.load.loadpos->Zeile,stat->st.load.loadpos->Posit,
               0,0,text[152]);
      interpreter = 1;
    }
  }
  down_load_anal(stat,_STORE);
  if (interpreter == 0)
  { stat->code->art = CO_STORE; }
}




                                                                                 
