/* Parallaxis Version: @(#)typen.h	2.13  2/28/92 14:47:47  */
/* ************************************************************************* */
/*                                                                           */
/* Parallaxis-Compiler von Ingo Barth                                        */
/*                                                                           */
/* Datei : typen.h                                                           */
/*                                                                           */
/* Definitionen fuer den Syntaxbaum                                          */
/*                                                                           */
/* ************************************************************************* */

/* wieviele verschiedene PARZ-Typen gibt es ? */
# define        ALL         4


/* Struktur zur Speicherung der relevanten Eingabedaten mit ihren Positionen */

typedef struct {
    int Zeile, Posit;           /* Positionsangabe */
    int Art;                    /* Auswahl */
    union {
        int i;                  /* Integerwert */
        float r;                /* Realwert */
        char c;                 /* Einzelnes Zeichen */
        char * s;               /* ein String */
        long ident_nr;          /* Nummer des Bezeichners im WB */
        int op;                 /* Operatornummer */
          } wert;
    } SCAN_ELEM;

/* Scanner liefert Zeiger auf SCAN_ELEM Struktur */


/* Strukturen zur Speicherung des Syntaxbaumes */
                                   
typedef struct T_system {                          /* System-Knoten */
        SCAN_ELEM * sys_ident;                     /* Systemname */
        struct T_Declarations * decl;              /* Declarationen */
        struct T_statement * statements;           /* Anweisungen */
        struct c_group * confs;                    /* Konfigurationen */
        struct c_conf * single_conf;               /* einzige konfiguration */
        int start, end;                            /* Anfangs- und Endezeile in PARZ */
        int protokollart;                          /* protokollieren ? */
        struct scope * scop;
        int port_variables;
        } T_SYSTEM;

typedef struct T_Declarations {
        struct T_Declarations * link;
        int select;                                /* Art der Deklaration */
        int Zeile, Posit;
        union {
            struct T_Constdecl * Const;            /* Konstante */
            struct T_typedecl * Type;              /* Typ */
            struct T_config * conf;                /* Konfiguration */
            struct T_conn * conn;                  /* Connection */
            struct T_vardef * ska_var;             /* Variablen skalar */
            struct T_vardef * vek_var;             /* Variablen vektoriell */
            struct T_procedecl * procs;            /* Prozeduren */
            } art;
        } T_DECLARATIONS;

typedef struct T_Constdecl {                       /* ConstanDeclt-Knoten */
        struct T_Constdecl * link;
        SCAN_ELEM * ident;                         /* zudefinierender Name */
        struct T_expr * Constant;                  /* Konstantendefinition */
        } T_CONSTDECL;

typedef struct T_typedecl {                        /* TypeDecl-Knoten */
        struct T_typedecl * link;
        SCAN_ELEM * ident;                         /* zudefinierender Name */
        struct T_type * type;                      /* Typdefinition */
        } T_TYPEDECL;

typedef struct T_config {                          /* Configuration-Knoten */
        struct T_config * link;
        SCAN_ELEM * ident;                         /* Konfigurationsname */
        struct T_subrange * ranges;                /* Bereiche */
        struct c_group * group;                    /* Gruppe */
        } T_CONFIG;

typedef struct T_transfer {                        /* TransferFunc-Knoten */
        struct T_transfer * link;
        int count;
        struct T_io_ident * out_ident;             /* OUT-Port */
        SCAN_ELEM * conf_ident;                    /* Konfigurationsname */
        struct T_source * sources;                 /* Quellenangaben */
        struct T_destination * destinations;       /* Zielbeschreibungen */
        int arrow;                                 /* Pfeilart */
        int error;                                 /* Syntax-Fehler */
        } T_TRANSFER;

typedef struct T_conn {
        T_TRANSFER * trans;                        /* Verbindungsdefinitionen */
        int Zeile, Posit;                          /* Position des Schl"usselwortes */
        int timestamp;                             /* Timestamp am Endeeiner Def. */
        } T_CONN;

typedef struct T_vardef {                          /* VarDecl-Knoten */
        struct T_vardef * link;
        struct ST_type * typbeschr;                /* Typbeschreibung in ST-Form */
        struct T_identlist * ident_list;           /* Namensliste */
        struct T_type * type;                      /* Typbeschreibung in Syntax-Form */
        } T_VARDEF;

typedef struct T_procedecl {                       /* ProcedureDecl-Knoten */
        struct S_T * ST;                           /* Symboltabellenzeiger */
        struct Eintr * reference;                  /* Prozedurname in der Symboltabelle */
        SCAN_ELEM * ident;                         /* Prozedurname */
        struct T_param * paramseq;                 /* Parameterbeschreibung */
        SCAN_ELEM * scavec;                        /* Ergebnis ist skalar oder vektoriell */
        struct T_type * type;                      /* Typ des Funktionsergebnis in Syntax-Form */
        int complex;                               /* Adresse fuer Ergebnis uebergeben */
        T_DECLARATIONS * decls;                    /* Declarationen */
        struct c_group * confs;                    /* Konfigurationen */
        struct c_conf * single_conf;               /* einzige Konfiguration */
        int last_index;                            /* timestamp am Ende */
        struct T_statement * statements;           /* Anweisungen */
/*        struct hvars * hv_scal;                    /* skalare Hilfsvariablen */
/*        struct hvars * hv_vect;                    /* vektorielle Hilfsvariablen */
        struct varnode * hv;                       /* Hilfsvariablen fuer Parameterberechnung */
        struct zwcode * pacode;                    /* Anweisungen fuer Parameterberechnung */
        struct zwcode * recode;                    /* Anweisungen fuer Rueckgabewert */
        int zeilen;                                /* fuer diese Prozedur benoetigte Zeilen */
        int proc_info;                             /* Prozedurart */
        int proc_mode;                             /* Inhalt der Procedur */
        int start, end;                            /* Anfangs- und Endezeile in PARZ */
        struct varnode * hvlist;                   /* Liste der Hilfsvariablen */
        int Zeile, Posit;                          /* Position fuer Fehlermeldung ohne RETURN */
        int Zeile2;                                /* Position fuer END-Marke */
        int endzeile;                              /* Position fuer PARZ-Ausgabe */
        int protokollart;                          /* protokollieren ? */
        struct scope * scop;
        int scope_count;
        int port_variables;
        } T_PROCEDECL;

typedef struct T_statement {                       /* Statements-Knoten */
        struct T_statement * link;
        int select;                                /* Statementart */
        int error;                                 /* Fehler bereits gemeldet */
        int zeilen;                                /* Anzahl der Zwischencodezeilen */
        int Zeile, Posit;                          /* Positionsangabe */
        int scavec;                                /* Statement befindet sich in skalarer/vektorieller Umgebung */
        int unreached;                             /* 1 falls Anweisung nie erreichbar */
        struct varnode * hv;                       /* Liste der Variablen der Anweisung */
        struct zwcode * code;                      /* Liste der Anweisungen fuer das Statement */
        union {
            struct {                               /* Zuweisung design := expr */
                struct T_expr * design;
                struct T_expr * expr;
                } assign;
            struct {                               /* Funktionsaufruf procident(exprlist) */
                SCAN_ELEM * procident;
                struct T_expr * exprlist;
                } proc;
            struct {                               /* IF expr THEN statements elsifselect ELSE elseselect END */
                struct T_expr * expr;
                struct T_statement * statements;
                struct T_elsif * elsifselect;
                struct T_statement * elseselect;
                } ifthen;
            struct {                               /* CASE expr OF cases ELSE elseselect END */
                struct T_expr * expr;
                struct T_cases * cases;
                struct T_statement * elseselect;
                } caseof;             
            struct {                               /* WHILE expr DO statments END */
                struct T_expr * expr;
                struct T_statement * statements;
                } whiledo;
            struct {                               /* REPEAT statements UNTIL expr */
                struct T_statement * statements;
                struct T_expr * expr;
                } repeat;
            struct {                               /* LOOP statements END */
                struct T_statement * statements;
                } doloop;
            struct {                               /* FOR st_fo_assign TO toexpr BY byexpr DO statements END */
                struct T_statement * st_fo_assign;
                struct T_expr * toexpr;
                struct T_expr * byexpr;
                struct T_statement * statements;
                } forto;
            struct {                               /* WITH design DO statements END */
                struct S_T * ST;
                struct T_expr * design;
                struct T_statement * statements;
                struct scope * scop;
                } with;             
            struct {                               /* RETURN expr */
                struct T_expr * expr;
                } ret;
            struct {                               /* PARALLEL selection statements ENDPARALLEL */
                SCAN_ELEM * parpos;
                struct T_select * selection;
                struct T_statement * statements;
                struct scope * scop;
                int Zeile2;
                } parallel;
            struct {                               /* PROPAGATE senddir receivedir (vonident,nachident) */
                int select;                        /* PROPAGATE, SEND oder RECEIVE */
                SCAN_ELEM * proppos;
                struct T_senddir * senddir;
                struct T_senddir * receivedir;
                struct T_expr * vonident;
                struct T_expr * nachident;
                SCAN_ELEM * reduce_ident;
                } propagate;
            struct {                               /* LOAD/STORE selection (vecident,scalident,lengident) */
                SCAN_ELEM * loadpos;
                struct T_select * selection;
                struct T_expr * vecident;
                struct T_expr * scalident;
                struct T_expr * lengident;
                struct scope * scop;
                } load;
            } st;
        } T_STATEMENT;

typedef struct T_Constant {                        /* Constant-Knoten */
        struct T_Constant * link;
        int Zeile, Posit;                          /* Positionsangabe */
        int count;
        int art;                                   /* Art der Konstanten */
        union {
            SCAN_ELEM * simple;                    /* Name einer Konstanten */
            struct {                               /* konstante Struktur */
                SCAN_ELEM * ident;
                struct T_Constant * Constant;
                } record;
            } wert;
        } T_CONSTANT;
        
typedef struct T_type {                            /* Typ-Knoten */
        struct T_type * link;
        int art;                                   /* Art des Typs */
        int Zeile,Posit;                           /* Beginn der Beschreibung */
        struct ST_type * erg_typ;                  /* Typ in ST-Form */
        union {
            SCAN_ELEM * ident;                     /* Typname */
            struct T_subrange * range;             /* Bereichsdefinition */
            struct T_identlist * identlist;        /* Aufzaehlung */
            struct {                               /* Felddefinition */
                struct T_type * dimen;
                struct T_type * type;
                } array;
            struct {                               /* Strukturdefintion */
                struct S_T * ST;                   /* Symboltabelle fuer die Komponenten */
                struct T_recdef * fieldlist;
                } record;
            struct T_type * settyp;                /* Mengenbeschreibung */
            } typ;
        } T_TYPE;

typedef struct T_recdef {                          /* FieldListknoten */
        struct T_recdef * link;
        int select;                                /* Art : normal oder variante */
        union {
            struct T_vardef * norm;                /* normal */
            struct {
                struct T_identlist * ident;                 /* Selektionsname */
                T_TYPE * typ;                      /* Selektionstyp */
                struct T_variant * vari;           /* variante */
                struct T_recdef * elseteil;        /* ELSE-Teil */
                } selected;
            } art;
        struct ST_type * typ;
        } T_RECDEF;

typedef struct T_variant {                         /* Varianten */
        struct T_variant * link;
        struct T_caselabel * caselist;             /* CaseLabelList */
        T_RECDEF * fieldlist;                      /* Variablenliste */
        } T_VARIANT;

typedef struct T_subrange {                        /* Range-Knoten */
        struct T_subrange * link;
        int count;
        int zeilen;                                /* Zahl der benoetigeten PARZ-Zeilen */
        struct varnode * hv;                       /* Hilfsvariable */
        struct T_expr * von;                       /* von-expr */
        struct T_expr * bis;                       /* bis-expr */
        } T_SUBRANGE;

typedef struct T_source {                          /* Source-Knoten */
        struct T_source * link;
        int count;
        SCAN_ELEM * wert;                          /* Quellenangabe */
        } T_SOURCE;

typedef struct T_destination {                     /* Destination-Knoten */
        struct T_destination * link;
        struct T_expr * discexpr;                  /* { discexpr } conf_ident [ exprlist ] . in_ident */
        SCAN_ELEM * conf_ident;
        T_SUBRANGE * exprlist;
        struct T_io_ident * in_ident;
        int error;                                 /* Syntax-Fehler */
        } T_DESTINATION;

typedef struct T_identlist {                       /* IdentList-Knoten */
        struct T_identlist * link;
        int count;                                 /* Anzahl der Identifier in der Liste */
        SCAN_ELEM * ident;
        int zeilen;                                /* Anzahl der Codezeilen bei Parameter */
        struct Eintr  * ein;
        } T_IDENTLIST;
                     
typedef struct T_expr {                            /* Faktor-Term-Expr-Knoten */
        struct T_expr * link;
        int count;
        int Zeile, Posit;                          /* Positionsangabe */
        int error;                                 /* Ausdruck ist fehlerhaft */
        int readonly;                              /* Ergebnis ist nur lesbar */
        struct ST_type * erg_typ;                  /* Typ des Ergebnisses */
        int scavec;                                /* Ergebnis ist skalar oder vektoriell */
        int erg_art;                               /* Ergaebnisart */
        union {                                    /* Ergebnis ist Konstante oder ST-Eintrag */
            struct ST_Const * Const;
            struct Eintr * eintr;
            } erg;
        int zeilen;                                /* Anzahl der Zwischencodezeilen */
        struct varnode * hv;                       /* Liste der Variablen des Ausdrucks */
        struct zwcode * code;                      /* Liste der Anweisungen zur Berechnung des Ausdrucks */
        int select;                                /* Art des Ausdrucks */
        union {
            SCAN_ELEM * Const;                     /* Name */
            struct {                               /* expr1 operator expr2 */
                int twice;
                struct T_expr * expr1;
                SCAN_ELEM * operator;
                struct T_expr * expr2;
                } binop;
            struct {                               /* funcident ( exprlist ) */
                SCAN_ELEM * funcident;
                struct T_expr * exprlist;
                } funccall;
            struct {                               /* ident selector */
                SCAN_ELEM * ident;
                struct T_designrest * selector;
                } designator;
            struct {                               /* setident { elements } */
                SCAN_ELEM * setident;
                T_SUBRANGE * elements;
                } sets;
            struct T_expr * klexpr;                /* ( klexpr ) */
            struct T_expr * notexpr;               /* NOT notexpr */
            struct {                               /* REDUCE . redident selection ( expr ) */
                SCAN_ELEM * redident;
                struct T_select * select;
                struct T_expr * expr;
                struct scope * scop;
                } reduce;
            } factors;
        } T_EXPR;

typedef struct T_designrest {                      /* DesignatorRest-Knoten */
        struct T_designrest * link;
        int count;
        int Zeile, Posit;                          /* Positionsangabe */
        int select;                                /* Art des Selektion */
        union {
            SCAN_ELEM * ident;                     /* . ident */
            T_EXPR * exprlist;                     /* [ exprlist ] */
            SCAN_ELEM * deref;                     /* ^ */
            } design;
        } T_DESIGNREST;

typedef struct T_param  {                           /* Param-Knoten */
        struct T_param * link;
        int count;
        struct ST_type * paramtyp;                  /* Datentyp der Parameter in ST-Form */
        int varpara;                                /* Var-Parameter ? */
        int par_anz;                                /* Zahl der Parameter dieser Definition */
        int skavecvar;                              /* ( SCALAR | VECTOR ) [VAR] */
        T_VARDEF * vardef;                          /* Parameterdefinition */
        int zeilen;                                 /* Anzahl der Codezeilen bei Parameter */
        struct zwcode * code;                       /* Anweisungen bei Parametern */
        struct varnode * hv;                        /* Hilfsvariablen */
        } T_PARAM;

typedef struct T_select {                           /* Selection-Knoten */
        struct T_select * link;
        int count;
        int proc;                                   /* Anzahl der noetigen Plaetze */
        int anzahl;                                 /* Anzahl der maximal moegl. Proz. */
        struct zwcode * code;                       /* Kode fuer die Auswahl */
        int zeilen;                                 /* Zeilen fuer die Auswahl */
        struct zwcode * var;                        /* Auswahlvariable */
        int art;                                    /* Art der Auswahl */
        SCAN_ELEM * ident;                          /* Konfigurationsname */
        T_SUBRANGE * ranges;                        /* Auswahldefinition */
        struct scope * scop;                        /* Geltungsbereich */
        } T_SELECT;
                        
typedef struct T_elsif {                           /* ElsIf-Knoten */
        struct T_elsif * link;
        int zeilen;                                /* wieviele PARZ-Zeilen */
        struct zwcode * code;                      /* PARZ-Code */
        T_EXPR * expr;                             /* ELSIF expr THEN statements */
        T_STATEMENT * statements;
        } T_ELSIF;

typedef struct T_senddir {                         /* Send-/Receive-Knoten */
        SCAN_ELEM * ident;                         /* Konfigurationsname */
        SCAN_ELEM * send;                          /* send [ (expr) ] [^ anzahl ] */
        T_EXPR * expr;
        SCAN_ELEM * anzahl;
        } T_SENDDIR;

typedef struct T_cases {                           /* Case-Knoten */
        struct T_cases * link;
        struct T_caselabel * caselabel;            /* von .. bis , ... */
        T_STATEMENT * statements;
        struct zwcode * code;                      /* Zwischenkode */
        int zeilen;                                /* Anzahl der Zeilen */
        } T_CASES;

typedef struct T_caselabel {                       /* Caselabel-Knoten */
        struct T_caselabel * link;
        T_EXPR * von;                              /* von .. bis */
        T_EXPR * bis;
        struct zwcode * code;                      /* Zwischenkode */
        int zeilen;                                /* Anzahl der Zeilen */
        int unten, oben;                           /* Zahlenwerte der Grenzen */
        } T_CASELABEL;

typedef struct T_io_ident {                        /* IO_Ident-Knoten */
        SCAN_ELEM * ident;                         /* ident ( Const ) */
        SCAN_ELEM * Const;
        int timestamp;
        } T_IO_IDENT;


/* Struktur zur Speicherung der Verbindungsdaten */

typedef struct connect {
        int ziel_proz;                             /* Zielprozessornummer */
        int ziel_port;                             /* Port des Zielprozessors */
        int quell_proz;                            /* Quellprozessornummer */
        int e_Zeile, e_Posit;                      /* Position der Eingangsdefintion */
        int a_Zeile, a_Posit;                      /* Position der Ausgangsdefinition */
        } CONNECT;

