static char _sccsid[] = "Parallaxis Version: @(#)wb.c	2.13  2/28/92 15:10:06";

/* *********************************************************************** */
/*                                                                         */
/* Parallaxis-Compiler von Ingo Barth                                      */
/*                                                                         */
/* Datei : wb.c                                                            */
/*                                                                         */
/* Funktionen fuer das Woerterbuch                                         */
/*                                                                         */
/* *********************************************************************** */

#include "defines.h"
#include "typen.h"
#include "y_tab.h"
#include "parallax.h"       /* wegen GET_MEM */
#include "symbols.h"        /* wegen TABELLENGROESSE und HASH_FAKTOR */

extern char yytext[];       /* String fuer enterstring */
extern char * strsave();    /* String sichern */
int ident_length = 0;       /* Bytes f"ur alle Identifier */
int ident_count = 0;        /* Anzahl der Identifier */

/* Defintion der Woerterbuchstruktur */

typedef struct wbe
{ struct wbe * next;   /* Verkettung */
  char       * name;   /* Bezeichner */
  int          art;    /* Schl"usselwort oder Bezeichner */
  int          nr;     /* Nummer in der linearen Kette */
} WB;

WB * wb[TABELLENGROESSE]; /* das Woerterbuch */



/* *********************************************************************** */
/* initialisiere das W"orterbuch mit NULL-Eintr"agen                       */
/*                                                                         */
/* Ergebnis :                                                              */
/*                                                                         */
/* *********************************************************************** */

clear_wb()
{   register int h;
    for (h = 0; h < TABELLENGROESSE; wb[h++] = NULL);
}


/* *********************************************************************** */
/* Hashfunktion                                                            */
/*                                                                         */
/* Ergebnis : Hashzahl                                                     */
/*                                                                         */
/* Parameter : String                                                      */
/*                                                                         */
/* *********************************************************************** */

static int hash(z)
char * z;
{   register int h = 0;
    while (*z)
    {  if (uppercase_flag)
       { char c = *z;
         *z = ((c < 'a') || (c > 'z')) ? c : c - ('a' - 'A');
       }
       h = ((h * HASH_FAKTOR) + *z++) % TABELLENGROESSE;
    }
    return h;
}


/* *********************************************************************** */
/* yytext im Woerterbuch suchen bzw. eintragen                             */
/*                                                                         */
/* Parameter : Liste der Eintraege mit gleicher Hashnummer                 */
/* Ergebnis  : Zeiger auf den Woerterbucheintrag oder NULL                 */
/*             zu suchender String                                         */
/*                                                                         */
/* *********************************************************************** */

static WB * wb_find(wb,s)
WB * wb;
char * s;
{ while (wb)
  { if (strcmp(s,wb->name) == 0)
      return wb;
    wb = wb->next;
  }
  return NULL;
}

/* *********************************************************************** */
/* Ausgabe einer Kette von Bezeichnern (rekursiv)                          */
/*                                                                         */
/* Parameter : Woerterbuchkette                                            */
/*             Ausgabedatei                                                */
/*                                                                         */
/* *********************************************************************** * /

static wb_tree(z,fp)
WB * z;
FILE * fp;
{ if (z)
  { if (z->next)
      wb_tree(z->next,fp);
    if (z->art == IDENT)
      fprintf(fp,"%s%c",z->name,0);
  }
}
/* *********************************************************************** */
/* Woerterbuch loeschen                                                    */
/*                                                                         */
/* *********************************************************************** */

initdict()
{ int i;
  for (i = 0; i < TABELLENGROESSE; i++) wb[i]=NULL;
}

/* *********************************************************************** */
/* String im Woerterbuch suchen bzw. eintragen                             */
/*                                                                         */
/* Parameter : einzutragender String                                       */
/*             Zeiger auf die Bezeichnernummer (Ergebnis)                  */
/*             Zeiger auf die Art des Bezeichners (Ergebnis?)              */
/*                                                                         */
/* *********************************************************************** */

enterstring(s,k,c)
char * s;
long * k;
int * c;
{ int h = hash(s);
  WB * i;
  if (i = wb_find(wb[h],s))
  { *c = i->art;
  }
  else
  { GET_MEM(i,1,WB);
    i->name = strsave(s);
    i->next = wb[h];
    wb[h] = i;
    i->nr = (i->next) ? i->next->nr + 1 : 0;
    i->art = *c;
    ident_count++;
    ident_length += my_strlen(s);
  }
  *k = (long) i->nr * TABELLENGROESSE + h + 1;
}

/* *********************************************************************** */
/* Zeichenkette eines Bezeichners aus dem Woerterbuch holen                */
/*                                                                         */
/* Parameter : Nummer des Bezeichners                                      */
/* Ergebnis  : Zeiger auf den Bezeichner                                   */
/*                                                                         */
/* *********************************************************************** */

char * getstring(k)
long k;
{ int h = (--k) % TABELLENGROESSE;
  int i = k / TABELLENGROESSE;
  WB * z;
  if (wb[h] && (wb[h]->nr >= i))
  { z = wb[h];
    while (z->nr > i)
    { z = z->next; }
    return z->name;
  }
  return NULL;
}

/* *********************************************************************** */
/* Ausgabe des Woerterbuchs in eine Datei                                  */
/*                                                                         */
/* Parameter : Dateiname                                                   */
/*                                                                         */
/* *********************************************************************** */

writedict(wb_fp)
FILE * wb_fp;
{ int i;
  fprintf(wb_fp,"W\n%d %d %d %d %d\n",ident_count,ident_length,TABELLENGROESSE,
                 HASH_FAKTOR,uppercase_flag);
  for (i = 0; i < TABELLENGROESSE; i++)
  { writestrings(wb_fp,wb[i],i); }
}

writestrings(wb_fp,z,i)
FILE * wb_fp;
WB * z;
int i;
{ if (z)
  { writestrings(wb_fp,z->next,i);
    fprintf(wb_fp,"%s %ld\n",z->name,((long)z->nr) * TABELLENGROESSE + i + 1);
  }
}


