/*********************************************************
 **
 ** FILE:    direc.h
 **		defines the DirContents structure
 ** CREATED: 21 SEP 92  Claus Brenner
 ** CHANGES: 
 **
 *********************************************************/

#ifndef	direc_h
#define	direc_h

#include	<sys/param.h>

#define		DI_MAX_ENTRIES		300	/* max number of entries a ScanDir will read */
#define		DI_MAX_ENTRYSPACE	5000	/* max characters of all direntries a ScanDir will read */
#define		DI_PATHDEPTH		10	/* max number of path components that will be
						   listed in the path popup */

/** NoOfEntries is the total number of all scanned
 ** directory entries, while NoOfDirEntries is the number
 ** of directories hereof. Since the Name pointers are always
 ** ordered as `directories first', names with position >=
 ** NoOfDirEntries are automatically files 
 ** Note that pointers to the names are stored in char *Name[],
 ** while the names themselves are stored with variable length
 ** in EntryNames, one after another.
 ** There is one peculiarity: for a name with n characters,
 ** n + 2 characters are stored. One is a leading character which
 ** is ' ' for files and '/' for directories. The other is the
 ** familiar '/0' end marker. When processing the names (e.g. sorting)
 ** disregard the first character */

struct DirContents {
  char	Pathname[MAXPATHLEN];
  int	NoOfEntries, NoOfDirEntries;	/* for the following
					 ** DirEntries */
  char	*Name[DI_MAX_ENTRIES];
  char	EntryNames[DI_MAX_ENTRYSPACE];
};

#endif

